/*ForcheckIDE/MakeFileForm.cpp*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#include "MakefileForm.h"
#include "Environment.h"
#include "Project.h"

#include <QtWidgets>

MakefileForm::MakefileForm(Project *project, bool *gen, QWidget *parent) : QDialog(parent)
{
    setWindowTitle("Configure and generate makefile");
    setAttribute(Qt::WA_DeleteOnClose);
    myproject = project;
    genpon = gen;
    *genpon = false;
    formCreate();
    makefileindex = myproject->getMakeFileIndex();
    debugButton->setChecked(makefileindex == 0);
    releaseButton->setChecked(makefileindex == 1);
    formInit(makefileindex);
}

void MakefileForm::formCreate()
{
    debugButton = new QRadioButton("Debug");
    connect(debugButton, SIGNAL(clicked(bool)),
            this, SLOT(debugButtonClicked(bool)));
    releaseButton = new QRadioButton("Release");
    connect(releaseButton, SIGNAL(clicked(bool)),
            this, SLOT(releaseButtonClicked(bool)));

    QGroupBox *makefilesettingsGroupBox = new QGroupBox(tr("Makefile settings"));

    QLabel *filenamelabel = new QLabel("Makefile:");
    makefileEdit = new QLineEdit();
    makefileEdit->setFixedWidth(400);
    QPushButton *p = new QPushButton("...");
    p->setFixedWidth(25);
    connect(p, SIGNAL(clicked()), this, SLOT(selectMakefileClicked()));

    QLabel *compilerlabel = new QLabel("Fortran compiler:");
    compilerEdit = new QLineEdit();
    compilerEdit->setFixedWidth(250);

    QLabel *optionslabel = new QLabel("Fortran compiler options:");
    compilerOptionsEdit = new QLineEdit();
    compilerOptionsEdit->setFixedWidth(250);

    QLabel *ccompilerlabel = new QLabel("C compiler:");
    cCompilerEdit = new QLineEdit();
    cCompilerEdit->setFixedWidth(250);

    QLabel *coptionslabel = new QLabel("C compiler options:");
    cCompilerOptionsEdit = new QLineEdit();
    cCompilerOptionsEdit->setFixedWidth(250);

    QLabel *objdirlabel = new QLabel("Object directory:");
    objDirEdit = new QLineEdit();
    objDirEdit->setFixedWidth(250);

    QLabel *targetlabel = new QLabel("Target:");
    targetEdit = new QLineEdit();
    targetEdit->setFixedWidth(250);

    QLabel *targetdirlabel = new QLabel("Target directory:");
    targetDirEdit = new QLineEdit();
    targetDirEdit->setFixedWidth(250);

    QLabel *linkeroptionslabel = new QLabel("Linker options:");
    linkerOptionsEdit = new QLineEdit();
    linkerOptionsEdit->setFixedWidth(250);

    applyButton = new QPushButton(tr("&Save settings"));
    applyButton->setFixedWidth(140);
    genButton = new QPushButton(tr("&Generate makefile"));
    genButton->setFixedWidth(140);
    cancelButton = new QPushButton(tr("&Cancel"));
    cancelButton->setFixedWidth(140);

    connect(applyButton, SIGNAL(clicked()), this, SLOT(applyClicked()));
    connect(genButton, SIGNAL(clicked()), this, SLOT(genMakefileClicked()));
    connect(cancelButton, SIGNAL(clicked()), this, SLOT(close()));

    QHBoxLayout *selectButtonLayout = new QHBoxLayout;
    selectButtonLayout->addWidget(debugButton);
    selectButtonLayout->addWidget(releaseButton);

    QHBoxLayout *filenameLayout = new QHBoxLayout;
    filenameLayout->addWidget(filenamelabel);
    filenameLayout->addWidget(makefileEdit);
    filenameLayout->addWidget(p);

    QVBoxLayout *vbox1 = new QVBoxLayout;
    vbox1->addWidget(compilerlabel);
    vbox1->addWidget(optionslabel);
    vbox1->addWidget(ccompilerlabel);
    vbox1->addWidget(coptionslabel);
    vbox1->addWidget(objdirlabel);
    vbox1->addWidget(targetlabel);
    vbox1->addWidget(targetdirlabel);
    vbox1->addWidget(linkeroptionslabel);

    QVBoxLayout *vbox2 = new QVBoxLayout;
    vbox2->addWidget(compilerEdit);
    vbox2->addWidget(compilerOptionsEdit);
    vbox2->addWidget(cCompilerEdit);
    vbox2->addWidget(cCompilerOptionsEdit);
    vbox2->addWidget(objDirEdit);
    vbox2->addWidget(targetEdit);
    vbox2->addWidget(targetDirEdit);
    vbox2->addWidget(linkerOptionsEdit);

    QHBoxLayout *hbox = new QHBoxLayout;
    hbox->addLayout(vbox1);
    hbox->addLayout(vbox2);

    makefilesettingsGroupBox->setLayout(hbox);

    QHBoxLayout *buttonLayout = new QHBoxLayout;
    buttonLayout->addWidget(applyButton);
    buttonLayout->addWidget(genButton);
    buttonLayout->addWidget(cancelButton);

    QVBoxLayout *vboxt = new QVBoxLayout;
    vboxt->addLayout(selectButtonLayout);
    vboxt->addLayout(filenameLayout);
    vboxt->addWidget(makefilesettingsGroupBox);
    vboxt->addLayout(buttonLayout);
    this->setLayout(vboxt);
}

void MakefileForm::formInit(int makefileindex)
{
    QString filename = myproject->getMakeFilename(makefileindex);
    QString compiler = myproject->getCompiler(makefileindex);
    QString compilerOptions = myproject->getCompilerOptions(makefileindex);
    QString cCompiler = myproject->getCCompiler(makefileindex);
    QString cCompilerOptions = myproject->getCCompilerOptions(makefileindex);
    QString objDir = myproject->getObjDir(makefileindex);
    QString target = myproject->getTarget(makefileindex);
    QString targetDir = myproject->getTargetDir(makefileindex);
    QString linkerOptions = myproject->getLinkerOptions(makefileindex);

    if (filename == ""){
        QFileInfo info(myproject->getProjectFilename());
        if (makefileindex == 0){
            filename = info.baseName() + "_debug" + myEnvironment->getMakeExt();
            compilerOptions = myEnvironment->getCompilerDebugOptions();
            objDir = "debug";
        }
        else{
            filename = info.baseName() + "_release" + myEnvironment->getMakeExt();
            compilerOptions = myEnvironment->getCompilerOptions();
            objDir = "release";
        }
        compiler = myEnvironment->getCompiler();
        cCompiler = myEnvironment->getcCompiler();
        cCompilerOptions = myEnvironment->getcCompilerOptions();
        linkerOptions = myEnvironment->getLinkerOptions();
        target = info.baseName();
        targetDir = objDir;
    }
    makefileEdit->setText(filename);
    compilerEdit->setText(compiler);
    compilerOptionsEdit->setText(compilerOptions);
    cCompilerEdit->setText(cCompiler);
    cCompilerOptionsEdit->setText(cCompilerOptions);
    objDirEdit->setText(objDir);
    targetEdit->setText(target);
    targetDirEdit->setText(targetDir);
    linkerOptionsEdit->setText(linkerOptions);
}

void MakefileForm::selectMakefileClicked()
{
    QString filename = QFileDialog::getSaveFileName(this,
                                                    tr("Select makefile"),
                                                    makefileEdit->text(),
                                                    tr("Make files (*") +
                                                    myEnvironment->getMakeExt() +
                                                    ")");
    if (filename.isEmpty()) return;
    QDir cwd(myEnvironment->getWorkingDir());
    filename = cwd.relativeFilePath(filename);
    makefileEdit->setText(filename);
    makefileEdit->setText(filename);
}

void MakefileForm::applyClicked()
{
    myproject->setMakeFileIndex(makefileindex);
    myproject->setMakeFilename(makefileEdit->text());
    myproject->setCompiler(compilerEdit->text());
    myproject->setCompilerOptions(compilerOptionsEdit->text());
    myproject->setCCompiler(cCompilerEdit->text());
    myproject->setCCompilerOptions(cCompilerOptionsEdit->text());
    myproject->setObjDir(objDirEdit->text());
    myproject->setTarget(targetEdit->text());
    myproject->setTargetDir(targetDirEdit->text());
    myproject->setLinkerOptions(linkerOptionsEdit->text());
}

void MakefileForm::debugButtonClicked(bool checked)
{
    if (checked){
        makefileindex = 0;
        formInit(makefileindex);
    }
}

void MakefileForm::releaseButtonClicked(bool checked)
{
    if (checked){
        makefileindex = 1;
        formInit(makefileindex);
    }
}

void MakefileForm::genMakefileClicked()
{
    applyClicked();
    *genpon = true;
    close();
}
