/*ForcheckIDE/MainWindow.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>

QT_BEGIN_NAMESPACE
class ProjectFrame;
class FileViewer;
class IDESettingsForm;
class OptionsForm;
class PreferencesForm;
class LibrarianForm;
class NewRelease;
class FileViewer;
class QMdiArea;
class QSplitter;
class QFile;
class QIODevice;
class QAction;
class QLabel;
class QTabWidget;
class QWidget;
QT_END_NAMESPACE

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow();

protected:
    void closeEvent(QCloseEvent *event);

private:
    void createActions();
    void createMenus();
    void createToolBars();

    //Local objects
    bool pwdValid;
    NewRelease *newrelease;
    FileViewer *introView;
    FileViewer *reportView;
    FileViewer *progressView;
    FileViewer *searchView;
    IDESettingsForm *ideSettingsForm;
    ProjectFrame *projectFrame;
    OptionsForm *optionsForm;
    PreferencesForm *preferencesForm;
    LibrarianForm *librarianForm;

    QMdiArea *mdiArea;
    QToolBar *searchToolBar;
    QToolBar *replaceToolBar;
    QSplitter *rightSplitter;
    QSplitter *mainSplitter;
    QLabel *statusMessage;
    QTabWidget *tabWidget;

    //Menu objects
    QToolBar *toolBar;
    QWidget *centralWidget;

    QMenu *fileMenu;
    QMenu *editMenu;
    QMenu *projectMenu;
    QMenu *analysisMenu;
    QMenu *optionsMenu;
    QMenu *toolsMenu;
    QMenu *viewMenu;
    QMenu *windowMenu;
    QMenu *helpMenu;

    QMenu *openProjectMenu;
    QMenu *reopenProjectMenu;
    QMenu *toolsLibrarianMenu;
    QMenu *toolsLibrarianReopenMenu;
    QMenu *toolsInterfaceBuilderMenu;
    QMenu *toolsInterfaceBuilderReopenMenu;

    //File Menu:
    QAction *pageSetup;
    QAction *fileExit;
    //Options Menu:
    QAction *IDESettings;
    QAction *preferences;
    //Tools Menu:
    QAction *librarianSelectFile;
    QAction *interfaceBuilderSelectFile;
    QAction *showInstallationReport;
    //View Menu:
    QAction *showToolbar;
    //Window Menu:
    QAction *closeAct;
    QAction *closeAllAct;
    QAction *tileAct;
    QAction *cascadeAct;
    QAction *nextAct;
    QAction *previousAct;
    QAction *separatorAct;
    //Help Menu:
    QAction *helpMain;
    QAction *helpQuickStart;
    QAction *helpUsingTheIDE;
    QAction *helpTutorial;
    QAction *helpIndex;
    QAction *helpContents;
    QAction *helpGlossary;
    QAction *gotoHomepage;
    QAction *frequentlyAskedQuestions;
    QAction *registerForcheck;
    QAction *sendEmail;
    QAction *checkForUpdates;
    QAction *aboutQt;
    QAction *about;

private slots:
    void updateActions();
    void pageSetupClicked();
    void IDESettingsClicked();
    void preferencesClicked();
    void librarianClicked();
    void interfaceBuilderClicked();
    void showToolbarClicked();

    void mainHelpClicked();
    void helpQuickStartClicked();
    void helpIDEClicked();
    void helpTutorialClicked();
    void helpIndexClicked();
    void helpGlossaryClicked();
    void homepageClicked();
    void frequentlyAskedQuestionsClicked ();
    void registerClicked();
    void sendEMailClicked();
    void checkForUpdatesClicked();
    void aboutQtClicked();
    void aboutClicked();
};

#endif // MAINWINDOW_H
