/*ForcheckIDE/ListDialog.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef LISTDIALOG_H
#define LISTDIALOG_H

#include <QDialog>
#include "HelpBrowser.h"

class QPushButton;
class QCheckBox;
class QLineEdit;
class QListWidget;
class QListWidgetItem;
class QString;
class QStringList;

class ListDialog : public QDialog
{
        Q_OBJECT
public:
    enum ListType {
        ListAllNone,
        ListSymb,
        ListDir
    };
        ListDialog(QWidget *parent=0, ListType listtype = ListAllNone, HelpBrowser::HelpEntry = HelpBrowser::HelpNone);
        ~ListDialog();
        void setLists(QStringList*);
        QStringList *getLists();
private:
        QLineEdit *lineEdit;
        QListWidget *listBox;
        QPushButton *addButton;
        QPushButton *editButton;
        QPushButton *removeButton;
        QPushButton *allButton;
        QPushButton *clearButton;
        QPushButton *okButton;
        QPushButton *cancelButton;
        QPushButton *helpButton;
        QCheckBox *abspathCheckBox;

        ListType listType;
        HelpBrowser::HelpEntry helpEntry;
        void update();

public slots:
        void lineEditted(const QString&);
        void listItemSelected(QListWidgetItem*);
        void addClicked();
        void editClicked();
        void removeClicked();
        void clearClicked();
        void allClicked();
        void helpClicked();
};

#endif
