/*ForcheckIDE/LibrarianForm.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef LIBRARIANFORM_H
#define LIBRARIANFORM_H

#include <QDialog>

class QLabel;
class QListWidget;
class QPushButton;
class QStatusBar;
class QSize;
class LibrarianActions;

class LibrarianForm : public QDialog
{
        Q_OBJECT
public:
        LibrarianForm(const QString& filename, QWidget *parent=0);
        QAction *windowMenuAction() const {return action;}
        QString getFileName(){return curFileName;}
        void update();

protected:
        QSize sizeHint() const;
        void focusInEvent(QFocusEvent * event);

private:
        QLabel *filenameLabel;
        QListWidget *listWidget;
        QPushButton *removeButton;
        QPushButton *compressButton;
        QPushButton *helpButton;
        QStatusBar *statusBar;
        QString curFileName;
        QAction *action;

        LibrarianActions *librarianActions;

        void formCreate();
        void updateEnabled();

private slots:
        void itemSelectionChanged();
        void removeClicked();
        void compressClicked();
        void helpClicked();

signals:
        void InFocus();
};

#endif
