/*ForcheckIDE/LibrarianActions.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef LIBRARIANACTIONS_H
#define LIBRARIANACTIONS_H

#include <QObject>

class QString;
class QFile;
class QStringList;

#define ISBRCL 76
#define MXVERL  8
#define MXSYMC 28
#define MXSYML 64

#define REC_INDEX 'X'
#define REC_NAME_CONT 'n'

#define LIB_ERR_OK        0
#define LIB_ERR_OPEN     -1
#define LIB_ERR_CREATE   -2
#define LIB_ERR_READ     -3
#define LIB_ERR_WRITE    -4
#define LIB_ERR_FCK      -5
#define LIB_ERR_VERSION  -6
#define LIB_ERR_CONSIST  -7
#define LIB_ERR_FOUND    -8
#define LIB_ERR_DELOLD   -9
#define LIB_ERR_DELETE   -10
#define LIB_ERR_MOVE     -11
#define LIB_ERR_NOT_EXISTS     -12

class LibrarianActions : QObject
{
        Q_OBJECT
public:
        LibrarianActions(const QString& filename);
        ~LibrarianActions();

        int open(const bool readwrite=false);
        void close();
        int makeList(QStringList& list);
        int remove(const QString& name);
        int compress();

        void showErrorMsg();

private:
        void cleanup(QFile *newlibfile);
        int cmpr1(QFile *newlibfile);
        int cmpr2(QFile *newlibfile);
        int copsub(QFile *newlibfile, int sbrc);
        int readHeaderRecord(QFile *file);
        int writeHeaderRecord(QFile *file);
        int fill(QFile *newlibfile, int fromrec, int torec);

        QFile *libfile;

        char Lbvers[MXVERL];
        char Fckvers[MXVERL];
        int Credatetime[6], Updatetime[6];
        int LbSeq;
        int StIrc, LstIrc, EndIrc, NumIrc, Lsbrc;
        int last_status;
};

#endif
