/*ForcheckIDE/LibListDialog.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef LIBLISTDIALOG_H
#define LIBLISTDIALOG_H

#include <QDialog>

class QLabel;
class QListWidget;
class QPushButton;
class QStringList;
class QListWidgetItem;

class LibListDialog : public QDialog
{
        Q_OBJECT
public:
        LibListDialog(QWidget *parent=0);
        ~LibListDialog();
        void setLists(const QString& filename, QStringList*);
        QStringList *getLists();
private:
        QLabel *header1;
        QLabel *header2;
        QListWidget *listBox1;
        QListWidget *listBox2;
        QPushButton *includeButton;
        QPushButton *includeAllButton;
        QPushButton *excludeButton;
        QPushButton *excludeAllButton;
        QPushButton *okButton;
        QPushButton *cancelButton;
        QPushButton *helpButton;

        void update();

public slots:
        void listItemSelected1(QListWidgetItem*);
        void listItemSelected2(QListWidgetItem*);
        void includeClicked();
        void includeAllClicked();
        void excludeClicked();
        void excludeAllClicked();
};

#endif
