/*ForcheckIDE/IniFile.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef INIFILE_H
#define INIFILE_H

#include <QFile>
#include <QTextStream>
#include <QString>
#include <QStringList>
#include <QVariant>
#include <QStringList>

class IniFile {
public:
        IniFile(const QString& filename);
        ~IniFile();
        bool create();
        bool exists();
        bool isEmpty();
        bool open();
        bool close();
        bool beginGroup(const QString& group);
        void endGroup();
        QStringList childGroups();
        bool contains(const QString& key);
        void setValue(const QString& key, const int& value);
        void setValue(const QString& key, const QString& value);
        QVariant value(const QString& key, const QVariant& defaultValue = QVariant());

private:
        QFile file;
        QTextStream stream;
        QStringList content;
        bool empty;
        bool writing;
        int startIndex;
        int endIndex;

        int locate(const QString& templ);
};

#endif
