/*ForcheckIDE/IDESettingsForm.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef IDESETTINGSFORM_H
#define IDESETTINGSFORM_H

#include <QDialog>

class QPushButton;
class QCheckBox;

class IDESettingsForm : public QDialog
{
        Q_OBJECT
public:
        IDESettingsForm(QWidget *parent=0);
        ~IDESettingsForm();
private:
        QCheckBox *verProjectFilesCheck;
        QCheckBox *verIncludeDepCheck;
        QCheckBox *autosaveFilesSearchCheck;
        QCheckBox *autosaveFilesAnalysisCheck;
        QCheckBox *autosaveFilesMakeCheck;
        QCheckBox *autosaveProjectCheck;

        QPushButton *helpButton;
        QPushButton *okButton;
        QPushButton *applyButton;
        QPushButton *cancelButton;

        void initialize();
        void applyChanges();

public slots:
        void helpClicked();
        void okClicked();
        void applyClicked();
    };

#endif
