/*ForcheckIDE/IDESettingsForm.cpp*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#include "IDESettingsForm.h"
#include "Environment.h"
#include "HelpBrowser.h"

#include <QtWidgets>

IDESettingsForm::IDESettingsForm(QWidget *parent) : QDialog(parent)
{
    setAttribute(Qt::WA_DeleteOnClose);
    setWindowTitle("IDE settings");

    verProjectFilesCheck = new QCheckBox("Verify project files at open project");
    verIncludeDepCheck = new QCheckBox("Verify include file dependencies at open project");
    autosaveFilesSearchCheck = new QCheckBox("Save open files at global search/replace without asking");
    autosaveFilesAnalysisCheck = new QCheckBox("Save open files at program analysis without asking");
    autosaveFilesMakeCheck = new QCheckBox("Save open files at Make without asking");
    autosaveProjectCheck = new QCheckBox("Save project at close project without asking");
    helpButton = new QPushButton(tr("&Help"));
    helpButton->setToolTip(tr("Present the relevant page of the user guide"));
    helpButton->setFixedWidth(80);
    helpButton->setShortcut(QKeySequence::HelpContents);
    okButton = new QPushButton(tr("&OK"));
    okButton->setToolTip(tr("Accept the specified settings and close the window"));
    okButton->setFixedWidth(80);
    applyButton = new QPushButton(tr("&Apply"));
    applyButton->setToolTip(tr("Accept the specified settings"));
    applyButton->setFixedWidth(80);
    cancelButton = new QPushButton(tr("&Cancel"));
    cancelButton->setToolTip(tr("Cancel the specified settings and close the window"));
    cancelButton->setFixedWidth(80);

    QHBoxLayout *buttonLayout = new QHBoxLayout;
    buttonLayout->addWidget(helpButton);
    buttonLayout->addWidget(okButton);
    buttonLayout->addWidget(applyButton);
    buttonLayout->addWidget(cancelButton);

    QVBoxLayout *mainLayout = new QVBoxLayout;
    mainLayout->addWidget(verProjectFilesCheck);
    mainLayout->addWidget(verIncludeDepCheck);
    mainLayout->addWidget(autosaveFilesSearchCheck);
    mainLayout->addWidget(autosaveFilesAnalysisCheck);
    mainLayout->addWidget(autosaveFilesMakeCheck);
    mainLayout->addWidget(autosaveProjectCheck);
    mainLayout->addStretch();
    mainLayout->addLayout(buttonLayout);
    setLayout(mainLayout);

    connect(helpButton, SIGNAL(clicked()), this, SLOT(helpClicked()));
    connect(okButton, SIGNAL(clicked()), this, SLOT(okClicked()));
    connect(applyButton, SIGNAL(clicked()), this, SLOT(applyClicked()));
    connect(cancelButton, SIGNAL(clicked()), this, SLOT(close()));

    initialize();
}

IDESettingsForm::~IDESettingsForm()
{
    delete helpButton;
    delete okButton;
    delete applyButton;
    delete cancelButton;
}

void IDESettingsForm::initialize()
{
    verProjectFilesCheck->setChecked(myEnvironment->getVerProjectFiles());
    verIncludeDepCheck->setChecked(myEnvironment->getVerIncludeDep());
    autosaveFilesSearchCheck->setChecked(myEnvironment->getAutosaveFilesSearch());
    autosaveFilesAnalysisCheck->setChecked(myEnvironment->getAutosaveFilesAnalysis());
    autosaveFilesMakeCheck->setChecked(myEnvironment->getAutosaveFilesMake());
    autosaveProjectCheck->setChecked(myEnvironment->getAutosaveProject());
}

void IDESettingsForm::applyChanges()
{
    myEnvironment->setVerProjectFiles(verProjectFilesCheck->isChecked());
    myEnvironment->setVerIncludeDep(verIncludeDepCheck->isChecked());
    myEnvironment->setAutosaveFilesSearch(autosaveFilesSearchCheck->isChecked());
    myEnvironment->setAutosaveFilesAnalysis(autosaveFilesAnalysisCheck->isChecked());
    myEnvironment->setAutosaveFilesMake(autosaveFilesMakeCheck->isChecked());
    myEnvironment->setAutosaveProject(autosaveProjectCheck->isChecked());
    myEnvironment->saveIdeSettings();
}

void IDESettingsForm::okClicked()
{
    applyChanges();
    close();
}

void IDESettingsForm::applyClicked()
{
    applyChanges();
}

void IDESettingsForm::helpClicked()
{
    HelpBrowser::HelpEntry helpentry;
    helpentry = HelpBrowser::HelpIDESettings;
    myEnvironment->helpBrowser->showHelp(helpentry);
}
