/*ForcheckIDE/Highlighter.cpp*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/
#include <QtWidgets>

#include "Highlighter.h"

Highlighter::Highlighter(QTextDocument *parent, bool isFFfile) : QSyntaxHighlighter(parent)
{
    isff = isFFfile;
    singleLineCommentFormat.setForeground(Qt::darkGreen);

    rule1.pattern = QRegExp("![^\n]*");
    rule1.format = singleLineCommentFormat;
    if (!isff) {
        rule2.pattern = QRegExp("C[^\n]*");
        rule2.format = singleLineCommentFormat;
        rule3.pattern = QRegExp("c[^\n]*");
        rule3.format = singleLineCommentFormat;
    }
}

void Highlighter::highlightBlock(const QString &text)
{
    QRegExp expression;
    int index;

    expression = rule1.pattern;
    index = expression.indexIn(text);
    if (index >= 0) {
        int length = expression.matchedLength();
        setFormat(index, length, rule1.format);
    }
    if (!isff) {
        expression = rule2.pattern;
        index = expression.indexIn(text);
        if (index == 0) {
            int length = expression.matchedLength();
            setFormat(index, length, rule2.format);
        }
        expression = rule3.pattern;
        index = expression.indexIn(text);
        if (index == 0) {
            int length = expression.matchedLength();
            setFormat(index, length, rule3.format);
        }
    }
}
