/*ForcheckIDE/HelpBrowser.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef HELPBROWSER_H
#define HELPBROWSER_H

#include "PdfWidget.h"

#include <QWidget>
#include <QString>
#include <QFile>

class PdfTocTree;
class QSpinBox;
class QLineEdit;
class QComboBox;
class QScrollArea;
class QMouseEvent;
class QSettings;
class QSplitter;
class QAction;

class HelpBrowser : public QWidget
{
      Q_OBJECT

public:
        enum HelpEntry {
                HelpNone,
                HelpMain,
                HelpUsingTheIDE,
                HelpTutorial,
                HelpIndex,
                HelpGlossary,

                HelpIDESettings,


                HelpLineOrStatementNumbering,
                HelpDirectories,
                HelpRedefinitionAndSuppressionOfMessages,
                HelpMessageFormat,
                HelpMessageSummary,
                HelpDateFormat,
                HelpDefaultFileExtensions,
                HelpCompilersSupported,
                HelpEditor,
                HelpBuild,
                HelpTheUsageOfIncludeFiles,

                HelpOptions,
                HelpProgramUnitAnalysisOptions,
                HelpGlobalAnalysisOptions,
                HelpListingOptions,
                HelpLibraryOptions,
                HelpMiscellaneousOptions,

                HelpUsingForcheckLibrariesInTheIDE,
                HelpMaintainingLibraryFilesFromTheIDE,
                HelpReferenceStructure,
                HelpReferenceStructureInXmlFormat,
                HelpModDep,
                HelpModDepInXmlFormat
        };

             //functies
             HelpBrowser(const QString& filename, QWidget *parent = 0);
             void save(QSettings &settings);
             void restore(QSettings &settings);
             bool helpAvailable();
             void showHelp(const HelpEntry entry);
             void showHelp(const QString& keyname);
             void keyPressEvent(QKeyEvent *event);

private:
             //functies
             void formCreate();
             bool load();
             int getKey(const HelpEntry entry);
             int findDestination(const QString& key);

             //variabelen
             QFile *helpFile;
             bool loaded;
             typedef struct {
                 HelpBrowser::HelpEntry key;
                 const char *keyName;
             } HelpEntryKey;
             static const HelpEntryKey helpEntryKeyList[];
             static const int helpEntryKeyListSize;
             PdfWidget *pdfWidget;
             PdfTocTree *pdfTocTree;
             QSplitter *splitter;
             QSpinBox *pageSpinBox;
             QLineEdit *searchLineEdit;
             QScrollArea *tocArea;
             QScrollArea *scrollArea;
             QVector<qreal> scaleFactors;
             QAction *previousPage;
             QAction *nextPage;
             QAction *firstPage;
             QAction *lastPage;
             QAction *findPrevious;
             QAction *findNext;

public slots:
             void tocDoubleClicked(QString& itemtext);

private slots:
             void scaleDocument(int index);
             void findPreviousClicked();
             void findNextClicked();
};

#endif
