/*ForcheckIDE/FileViewer.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef FILEVIEWER_H
#define FILEVIEWER_H

#include <QPlainTextEdit>

class QMainWindow;
class QAction;
class QString;
class QSize;
class QMouseEvent;

class FileViewer : public QPlainTextEdit
{
    Q_OBJECT

public:
    FileViewer(QMainWindow *parent = 0, bool small = false);
    QAction *windowMenuAction() const {return showAction;}
    QString getFileName(){return curFileName;}
    QSize sizeHint() const;
    void clear();
    bool loadFile(const QString& file);
    void putText(const QString& text);
    void appendText(const QString& text);
    bool saveFile();

private:
    QMainWindow *myparent;
    bool mysmall;
    void create();
    void mouseDoubleClickEvent(QMouseEvent *event );
    void parseLine(const QString& line, QString& filename, int& linnum);
    void highlightCurrentLine();

    QString curFileName;
    QAction *showAction;

protected:
    void focusInEvent(QFocusEvent * event);
    void focusOutEvent(QFocusEvent * event);

signals:
    void requestEdit(const QString&, int);
    void InFocus();
    void OutFocus();
};

#endif

