/*ForcheckIDE/FileKinds.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef FILEKIND_H
#define FILEKIND_H

#include "Options.h"

#include <QString>
#include <set>

using namespace std;

class FileKind
{
public:
        enum ETFileKind {
                Unknown = -3,
                None = -2,
                Any = -1,
                First = 0,
                Project=First,
                Make,
                PreSource,
                Source,
                CSource,
                Include,
                LibOutput,
                LibRef,
                Listing,
                ReferenceStructure,
                ModDep,
                Report,
                Count
        };

        static bool isEditable(const ETFileKind kind) {
            return  (kind == PreSource ||
                     kind == Source ||
                     kind == CSource ||
                     kind == Include ||
                     kind == Unknown);
        }
        static bool isHighlightable(const ETFileKind kind) {
            return  (kind == PreSource ||
                     kind == Source ||
                     kind == Include);
        }
        static bool isViewable(const ETFileKind kind) {
            return  (kind == LibOutput ||
                     kind == LibRef ||
                     kind == Listing ||
                     kind == ReferenceStructure ||
                     kind == ModDep ||
                     kind == Report);
        }
        static bool isPrintable(const ETFileKind kind) {
            return  (kind == PreSource ||
                     kind == Source ||
                     kind == CSource ||
                     kind == Include ||
                     kind == Listing ||
                     kind == Report ||
                     kind == Unknown);
        }
        static bool isLibrary(const ETFileKind kind) {
            return  (kind == LibOutput ||
                     kind == LibRef);
        }
        static bool isMultipleSelectableFiles(const ETFileKind kind) {
            return  (kind == PreSource ||
                     kind == Source ||
                     kind == CSource ||
                     kind == Include ||
                     kind == LibRef);
        }
        static bool isOutputFile(const ETFileKind kind) {
            return  (kind == LibOutput ||
                     kind == Listing ||
                     kind == ReferenceStructure ||
                     kind == ModDep ||
                     kind == Report);
        }
        static bool isIncludable(const ETFileKind kind) {
            return  (kind == PreSource ||
                     kind == Source ||
                     kind == LibRef ||
                     kind == Listing ||
                     kind == ReferenceStructure ||
                     kind == ModDep ||
                     kind == Report);
        }
        static bool canBeAnalysed(const ETFileKind kind) {
            return  (kind == PreSource ||
                     kind == Source ||
                     kind == LibRef);
        }
        static bool canHaveFileOptions(const ETFileKind kind) {
            return  (kind == PreSource ||
                     kind == Source ||
                     kind == LibRef);
        }
        static bool canBeInProject(const ETFileKind filekind);

        static QString fileKind2String(const ETFileKind filekind);
        static ETFileKind string2FileKind(const QString filekindstring);
        static ETFileKind int2FileKind(const int filekindint);
        static ETFileKind ext2FileKind(const QString& fileext);
        static OptionsKind::ETOptionsKind getOptionKind(const ETFileKind filekind);
        static QString getIcon(const ETFileKind kind);

        static QString fileDir(const QString& filename);
        static QString fileExt(const QString& filename);
        static bool isFppFile(const QString& filename);
        static bool isDefaultFfFile(const QString& filename);
    };

#define ForEachProjectFileKind(fk) \
        for (FileKind::ETFileKind fk = FileKind::Source; fk != FileKind::Unknown; fk = FileKind::int2FileKind(fk+1))

#endif
