/*ForcheckIDE/FileExistsValidator.cpp*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#include "FileExistsValidator.h"
#include "Info.h"

#include <QtWidgets>
#include <QFile>

FileExistsValidator::FileExistsValidator(QObject *parent) :
    QValidator(parent)
{
}

QValidator::State FileExistsValidator::validate (QString& input, int& pos ) const
{
    QFile file(input);
    if (file.exists())
        return QValidator::Acceptable;
    else {
        QMessageBox::warning(0, Info::TITLE,
                             input + tr("\nFile does not exists"),
                             QMessageBox::Ok);
        return QValidator::Invalid;
    }

}
