/*ForcheckIDE/Constants.cpp*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#include "Constants.h"
#include <QDir>

// Default editor
#if defined(Q_OS_WIN)
//  const QString Constants::DefaultEditorFileName = "notepad";
  const QString Constants::DefaultEditorFileName = QString();
#elif defined(Q_OS_LINUX)
//  const QString Constants::DefaultEditorFileName = "vi";
  const QString Constants::DefaultEditorFileName = QString();
#endif
//const QString Constants::DefaultEditorCommandLine = "%f";
const QString Constants::DefaultEditorCommandLine = QString();

// Default build data
const QString Constants::DefaultCompiler = "gfortran";
const QString Constants::DefaultCompilerOptions = "-c -fbacktrace";
const QString Constants::DefaultCompilerDebugOptions = "-c -fbacktrace -fcheck=all";
const QString Constants::DefaultcCompiler = "gcc";
const QString Constants::DefaultcCompilerOptions = "-c";
const QString Constants::DefaultLinkerOptions = "-static";
#if defined(Q_OS_WIN)
  const QString Constants::DefaultBuildUtility = "";
#elif defined(Q_OS_LINUX)
  const QString Constants::DefaultBuildUtility = "make";
#endif

// Default filename extensions
const QString Constants::DefaultExt_Project = ".fcp";
const QString Constants::DefaultExt_Make = ".mak";
#if defined(Q_OS_WIN)
  const QString Constants::DefaultExt_Source = ".for";
  const QString Constants::DefaultExt_PreSource = ".fpp";
  const QString Constants::DefaultExt_Bin = ".exe";
#elif defined(Q_OS_LINUX)
  const QString Constants::DefaultExt_Source = ".f";
  const QString Constants::DefaultExt_PreSource = ".F";
  const QString Constants::DefaultExt_Bin = "";
#endif
const QString Constants::DefaultExt_CSource = ".c";
const QString Constants::DefaultExt_Include = ".inc";
const QString Constants::DefaultExt_Library = ".flb";
const QString Constants::DefaultExt_Listing = ".lst";
const QString Constants::DefaultExt_Report = ".rep";
const QString Constants::DefaultExt_Refstruct = ".xml";
const QString Constants::DefaultExt_ModDep = ".xml";

// Appended to forcheck shared data directory in Environment.cpp
#if defined(Q_OS_WIN)
  const QString Constants::DefaultEmulationFilename = "intel15.cnf";
  const QString Constants::HelpFilename = "win_ide.pdf";
#elif defined(Q_OS_LINUX)
  const QString Constants::DefaultEmulationFilename = "gfortran.cnf";
  const QString Constants::HelpFilename = "unix_ide.pdf";
#endif

const QString Constants::FckConfigurationFilename = "forchk.cnf";
const QString Constants::IDEConfigurationFilename = "forchk.cfg";
const QString Constants::DefaultOptionsFilename = "forchk.dfo";
#if defined(Q_OS_WIN)
  const QString Constants::FckExecutable = "forchk.exe";
  const QString Constants::InterfExecutable = "interf.exe";
#elif defined(Q_OS_LINUX)
  const QString Constants::FckExecutable = "forchk";
  const QString Constants::InterfExecutable = "interf";
#endif
const QString Constants::InstallationReport = "InstallationReport.txt";

const QString Constants::FckPwdFilename = "fckpwd.pwd";
const QString Constants::FckMsgFilename = "fckerr.msg";
const QString Constants::DepFilename = "fck.dep";
const QString Constants::DefaultReportFilename = "fck.rep";
const QString Constants::CommandFilename = "fck.cmd";

