/*ForcheckIDE/CodeEditor.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/
#ifndef CODEEDITOR_H
#define CODEEDITOR_H

#include <QPlainTextEdit>

class QPaintEvent;
class QResizeEvent;
class QSize;
class QWidget;
class QString;
class QMainWindow;

class LineNumberArea;


class CodeEditor : public QPlainTextEdit
{
    Q_OBJECT

public:
    CodeEditor(QMainWindow *parent = 0);
    QAction *windowMenuAction() const {return action;}
    QString getFileName(){return curFileName;}
    bool isOkToContinue();
    bool loadFile(const QString& filename);
    bool closeFile();
    bool saveFile();
    QString newFileName();
    void gotoLine(int linnum);

    QSize sizeHint() const;
    void lineNumberAreaPaintEvent(QPaintEvent *event);
    void lineNumberAreaPressEvent(QMouseEvent *event);
    int lineNumberAreaWidth();

protected:
    void resizeEvent(QResizeEvent *event);
    void closeEvent(QCloseEvent *event);
    void focusOutEvent(QFocusEvent * event);
    void focusInEvent(QFocusEvent * event);

private:
    bool isUntitled;
    QMainWindow *myparent;
    QWidget *lineNumberArea;
    QString curFileName;
    QAction *action;
    void setCurrentFileName(const QString &fileName);

private slots:
    void documentWasModified();
    void highlightCurrentLine();
    void updateLineNumberAreaWidth(int newBlockCount);
    void updateLineNumberArea(const QRect &, int);

signals:
    void fileSaved(const QString &);
    void closed();
    void InFocus();
    void OutFocus();
};


class LineNumberArea : public QWidget
{
public:
    LineNumberArea(CodeEditor *editor) : QWidget(editor) {
        codeEditor = editor;
    }

    QSize sizeHint() const {
        return QSize(codeEditor->lineNumberAreaWidth(), 0);
    }

protected:
    void paintEvent(QPaintEvent *event) {
        codeEditor->lineNumberAreaPaintEvent(event);
    }
    void mousePressEvent(QMouseEvent *event) {
        codeEditor->lineNumberAreaPressEvent(event);
    }

private:
    CodeEditor *codeEditor;
};

#endif // CODEEDITOR_H
