/*ForcheckIDE/CnfOptions.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef CNFOPTIONS_H
#define CNFOPTIONS_H

#define NR_COUNT_MODE_OPTIONS 6
#define NR_OUTPUT_OPTIONS 9
//LERM = 72 - 2
#define LERM 70

#include <QObject>
#include <QString>

class QFile;

class CnfOptions : public QObject
{
    Q_OBJECT

public:
        CnfOptions(const QString &fckcnffile, const QString &fckerrmsgfile);
        ~CnfOptions();

        void writeToFile();

        bool getSuppressAll() { return suppressAll; }
        void setSuppressAll(bool b) { suppressAll = b; }

        QString getMaxMsg() { return maxMsg; }
        void setMaxMsg(QString m) { maxMsg = m; }
        bool getPrintSourceStm() { return printSourceStm; }
        void setPrintSourceStm(bool b) { printSourceStm = b; }
        bool getPrintLinStmNum() { return printLinStmNum; }
        void setPrintLinStmNum(bool b) { printLinStmNum = b; }

        bool getCountModeOption(int i) { return count_mode_options[i]; }
        void setCountModeOption(int i, bool b) { count_mode_options[i] = b; }

        bool getOutputOption(int i) { return output_options[i]; }
        void setOutputOption(int i, bool b) { output_options[i] = b; }

        QString getFileLineFormat() { return fileLineFmt; }
        void setFileLineFormat(const QString &newFormat) { fileLineFmt = newFormat; }
        QString getDateFormat() { return fckDateFormat; }
        void setDateFormat(const QString &newFormat) { fckDateFormat = newFormat; }
        QString getTimeFormat() { return fckTimeFormat; }
        void setTimeFormat(const QString &newFormat) { fckTimeFormat = newFormat; }
        void setChanged(bool change=true) { changed = change; }

        typedef struct {
                char Level;
                char Dummy;
                char Message[LERM];
        } MSG_STRUCT;
        MSG_STRUCT *msgs;
        int numMsg;
        static const char levelFlags[];
        int *newLevel;

private:
        void init();
        void readMsgFile(const QString &msgfilename);
        void readFromFile();

        bool suppressAll;
        QString maxMsg;
        bool printSourceStm;
        bool printLinStmNum;
        QString fileLineFmt;
        bool count_mode_options[NR_COUNT_MODE_OPTIONS];
        bool output_options[NR_OUTPUT_OPTIONS];
        bool changed;
        QString fckDateFormat;
        QString fckTimeFormat;
        QFile *cnffile;
};

#endif
