<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" omit-xml-declaration="yes"/>
<xsl:template match="/">
<HTML>
<HEAD>
<title>Forcheck call-tree browser</title>
<STYLE>
    BODY {font:x-small 'Verdana'; margin-right:1.5em}
  <!-- container for expanding/collapsing content -->
    .c  {cursor:hand}
  <!-- button - contains +/-/nbsp -->
    .b  {color:red; font-family:'Courier New'; font-weight:bold; text-decoration:none}
    .bfix  {color:red; font-family:'Courier New'; font-weight:bold; text-decoration:none}
  <!-- element container -->
    .e  {margin-left:2em; text-indent:-1em; margin-right:1em}
  <!-- comment or cdata -->
    .k  {margin-left:1em; text-indent:-1em; margin-right:1em}
  <!-- tag -->

    .t  {color:#990000}
  <!-- tag in xsl namespace -->
    .xt {color:#990099}
  <!-- attribute in xml or xmlns namespace -->
    .ns {color:red}
  <!-- attribute in dt namespace -->
    .dt {color:green}
  <!-- markup characters -->
    .m  {color:blue}
  <!-- text node -->
    .tx {font-weight:bold}
</STYLE>
<SCRIPT language="javascript">
<xsl:text><![CDATA[
var ihigh = 0;				//count number of nodes displayed
var highe = new Array();	//array of found nodes as result of search with color red
var norme = new Array();	//array of nodes with the original colors
var casesensitive=false;

function substit(s,sfrm,sto,nn) // substitute sfrm in s by sto, at most nn times (nn==-1 = inf). Better use replace in Netscape4.*
{
	var ii, sout="", l=sfrm.length;
	if(!s) return(s);
	ii=s.indexOf(sfrm);
	while((ii>-1)&&(nn!=0))
	{	nn=nn-1;
		sout+=s.substring(0,ii);
		sout+=sto;
		s=s.substring(ii+l,s.length);
		ii=s.indexOf(sfrm);
	}
	sout+=s;
  return sout;
}

// Change the +/- symbol and hide the children.  This function works on "element" displays
function ch(e,force)
{
	if(e) if(e.children[0]) if(e.children[0].children[0])
	{	// find the +/- symbol
		mark = e.children[0].children[0];
		e=e.children[0];
          
        if (mark.className)if (mark.className=='b')
		{	// if it is already collapsed, expand it by showing the children
			 if ( ( force == 1 ) || ( (force == 0 ) && (mark.innerHTML == "+")))
     		 {	mark.innerHTML = "-";
          	  	for (var i = 0; i < e.children.length; i++)
					if(e.children[i].className) if(e.children[i].className=='e')
						e.children[i].style.display = "block";
     	     }
			// if it is expanded, collapse it by hiding the children
			else if ( ( force == -1 ) || ( (force == 0 ) && (mark.innerHTML == "-")))
			{	mark.innerHTML = "+";
				for (var i = 0; i < e.children.length; i++)
					if(e.children[i].className)
						if(e.children[i].className=='e')
							e.children[i].style.display="none";
			}
		}
	}
}
        
// Handle a mouse click
function cl(e)
{
	if (!e) var	e = window.event;				//for IE
	if (e.target) e = e.target;					//for FireFox
	else if (e.srcElement) e = e.srcElement;	//for IE
	// make sure we are handling clicks upon expandable container elements
	if (e.className)
	{
		if (e.className == "b")
		{
			if (e.className != "c")
			{
				e = e.parentNode;
				if (e.className != "c") return;
			}
			e = e.parentNode;
            // call the correct funtion to change the collapse/expand state and display
			if (e.className == "e")
				ch(e,0);			//0 indicaes click on plus or minus
		}
	}
}

// Dummy function for expand/collapse link navigation - trap onclick events instead
function ex() 
{}

//expand ancestors of found nodes.
function chancestors(ee)
{
	if(ee) // parent of top element is null
	{
		if (ee.className == "e") ch(ee,1);
		chancestors(ee.parentElement);		//recursief
	}
}

function choffspring(ee,force)
{
	if(ee){
		if(ee.children){
			for (var i =0; i < ee.children.length; i++)
				if(ee.children[i]){
					if (ee.children[i].className == "e")
						ch(ee.children[i],force);
					choffspring(ee.children[i],force);			//recursief
				}
		}
	}
}

function compstr(a,b)
{
	if (casesensitive)
		return a.indexOf(b);
	else
		return a.toLowerCase().indexOf(b.toLowerCase());
}

function deepestleveltxt(ee,stxt)
{
	if(compstr(ee.innerHTML,stxt) >0 ) 		//look if ee contains the string
	{
		if(ee.children)
		{
			for (var i =0; i < ee.children.length; i++) if(ee.children[i])
			{
				if(compstr(ee.children[i].innerHTML,stxt) > 0)		//is there a lower level?
				{
					return false;		// yes
				}
			}
		}
		return true;		//no
	}
	return false;		//no substring? return false
}

function diffcolor(ee)
{
	norme[ihigh]=ee.style.color; highe[ihigh]=ee; ihigh++;	//save original style color
	for (var i = 2; i < ee.children.length; i++)		//start with i=2 because plus is a child
	{
		if(ee.children[i].children) diffcolor(ee.children[i]);
		ee.children[i].style.color="black";
	}
}

function dispstring(e,stxt) // display objects and their ancestors which contain string stxt;object has e as ancestor
{
  	nfnd=0;
	for (var i = 0; i < e.children.length; i++)	if(e.children[i])
	{
		ee=e.children[i];
		if(deepestleveltxt(ee,stxt)) 	//diepste level gevonden
		{
			chancestors(ee.parentNode.parentNode.parentNode);
	//		ch(ee.parentElement.parentElement,-1);
			if (ee.children)
				{diffcolor(ee);ee.style.color="red";} 
			else 
			{
				norme[ihigh]=ee.style.color; highe[ihigh]=ee; ihigh++;   	//save old style colour
				ee.style.color="red";
			}
			nfnd++;
		}
		nfnd=nfnd+dispstring(e.children[i],stxt);		//something found?
   }
   return nfnd;
}

function dofind()
{ 	
	txt=document.fndform.txt.value; 
	casesensitive=document.fndform.casesen.checked;
	txt=substit(txt,"  "," ",-1); txt=substit(txt,"  "," ",-1);
	if(txt!="")
	{
		for(var i = 0; i < ihigh; i++) highe[i].style.color=norme[i];
		ihigh=0; //reset ihigh weer tot nul
		if(dispstring(document.body,txt)==0)
			alert("Forcheck call-tree browser couldn't find string: "+txt);
	}
}

function buttonclick(x)
{
	if (x != 4) window.status = "Working...";
	if ((x == 1) || (x==0)) choffspring(document.body,-1);  //collapse
	if ( x == 2 ) choffspring(document.body,1); //expand
	if ( x == 3 ) dofind();
	if ( x == 4 ) help();
	window.status = "Ready";
}

function help()
{
	alert("The Forcheck call-tree browser searches the reference tree, and expands the found node.\n\n-The search is case-insensitive by default.\n-Partial word matches are also displayed.\n-No wildcards or boolean searches are supported.\n-The search may take some time...");
}

// Set the onclick handler
document.onclick = cl;
window.defaultStatus = "Ready";

    ]]></xsl:text>
</SCRIPT>
</HEAD>
<BODY onLoad = "buttonclick(0)" class="st">
	<form action="javascript:dofind()" name="fndform">
		<p><b>Forcheck call-tree browser</b></p>
		<input type="text" name="txt"/>
		<input type="button" onclick="buttonclick(3)" value="Search" style="font-weight:bold; color:#FFF; background-color:#036; border-style:outset; border-color:#69F;"/>
		<input type="button" onclick="buttonclick(1)" value="Collapse All" style="font-weight:bold;  color:#FFF; background-color:#036; border-style:outset; border-color:#69F;"/>
		<input type="button" onclick="buttonclick(2)" value="Expand All" style="font-weight:bold; color:#FFF; background-color:#036; border-style:outset; border-color:#69F;"/>
		<input type="button" onclick="buttonclick(4)" value="Help" style="font-weight:bold; color:#FFF; background-color:#036; border-style:outset; border-color:#69F;"/><BR/>  
		<input type="checkbox" name="casesen" /><small>case sensitive</small>
	</form>
	<xsl:apply-templates />
</BODY>
</HTML>
</xsl:template>

<!-- Note the following templates for elements may examine children.  This harms to some extent
  the ability to process a document asynchronously - we can't process an element until we have
  read and examined at least some of its children.  Specifically, the first element child must
  be read before any template can be chosen.  And any element that does not have element
  children must be read completely before the correct template can be chosen. This seems 
  an acceptable performance loss in the light of the formatting possibilities available 
  when examining children. -->
	
    <xsl:template match="@*">
    <xsl:value-of select="."/>
    </xsl:template> 

	<xsl:template match="comment">
		<DIV class="e">	
			<SPAN class="c" STYLE="margin-left:1em;text-indent:-2em">
				<xsl:apply-templates/>
			</SPAN>
		</DIV>
	</xsl:template>
	<!-- Template for elements with element children -->
	<xsl:template match="*">
		
				<xsl:apply-templates/>
		
	</xsl:template>
	<!-- Template for elements not handled elsewhere (leaf nodes) -->
<!--	<xsl:template match="textNode()">
		<DIV STYLE="margin-left:1em;text-indent:-1em">
			<xsl:value-of />
		</DIV>
	</xsl:template>   -->
	<!-- Template for elements with element children -->
	<xsl:template match="SUB">
		<DIV class="e">	
			<SPAN class="c" STYLE="margin-left:3em;text-indent:-1em">
				<A href="#" onclick="return false" onfocus="h()" class="bfix">-</A>
				<xsl:apply-templates/>
			</SPAN>
		</DIV>
	</xsl:template>
<!-- Template for elements with element grand children -->
	<xsl:template match="SUB[SUB]">
		<DIV class="e">	
			<SPAN class="c" STYLE="margin-left:3em;text-indent:-1em">
				<A href="#" onclick="return false" onfocus="h()" class="b">-</A>
				<xsl:apply-templates/>
			</SPAN>
		</DIV>
	</xsl:template>

	<xsl:template match="a">
		<xsl:element name="A">
		   <xsl:apply-templates select="@subref"/>
   
                   <xsl:apply-templates select="@subid"/>	
                  
                   <xsl:value-of select="." />
		</xsl:element>
	</xsl:template>

	<xsl:template match="@subid">
        <a><xsl:attribute name="name"><xsl:value-of select="."/></xsl:attribute></a>   
	</xsl:template>

	<xsl:template match="SUB[@subref]">
        <xsl:param name="dummy" select="@subref"/>
        <xsl:apply-templates select="//*[@subid=$dummy]"></xsl:apply-templates>
	</xsl:template>

</xsl:stylesheet>