/***********************************************************************/
/* FLOPPY exec                                                         */
/*                                                                     */
/* JJB May 1987                                                        */
/***********************************************************************/
address 'COMMAND'
signal on novalue
parse source . . execname .
fnin = " "; ftin = "FORTRAN"; fmin = "A"
fnold = ""; ftold = "FLOPIGN"; fmold = "A"
tree = "NO"; checks = "STANDARD"; ignore = "NO"
flopo = "YES"; full = "NO"; tidy = "NO"
fntdy = "OUTPUT"; fttdy = "FORTRAN"; fmtdy = "A"
gotos = "NO"; indent = "NO"; spaces = 3; groupf = "NO"
renums = "NO"; renumf = "NO"; startf = 500; stepf = 10
starts = 10; steps = 10
 
optset = "CHECKS IGNORE TREE DISK FULL GOTOS INDENT GROUPF"
optset = optset "RENUMF RENUMS OLD OUTPUT TIDY"
sngset = "TREE DISK FULL GOTOS GROUPF IGNORE TIDY"
 
 
err = "Name of source Fortran file not yet given."
cursor = "0001"
interactive = "YES"
parse upper arg input
parse value input with filename '(' options
xx = 'XPARSE'(filename,'A')
 
/***********************/
/* LINE MODE TREATMENT */
/***********************/
 
if A.0 ^= 0 then do
   interactive = "NO"
   if A.1 = "?" then do; ADDRESS CMS 'HELP 'execname; signal EXIT; end
   fnin = A.1
   if A.0 > 1 then ftin = A.2
   if A.0 > 2 then fmin = A.3
   if A.0 > 3 then do
      err = "Too many parameters given :" A.4
      signal EXIT
   end
   nopts = words(options)
   iopt = 0 ; err = " " ; flopo = "NO"
   do forever
      iopt = iopt + 1 ; if iopt > nopts then leave
      if find(optset,word(options,iopt))= 0 then do
         err = "Unidentified option on command line: "word(options,iopt)
         signal EXIT
      end
      if find(sngset,word(options,iopt)) ^= 0 then do
         interpret word(options,iopt)||'="YES"'
         if abbrev(word(options,iopt),"DISK",4) then flopo = "YES"
         iterate
      end
      if iopt < nopts then do
         key = word(options,iopt) ; val = word(options,iopt+1)
         if abbrev(key,"OLD",3) then do
            if iopt + 3 > nopts then do
               err = "Specify full file name for OLD file."
               signal EXIT
            end
            fnold = val
            ftold = word(options,iopt+2)
            fmold = word(options,iopt+3)
            iopt = iopt + 2
         end
         if abbrev(key,"OUT",3) then do
            if iopt + 3 > nopts then do
               err = "Specify full file name for OUTPUT file."
               signal EXIT
            end
            fntdy = val
            fttdy = word(options,iopt+2)
            fmtdy = word(options,iopt+3)
            iopt = iopt + 2
         end
         if abbrev(key,"CHEC",4) then checks = val
         if abbrev(key,"INDE",4) then do
            spaces = val
            indent = "YES"
         end
         if abbrev(key,"RENUMF",6) then do
            /* renumber FORMAT statements. Get the step and start. */
            ipos = pos(",",val,1)
            if ipos = 0 then startf = val
            else do
               startf = substr(val,1,ipos-1)
               stepf  = substr(val,ipos+1)
            end
            renumf = "YES"
         end
         if abbrev(key,"RENUMS",6) then do
            /* renumber other statements. Get the step and start. */
            ipos = pos(",",val,1)
            if ipos = 0 then starts = val
            else do
               starts = substr(val,1,ipos-1)
               steps  = substr(val,ipos+1)
            end
            renums = "YES"
         end
         iopt = iopt + 1
         iterate
      end
      if iopt = nopts then do
         err = 'Missing value for option 'word(options,iopt)
         signal EXIT
      end
   end
end
 
/****************/
/* GENERAL MODE */
/****************/
 
START:
if interactive = "NO" then signal CHECK
if ^'QCONSOLE'('GRAPHIC') then do
   err = 'Not a full screen device'
   signal EXIT
end
do forever
   signal off error
   'IOS3270' execname 'PANEL ;PANEL1 (CLEAR 'cursor
/* signal on error    ios3270 gives codes that aren't errors...*/
   if IOSK = 'PF03' then do; err = ' '; signal EXIT; end
   if IOSK = 'PF02' then do
      say "Enter the CMS command :"
      parse pull command
      signal off error; ADDRESS CMS command; signal on error
      say "Continue with "execname" ? [CR=YES]"
      parse upper pull answer
      if abbrev(answer,"N",1) then signal EXIT
      iterate
   end
   if IOSK = 'PF01' then do
      /* extract cursor position and find appropriate part of help */
      row = substr(IOSC,1,2) ; col = substr(IOSC,3,2)
      cursor = IOSC
      if row = 5 then do
         push 'FIND FLOPPY'
         ADDRESS CMS 'XEDIT 'execname' HELPCMS'
         iterate
      end
      if row = 7 then do
         push 'FIND OLD'
         ADDRESS CMS 'XEDIT 'execname' HELPCMS'
         iterate
      end
      if row = 8 then do
         push 'FIND CHECKS'
         ADDRESS CMS 'XEDIT 'execname' HELPCMS'
         iterate
      end
      if row = 9 then do
         push 'FIND IGNORE'
         ADDRESS CMS 'XEDIT 'execname' HELPCMS'
         iterate
      end
      if row = 11 then do
         push 'FIND TREE'
         ADDRESS CMS 'XEDIT 'execname' HELPCMS'
         iterate
      end
      if row = 13 then do
         push 'FIND DISK'
         ADDRESS CMS 'XEDIT 'execname' HELPCMS'
         iterate
      end
      if row = 14 then do
         push 'FIND FULL'
         ADDRESS CMS 'XEDIT 'execname' HELPCMS'
         iterate
      end
      if row = 16 & col > 40 then do
         push 'FIND OUTPUT'
         ADDRESS CMS 'XEDIT 'execname' HELPCMS'
         iterate
      end
      if row = 16 & col < 41 then do
         push 'FIND FLOPPY'
         ADDRESS CMS 'XEDIT 'execname' HELPCMS'
         iterate
      end
      if row = 17 then do
         push 'FIND GOTOS'
         ADDRESS CMS 'XEDIT 'execname' HELPCMS'
         iterate
      end
      if row = 18 then do
         push 'FIND INDENT'
         ADDRESS CMS 'XEDIT 'execname' HELPCMS'
         iterate
      end
      if row = 19 then do
         push 'FIND GROUPF'
         ADDRESS CMS 'XEDIT 'execname' HELPCMS'
         iterate
      end
      if row = 20 | row = 21 then do
         push 'FIND RENUMF'
         ADDRESS CMS 'XEDIT 'execname' HELPCMS'
         iterate
      end
      if row = 22 | row = 23 then do
         push 'FIND RENUMS'
         ADDRESS CMS 'XEDIT 'execname' HELPCMS'
         iterate
      end
      ADDRESS CMS 'HELP 'execname
   end
   leave
end
 
CHECK:
err = ' '
upper fnin ftin fmin fntdy fttdy fmtdy fnold ftold fmold
upper tree checks ignore flopo full tidy gotos
upper indent renums renumf groupf
 
if ^'FEXIST'(fnin ftin fmin) then do
   err = "Input FORTRAN file does not exist."
   cursor = "0001"
   if interactive = "YES" then signal START
   signal EXIT
end
 
if 'QFILE'(fnin ftin fmin,"RECFM") ^= "F" then do
   err = "Input FORTRAN file is RECFM V. Change to RECFM F please."
   cursor = "0001"
   if interactive = "YES" then signal START
   signal EXIT
end
 
if ^'FEXIST'(fnold ftold fmold) & LENGTH(fnold) ^= 0 then do
   err = "FLOPPY parameter file does not exist."
   cursor = "0004"
   if interactive = "YES" then signal START
   signal EXIT
end
 
checks = strip(checks)
if words(checks) ^= 1 then do
   err = "Use a single Checks keyword, or separate numbers with commas"
   cursor = "0007"
   if interactive = "YES" then signal START
   signal EXIT
end
 
if find("STANDARD ALEPH GALEPH ONLINE NONE LIST",checks) = 0 then do
   if ^datatype(checks,'N') then do
      if index(checks,',') = 0 then do
         err = "Must be list of numbers or keyword. See HELP file."
         cursor = "0007"
         if interactive = "YES" then signal START
         signal EXIT
      end
      else do
         ipos = 1
         do until ipos > length(checks)
            ipose = index(checks,',',ipos) - 1
            if ipose = -1 then ipose = length(checks)
            num = substr(checks,ipos,ipose-ipos+1)
            if ^datatype(num,"N") then do
                err = "Invalid integer "num" in list of checks."
                cursor = "0007"
                if interactive = "YES" then signal START
                signal EXIT
            end
            ipos = ipose + 2
         end
      end
   end
end
 
set1 = "N"
if abbrev(gotos,"Y",1) | abbrev(indent,"Y",1) ,
     | abbrev(groupf,"Y",1) | abbrev(renumf,"Y",1),
     | abbrev(renumf,"Y",1) then set1 = "Y"
 
if set1 = "Y" then tidy = "Y"
if set1 = "N" & abbrev(tidy,"Y",1) then do
   err = "Specify how you want to tidy the code."
   cursor = "0012"
   if interactive = "YES" then signal START
   signal EXIT
end
 
if abbrev(tidy,"Y",1) then do
   if fntdy = " " then do
      err = "Specify the name of the output FORTRAN file."
      cursor = "0013"
      if interactive = "YES" then signal START
      signal EXIT
   end
   if fttdy = " " then do
      err = "Specify the name of the output FORTRAN file."
      cursor = "0014"
      if interactive = "YES" then signal START
      signal EXIT
   end
   if fnin||ftin||fmin = fntdy||fttdy||fmtdy then do
      err = "Output FORTRAN will overwrite input. Rename."
      cursor = "0013"
      if interactive = "YES" then signal START
      signal EXIT
   end
   if abbrev(indent,"Y",1) & ^datatype(spaces,"N") then do
      err = "Number of spaces to indent must be an integer."
      cursor = "0018"
      if interactive = "YES" then signal START
      signal EXIT
   end
   if abbrev(indent,"Y",1) & ( spaces>5 | spaces<1 ) then do
      err = "Number of spaces must be between 1 and 5 for indent."
      cursor = "0018"
      if interactive = "YES" then signal START
      signal EXIT
   end
   if abbrev(renumf,"Y",1) then do
      if ^datatype(startf,"N") then do
         err = "Statement number must be numeric."
         cursor = "0021"
         if interactive = "YES" then signal START
         signal EXIT
      end
      if ^datatype(stepf,"N") then do
         err = "Statement number step must be numeric."
         cursor = "0022"
         if interactive = "YES" then signal START
         signal EXIT
      end
   end
   if abbrev(renumf,"Y",1) then do
      if ^datatype(starts,"N") then do
         err = "Statement number must be numeric."
         cursor = "0024"
         if interactive = "YES" then signal START
         signal EXIT
      end
      if ^datatype(steps,"N") then do
         err = "Statement number step must be numeric."
         cursor = "0025"
         if interactive = "YES" then signal START
         signal EXIT
      end
   end
end
 
if ^abbrev(flopo,"N",1) & ^abbrev(flopo,"Y",1) then do
   err = "FLOPPY output to disk: give Yes or No."
   cursor = "0010"
   if interactive = "YES" then signal START
   signal EXIT
end
 
if ^abbrev(tree,"N",1) & ^abbrev(tree,"Y",1) then do
   err = "TREE output from FLOPPY: give Yes or No."
   cursor = "0009"
   if interactive = "YES" then signal START
   signal EXIT
end
 
if ^abbrev(full,"N",1) & ^abbrev(full,"Y",1) then do
   err = "Full source listing from FLOPPY: give Yes or No."
   cursor = "0011"
   if interactive = "YES" then signal START
   signal EXIT
end
 
if ^abbrev(ignore,"N",1) & ^abbrev(ignore,"Y",1) then do
   err = "List of ignore names for FLOPPY: give Yes or No."
   cursor = "0008"
   if interactive = "YES" then signal START
   signal EXIT
end
 
 
 
/* Now write the necessary input files */
oldflag = length(fnold)
if oldflag ^= 0 then file = fnold' TEMP$T A'
if oldflag  = 0 then do
   file = fnin' FLOPIGN A'
   if 'FEXIST'(file) then 'ERASE 'file /* erase unwanted ignore file */
end
exw = 'EXECIO 1 DISKW 'file' (STRING '
exw" "
 
if abbrev(full,'Y',1) then exw"*FULL"
 
if abbrev(checks,'ALEP',1) & oldflag = 0 then exw"*ALEPH"
 
if abbrev(ignore,"Y",1) then do
    say "You must now enter a list of the names FLOPPY is to ignore"
    /* push terminal control characters before reading names */
    cpus= "CPUSH"("TERM")
    "CP TERM CHARDEL OFF"
    "CP TERM LINEDEL OFF"
    "CP TERM LINEND  OFF"
    "CP TERM ESCAPE  OFF"
    "CP TERM TABCHAR OFF"
    say "Names to ignore ..... "
    say " eg to ignore variable NUMGEN enter NUMGEN "
    say "    to ignore subroutine FRED enter #FRED "
    say " "
    n = 0
    do forever
       say "Enter name to ignore [CR=no more]"
       parse upper pull name
       if name = "" then leave
       n = n + 1
       exw name
    end
    /* restore control characters                            */
    cpo = "CPOP"("TERM")
end
 
if abbrev("LIST",checks,1) then do
   say 'Enter the long list of rule numbers to be checked.'
   say 'Separate each rule by a comma (,)'
   parse upper pull checks
end
 
if find("STANDARD ALEPH GALEPH ONLINE NONE LIST",checks) = 0 then do
   if ^datatype(checks,'N') then do
      ipos = 1
      do until ipos > length(checks)
         ipose = index(checks,',',ipos) - 1
         if ipose = -1 then ipose = length(checks)
         num = substr(checks,ipos,ipose-ipos+1)
         if length(num) = 1 then num = "  "||num
         if length(num) = 2 then num = " "||num
         if datatype(num,"N") then exw"*CHECK RULE "num
         ipos = ipose + 2
      end
   end
   else do
      if length(checks) = 1 then checks = " "||checks
      exw"*CHECK RULE  "checks
   end
end
else do
   if abbrev("STANDARD",checks,1) & oldflag = 0 then exw"*CHECK RULE *"
   if abbrev("ALEPH",checks,1) & oldflag = 0 then exw"*ALEPH"
   if abbrev("GALEPH",checks,1) & oldflag = 0 then exw"*ALEPH"
   if abbrev("GALEPH",checks,1) & oldflag = 0 then exw"*GALEPH"
   if abbrev("NONE",checks,1) then exw"*CHECK RULE -99"
end
'FINIS 'file
 
if fnold ^= " " then do
   'COPYFILE 'fnold ftold fmold' = = A (REPLACE'
   'COPYFILE 'file fnold ftold' A (APPEND'
   'ERASE 'file
end
else fnold = fnin
 
/* Now the FLOP (not FLOPPY) input data */
 
file = 'FLOPPY TEMP$T A'
if 'FEXIST'(file) then 'ERASE 'file
exw = 'EXECIO 1 DISKW 'file' (STRING '
 
if abbrev(tidy,"Y",1)   then exw"OUTPUT,FULL,COMPRESS;"
if abbrev(tree,"Y",1)   then exw"OPTIONS,TREE;"
if abbrev(gotos,"Y",1)  then exw"STATEMENTS,GOTO;"
if abbrev(groupf,"Y",1) then exw"STATEMENTS,SEPARATE;"
if abbrev(indent,"Y",1) then exw"OPTIONS,INDENT="spaces";"
if abbrev(renumf,"Y",1) then exw"STATEMENTS,FORMAT="startf","stepf";"
if abbrev(renums,"Y",1) then exw"STATEMENTS,NUMBER="starts","steps";"
/* default cards for FLOP */
exw"LIST,GLOBAL,TYPE;"
exw"PRINT,ILLEGAL;"
exw"OPTIONS,USER;"
exw"END;"
'FINIS 'file
 
'COPYFILE 'file' = = = (RECFM F LRECL 80 REPLACE'
 
'COPYFILE 'fnold ftold fmold' = = = (RECFM F LRECL 80 REPLACE'
 
/* Now assign the FILEDEFs */
'MAKEBUF'
bufno = rc
'SENTRIES'
entries = rc
'QFILEDEF ( STACK'
pull dummy
num_fdefs = 0
do queued()-entries
   num_fdefs = num_fdefs + 1
   pull fdef.num_fdefs
end
'DROPBUF 'bufno
'FILEDEF 5 CLEAR'
'FILEDEF 6 CLEAR'
'FILEDEF 11 CLEAR'
'FILEDEF 13 CLEAR'
'FILEDEF 14 CLEAR'
'FILEDEF 15 CLEAR'
'FILEDEF 50 CLEAR'
'FILEDEF 99 CLEAR'
 
'FILEDEF 5 DISK 'file
'FILEDEF 11 DISK 'fnin ftin fmin
'FILEDEF 15 DISK 'fnold ftold fmold
'FILEDEF 99 DISK FLOPPY SCRATCH A (RECFM F LRECL 132'
 
if abbrev(tidy,"Y",1) then do
  say 'Tidied FORTRAN output will be called 'fntdy fttdy fmtdy
  'FILEDEF 14 DISK 'fntdy fttdy fmtdy '(LRECL 80 RECFM F'
end
 
if abbrev(flopo,"Y",1) then do
  say 'FLOPPY listing file will be called 'fnin 'FLOPLIS A'
  'FILEDEF 6 DISK 'fnin' FLOPLIS A (LRECL 132 RECFM F'
end
else 'FILEDEF 6 TERMINAL (LRECL 132 PERM'
 
if abbrev(tree,"Y",1) then do
  say 'FLOPPY output for TREE will be called 'fnin 'FLOPTRE A'
  'FILEDEF 13 DISK 'fnin' TEMPTRE A (LRECL 8000 RECFM VS'
  'FILEDEF 50 DISK 'fnin' FLOPTRE A (LRECL 8000 RECFM VS'
end
 
say 'FLOPPY begins .... '
 
/* RUN FLOPPY */
'FLOPPY$M'
 
/* Reinstate original FILEDEFs */
'FILEDEF 5 CLEAR'
'FILEDEF 6 CLEAR'
'FILEDEF 11 CLEAR'
'FILEDEF 13 CLEAR'
'FILEDEF 14 CLEAR'
'FILEDEF 15 CLEAR'
'FILEDEF 50 CLEAR'
'FILEDEF 99 CLEAR'
do i = 1 to num_fdefs
   fdef.i
end
 
/* Erase unwanted files */
if 'FEXIST'('FLOPPY SCRATCH A') then 'ERASE FLOPPY SCRATCH A'
if 'FEXIST'(file) then 'ERASE 'file
 
say 'FLOPPY has finished'
 
call EXIT
 
 
 
NOVALUE:
say 'Uninitialised variable encountered on line' sigl
call EXIT
 
ERROR:
say 'Error on line' sigl
call EXIT
 
EXIT:
if err ^= " " then say execname ": " err
exit

