.TH floppy 1 "3rd March 1993"  "CERN"
.SH NAME
floppy \- Fortran coding convention checker and code tidier
.SH SYNOPSIS
.B floppy 
[
.B \-l
] [
.B \-c rules
] [
.B \-f
] [
.B \-o old file
] [
.B \-i names
] [
.B \-j number
] [
.B \-F
] [
.B \-G
] [
.B \-H HTML file
] [
.B \-A
] [
.B \-r start[,step]
] [
.B \-s start[,step]
] [
.B \-n new fortran
] [
.B \-t flow file
] [ file ]
.SH DESCRIPTION
.I Floppy
is a tool which allows a file of Fortran 77 code to be checked against
a set of common coding conventions. Floppy also allows the source Fortran
to be reformatted and tidied in various ways.
.PP
Note that, before passing code through Floppy, it should have
been compiled, preferably with the ANSI compiler flag, to check
for errors. Otherwise, the results from using Floppy are
unpredictable. Note also that non-standard Fortran statements
(such as "include" directives) are treated as
.B comments
by Floppy, and thus ignored. This version of Floppy allows long
variable names, and mixed-case source form.

.SH OPTIONS
.IP \fB\-l\fR 12
The
.I logging
option causes Floppy to produce a verbose description of the selected options.
.IP \fB\-c\ rules \fR 12
The 
.I checks
option indicates which rules Floppy should check. The checks may be specified as
a series of comma-separated numbers (see below), or as one of the following:
.RS 12
.IP standard 12
The standard set of rules will be checked (those marked * in the list below).
.IP a 12
ALL rules in the available list will be checked.
.IP n 12
NO rules will be checked. (Useful when just tidying code.)
.PP
Note that, if selecting individual rule numbers, 99 is taken to mean ALL
rules, and -99 to mean NO rules. Specifying a negative rule number excludes
that rule. So to check all rules except 1,5,7 and 31, you can use
.br
.RS 12
.I -c99,-1,-5,-7,-31
.RE 12

.RE
.IP \fB\-f\fR 12
The
.I full
qualifier specifies
that all source code lines should be listed, rather than
just those in breach of any specified rules.

.IP \fB\-o\ old file\fR 12
Use a previously-generated file of rule numbers, ignore names etc.
The
.I old
tag should be set to the file name, which is generated by 
appending .old to the previous source Fortran file name.

.IP \fB\-i\ names\fR 12
Specify a list of Fortran module and variable names to be ignored
when the rules are checked. Specify module names by prepending the
name with a # sign. The list of names should be separated by commas.
Note also that the names should be uppercase, to conform with the
F77 standard. For example,
.br
.I -i#GOOBAR,FOOBAR
will cause subroutine GOOBAR to be ignored, and any references to the
variable FOOBAR.

.IP \fB\-H\ HTML file\fR 12
The
.I HTML
option specifies that the source Fortran be converted to HTML.
The output filename is by default the source file name appended
with ".html", otherwise it may be given as an argument to the
option. When creating the HTML, all local variable names are
referenced with internal URLs. External module names are referenced
using a default URL (/dummy.html) or an Anchor Dictionary
may be specified (using the -A option) which is searched and
for the corresponding anchor text for the module name. Include
files are referenced directly. See the Floppy User Guide for
more details.

.IP \fB\-A\fR 12
The
.I Anchor Dictionary
option specifies that, for Fortran to HTML conversion, a dictionary
of module names is to be used to convert the text. For example,
if it is desired to reference a User Guide for any calls to
module MATRIX, then the anchor dictionary entry might appear thus:

MATRIX /usr/local/guides/matrixguide.html

If the dictionary (the name of which is the Fortran source file
name appended with ".htmldict") does not exist, it is created
and will contain a list of all module names found in the source.
If it does exist, it is appended with any module names found in
the source that do not appear in the dictionary.

.IP \fB\-t\ Flow file\fR 12
The
.I Flow
option specifies that a binary file be written out that
may afterwards be processed by the Flow program.

.PP

The following options apply to code tidying:

.IP \fB\-j\ [number]\fR 12
The
.I indent
option causes all DO loops and IF...THEN...ENDIF clauses to be
indented by the specified number of spaces to the right. The default
value is 3 spaces, the maximum allowed is 5.

.IP \fB\-F\fR 12
Specifies that all FORMAT statements be grouped together at the end
of each module.

.IP \fB\-G\fR 12
Specifies that all GOTO n clauses are right adjusted to column 72.

.IP \fB\-s\ start,[step]\fR 12
Specify that all labelled statements be re-numbered, starting at
.I start
and stepping by
.I step.
The default value for
.I step
is 10.

.IP \fB\-r\ start,[step]\fR 12
Specify that all FORMAT statements be re-numbered, starting at
.I start
and stepping by
.I step.
The default value for
.I step
is 10.

.IP \fB\-n\ new fortran\fR 12
Causes the new Fortran file to be called
.I new fortran.
If this option is not given, then the new Fortran file
will have the name of the source Fortran, appended by
.I .out

.SH CODING CONVENTION LIST

The full list of rules is as follows:
.br
.(l
*  1   Avoid comment lines after end of module
.br
*  2   End all program modules with the END statement
.br
*  3   Declared COMMON blocks must be used in the module
.br
*  4   COMPLEX and DOUBLEPRECISION vars at end of COMMON
.br
*  5   COMMON block definitions should not change
.br
*  6   Variable names should be 6 or fewer characters long
.br
   7   Variables in COMMON should be 6 characters long
.br
   8   Variables not in COMMON should be <6 characters
.br
*  9   Integer variables should begin with I to N
.br
*  10  Variable names should not equal FORTRAN keywords
.br
*  11  Avoid comment lines before module declaration
.br
*  12  Module names should not equal intrinsic functions
.br
*  13  Modules should declare IMPLICIT NONE
.br
*  14  Module should begin with at least 3 comment lines
.br
   15  Comment lines should begin with a C
.br
*  16  No comment lines between continuations
.br
*  17  Avoid non-standard variable types eg INTEGER*2
.br
*  18  Avoid multiple COMMON definitions per line
.br
*  19  Do not dimension COMMON variables outside COMMON
.br
*  20  Avoid embedded blanks in variable names
.br
*  21  Avoid embedded blanks in syntactic entities
.br
*  22  Avoid the use of PRINT statements (use WRITE)
.br
   23  Do not give the END statement a label
.br
*  24  Avoid WRITE(* construction
.br
   25  Avoid WRITE statement in a FUNCTION
.br
*  26  Avoid the use of PAUSE statements
.br
*  27  Statement labels should not begin in column 1
.br
*  28  Always preceede STOP by a descriptive WRITE
.br
*  29  Avoid the use of ENTRY in FUNCTIONS
.br
*  30  Avoid using I/O in FUNCTIONs
.br
   31  Avoid the use of the alternate RETURN statement
.br
*  32  COMMON block names should not equal variable names
.br
*  33  Avoid use of obsolete CERN library routines
.br
   34  Avoid FUNCTION names the same as intrinsics
.br
*  35  Local functions should be declared EXTERNAL
.br
*  36  Module names should all be different
.br
*  37  Avoid expressions of mixed mode eg A=B/I
.br
*  38  Length of passed CHARACTER variables should be *
.br
*  39  Order of statements should conform !
.br
*  40  Separate Statement Functions by comment lines
.br
*  41  No names in Statement Function definitions elsewhere
.br
   42  Use LLT,LGT etc to compare CHARACTER vars. in IFs
.br
   43  Variables (not COMMON, not PARAMs) <6 characters
.br
*  44  Passed arguments should be dimensioned * in module
.br
   45  Variables in COMMON should be >=6 characters long
.br 
   46  Avoid the use of the ENTRY statement
.)l

.SH SEE ALSO
.PP
flow(l), f77(1)
