import wx
import feature_support
from utils import is_deployed
import sys
import os

class GreeterView(wx.Panel):
	def __init__(self, parent, context):
		super().__init__(parent)

		self.scroll_panel = wx.ScrolledWindow(self, style=wx.VSCROLL)
		vbox = wx.BoxSizer(wx.VERTICAL)
		self.scroll_panel.SetSizer(vbox)
		self.scroll_panel.SetScrollRate(0, 20)
  
		txt_title = wx.StaticText(self.scroll_panel, label="Welcome to WeeaBlind")
		title_font = wx.Font(18, wx.FONTFAMILY_DEFAULT, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD)
		txt_title.SetFont(title_font)
		vbox.Add(txt_title, 0, wx.ALIGN_LEFT | wx.TOP | wx.LEFT, 20)

		img = wx.Image("logo.png" if not is_deployed else os.path.join("_internal", "logo.png"), wx.BITMAP_TYPE_ANY)
		img.Rescale(200, 200)
		bmp = wx.StaticBitmap(self.scroll_panel, wx.ID_ANY, wx.Bitmap(img))
		vbox.Add(bmp, 0, wx.ALIGN_LEFT | wx.BOTTOM | wx.LEFT, 20)

		intro_text = "Welcome to WeeaBlind, your companion for dubbing multi-lingual media using modern AI technologies. This tool bridges the gap for individuals with visual impairments, dyslexia, or anyone who prefers listening over reading subtitles. Dive into your favorite shows and videos and experiement with innovative speech synthesis, diarization, language identification, and voice cloning technologies. The program is still very much under construction, but is also quite useful in its current state!"
		txt_introduction = wx.StaticText(self.scroll_panel, label=intro_text)
		txt_introduction.Wrap(400)  # Wrap text to a maximum width of 400 pixels
		vbox.Add(txt_introduction, 0, wx.ALIGN_LEFT | wx.TOP | wx.LEFT, 20)
		
		mode_state = "RELEASE" if is_deployed else "DEVELOPMENT"
		mode_prompt = "You can install features from the requirements.txt with pip and they will become unlocked" if not is_deployed else "If you'd like access to the full suite of AI-powered features the program can perform, you'll need to install python and set up WeeaBlind in a virtual enviornment as described in the README. These are not easily distributable in a binary release format."
		txt_mode = wx.StaticText(self.scroll_panel, label=f"You are running in {mode_state} mode.\n{mode_prompt}")
		vbox.Add(txt_mode, 0, wx.ALIGN_LEFT | wx.TOP | wx.LEFT, 20)

		txt_usage_header = wx.StaticText(self.scroll_panel, label="How to Use Weeablind:")
		usage_section_font = wx.Font(14, wx.FONTFAMILY_DEFAULT, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD)
		txt_usage_header.SetFont(usage_section_font)
		vbox.Add(txt_usage_header, 0, wx.ALIGN_LEFT | wx.TOP | wx.LEFT, 20)

		

		usage_guide = """
Start by importing a video file or pasting a YouTube link and pressing enter
If you want subtitles autogenerated by YouTube, specify the language you want, or specify "all" for all subtitle options.
Make sure the correct audio and subtitle track are selected in the List Streams Tab
Next, configure the TTS voice you'd like to dub the video with. You can install more TTS voices in Windows settings and enable them with the "Unlock OneCore" button
Once everything is configured, you can preview how it will sound in the Subtitles Tab
If the video or subtitles are too quiet, you can change and preview the audio mixing in List Streams
If the subtitles for your video were autogenerated by YouTube, the timings may not line up perfectly, so unchecking Match Rate can fix timestreatch issues
Finally, click "Run Dubbing" to create your video
All files generated by the program appear in the "output" folder

--For Advanced Use--

If the video contains multiple spoken languages, use the language identification and filter features
If you want to remove spoken vocals in the video's source language, use the "remove vocals" button in List Streams
In the Subtitles Tab, you can select spoken lines for cloning and export them to a wav file
If you have Coqui TTS installed, you can use these clones with XTTS or a Voice Conversion model
For videos with only burned in subs, you can attempt Video OCR in the List Streams tab.
"""
		txt_usage = wx.StaticText(self.scroll_panel, label=usage_guide)
		txt_usage.Wrap(400)
		vbox.Add(txt_usage, 0, wx.ALIGN_LEFT | wx.TOP | wx.LEFT, 20)


		txt_features_header = wx.StaticText(self.scroll_panel, label="Currently Supported Features:")
		feature_section_font = wx.Font(14, wx.FONTFAMILY_DEFAULT, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD)
		txt_features_header.SetFont(feature_section_font)
		vbox.Add(txt_features_header, 0, wx.ALIGN_LEFT | wx.TOP | wx.LEFT, 20)

		features = {
			"FFmpeg": feature_support.ffmpeg_supported,
			"Diarization": feature_support.diarization_supported,
			"OCR": feature_support.ocr_supported,
			"Language Detection": feature_support.language_detection_supported,
			"Vocal Isolation": feature_support.vocal_isolation_supported,
			"YouTube Downloads": feature_support.downloads_supported,
			"Espeak": feature_support.espeak_supported,
			"Coqui TTS": feature_support.coqui_supported,
			"PyTorch": feature_support.torch_supported,
			"GPU Support": feature_support.gpu_supported,
		}

		for feature in features:
			txt_feature = wx.StaticText(self.scroll_panel, label=f"""{feature}: {"Not" if not features[feature] else ""} Supported""")
			txt_feature.SetForegroundColour((0, 255, 0) if features[feature] else (255, 0, 0))
			vbox.Add(txt_feature, 0, wx.ALIGN_LEFT | wx.TOP | wx.LEFT, 20)

		main_sizer = wx.BoxSizer(wx.VERTICAL)
		main_sizer.Add(self.scroll_panel, 1, wx.CENTER | wx.EXPAND | wx.ALL, border=10)
		self.SetSizerAndFit(main_sizer)

