#pragma once

#include "desktop.h"
#include "animations/animation_manager.h"
#include "views/desktop_view_pin_timeout.h"
#include "views/desktop_view_pin_input.h"
#include "views/desktop_view_locked.h"
#include "views/desktop_view_main.h"
#include "views/desktop_view_lock_menu.h"
#include "views/desktop_view_debug.h"
#include "views/desktop_view_slideshow.h"
#include <desktop/desktop_settings.h>

#include <furi.h>
#include <gui/gui.h>
#include <gui/view_stack.h>
#include <gui/view_dispatcher.h>
#include <gui/modules/popup.h>
#include <gui/scene_manager.h>

#include <loader/loader.h>
#include <notification/notification_app.h>
#include <toolbox/api_lock.h>

#define STATUS_BAR_Y_SHIFT 13

typedef enum {
    DesktopViewIdMain,
    DesktopViewIdLockMenu,
    DesktopViewIdLocked,
    DesktopViewIdHwMismatch,
    DesktopViewIdPinInput,
    DesktopViewIdPinTimeout,
    DesktopViewIdSlideshow,
    DesktopViewIdTotal,
} DesktopViewId;

struct Desktop {
    // Scene
    FuriThread* scene_thread;
    // GUI
    Gui* gui;
    ViewDispatcher* view_dispatcher;
    SceneManager* scene_manager;

    Popup* hw_mismatch_popup;
    DesktopLockMenuView* lock_menu;
    DesktopDebugView* _debug_view; // Unused, kept for compatibility
    DesktopViewLocked* locked_view;
    DesktopMainView* main_view;
    DesktopViewPinTimeout* pin_timeout_view;
    DesktopSlideshowView* slideshow_view;

    ViewStack* main_view_stack;
    ViewStack* locked_view_stack;

    DesktopSettings settings;
    DesktopViewPinInput* pin_input_view;

    ViewPort* lock_icon_viewport;
    ViewPort* _dummy_mode_icon_viewport; // Unused, kept for compatibility
    ViewPort* clock_viewport;
    ViewPort* stealth_mode_icon_viewport;

    AnimationManager* animation_manager;

    Loader* loader;
    NotificationApp* notification;

    FuriPubSubSubscription* app_start_stop_subscription;
    FuriPubSub* input_events_pubsub;
    FuriPubSubSubscription* input_events_subscription;
    FuriTimer* auto_lock_timer;
    FuriTimer* update_clock_timer;

    FuriPubSub* status_pubsub;

    uint8_t time_hour;
    uint8_t time_minute;
    bool time_format_12 : 1; // 1 - 12 hour, 0 - 24H

    bool in_transition : 1;

    Keybinds keybinds;

    FuriPubSub* ascii_events_pubsub;
    FuriPubSubSubscription* ascii_events_subscription;

    FuriApiLock animation_lock;
};

Desktop* desktop_alloc();

void desktop_free(Desktop* desktop);
void desktop_lock(Desktop* desktop, bool pin_lock);
void desktop_unlock(Desktop* desktop);
void desktop_set_stealth_mode_state(Desktop* desktop, bool enabled);
