#include <stdio.h>
#include <furi.h>
#include <furi_hal.h>
#include "../minunit.h"

static const uint8_t key_ctr_1[32] = {
    0x77, 0x6B, 0xEF, 0xF2, 0x85, 0x1D, 0xB0, 0x6F, 0x4C, 0x8A, 0x05, 0x42, 0xC8, 0x69, 0x6F, 0x6C,
    0x6A, 0x81, 0xAF, 0x1E, 0xEC, 0x96, 0xB4, 0xD3, 0x7F, 0xC1, 0xD6, 0x89, 0xE6, 0xC1, 0xC1, 0x04,
};
static const uint8_t iv_ctr_1[16] = {
    0x00,
    0x00,
    0x00,
    0x60,
    0xDB,
    0x56,
    0x72,
    0xC9,
    0x7A,
    0xA8,
    0xF0,
    0xB2,
    0x00,
    0x00,
    0x00,
    0x01,
};
static const uint8_t pt_ctr_1[16] = {
    0x53,
    0x69,
    0x6E,
    0x67,
    0x6C,
    0x65,
    0x20,
    0x62,
    0x6C,
    0x6F,
    0x63,
    0x6B,
    0x20,
    0x6D,
    0x73,
    0x67,
};
static const uint8_t tv_ctr_ct_1[16] = {
    0x14,
    0x5A,
    0xD0,
    0x1D,
    0xBF,
    0x82,
    0x4E,
    0xC7,
    0x56,
    0x08,
    0x63,
    0xDC,
    0x71,
    0xE3,
    0xE0,
    0xC0,
};

static const uint8_t key_ctr_2[32] = {
    0x77, 0x6B, 0xEF, 0xF2, 0x85, 0x1D, 0xB0, 0x6F, 0x4C, 0x8A, 0x05, 0x42, 0xC8, 0x69, 0x6F, 0x6C,
    0x6A, 0x81, 0xAF, 0x1E, 0xEC, 0x96, 0xB4, 0xD3, 0x7F, 0xC1, 0xD6, 0x89, 0xE6, 0xC1, 0xC1, 0x04,
};
static const uint8_t iv_ctr_2[16] = {
    0x00,
    0x00,
    0x00,
    0x60,
    0xDB,
    0x56,
    0x72,
    0xC9,
    0x7A,
    0xA8,
    0xF0,
    0xB2,
    0x00,
    0x00,
    0x00,
    0x01,
};
static const uint8_t pt_ctr_2[0] = {};
//static const uint8_t tv_ctr_ct_2[0] = {};

static const uint8_t key_ctr_3[32] = {
    0xF6, 0xD6, 0x6D, 0x6B, 0xD5, 0x2D, 0x59, 0xBB, 0x07, 0x96, 0x36, 0x58, 0x79, 0xEF, 0xF8, 0x86,
    0xC6, 0x6D, 0xD5, 0x1A, 0x5B, 0x6A, 0x99, 0x74, 0x4B, 0x50, 0x59, 0x0C, 0x87, 0xA2, 0x38, 0x84,
};
static const uint8_t iv_ctr_3[16] = {
    0x00,
    0xFA,
    0xAC,
    0x24,
    0xC1,
    0x58,
    0x5E,
    0xF1,
    0x5A,
    0x43,
    0xD8,
    0x75,
    0x00,
    0x00,
    0x00,
    0x01,
};
static const uint8_t pt_ctr_3[32] = {
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
    0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F,
};
static const uint8_t tv_ctr_ct_3[32] = {
    0xF0, 0x5E, 0x23, 0x1B, 0x38, 0x94, 0x61, 0x2C, 0x49, 0xEE, 0x00, 0x0B, 0x80, 0x4E, 0xB2, 0xA9,
    0xB8, 0x30, 0x6B, 0x50, 0x8F, 0x83, 0x9D, 0x6A, 0x55, 0x30, 0x83, 0x1D, 0x93, 0x44, 0xAF, 0x1C,
};

static const uint8_t key_ctr_4[32] = {
    0xFF, 0x7A, 0x61, 0x7C, 0xE6, 0x91, 0x48, 0xE4, 0xF1, 0x72, 0x6E, 0x2F, 0x43, 0x58, 0x1D, 0xE2,
    0xAA, 0x62, 0xD9, 0xF8, 0x05, 0x53, 0x2E, 0xDF, 0xF1, 0xEE, 0xD6, 0x87, 0xFB, 0x54, 0x15, 0x3D,
};
static const uint8_t iv_ctr_4[16] = {
    0x00,
    0x1C,
    0xC5,
    0xB7,
    0x51,
    0xA5,
    0x1D,
    0x70,
    0xA1,
    0xC1,
    0x11,
    0x48,
    0x00,
    0x00,
    0x00,
    0x01,
};
static const uint8_t pt_ctr_4[36] = {
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B,
    0x0C, 0x0D, 0x0E, 0x0F, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
    0x18, 0x19, 0x1A, 0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20, 0x21, 0x22, 0x23,
};
static const uint8_t tv_ctr_ct_4[36] = {
    0xEB, 0x6C, 0x52, 0x82, 0x1D, 0x0B, 0xBB, 0xF7, 0xCE, 0x75, 0x94, 0x46,
    0x2A, 0xCA, 0x4F, 0xAA, 0xB4, 0x07, 0xDF, 0x86, 0x65, 0x69, 0xFD, 0x07,
    0xF4, 0x8C, 0xC0, 0xB5, 0x83, 0xD6, 0x07, 0x1F, 0x1E, 0xC0, 0xE6, 0xB8,
};

static const uint8_t key_ctr_5[32] = {
    0xFF, 0x7A, 0x61, 0x7C, 0xE6, 0x91, 0x48, 0xE4, 0xF1, 0x72, 0x6E, 0x2F, 0x43, 0x58, 0x1D, 0xE2,
    0xAA, 0x62, 0xD9, 0xF8, 0x05, 0x53, 0x2E, 0xDF, 0xF1, 0xEE, 0xD6, 0x87, 0xFB, 0x54, 0x15, 0x3D,
};
static const uint8_t iv_ctr_5[16] = {
    0x00,
    0x1C,
    0xC5,
    0xB7,
    0x51,
    0xA5,
    0x1D,
    0x70,
    0xA1,
    0xC1,
    0x11,
    0x48,
    0x00,
    0x00,
    0x00,
    0x01,
};
static const uint8_t pt_ctr_5[0] = {};
//static const uint8_t tv_ctr_ct_5[0] = {};

static const uint8_t key_gcm_1[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
static const uint8_t iv_gcm_1[16] = {
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
};
static const uint8_t pt_gcm_1[0] = {};
//static const uint8_t tv_gcm_ct_1[0] = {};
static const uint8_t aad_gcm_1[0] = {};
static const uint8_t tv_gcm_tag_1[16] = {
    0x53,
    0x0F,
    0x8A,
    0xFB,
    0xC7,
    0x45,
    0x36,
    0xB9,
    0xA9,
    0x63,
    0xB4,
    0xF1,
    0xC4,
    0xCB,
    0x73,
    0x8B,
};

static const uint8_t key_gcm_2[32] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};
static const uint8_t iv_gcm_2[16] = {
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
};
static const uint8_t pt_gcm_2[16] = {
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
};
static const uint8_t tv_gcm_ct_2[16] = {
    0xCE,
    0xA7,
    0x40,
    0x3D,
    0x4D,
    0x60,
    0x6B,
    0x6E,
    0x07,
    0x4E,
    0xC5,
    0xD3,
    0xBA,
    0xF3,
    0x9D,
    0x18,
};
static const uint8_t aad_gcm_2[0] = {};
static const uint8_t tv_gcm_tag_2[16] = {
    0xD0,
    0xD1,
    0xC8,
    0xA7,
    0x99,
    0x99,
    0x6B,
    0xF0,
    0x26,
    0x5B,
    0x98,
    0xB5,
    0xD4,
    0x8A,
    0xB9,
    0x19,
};

static const uint8_t key_gcm_3[32] = {
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C, 0x6D, 0x6A, 0x8F, 0x94, 0x67, 0x30, 0x83, 0x08,
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C, 0x6D, 0x6A, 0x8F, 0x94, 0x67, 0x30, 0x83, 0x08,
};
static const uint8_t iv_gcm_3[16] = {
    0xCA,
    0xFE,
    0xBA,
    0xBE,
    0xFA,
    0xCE,
    0xDB,
    0xAD,
    0xDE,
    0xCA,
    0xF8,
    0x88,
    0x00,
    0x00,
    0x00,
    0x00,
};
static const uint8_t pt_gcm_3[64] = {
    0xD9, 0x31, 0x32, 0x25, 0xF8, 0x84, 0x06, 0xE5, 0xA5, 0x59, 0x09, 0xC5, 0xAF, 0xF5, 0x26, 0x9A,
    0x86, 0xA7, 0xA9, 0x53, 0x15, 0x34, 0xF7, 0xDA, 0x2E, 0x4C, 0x30, 0x3D, 0x8A, 0x31, 0x8A, 0x72,
    0x1C, 0x3C, 0x0C, 0x95, 0x95, 0x68, 0x09, 0x53, 0x2F, 0xCF, 0x0E, 0x24, 0x49, 0xA6, 0xB5, 0x25,
    0xB1, 0x6A, 0xED, 0xF5, 0xAA, 0x0D, 0xE6, 0x57, 0xBA, 0x63, 0x7B, 0x39, 0x1A, 0xAF, 0xD2, 0x55,
};
static const uint8_t tv_gcm_ct_3[64] = {
    0x52, 0x2D, 0xC1, 0xF0, 0x99, 0x56, 0x7D, 0x07, 0xF4, 0x7F, 0x37, 0xA3, 0x2A, 0x84, 0x42, 0x7D,
    0x64, 0x3A, 0x8C, 0xDC, 0xBF, 0xE5, 0xC0, 0xC9, 0x75, 0x98, 0xA2, 0xBD, 0x25, 0x55, 0xD1, 0xAA,
    0x8C, 0xB0, 0x8E, 0x48, 0x59, 0x0D, 0xBB, 0x3D, 0xA7, 0xB0, 0x8B, 0x10, 0x56, 0x82, 0x88, 0x38,
    0xC5, 0xF6, 0x1E, 0x63, 0x93, 0xBA, 0x7A, 0x0A, 0xBC, 0xC9, 0xF6, 0x62, 0x89, 0x80, 0x15, 0xAD,
};
static const uint8_t aad_gcm_3[0] = {};
static const uint8_t tv_gcm_tag_3[16] = {
    0xB0,
    0x94,
    0xDA,
    0xC5,
    0xD9,
    0x34,
    0x71,
    0xBD,
    0xEC,
    0x1A,
    0x50,
    0x22,
    0x70,
    0xE3,
    0xCC,
    0x6C,
};

static const uint8_t key_gcm_4[32] = {
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C, 0x6D, 0x6A, 0x8F, 0x94, 0x67, 0x30, 0x83, 0x08,
    0xFE, 0xFF, 0xE9, 0x92, 0x86, 0x65, 0x73, 0x1C, 0x6D, 0x6A, 0x8F, 0x94, 0x67, 0x30, 0x83, 0x08,
};
static const uint8_t iv_gcm_4[16] = {
    0xCA,
    0xFE,
    0xBA,
    0xBE,
    0xFA,
    0xCE,
    0xDB,
    0xAD,
    0xDE,
    0xCA,
    0xF8,
    0x88,
    0x00,
    0x00,
    0x00,
    0x00,
};
static const uint8_t pt_gcm_4[60] = {
    0xD9, 0x31, 0x32, 0x25, 0xF8, 0x84, 0x06, 0xE5, 0xA5, 0x59, 0x09, 0xC5, 0xAF, 0xF5, 0x26,
    0x9A, 0x86, 0xA7, 0xA9, 0x53, 0x15, 0x34, 0xF7, 0xDA, 0x2E, 0x4C, 0x30, 0x3D, 0x8A, 0x31,
    0x8A, 0x72, 0x1C, 0x3C, 0x0C, 0x95, 0x95, 0x68, 0x09, 0x53, 0x2F, 0xCF, 0x0E, 0x24, 0x49,
    0xA6, 0xB5, 0x25, 0xB1, 0x6A, 0xED, 0xF5, 0xAA, 0x0D, 0xE6, 0x57, 0xBA, 0x63, 0x7B, 0x39,
};
static const uint8_t tv_gcm_ct_4[60] = {
    0x52, 0x2D, 0xC1, 0xF0, 0x99, 0x56, 0x7D, 0x07, 0xF4, 0x7F, 0x37, 0xA3, 0x2A, 0x84, 0x42,
    0x7D, 0x64, 0x3A, 0x8C, 0xDC, 0xBF, 0xE5, 0xC0, 0xC9, 0x75, 0x98, 0xA2, 0xBD, 0x25, 0x55,
    0xD1, 0xAA, 0x8C, 0xB0, 0x8E, 0x48, 0x59, 0x0D, 0xBB, 0x3D, 0xA7, 0xB0, 0x8B, 0x10, 0x56,
    0x82, 0x88, 0x38, 0xC5, 0xF6, 0x1E, 0x63, 0x93, 0xBA, 0x7A, 0x0A, 0xBC, 0xC9, 0xF6, 0x62,
};
static const uint8_t aad_gcm_4[20] = {
    0xFE, 0xED, 0xFA, 0xCE, 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED,
    0xFA, 0xCE, 0xDE, 0xAD, 0xBE, 0xEF, 0xAB, 0xAD, 0xDA, 0xD2,
};
static const uint8_t tv_gcm_tag_4[16] = {
    0x76,
    0xFC,
    0x6E,
    0xCE,
    0x0F,
    0x4E,
    0x17,
    0x68,
    0xCD,
    0xDF,
    0x88,
    0x53,
    0xBB,
    0x2D,
    0x55,
    0x1B,
};

static void furi_hal_crypto_ctr_setup() {
}

static void furi_hal_crypto_ctr_teardown() {
}

static void furi_hal_crypto_gcm_setup() {
}

static void furi_hal_crypto_gcm_teardown() {
}

MU_TEST(furi_hal_crypto_ctr_1) {
    bool ret = false;
    uint8_t ct[sizeof(pt_ctr_1)];

    ret = furi_hal_crypto_ctr(key_ctr_1, iv_ctr_1, pt_ctr_1, ct, sizeof(pt_ctr_1));
    mu_assert(ret, "CTR 1 failed");
    mu_assert_mem_eq(tv_ctr_ct_1, ct, sizeof(pt_ctr_1));
}

MU_TEST(furi_hal_crypto_ctr_2) {
    bool ret = false;
    uint8_t ct[sizeof(pt_ctr_2)];

    ret = furi_hal_crypto_ctr(key_ctr_2, iv_ctr_2, pt_ctr_2, ct, sizeof(pt_ctr_2));
    mu_assert(ret, "CTR 2 failed");
    //mu_assert_mem_eq(tv_ctr_ct_2, ct, sizeof(pt_ctr_2));
}

MU_TEST(furi_hal_crypto_ctr_3) {
    bool ret = false;
    uint8_t ct[sizeof(pt_ctr_3)];

    ret = furi_hal_crypto_ctr(key_ctr_3, iv_ctr_3, pt_ctr_3, ct, sizeof(pt_ctr_3));
    mu_assert(ret, "CTR 3 failed");
    mu_assert_mem_eq(tv_ctr_ct_3, ct, sizeof(pt_ctr_3));
}

MU_TEST(furi_hal_crypto_ctr_4) {
    bool ret = false;
    uint8_t ct[sizeof(pt_ctr_4)];

    ret = furi_hal_crypto_ctr(key_ctr_4, iv_ctr_4, pt_ctr_4, ct, sizeof(pt_ctr_4));
    mu_assert(ret, "CTR 4 failed");
    mu_assert_mem_eq(tv_ctr_ct_4, ct, sizeof(pt_ctr_4));
}

MU_TEST(furi_hal_crypto_ctr_5) {
    bool ret = false;
    uint8_t ct[sizeof(pt_ctr_5)];

    ret = furi_hal_crypto_ctr(key_ctr_5, iv_ctr_5, pt_ctr_5, ct, sizeof(pt_ctr_5));
    mu_assert(ret, "CTR 5 failed");
    //mu_assert_mem_eq(tv_ctr_ct_5, ct, sizeof(pt_ctr_5));
}

MU_TEST(furi_hal_crypto_gcm_1) {
    bool ret = false;
    uint8_t pt[sizeof(pt_gcm_1)];
    uint8_t ct[sizeof(pt_gcm_1)];
    uint8_t tag_enc[16];
    uint8_t tag_dec[16];

    ret = furi_hal_crypto_gcm(
        key_gcm_1,
        iv_gcm_1,
        aad_gcm_1,
        sizeof(aad_gcm_1),
        pt_gcm_1,
        ct,
        sizeof(pt_gcm_1),
        tag_enc,
        false);
    mu_assert(ret, "GCM 1 encryption failed");
    //mu_assert_mem_eq(tv_gcm_ct_1, ct, sizeof(pt_gcm_1));
    mu_assert_mem_eq(tv_gcm_tag_1, tag_enc, 16);

    ret = furi_hal_crypto_gcm(
        key_gcm_1, iv_gcm_1, aad_gcm_1, sizeof(aad_gcm_1), ct, pt, sizeof(pt_gcm_1), tag_dec, true);
    mu_assert(ret, "GCM 1 decryption failed");
    //mu_assert_mem_eq(pt_gcm_1, pt, sizeof(pt_gcm_1));
    mu_assert_mem_eq(tv_gcm_tag_1, tag_dec, 16);
}

MU_TEST(furi_hal_crypto_gcm_2) {
    bool ret = false;
    uint8_t pt[sizeof(pt_gcm_2)];
    uint8_t ct[sizeof(pt_gcm_2)];
    uint8_t tag_enc[16];
    uint8_t tag_dec[16];

    ret = furi_hal_crypto_gcm(
        key_gcm_2,
        iv_gcm_2,
        aad_gcm_2,
        sizeof(aad_gcm_2),
        pt_gcm_2,
        ct,
        sizeof(pt_gcm_2),
        tag_enc,
        false);
    mu_assert(ret, "GCM 2 encryption failed");
    mu_assert_mem_eq(tv_gcm_ct_2, ct, sizeof(pt_gcm_2));
    mu_assert_mem_eq(tv_gcm_tag_2, tag_enc, 16);

    ret = furi_hal_crypto_gcm(
        key_gcm_2, iv_gcm_2, aad_gcm_2, sizeof(aad_gcm_2), ct, pt, sizeof(pt_gcm_2), tag_dec, true);
    mu_assert(ret, "GCM 2 decryption failed");
    mu_assert_mem_eq(pt_gcm_2, pt, sizeof(pt_gcm_2));
    mu_assert_mem_eq(tv_gcm_tag_2, tag_dec, 16);
}

MU_TEST(furi_hal_crypto_gcm_3) {
    bool ret = false;
    uint8_t pt[sizeof(pt_gcm_3)];
    uint8_t ct[sizeof(pt_gcm_3)];
    uint8_t tag_enc[16];
    uint8_t tag_dec[16];

    ret = furi_hal_crypto_gcm(
        key_gcm_3,
        iv_gcm_3,
        aad_gcm_3,
        sizeof(aad_gcm_3),
        pt_gcm_3,
        ct,
        sizeof(pt_gcm_3),
        tag_enc,
        false);
    mu_assert(ret, "GCM 3 encryption failed");
    mu_assert_mem_eq(tv_gcm_ct_3, ct, sizeof(pt_gcm_3));
    mu_assert_mem_eq(tv_gcm_tag_3, tag_enc, 16);

    ret = furi_hal_crypto_gcm(
        key_gcm_3, iv_gcm_3, aad_gcm_3, sizeof(aad_gcm_3), ct, pt, sizeof(pt_gcm_3), tag_dec, true);
    mu_assert(ret, "GCM 3 decryption failed");
    mu_assert_mem_eq(pt_gcm_3, pt, sizeof(pt_gcm_3));
    mu_assert_mem_eq(tv_gcm_tag_3, tag_dec, 16);
}

MU_TEST(furi_hal_crypto_gcm_4) {
    bool ret = false;
    uint8_t pt[sizeof(pt_gcm_4)];
    uint8_t ct[sizeof(pt_gcm_4)];
    uint8_t tag_enc[16];
    uint8_t tag_dec[16];

    ret = furi_hal_crypto_gcm(
        key_gcm_4,
        iv_gcm_4,
        aad_gcm_4,
        sizeof(aad_gcm_4),
        pt_gcm_4,
        ct,
        sizeof(pt_gcm_4),
        tag_enc,
        false);
    mu_assert(ret, "GCM 4 encryption failed");
    mu_assert_mem_eq(tv_gcm_ct_4, ct, sizeof(pt_gcm_4));
    mu_assert_mem_eq(tv_gcm_tag_4, tag_enc, 16);

    ret = furi_hal_crypto_gcm(
        key_gcm_4, iv_gcm_4, aad_gcm_4, sizeof(aad_gcm_4), ct, pt, sizeof(pt_gcm_4), tag_dec, true);
    mu_assert(ret, "GCM 4 decryption failed");
    mu_assert_mem_eq(pt_gcm_4, pt, sizeof(pt_gcm_4));
    mu_assert_mem_eq(tv_gcm_tag_4, tag_dec, 16);
}

MU_TEST_SUITE(furi_hal_crypto_ctr_test) {
    MU_SUITE_CONFIGURE(&furi_hal_crypto_ctr_setup, &furi_hal_crypto_ctr_teardown);
    MU_RUN_TEST(furi_hal_crypto_ctr_1);
    MU_RUN_TEST(furi_hal_crypto_ctr_2);
    MU_RUN_TEST(furi_hal_crypto_ctr_3);
    MU_RUN_TEST(furi_hal_crypto_ctr_4);
    MU_RUN_TEST(furi_hal_crypto_ctr_5);
}

MU_TEST_SUITE(furi_hal_crypto_gcm_test) {
    MU_SUITE_CONFIGURE(&furi_hal_crypto_gcm_setup, &furi_hal_crypto_gcm_teardown);
    MU_RUN_TEST(furi_hal_crypto_gcm_1);
    MU_RUN_TEST(furi_hal_crypto_gcm_2);
    MU_RUN_TEST(furi_hal_crypto_gcm_3);
    MU_RUN_TEST(furi_hal_crypto_gcm_4);
}

int run_minunit_test_furi_hal_crypto() {
    MU_RUN_SUITE(furi_hal_crypto_ctr_test);
    MU_RUN_SUITE(furi_hal_crypto_gcm_test);
    return MU_EXIT_CODE;
}
