<div align="center">

![Image text](https://github.com/Fitzgerald-Porthmouth-Koenigsegg/Plangothic/blob/main/pic/31fix.svg)

[日文 / 日本語](README.ja.md) | [英文 / English](README.en.md) | [簡體中文 / 简体中文](README.md)

# 遍黑體項目（Plangothic Project）
[![視頻介紹](https://img.shields.io/badge/視頻介紹-00a1d6?logo=Bilibili&logoColor=ffffff)](https://www.bilibili.com/video/BV1Dr4y1V7b7)
[![下載](https://img.shields.io/github/release/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project?color=critical&label=發行版下載&logo=data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA3LjQyIDcuNDIiPjxjaXJjbGUgY3g9IjMuNzEiIGN5PSIzLjcyIiByPSIzLjciIGZpbGw9IiNjNzVjNWMiLz48cGF0aCBmaWxsPSIjZmZmIiBkPSJtMy4yIDEuNTcgMS4wNS0uMDF6bTEuMDUtLjAxdjEuNTdoLjU4TDMuNzIgNC43IDIuNTcgMy4xMmguNjJWMS41OGMtLjczLjIyLTEuMjcuODgtMS4yOCAxLjY0aC0uMTZjLS40NSAwLS44Mi40OC0uODIgMS4wNiAwIC42LjY4IDEuMDcuODIgMS4wN2gzLjg4Yy4xMiAwIC44Mi0uNDguODItMS4wNyAwLS41OC0uMzctMS4wNi0uODMtMS4wNmgtLjA5YzAtLjc3LS41NC0xLjQ0LTEuMjgtMS42NVoiLz48L3N2Zz4=)](https://github.com/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project/releases/latest)
[![總下載](https://img.shields.io/github/downloads/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project/total.svg?color=critical&label=總下載量&logo=data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA3LjQyIDcuNDIiPjxjaXJjbGUgY3g9IjMuNzEiIGN5PSIzLjcyIiByPSIzLjciIGZpbGw9IiNjNzVjNWMiLz48cGF0aCBmaWxsPSIjZmZmIiBkPSJtMy4yIDEuNTcgMS4wNS0uMDF6bTEuMDUtLjAxdjEuNTdoLjU4TDMuNzIgNC43IDIuNTcgMy4xMmguNjJWMS41OGMtLjczLjIyLTEuMjcuODgtMS4yOCAxLjY0aC0uMTZjLS40NSAwLS44Mi40OC0uODIgMS4wNiAwIC42LjY4IDEuMDcuODIgMS4wN2gzLjg4Yy4xMiAwIC44Mi0uNDguODItMS4wNyAwLS41OC0uMzctMS4wNi0uODMtMS4wNmgtLjA5YzAtLjc3LS41NC0xLjQ0LTEuMjgtMS42NVoiLz48L3N2Zz4=)](https://github.com/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project/releases/latest)
[![星标](https://img.shields.io/github/stars/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project?label=星標數&color=critical&logo=data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA3LjQ1IDcuNyI+PHBhdGggZmlsbD0iI2ZmZDAwMCIgZD0iTTUuOTkgNy42NSAzLjc4IDYuMTIgMS40IDcuNjJsLjY3LTIuNzVMLjAyIDIuODhsMi42Mi0uMTZMMy43NSAwbC45NiAyLjY1IDIuNzMuMy0yLjAzIDEuOHoiLz48L3N2Zz4=)](https://github.com/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project)
[![License](https://img.shields.io/static/v1?label=使用協議&message=SIL%20Open%20Font%20License&color=critical&logo=creative%20commons)](https://github.com/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project/blob/main/LICENSE)
[![QQ Group](https://img.shields.io/badge/QQ%20羣-1135661191-critical?logo=tencentqq)](http://qm.qq.com/cgi-bin/qm/qr?_wv=1027&k=HvSdPx6z78suzTz51M3xGe-gENeaa1yc&authKey=eHjDZI54yDVbhyFjQqA2ImtV35LFy%2Fit8EuAzVDscVPcACE23L0hT314LiU9ey2%2F&noverify=0&group_code=1135661191)
</div>

## 概述
遍黑體項目是基於[思源黑體](https://github.com/adobe-fonts/source-han-sans)，並以中國大陸字形為標準的對中日韓統一表意文字擴展區進行字形補充的項目，是「遍宇宙家族」中的一個子項目，該項目於2020年6月前後啟動。

## 收錄範圍
本字體主要支援擴展B區至擴展J區的全部漢字，其他區塊有零星的字元。

> [!WARNING]
>
> 該字體目前處於未完成階段，仍然缺少大量漢字。
## 貢獻者
- 主製作：**[Fitzgerald](https://github.com/Fitzgerald-Porthmouth-Koenigsegg)**、[Usagixineist](https://github.com/Usagixineist)、[Cod'dte](https://github.com/buwuzhengyedexiaoji)、[PakMa Tsyn](https://github.com/PakMaTsyn)
- 聯合製作：Magnetshroom、[Mukuro](https://github.com/Hayashizawa)、[Humework](https://github.com/Humework-Gollayosh-Carzonharch-Hu)
- 其他技術協助：[0xAA55](https://github.com/0xAA55)、[Baysoftware](https://github.com/yi-bai)、Boris Ivanovich、[Henry Chan](https://github.com/hfhchan)、[Hulenkius](https://github.com/Hulenkius)、[Siphercase](https://github.com/Siphercase)、[Losketch](https://github.com/Losketch)

還有不少其他曾經向遍黑體項目給予支持、參與製作的人員，也在此對他們表示感謝。

## 字體授權
本字體以[SIL Open Font License（SIL開放字體協議）](https://openfontlicense.org/open-font-license-official-text/)授權形式發佈，詳見[授權文件](LICENSE)。

授權協議的簡體中文版參考（非官方譯本）：https://www.maoken.com/ofl 。

### 您可以：
- 任何個人、團體、組織及企業可免費進行商業目的和非商業目的使用，無需支付費用、事先告知作者、標明來源訊息或征得作者許可。
- 對字體檔案進行二次發佈或安裝、嵌入到任何軟體或設備中，同時軟體或設備可被再次分發或銷售。
- 對字體檔案進行修改、擴充和格式轉換，但二次修改的作品**嚴禁使用本字體的保留名稱「Plangothic」、「遍黑」**，二次修改過後的版本**亦須以 SIL Open Font License 發表**（若僅對源字體進行格式轉換可繼續使用該保留名稱）。

### 您不可以：
- 對字體檔案中的任何部分（包括但不限於字形、OpenType特性邏輯）進行倒賣兜售，如將字體檔案單獨售賣，與其他字體進行捆綁售賣、需付費辦理特殊許可權才可使用字體等。
- 將字體檔案中的任何部分以非SIL Open Font License授權協議發表。
- 利用本字體檔案或其衍生品進行危害計算機系統正常進行的行為（包括但不限於在字體檔案中嵌入計算機病毒、主觀故意利用程式或系統存在的漏洞來擾亂計算機系統的正常運作等）。
- 將本字體用作違反當地法律法規的用途。
- 其他上述未列明的違反SIL Open Font License授權協議的行為。

### 注意：
- 但凡有任何個人、企業、團隊等使用、複製、修改、分發本字體，或對本字型進行任何符合SIL Open Font License規定的行為，使用、下載或行使合約規定權利之接受方，即默認視為同意遵守SIL Open Font License的一切規定。
- 本字體為免費商用字體，**凡是需要付費來獲得該字體的行為，都是詐騙行為，謹防上當受騙**。如您是付費獲得的此字體，請立刻對其進行舉報，必要時可協助相關司法機關。
- 作者不行使、未能及時行使或未充分行使SIL Open Font License授權協議所享有的合法權利，不應被視為放棄該權利，也不影響作者在將來行使該權利。
- 本字體不包含任何政治意圖、隱喻及目的，與一切政治活動無關。 作者不承擔使用該字體所產生的任何連帶法律責任。

## 常見問題
### 1. 為什麼遍黑體是兩個字體檔案？
- 因為一個字體所能容納的字形數量有限（65535個），而表意文字的總數量遠大於這個值。
### 2. P1名稱中的fallback和allideo有什麼區別？
- fallback檔案適用於現時已安裝的字體**能顯示**全部漢字的用戶，其中還沒有製作黑體的漢字部分將空而不書。allideo檔案適用於現時已安裝的字體**不能顯示**全部漢字的用戶，其中還沒有製作黑體的漢字部分將使用花園明朝（Hanazono Mincho）补充之。兩個字體檔案均可以瞭解到現時遍黑體的製作進度如何，當本項目已經完全覆蓋所有漢字的時候，fallback檔案將會消失。
### 3. 為什麼只有P1的字體檔案是兩個類別？
- 因為P2所涵蓋的擴展G區、擴展H區、擴展J區的表意文字均已全部製作完畢，毋須再進行劃分。
### 4. 為什麼這個項目僅包含少量基本區和擴展A區的漢字？
- 因為本項目的宗旨是「基于[思源黑體](https://github.com/adobe-fonts/source-han-sans)進行的補充」，如需顯示基本區和擴展A區的表意文字，直接使用思源黑體即可。本項目中所包含的零星的基本區和擴展A區的表意文字均為在Unicode內**有字形改動或者不符合本項目宗旨**的表意文字。本項目在添加這些表意文字之前均已與其他主流字體和Unicode碼表內字形進行過比對。
### 5. 未來是否會做包含其他字重（或其他地區字形）的版本？
- 因為本項目工程量過於龐大，所以不會有此打算。若您有類似想法，可自行製作有關於您需求的該項目的衍生字體版本。
### 6. 為什麼這個項目裏的字體沒有複雜文種排版（CTL）或是異體字選擇器（IVS）功能？
- 因為本項目的字體使用性質側重於工具字體、亦即不負責排版僅負責顯示（類似於[Unifont](https://unifoundry.com/unifont)和[綿雲飴里](https://github.com/MY1L)所開發的[Noto Unicode](https://github.com/MY1L/Unicode/tree/main/NotoUnicode)），使用複雜文種處理準確地排版這些語言文字，或是使用異體字選擇器顯示其它地區字形的功能**並不在**本項目的涵蓋範圍內。若您有類似想法，可自行製作有關於您需求的該項目的衍生字體版本。
### 7. 本項目的TTC字體（即多個TrueType字體的合併）是否可以直接用於手機或在軟件中使用？即是否可以直接安裝在手機上並顯示所有字形？遇到的問題是否適用於所有軟件平台，或者只限於特定平台？
- 本項目的TTC字體適用於Windows平台，可以正常使用。由於其他原因，對於手機設備直接安裝TTC字體文件只能顯示其中的一個字形（通常是P1），無法同時顯示所有字形。在軟件中使用時，可能需要特別設置才能顯示TTC字體中的所有字形。不同平台對TTC字體的兼容性可能有所不同，大多數情況下需要額外的步驟。

#### 附：遍黑體安裝至Windows平台並全局Fallback的方法：

1. 下載TTF版字型檔案（兩個單獨的ttf或者單個的ttc檔案任選其一）；
2. 在資源管理器上選擇字型檔案，然後點擊**滑鼠右鍵→“為所有使用者安裝”（需要管理員權限，Win11使用者還需要點擊“顯示更多選項”）**，安裝字型檔案；
3. 下載註冊表檔案`reg/Plangothic-Install.reg`，雙擊執行（需要管理員權限），若出現安全警告請點擊“執行”；
4. 註銷並重新登錄Windows系統帳戶，設置即可生效；
5. 若要刪除字型，則僅需刪除字型本體即可，註冊表設置無需變動。如果要刪註冊表內容，下載文件`reg/Plangothic-Uninstall.reg`，雙擊執行即可。

#### 附：遍黑體安裝至手機的方法：

要將TTC字體安裝至Android手機，請遵循以下步驟：
1. 備份當前手機系統的 `/system/etc/fonts.xml` 和 `/system/etc/font_fallback.xml` （如果有）文件。
2. 打開 `system/etc/fonts.xml` 和 `/system/etc/font_fallback.xml` （如果有）文件。
3. 在文件的 `<family lang="ko">` 標籤後，找到相應的 `</family>` 標籤後換行。
4. 添加以下 XML 代碼，確保正確縮進：
``` xml
    <family>
        <font weight="400" style="normal" index="0">Plangothic.ttc</font>
        <font weight="400" style="normal" index="1">Plangothic.ttc</font>
    </family>
``` 
完成這些步驟後，重新啟動手機以使更改生效。如果仍然遇到問題，請檢查是否正確更新了字體文件，並確保設備權限允許修改系統文件。

另請注意，以上方法**不適用**於蘋果手機的用戶，亦無法提供針對蘋果手機用戶的安裝至手機的方法，敬請諒解。

## 支持我們
「不積跬步，無以至千里。」遍黑體項目製作難度大，製作時間長，若願意支持我們，在此致以誠摯感謝！您的捐助可以幫助遍黑體項目以更好發展。您還可以通過其他方式做出貢獻，如幫助檢查錯誤字形，對不美觀字形提出改進意見等。

在您捐助之前請務必注意以下幾點：
- 捐款前請務必仔細確付款帳戶（支付寶：Fitzgerald K.、微信：蔽芪茢·茇䓮·蓲䒤菥。如用戶名有改動，則第一時間會做出更正），我們無法承擔您受騙的損失。
- 現時只有這一個頁面是正式的受捐頁面。如果您在其它地方看到此項目的捐款連結，請立刻對其進行舉報，必要時可協助相關司法機關。
- 您向本項目捐助，即默認表明您贊同我們的理念，並願意以此種方式支持我們的發展。捐助者提出的意見會被認真考慮，但捐款再多也沒有權利以個人意志改變本項目的宗旨和公益性質。
- 捐助後如願意，可留言寫明您的捐款時間和金額，感謝您對本項目的支持。
- 所有捐助資金均會逐一記錄，並將全部用於該項目的技術支援等開銷，不會被私用。
![Image text](https://github.com/Fitzgerald-Porthmouth-Koenigsegg/Plangothic/blob/main/pic/1650383987393.svg)

## 联系方式
您在使用本字體的過程中如有任何問題和建議，歡迎反饋。您可在項目中提交issue（嚴禁提交無關內容），也可以通過下列聯繫方式進行反饋：
- GitHub: https://github.com/Fitzgerald-Porthmouth-Koenigsegg
- Twitter: https://twitter.com/Fitzgerald_P_K_/
- 郵箱: 374601620@qq.com（備用郵箱：fitzgeraldkoenigsegg@gmail.com）
- QQ: 374601620

## 其他說明
1. 任何人都可以參與到遍黑體項目的製作中，但需確保您對地區字形、字形美觀、軟體使用、Unicode等方面有一定的基礎，關於此方面可加入該項目的QQ群[1135661191](http://qm.qq.com/cgi-bin/qm/qr?_wv=1027&k=HvSdPx6z78suzTz51M3xGe-gENeaa1yc&authKey=eHjDZI54yDVbhyFjQqA2ImtV35LFy%2Fit8EuAzVDscVPcACE23L0hT314LiU9ey2%2F&noverify=0&group_code=1135661191)進行詳細商討質詢。另外，本項目目前只有這一個用來交流的討論組，由於某些原因，我們無任何海外討論群組（Telegram、Discord等），給您帶來的不便深表歉意。
2. 本項目長期招賢納士，您可以動用自己的一份力，讓身邊更多的人瞭解該企劃。我們也歡迎字體製作方面的技術人才，歡迎大家繼續完善該項目，您可以通過上面的聯繫方式與作者聯系。遍黑體項目的發展離不開你們的宣傳和鼓勵。
3. 本項目成員並不是專業的字體設計師，所以會導致字體的字形結構可能不甚美觀，補字與原版相比可能略有違和感。此外由於成員的時間與精力有限，項目並沒有多餘的時間精修，部分漢字的部件拼接會很生硬，因此作者無法保證字體本身數據的準確性及預期呈現效果在您的設備是否能够完美複現，作者不對本字體作任何明示或暗示的保證，亦不承擔您使用該字體所產生的任何索賠、損害或可歸責事由而來的任何責任。
4. 本字體包含的部分國標字形**未完全遵循**[Unicode官方碼表文件](https://www.unicode.org/charts/)中所展示的字形，十分介意者請勿使用。
5. 本項目部分或全部借用或參考了其他工具或開源字體項目，主要包括：
    - [思源黑體](https://github.com/adobe-fonts/source-han-sans)。
    - Noto系列裡的其他字體。
    - [上地宏一](https://twitter.com/kamichikoichi)所開發的[字形維基](https://glyphwiki.org/wiki/GlyphWiki:%e3%83%a1%e3%82%a4%e3%83%b3%e3%83%9a%e3%83%bc%e3%82%b8)及 KAGE Engine。
    - [すきまゴシック（Sukima Gothic、隙間黑體）](https://oppekebekkanko.booth.pm/items/2117070)。
    - [綿雲飴里](https://github.com/MY1L)所開發的[Noto Unicode](https://github.com/MY1L/Unicode/tree/main/NotoUnicode)。
    - [昭源黑體](https://github.com/chiron-fonts/chiron-hei-hk)。
    - [奈白不弍](https://github.com/Buernia)所開發的[煮豆黑體](https://github.com/Buernia/Zhudou-Sans)。
    - [秋空黑體](https://github.com/ChiuMing-Neko/ChiuKongGothic)。
    - [Nôm Na Tống（喃那宋）](https://github.com/nomfoundation/font)。
    - [魏安（Andrew West）](https://twitter.com/BabelStone)所開發的[BabelStone Han（巴別宋）](https://www.babelstone.co.uk/Fonts/index.html)。
    - [白易](https://github.com/yi-bai)所開發的[字統網](https://zi.tools)。
    - [Gothic Nguyen（阮黑體）](https://github.com/TKYKmori/Gothic-Nguyen)。
    - [Unicode官方碼表文件](https://www.unicode.org/charts/)。
    - [Unihan數據庫](https://www.unicode.org/Public/16.0.0/ucd/Unihan.zip)。
    - [Losketch](https://github.com/Losketch)所開發的[落尘無襯](https://github.com/Losketch/LorchinSans)。
6. 該項目的字形資料由[Hulenkius](https://github.com/Hulenkius)通過SVG檔案進行線上使用，使用者可以通過「<https://seeki.vistudium.top/SVG/{小寫的漢字十六進制碼位}.svg>」鏈接獲取。

    例：`<img src="https://seeki.vistudium.top/SVG/2ebf0.svg"/>`的顯示結果將會是：
<div align="center"><img src="https://seeki.vistudium.top/SVG/2ebf0.svg" width="20%"/></div>

> [!IMPORTANT]
> - 線上的SVG檔案僅包含中日韓統一表意文字擴展B區至中日韓統一表意文字擴展I區。
> - 線上的SVG檔案不和本項目的更新完全同步，請酌情使用。
## 關於「遍宇宙家族」（Planiverse）
該字體家族由Fitzgerald在2023年12月創設，現時涵蓋了以下的幾個子字體項目：
1. **Plangothic Project（遍黑體項目）**：基於思源黑體，並以中國大陸字形為標準的對中日韓越統一表意文字擴展區進行字形補充的項目。
    - **項目狀態**：已創設項目本體和項目主頁，但未完成。
2. **Planwritzen Project（遍蕤體項目）**：基於Fitzgerald自己的手寫體，並以遍黑體項目中的字形為標準的字體項目，其字元收錄範圍暫定為思源黑體+遍黑體（或可能會有字元範圍的擴充）。
    - **項目狀態**：已創設項目本體，但未創建項目主頁。
3. **Planschrift Project（遍玨體項目）**：基於匯文明朝體，對中日韓越統一表意文字擴展區進行字形補充的項目，其字元收錄範圍暫定為在匯文明朝體的字元範圍基礎上擴充至思源黑體+遍黑體。
    - **項目狀態**：已創設項目本體和[項目主頁](https://github.com/Fitzgerald-Porthmouth-Koenigsegg/Planschrift_Project)，但未完成。
4. **Planseal Project（遍篆體項目）**：基於《說文解字》小篆體，對中日韓越統一表意文字擴展區進行字形補充的項目。
    - **項目狀態**：未創設項目本體和項目主頁，項目名稱暫定。
5. **Planicon Project（遍象體項目）**：基於字統網中部分漢字圖標的字形補充的項目，其字元收錄範圍暫定為基本區和擴展A區，其他漢字區塊散有字形。
    - **項目狀態**：已創設項目本體，但未創建項目主頁，項目名稱暫定。
6. **Plantsing Project（遍擎體項目）**：基於武英殿本《康熙字典》，對中日韓越統一表意文字擴展區進行字形補充的項目，其字元收錄範圍暫定為與遍黑體項目拉齊。
    - **項目狀態**：未創設項目本體和項目主頁。
7. **Planhangul Project（遍訓體項目）**：基於思源黑體，但以漢字的形式對諺文進行字形製作的項目，其字元收錄範圍暫定為基本諺文和擴展諺文。
    - **項目狀態**：未創設項目本體和項目主頁，項目名稱暫定。
8. **Planfixibit Project（遍繕體項目）**：基於[Fixedsys Excelsior](https://github.com/kika/fixedsys)，跟進最新版本的Unicode，並進行字元補充的項目。
    - **項目狀態**：未創設項目本體和項目主頁，項目名稱暫定。
> [!WARNING]
>
> 1. 嚴格意義上來說，遍象體項目和遍繕體項目不符合收錄進「遍宇宙家族」的要求，但出於方便考慮，仍然將這兩個項目納入進該家族中。
> 2. 遍象體項目、遍擎體項目、遍繕體項目疑似容易產生版權爭端，是否能够存活亟待商榷。
