<div align="center">

![Image text](https://github.com/Fitzgerald-Porthmouth-Koenigsegg/Plangothic/blob/main/pic/31fix.svg)

[簡體字中国語 / 简体中文](README.md) | [英語 / English](README.en.md) | [繁體字中國語 / 繁體中文](README.zh.hant.md)

# プランゴシック・プロジェクト（Plangothic Project）
[![视频介绍](https://img.shields.io/badge/ビデオ紹介-00a1d6?logo=Bilibili&logoColor=ffffff)](https://www.bilibili.com/video/BV1Dr4y1V7b7)
[![下载](https://img.shields.io/github/release/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project?color=critical&label=リリースバージョン&logo=data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA3LjQyIDcuNDIiPjxjaXJjbGUgY3g9IjMuNzEiIGN5PSIzLjcyIiByPSIzLjciIGZpbGw9IiNjNzVjNWMiLz48cGF0aCBmaWxsPSIjZmZmIiBkPSJtMy4yIDEuNTcgMS4wNS0uMDF6bTEuMDUtLjAxdjEuNTdoLjU4TDMuNzIgNC43IDIuNTcgMy4xMmguNjJWMS41OGMtLjczLjIyLTEuMjcuODgtMS4yOCAxLjY0aC0uMTZjLS40NSAwLS44Mi40OC0uODIgMS4wNiAwIC42LjY4IDEuMDcuODIgMS4wN2gzLjg4Yy4xMiAwIC44Mi0uNDguODItMS4wNyAwLS41OC0uMzctMS4wNi0uODMtMS4wNmgtLjA5YzAtLjc3LS41NC0xLjQ0LTEuMjgtMS42NVoiLz48L3N2Zz4=)](https://github.com/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project/releases/latest)
[![总下载](https://img.shields.io/github/downloads/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project/total.svg?color=critical&label=トータルダウンロード&logo=data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA3LjQyIDcuNDIiPjxjaXJjbGUgY3g9IjMuNzEiIGN5PSIzLjcyIiByPSIzLjciIGZpbGw9IiNjNzVjNWMiLz48cGF0aCBmaWxsPSIjZmZmIiBkPSJtMy4yIDEuNTcgMS4wNS0uMDF6bTEuMDUtLjAxdjEuNTdoLjU4TDMuNzIgNC43IDIuNTcgMy4xMmguNjJWMS41OGMtLjczLjIyLTEuMjcuODgtMS4yOCAxLjY0aC0uMTZjLS40NSAwLS44Mi40OC0uODIgMS4wNiAwIC42LjY4IDEuMDcuODIgMS4wN2gzLjg4Yy4xMiAwIC44Mi0uNDguODItMS4wNyAwLS41OC0uMzctMS4wNi0uODMtMS4wNmgtLjA5YzAtLjc3LS41NC0xLjQ0LTEuMjgtMS42NVoiLz48L3N2Zz4=)](https://github.com/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project/releases/latest)
[![星标](https://img.shields.io/github/stars/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project?label=トータル星&color=critical&logo=data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA3LjQ1IDcuNyI+PHBhdGggZmlsbD0iI2ZmZDAwMCIgZD0iTTUuOTkgNy42NSAzLjc4IDYuMTIgMS40IDcuNjJsLjY3LTIuNzVMLjAyIDIuODhsMi42Mi0uMTZMMy43NSAwbC45NiAyLjY1IDIuNzMuMy0yLjAzIDEuOHoiLz48L3N2Zz4=)](https://github.com/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project)
[![License](https://img.shields.io/static/v1?label=ライセンス&message=SIL%20Open%20Font%20License&color=critical&logo=creative%20commons)](https://github.com/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project/blob/main/LICENSE)
</div>

## 概要
Plangothic Project（プランゴシックプロジェクト、中国語：遍黒體項目、遍黑体项目）は、[源ノ角ゴシック](https://github.com/adobe-fonts/source-han-sans)の中国大陸版をベースに、CJK 統合漢字拡張ブロックを補完するゴシック体フォントの作成を目指すプロジェクトです。2020 年 6 月頃より開発されています。

## 収録範囲
本フォントは主に拡張漢字B区から拡張漢字J区までのすべてを支援し、その他のブロックには散発的な文字がある。

> [!WARNING]
>
> このフォントは現在未完成の段階にあり、まだ大量の漢字が不足している。
## 主な開発メンバー
- 制作コア：**[Fitzgerald](https://github.com/Fitzgerald-Porthmouth-Koenigsegg)**、[Usagixineist](https://github.com/Usagixineist)、[Cod'dte](https://github.com/buwuzhengyedexiaoji)、[PakMa Tsyn](https://github.com/PakMaTsyn)
- 共同制作：Magnetshroom、[Mukuro](https://github.com/Hayashizawa)、[Humework](https://github.com/Humework-Gollayosh-Carzonharch-Hu)
- 技術協力：[0xAA55](https://github.com/0xAA55)、[Baysoftware](https://github.com/yi-bai)、Boris Ivanovich、[Henry Chan](https://github.com/hfhchan)、[Hulenkius](https://github.com/Hulenkius)、[Siphercase](https://github.com/Siphercase)、[Losketch](https://github.com/Losketch)

その他、これまでにご協力とご支援を頂いた方々にも、心より感謝を申し上げます。

## ライセンス
本フォントはSIL Open Font License（SILオープンフォントライセンス）形式で公開されており、詳細は[ライセンス](LICENSE)を参照。

### あなたは：
- いかなる個人、団体、組織及び企業は無料で商業目的と非商業目的の使用を行うことができ、費用を支払う必要がなく、事前に著者に知らせ、ソース情報を明記したり、著者の許可を得たりする必要がない。
- フォントファイルを二次発行またはインストールし、任意のソフトウェアまたはデバイスに埋め込み、ソフトウェアまたはデバイスを再配布または販売することができます。
- フォントファイルの修正、拡張、フォーマット変換を行いますが、二次修正された作品は**本フォントの保留名「Plangothic」、「遍黑」を使用することを厳禁し**、二次修正されたバージョンも**SIL Open Font Licenseで発表する必要があります**（ソースフォントのみをフォーマット変換する場合は、この保留名を使用し続けることができます）。

### あなたはできません：
- フォントファイルの一部（字形、OpenType特性を含むがこれらに限定されない）を転売し、例えば、フォントファイルを単独で販売し、他のフォントと同梱して販売し、特殊な権限を有料で処理しなければフォントを使用できないなど。
- フォントファイルの任意の部分を非SIL Open Font License発表します。
- 本フォントファイルまたはその派生物を用いてコンピュータシステムの正常な進行を危害する行為（それには限定されない：フォントファイルにコンピュータウイルスを埋め込むこと、プログラムまたはシステムに存在する脆弱性を主観的に故意に利用してコンピュータシステムの正常な動作を乱すことなどを含むが、これらに限定されない）を行う。
- このフォントは、ローカル法規制に違反する用途として使用されます。
- 上記に記載されていないその他のSIL Open Font License違反行為。

### に注意：
- 個人、企業、団体などが本フォントを使用、複製、修正、配布したり、本フォントに対してSIL Open Font Licenseの規定に該当する行為を行ったりした場合、使用、ダウンロード、またはライセンスの該当行為を行った当事者は、暗黙にSIL Open Font Licenseのすべての規定に同意したものとみなされます。
- このフォントは無料の商用フォントで、料金を払ってこのフォントを入手する必要がある行為はすべて詐欺行為であり、だまされないように注意してください。このフォントを有料で入手した場合は、必要に応じて司法機関に協力できるように、すぐに通報してください。
- 著者はSIL Open Font Licenseによって享受された合法的な権利を使用したり、適時に行使しなかったり、十分に行使しなかったりしてはならず、その権利を放棄したとみなされてはならず、著者が将来その権利を行使することにも影響しない。
- このフォントには、すべての政治活動とは関係なく、政治的意図、メタファー、目的は含まれていません。著者は、このフォントを使用することによる連帯の法的責任を負いません。

## よくある質問
### 1. なぜ Plangothic のフォントファイルは 2 つあるのですか？
- 1 フォントファイルあたりの最大グリフ数は 65535 に制限されていますが、CJK 統合漢字の数はこれよりはるかに多いからです。
### 2. P1のfallback版とallideo版の違いは何ですか？
- fallback版は、すべてのCJK統合漢字を**表示できるフォントが**現在インストールされているユーザーに適用されます、未作成の漢字部分は表示されません。Allideo版は、すべてのCJK統合漢字を**表示できないフォントが**現在インストールされているユーザーに適用されます、未作成の漢字を花園明朝（Hanazono Mincho）で補足される。どちらのファイルも、最新の進捗状況を反映しています。このプロジェクトがすべてのCJK統合漢字を完全に上書きした場合、fallback版はなくなります。
### 3. なぜP1だけが2種類に分かれているのですか？
- P2に含まれる拡張G、拡張H、拡張Jの漢字は全て制作済みなので、区分する必要がないからです。
### 4. なぜこのプロジェクトには URO（基本ブロック）と拡張 A の漢字が少量含まれているのですか？
- 本プロジェクトの趣旨は「[源ノ角ゴシック](https://github.com/adobe-fonts/source-han-sans)ベースの補完」であるため、URO と拡張 A の CJK 漢字を表示したい場合は、そのまま源ノ角ゴシックを使用できます。本プロジェクトに含まれるまばらな URO と拡張 A の文字は、いずれも Unicode でグリフ変更があったり、本プロジェクトの趣旨に合わない文字です。これらの漢字を追加する前には、他の主なフォントや Unicode コード表のグリフと比較しています。
### 5. 将来、他のウェイト（または他地域のグリフ）を追加する予定はありますか？
- このプロジェクトの作業量は膨大なため、その予定はありません。ご関心のある方は、各自で派生フォントを作成することができます。
### 6.なぜこのフォントに複雑なテキストレイアウト（ℂomplex 𝕋ext 𝕃ayout, CTL）や異体字セレクタ（𝕀deographs 𝕍ariation 𝕊electors, IVS）がないのでしょうか？
- 当プロジェクトは、[Unifont](https://unifoundry.com/unifont)、あるいは[綿雲飴里](https://github.com/MY1L)が開発した[Noto Unicode](https://github.com/MY1L/Unicode/tree/main/NotoUnicode)と同じく、字形を表示するための補助フォントとして開発されており、組版への使用は想定していません。CTL を用いてこれらの文字を組版すことは、このプロジェクトの対象外である、同様に、異体字セレクタ（**I**deographs **V**ariation **S**elector, IVS）も本プロジェクトの対象外です。ご関心のある方は、各自で派生フォントを作成することができます。
### 7. このプロジェクトで使用されているTTCフォント（複数のTrueTypeフォントの集合体）は、スマートフォンやソフトウェアで直接使用することができますか？ すべてのフォントスタイルを一度に表示するために、電話にインストールすることはできますか？ ソフトウェアプラットフォーム間で互換性の問題がありますか、それとも特定のプラットフォームに限定されていますか？
- このプロジェクトのTTCフォントはWindowsプラットフォームと互換性があり、そこでシームレスに動作します。ただし、モバイルデバイスでは、通常の方法でTTCフォントファイルを直接インストールすると、テクニカルの制約により通常P1のフォントスタイルのみが表示されることがあります。ソフトウェアアプリケーション内ですべてのフォントスタイルを表示するには、特別な構成が必要な場合があります。TTCフォントとの互換性は、さまざまなプラットフォームで異なる場合があり、追加の手順が必要なことがよくあります。

#### 付属：WindowsプラットフォームにPlangothicをインストールし、グローバルなフォールバックフォントとして設定する方法：

1. TTFバージョンのフォントファイルをダウンロードします（2つの別々のttfファイルまたは単一のttcファイルのどちらかを選択）；
2. ファイルエクスプローラーでフォントファイルを選択し、**右クリック→「すべてのユーザーのためにインストール」（管理者権限が必要で、Windows 11ユーザーは「その他のオプションを表示」をクリックする必要があります）** をクリックしてフォントファイルをインストールします。
3. レジストリファイル `reg/Plangothic-Install.reg`をダウンロードし、ダブルクリックして実行します（管理者権限が必要です）。セキュリティ警告が表示された場合は、「実行」をクリックします。
4. 設定を有効にするには、Windowsシステムアカウントからログアウトしてログインし直します。
5. フォントを削除するには、フォントファイル自体を削除するだけで、レジストリの設定を変更する必要はありません。レジストリコンテンツを削除する場合は、 `reg/Plangothic-Uninstall.reg`ファイルをダウンロードしてダブルクリックして実行します。

#### 付属：モバイル電話にPlangothicをインストールする詳細な手順：

Android フォンに Plangothic TTC フォントをインストールする手順：
1. 現在の電話システムの `/system/etc/fonts.xml` と `/system/etc/font_fallback.xml` ファイルをバックアップします（有であれば）；
2. `system/etc/fonts.xml` と `/system/etc/font_fallback.xml` ファイルを開きます；
3. `</family>` の終了タグ `<family lang="ko">`, の直後に新しい行を挿入します；
4. 次のXMLコードスニペットを適切なインデントで追加してください：
``` xml
    <family>
        <font weight="400" style="normal" index="0">Plangothic.ttc</font>
        <font weight="400" style="normal" index="1">Plangothic.ttc</font>
    </family>
``` 
これらのステップを完了したら、電話を再起動して変更を適用します。問題が発生した場合、フォントファイルが正しく更新されていることを確認し、デバイスの権限がシステムファイルの変更を許可していることを確認してください。

また、上記の方法はアップル携帯電話のユーザーには**適用されず**、アップル携帯電話のユーザーに対するインストール方法も提供できないことに注意してください、ご了承ください。

## 連絡先
このフォントを使用する過程で何か問題やアドバイスがあれば、フィードバックを歓迎します。プロジェクトにissueを提出することができます（無関係な内容の提出は厳禁）、あるいは以下の連絡先を通じてフィードバックすることができます：
- GitHub：https://github.com/Fitzgerald-Porthmouth-Koenigsegg
- ツイッター：https://twitter.com/Fitzgerald_P_K_/
- メール：374601620@qq.com（代替メール：fitzgeraldkoenigsegg@gmail.com）

## その他の説明
1. いくつかの理由で、Telegram、Discordなどのディスカッショングループはありません。ご不便をおかけして申し訳ありません。
2. 当プロジェクトは常に協力者を募集しています。ぜひ周りの方々にこのプロジェクトのことを広めてください。書体制作に詳しい方も大歓迎です。ぜひ現在のフォントを基によりよいフォントを作り上げましょう。上記の連絡先から作者にご連絡ください。Plangothicの発展は皆様のお力にかかっています。
3. 本プロジェクトのメンバーは専門のフォントデザイナーではないので、フォントの字形構造が見栄えがしない可能性があり、補字は原版に比べて少し違和感があるかもしれません。また、メンバーの時間と精力には限りがあるため、プロジェクトには修繕する余裕がなく、一部の漢字の部品のつなぎ合わせはぎこちないため、フォント自体のデータの正確性と予想されるレンダリング効果があなたのデバイスで完全に再現できるかどうかを保証することはできません。著者は本フォントに対していかなる明示や暗示の保証をしません。また、あなたがこのフォントを使用したことによるいかなるクレーム、損害、または責任に帰すことができる責任も負いません。
4. このフォントに含まれる中国大陸のグリフの一部は、[Unicodeグラフファイル](https://www.unicode.org/charts/)に表示されているフォントに**完全に準拠していません**。気になる場合や納得できない場合は、このフォントを使用しないでください。
5. 本プロジェクトは、主に以下のツールまたはオープンソースフォントプロジェクトの一部またはすべてを使用、ないし参考にしています：
    - [源ノ角ゴシック](https://github.com/adobe-fonts/source-han-sans)。
    - 他の Noto フォント。
    - [上地宏一](https://twitter.com/kamichikoichi)氏による[グリフウィキ](https://glyphwiki.org/wiki/GlyphWiki:%e3%83%a1%e3%82%a4%e3%83%b3%e3%83%9a%e3%83%bc%e3%82%b8)と KAGE Engine。
    - [すきまゴシック](https://oppekebekkanko.booth.pm/items/2117070)。
    - [綿雲飴里](https://github.com/MY1L)氏による[Noto Unicode](https://github.com/MY1L/Unicode/tree/main/NotoUnicode)。
    - [Chiron Hei HK（昭源黑體）](https://github.com/chiron-fonts/chiron-hei-hk)。
    - [奈白不弍](https://github.com/Buernia)氏による[Zhudou-Sans（煮豆黑體）](https://github.com/Buernia/Zhudou-Sans)。
    - [ChiuKong Gothic](https://github.com/ChiuMing-Neko/ChiuKongGothic)。
    - [Nôm Na Tống](https://github.com/nomfoundation/font)。
    - [魏安（Andrew West、アンドリュー・ウェスト）](https://twitter.com/BabelStone)氏による[BabelStone Han](https://www.babelstone.co.uk/Fonts/index.html)。
    - [白易](https://github.com/yi-bai)氏による[Zitools](https://zi.tools)。
    - [Gothic Nguyen](https://github.com/TKYKmori/Gothic-Nguyen)。
    - [Unicodeグラフファイル](https://www.unicode.org/charts/)。
    - [Unihanデータベース](https://www.unicode.org/Public/16.0.0/ucd/Unihan.zip)。
    - [Losketch](https://github.com/Losketch)氏による[落尘無襯](https://github.com/Losketch/LorchinSans)。
6. このプロジェクトの文字データは[Hulenkius](https://github.com/Hulenkius)によって SVG ファイルを使用してオンラインで提供されています。ユーザーは「<https://seeki.vistudium.top/SVG/{小文字の漢字の 16 進コードポイント}.svg>」リンクを使用して取得することができます。

    例：`<img src="https://seeki.vistudium.top/SVG/2ebf0.svg"/>`の表示結果は次のようになります：
<div align="center"><img src="https://seeki.vistudium.top/SVG/2ebf0.svg" width="20%"/></div>

> [!IMPORTANT]
>  - オンラインの SVG ファイルには、CJK 統合漢字拡張 B 領域から CJK 統合漢字拡張 I までの文字しか含まれていません。
>  - オンラインの SVG ファイルは、このプロジェクトの更新と完全に同期しているわけではないので、適宜ご利用ください。
## 「プランニヴァース」（Planiverse）について
このフォントファミリーは、Fitzgerald によって 2023 年 12 月に作成され、現在は次のサブフォントプロジェクトが含まれています：
1. **Plangothic Project（プランゴシック・プロジェクト、中国語：遍黒體項目、遍黑体项目）**：源ノ角ゴシックの中国大陸版をベースに、CJK 統合漢字拡張ブロックを補完するゴシック体フォントの作成を目指すプロジェクトです。
    - **プロジェクトステータス**：プロジェクト本体とプロジェクトホームページを作成しましたが、完了していません。
2. **Planwritzen Project（プランライト・プロジェクト、中国語：遍蕤體項目、遍蕤体项目）**：Fitzgerald 独自の手書き体ベースに、プランゴシック・プロジェクト中のグリフを標準とするフォントプロジェクトであり、その文字収録範囲は暫定的源ノ角ゴシック+プランゴシック・プロジェクト（または文字範囲の拡張が可能）。
    - **プロジェクトステータス**：プロジェクト本体は作成されていますが、プロジェクトホームページは作成されていません。
3. **Planschrift Project（プランシェフト・プロジェクト、中国語：遍玨體項目、遍玨体项目）**：Huiwen-Mincho（匯文明朝）ベースに、CJK 統合漢字拡張ブロックを補完するフォントの作成を目指すプロジェクトです、その文字収録範囲は暫定的に匯文明朝体の文字範囲をベースにして源ノ角ゴシック+プランゴシック・プロジェクトに拡張すると暫定的に設定されている。
    - **プロジェクトステータス**：プロジェクト本体と[プロジェクトホームページ](https://github.com/Fitzgerald-Porthmouth-Koenigsegg/Planschrift_Project)を作成しましたが、完了していません。
4. **Planseal Project（プランシール・プロジェクト、中国語：遍篆體項目、遍篆体项目）**：『説文解字』小篆ベースに、CJK 統合漢字拡張ブロックを補完するフォントの作成を目指すプロジェクトです。
    - **プロジェクトステータス**：プロジェクト本体とプロジェクトホームページは作成されておらず、プロジェクト名は暫定的である。
5. **Planicon Project（プランイコン・プロジェクト、中国語：遍象體項目、遍象体项目）**：Zitoolsにおける漢字アイコンの一部にベースづくグリフ補足のプロジェクト，その文字収録範囲は暫定的に URO と拡張 A であり、そ他 CJK 統合漢字拡张のブロックは部分的にのみ実装されています。
    - **プロジェクトステータス**：プロジェクト本体は作成されていますが、プロジェクトホームページは作成されていません、プロジェクト名は暫定的である。
6. **Plantsing Project（プランツィン・プロジェクト、中国語：遍擎體項目、遍擎体项目）**：武英殿版『康熙字典』ベースに、CJK 統合漢字拡張ブロックを補完するフォントの作成を目指すプロジェクトです、その文字収録範囲は暫定的にプランゴシック・プロジェクトと整列する。
    - **プロジェクトステータス**：プロジェクト本体とプロジェクトホームページは作成されておらず。
7. **Planhangul Project（プランハングル・プロジェクト、中国語：遍訓體項目、遍训体项目）**：源ノ角ゴシックベースに、漢字の形式で韓國文の字形制作を行うプロジェクトでは、その文字収録範囲は暫定的に基本韓國文と拡張韓國文となっている。
    - **プロジェクトステータス**：プロジェクト本体とプロジェクトホームページは作成されておらず、プロジェクト名は暫定的である。
8. **Planfixibit Project（プランフィジビト・プロジェクト、中国語：遍繕體項目、遍缮体项目）**：[Fixedsys Excelsior](https://github.com/kika/fixedsys)に基づいて、最新バージョンのUnicodeをフォローし、文字補足の項目を行います。
    - **项目状态**：プロジェクト本体とプロジェクトホームページは作成されておらず、プロジェクト名は暫定的である。
> [!WARNING]
>
> 1. 厳密な意味では、プランイコン・プロジェクトとプランフィジビト・プロジェクトは「プランニヴァース」に収録される要件には適合していないが、便宜上、このプロジェクトをの家族に組み込んでいる。
> 2. プランイコン・プロジェクト、プランコウキジ・プロジェクト、プランフィジビト・プロジェクトは著作権紛争が生じやすいと疑われており、保留できるかどうかは議論を待たなければならない。