<div align="center">

![Image text](https://github.com/Fitzgerald-Porthmouth-Koenigsegg/Plangothic/blob/main/pic/31fix.svg)

[Simplified Chinese / 简体中文](README.md) | [Japanese / 日本語](README.ja.md) | [Traditional Chinese / 繁體中文](README.zh.hant.md)

# Plangothic Project
[![视频介绍](https://img.shields.io/badge/Video%20introduction-00a1d6?logo=Bilibili&logoColor=ffffff)](https://www.bilibili.com/video/BV1Dr4y1V7b7)
[![下载](https://img.shields.io/github/release/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project?color=critical&label=Release&logo=data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA3LjQyIDcuNDIiPjxjaXJjbGUgY3g9IjMuNzEiIGN5PSIzLjcyIiByPSIzLjciIGZpbGw9IiNjNzVjNWMiLz48cGF0aCBmaWxsPSIjZmZmIiBkPSJtMy4yIDEuNTcgMS4wNS0uMDF6bTEuMDUtLjAxdjEuNTdoLjU4TDMuNzIgNC43IDIuNTcgMy4xMmguNjJWMS41OGMtLjczLjIyLTEuMjcuODgtMS4yOCAxLjY0aC0uMTZjLS40NSAwLS44Mi40OC0uODIgMS4wNiAwIC42LjY4IDEuMDcuODIgMS4wN2gzLjg4Yy4xMiAwIC44Mi0uNDguODItMS4wNyAwLS41OC0uMzctMS4wNi0uODMtMS4wNmgtLjA5YzAtLjc3LS41NC0xLjQ0LTEuMjgtMS42NVoiLz48L3N2Zz4=)](https://github.com/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project/releases/latest)
[![总下载](https://img.shields.io/github/downloads/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project/total.svg?color=critical&label=Total%20download&logo=data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA3LjQyIDcuNDIiPjxjaXJjbGUgY3g9IjMuNzEiIGN5PSIzLjcyIiByPSIzLjciIGZpbGw9IiNjNzVjNWMiLz48cGF0aCBmaWxsPSIjZmZmIiBkPSJtMy4yIDEuNTcgMS4wNS0uMDF6bTEuMDUtLjAxdjEuNTdoLjU4TDMuNzIgNC43IDIuNTcgMy4xMmguNjJWMS41OGMtLjczLjIyLTEuMjcuODgtMS4yOCAxLjY0aC0uMTZjLS40NSAwLS44Mi40OC0uODIgMS4wNiAwIC42LjY4IDEuMDcuODIgMS4wN2gzLjg4Yy4xMiAwIC44Mi0uNDguODItMS4wNyAwLS41OC0uMzctMS4wNi0uODMtMS4wNmgtLjA5YzAtLjc3LS41NC0xLjQ0LTEuMjgtMS42NVoiLz48L3N2Zz4=)](https://github.com/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project/releases/latest)
[![星标](https://img.shields.io/github/stars/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project?label=Stars&color=critical&logo=data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA3LjQ1IDcuNyI+PHBhdGggZmlsbD0iI2ZmZDAwMCIgZD0iTTUuOTkgNy42NSAzLjc4IDYuMTIgMS40IDcuNjJsLjY3LTIuNzVMLjAyIDIuODhsMi42Mi0uMTZMMy43NSAwbC45NiAyLjY1IDIuNzMuMy0yLjAzIDEuOHoiLz48L3N2Zz4=)](https://github.com/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project)
[![License](https://img.shields.io/static/v1?label=License&message=SIL%20Open%20Font%20License&color=critical&logo=creative%20commons)](https://github.com/Fitzgerald-Porthmouth-Koenigsegg/Plangothic-Project/blob/main/LICENSE)
</div>

## Overview
Plangothic Project (Chinese: 遍黑体项目) is based on [Source Han Sans](https://github.com/adobe-fonts/source-han-sans) CN and takes the Chinese Mainland variant ideographs as the standard to supplement the CJK Unified Ideographs Extension blocks. Initiated around June 2020.

## Coverage
This font mainly supports all CJK ideographs from extension B to extension J, with sporadic character in other blocks.

> [!WARNING]
>
> This font is currently uncompleted and still lacks large numbers of CJK ideographs.
## Contributors
- Main: **[Fitzgerald](https://github.com/Fitzgerald-Porthmouth-Koenigsegg)**, [Usagixineist](https://github.com/Usagixineist), [Cod'dte](https://github.com/buwuzhengyedexiaoji), [PakMa Tsyn](https://github.com/PakMaTsyn)
- Collab: Magnetshroom、[Mukuro](https://github.com/Hayashizawa), [Humework](https://github.com/Humework-Gollayosh-Carzonharch-Hu)
- Assistants: [0xAA55](https://github.com/0xAA55), [Baysoftware](https://github.com/yi-bai), Boris Ivanovich, [Henry Chan](https://github.com/hfhchan), [Hulenkius](https://github.com/Hulenkius), [Siphercase](https://github.com/Siphercase), [Losketch](https://github.com/Losketch)

There are also many other people who have supported and participated in the project. We would like to thank them.

## License
This font is published under the [SIL Open Font License](https://openfontlicense.org/open-font-license-official-text/). Please refer to the [LICENSE](LICENSE) for details.

### You can:
- Any individual, group, organization, or enterprise may use it for commercial and non-commercial purposes free of charge, without the need to pay fees, inform the author in advance, indicate the source information, or obtain the author's permission.
- Republish or install font files, embed them into any software or device, and the software or device can be redistributed or resold.
- Modify, expand, and convert font files, but it is **strictly prohibited to use the reserved names "Plangothic" and "遍黑" for the font in the works that have been modified twice**. The version that has been modified twice **must also be published under the SIL Open Font License** (if only the source font is converted, the reserved name can still be used).

### You cannot:
- Sell any part of the font file (including but not limited to glyphs, OpenType feature) for resale, including but not limited to selling the font file separately, bundling it with other fonts, requiring payment for special permissions to use the font, etc.
- Publish any part of the font file under a non SIL Open Font License.
- Using this font file or its derivatives to harm the normal operation of computer systems (including but not limited to embedding computer viruses in font files, subjectively intentionally exploiting vulnerabilities in programs or systems to disrupt the normal operation of computer systems, etc.).
- Use this font for purposes that violate local laws and regulations.
- Other behaviors that violate the SIL Open Font License that are not listed above.

### Attention:
- Any individual, enterprise, team, etc. who uses, copies, modifies, distributes this font or conducts any behavior conforming to the provisions of the SIL Open Font License, and the recipient who uses, downloads, or exercises the rights specified in the contract, shall be deemed to have agreed to comply with all the provisions of the SIL Open Font License by default.
- This font is a free commercial font. **Any behavior that requires payment to obtain this font is considered fraudulent. Beware of being deceived**. If you obtained this font for payment, please report it immediately and assist relevant judicial authorities if necessary.
- The author's failure to exercise, timely exercise, or fully exercise the legitimate rights enjoyed by the SIL Open Font License shall not be deemed as a waiver of such rights, nor shall it affect the author's future exercise of such rights.
- This font does not contain any political intentions, metaphors, or purposes, and is not related to any political activities. The author shall not be liable for any joint legal liability arising from the use of this font.

## FAQ
### 1. Why are there two font files for Plangothic?
- Because the maximum number of glyphs a font can hold is limited (to 65535), while the total count of CJK ideographs is much greater than this value.
### 2. What is the difference between *fallback* and *allideo* versions for P1?
- The *fallback* version is suitable for users who currently have installed fonts that **CAN DISPLAY** all CJK ideographs, and the CJK ideographs we have not included will be empty. The *allideo* version is suitable for users who currently have installed fonts that **CANNOT DISPLAY** all CJK ideographs, in which the CJK ideographs that have **NOT** been included will be supplement by the Hanazono Mincho. Both files can be used to find out our current progress. When this project has completely covered all CJK ideographs, the *fallback* file will be removed.
### 3. Why P1 is divided into two types?
- Because all characters in extensions G, extensions H and extensions J covered by P2, have been included, so there is no need to divide P2.
### 4. Why does this project just include a small amount of CJK ideographs in the URO and extensions A?
- Since the purpose of this project is "supplement all the extension blocks of CJK Unified Ideographs based on [Source Han Sans](https://github.com/adobe-fonts/source-han-sans) CN", needs of using CJK ideographs in the URO and Extension A blocks can be solved by directly using the Source Han Sans font. As for these CJK ideographs scattered in the URO and Extension A, included in this project are CJK ideographs with glyph changes in Unicode or inconsistent with the purpose of this project. Before adding these CJK ideographs to the project, they have been compared with other mainstream fonts and glyphs in the Unicode.
### 5. Will there be a version containing other weights (or other local glyphs) in the future?
- Since the quantities of this project are too large, so this request is not in our reach by now. If you have such ideas, you can make a derivative font version of the project with your requirements.
### 6. Why is there no ℂomplex 𝕋ext 𝕃ayout (CTL) and 𝕀deographs 𝕍ariation 𝕊electors (IVS) in this font?
- The fonts of this project orientate themselves as pragmatic tool fonts, that is they are not responsible for precise typesetting but only for display (see [Unifont](https://unifoundry.com/unifont) and [Noto Unicode](https://github.com/MY1L/Unicode/tree/main/NotoUnicode) developed by [My1l](https://github.com/MY1L)). Using CTL to typeset and display these scripts, and displaying regional variation ideographs other than the CN variant using IVSs is OUTSIDE the coverage of the project. If you have such ideas, you can produce derivation fonts of this project by yourself if in need.
### 7. Can the TTC font from this project (a collection of multiple TrueType fonts) be directly used on smartphones or within software? Can it be installed on a phone to display all font styles simultaneously? Are there compatibility issues across software platforms or is it limited to specific platforms?
- The TTC font from this project is compatible with Windows platforms and works seamlessly there. However, on mobile devices, directly installing a TTC font file typically results in displaying only one font style (usually P1) due to technical constraints. To display all font styles within software applications, special configurations may be required. Compatibility with TTC fonts can vary across different platforms, often requiring additional steps. Detailed instructions for installing Plangothic on an Android phone are provided here.

#### P.S.: How to install Plangothic font on the Windows platform and set it as the global fallback font:

1. Download the TTF version of the font file (choose either two separate ttf files or a single ttc file).
2. In File Explorer, select the font file, then **click right mouse button→"Install for all users"(requires administrator privileges, Windows 11 users also need to click "Show more options")** to install the font file.
3. Download the registry file `reg/Plangothic-Install.reg`, double-click to run it (requires administrator privileges), and if a security warning appears, click "Run".
4. Log out and log back in to the Windows system account for the settings to take effect.
5. To delete the font, simply delete the font file itself, and there is no need to change the registry settings. If you want to delete the registry content, download the file `reg/Plangothic-Uninstall.reg`and double-click to run it.

#### P.S.: Method for installing the Plangothic on the phone:

To install the Plangothic TTC font on an Android phone, follow these steps:
1. Backup the `/system/etc/fonts.xml` and `/system/etc/font_fallback.xml` files of your current phone system (if available).
2. Open the `system/etc/fonts.xml` and `/system/etc/font_fallback.xml` files.
3. After the closing `</family>` tag of `<family lang="ko">`, insert a new line.
4. Add the following XML code snippet with correct indentation:
``` xml
    <family>
        <font weight="400" style="normal" index="0">Plangothic.ttc</font>
        <font weight="400" style="normal" index="1">Plangothic.ttc</font>
    </family>
``` 
After completing these steps, restart your phone to apply the changes. If you encounter issues, verify that the font files have been correctly updated and ensure that your device permissions allow modifications to system files.

Please note that the above methods are **NOT applicable** to Apple phone users and cannot provide installation methods for Apple phone users. We apologize for any inconvenience caused.

## Contact
If you have any questions or suggestions during the use of this font, please feel free to provide feedback. You can submit an issue in the project (unrelated content is strictly prohibited), or you can provide feedback through the following contact information:
- GitHub: https://github.com/Fitzgerald-Porthmouth-Koenigsegg
- Twitter: https://twitter.com/Fitzgerald_P_K_/
- E-mails: 374601620@qq.com (Backup email: fitzgeraldkoenigsegg@gmail.com)

## Other instructions
1. Due to certain reasons, we DO NOT have any discussion groups (Telegram, Discord, etc.), and we deeply apologize for any inconvenience caused to you.
2. This is a long-term project. We would be grateful if you could promote the project to others. We also welcome technical personnels in font production and accept you to continue to improve this project. You can contact the author through said information. The development of this project is inseparable from your publicity and encouragement.
3. The members of this project are not professional font designers, so the font structure may not be aesthetically pleasing, and the added text may have a slight inconsistency compared to the original version. In addition, due to the limited time and energy of the members, there is no extra time for the project to refine. Some parts of the Chinese characters will be assembled very rigidly. Therefore, we cannot guarantee the accuracy of the font data and whether the expected presentation effect can be perfectly reproduced on your device. The author makes no express or implied warranties about this font, nor assumes any responsibility for any claims, damages, or attributable reasons arising from your use of this font.
4. Some of the Chinese Mainland glyphs included in this font **DO NOT** fully follow the fonts displayed in the [Unicode charts file](https://www.unicode.org/charts/). If you mind or cannot accept, please do not use this font.
5. This project borrows and/or refers to other tools and/or open-source font projects in part or whole, mainly including:
    - [Source Han Sans](https://github.com/adobe-fonts/source-han-sans).
    - Other fonts in the Noto series.
    - [Glyphwiki](https://glyphwiki.org/wiki/GlyphWiki:%e3%83%a1%e3%82%a4%e3%83%b3%e3%83%9a%e3%83%bc%e3%82%b8) and KAGE Engine developed by [Kamichi Koichi](https://twitter.com/kamichikoichi).
    - [Sukima Gothic (すきまゴシック)](https://oppekebekkanko.booth.pm/items/2117070).
    - [Noto Unicode](https://github.com/MY1L/Unicode/tree/main/NotoUnicode) developed by [My1l](https://github.com/MY1L).
    - [Chiron Hei HK](https://github.com/chiron-fonts/chiron-hei-hk)。
    - [Zhudou-Sans](https://github.com/Buernia/Zhudou-Sans) developed by [Buernia](https://github.com/Buernia).
    - [ChiuKong Gothic](https://github.com/ChiuMing-Neko/ChiuKongGothic).
    - [Nôm Na Tống](https://github.com/nomfoundation/font).
    - [BabelStone Han](https://www.babelstone.co.uk/Fonts/index.html) developed by [Andrew West](https://twitter.com/BabelStone).
    - [Zitools](https://zi.tools) developed by [Yi Bai](https://github.com/yi-bai).
    - [Gothic Nguyen](https://github.com/TKYKmori/Gothic-Nguyen).
    - [Unicode charts file](https://www.unicode.org/charts/).
    - [Unihan database](https://www.unicode.org/Public/16.0.0/ucd/Unihan.zip).
    - [Lorchin Sans](https://github.com/Losketch/LorchinSans) developed by [Losketch](https://github.com/Losketch).
6. The glyphs data of this project is provided online by [Hulenkius](https://github.com/Hulenkius) through SVG files. Users can obtain them through the link "https://seeki.vistudium.top/SVG/{lowercase_glyphs_hexadecimal_code}.svg".

    For example, the display result of `<img src="https://seeki.vistudium.top/SVG/2ebf0.svg"/>` will be:
<div align="center"><img src="https://seeki.vistudium.top/SVG/2ebf0.svg" width="20%"/></div>

> [!IMPORTANT]
>  - The online SVG files only include CJK Unified Ideographs Extension blocks B to Extension I.
>  - The online SVG files may not simultaneously synchronize with the updates of this project, please use with discreation.

## About "The Planiverse"
Founded by Fitzgerald in December 2023 and includes several sub-projects currently as follows:
1. **Plangothic Project (Chinese: 遍黑体项目)**: Based on Source Han Sans CN and takes the CN variant as the standard to supplement the CJK Unified Ideographs Extension blocks.
    - **Status**: Created project and its homepage. Uncompleted.
2. **Planwritzen Project (Chinese: 遍蕤体项目)**: Based on Fitzgerald's own handwriting and using the Plangothic Project as the standard. Character range set to align with the Source Han Sans + Plangothic Project temporarily (or there may be an extension).
    - **Status**: Created project without homepage. Uncompleted.
3. **Planschrift Project (Chinese: 遍玨体项目)**: Based on Huiwen-mincho supplementing the CJK Unified Ideographs Extension blocks. Temporary character range expanded from the range of Huiwen-mincho to Source Han Sans + Plangothic Project.
    - **Status**: Created project and its [homepage](https://github.com/Fitzgerald-Porthmouth-Koenigsegg/Planschrift_Project). Uncompleted.
4. **Planseal Project (Chinese: 遍篆体项目)**: Based on the seal script in *Shuowen Jiezi* and as the standard to supplement the CJK Unified Ideographs Extension blocks.
    - **Status**: Not created. Name tentative.
5. **Planicon Project (Chinese: 遍象体项目)**: Based on CJK ideographs icons in the [Zi.tools](https://zi.tools/) and as the standard to supplement the CJK Unified Ideographs Extension blocks. Temporary character range set to URO and Extension A. Other ideographs are partly available.
    - **Status**: Not created. Name tentative.
6. **Plantsing Project (Chinese: 遍擎体项目)**: Based on the Wuying Hall version of *Kangxi Dictionary* and as the standard to supplement the CJK Unified Ideographs Extension blocks. Temporary character range set to align with the Plangothic Project.
    - **Status**: Not created.
7. **Planhangul Project (Chinese: 遍训体项目)**: Based on Source Han Sans CN, creating Hangul in the form of CJK ideographs. Temporary  character range set to Hangul and Hangul Extension.
    - **Status**: Not created. Name tentative.
8. **Planfixibit Project (Chinese: 遍缮体项目)**: Based on [Fixedsys Excelsior](https://github.com/kika/fixedsys), Follow up on the latest version of Unicode and implement character supplementation projects.
    - **Status**: Not created. Name tentative.
> [!WARNING]
>
> 1. Strictly speaking, Planicon Project and Planfixibit Project does not meet the requirements for "The Planiverse", but still included for convenience.
> 2. Prone to Planicon Project, Plankangxi Project, and Planfixibit Project copyright disputes, its reservation needs to be discussed.
