/**
 * File was inspired by: https://github.com/mProjectsCode/obsidian-meta-bind-plugin/blob/master/automation/build/buildBanner.ts
 */
import * as Bun from "bun";

export async function banner(buildType: string) {
	const manifest = await Bun.file("manifest.json").json();

	return `/*
=======================================================
THIS IS A GENERATED/BUNDLED FILE BY ESBUILD
if you want to view the source, please visit the github repository of this plugin at https://github.com/Fevol/obsidian-translate
	
  ${manifest.name} — ${manifest.version} [${buildType.toUpperCase()} BUILD]
	Author: ${manifest.author}
	Version: ${manifest.version}
	Time: ${new Date().toUTCString()}
	
=======================================================
*/
`;
}
