/***************************************************************************
 *                                                                         *
 *   Copyright (C) 2017  Seamly, LLC                                       *
 *                                                                         *
 *   https://github.com/fashionfreedom/seamly2d                             *
 *                                                                         *
 ***************************************************************************
 **
 **  Seamly2D is free software: you can redistribute it and/or modify
 **  it under the terms of the GNU General Public License as published by
 **  the Free Software Foundation, either version 3 of the License, or
 **  (at your option) any later version.
 **
 **  Seamly2D is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **
 **  You should have received a copy of the GNU General Public License
 **  along with Seamly2D.  If not, see <http://www.gnu.org/licenses/>.
 **
 **************************************************************************

 ************************************************************************
 **
 **  @file   tst_tstranslation.h
 **  @author Roman Telezhynskyi <dismine(at)gmail.com>
 **  @date   13 12, 2015
 **
 **  @brief
 **  @copyright
 **  This source code is part of the Valentine project, a pattern making
 **  program, whose allow create and modeling patterns of clothing.
 **  Copyright (C) 2015 Seamly2D project
 **  <https://github.com/fashionfreedom/seamly2d> All Rights Reserved.
 **
 **  Seamly2D is free software: you can redistribute it and/or modify
 **  it under the terms of the GNU General Public License as published by
 **  the Free Software Foundation, either version 3 of the License, or
 **  (at your option) any later version.
 **
 **  Seamly2D is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **
 **  You should have received a copy of the GNU General Public License
 **  along with Seamly2D.  If not, see <http://www.gnu.org/licenses/>.
 **
 *************************************************************************/

#ifndef TST_TSTRANSLATION_H
#define TST_TSTRANSLATION_H

#include <QDomDocument>
#include <QFile>
#include <QObject>
#include <QSharedPointer>

class TST_TSTranslation : public QObject
{
    Q_OBJECT
public:
    explicit TST_TSTranslation(QObject *parent = nullptr);

private slots:
    void CheckEnglishLocalization_data();
    void CheckEnglishLocalization();
    void CheckEmptyToolButton_data();
    void CheckEmptyToolButton();
    void CheckPlaceMarkerExist_data();
    void CheckPlaceMarkerExist();
    void TestPunctuation_data();
    void TestPunctuation();
    void TestHTMLTags_data();
    void TestHTMLTags();

private:
    Q_DISABLE_COPY(TST_TSTranslation)
    QSharedPointer<QFile> tsFile;
    QSharedPointer<QDomDocument> tsXML;

    static const QString TagName;
    static const QString TagMessage;
    static const QString TagSource;
    static const QString TagTranslation;

    static const QString AttrType;
    static const QString AttrValVanished;
    static const QString AttrValUnfinished;
    static const QString AttrValObsolete;

    QDomNodeList LoadTSFile(const QString &filename);
};

#endif // TST_TSTRANSLATION_H
