//-----------------------------------------------------------------------------
//  @file   dialogcutarc.cpp
//  @author Douglas S Caskey
//  @date   14 Aug, 2023
//
//  @copyright
//  Copyright (C) 2017 - 2024 Seamly, LLC
//  https://github.com/fashionfreedom/seamly2d
//
//  @brief
//  Seamly2D is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  Seamly2D is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with Seamly2D. If not, see <http://www.gnu.org/licenses/>.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//  @file   dialogcutarc.cpp
//  @author Roman Telezhynskyi <dismine(at)gmail.com>
//  @date   7 1, 2014
//
//  @copyright
//  Copyright (C) 2013 Valentina project.
//  This source code is part of the Valentina project, a pattern making
//  program, whose allow create and modeling patterns of clothing.
//  <https://bitbucket.org/dismine/valentina> All Rights Reserved.
//
//  Valentina is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, either version 3 of the License,
//  or (at your option) any later version.
//
//  Valentina is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with Valentina.  If not, see <http://www.gnu.org/licenses/>.
//-----------------------------------------------------------------------------

#ifndef DIALOGCUTARC_H
#define DIALOGCUTARC_H

#include <qcompilerdetection.h>
#include <QMetaObject>
#include <QObject>
#include <QString>
#include <QtGlobal>

#include "../vmisc/def.h"
#include "dialogtool.h"

namespace Ui
{
    class DialogCutArc;
}

//---------------------------------------------------------------------------------------------------------------------
/// @brief The DialogCutArc class dialog for ToolCutArc.
//---------------------------------------------------------------------------------------------------------------------
class DialogCutArc : public DialogTool
{
    Q_OBJECT
public:
                       DialogCutArc(const VContainer *data, const quint32 &toolId, QWidget *parent = nullptr);
    virtual           ~DialogCutArc() Q_DECL_OVERRIDE;

    void               SetPointName(const QString &value);

    QString            getDirection() const;
    void               setDirection(const QString &value);

    QString            GetFormula() const;
    void               SetFormula(const QString &value);

    quint32            getArcId() const;
    void               setArcId(const quint32 &value);

    QString            getLineColor() const;
    void               setLineColor(const QString &value);

public slots:
    virtual void       ChosenObject(quint32 id, const SceneObject &type) Q_DECL_OVERRIDE;

    /// @brief DeployFormulaTextEdit grow or shrink formula input.
    void               DeployFormulaTextEdit();

    /// @brief FormulaTextChanged when formula text changes for validation and calc.
    void               FormulaTextChanged();
    void               FXLength();

protected:
    virtual void       ShowVisualization() Q_DECL_OVERRIDE;

    /// @brief SaveData Put dialog data in local variables
    virtual void       SaveData() Q_DECL_OVERRIDE;
    virtual void       closeEvent(QCloseEvent *event) Q_DECL_OVERRIDE;

private:
    Q_DISABLE_COPY(DialogCutArc)
    /// @brief ui keeps information about user interface.
    Ui::DialogCutArc  *ui;

    /// @brief formula string with formula.
    QString            formula;

    /// @brief formulaBaseHeight base height defined by dialogui.
    int                formulaBaseHeight;
};

#endif // DIALOGCUTARC_H
