/***************************************************************************
 **  @file   dialogs.h
 **  @author Douglas S Caskey
 **  @date   Dec 11, 2022
 **
 **  @copyright
 **  Copyright (C) 2017 - 2022 Seamly, LLC
 **  https://github.com/fashionfreedom/seamly2d
 **
 **  @brief
 **  Seamly2D is free software: you can redistribute it and/or modify
 **  it under the terms of the GNU General Public License as published by
 **  the Free Software Foundation, either version 3 of the License, or
 **  (at your option) any later version.
 **
 **  Seamly2D is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **
 **  You should have received a copy of the GNU General Public License
 **  along with Seamly2D. If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

/************************************************************************
 **
 **  @file   dialogs.h
 **  @author Roman Telezhynskyi <dismine(at)gmail.com>
 **  @date   16 6, 2015
 **
 **  @brief
 **  @copyright
 **  This source code is part of the Valentina project, a pattern making
 **  program, whose allow create and modeling patterns of clothing.
 **  Copyright (C) 2015 Valentina project
 **  <https://bitbucket.org/dismine/valentina> All Rights Reserved.
 **
 **  Valentina is free software: you can redistribute it and/or modify
 **  it under the terms of the GNU General Public License as published by
 **  the Free Software Foundation, either version 3 of the License, or
 **  (at your option) any later version.
 **
 **  Valentina is distributed in the hope that it will be useful,
 **  but WITHOUT ANY WARRANTY; without even the implied warranty of
 **  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **  GNU General Public License for more details.
 **
 **  You should have received a copy of the GNU General Public License
 **  along with Valentina.  If not, see <http://www.gnu.org/licenses/>.
 **
 *************************************************************************/

#ifndef TOOLDIALOGS_H
#define TOOLDIALOGS_H

#include "tools/dialogalongline.h"
#include "tools/dialogarc.h"
#include "tools/dialogarcwithlength.h"
#include "tools/dialogbisector.h"
#include "tools/piece/pattern_piece_dialog.h"
#include "tools/dialogendline.h"
#include "tools/dialogline.h"
#include "tools/dialoglineintersect.h"
#include "tools/dialognormal.h"
#include "tools/dialogpointofcontact.h"
#include "tools/dialogshoulderpoint.h"
#include "tools/dialogsinglepoint.h"
#include "tools/dialogspline.h"
#include "tools/dialogcubicbezier.h"
#include "tools/dialogsplinepath.h"
#include "tools/dialogcubicbezierpath.h"
#include "tools/dialogheight.h"
#include "tools/dialogcutarc.h"
#include "tools/dialogcutspline.h"
#include "tools/dialogcutsplinepath.h"
#include "tools/union_dialog.h"
#include "tools/dialogtriangle.h"
#include "tools/point_intersectxy_dialog.h"
#include "tools/dialoglineintersectaxis.h"
#include "tools/dialogcurveintersectaxis.h"
#include "tools/dialogpointofintersectionarcs.h"
#include "tools/intersect_circles_dialog.h"
#include "tools/dialogpointofintersectioncurves.h"
#include "tools/intersect_circletangent_dialog.h"
#include "tools/dialogpointfromarcandtangent.h"
#include "tools/dialogtruedarts.h"
#include "tools/editgroup_dialog.h"
#include "tools/addtogroup_dialog.h"
#include "tools/dialogrotation.h"
#include "tools/dialogmirrorbyline.h"
#include "tools/dialogmirrorbyaxis.h"
#include "tools/dialogmove.h"
#include "tools/dialogellipticalarc.h"
#include "tools/piece/dialoginternalpath.h"
#include "tools/anchorpoint_dialog.h"
#include "tools/insert_nodes_dialog.h"

#include "support/edit_formula_dialog.h"
#include "support/dialogundo.h"

#endif // TOOLDIALOGS_H
