/*
 * unidata.h - generated by parseucd.lua
 */
#ifndef unidata_h
#define unidata_h

#ifndef utfint
# define utfint utfint
typedef unsigned int utfint;
#endif

typedef struct range_table {
    utfint first;
    utfint last;
    int step;
} range_table;

typedef struct conv_table {
    utfint first;
    utfint last;
    int step;
    int offset;
} conv_table;

typedef struct nfc_table {
    utfint cp;
    int reason;
    unsigned int data1;
    unsigned int data2;
} nfc_table;

#define REASON_MUST_CONVERT_1 1
#define REASON_MUST_CONVERT_2 2
#define REASON_STARTER_CAN_COMBINE 3
#define REASON_COMBINING_MARK 4
#define REASON_JAMO_VOWEL 5
#define REASON_JAMO_TRAILING 6

typedef struct canon_cls_table {
    utfint first;
    utfint last;
    unsigned int canon_cls;
} canon_cls_table;

typedef struct combine_table {
    utfint hash;
    utfint cp1;
    utfint cp2;
    utfint dest;
} combine_table;

typedef struct decompose_table {
    utfint cp;
    utfint to1;
    utfint to2;
    unsigned int canon_cls2;
} decompose_table;

static struct range_table alpha_table[] = {
    { 0x41, 0x5A, 1 },
    { 0x61, 0x7A, 1 },
    { 0xAA, 0xB5, 11 },
    { 0xBA, 0xC0, 6 },
    { 0xC1, 0xD6, 1 },
    { 0xD8, 0xF6, 1 },
    { 0xF8, 0x2C1, 1 },
    { 0x2C6, 0x2D1, 1 },
    { 0x2E0, 0x2E4, 1 },
    { 0x2EC, 0x2EE, 2 },
    { 0x345, 0x370, 43 },
    { 0x371, 0x374, 1 },
    { 0x376, 0x377, 1 },
    { 0x37A, 0x37D, 1 },
    { 0x37F, 0x386, 7 },
    { 0x388, 0x38A, 1 },
    { 0x38C, 0x38E, 2 },
    { 0x38F, 0x3A1, 1 },
    { 0x3A3, 0x3F5, 1 },
    { 0x3F7, 0x481, 1 },
    { 0x48A, 0x52F, 1 },
    { 0x531, 0x556, 1 },
    { 0x559, 0x560, 7 },
    { 0x561, 0x588, 1 },
    { 0x5B0, 0x5BD, 1 },
    { 0x5BF, 0x5C1, 2 },
    { 0x5C2, 0x5C4, 2 },
    { 0x5C5, 0x5C7, 2 },
    { 0x5D0, 0x5EA, 1 },
    { 0x5EF, 0x5F2, 1 },
    { 0x610, 0x61A, 1 },
    { 0x620, 0x657, 1 },
    { 0x659, 0x65F, 1 },
    { 0x66E, 0x6D3, 1 },
    { 0x6D5, 0x6DC, 1 },
    { 0x6E1, 0x6E8, 1 },
    { 0x6ED, 0x6EF, 1 },
    { 0x6FA, 0x6FC, 1 },
    { 0x6FF, 0x710, 17 },
    { 0x711, 0x73F, 1 },
    { 0x74D, 0x7B1, 1 },
    { 0x7CA, 0x7EA, 1 },
    { 0x7F4, 0x7F5, 1 },
    { 0x7FA, 0x800, 6 },
    { 0x801, 0x817, 1 },
    { 0x81A, 0x82C, 1 },
    { 0x840, 0x858, 1 },
    { 0x860, 0x86A, 1 },
    { 0x870, 0x887, 1 },
    { 0x889, 0x88E, 1 },
    { 0x8A0, 0x8C9, 1 },
    { 0x8D4, 0x8DF, 1 },
    { 0x8E3, 0x8E9, 1 },
    { 0x8F0, 0x93B, 1 },
    { 0x93D, 0x94C, 1 },
    { 0x94E, 0x950, 1 },
    { 0x955, 0x963, 1 },
    { 0x971, 0x983, 1 },
    { 0x985, 0x98C, 1 },
    { 0x98F, 0x990, 1 },
    { 0x993, 0x9A8, 1 },
    { 0x9AA, 0x9B0, 1 },
    { 0x9B2, 0x9B6, 4 },
    { 0x9B7, 0x9B9, 1 },
    { 0x9BD, 0x9C4, 1 },
    { 0x9C7, 0x9C8, 1 },
    { 0x9CB, 0x9CC, 1 },
    { 0x9CE, 0x9D7, 9 },
    { 0x9DC, 0x9DD, 1 },
    { 0x9DF, 0x9E3, 1 },
    { 0x9F0, 0x9F1, 1 },
    { 0x9FC, 0xA01, 5 },
    { 0xA02, 0xA03, 1 },
    { 0xA05, 0xA0A, 1 },
    { 0xA0F, 0xA10, 1 },
    { 0xA13, 0xA28, 1 },
    { 0xA2A, 0xA30, 1 },
    { 0xA32, 0xA33, 1 },
    { 0xA35, 0xA36, 1 },
    { 0xA38, 0xA39, 1 },
    { 0xA3E, 0xA42, 1 },
    { 0xA47, 0xA48, 1 },
    { 0xA4B, 0xA4C, 1 },
    { 0xA51, 0xA59, 8 },
    { 0xA5A, 0xA5C, 1 },
    { 0xA5E, 0xA70, 18 },
    { 0xA71, 0xA75, 1 },
    { 0xA81, 0xA83, 1 },
    { 0xA85, 0xA8D, 1 },
    { 0xA8F, 0xA91, 1 },
    { 0xA93, 0xAA8, 1 },
    { 0xAAA, 0xAB0, 1 },
    { 0xAB2, 0xAB3, 1 },
    { 0xAB5, 0xAB9, 1 },
    { 0xABD, 0xAC5, 1 },
    { 0xAC7, 0xAC9, 1 },
    { 0xACB, 0xACC, 1 },
    { 0xAD0, 0xAE0, 16 },
    { 0xAE1, 0xAE3, 1 },
    { 0xAF9, 0xAFC, 1 },
    { 0xB01, 0xB03, 1 },
    { 0xB05, 0xB0C, 1 },
    { 0xB0F, 0xB10, 1 },
    { 0xB13, 0xB28, 1 },
    { 0xB2A, 0xB30, 1 },
    { 0xB32, 0xB33, 1 },
    { 0xB35, 0xB39, 1 },
    { 0xB3D, 0xB44, 1 },
    { 0xB47, 0xB48, 1 },
    { 0xB4B, 0xB4C, 1 },
    { 0xB56, 0xB57, 1 },
    { 0xB5C, 0xB5D, 1 },
    { 0xB5F, 0xB63, 1 },
    { 0xB71, 0xB82, 17 },
    { 0xB83, 0xB85, 2 },
    { 0xB86, 0xB8A, 1 },
    { 0xB8E, 0xB90, 1 },
    { 0xB92, 0xB95, 1 },
    { 0xB99, 0xB9A, 1 },
    { 0xB9C, 0xB9E, 2 },
    { 0xB9F, 0xBA3, 4 },
    { 0xBA4, 0xBA8, 4 },
    { 0xBA9, 0xBAA, 1 },
    { 0xBAE, 0xBB9, 1 },
    { 0xBBE, 0xBC2, 1 },
    { 0xBC6, 0xBC8, 1 },
    { 0xBCA, 0xBCC, 1 },
    { 0xBD0, 0xBD7, 7 },
    { 0xC00, 0xC0C, 1 },
    { 0xC0E, 0xC10, 1 },
    { 0xC12, 0xC28, 1 },
    { 0xC2A, 0xC39, 1 },
    { 0xC3D, 0xC44, 1 },
    { 0xC46, 0xC48, 1 },
    { 0xC4A, 0xC4C, 1 },
    { 0xC55, 0xC56, 1 },
    { 0xC58, 0xC5A, 1 },
    { 0xC5D, 0xC60, 3 },
    { 0xC61, 0xC63, 1 },
    { 0xC80, 0xC83, 1 },
    { 0xC85, 0xC8C, 1 },
    { 0xC8E, 0xC90, 1 },
    { 0xC92, 0xCA8, 1 },
    { 0xCAA, 0xCB3, 1 },
    { 0xCB5, 0xCB9, 1 },
    { 0xCBD, 0xCC4, 1 },
    { 0xCC6, 0xCC8, 1 },
    { 0xCCA, 0xCCC, 1 },
    { 0xCD5, 0xCD6, 1 },
    { 0xCDD, 0xCDE, 1 },
    { 0xCE0, 0xCE3, 1 },
    { 0xCF1, 0xCF3, 1 },
    { 0xD00, 0xD0C, 1 },
    { 0xD0E, 0xD10, 1 },
    { 0xD12, 0xD3A, 1 },
    { 0xD3D, 0xD44, 1 },
    { 0xD46, 0xD48, 1 },
    { 0xD4A, 0xD4C, 1 },
    { 0xD4E, 0xD54, 6 },
    { 0xD55, 0xD57, 1 },
    { 0xD5F, 0xD63, 1 },
    { 0xD7A, 0xD7F, 1 },
    { 0xD81, 0xD83, 1 },
    { 0xD85, 0xD96, 1 },
    { 0xD9A, 0xDB1, 1 },
    { 0xDB3, 0xDBB, 1 },
    { 0xDBD, 0xDC0, 3 },
    { 0xDC1, 0xDC6, 1 },
    { 0xDCF, 0xDD4, 1 },
    { 0xDD6, 0xDD8, 2 },
    { 0xDD9, 0xDDF, 1 },
    { 0xDF2, 0xDF3, 1 },
    { 0xE01, 0xE3A, 1 },
    { 0xE40, 0xE46, 1 },
    { 0xE4D, 0xE81, 52 },
    { 0xE82, 0xE86, 2 },
    { 0xE87, 0xE8A, 1 },
    { 0xE8C, 0xEA3, 1 },
    { 0xEA5, 0xEA7, 2 },
    { 0xEA8, 0xEB9, 1 },
    { 0xEBB, 0xEBD, 1 },
    { 0xEC0, 0xEC4, 1 },
    { 0xEC6, 0xECD, 7 },
    { 0xEDC, 0xEDF, 1 },
    { 0xF00, 0xF40, 64 },
    { 0xF41, 0xF47, 1 },
    { 0xF49, 0xF6C, 1 },
    { 0xF71, 0xF83, 1 },
    { 0xF88, 0xF97, 1 },
    { 0xF99, 0xFBC, 1 },
    { 0x1000, 0x1036, 1 },
    { 0x1038, 0x103B, 3 },
    { 0x103C, 0x103F, 1 },
    { 0x1050, 0x108F, 1 },
    { 0x109A, 0x109D, 1 },
    { 0x10A0, 0x10C5, 1 },
    { 0x10C7, 0x10CD, 6 },
    { 0x10D0, 0x10FA, 1 },
    { 0x10FC, 0x1248, 1 },
    { 0x124A, 0x124D, 1 },
    { 0x1250, 0x1256, 1 },
    { 0x1258, 0x125A, 2 },
    { 0x125B, 0x125D, 1 },
    { 0x1260, 0x1288, 1 },
    { 0x128A, 0x128D, 1 },
    { 0x1290, 0x12B0, 1 },
    { 0x12B2, 0x12B5, 1 },
    { 0x12B8, 0x12BE, 1 },
    { 0x12C0, 0x12C2, 2 },
    { 0x12C3, 0x12C5, 1 },
    { 0x12C8, 0x12D6, 1 },
    { 0x12D8, 0x1310, 1 },
    { 0x1312, 0x1315, 1 },
    { 0x1318, 0x135A, 1 },
    { 0x1380, 0x138F, 1 },
    { 0x13A0, 0x13F5, 1 },
    { 0x13F8, 0x13FD, 1 },
    { 0x1401, 0x166C, 1 },
    { 0x166F, 0x167F, 1 },
    { 0x1681, 0x169A, 1 },
    { 0x16A0, 0x16EA, 1 },
    { 0x16EE, 0x16F8, 1 },
    { 0x1700, 0x1713, 1 },
    { 0x171F, 0x1733, 1 },
    { 0x1740, 0x1753, 1 },
    { 0x1760, 0x176C, 1 },
    { 0x176E, 0x1770, 1 },
    { 0x1772, 0x1773, 1 },
    { 0x1780, 0x17B3, 1 },
    { 0x17B6, 0x17C8, 1 },
    { 0x17D7, 0x17DC, 5 },
    { 0x1820, 0x1878, 1 },
    { 0x1880, 0x18AA, 1 },
    { 0x18B0, 0x18F5, 1 },
    { 0x1900, 0x191E, 1 },
    { 0x1920, 0x192B, 1 },
    { 0x1930, 0x1938, 1 },
    { 0x1950, 0x196D, 1 },
    { 0x1970, 0x1974, 1 },
    { 0x1980, 0x19AB, 1 },
    { 0x19B0, 0x19C9, 1 },
    { 0x1A00, 0x1A1B, 1 },
    { 0x1A20, 0x1A5E, 1 },
    { 0x1A61, 0x1A74, 1 },
    { 0x1AA7, 0x1ABF, 24 },
    { 0x1AC0, 0x1ACC, 12 },
    { 0x1ACD, 0x1ACE, 1 },
    { 0x1B00, 0x1B33, 1 },
    { 0x1B35, 0x1B43, 1 },
    { 0x1B45, 0x1B4C, 1 },
    { 0x1B80, 0x1BA9, 1 },
    { 0x1BAC, 0x1BAF, 1 },
    { 0x1BBA, 0x1BE5, 1 },
    { 0x1BE7, 0x1BF1, 1 },
    { 0x1C00, 0x1C36, 1 },
    { 0x1C4D, 0x1C4F, 1 },
    { 0x1C5A, 0x1C7D, 1 },
    { 0x1C80, 0x1C88, 1 },
    { 0x1C90, 0x1CBA, 1 },
    { 0x1CBD, 0x1CBF, 1 },
    { 0x1CE9, 0x1CEC, 1 },
    { 0x1CEE, 0x1CF3, 1 },
    { 0x1CF5, 0x1CF6, 1 },
    { 0x1CFA, 0x1D00, 6 },
    { 0x1D01, 0x1DBF, 1 },
    { 0x1DE7, 0x1DF4, 1 },
    { 0x1E00, 0x1F15, 1 },
    { 0x1F18, 0x1F1D, 1 },
    { 0x1F20, 0x1F45, 1 },
    { 0x1F48, 0x1F4D, 1 },
    { 0x1F50, 0x1F57, 1 },
    { 0x1F59, 0x1F5F, 2 },
    { 0x1F60, 0x1F7D, 1 },
    { 0x1F80, 0x1FB4, 1 },
    { 0x1FB6, 0x1FBC, 1 },
    { 0x1FBE, 0x1FC2, 4 },
    { 0x1FC3, 0x1FC4, 1 },
    { 0x1FC6, 0x1FCC, 1 },
    { 0x1FD0, 0x1FD3, 1 },
    { 0x1FD6, 0x1FDB, 1 },
    { 0x1FE0, 0x1FEC, 1 },
    { 0x1FF2, 0x1FF4, 1 },
    { 0x1FF6, 0x1FFC, 1 },
    { 0x2071, 0x207F, 14 },
    { 0x2090, 0x209C, 1 },
    { 0x2102, 0x2107, 5 },
    { 0x210A, 0x2113, 1 },
    { 0x2115, 0x2119, 4 },
    { 0x211A, 0x211D, 1 },
    { 0x2124, 0x212A, 2 },
    { 0x212B, 0x212D, 1 },
    { 0x212F, 0x2139, 1 },
    { 0x213C, 0x213F, 1 },
    { 0x2145, 0x2149, 1 },
    { 0x214E, 0x2160, 18 },
    { 0x2161, 0x2188, 1 },
    { 0x24B6, 0x24E9, 1 },
    { 0x2C00, 0x2CE4, 1 },
    { 0x2CEB, 0x2CEE, 1 },
    { 0x2CF2, 0x2CF3, 1 },
    { 0x2D00, 0x2D25, 1 },
    { 0x2D27, 0x2D2D, 6 },
    { 0x2D30, 0x2D67, 1 },
    { 0x2D6F, 0x2D80, 17 },
    { 0x2D81, 0x2D96, 1 },
    { 0x2DA0, 0x2DA6, 1 },
    { 0x2DA8, 0x2DAE, 1 },
    { 0x2DB0, 0x2DB6, 1 },
    { 0x2DB8, 0x2DBE, 1 },
    { 0x2DC0, 0x2DC6, 1 },
    { 0x2DC8, 0x2DCE, 1 },
    { 0x2DD0, 0x2DD6, 1 },
    { 0x2DD8, 0x2DDE, 1 },
    { 0x2DE0, 0x2DFF, 1 },
    { 0x2E2F, 0x3005, 470 },
    { 0x3006, 0x3007, 1 },
    { 0x3021, 0x3029, 1 },
    { 0x3031, 0x3035, 1 },
    { 0x3038, 0x303C, 1 },
    { 0x3041, 0x3096, 1 },
    { 0x309D, 0x309F, 1 },
    { 0x30A1, 0x30FA, 1 },
    { 0x30FC, 0x30FF, 1 },
    { 0x3105, 0x312F, 1 },
    { 0x3131, 0x318E, 1 },
    { 0x31A0, 0x31BF, 1 },
    { 0x31F0, 0x31FF, 1 },
    { 0x3400, 0x4DBF, 1 },
    { 0x4E00, 0xA48C, 1 },
    { 0xA4D0, 0xA4FD, 1 },
    { 0xA500, 0xA60C, 1 },
    { 0xA610, 0xA61F, 1 },
    { 0xA62A, 0xA62B, 1 },
    { 0xA640, 0xA66E, 1 },
    { 0xA674, 0xA67B, 1 },
    { 0xA67F, 0xA6EF, 1 },
    { 0xA717, 0xA71F, 1 },
    { 0xA722, 0xA788, 1 },
    { 0xA78B, 0xA7CA, 1 },
    { 0xA7D0, 0xA7D1, 1 },
    { 0xA7D3, 0xA7D5, 2 },
    { 0xA7D6, 0xA7D9, 1 },
    { 0xA7F2, 0xA805, 1 },
    { 0xA807, 0xA827, 1 },
    { 0xA840, 0xA873, 1 },
    { 0xA880, 0xA8C3, 1 },
    { 0xA8C5, 0xA8F2, 45 },
    { 0xA8F3, 0xA8F7, 1 },
    { 0xA8FB, 0xA8FD, 2 },
    { 0xA8FE, 0xA8FF, 1 },
    { 0xA90A, 0xA92A, 1 },
    { 0xA930, 0xA952, 1 },
    { 0xA960, 0xA97C, 1 },
    { 0xA980, 0xA9B2, 1 },
    { 0xA9B4, 0xA9BF, 1 },
    { 0xA9CF, 0xA9E0, 17 },
    { 0xA9E1, 0xA9EF, 1 },
    { 0xA9FA, 0xA9FE, 1 },
    { 0xAA00, 0xAA36, 1 },
    { 0xAA40, 0xAA4D, 1 },
    { 0xAA60, 0xAA76, 1 },
    { 0xAA7A, 0xAABE, 1 },
    { 0xAAC0, 0xAAC2, 2 },
    { 0xAADB, 0xAADD, 1 },
    { 0xAAE0, 0xAAEF, 1 },
    { 0xAAF2, 0xAAF5, 1 },
    { 0xAB01, 0xAB06, 1 },
    { 0xAB09, 0xAB0E, 1 },
    { 0xAB11, 0xAB16, 1 },
    { 0xAB20, 0xAB26, 1 },
    { 0xAB28, 0xAB2E, 1 },
    { 0xAB30, 0xAB5A, 1 },
    { 0xAB5C, 0xAB69, 1 },
    { 0xAB70, 0xABEA, 1 },
    { 0xAC00, 0xD7A3, 1 },
    { 0xD7B0, 0xD7C6, 1 },
    { 0xD7CB, 0xD7FB, 1 },
    { 0xF900, 0xFA6D, 1 },
    { 0xFA70, 0xFAD9, 1 },
    { 0xFB00, 0xFB06, 1 },
    { 0xFB13, 0xFB17, 1 },
    { 0xFB1D, 0xFB28, 1 },
    { 0xFB2A, 0xFB36, 1 },
    { 0xFB38, 0xFB3C, 1 },
    { 0xFB3E, 0xFB40, 2 },
    { 0xFB41, 0xFB43, 2 },
    { 0xFB44, 0xFB46, 2 },
    { 0xFB47, 0xFBB1, 1 },
    { 0xFBD3, 0xFD3D, 1 },
    { 0xFD50, 0xFD8F, 1 },
    { 0xFD92, 0xFDC7, 1 },
    { 0xFDF0, 0xFDFB, 1 },
    { 0xFE70, 0xFE74, 1 },
    { 0xFE76, 0xFEFC, 1 },
    { 0xFF21, 0xFF3A, 1 },
    { 0xFF41, 0xFF5A, 1 },
    { 0xFF66, 0xFFBE, 1 },
    { 0xFFC2, 0xFFC7, 1 },
    { 0xFFCA, 0xFFCF, 1 },
    { 0xFFD2, 0xFFD7, 1 },
    { 0xFFDA, 0xFFDC, 1 },
    { 0x10000, 0x1000B, 1 },
    { 0x1000D, 0x10026, 1 },
    { 0x10028, 0x1003A, 1 },
    { 0x1003C, 0x1003D, 1 },
    { 0x1003F, 0x1004D, 1 },
    { 0x10050, 0x1005D, 1 },
    { 0x10080, 0x100FA, 1 },
    { 0x10140, 0x10174, 1 },
    { 0x10280, 0x1029C, 1 },
    { 0x102A0, 0x102D0, 1 },
    { 0x10300, 0x1031F, 1 },
    { 0x1032D, 0x1034A, 1 },
    { 0x10350, 0x1037A, 1 },
    { 0x10380, 0x1039D, 1 },
    { 0x103A0, 0x103C3, 1 },
    { 0x103C8, 0x103CF, 1 },
    { 0x103D1, 0x103D5, 1 },
    { 0x10400, 0x1049D, 1 },
    { 0x104B0, 0x104D3, 1 },
    { 0x104D8, 0x104FB, 1 },
    { 0x10500, 0x10527, 1 },
    { 0x10530, 0x10563, 1 },
    { 0x10570, 0x1057A, 1 },
    { 0x1057C, 0x1058A, 1 },
    { 0x1058C, 0x10592, 1 },
    { 0x10594, 0x10595, 1 },
    { 0x10597, 0x105A1, 1 },
    { 0x105A3, 0x105B1, 1 },
    { 0x105B3, 0x105B9, 1 },
    { 0x105BB, 0x105BC, 1 },
    { 0x10600, 0x10736, 1 },
    { 0x10740, 0x10755, 1 },
    { 0x10760, 0x10767, 1 },
    { 0x10780, 0x10785, 1 },
    { 0x10787, 0x107B0, 1 },
    { 0x107B2, 0x107BA, 1 },
    { 0x10800, 0x10805, 1 },
    { 0x10808, 0x1080A, 2 },
    { 0x1080B, 0x10835, 1 },
    { 0x10837, 0x10838, 1 },
    { 0x1083C, 0x1083F, 3 },
    { 0x10840, 0x10855, 1 },
    { 0x10860, 0x10876, 1 },
    { 0x10880, 0x1089E, 1 },
    { 0x108E0, 0x108F2, 1 },
    { 0x108F4, 0x108F5, 1 },
    { 0x10900, 0x10915, 1 },
    { 0x10920, 0x10939, 1 },
    { 0x10980, 0x109B7, 1 },
    { 0x109BE, 0x109BF, 1 },
    { 0x10A00, 0x10A03, 1 },
    { 0x10A05, 0x10A06, 1 },
    { 0x10A0C, 0x10A13, 1 },
    { 0x10A15, 0x10A17, 1 },
    { 0x10A19, 0x10A35, 1 },
    { 0x10A60, 0x10A7C, 1 },
    { 0x10A80, 0x10A9C, 1 },
    { 0x10AC0, 0x10AC7, 1 },
    { 0x10AC9, 0x10AE4, 1 },
    { 0x10B00, 0x10B35, 1 },
    { 0x10B40, 0x10B55, 1 },
    { 0x10B60, 0x10B72, 1 },
    { 0x10B80, 0x10B91, 1 },
    { 0x10C00, 0x10C48, 1 },
    { 0x10C80, 0x10CB2, 1 },
    { 0x10CC0, 0x10CF2, 1 },
    { 0x10D00, 0x10D27, 1 },
    { 0x10E80, 0x10EA9, 1 },
    { 0x10EAB, 0x10EAC, 1 },
    { 0x10EB0, 0x10EB1, 1 },
    { 0x10F00, 0x10F1C, 1 },
    { 0x10F27, 0x10F30, 9 },
    { 0x10F31, 0x10F45, 1 },
    { 0x10F70, 0x10F81, 1 },
    { 0x10FB0, 0x10FC4, 1 },
    { 0x10FE0, 0x10FF6, 1 },
    { 0x11000, 0x11045, 1 },
    { 0x11071, 0x11075, 1 },
    { 0x11080, 0x110B8, 1 },
    { 0x110C2, 0x110D0, 14 },
    { 0x110D1, 0x110E8, 1 },
    { 0x11100, 0x11132, 1 },
    { 0x11144, 0x11147, 1 },
    { 0x11150, 0x11172, 1 },
    { 0x11176, 0x11180, 10 },
    { 0x11181, 0x111BF, 1 },
    { 0x111C1, 0x111C4, 1 },
    { 0x111CE, 0x111CF, 1 },
    { 0x111DA, 0x111DC, 2 },
    { 0x11200, 0x11211, 1 },
    { 0x11213, 0x11234, 1 },
    { 0x11237, 0x1123E, 7 },
    { 0x1123F, 0x11241, 1 },
    { 0x11280, 0x11286, 1 },
    { 0x11288, 0x1128A, 2 },
    { 0x1128B, 0x1128D, 1 },
    { 0x1128F, 0x1129D, 1 },
    { 0x1129F, 0x112A8, 1 },
    { 0x112B0, 0x112E8, 1 },
    { 0x11300, 0x11303, 1 },
    { 0x11305, 0x1130C, 1 },
    { 0x1130F, 0x11310, 1 },
    { 0x11313, 0x11328, 1 },
    { 0x1132A, 0x11330, 1 },
    { 0x11332, 0x11333, 1 },
    { 0x11335, 0x11339, 1 },
    { 0x1133D, 0x11344, 1 },
    { 0x11347, 0x11348, 1 },
    { 0x1134B, 0x1134C, 1 },
    { 0x11350, 0x11357, 7 },
    { 0x1135D, 0x11363, 1 },
    { 0x11400, 0x11441, 1 },
    { 0x11443, 0x11445, 1 },
    { 0x11447, 0x1144A, 1 },
    { 0x1145F, 0x11461, 1 },
    { 0x11480, 0x114C1, 1 },
    { 0x114C4, 0x114C5, 1 },
    { 0x114C7, 0x11580, 185 },
    { 0x11581, 0x115B5, 1 },
    { 0x115B8, 0x115BE, 1 },
    { 0x115D8, 0x115DD, 1 },
    { 0x11600, 0x1163E, 1 },
    { 0x11640, 0x11644, 4 },
    { 0x11680, 0x116B5, 1 },
    { 0x116B8, 0x11700, 72 },
    { 0x11701, 0x1171A, 1 },
    { 0x1171D, 0x1172A, 1 },
    { 0x11740, 0x11746, 1 },
    { 0x11800, 0x11838, 1 },
    { 0x118A0, 0x118DF, 1 },
    { 0x118FF, 0x11906, 1 },
    { 0x11909, 0x1190C, 3 },
    { 0x1190D, 0x11913, 1 },
    { 0x11915, 0x11916, 1 },
    { 0x11918, 0x11935, 1 },
    { 0x11937, 0x11938, 1 },
    { 0x1193B, 0x1193C, 1 },
    { 0x1193F, 0x11942, 1 },
    { 0x119A0, 0x119A7, 1 },
    { 0x119AA, 0x119D7, 1 },
    { 0x119DA, 0x119DF, 1 },
    { 0x119E1, 0x119E3, 2 },
    { 0x119E4, 0x11A00, 28 },
    { 0x11A01, 0x11A32, 1 },
    { 0x11A35, 0x11A3E, 1 },
    { 0x11A50, 0x11A97, 1 },
    { 0x11A9D, 0x11AB0, 19 },
    { 0x11AB1, 0x11AF8, 1 },
    { 0x11C00, 0x11C08, 1 },
    { 0x11C0A, 0x11C36, 1 },
    { 0x11C38, 0x11C3E, 1 },
    { 0x11C40, 0x11C72, 50 },
    { 0x11C73, 0x11C8F, 1 },
    { 0x11C92, 0x11CA7, 1 },
    { 0x11CA9, 0x11CB6, 1 },
    { 0x11D00, 0x11D06, 1 },
    { 0x11D08, 0x11D09, 1 },
    { 0x11D0B, 0x11D36, 1 },
    { 0x11D3A, 0x11D3C, 2 },
    { 0x11D3D, 0x11D3F, 2 },
    { 0x11D40, 0x11D41, 1 },
    { 0x11D43, 0x11D46, 3 },
    { 0x11D47, 0x11D60, 25 },
    { 0x11D61, 0x11D65, 1 },
    { 0x11D67, 0x11D68, 1 },
    { 0x11D6A, 0x11D8E, 1 },
    { 0x11D90, 0x11D91, 1 },
    { 0x11D93, 0x11D96, 1 },
    { 0x11D98, 0x11EE0, 328 },
    { 0x11EE1, 0x11EF6, 1 },
    { 0x11F00, 0x11F10, 1 },
    { 0x11F12, 0x11F3A, 1 },
    { 0x11F3E, 0x11F40, 1 },
    { 0x11FB0, 0x12000, 80 },
    { 0x12001, 0x12399, 1 },
    { 0x12400, 0x1246E, 1 },
    { 0x12480, 0x12543, 1 },
    { 0x12F90, 0x12FF0, 1 },
    { 0x13000, 0x1342F, 1 },
    { 0x13441, 0x13446, 1 },
    { 0x14400, 0x14646, 1 },
    { 0x16800, 0x16A38, 1 },
    { 0x16A40, 0x16A5E, 1 },
    { 0x16A70, 0x16ABE, 1 },
    { 0x16AD0, 0x16AED, 1 },
    { 0x16B00, 0x16B2F, 1 },
    { 0x16B40, 0x16B43, 1 },
    { 0x16B63, 0x16B77, 1 },
    { 0x16B7D, 0x16B8F, 1 },
    { 0x16E40, 0x16E7F, 1 },
    { 0x16F00, 0x16F4A, 1 },
    { 0x16F4F, 0x16F87, 1 },
    { 0x16F8F, 0x16F9F, 1 },
    { 0x16FE0, 0x16FE1, 1 },
    { 0x16FE3, 0x16FF0, 13 },
    { 0x16FF1, 0x17000, 15 },
    { 0x17001, 0x187F7, 1 },
    { 0x18800, 0x18CD5, 1 },
    { 0x18D00, 0x18D08, 1 },
    { 0x1AFF0, 0x1AFF3, 1 },
    { 0x1AFF5, 0x1AFFB, 1 },
    { 0x1AFFD, 0x1AFFE, 1 },
    { 0x1B000, 0x1B122, 1 },
    { 0x1B132, 0x1B150, 30 },
    { 0x1B151, 0x1B152, 1 },
    { 0x1B155, 0x1B164, 15 },
    { 0x1B165, 0x1B167, 1 },
    { 0x1B170, 0x1B2FB, 1 },
    { 0x1BC00, 0x1BC6A, 1 },
    { 0x1BC70, 0x1BC7C, 1 },
    { 0x1BC80, 0x1BC88, 1 },
    { 0x1BC90, 0x1BC99, 1 },
    { 0x1BC9E, 0x1D400, 5986 },
    { 0x1D401, 0x1D454, 1 },
    { 0x1D456, 0x1D49C, 1 },
    { 0x1D49E, 0x1D49F, 1 },
    { 0x1D4A2, 0x1D4A5, 3 },
    { 0x1D4A6, 0x1D4A9, 3 },
    { 0x1D4AA, 0x1D4AC, 1 },
    { 0x1D4AE, 0x1D4B9, 1 },
    { 0x1D4BB, 0x1D4BD, 2 },
    { 0x1D4BE, 0x1D4C3, 1 },
    { 0x1D4C5, 0x1D505, 1 },
    { 0x1D507, 0x1D50A, 1 },
    { 0x1D50D, 0x1D514, 1 },
    { 0x1D516, 0x1D51C, 1 },
    { 0x1D51E, 0x1D539, 1 },
    { 0x1D53B, 0x1D53E, 1 },
    { 0x1D540, 0x1D544, 1 },
    { 0x1D546, 0x1D54A, 4 },
    { 0x1D54B, 0x1D550, 1 },
    { 0x1D552, 0x1D6A5, 1 },
    { 0x1D6A8, 0x1D6C0, 1 },
    { 0x1D6C2, 0x1D6DA, 1 },
    { 0x1D6DC, 0x1D6FA, 1 },
    { 0x1D6FC, 0x1D714, 1 },
    { 0x1D716, 0x1D734, 1 },
    { 0x1D736, 0x1D74E, 1 },
    { 0x1D750, 0x1D76E, 1 },
    { 0x1D770, 0x1D788, 1 },
    { 0x1D78A, 0x1D7A8, 1 },
    { 0x1D7AA, 0x1D7C2, 1 },
    { 0x1D7C4, 0x1D7CB, 1 },
    { 0x1DF00, 0x1DF1E, 1 },
    { 0x1DF25, 0x1DF2A, 1 },
    { 0x1E000, 0x1E006, 1 },
    { 0x1E008, 0x1E018, 1 },
    { 0x1E01B, 0x1E021, 1 },
    { 0x1E023, 0x1E024, 1 },
    { 0x1E026, 0x1E02A, 1 },
    { 0x1E030, 0x1E06D, 1 },
    { 0x1E08F, 0x1E100, 113 },
    { 0x1E101, 0x1E12C, 1 },
    { 0x1E137, 0x1E13D, 1 },
    { 0x1E14E, 0x1E290, 322 },
    { 0x1E291, 0x1E2AD, 1 },
    { 0x1E2C0, 0x1E2EB, 1 },
    { 0x1E4D0, 0x1E4EB, 1 },
    { 0x1E7E0, 0x1E7E6, 1 },
    { 0x1E7E8, 0x1E7EB, 1 },
    { 0x1E7ED, 0x1E7EE, 1 },
    { 0x1E7F0, 0x1E7FE, 1 },
    { 0x1E800, 0x1E8C4, 1 },
    { 0x1E900, 0x1E943, 1 },
    { 0x1E947, 0x1E94B, 4 },
    { 0x1EE00, 0x1EE03, 1 },
    { 0x1EE05, 0x1EE1F, 1 },
    { 0x1EE21, 0x1EE22, 1 },
    { 0x1EE24, 0x1EE27, 3 },
    { 0x1EE29, 0x1EE32, 1 },
    { 0x1EE34, 0x1EE37, 1 },
    { 0x1EE39, 0x1EE3B, 2 },
    { 0x1EE42, 0x1EE47, 5 },
    { 0x1EE49, 0x1EE4D, 2 },
    { 0x1EE4E, 0x1EE4F, 1 },
    { 0x1EE51, 0x1EE52, 1 },
    { 0x1EE54, 0x1EE57, 3 },
    { 0x1EE59, 0x1EE61, 2 },
    { 0x1EE62, 0x1EE64, 2 },
    { 0x1EE67, 0x1EE6A, 1 },
    { 0x1EE6C, 0x1EE72, 1 },
    { 0x1EE74, 0x1EE77, 1 },
    { 0x1EE79, 0x1EE7C, 1 },
    { 0x1EE7E, 0x1EE80, 2 },
    { 0x1EE81, 0x1EE89, 1 },
    { 0x1EE8B, 0x1EE9B, 1 },
    { 0x1EEA1, 0x1EEA3, 1 },
    { 0x1EEA5, 0x1EEA9, 1 },
    { 0x1EEAB, 0x1EEBB, 1 },
    { 0x1F130, 0x1F149, 1 },
    { 0x1F150, 0x1F169, 1 },
    { 0x1F170, 0x1F189, 1 },
    { 0x20000, 0x2A6DF, 1 },
    { 0x2A700, 0x2B739, 1 },
    { 0x2B740, 0x2B81D, 1 },
    { 0x2B820, 0x2CEA1, 1 },
    { 0x2CEB0, 0x2EBE0, 1 },
    { 0x2EBF0, 0x2EE5D, 1 },
    { 0x2F800, 0x2FA1D, 1 },
    { 0x30000, 0x3134A, 1 },
    { 0x31350, 0x323AF, 1 },
};

static struct range_table lower_table[] = {
    { 0x61, 0x7A, 1 },
    { 0xAA, 0xB5, 11 },
    { 0xBA, 0xDF, 37 },
    { 0xE0, 0xF6, 1 },
    { 0xF8, 0xFF, 1 },
    { 0x101, 0x137, 2 },
    { 0x138, 0x148, 2 },
    { 0x149, 0x177, 2 },
    { 0x17A, 0x17E, 2 },
    { 0x17F, 0x180, 1 },
    { 0x183, 0x185, 2 },
    { 0x188, 0x18C, 4 },
    { 0x18D, 0x192, 5 },
    { 0x195, 0x199, 4 },
    { 0x19A, 0x19B, 1 },
    { 0x19E, 0x1A1, 3 },
    { 0x1A3, 0x1A5, 2 },
    { 0x1A8, 0x1AA, 2 },
    { 0x1AB, 0x1AD, 2 },
    { 0x1B0, 0x1B4, 4 },
    { 0x1B6, 0x1B9, 3 },
    { 0x1BA, 0x1BD, 3 },
    { 0x1BE, 0x1BF, 1 },
    { 0x1C6, 0x1CC, 3 },
    { 0x1CE, 0x1DC, 2 },
    { 0x1DD, 0x1EF, 2 },
    { 0x1F0, 0x1F3, 3 },
    { 0x1F5, 0x1F9, 4 },
    { 0x1FB, 0x233, 2 },
    { 0x234, 0x239, 1 },
    { 0x23C, 0x23F, 3 },
    { 0x240, 0x242, 2 },
    { 0x247, 0x24F, 2 },
    { 0x250, 0x293, 1 },
    { 0x295, 0x2B8, 1 },
    { 0x2C0, 0x2C1, 1 },
    { 0x2E0, 0x2E4, 1 },
    { 0x345, 0x371, 44 },
    { 0x373, 0x377, 4 },
    { 0x37A, 0x37D, 1 },
    { 0x390, 0x3AC, 28 },
    { 0x3AD, 0x3CE, 1 },
    { 0x3D0, 0x3D1, 1 },
    { 0x3D5, 0x3D7, 1 },
    { 0x3D9, 0x3EF, 2 },
    { 0x3F0, 0x3F3, 1 },
    { 0x3F5, 0x3FB, 3 },
    { 0x3FC, 0x430, 52 },
    { 0x431, 0x45F, 1 },
    { 0x461, 0x481, 2 },
    { 0x48B, 0x4BF, 2 },
    { 0x4C2, 0x4CE, 2 },
    { 0x4CF, 0x52F, 2 },
    { 0x560, 0x588, 1 },
    { 0x10D0, 0x10FA, 1 },
    { 0x10FC, 0x10FF, 1 },
    { 0x13F8, 0x13FD, 1 },
    { 0x1C80, 0x1C88, 1 },
    { 0x1D00, 0x1DBF, 1 },
    { 0x1E01, 0x1E95, 2 },
    { 0x1E96, 0x1E9D, 1 },
    { 0x1E9F, 0x1EFF, 2 },
    { 0x1F00, 0x1F07, 1 },
    { 0x1F10, 0x1F15, 1 },
    { 0x1F20, 0x1F27, 1 },
    { 0x1F30, 0x1F37, 1 },
    { 0x1F40, 0x1F45, 1 },
    { 0x1F50, 0x1F57, 1 },
    { 0x1F60, 0x1F67, 1 },
    { 0x1F70, 0x1F7D, 1 },
    { 0x1F80, 0x1F87, 1 },
    { 0x1F90, 0x1F97, 1 },
    { 0x1FA0, 0x1FA7, 1 },
    { 0x1FB0, 0x1FB4, 1 },
    { 0x1FB6, 0x1FB7, 1 },
    { 0x1FBE, 0x1FC2, 4 },
    { 0x1FC3, 0x1FC4, 1 },
    { 0x1FC6, 0x1FC7, 1 },
    { 0x1FD0, 0x1FD3, 1 },
    { 0x1FD6, 0x1FD7, 1 },
    { 0x1FE0, 0x1FE7, 1 },
    { 0x1FF2, 0x1FF4, 1 },
    { 0x1FF6, 0x1FF7, 1 },
    { 0x2071, 0x207F, 14 },
    { 0x2090, 0x209C, 1 },
    { 0x210A, 0x210E, 4 },
    { 0x210F, 0x2113, 4 },
    { 0x212F, 0x2139, 5 },
    { 0x213C, 0x213D, 1 },
    { 0x2146, 0x2149, 1 },
    { 0x214E, 0x2170, 34 },
    { 0x2171, 0x217F, 1 },
    { 0x2184, 0x24D0, 844 },
    { 0x24D1, 0x24E9, 1 },
    { 0x2C30, 0x2C5F, 1 },
    { 0x2C61, 0x2C65, 4 },
    { 0x2C66, 0x2C6C, 2 },
    { 0x2C71, 0x2C73, 2 },
    { 0x2C74, 0x2C76, 2 },
    { 0x2C77, 0x2C7D, 1 },
    { 0x2C81, 0x2CE3, 2 },
    { 0x2CE4, 0x2CEC, 8 },
    { 0x2CEE, 0x2CF3, 5 },
    { 0x2D00, 0x2D25, 1 },
    { 0x2D27, 0x2D2D, 6 },
    { 0xA641, 0xA66D, 2 },
    { 0xA681, 0xA69B, 2 },
    { 0xA69C, 0xA69D, 1 },
    { 0xA723, 0xA72F, 2 },
    { 0xA730, 0xA731, 1 },
    { 0xA733, 0xA76F, 2 },
    { 0xA770, 0xA778, 1 },
    { 0xA77A, 0xA77C, 2 },
    { 0xA77F, 0xA787, 2 },
    { 0xA78C, 0xA78E, 2 },
    { 0xA791, 0xA793, 2 },
    { 0xA794, 0xA795, 1 },
    { 0xA797, 0xA7A9, 2 },
    { 0xA7AF, 0xA7B5, 6 },
    { 0xA7B7, 0xA7C3, 2 },
    { 0xA7C8, 0xA7CA, 2 },
    { 0xA7D1, 0xA7D9, 2 },
    { 0xA7F2, 0xA7F4, 1 },
    { 0xA7F6, 0xA7F8, 2 },
    { 0xA7F9, 0xA7FA, 1 },
    { 0xAB30, 0xAB5A, 1 },
    { 0xAB5C, 0xAB69, 1 },
    { 0xAB70, 0xABBF, 1 },
    { 0xFB00, 0xFB06, 1 },
    { 0xFB13, 0xFB17, 1 },
    { 0xFF41, 0xFF5A, 1 },
    { 0x10428, 0x1044F, 1 },
    { 0x104D8, 0x104FB, 1 },
    { 0x10597, 0x105A1, 1 },
    { 0x105A3, 0x105B1, 1 },
    { 0x105B3, 0x105B9, 1 },
    { 0x105BB, 0x105BC, 1 },
    { 0x10780, 0x10783, 3 },
    { 0x10784, 0x10785, 1 },
    { 0x10787, 0x107B0, 1 },
    { 0x107B2, 0x107BA, 1 },
    { 0x10CC0, 0x10CF2, 1 },
    { 0x118C0, 0x118DF, 1 },
    { 0x16E60, 0x16E7F, 1 },
    { 0x1D41A, 0x1D433, 1 },
    { 0x1D44E, 0x1D454, 1 },
    { 0x1D456, 0x1D467, 1 },
    { 0x1D482, 0x1D49B, 1 },
    { 0x1D4B6, 0x1D4B9, 1 },
    { 0x1D4BB, 0x1D4BD, 2 },
    { 0x1D4BE, 0x1D4C3, 1 },
    { 0x1D4C5, 0x1D4CF, 1 },
    { 0x1D4EA, 0x1D503, 1 },
    { 0x1D51E, 0x1D537, 1 },
    { 0x1D552, 0x1D56B, 1 },
    { 0x1D586, 0x1D59F, 1 },
    { 0x1D5BA, 0x1D5D3, 1 },
    { 0x1D5EE, 0x1D607, 1 },
    { 0x1D622, 0x1D63B, 1 },
    { 0x1D656, 0x1D66F, 1 },
    { 0x1D68A, 0x1D6A5, 1 },
    { 0x1D6C2, 0x1D6DA, 1 },
    { 0x1D6DC, 0x1D6E1, 1 },
    { 0x1D6FC, 0x1D714, 1 },
    { 0x1D716, 0x1D71B, 1 },
    { 0x1D736, 0x1D74E, 1 },
    { 0x1D750, 0x1D755, 1 },
    { 0x1D770, 0x1D788, 1 },
    { 0x1D78A, 0x1D78F, 1 },
    { 0x1D7AA, 0x1D7C2, 1 },
    { 0x1D7C4, 0x1D7C9, 1 },
    { 0x1D7CB, 0x1DF00, 1845 },
    { 0x1DF01, 0x1DF09, 1 },
    { 0x1DF0B, 0x1DF1E, 1 },
    { 0x1DF25, 0x1DF2A, 1 },
    { 0x1E030, 0x1E06D, 1 },
    { 0x1E922, 0x1E943, 1 },
};

static struct range_table upper_table[] = {
    { 0x41, 0x5A, 1 },
    { 0xC0, 0xD6, 1 },
    { 0xD8, 0xDE, 1 },
    { 0x100, 0x136, 2 },
    { 0x139, 0x147, 2 },
    { 0x14A, 0x178, 2 },
    { 0x179, 0x17D, 2 },
    { 0x181, 0x182, 1 },
    { 0x184, 0x186, 2 },
    { 0x187, 0x189, 2 },
    { 0x18A, 0x18B, 1 },
    { 0x18E, 0x191, 1 },
    { 0x193, 0x194, 1 },
    { 0x196, 0x198, 1 },
    { 0x19C, 0x19D, 1 },
    { 0x19F, 0x1A0, 1 },
    { 0x1A2, 0x1A6, 2 },
    { 0x1A7, 0x1A9, 2 },
    { 0x1AC, 0x1AE, 2 },
    { 0x1AF, 0x1B1, 2 },
    { 0x1B2, 0x1B3, 1 },
    { 0x1B5, 0x1B7, 2 },
    { 0x1B8, 0x1BC, 4 },
    { 0x1C4, 0x1CD, 3 },
    { 0x1CF, 0x1DB, 2 },
    { 0x1DE, 0x1EE, 2 },
    { 0x1F1, 0x1F4, 3 },
    { 0x1F6, 0x1F8, 1 },
    { 0x1FA, 0x232, 2 },
    { 0x23A, 0x23B, 1 },
    { 0x23D, 0x23E, 1 },
    { 0x241, 0x243, 2 },
    { 0x244, 0x246, 1 },
    { 0x248, 0x24E, 2 },
    { 0x370, 0x372, 2 },
    { 0x376, 0x37F, 9 },
    { 0x386, 0x388, 2 },
    { 0x389, 0x38A, 1 },
    { 0x38C, 0x38E, 2 },
    { 0x38F, 0x391, 2 },
    { 0x392, 0x3A1, 1 },
    { 0x3A3, 0x3AB, 1 },
    { 0x3CF, 0x3D2, 3 },
    { 0x3D3, 0x3D4, 1 },
    { 0x3D8, 0x3EE, 2 },
    { 0x3F4, 0x3F7, 3 },
    { 0x3F9, 0x3FA, 1 },
    { 0x3FD, 0x42F, 1 },
    { 0x460, 0x480, 2 },
    { 0x48A, 0x4C0, 2 },
    { 0x4C1, 0x4CD, 2 },
    { 0x4D0, 0x52E, 2 },
    { 0x531, 0x556, 1 },
    { 0x10A0, 0x10C5, 1 },
    { 0x10C7, 0x10CD, 6 },
    { 0x13A0, 0x13F5, 1 },
    { 0x1C90, 0x1CBA, 1 },
    { 0x1CBD, 0x1CBF, 1 },
    { 0x1E00, 0x1E94, 2 },
    { 0x1E9E, 0x1EFE, 2 },
    { 0x1F08, 0x1F0F, 1 },
    { 0x1F18, 0x1F1D, 1 },
    { 0x1F28, 0x1F2F, 1 },
    { 0x1F38, 0x1F3F, 1 },
    { 0x1F48, 0x1F4D, 1 },
    { 0x1F59, 0x1F5F, 2 },
    { 0x1F68, 0x1F6F, 1 },
    { 0x1FB8, 0x1FBB, 1 },
    { 0x1FC8, 0x1FCB, 1 },
    { 0x1FD8, 0x1FDB, 1 },
    { 0x1FE8, 0x1FEC, 1 },
    { 0x1FF8, 0x1FFB, 1 },
    { 0x2102, 0x2107, 5 },
    { 0x210B, 0x210D, 1 },
    { 0x2110, 0x2112, 1 },
    { 0x2115, 0x2119, 4 },
    { 0x211A, 0x211D, 1 },
    { 0x2124, 0x212A, 2 },
    { 0x212B, 0x212D, 1 },
    { 0x2130, 0x2133, 1 },
    { 0x213E, 0x213F, 1 },
    { 0x2145, 0x2160, 27 },
    { 0x2161, 0x216F, 1 },
    { 0x2183, 0x24B6, 819 },
    { 0x24B7, 0x24CF, 1 },
    { 0x2C00, 0x2C2F, 1 },
    { 0x2C60, 0x2C62, 2 },
    { 0x2C63, 0x2C64, 1 },
    { 0x2C67, 0x2C6D, 2 },
    { 0x2C6E, 0x2C70, 1 },
    { 0x2C72, 0x2C75, 3 },
    { 0x2C7E, 0x2C80, 1 },
    { 0x2C82, 0x2CE2, 2 },
    { 0x2CEB, 0x2CED, 2 },
    { 0x2CF2, 0xA640, 31054 },
    { 0xA642, 0xA66C, 2 },
    { 0xA680, 0xA69A, 2 },
    { 0xA722, 0xA72E, 2 },
    { 0xA732, 0xA76E, 2 },
    { 0xA779, 0xA77D, 2 },
    { 0xA77E, 0xA786, 2 },
    { 0xA78B, 0xA78D, 2 },
    { 0xA790, 0xA792, 2 },
    { 0xA796, 0xA7AA, 2 },
    { 0xA7AB, 0xA7AE, 1 },
    { 0xA7B0, 0xA7B4, 1 },
    { 0xA7B6, 0xA7C4, 2 },
    { 0xA7C5, 0xA7C7, 1 },
    { 0xA7C9, 0xA7D0, 7 },
    { 0xA7D6, 0xA7D8, 2 },
    { 0xA7F5, 0xFF21, 22316 },
    { 0xFF22, 0xFF3A, 1 },
    { 0x10400, 0x10427, 1 },
    { 0x104B0, 0x104D3, 1 },
    { 0x10570, 0x1057A, 1 },
    { 0x1057C, 0x1058A, 1 },
    { 0x1058C, 0x10592, 1 },
    { 0x10594, 0x10595, 1 },
    { 0x10C80, 0x10CB2, 1 },
    { 0x118A0, 0x118BF, 1 },
    { 0x16E40, 0x16E5F, 1 },
    { 0x1D400, 0x1D419, 1 },
    { 0x1D434, 0x1D44D, 1 },
    { 0x1D468, 0x1D481, 1 },
    { 0x1D49C, 0x1D49E, 2 },
    { 0x1D49F, 0x1D4A5, 3 },
    { 0x1D4A6, 0x1D4A9, 3 },
    { 0x1D4AA, 0x1D4AC, 1 },
    { 0x1D4AE, 0x1D4B5, 1 },
    { 0x1D4D0, 0x1D4E9, 1 },
    { 0x1D504, 0x1D505, 1 },
    { 0x1D507, 0x1D50A, 1 },
    { 0x1D50D, 0x1D514, 1 },
    { 0x1D516, 0x1D51C, 1 },
    { 0x1D538, 0x1D539, 1 },
    { 0x1D53B, 0x1D53E, 1 },
    { 0x1D540, 0x1D544, 1 },
    { 0x1D546, 0x1D54A, 4 },
    { 0x1D54B, 0x1D550, 1 },
    { 0x1D56C, 0x1D585, 1 },
    { 0x1D5A0, 0x1D5B9, 1 },
    { 0x1D5D4, 0x1D5ED, 1 },
    { 0x1D608, 0x1D621, 1 },
    { 0x1D63C, 0x1D655, 1 },
    { 0x1D670, 0x1D689, 1 },
    { 0x1D6A8, 0x1D6C0, 1 },
    { 0x1D6E2, 0x1D6FA, 1 },
    { 0x1D71C, 0x1D734, 1 },
    { 0x1D756, 0x1D76E, 1 },
    { 0x1D790, 0x1D7A8, 1 },
    { 0x1D7CA, 0x1E900, 4406 },
    { 0x1E901, 0x1E921, 1 },
    { 0x1F130, 0x1F149, 1 },
    { 0x1F150, 0x1F169, 1 },
    { 0x1F170, 0x1F189, 1 },
};

static struct range_table xdigit_table[] = {
    { 0x30, 0x39, 1 },
    { 0x41, 0x46, 1 },
    { 0x61, 0x66, 1 },
    { 0xFF10, 0xFF19, 1 },
    { 0xFF21, 0xFF26, 1 },
    { 0xFF41, 0xFF46, 1 },
};

static struct range_table space_table[] = {
    { 0x9, 0xD, 1 },
    { 0x20, 0x85, 101 },
    { 0xA0, 0x1680, 5600 },
    { 0x2000, 0x200A, 1 },
    { 0x2028, 0x2029, 1 },
    { 0x202F, 0x205F, 48 },
    { 0x3000, 0x3000, 1 },
};

static struct range_table unprintable_table[] = {
    { 0xAD, 0x34F, 674 },
    { 0x61C, 0x115F, 2883 },
    { 0x1160, 0x17B4, 1620 },
    { 0x17B5, 0x180B, 86 },
    { 0x180C, 0x180F, 1 },
    { 0x200B, 0x200F, 1 },
    { 0x202A, 0x202E, 1 },
    { 0x2060, 0x206F, 1 },
    { 0x3164, 0xFE00, 52380 },
    { 0xFE01, 0xFE0F, 1 },
    { 0xFEFF, 0xFFA0, 161 },
    { 0xFFF0, 0xFFF8, 1 },
    { 0x1BCA0, 0x1BCA3, 1 },
    { 0x1D173, 0x1D17A, 1 },
    { 0xE0000, 0xE0FFF, 1 },
};

static struct range_table graph_table[] = {
    { 0x20, 0x7E, 1 },
    { 0xA0, 0xAC, 1 },
    { 0xAE, 0x2FF, 1 },
    { 0x370, 0x377, 1 },
    { 0x37A, 0x37F, 1 },
    { 0x384, 0x38A, 1 },
    { 0x38C, 0x38E, 2 },
    { 0x38F, 0x3A1, 1 },
    { 0x3A3, 0x482, 1 },
    { 0x48A, 0x52F, 1 },
    { 0x531, 0x556, 1 },
    { 0x559, 0x58A, 1 },
    { 0x58D, 0x58F, 1 },
    { 0x5BE, 0x5C0, 2 },
    { 0x5C3, 0x5C6, 3 },
    { 0x5D0, 0x5EA, 1 },
    { 0x5EF, 0x5F4, 1 },
    { 0x606, 0x60F, 1 },
    { 0x61B, 0x61D, 2 },
    { 0x61E, 0x64A, 1 },
    { 0x660, 0x66F, 1 },
    { 0x671, 0x6D5, 1 },
    { 0x6DE, 0x6E5, 7 },
    { 0x6E6, 0x6E9, 3 },
    { 0x6EE, 0x70D, 1 },
    { 0x710, 0x712, 2 },
    { 0x713, 0x72F, 1 },
    { 0x74D, 0x7A5, 1 },
    { 0x7B1, 0x7C0, 15 },
    { 0x7C1, 0x7EA, 1 },
    { 0x7F4, 0x7FA, 1 },
    { 0x7FE, 0x815, 1 },
    { 0x81A, 0x824, 10 },
    { 0x828, 0x830, 8 },
    { 0x831, 0x83E, 1 },
    { 0x840, 0x858, 1 },
    { 0x85E, 0x860, 2 },
    { 0x861, 0x86A, 1 },
    { 0x870, 0x88E, 1 },
    { 0x8A0, 0x8C9, 1 },
    { 0x903, 0x939, 1 },
    { 0x93B, 0x93D, 2 },
    { 0x93E, 0x940, 1 },
    { 0x949, 0x94C, 1 },
    { 0x94E, 0x950, 1 },
    { 0x958, 0x961, 1 },
    { 0x964, 0x980, 1 },
    { 0x982, 0x983, 1 },
    { 0x985, 0x98C, 1 },
    { 0x98F, 0x990, 1 },
    { 0x993, 0x9A8, 1 },
    { 0x9AA, 0x9B0, 1 },
    { 0x9B2, 0x9B6, 4 },
    { 0x9B7, 0x9B9, 1 },
    { 0x9BD, 0x9BF, 2 },
    { 0x9C0, 0x9C7, 7 },
    { 0x9C8, 0x9CB, 3 },
    { 0x9CC, 0x9CE, 2 },
    { 0x9DC, 0x9DD, 1 },
    { 0x9DF, 0x9E1, 1 },
    { 0x9E6, 0x9FD, 1 },
    { 0xA03, 0xA05, 2 },
    { 0xA06, 0xA0A, 1 },
    { 0xA0F, 0xA10, 1 },
    { 0xA13, 0xA28, 1 },
    { 0xA2A, 0xA30, 1 },
    { 0xA32, 0xA33, 1 },
    { 0xA35, 0xA36, 1 },
    { 0xA38, 0xA39, 1 },
    { 0xA3E, 0xA40, 1 },
    { 0xA59, 0xA5C, 1 },
    { 0xA5E, 0xA66, 8 },
    { 0xA67, 0xA6F, 1 },
    { 0xA72, 0xA74, 1 },
    { 0xA76, 0xA83, 13 },
    { 0xA85, 0xA8D, 1 },
    { 0xA8F, 0xA91, 1 },
    { 0xA93, 0xAA8, 1 },
    { 0xAAA, 0xAB0, 1 },
    { 0xAB2, 0xAB3, 1 },
    { 0xAB5, 0xAB9, 1 },
    { 0xABD, 0xAC0, 1 },
    { 0xAC9, 0xACB, 2 },
    { 0xACC, 0xAD0, 4 },
    { 0xAE0, 0xAE1, 1 },
    { 0xAE6, 0xAF1, 1 },
    { 0xAF9, 0xB02, 9 },
    { 0xB03, 0xB05, 2 },
    { 0xB06, 0xB0C, 1 },
    { 0xB0F, 0xB10, 1 },
    { 0xB13, 0xB28, 1 },
    { 0xB2A, 0xB30, 1 },
    { 0xB32, 0xB33, 1 },
    { 0xB35, 0xB39, 1 },
    { 0xB3D, 0xB40, 3 },
    { 0xB47, 0xB48, 1 },
    { 0xB4B, 0xB4C, 1 },
    { 0xB5C, 0xB5D, 1 },
    { 0xB5F, 0xB61, 1 },
    { 0xB66, 0xB77, 1 },
    { 0xB83, 0xB85, 2 },
    { 0xB86, 0xB8A, 1 },
    { 0xB8E, 0xB90, 1 },
    { 0xB92, 0xB95, 1 },
    { 0xB99, 0xB9A, 1 },
    { 0xB9C, 0xB9E, 2 },
    { 0xB9F, 0xBA3, 4 },
    { 0xBA4, 0xBA8, 4 },
    { 0xBA9, 0xBAA, 1 },
    { 0xBAE, 0xBB9, 1 },
    { 0xBBF, 0xBC1, 2 },
    { 0xBC2, 0xBC6, 4 },
    { 0xBC7, 0xBC8, 1 },
    { 0xBCA, 0xBCC, 1 },
    { 0xBD0, 0xBE6, 22 },
    { 0xBE7, 0xBFA, 1 },
    { 0xC01, 0xC03, 1 },
    { 0xC05, 0xC0C, 1 },
    { 0xC0E, 0xC10, 1 },
    { 0xC12, 0xC28, 1 },
    { 0xC2A, 0xC39, 1 },
    { 0xC3D, 0xC41, 4 },
    { 0xC42, 0xC44, 1 },
    { 0xC58, 0xC5A, 1 },
    { 0xC5D, 0xC60, 3 },
    { 0xC61, 0xC66, 5 },
    { 0xC67, 0xC6F, 1 },
    { 0xC77, 0xC80, 1 },
    { 0xC82, 0xC8C, 1 },
    { 0xC8E, 0xC90, 1 },
    { 0xC92, 0xCA8, 1 },
    { 0xCAA, 0xCB3, 1 },
    { 0xCB5, 0xCB9, 1 },
    { 0xCBD, 0xCBE, 1 },
    { 0xCC0, 0xCC1, 1 },
    { 0xCC3, 0xCC4, 1 },
    { 0xCC7, 0xCC8, 1 },
    { 0xCCA, 0xCCB, 1 },
    { 0xCDD, 0xCDE, 1 },
    { 0xCE0, 0xCE1, 1 },
    { 0xCE6, 0xCEF, 1 },
    { 0xCF1, 0xCF3, 1 },
    { 0xD02, 0xD0C, 1 },
    { 0xD0E, 0xD10, 1 },
    { 0xD12, 0xD3A, 1 },
    { 0xD3D, 0xD3F, 2 },
    { 0xD40, 0xD46, 6 },
    { 0xD47, 0xD48, 1 },
    { 0xD4A, 0xD4C, 1 },
    { 0xD4E, 0xD4F, 1 },
    { 0xD54, 0xD56, 1 },
    { 0xD58, 0xD61, 1 },
    { 0xD66, 0xD7F, 1 },
    { 0xD82, 0xD83, 1 },
    { 0xD85, 0xD96, 1 },
    { 0xD9A, 0xDB1, 1 },
    { 0xDB3, 0xDBB, 1 },
    { 0xDBD, 0xDC0, 3 },
    { 0xDC1, 0xDC6, 1 },
    { 0xDD0, 0xDD1, 1 },
    { 0xDD8, 0xDDE, 1 },
    { 0xDE6, 0xDEF, 1 },
    { 0xDF2, 0xDF4, 1 },
    { 0xE01, 0xE30, 1 },
    { 0xE32, 0xE33, 1 },
    { 0xE3F, 0xE46, 1 },
    { 0xE4F, 0xE5B, 1 },
    { 0xE81, 0xE82, 1 },
    { 0xE84, 0xE86, 2 },
    { 0xE87, 0xE8A, 1 },
    { 0xE8C, 0xEA3, 1 },
    { 0xEA5, 0xEA7, 2 },
    { 0xEA8, 0xEB0, 1 },
    { 0xEB2, 0xEB3, 1 },
    { 0xEBD, 0xEC0, 3 },
    { 0xEC1, 0xEC4, 1 },
    { 0xEC6, 0xED0, 10 },
    { 0xED1, 0xED9, 1 },
    { 0xEDC, 0xEDF, 1 },
    { 0xF00, 0xF17, 1 },
    { 0xF1A, 0xF34, 1 },
    { 0xF36, 0xF3A, 2 },
    { 0xF3B, 0xF47, 1 },
    { 0xF49, 0xF6C, 1 },
    { 0xF7F, 0xF85, 6 },
    { 0xF88, 0xF8C, 1 },
    { 0xFBE, 0xFC5, 1 },
    { 0xFC7, 0xFCC, 1 },
    { 0xFCE, 0xFDA, 1 },
    { 0x1000, 0x102C, 1 },
    { 0x1031, 0x1038, 7 },
    { 0x103B, 0x103C, 1 },
    { 0x103F, 0x1057, 1 },
    { 0x105A, 0x105D, 1 },
    { 0x1061, 0x1070, 1 },
    { 0x1075, 0x1081, 1 },
    { 0x1083, 0x1084, 1 },
    { 0x1087, 0x108C, 1 },
    { 0x108E, 0x109C, 1 },
    { 0x109E, 0x10C5, 1 },
    { 0x10C7, 0x10CD, 6 },
    { 0x10D0, 0x1248, 1 },
    { 0x124A, 0x124D, 1 },
    { 0x1250, 0x1256, 1 },
    { 0x1258, 0x125A, 2 },
    { 0x125B, 0x125D, 1 },
    { 0x1260, 0x1288, 1 },
    { 0x128A, 0x128D, 1 },
    { 0x1290, 0x12B0, 1 },
    { 0x12B2, 0x12B5, 1 },
    { 0x12B8, 0x12BE, 1 },
    { 0x12C0, 0x12C2, 2 },
    { 0x12C3, 0x12C5, 1 },
    { 0x12C8, 0x12D6, 1 },
    { 0x12D8, 0x1310, 1 },
    { 0x1312, 0x1315, 1 },
    { 0x1318, 0x135A, 1 },
    { 0x1360, 0x137C, 1 },
    { 0x1380, 0x1399, 1 },
    { 0x13A0, 0x13F5, 1 },
    { 0x13F8, 0x13FD, 1 },
    { 0x1400, 0x169C, 1 },
    { 0x16A0, 0x16F8, 1 },
    { 0x1700, 0x1711, 1 },
    { 0x1715, 0x171F, 10 },
    { 0x1720, 0x1731, 1 },
    { 0x1734, 0x1736, 1 },
    { 0x1740, 0x1751, 1 },
    { 0x1760, 0x176C, 1 },
    { 0x176E, 0x1770, 1 },
    { 0x1780, 0x17B3, 1 },
    { 0x17B6, 0x17BE, 8 },
    { 0x17BF, 0x17C5, 1 },
    { 0x17C7, 0x17C8, 1 },
    { 0x17D4, 0x17DC, 1 },
    { 0x17E0, 0x17E9, 1 },
    { 0x17F0, 0x17F9, 1 },
    { 0x1800, 0x180A, 1 },
    { 0x1810, 0x1819, 1 },
    { 0x1820, 0x1878, 1 },
    { 0x1880, 0x1884, 1 },
    { 0x1887, 0x18A8, 1 },
    { 0x18AA, 0x18B0, 6 },
    { 0x18B1, 0x18F5, 1 },
    { 0x1900, 0x191E, 1 },
    { 0x1923, 0x1926, 1 },
    { 0x1929, 0x192B, 1 },
    { 0x1930, 0x1931, 1 },
    { 0x1933, 0x1938, 1 },
    { 0x1940, 0x1944, 4 },
    { 0x1945, 0x196D, 1 },
    { 0x1970, 0x1974, 1 },
    { 0x1980, 0x19AB, 1 },
    { 0x19B0, 0x19C9, 1 },
    { 0x19D0, 0x19DA, 1 },
    { 0x19DE, 0x1A16, 1 },
    { 0x1A19, 0x1A1A, 1 },
    { 0x1A1E, 0x1A55, 1 },
    { 0x1A57, 0x1A61, 10 },
    { 0x1A63, 0x1A64, 1 },
    { 0x1A6D, 0x1A72, 1 },
    { 0x1A80, 0x1A89, 1 },
    { 0x1A90, 0x1A99, 1 },
    { 0x1AA0, 0x1AAD, 1 },
    { 0x1B04, 0x1B33, 1 },
    { 0x1B3B, 0x1B3D, 2 },
    { 0x1B3E, 0x1B41, 1 },
    { 0x1B43, 0x1B4C, 1 },
    { 0x1B50, 0x1B6A, 1 },
    { 0x1B74, 0x1B7E, 1 },
    { 0x1B82, 0x1BA1, 1 },
    { 0x1BA6, 0x1BA7, 1 },
    { 0x1BAA, 0x1BAE, 4 },
    { 0x1BAF, 0x1BE5, 1 },
    { 0x1BE7, 0x1BEA, 3 },
    { 0x1BEB, 0x1BEC, 1 },
    { 0x1BEE, 0x1BF2, 4 },
    { 0x1BF3, 0x1BFC, 9 },
    { 0x1BFD, 0x1C2B, 1 },
    { 0x1C34, 0x1C35, 1 },
    { 0x1C3B, 0x1C49, 1 },
    { 0x1C4D, 0x1C88, 1 },
    { 0x1C90, 0x1CBA, 1 },
    { 0x1CBD, 0x1CC7, 1 },
    { 0x1CD3, 0x1CE1, 14 },
    { 0x1CE9, 0x1CEC, 1 },
    { 0x1CEE, 0x1CF3, 1 },
    { 0x1CF5, 0x1CF7, 1 },
    { 0x1CFA, 0x1D00, 6 },
    { 0x1D01, 0x1DBF, 1 },
    { 0x1E00, 0x1F15, 1 },
    { 0x1F18, 0x1F1D, 1 },
    { 0x1F20, 0x1F45, 1 },
    { 0x1F48, 0x1F4D, 1 },
    { 0x1F50, 0x1F57, 1 },
    { 0x1F59, 0x1F5F, 2 },
    { 0x1F60, 0x1F7D, 1 },
    { 0x1F80, 0x1FB4, 1 },
    { 0x1FB6, 0x1FC4, 1 },
    { 0x1FC6, 0x1FD3, 1 },
    { 0x1FD6, 0x1FDB, 1 },
    { 0x1FDD, 0x1FEF, 1 },
    { 0x1FF2, 0x1FF4, 1 },
    { 0x1FF6, 0x1FFE, 1 },
    { 0x2000, 0x200A, 1 },
    { 0x2010, 0x2027, 1 },
    { 0x202F, 0x205F, 1 },
    { 0x2070, 0x2071, 1 },
    { 0x2074, 0x208E, 1 },
    { 0x2090, 0x209C, 1 },
    { 0x20A0, 0x20C0, 1 },
    { 0x2100, 0x218B, 1 },
    { 0x2190, 0x2426, 1 },
    { 0x2440, 0x244A, 1 },
    { 0x2460, 0x2B73, 1 },
    { 0x2B76, 0x2B95, 1 },
    { 0x2B97, 0x2CEE, 1 },
    { 0x2CF2, 0x2CF3, 1 },
    { 0x2CF9, 0x2D25, 1 },
    { 0x2D27, 0x2D2D, 6 },
    { 0x2D30, 0x2D67, 1 },
    { 0x2D6F, 0x2D70, 1 },
    { 0x2D80, 0x2D96, 1 },
    { 0x2DA0, 0x2DA6, 1 },
    { 0x2DA8, 0x2DAE, 1 },
    { 0x2DB0, 0x2DB6, 1 },
    { 0x2DB8, 0x2DBE, 1 },
    { 0x2DC0, 0x2DC6, 1 },
    { 0x2DC8, 0x2DCE, 1 },
    { 0x2DD0, 0x2DD6, 1 },
    { 0x2DD8, 0x2DDE, 1 },
    { 0x2E00, 0x2E5D, 1 },
    { 0x2E80, 0x2E99, 1 },
    { 0x2E9B, 0x2EF3, 1 },
    { 0x2F00, 0x2FD5, 1 },
    { 0x2FF0, 0x3029, 1 },
    { 0x3030, 0x303F, 1 },
    { 0x3041, 0x3096, 1 },
    { 0x309B, 0x30FF, 1 },
    { 0x3105, 0x312F, 1 },
    { 0x3131, 0x318E, 1 },
    { 0x3190, 0x31E3, 1 },
    { 0x31EF, 0x321E, 1 },
    { 0x3220, 0xA48C, 1 },
    { 0xA490, 0xA4C6, 1 },
    { 0xA4D0, 0xA62B, 1 },
    { 0xA640, 0xA66E, 1 },
    { 0xA673, 0xA67E, 11 },
    { 0xA67F, 0xA69D, 1 },
    { 0xA6A0, 0xA6EF, 1 },
    { 0xA6F2, 0xA6F7, 1 },
    { 0xA700, 0xA7CA, 1 },
    { 0xA7D0, 0xA7D1, 1 },
    { 0xA7D3, 0xA7D5, 2 },
    { 0xA7D6, 0xA7D9, 1 },
    { 0xA7F2, 0xA801, 1 },
    { 0xA803, 0xA805, 1 },
    { 0xA807, 0xA80A, 1 },
    { 0xA80C, 0xA824, 1 },
    { 0xA827, 0xA82B, 1 },
    { 0xA830, 0xA839, 1 },
    { 0xA840, 0xA877, 1 },
    { 0xA880, 0xA8C3, 1 },
    { 0xA8CE, 0xA8D9, 1 },
    { 0xA8F2, 0xA8FE, 1 },
    { 0xA900, 0xA925, 1 },
    { 0xA92E, 0xA946, 1 },
    { 0xA952, 0xA953, 1 },
    { 0xA95F, 0xA97C, 1 },
    { 0xA983, 0xA9B2, 1 },
    { 0xA9B4, 0xA9B5, 1 },
    { 0xA9BA, 0xA9BB, 1 },
    { 0xA9BE, 0xA9CD, 1 },
    { 0xA9CF, 0xA9D9, 1 },
    { 0xA9DE, 0xA9E4, 1 },
    { 0xA9E6, 0xA9FE, 1 },
    { 0xAA00, 0xAA28, 1 },
    { 0xAA2F, 0xAA30, 1 },
    { 0xAA33, 0xAA34, 1 },
    { 0xAA40, 0xAA42, 1 },
    { 0xAA44, 0xAA4B, 1 },
    { 0xAA4D, 0xAA50, 3 },
    { 0xAA51, 0xAA59, 1 },
    { 0xAA5C, 0xAA7B, 1 },
    { 0xAA7D, 0xAAAF, 1 },
    { 0xAAB1, 0xAAB5, 4 },
    { 0xAAB6, 0xAAB9, 3 },
    { 0xAABA, 0xAABD, 1 },
    { 0xAAC0, 0xAAC2, 2 },
    { 0xAADB, 0xAAEB, 1 },
    { 0xAAEE, 0xAAF5, 1 },
    { 0xAB01, 0xAB06, 1 },
    { 0xAB09, 0xAB0E, 1 },
    { 0xAB11, 0xAB16, 1 },
    { 0xAB20, 0xAB26, 1 },
    { 0xAB28, 0xAB2E, 1 },
    { 0xAB30, 0xAB6B, 1 },
    { 0xAB70, 0xABE4, 1 },
    { 0xABE6, 0xABE7, 1 },
    { 0xABE9, 0xABEC, 1 },
    { 0xABF0, 0xABF9, 1 },
    { 0xAC00, 0xD7A3, 1 },
    { 0xD7B0, 0xD7C6, 1 },
    { 0xD7CB, 0xD7FB, 1 },
    { 0xF900, 0xFA6D, 1 },
    { 0xFA70, 0xFAD9, 1 },
    { 0xFB00, 0xFB06, 1 },
    { 0xFB13, 0xFB17, 1 },
    { 0xFB1D, 0xFB1F, 2 },
    { 0xFB20, 0xFB36, 1 },
    { 0xFB38, 0xFB3C, 1 },
    { 0xFB3E, 0xFB40, 2 },
    { 0xFB41, 0xFB43, 2 },
    { 0xFB44, 0xFB46, 2 },
    { 0xFB47, 0xFBC2, 1 },
    { 0xFBD3, 0xFD8F, 1 },
    { 0xFD92, 0xFDC7, 1 },
    { 0xFDCF, 0xFDF0, 33 },
    { 0xFDF1, 0xFDFF, 1 },
    { 0xFE10, 0xFE19, 1 },
    { 0xFE30, 0xFE52, 1 },
    { 0xFE54, 0xFE66, 1 },
    { 0xFE68, 0xFE6B, 1 },
    { 0xFE70, 0xFE74, 1 },
    { 0xFE76, 0xFEFC, 1 },
    { 0xFF01, 0xFF9D, 1 },
    { 0xFFA0, 0xFFBE, 1 },
    { 0xFFC2, 0xFFC7, 1 },
    { 0xFFCA, 0xFFCF, 1 },
    { 0xFFD2, 0xFFD7, 1 },
    { 0xFFDA, 0xFFDC, 1 },
    { 0xFFE0, 0xFFE6, 1 },
    { 0xFFE8, 0xFFEE, 1 },
    { 0xFFFC, 0xFFFD, 1 },
    { 0x10000, 0x1000B, 1 },
    { 0x1000D, 0x10026, 1 },
    { 0x10028, 0x1003A, 1 },
    { 0x1003C, 0x1003D, 1 },
    { 0x1003F, 0x1004D, 1 },
    { 0x10050, 0x1005D, 1 },
    { 0x10080, 0x100FA, 1 },
    { 0x10100, 0x10102, 1 },
    { 0x10107, 0x10133, 1 },
    { 0x10137, 0x1018E, 1 },
    { 0x10190, 0x1019C, 1 },
    { 0x101A0, 0x101D0, 48 },
    { 0x101D1, 0x101FC, 1 },
    { 0x10280, 0x1029C, 1 },
    { 0x102A0, 0x102D0, 1 },
    { 0x102E1, 0x102FB, 1 },
    { 0x10300, 0x10323, 1 },
    { 0x1032D, 0x1034A, 1 },
    { 0x10350, 0x10375, 1 },
    { 0x10380, 0x1039D, 1 },
    { 0x1039F, 0x103C3, 1 },
    { 0x103C8, 0x103D5, 1 },
    { 0x10400, 0x1049D, 1 },
    { 0x104A0, 0x104A9, 1 },
    { 0x104B0, 0x104D3, 1 },
    { 0x104D8, 0x104FB, 1 },
    { 0x10500, 0x10527, 1 },
    { 0x10530, 0x10563, 1 },
    { 0x1056F, 0x1057A, 1 },
    { 0x1057C, 0x1058A, 1 },
    { 0x1058C, 0x10592, 1 },
    { 0x10594, 0x10595, 1 },
    { 0x10597, 0x105A1, 1 },
    { 0x105A3, 0x105B1, 1 },
    { 0x105B3, 0x105B9, 1 },
    { 0x105BB, 0x105BC, 1 },
    { 0x10600, 0x10736, 1 },
    { 0x10740, 0x10755, 1 },
    { 0x10760, 0x10767, 1 },
    { 0x10780, 0x10785, 1 },
    { 0x10787, 0x107B0, 1 },
    { 0x107B2, 0x107BA, 1 },
    { 0x10800, 0x10805, 1 },
    { 0x10808, 0x1080A, 2 },
    { 0x1080B, 0x10835, 1 },
    { 0x10837, 0x10838, 1 },
    { 0x1083C, 0x1083F, 3 },
    { 0x10840, 0x10855, 1 },
    { 0x10857, 0x1089E, 1 },
    { 0x108A7, 0x108AF, 1 },
    { 0x108E0, 0x108F2, 1 },
    { 0x108F4, 0x108F5, 1 },
    { 0x108FB, 0x1091B, 1 },
    { 0x1091F, 0x10939, 1 },
    { 0x1093F, 0x10980, 65 },
    { 0x10981, 0x109B7, 1 },
    { 0x109BC, 0x109CF, 1 },
    { 0x109D2, 0x10A00, 1 },
    { 0x10A10, 0x10A13, 1 },
    { 0x10A15, 0x10A17, 1 },
    { 0x10A19, 0x10A35, 1 },
    { 0x10A40, 0x10A48, 1 },
    { 0x10A50, 0x10A58, 1 },
    { 0x10A60, 0x10A9F, 1 },
    { 0x10AC0, 0x10AE4, 1 },
    { 0x10AEB, 0x10AF6, 1 },
    { 0x10B00, 0x10B35, 1 },
    { 0x10B39, 0x10B55, 1 },
    { 0x10B58, 0x10B72, 1 },
    { 0x10B78, 0x10B91, 1 },
    { 0x10B99, 0x10B9C, 1 },
    { 0x10BA9, 0x10BAF, 1 },
    { 0x10C00, 0x10C48, 1 },
    { 0x10C80, 0x10CB2, 1 },
    { 0x10CC0, 0x10CF2, 1 },
    { 0x10CFA, 0x10D23, 1 },
    { 0x10D30, 0x10D39, 1 },
    { 0x10E60, 0x10E7E, 1 },
    { 0x10E80, 0x10EA9, 1 },
    { 0x10EAD, 0x10EB0, 3 },
    { 0x10EB1, 0x10F00, 79 },
    { 0x10F01, 0x10F27, 1 },
    { 0x10F30, 0x10F45, 1 },
    { 0x10F51, 0x10F59, 1 },
    { 0x10F70, 0x10F81, 1 },
    { 0x10F86, 0x10F89, 1 },
    { 0x10FB0, 0x10FCB, 1 },
    { 0x10FE0, 0x10FF6, 1 },
    { 0x11000, 0x11002, 2 },
    { 0x11003, 0x11037, 1 },
    { 0x11047, 0x1104D, 1 },
    { 0x11052, 0x1106F, 1 },
    { 0x11071, 0x11072, 1 },
    { 0x11075, 0x11082, 13 },
    { 0x11083, 0x110B2, 1 },
    { 0x110B7, 0x110B8, 1 },
    { 0x110BB, 0x110BC, 1 },
    { 0x110BE, 0x110C1, 1 },
    { 0x110D0, 0x110E8, 1 },
    { 0x110F0, 0x110F9, 1 },
    { 0x11103, 0x11126, 1 },
    { 0x1112C, 0x11136, 10 },
    { 0x11137, 0x11147, 1 },
    { 0x11150, 0x11172, 1 },
    { 0x11174, 0x11176, 1 },
    { 0x11182, 0x111B5, 1 },
    { 0x111BF, 0x111C8, 1 },
    { 0x111CD, 0x111CE, 1 },
    { 0x111D0, 0x111DF, 1 },
    { 0x111E1, 0x111F4, 1 },
    { 0x11200, 0x11211, 1 },
    { 0x11213, 0x1122E, 1 },
    { 0x11232, 0x11233, 1 },
    { 0x11235, 0x11238, 3 },
    { 0x11239, 0x1123D, 1 },
    { 0x1123F, 0x11240, 1 },
    { 0x11280, 0x11286, 1 },
    { 0x11288, 0x1128A, 2 },
    { 0x1128B, 0x1128D, 1 },
    { 0x1128F, 0x1129D, 1 },
    { 0x1129F, 0x112A9, 1 },
    { 0x112B0, 0x112DE, 1 },
    { 0x112E0, 0x112E2, 1 },
    { 0x112F0, 0x112F9, 1 },
    { 0x11302, 0x11303, 1 },
    { 0x11305, 0x1130C, 1 },
    { 0x1130F, 0x11310, 1 },
    { 0x11313, 0x11328, 1 },
    { 0x1132A, 0x11330, 1 },
    { 0x11332, 0x11333, 1 },
    { 0x11335, 0x11339, 1 },
    { 0x1133D, 0x11341, 2 },
    { 0x11342, 0x11344, 1 },
    { 0x11347, 0x11348, 1 },
    { 0x1134B, 0x1134D, 1 },
    { 0x11350, 0x1135D, 13 },
    { 0x1135E, 0x11363, 1 },
    { 0x11400, 0x11437, 1 },
    { 0x11440, 0x11441, 1 },
    { 0x11445, 0x11447, 2 },
    { 0x11448, 0x1145B, 1 },
    { 0x1145D, 0x1145F, 2 },
    { 0x11460, 0x11461, 1 },
    { 0x11480, 0x114AF, 1 },
    { 0x114B1, 0x114B2, 1 },
    { 0x114B9, 0x114BB, 2 },
    { 0x114BC, 0x114BE, 2 },
    { 0x114C1, 0x114C4, 3 },
    { 0x114C5, 0x114C7, 1 },
    { 0x114D0, 0x114D9, 1 },
    { 0x11580, 0x115AE, 1 },
    { 0x115B0, 0x115B1, 1 },
    { 0x115B8, 0x115BB, 1 },
    { 0x115BE, 0x115C1, 3 },
    { 0x115C2, 0x115DB, 1 },
    { 0x11600, 0x11632, 1 },
    { 0x1163B, 0x1163C, 1 },
    { 0x1163E, 0x11641, 3 },
    { 0x11642, 0x11644, 1 },
    { 0x11650, 0x11659, 1 },
    { 0x11660, 0x1166C, 1 },
    { 0x11680, 0x116AA, 1 },
    { 0x116AC, 0x116AE, 2 },
    { 0x116AF, 0x116B6, 7 },
    { 0x116B8, 0x116B9, 1 },
    { 0x116C0, 0x116C9, 1 },
    { 0x11700, 0x1171A, 1 },
    { 0x11720, 0x11721, 1 },
    { 0x11726, 0x11730, 10 },
    { 0x11731, 0x11746, 1 },
    { 0x11800, 0x1182E, 1 },
    { 0x11838, 0x1183B, 3 },
    { 0x118A0, 0x118F2, 1 },
    { 0x118FF, 0x11906, 1 },
    { 0x11909, 0x1190C, 3 },
    { 0x1190D, 0x11913, 1 },
    { 0x11915, 0x11916, 1 },
    { 0x11918, 0x1192F, 1 },
    { 0x11931, 0x11935, 1 },
    { 0x11937, 0x11938, 1 },
    { 0x1193D, 0x1193F, 2 },
    { 0x11940, 0x11942, 1 },
    { 0x11944, 0x11946, 1 },
    { 0x11950, 0x11959, 1 },
    { 0x119A0, 0x119A7, 1 },
    { 0x119AA, 0x119D3, 1 },
    { 0x119DC, 0x119DF, 1 },
    { 0x119E1, 0x119E4, 1 },
    { 0x11A00, 0x11A0B, 11 },
    { 0x11A0C, 0x11A32, 1 },
    { 0x11A39, 0x11A3A, 1 },
    { 0x11A3F, 0x11A46, 1 },
    { 0x11A50, 0x11A57, 7 },
    { 0x11A58, 0x11A5C, 4 },
    { 0x11A5D, 0x11A89, 1 },
    { 0x11A97, 0x11A9A, 3 },
    { 0x11A9B, 0x11AA2, 1 },
    { 0x11AB0, 0x11AF8, 1 },
    { 0x11B00, 0x11B09, 1 },
    { 0x11C00, 0x11C08, 1 },
    { 0x11C0A, 0x11C2F, 1 },
    { 0x11C3E, 0x11C40, 2 },
    { 0x11C41, 0x11C45, 1 },
    { 0x11C50, 0x11C6C, 1 },
    { 0x11C70, 0x11C8F, 1 },
    { 0x11CA9, 0x11CB1, 8 },
    { 0x11CB4, 0x11D00, 76 },
    { 0x11D01, 0x11D06, 1 },
    { 0x11D08, 0x11D09, 1 },
    { 0x11D0B, 0x11D30, 1 },
    { 0x11D46, 0x11D50, 10 },
    { 0x11D51, 0x11D59, 1 },
    { 0x11D60, 0x11D65, 1 },
    { 0x11D67, 0x11D68, 1 },
    { 0x11D6A, 0x11D8E, 1 },
    { 0x11D93, 0x11D94, 1 },
    { 0x11D96, 0x11D98, 2 },
    { 0x11DA0, 0x11DA9, 1 },
    { 0x11EE0, 0x11EF2, 1 },
    { 0x11EF5, 0x11EF8, 1 },
    { 0x11F02, 0x11F10, 1 },
    { 0x11F12, 0x11F35, 1 },
    { 0x11F3E, 0x11F3F, 1 },
    { 0x11F41, 0x11F43, 2 },
    { 0x11F44, 0x11F59, 1 },
    { 0x11FB0, 0x11FC0, 16 },
    { 0x11FC1, 0x11FF1, 1 },
    { 0x11FFF, 0x12399, 1 },
    { 0x12400, 0x1246E, 1 },
    { 0x12470, 0x12474, 1 },
    { 0x12480, 0x12543, 1 },
    { 0x12F90, 0x12FF2, 1 },
    { 0x13000, 0x1342F, 1 },
    { 0x13441, 0x13446, 1 },
    { 0x14400, 0x14646, 1 },
    { 0x16800, 0x16A38, 1 },
    { 0x16A40, 0x16A5E, 1 },
    { 0x16A60, 0x16A69, 1 },
    { 0x16A6E, 0x16ABE, 1 },
    { 0x16AC0, 0x16AC9, 1 },
    { 0x16AD0, 0x16AED, 1 },
    { 0x16AF5, 0x16B00, 11 },
    { 0x16B01, 0x16B2F, 1 },
    { 0x16B37, 0x16B45, 1 },
    { 0x16B50, 0x16B59, 1 },
    { 0x16B5B, 0x16B61, 1 },
    { 0x16B63, 0x16B77, 1 },
    { 0x16B7D, 0x16B8F, 1 },
    { 0x16E40, 0x16E9A, 1 },
    { 0x16F00, 0x16F4A, 1 },
    { 0x16F50, 0x16F87, 1 },
    { 0x16F93, 0x16F9F, 1 },
    { 0x16FE0, 0x16FE3, 1 },
    { 0x16FF0, 0x16FF1, 1 },
    { 0x17000, 0x187F7, 1 },
    { 0x18800, 0x18CD5, 1 },
    { 0x18D00, 0x18D08, 1 },
    { 0x1AFF0, 0x1AFF3, 1 },
    { 0x1AFF5, 0x1AFFB, 1 },
    { 0x1AFFD, 0x1AFFE, 1 },
    { 0x1B000, 0x1B122, 1 },
    { 0x1B132, 0x1B150, 30 },
    { 0x1B151, 0x1B152, 1 },
    { 0x1B155, 0x1B164, 15 },
    { 0x1B165, 0x1B167, 1 },
    { 0x1B170, 0x1B2FB, 1 },
    { 0x1BC00, 0x1BC6A, 1 },
    { 0x1BC70, 0x1BC7C, 1 },
    { 0x1BC80, 0x1BC88, 1 },
    { 0x1BC90, 0x1BC99, 1 },
    { 0x1BC9C, 0x1BC9F, 3 },
    { 0x1CF50, 0x1CFC3, 1 },
    { 0x1D000, 0x1D0F5, 1 },
    { 0x1D100, 0x1D126, 1 },
    { 0x1D129, 0x1D164, 1 },
    { 0x1D166, 0x1D16A, 4 },
    { 0x1D16B, 0x1D16D, 1 },
    { 0x1D183, 0x1D184, 1 },
    { 0x1D18C, 0x1D1A9, 1 },
    { 0x1D1AE, 0x1D1EA, 1 },
    { 0x1D200, 0x1D241, 1 },
    { 0x1D245, 0x1D2C0, 123 },
    { 0x1D2C1, 0x1D2D3, 1 },
    { 0x1D2E0, 0x1D2F3, 1 },
    { 0x1D300, 0x1D356, 1 },
    { 0x1D360, 0x1D378, 1 },
    { 0x1D400, 0x1D454, 1 },
    { 0x1D456, 0x1D49C, 1 },
    { 0x1D49E, 0x1D49F, 1 },
    { 0x1D4A2, 0x1D4A5, 3 },
    { 0x1D4A6, 0x1D4A9, 3 },
    { 0x1D4AA, 0x1D4AC, 1 },
    { 0x1D4AE, 0x1D4B9, 1 },
    { 0x1D4BB, 0x1D4BD, 2 },
    { 0x1D4BE, 0x1D4C3, 1 },
    { 0x1D4C5, 0x1D505, 1 },
    { 0x1D507, 0x1D50A, 1 },
    { 0x1D50D, 0x1D514, 1 },
    { 0x1D516, 0x1D51C, 1 },
    { 0x1D51E, 0x1D539, 1 },
    { 0x1D53B, 0x1D53E, 1 },
    { 0x1D540, 0x1D544, 1 },
    { 0x1D546, 0x1D54A, 4 },
    { 0x1D54B, 0x1D550, 1 },
    { 0x1D552, 0x1D6A5, 1 },
    { 0x1D6A8, 0x1D7CB, 1 },
    { 0x1D7CE, 0x1D9FF, 1 },
    { 0x1DA37, 0x1DA3A, 1 },
    { 0x1DA6D, 0x1DA74, 1 },
    { 0x1DA76, 0x1DA83, 1 },
    { 0x1DA85, 0x1DA8B, 1 },
    { 0x1DF00, 0x1DF1E, 1 },
    { 0x1DF25, 0x1DF2A, 1 },
    { 0x1E030, 0x1E06D, 1 },
    { 0x1E100, 0x1E12C, 1 },
    { 0x1E137, 0x1E13D, 1 },
    { 0x1E140, 0x1E149, 1 },
    { 0x1E14E, 0x1E14F, 1 },
    { 0x1E290, 0x1E2AD, 1 },
    { 0x1E2C0, 0x1E2EB, 1 },
    { 0x1E2F0, 0x1E2F9, 1 },
    { 0x1E2FF, 0x1E4D0, 465 },
    { 0x1E4D1, 0x1E4EB, 1 },
    { 0x1E4F0, 0x1E4F9, 1 },
    { 0x1E7E0, 0x1E7E6, 1 },
    { 0x1E7E8, 0x1E7EB, 1 },
    { 0x1E7ED, 0x1E7EE, 1 },
    { 0x1E7F0, 0x1E7FE, 1 },
    { 0x1E800, 0x1E8C4, 1 },
    { 0x1E8C7, 0x1E8CF, 1 },
    { 0x1E900, 0x1E943, 1 },
    { 0x1E94B, 0x1E950, 5 },
    { 0x1E951, 0x1E959, 1 },
    { 0x1E95E, 0x1E95F, 1 },
    { 0x1EC71, 0x1ECB4, 1 },
    { 0x1ED01, 0x1ED3D, 1 },
    { 0x1EE00, 0x1EE03, 1 },
    { 0x1EE05, 0x1EE1F, 1 },
    { 0x1EE21, 0x1EE22, 1 },
    { 0x1EE24, 0x1EE27, 3 },
    { 0x1EE29, 0x1EE32, 1 },
    { 0x1EE34, 0x1EE37, 1 },
    { 0x1EE39, 0x1EE3B, 2 },
    { 0x1EE42, 0x1EE47, 5 },
    { 0x1EE49, 0x1EE4D, 2 },
    { 0x1EE4E, 0x1EE4F, 1 },
    { 0x1EE51, 0x1EE52, 1 },
    { 0x1EE54, 0x1EE57, 3 },
    { 0x1EE59, 0x1EE61, 2 },
    { 0x1EE62, 0x1EE64, 2 },
    { 0x1EE67, 0x1EE6A, 1 },
    { 0x1EE6C, 0x1EE72, 1 },
    { 0x1EE74, 0x1EE77, 1 },
    { 0x1EE79, 0x1EE7C, 1 },
    { 0x1EE7E, 0x1EE80, 2 },
    { 0x1EE81, 0x1EE89, 1 },
    { 0x1EE8B, 0x1EE9B, 1 },
    { 0x1EEA1, 0x1EEA3, 1 },
    { 0x1EEA5, 0x1EEA9, 1 },
    { 0x1EEAB, 0x1EEBB, 1 },
    { 0x1EEF0, 0x1EEF1, 1 },
    { 0x1F000, 0x1F02B, 1 },
    { 0x1F030, 0x1F093, 1 },
    { 0x1F0A0, 0x1F0AE, 1 },
    { 0x1F0B1, 0x1F0BF, 1 },
    { 0x1F0C1, 0x1F0CF, 1 },
    { 0x1F0D1, 0x1F0F5, 1 },
    { 0x1F100, 0x1F1AD, 1 },
    { 0x1F1E6, 0x1F202, 1 },
    { 0x1F210, 0x1F23B, 1 },
    { 0x1F240, 0x1F248, 1 },
    { 0x1F250, 0x1F251, 1 },
    { 0x1F260, 0x1F265, 1 },
    { 0x1F300, 0x1F6D7, 1 },
    { 0x1F6DC, 0x1F6EC, 1 },
    { 0x1F6F0, 0x1F6FC, 1 },
    { 0x1F700, 0x1F776, 1 },
    { 0x1F77B, 0x1F7D9, 1 },
    { 0x1F7E0, 0x1F7EB, 1 },
    { 0x1F7F0, 0x1F800, 16 },
    { 0x1F801, 0x1F80B, 1 },
    { 0x1F810, 0x1F847, 1 },
    { 0x1F850, 0x1F859, 1 },
    { 0x1F860, 0x1F887, 1 },
    { 0x1F890, 0x1F8AD, 1 },
    { 0x1F8B0, 0x1F8B1, 1 },
    { 0x1F900, 0x1FA53, 1 },
    { 0x1FA60, 0x1FA6D, 1 },
    { 0x1FA70, 0x1FA7C, 1 },
    { 0x1FA80, 0x1FA88, 1 },
    { 0x1FA90, 0x1FABD, 1 },
    { 0x1FABF, 0x1FAC5, 1 },
    { 0x1FACE, 0x1FADB, 1 },
    { 0x1FAE0, 0x1FAE8, 1 },
    { 0x1FAF0, 0x1FAF8, 1 },
    { 0x1FB00, 0x1FB92, 1 },
    { 0x1FB94, 0x1FBCA, 1 },
    { 0x1FBF0, 0x1FBF9, 1 },
    { 0x20000, 0x2A6DF, 1 },
    { 0x2A700, 0x2B739, 1 },
    { 0x2B740, 0x2B81D, 1 },
    { 0x2B820, 0x2CEA1, 1 },
    { 0x2CEB0, 0x2EBE0, 1 },
    { 0x2EBF0, 0x2EE5D, 1 },
    { 0x2F800, 0x2FA1D, 1 },
    { 0x30000, 0x3134A, 1 },
    { 0x31350, 0x323AF, 1 },
};

static struct range_table compose_table[] = {
    { 0x300, 0x36F, 1 },
    { 0x483, 0x489, 1 },
    { 0x591, 0x5BD, 1 },
    { 0x5BF, 0x5C1, 2 },
    { 0x5C2, 0x5C4, 2 },
    { 0x5C5, 0x5C7, 2 },
    { 0x610, 0x61A, 1 },
    { 0x64B, 0x65F, 1 },
    { 0x670, 0x6D6, 102 },
    { 0x6D7, 0x6DC, 1 },
    { 0x6DF, 0x6E4, 1 },
    { 0x6E7, 0x6E8, 1 },
    { 0x6EA, 0x6ED, 1 },
    { 0x711, 0x730, 31 },
    { 0x731, 0x74A, 1 },
    { 0x7A6, 0x7B0, 1 },
    { 0x7EB, 0x7F3, 1 },
    { 0x7FD, 0x816, 25 },
    { 0x817, 0x819, 1 },
    { 0x81B, 0x823, 1 },
    { 0x825, 0x827, 1 },
    { 0x829, 0x82D, 1 },
    { 0x859, 0x85B, 1 },
    { 0x898, 0x89F, 1 },
    { 0x8CA, 0x8E1, 1 },
    { 0x8E3, 0x902, 1 },
    { 0x93A, 0x93C, 2 },
    { 0x941, 0x948, 1 },
    { 0x94D, 0x951, 4 },
    { 0x952, 0x957, 1 },
    { 0x962, 0x963, 1 },
    { 0x981, 0x9BC, 59 },
    { 0x9BE, 0x9C1, 3 },
    { 0x9C2, 0x9C4, 1 },
    { 0x9CD, 0x9D7, 10 },
    { 0x9E2, 0x9E3, 1 },
    { 0x9FE, 0xA01, 3 },
    { 0xA02, 0xA3C, 58 },
    { 0xA41, 0xA42, 1 },
    { 0xA47, 0xA48, 1 },
    { 0xA4B, 0xA4D, 1 },
    { 0xA51, 0xA70, 31 },
    { 0xA71, 0xA75, 4 },
    { 0xA81, 0xA82, 1 },
    { 0xABC, 0xAC1, 5 },
    { 0xAC2, 0xAC5, 1 },
    { 0xAC7, 0xAC8, 1 },
    { 0xACD, 0xAE2, 21 },
    { 0xAE3, 0xAFA, 23 },
    { 0xAFB, 0xAFF, 1 },
    { 0xB01, 0xB3C, 59 },
    { 0xB3E, 0xB3F, 1 },
    { 0xB41, 0xB44, 1 },
    { 0xB4D, 0xB55, 8 },
    { 0xB56, 0xB57, 1 },
    { 0xB62, 0xB63, 1 },
    { 0xB82, 0xBBE, 60 },
    { 0xBC0, 0xBCD, 13 },
    { 0xBD7, 0xC00, 41 },
    { 0xC04, 0xC3C, 56 },
    { 0xC3E, 0xC40, 1 },
    { 0xC46, 0xC48, 1 },
    { 0xC4A, 0xC4D, 1 },
    { 0xC55, 0xC56, 1 },
    { 0xC62, 0xC63, 1 },
    { 0xC81, 0xCBC, 59 },
    { 0xCBF, 0xCC2, 3 },
    { 0xCC6, 0xCCC, 6 },
    { 0xCCD, 0xCD5, 8 },
    { 0xCD6, 0xCE2, 12 },
    { 0xCE3, 0xD00, 29 },
    { 0xD01, 0xD3B, 58 },
    { 0xD3C, 0xD3E, 2 },
    { 0xD41, 0xD44, 1 },
    { 0xD4D, 0xD57, 10 },
    { 0xD62, 0xD63, 1 },
    { 0xD81, 0xDCA, 73 },
    { 0xDCF, 0xDD2, 3 },
    { 0xDD3, 0xDD4, 1 },
    { 0xDD6, 0xDDF, 9 },
    { 0xE31, 0xE34, 3 },
    { 0xE35, 0xE3A, 1 },
    { 0xE47, 0xE4E, 1 },
    { 0xEB1, 0xEB4, 3 },
    { 0xEB5, 0xEBC, 1 },
    { 0xEC8, 0xECE, 1 },
    { 0xF18, 0xF19, 1 },
    { 0xF35, 0xF39, 2 },
    { 0xF71, 0xF7E, 1 },
    { 0xF80, 0xF84, 1 },
    { 0xF86, 0xF87, 1 },
    { 0xF8D, 0xF97, 1 },
    { 0xF99, 0xFBC, 1 },
    { 0xFC6, 0x102D, 103 },
    { 0x102E, 0x1030, 1 },
    { 0x1032, 0x1037, 1 },
    { 0x1039, 0x103A, 1 },
    { 0x103D, 0x103E, 1 },
    { 0x1058, 0x1059, 1 },
    { 0x105E, 0x1060, 1 },
    { 0x1071, 0x1074, 1 },
    { 0x1082, 0x1085, 3 },
    { 0x1086, 0x108D, 7 },
    { 0x109D, 0x135D, 704 },
    { 0x135E, 0x135F, 1 },
    { 0x1712, 0x1714, 1 },
    { 0x1732, 0x1733, 1 },
    { 0x1752, 0x1753, 1 },
    { 0x1772, 0x1773, 1 },
    { 0x17B4, 0x17B5, 1 },
    { 0x17B7, 0x17BD, 1 },
    { 0x17C6, 0x17C9, 3 },
    { 0x17CA, 0x17D3, 1 },
    { 0x17DD, 0x180B, 46 },
    { 0x180C, 0x180D, 1 },
    { 0x180F, 0x1885, 118 },
    { 0x1886, 0x18A9, 35 },
    { 0x1920, 0x1922, 1 },
    { 0x1927, 0x1928, 1 },
    { 0x1932, 0x1939, 7 },
    { 0x193A, 0x193B, 1 },
    { 0x1A17, 0x1A18, 1 },
    { 0x1A1B, 0x1A56, 59 },
    { 0x1A58, 0x1A5E, 1 },
    { 0x1A60, 0x1A62, 2 },
    { 0x1A65, 0x1A6C, 1 },
    { 0x1A73, 0x1A7C, 1 },
    { 0x1A7F, 0x1AB0, 49 },
    { 0x1AB1, 0x1ACE, 1 },
    { 0x1B00, 0x1B03, 1 },
    { 0x1B34, 0x1B3A, 1 },
    { 0x1B3C, 0x1B42, 6 },
    { 0x1B6B, 0x1B73, 1 },
    { 0x1B80, 0x1B81, 1 },
    { 0x1BA2, 0x1BA5, 1 },
    { 0x1BA8, 0x1BA9, 1 },
    { 0x1BAB, 0x1BAD, 1 },
    { 0x1BE6, 0x1BE8, 2 },
    { 0x1BE9, 0x1BED, 4 },
    { 0x1BEF, 0x1BF1, 1 },
    { 0x1C2C, 0x1C33, 1 },
    { 0x1C36, 0x1C37, 1 },
    { 0x1CD0, 0x1CD2, 1 },
    { 0x1CD4, 0x1CE0, 1 },
    { 0x1CE2, 0x1CE8, 1 },
    { 0x1CED, 0x1CF4, 7 },
    { 0x1CF8, 0x1CF9, 1 },
    { 0x1DC0, 0x1DFF, 1 },
    { 0x200C, 0x20D0, 196 },
    { 0x20D1, 0x20F0, 1 },
    { 0x2CEF, 0x2CF1, 1 },
    { 0x2D7F, 0x2DE0, 97 },
    { 0x2DE1, 0x2DFF, 1 },
    { 0x302A, 0x302F, 1 },
    { 0x3099, 0x309A, 1 },
    { 0xA66F, 0xA672, 1 },
    { 0xA674, 0xA67D, 1 },
    { 0xA69E, 0xA69F, 1 },
    { 0xA6F0, 0xA6F1, 1 },
    { 0xA802, 0xA806, 4 },
    { 0xA80B, 0xA825, 26 },
    { 0xA826, 0xA82C, 6 },
    { 0xA8C4, 0xA8C5, 1 },
    { 0xA8E0, 0xA8F1, 1 },
    { 0xA8FF, 0xA926, 39 },
    { 0xA927, 0xA92D, 1 },
    { 0xA947, 0xA951, 1 },
    { 0xA980, 0xA982, 1 },
    { 0xA9B3, 0xA9B6, 3 },
    { 0xA9B7, 0xA9B9, 1 },
    { 0xA9BC, 0xA9BD, 1 },
    { 0xA9E5, 0xAA29, 68 },
    { 0xAA2A, 0xAA2E, 1 },
    { 0xAA31, 0xAA32, 1 },
    { 0xAA35, 0xAA36, 1 },
    { 0xAA43, 0xAA4C, 9 },
    { 0xAA7C, 0xAAB0, 52 },
    { 0xAAB2, 0xAAB4, 1 },
    { 0xAAB7, 0xAAB8, 1 },
    { 0xAABE, 0xAABF, 1 },
    { 0xAAC1, 0xAAEC, 43 },
    { 0xAAED, 0xAAF6, 9 },
    { 0xABE5, 0xABE8, 3 },
    { 0xABED, 0xFB1E, 20273 },
    { 0xFE00, 0xFE0F, 1 },
    { 0xFE20, 0xFE2F, 1 },
    { 0xFF9E, 0xFF9F, 1 },
    { 0x101FD, 0x102E0, 227 },
    { 0x10376, 0x1037A, 1 },
    { 0x10A01, 0x10A03, 1 },
    { 0x10A05, 0x10A06, 1 },
    { 0x10A0C, 0x10A0F, 1 },
    { 0x10A38, 0x10A3A, 1 },
    { 0x10A3F, 0x10AE5, 166 },
    { 0x10AE6, 0x10D24, 574 },
    { 0x10D25, 0x10D27, 1 },
    { 0x10EAB, 0x10EAC, 1 },
    { 0x10EFD, 0x10EFF, 1 },
    { 0x10F46, 0x10F50, 1 },
    { 0x10F82, 0x10F85, 1 },
    { 0x11001, 0x11038, 55 },
    { 0x11039, 0x11046, 1 },
    { 0x11070, 0x11073, 3 },
    { 0x11074, 0x1107F, 11 },
    { 0x11080, 0x11081, 1 },
    { 0x110B3, 0x110B6, 1 },
    { 0x110B9, 0x110BA, 1 },
    { 0x110C2, 0x11100, 62 },
    { 0x11101, 0x11102, 1 },
    { 0x11127, 0x1112B, 1 },
    { 0x1112D, 0x11134, 1 },
    { 0x11173, 0x11180, 13 },
    { 0x11181, 0x111B6, 53 },
    { 0x111B7, 0x111BE, 1 },
    { 0x111C9, 0x111CC, 1 },
    { 0x111CF, 0x1122F, 96 },
    { 0x11230, 0x11231, 1 },
    { 0x11234, 0x11236, 2 },
    { 0x11237, 0x1123E, 7 },
    { 0x11241, 0x112DF, 158 },
    { 0x112E3, 0x112EA, 1 },
    { 0x11300, 0x11301, 1 },
    { 0x1133B, 0x1133C, 1 },
    { 0x1133E, 0x11340, 2 },
    { 0x11357, 0x11366, 15 },
    { 0x11367, 0x1136C, 1 },
    { 0x11370, 0x11374, 1 },
    { 0x11438, 0x1143F, 1 },
    { 0x11442, 0x11444, 1 },
    { 0x11446, 0x1145E, 24 },
    { 0x114B0, 0x114B3, 3 },
    { 0x114B4, 0x114B8, 1 },
    { 0x114BA, 0x114BD, 3 },
    { 0x114BF, 0x114C0, 1 },
    { 0x114C2, 0x114C3, 1 },
    { 0x115AF, 0x115B2, 3 },
    { 0x115B3, 0x115B5, 1 },
    { 0x115BC, 0x115BD, 1 },
    { 0x115BF, 0x115C0, 1 },
    { 0x115DC, 0x115DD, 1 },
    { 0x11633, 0x1163A, 1 },
    { 0x1163D, 0x1163F, 2 },
    { 0x11640, 0x116AB, 107 },
    { 0x116AD, 0x116B0, 3 },
    { 0x116B1, 0x116B5, 1 },
    { 0x116B7, 0x1171D, 102 },
    { 0x1171E, 0x1171F, 1 },
    { 0x11722, 0x11725, 1 },
    { 0x11727, 0x1172B, 1 },
    { 0x1182F, 0x11837, 1 },
    { 0x11839, 0x1183A, 1 },
    { 0x11930, 0x1193B, 11 },
    { 0x1193C, 0x1193E, 2 },
    { 0x11943, 0x119D4, 145 },
    { 0x119D5, 0x119D7, 1 },
    { 0x119DA, 0x119DB, 1 },
    { 0x119E0, 0x11A01, 33 },
    { 0x11A02, 0x11A0A, 1 },
    { 0x11A33, 0x11A38, 1 },
    { 0x11A3B, 0x11A3E, 1 },
    { 0x11A47, 0x11A51, 10 },
    { 0x11A52, 0x11A56, 1 },
    { 0x11A59, 0x11A5B, 1 },
    { 0x11A8A, 0x11A96, 1 },
    { 0x11A98, 0x11A99, 1 },
    { 0x11C30, 0x11C36, 1 },
    { 0x11C38, 0x11C3D, 1 },
    { 0x11C3F, 0x11C92, 83 },
    { 0x11C93, 0x11CA7, 1 },
    { 0x11CAA, 0x11CB0, 1 },
    { 0x11CB2, 0x11CB3, 1 },
    { 0x11CB5, 0x11CB6, 1 },
    { 0x11D31, 0x11D36, 1 },
    { 0x11D3A, 0x11D3C, 2 },
    { 0x11D3D, 0x11D3F, 2 },
    { 0x11D40, 0x11D45, 1 },
    { 0x11D47, 0x11D90, 73 },
    { 0x11D91, 0x11D95, 4 },
    { 0x11D97, 0x11EF3, 348 },
    { 0x11EF4, 0x11F00, 12 },
    { 0x11F01, 0x11F36, 53 },
    { 0x11F37, 0x11F3A, 1 },
    { 0x11F40, 0x11F42, 2 },
    { 0x13440, 0x13447, 7 },
    { 0x13448, 0x13455, 1 },
    { 0x16AF0, 0x16AF4, 1 },
    { 0x16B30, 0x16B36, 1 },
    { 0x16F4F, 0x16F8F, 64 },
    { 0x16F90, 0x16F92, 1 },
    { 0x16FE4, 0x1BC9D, 19641 },
    { 0x1BC9E, 0x1CF00, 4706 },
    { 0x1CF01, 0x1CF2D, 1 },
    { 0x1CF30, 0x1CF46, 1 },
    { 0x1D165, 0x1D167, 2 },
    { 0x1D168, 0x1D169, 1 },
    { 0x1D16E, 0x1D172, 1 },
    { 0x1D17B, 0x1D182, 1 },
    { 0x1D185, 0x1D18B, 1 },
    { 0x1D1AA, 0x1D1AD, 1 },
    { 0x1D242, 0x1D244, 1 },
    { 0x1DA00, 0x1DA36, 1 },
    { 0x1DA3B, 0x1DA6C, 1 },
    { 0x1DA75, 0x1DA84, 15 },
    { 0x1DA9B, 0x1DA9F, 1 },
    { 0x1DAA1, 0x1DAAF, 1 },
    { 0x1E000, 0x1E006, 1 },
    { 0x1E008, 0x1E018, 1 },
    { 0x1E01B, 0x1E021, 1 },
    { 0x1E023, 0x1E024, 1 },
    { 0x1E026, 0x1E02A, 1 },
    { 0x1E08F, 0x1E130, 161 },
    { 0x1E131, 0x1E136, 1 },
    { 0x1E2AE, 0x1E2EC, 62 },
    { 0x1E2ED, 0x1E2EF, 1 },
    { 0x1E4EC, 0x1E4EF, 1 },
    { 0x1E8D0, 0x1E8D6, 1 },
    { 0x1E944, 0x1E94A, 1 },
    { 0xE0020, 0xE007F, 1 },
    { 0xE0100, 0xE01EF, 1 },
};

static struct range_table cntrl_table[] = {
    { 0x0, 0x1F, 1 },
    { 0x7F, 0x9F, 1 },
    { 0xAD, 0x600, 1363 },
    { 0x601, 0x605, 1 },
    { 0x61C, 0x6DD, 193 },
    { 0x70F, 0x890, 385 },
    { 0x891, 0x8E2, 81 },
    { 0x180E, 0x200B, 2045 },
    { 0x200C, 0x200F, 1 },
    { 0x202A, 0x202E, 1 },
    { 0x2060, 0x2064, 1 },
    { 0x2066, 0x206F, 1 },
    { 0xE000, 0xE000, 0 },
    { 0xE001, 0xF8FF, 1 },
    { 0xFEFF, 0xFFF9, 250 },
    { 0xFFFA, 0xFFFB, 1 },
    { 0x110BD, 0x110CD, 16 },
    { 0x13430, 0x1343F, 1 },
    { 0x1BCA0, 0x1BCA3, 1 },
    { 0x1D173, 0x1D17A, 1 },
    { 0xE0001, 0xE0020, 31 },
    { 0xE0021, 0xE007F, 1 },
    { 0xF0000, 0xF0000, 0 },
    { 0xF0001, 0xFFFFD, 1 },
    { 0x100000, 0x100000, 0 },
    { 0x100001, 0x10FFFD, 1 },
};

static struct range_table digit_table[] = {
    { 0x30, 0x39, 1 },
    { 0x660, 0x669, 1 },
    { 0x6F0, 0x6F9, 1 },
    { 0x7C0, 0x7C9, 1 },
    { 0x966, 0x96F, 1 },
    { 0x9E6, 0x9EF, 1 },
    { 0xA66, 0xA6F, 1 },
    { 0xAE6, 0xAEF, 1 },
    { 0xB66, 0xB6F, 1 },
    { 0xBE6, 0xBEF, 1 },
    { 0xC66, 0xC6F, 1 },
    { 0xCE6, 0xCEF, 1 },
    { 0xD66, 0xD6F, 1 },
    { 0xDE6, 0xDEF, 1 },
    { 0xE50, 0xE59, 1 },
    { 0xED0, 0xED9, 1 },
    { 0xF20, 0xF29, 1 },
    { 0x1040, 0x1049, 1 },
    { 0x1090, 0x1099, 1 },
    { 0x17E0, 0x17E9, 1 },
    { 0x1810, 0x1819, 1 },
    { 0x1946, 0x194F, 1 },
    { 0x19D0, 0x19D9, 1 },
    { 0x1A80, 0x1A89, 1 },
    { 0x1A90, 0x1A99, 1 },
    { 0x1B50, 0x1B59, 1 },
    { 0x1BB0, 0x1BB9, 1 },
    { 0x1C40, 0x1C49, 1 },
    { 0x1C50, 0x1C59, 1 },
    { 0xA620, 0xA629, 1 },
    { 0xA8D0, 0xA8D9, 1 },
    { 0xA900, 0xA909, 1 },
    { 0xA9D0, 0xA9D9, 1 },
    { 0xA9F0, 0xA9F9, 1 },
    { 0xAA50, 0xAA59, 1 },
    { 0xABF0, 0xABF9, 1 },
    { 0xFF10, 0xFF19, 1 },
    { 0x104A0, 0x104A9, 1 },
    { 0x10D30, 0x10D39, 1 },
    { 0x11066, 0x1106F, 1 },
    { 0x110F0, 0x110F9, 1 },
    { 0x11136, 0x1113F, 1 },
    { 0x111D0, 0x111D9, 1 },
    { 0x112F0, 0x112F9, 1 },
    { 0x11450, 0x11459, 1 },
    { 0x114D0, 0x114D9, 1 },
    { 0x11650, 0x11659, 1 },
    { 0x116C0, 0x116C9, 1 },
    { 0x11730, 0x11739, 1 },
    { 0x118E0, 0x118E9, 1 },
    { 0x11950, 0x11959, 1 },
    { 0x11C50, 0x11C59, 1 },
    { 0x11D50, 0x11D59, 1 },
    { 0x11DA0, 0x11DA9, 1 },
    { 0x11F50, 0x11F59, 1 },
    { 0x16A60, 0x16A69, 1 },
    { 0x16AC0, 0x16AC9, 1 },
    { 0x16B50, 0x16B59, 1 },
    { 0x1D7CE, 0x1D7FF, 1 },
    { 0x1E140, 0x1E149, 1 },
    { 0x1E2F0, 0x1E2F9, 1 },
    { 0x1E4F0, 0x1E4F9, 1 },
    { 0x1E950, 0x1E959, 1 },
    { 0x1FBF0, 0x1FBF9, 1 },
};

static struct range_table alnum_extend_table[] = {
    { 0x30, 0x39, 1 },
    { 0xB2, 0xB3, 1 },
    { 0xB9, 0xBC, 3 },
    { 0xBD, 0xBE, 1 },
    { 0x660, 0x669, 1 },
    { 0x6F0, 0x6F9, 1 },
    { 0x7C0, 0x7C9, 1 },
    { 0x966, 0x96F, 1 },
    { 0x9E6, 0x9EF, 1 },
    { 0x9F4, 0x9F9, 1 },
    { 0xA66, 0xA6F, 1 },
    { 0xAE6, 0xAEF, 1 },
    { 0xB66, 0xB6F, 1 },
    { 0xB72, 0xB77, 1 },
    { 0xBE6, 0xBF2, 1 },
    { 0xC66, 0xC6F, 1 },
    { 0xC78, 0xC7E, 1 },
    { 0xCE6, 0xCEF, 1 },
    { 0xD58, 0xD5E, 1 },
    { 0xD66, 0xD78, 1 },
    { 0xDE6, 0xDEF, 1 },
    { 0xE50, 0xE59, 1 },
    { 0xED0, 0xED9, 1 },
    { 0xF20, 0xF33, 1 },
    { 0x1040, 0x1049, 1 },
    { 0x1090, 0x1099, 1 },
    { 0x1369, 0x137C, 1 },
    { 0x16EE, 0x16F0, 1 },
    { 0x17E0, 0x17E9, 1 },
    { 0x17F0, 0x17F9, 1 },
    { 0x1810, 0x1819, 1 },
    { 0x1946, 0x194F, 1 },
    { 0x19D0, 0x19DA, 1 },
    { 0x1A80, 0x1A89, 1 },
    { 0x1A90, 0x1A99, 1 },
    { 0x1B50, 0x1B59, 1 },
    { 0x1BB0, 0x1BB9, 1 },
    { 0x1C40, 0x1C49, 1 },
    { 0x1C50, 0x1C59, 1 },
    { 0x2070, 0x2074, 4 },
    { 0x2075, 0x2079, 1 },
    { 0x2080, 0x2089, 1 },
    { 0x2150, 0x2182, 1 },
    { 0x2185, 0x2189, 1 },
    { 0x2460, 0x249B, 1 },
    { 0x24EA, 0x24FF, 1 },
    { 0x2776, 0x2793, 1 },
    { 0x2CFD, 0x3007, 778 },
    { 0x3021, 0x3029, 1 },
    { 0x3038, 0x303A, 1 },
    { 0x3192, 0x3195, 1 },
    { 0x3220, 0x3229, 1 },
    { 0x3248, 0x324F, 1 },
    { 0x3251, 0x325F, 1 },
    { 0x3280, 0x3289, 1 },
    { 0x32B1, 0x32BF, 1 },
    { 0xA620, 0xA629, 1 },
    { 0xA6E6, 0xA6EF, 1 },
    { 0xA830, 0xA835, 1 },
    { 0xA8D0, 0xA8D9, 1 },
    { 0xA900, 0xA909, 1 },
    { 0xA9D0, 0xA9D9, 1 },
    { 0xA9F0, 0xA9F9, 1 },
    { 0xAA50, 0xAA59, 1 },
    { 0xABF0, 0xABF9, 1 },
    { 0xFF10, 0xFF19, 1 },
    { 0x10107, 0x10133, 1 },
    { 0x10140, 0x10178, 1 },
    { 0x1018A, 0x1018B, 1 },
    { 0x102E1, 0x102FB, 1 },
    { 0x10320, 0x10323, 1 },
    { 0x10341, 0x1034A, 9 },
    { 0x103D1, 0x103D5, 1 },
    { 0x104A0, 0x104A9, 1 },
    { 0x10858, 0x1085F, 1 },
    { 0x10879, 0x1087F, 1 },
    { 0x108A7, 0x108AF, 1 },
    { 0x108FB, 0x108FF, 1 },
    { 0x10916, 0x1091B, 1 },
    { 0x109BC, 0x109BD, 1 },
    { 0x109C0, 0x109CF, 1 },
    { 0x109D2, 0x109FF, 1 },
    { 0x10A40, 0x10A48, 1 },
    { 0x10A7D, 0x10A7E, 1 },
    { 0x10A9D, 0x10A9F, 1 },
    { 0x10AEB, 0x10AEF, 1 },
    { 0x10B58, 0x10B5F, 1 },
    { 0x10B78, 0x10B7F, 1 },
    { 0x10BA9, 0x10BAF, 1 },
    { 0x10CFA, 0x10CFF, 1 },
    { 0x10D30, 0x10D39, 1 },
    { 0x10E60, 0x10E7E, 1 },
    { 0x10F1D, 0x10F26, 1 },
    { 0x10F51, 0x10F54, 1 },
    { 0x10FC5, 0x10FCB, 1 },
    { 0x11052, 0x1106F, 1 },
    { 0x110F0, 0x110F9, 1 },
    { 0x11136, 0x1113F, 1 },
    { 0x111D0, 0x111D9, 1 },
    { 0x111E1, 0x111F4, 1 },
    { 0x112F0, 0x112F9, 1 },
    { 0x11450, 0x11459, 1 },
    { 0x114D0, 0x114D9, 1 },
    { 0x11650, 0x11659, 1 },
    { 0x116C0, 0x116C9, 1 },
    { 0x11730, 0x1173B, 1 },
    { 0x118E0, 0x118F2, 1 },
    { 0x11950, 0x11959, 1 },
    { 0x11C50, 0x11C6C, 1 },
    { 0x11D50, 0x11D59, 1 },
    { 0x11DA0, 0x11DA9, 1 },
    { 0x11F50, 0x11F59, 1 },
    { 0x11FC0, 0x11FD4, 1 },
    { 0x12400, 0x1246E, 1 },
    { 0x16A60, 0x16A69, 1 },
    { 0x16AC0, 0x16AC9, 1 },
    { 0x16B50, 0x16B59, 1 },
    { 0x16B5B, 0x16B61, 1 },
    { 0x16E80, 0x16E96, 1 },
    { 0x1D2C0, 0x1D2D3, 1 },
    { 0x1D2E0, 0x1D2F3, 1 },
    { 0x1D360, 0x1D378, 1 },
    { 0x1D7CE, 0x1D7FF, 1 },
    { 0x1E140, 0x1E149, 1 },
    { 0x1E2F0, 0x1E2F9, 1 },
    { 0x1E4F0, 0x1E4F9, 1 },
    { 0x1E8C7, 0x1E8CF, 1 },
    { 0x1E950, 0x1E959, 1 },
    { 0x1EC71, 0x1ECAB, 1 },
    { 0x1ECAD, 0x1ECAF, 1 },
    { 0x1ECB1, 0x1ECB4, 1 },
    { 0x1ED01, 0x1ED2D, 1 },
    { 0x1ED2F, 0x1ED3D, 1 },
    { 0x1F100, 0x1F10C, 1 },
    { 0x1FBF0, 0x1FBF9, 1 },
};

static struct range_table punct_table[] = {
    { 0x21, 0x2F, 1 },
    { 0x3A, 0x40, 1 },
    { 0x5B, 0x60, 1 },
    { 0x7B, 0x7E, 1 },
    { 0xA1, 0xA5, 1 },
    { 0xA7, 0xA8, 1 },
    { 0xAB, 0xAC, 1 },
    { 0xAF, 0xB1, 2 },
    { 0xB4, 0xB6, 2 },
    { 0xB7, 0xB8, 1 },
    { 0xBB, 0xBF, 4 },
    { 0xD7, 0xF7, 32 },
    { 0x2C2, 0x2C5, 1 },
    { 0x2D2, 0x2DF, 1 },
    { 0x2E5, 0x2EB, 1 },
    { 0x2ED, 0x2EF, 2 },
    { 0x2F0, 0x2FF, 1 },
    { 0x375, 0x37E, 9 },
    { 0x384, 0x385, 1 },
    { 0x387, 0x3F6, 111 },
    { 0x55A, 0x55F, 1 },
    { 0x589, 0x58A, 1 },
    { 0x58F, 0x5BE, 47 },
    { 0x5C0, 0x5C6, 3 },
    { 0x5F3, 0x5F4, 1 },
    { 0x606, 0x60D, 1 },
    { 0x61B, 0x61D, 2 },
    { 0x61E, 0x61F, 1 },
    { 0x66A, 0x66D, 1 },
    { 0x6D4, 0x700, 44 },
    { 0x701, 0x70D, 1 },
    { 0x7F7, 0x7F9, 1 },
    { 0x7FE, 0x7FF, 1 },
    { 0x830, 0x83E, 1 },
    { 0x85E, 0x888, 42 },
    { 0x964, 0x965, 1 },
    { 0x970, 0x9F2, 130 },
    { 0x9F3, 0x9FB, 8 },
    { 0x9FD, 0xA76, 121 },
    { 0xAF0, 0xAF1, 1 },
    { 0xBF9, 0xC77, 126 },
    { 0xC84, 0xDF4, 368 },
    { 0xE3F, 0xE4F, 16 },
    { 0xE5A, 0xE5B, 1 },
    { 0xF04, 0xF12, 1 },
    { 0xF14, 0xF3A, 38 },
    { 0xF3B, 0xF3D, 1 },
    { 0xF85, 0xFD0, 75 },
    { 0xFD1, 0xFD4, 1 },
    { 0xFD9, 0xFDA, 1 },
    { 0x104A, 0x104F, 1 },
    { 0x10FB, 0x1360, 613 },
    { 0x1361, 0x1368, 1 },
    { 0x1400, 0x166E, 622 },
    { 0x169B, 0x169C, 1 },
    { 0x16EB, 0x16ED, 1 },
    { 0x1735, 0x1736, 1 },
    { 0x17D4, 0x17D6, 1 },
    { 0x17D8, 0x17DB, 1 },
    { 0x1800, 0x180A, 1 },
    { 0x1944, 0x1945, 1 },
    { 0x1A1E, 0x1A1F, 1 },
    { 0x1AA0, 0x1AA6, 1 },
    { 0x1AA8, 0x1AAD, 1 },
    { 0x1B5A, 0x1B60, 1 },
    { 0x1B7D, 0x1B7E, 1 },
    { 0x1BFC, 0x1BFF, 1 },
    { 0x1C3B, 0x1C3F, 1 },
    { 0x1C7E, 0x1C7F, 1 },
    { 0x1CC0, 0x1CC7, 1 },
    { 0x1CD3, 0x1FBD, 746 },
    { 0x1FBF, 0x1FC1, 1 },
    { 0x1FCD, 0x1FCF, 1 },
    { 0x1FDD, 0x1FDF, 1 },
    { 0x1FED, 0x1FEF, 1 },
    { 0x1FFD, 0x1FFE, 1 },
    { 0x2010, 0x2027, 1 },
    { 0x2030, 0x205E, 1 },
    { 0x207A, 0x207E, 1 },
    { 0x208A, 0x208E, 1 },
    { 0x20A0, 0x20C0, 1 },
    { 0x2118, 0x2140, 40 },
    { 0x2141, 0x2144, 1 },
    { 0x214B, 0x2190, 69 },
    { 0x2191, 0x2194, 1 },
    { 0x219A, 0x219B, 1 },
    { 0x21A0, 0x21A6, 3 },
    { 0x21AE, 0x21CE, 32 },
    { 0x21CF, 0x21D2, 3 },
    { 0x21D4, 0x21F4, 32 },
    { 0x21F5, 0x22FF, 1 },
    { 0x2308, 0x230B, 1 },
    { 0x2320, 0x2321, 1 },
    { 0x2329, 0x232A, 1 },
    { 0x237C, 0x239B, 31 },
    { 0x239C, 0x23B3, 1 },
    { 0x23DC, 0x23E1, 1 },
    { 0x25B7, 0x25C1, 10 },
    { 0x25F8, 0x25FF, 1 },
    { 0x266F, 0x2768, 249 },
    { 0x2769, 0x2775, 1 },
    { 0x27C0, 0x27FF, 1 },
    { 0x2900, 0x2AFF, 1 },
    { 0x2B30, 0x2B44, 1 },
    { 0x2B47, 0x2B4C, 1 },
    { 0x2CF9, 0x2CFC, 1 },
    { 0x2CFE, 0x2CFF, 1 },
    { 0x2D70, 0x2E00, 144 },
    { 0x2E01, 0x2E2E, 1 },
    { 0x2E30, 0x2E4F, 1 },
    { 0x2E52, 0x2E5D, 1 },
    { 0x3001, 0x3003, 1 },
    { 0x3008, 0x3011, 1 },
    { 0x3014, 0x301F, 1 },
    { 0x3030, 0x303D, 13 },
    { 0x309B, 0x309C, 1 },
    { 0x30A0, 0x30FB, 91 },
    { 0xA4FE, 0xA4FF, 1 },
    { 0xA60D, 0xA60F, 1 },
    { 0xA673, 0xA67E, 11 },
    { 0xA6F2, 0xA6F7, 1 },
    { 0xA700, 0xA716, 1 },
    { 0xA720, 0xA721, 1 },
    { 0xA789, 0xA78A, 1 },
    { 0xA838, 0xA874, 60 },
    { 0xA875, 0xA877, 1 },
    { 0xA8CE, 0xA8CF, 1 },
    { 0xA8F8, 0xA8FA, 1 },
    { 0xA8FC, 0xA92E, 50 },
    { 0xA92F, 0xA95F, 48 },
    { 0xA9C1, 0xA9CD, 1 },
    { 0xA9DE, 0xA9DF, 1 },
    { 0xAA5C, 0xAA5F, 1 },
    { 0xAADE, 0xAADF, 1 },
    { 0xAAF0, 0xAAF1, 1 },
    { 0xAB5B, 0xAB6A, 15 },
    { 0xAB6B, 0xABEB, 128 },
    { 0xFB29, 0xFBB2, 137 },
    { 0xFBB3, 0xFBC2, 1 },
    { 0xFD3E, 0xFD3F, 1 },
    { 0xFDFC, 0xFE10, 20 },
    { 0xFE11, 0xFE19, 1 },
    { 0xFE30, 0xFE52, 1 },
    { 0xFE54, 0xFE66, 1 },
    { 0xFE68, 0xFE6B, 1 },
    { 0xFF01, 0xFF0F, 1 },
    { 0xFF1A, 0xFF20, 1 },
    { 0xFF3B, 0xFF40, 1 },
    { 0xFF5B, 0xFF65, 1 },
    { 0xFFE0, 0xFFE3, 1 },
    { 0xFFE5, 0xFFE6, 1 },
    { 0xFFE9, 0xFFEC, 1 },
    { 0x10100, 0x10102, 1 },
    { 0x1039F, 0x103D0, 49 },
    { 0x1056F, 0x10857, 744 },
    { 0x1091F, 0x1093F, 32 },
    { 0x10A50, 0x10A58, 1 },
    { 0x10A7F, 0x10AF0, 113 },
    { 0x10AF1, 0x10AF6, 1 },
    { 0x10B39, 0x10B3F, 1 },
    { 0x10B99, 0x10B9C, 1 },
    { 0x10EAD, 0x10F55, 168 },
    { 0x10F56, 0x10F59, 1 },
    { 0x10F86, 0x10F89, 1 },
    { 0x11047, 0x1104D, 1 },
    { 0x110BB, 0x110BC, 1 },
    { 0x110BE, 0x110C1, 1 },
    { 0x11140, 0x11143, 1 },
    { 0x11174, 0x11175, 1 },
    { 0x111C5, 0x111C8, 1 },
    { 0x111CD, 0x111DB, 14 },
    { 0x111DD, 0x111DF, 1 },
    { 0x11238, 0x1123D, 1 },
    { 0x112A9, 0x1144B, 418 },
    { 0x1144C, 0x1144F, 1 },
    { 0x1145A, 0x1145B, 1 },
    { 0x1145D, 0x114C6, 105 },
    { 0x115C1, 0x115D7, 1 },
    { 0x11641, 0x11643, 1 },
    { 0x11660, 0x1166C, 1 },
    { 0x116B9, 0x1173C, 131 },
    { 0x1173D, 0x1173E, 1 },
    { 0x1183B, 0x11944, 265 },
    { 0x11945, 0x11946, 1 },
    { 0x119E2, 0x11A3F, 93 },
    { 0x11A40, 0x11A46, 1 },
    { 0x11A9A, 0x11A9C, 1 },
    { 0x11A9E, 0x11AA2, 1 },
    { 0x11B00, 0x11B09, 1 },
    { 0x11C41, 0x11C45, 1 },
    { 0x11C70, 0x11C71, 1 },
    { 0x11EF7, 0x11EF8, 1 },
    { 0x11F43, 0x11F4F, 1 },
    { 0x11FDD, 0x11FE0, 1 },
    { 0x11FFF, 0x12470, 1137 },
    { 0x12471, 0x12474, 1 },
    { 0x12FF1, 0x12FF2, 1 },
    { 0x16A6E, 0x16A6F, 1 },
    { 0x16AF5, 0x16B37, 66 },
    { 0x16B38, 0x16B3B, 1 },
    { 0x16B44, 0x16E97, 851 },
    { 0x16E98, 0x16E9A, 1 },
    { 0x16FE2, 0x1BC9F, 19645 },
    { 0x1D6C1, 0x1D6DB, 26 },
    { 0x1D6FB, 0x1D715, 26 },
    { 0x1D735, 0x1D74F, 26 },
    { 0x1D76F, 0x1D789, 26 },
    { 0x1D7A9, 0x1D7C3, 26 },
    { 0x1DA87, 0x1DA8B, 1 },
    { 0x1E2FF, 0x1E95E, 1631 },
    { 0x1E95F, 0x1ECB0, 849 },
    { 0x1EEF0, 0x1EEF1, 1 },
    { 0x1F3FB, 0x1F3FF, 1 },
};

static struct conv_table tolower_table[] = {
    { 0x41, 0x5A, 1, 32 },
    { 0xC0, 0xD6, 1, 32 },
    { 0xD8, 0xDE, 1, 32 },
    { 0x100, 0x12E, 2, 1 },
    { 0x130, 0x130, 1, -199 },
    { 0x132, 0x136, 2, 1 },
    { 0x139, 0x147, 2, 1 },
    { 0x14A, 0x176, 2, 1 },
    { 0x178, 0x178, 1, -121 },
    { 0x179, 0x17D, 2, 1 },
    { 0x181, 0x181, 1, 210 },
    { 0x182, 0x184, 2, 1 },
    { 0x186, 0x186, 1, 206 },
    { 0x187, 0x187, 1, 1 },
    { 0x189, 0x18A, 1, 205 },
    { 0x18B, 0x18B, 1, 1 },
    { 0x18E, 0x18E, 1, 79 },
    { 0x18F, 0x18F, 1, 202 },
    { 0x190, 0x190, 1, 203 },
    { 0x191, 0x191, 1, 1 },
    { 0x193, 0x193, 1, 205 },
    { 0x194, 0x194, 1, 207 },
    { 0x196, 0x196, 1, 211 },
    { 0x197, 0x197, 1, 209 },
    { 0x198, 0x198, 1, 1 },
    { 0x19C, 0x19C, 1, 211 },
    { 0x19D, 0x19D, 1, 213 },
    { 0x19F, 0x19F, 1, 214 },
    { 0x1A0, 0x1A4, 2, 1 },
    { 0x1A6, 0x1A6, 1, 218 },
    { 0x1A7, 0x1A7, 1, 1 },
    { 0x1A9, 0x1A9, 1, 218 },
    { 0x1AC, 0x1AC, 1, 1 },
    { 0x1AE, 0x1AE, 1, 218 },
    { 0x1AF, 0x1AF, 1, 1 },
    { 0x1B1, 0x1B2, 1, 217 },
    { 0x1B3, 0x1B5, 2, 1 },
    { 0x1B7, 0x1B7, 1, 219 },
    { 0x1B8, 0x1BC, 4, 1 },
    { 0x1C4, 0x1C4, 1, 2 },
    { 0x1C5, 0x1C5, 1, 1 },
    { 0x1C7, 0x1C7, 1, 2 },
    { 0x1C8, 0x1C8, 1, 1 },
    { 0x1CA, 0x1CA, 1, 2 },
    { 0x1CB, 0x1DB, 2, 1 },
    { 0x1DE, 0x1EE, 2, 1 },
    { 0x1F1, 0x1F1, 1, 2 },
    { 0x1F2, 0x1F4, 2, 1 },
    { 0x1F6, 0x1F6, 1, -97 },
    { 0x1F7, 0x1F7, 1, -56 },
    { 0x1F8, 0x21E, 2, 1 },
    { 0x220, 0x220, 1, -130 },
    { 0x222, 0x232, 2, 1 },
    { 0x23A, 0x23A, 1, 10795 },
    { 0x23B, 0x23B, 1, 1 },
    { 0x23D, 0x23D, 1, -163 },
    { 0x23E, 0x23E, 1, 10792 },
    { 0x241, 0x241, 1, 1 },
    { 0x243, 0x243, 1, -195 },
    { 0x244, 0x244, 1, 69 },
    { 0x245, 0x245, 1, 71 },
    { 0x246, 0x24E, 2, 1 },
    { 0x370, 0x372, 2, 1 },
    { 0x376, 0x376, 1, 1 },
    { 0x37F, 0x37F, 1, 116 },
    { 0x386, 0x386, 1, 38 },
    { 0x388, 0x38A, 1, 37 },
    { 0x38C, 0x38C, 1, 64 },
    { 0x38E, 0x38F, 1, 63 },
    { 0x391, 0x3A1, 1, 32 },
    { 0x3A3, 0x3AB, 1, 32 },
    { 0x3CF, 0x3CF, 1, 8 },
    { 0x3D8, 0x3EE, 2, 1 },
    { 0x3F4, 0x3F4, 1, -60 },
    { 0x3F7, 0x3F7, 1, 1 },
    { 0x3F9, 0x3F9, 1, -7 },
    { 0x3FA, 0x3FA, 1, 1 },
    { 0x3FD, 0x3FF, 1, -130 },
    { 0x400, 0x40F, 1, 80 },
    { 0x410, 0x42F, 1, 32 },
    { 0x460, 0x480, 2, 1 },
    { 0x48A, 0x4BE, 2, 1 },
    { 0x4C0, 0x4C0, 1, 15 },
    { 0x4C1, 0x4CD, 2, 1 },
    { 0x4D0, 0x52E, 2, 1 },
    { 0x531, 0x556, 1, 48 },
    { 0x10A0, 0x10C5, 1, 7264 },
    { 0x10C7, 0x10CD, 6, 7264 },
    { 0x13A0, 0x13EF, 1, 38864 },
    { 0x13F0, 0x13F5, 1, 8 },
    { 0x1C90, 0x1CBA, 1, -3008 },
    { 0x1CBD, 0x1CBF, 1, -3008 },
    { 0x1E00, 0x1E94, 2, 1 },
    { 0x1E9E, 0x1E9E, 1, -7615 },
    { 0x1EA0, 0x1EFE, 2, 1 },
    { 0x1F08, 0x1F0F, 1, -8 },
    { 0x1F18, 0x1F1D, 1, -8 },
    { 0x1F28, 0x1F2F, 1, -8 },
    { 0x1F38, 0x1F3F, 1, -8 },
    { 0x1F48, 0x1F4D, 1, -8 },
    { 0x1F59, 0x1F5F, 2, -8 },
    { 0x1F68, 0x1F6F, 1, -8 },
    { 0x1F88, 0x1F8F, 1, -8 },
    { 0x1F98, 0x1F9F, 1, -8 },
    { 0x1FA8, 0x1FAF, 1, -8 },
    { 0x1FB8, 0x1FB9, 1, -8 },
    { 0x1FBA, 0x1FBB, 1, -74 },
    { 0x1FBC, 0x1FBC, 1, -9 },
    { 0x1FC8, 0x1FCB, 1, -86 },
    { 0x1FCC, 0x1FCC, 1, -9 },
    { 0x1FD8, 0x1FD9, 1, -8 },
    { 0x1FDA, 0x1FDB, 1, -100 },
    { 0x1FE8, 0x1FE9, 1, -8 },
    { 0x1FEA, 0x1FEB, 1, -112 },
    { 0x1FEC, 0x1FEC, 1, -7 },
    { 0x1FF8, 0x1FF9, 1, -128 },
    { 0x1FFA, 0x1FFB, 1, -126 },
    { 0x1FFC, 0x1FFC, 1, -9 },
    { 0x2126, 0x2126, 1, -7517 },
    { 0x212A, 0x212A, 1, -8383 },
    { 0x212B, 0x212B, 1, -8262 },
    { 0x2132, 0x2132, 1, 28 },
    { 0x2160, 0x216F, 1, 16 },
    { 0x2183, 0x2183, 1, 1 },
    { 0x24B6, 0x24CF, 1, 26 },
    { 0x2C00, 0x2C2F, 1, 48 },
    { 0x2C60, 0x2C60, 1, 1 },
    { 0x2C62, 0x2C62, 1, -10743 },
    { 0x2C63, 0x2C63, 1, -3814 },
    { 0x2C64, 0x2C64, 1, -10727 },
    { 0x2C67, 0x2C6B, 2, 1 },
    { 0x2C6D, 0x2C6D, 1, -10780 },
    { 0x2C6E, 0x2C6E, 1, -10749 },
    { 0x2C6F, 0x2C6F, 1, -10783 },
    { 0x2C70, 0x2C70, 1, -10782 },
    { 0x2C72, 0x2C75, 3, 1 },
    { 0x2C7E, 0x2C7F, 1, -10815 },
    { 0x2C80, 0x2CE2, 2, 1 },
    { 0x2CEB, 0x2CED, 2, 1 },
    { 0x2CF2, 0xA640, 31054, 1 },
    { 0xA642, 0xA66C, 2, 1 },
    { 0xA680, 0xA69A, 2, 1 },
    { 0xA722, 0xA72E, 2, 1 },
    { 0xA732, 0xA76E, 2, 1 },
    { 0xA779, 0xA77B, 2, 1 },
    { 0xA77D, 0xA77D, 1, -35332 },
    { 0xA77E, 0xA786, 2, 1 },
    { 0xA78B, 0xA78B, 1, 1 },
    { 0xA78D, 0xA78D, 1, -42280 },
    { 0xA790, 0xA792, 2, 1 },
    { 0xA796, 0xA7A8, 2, 1 },
    { 0xA7AA, 0xA7AA, 1, -42308 },
    { 0xA7AB, 0xA7AB, 1, -42319 },
    { 0xA7AC, 0xA7AC, 1, -42315 },
    { 0xA7AD, 0xA7AD, 1, -42305 },
    { 0xA7AE, 0xA7AE, 1, -42308 },
    { 0xA7B0, 0xA7B0, 1, -42258 },
    { 0xA7B1, 0xA7B1, 1, -42282 },
    { 0xA7B2, 0xA7B2, 1, -42261 },
    { 0xA7B3, 0xA7B3, 1, 928 },
    { 0xA7B4, 0xA7C2, 2, 1 },
    { 0xA7C4, 0xA7C4, 1, -48 },
    { 0xA7C5, 0xA7C5, 1, -42307 },
    { 0xA7C6, 0xA7C6, 1, -35384 },
    { 0xA7C7, 0xA7C9, 2, 1 },
    { 0xA7D0, 0xA7D6, 6, 1 },
    { 0xA7D8, 0xA7F5, 29, 1 },
    { 0xFF21, 0xFF3A, 1, 32 },
    { 0x10400, 0x10427, 1, 40 },
    { 0x104B0, 0x104D3, 1, 40 },
    { 0x10570, 0x1057A, 1, 39 },
    { 0x1057C, 0x1058A, 1, 39 },
    { 0x1058C, 0x10592, 1, 39 },
    { 0x10594, 0x10595, 1, 39 },
    { 0x10C80, 0x10CB2, 1, 64 },
    { 0x118A0, 0x118BF, 1, 32 },
    { 0x16E40, 0x16E5F, 1, 32 },
    { 0x1E900, 0x1E921, 1, 34 },
};

static struct conv_table toupper_table[] = {
    { 0x61, 0x7A, 1, -32 },
    { 0xB5, 0xB5, 1, 743 },
    { 0xE0, 0xF6, 1, -32 },
    { 0xF8, 0xFE, 1, -32 },
    { 0xFF, 0xFF, 1, 121 },
    { 0x101, 0x12F, 2, -1 },
    { 0x131, 0x131, 1, -232 },
    { 0x133, 0x137, 2, -1 },
    { 0x13A, 0x148, 2, -1 },
    { 0x14B, 0x177, 2, -1 },
    { 0x17A, 0x17E, 2, -1 },
    { 0x17F, 0x17F, 1, -300 },
    { 0x180, 0x180, 1, 195 },
    { 0x183, 0x185, 2, -1 },
    { 0x188, 0x18C, 4, -1 },
    { 0x192, 0x192, 1, -1 },
    { 0x195, 0x195, 1, 97 },
    { 0x199, 0x199, 1, -1 },
    { 0x19A, 0x19A, 1, 163 },
    { 0x19E, 0x19E, 1, 130 },
    { 0x1A1, 0x1A5, 2, -1 },
    { 0x1A8, 0x1AD, 5, -1 },
    { 0x1B0, 0x1B4, 4, -1 },
    { 0x1B6, 0x1B9, 3, -1 },
    { 0x1BD, 0x1BD, 1, -1 },
    { 0x1BF, 0x1BF, 1, 56 },
    { 0x1C5, 0x1C5, 1, -1 },
    { 0x1C6, 0x1C6, 1, -2 },
    { 0x1C8, 0x1C8, 1, -1 },
    { 0x1C9, 0x1C9, 1, -2 },
    { 0x1CB, 0x1CB, 1, -1 },
    { 0x1CC, 0x1CC, 1, -2 },
    { 0x1CE, 0x1DC, 2, -1 },
    { 0x1DD, 0x1DD, 1, -79 },
    { 0x1DF, 0x1EF, 2, -1 },
    { 0x1F2, 0x1F2, 1, -1 },
    { 0x1F3, 0x1F3, 1, -2 },
    { 0x1F5, 0x1F9, 4, -1 },
    { 0x1FB, 0x21F, 2, -1 },
    { 0x223, 0x233, 2, -1 },
    { 0x23C, 0x23C, 1, -1 },
    { 0x23F, 0x240, 1, 10815 },
    { 0x242, 0x247, 5, -1 },
    { 0x249, 0x24F, 2, -1 },
    { 0x250, 0x250, 1, 10783 },
    { 0x251, 0x251, 1, 10780 },
    { 0x252, 0x252, 1, 10782 },
    { 0x253, 0x253, 1, -210 },
    { 0x254, 0x254, 1, -206 },
    { 0x256, 0x257, 1, -205 },
    { 0x259, 0x259, 1, -202 },
    { 0x25B, 0x25B, 1, -203 },
    { 0x25C, 0x25C, 1, 42319 },
    { 0x260, 0x260, 1, -205 },
    { 0x261, 0x261, 1, 42315 },
    { 0x263, 0x263, 1, -207 },
    { 0x265, 0x265, 1, 42280 },
    { 0x266, 0x266, 1, 42308 },
    { 0x268, 0x268, 1, -209 },
    { 0x269, 0x269, 1, -211 },
    { 0x26A, 0x26A, 1, 42308 },
    { 0x26B, 0x26B, 1, 10743 },
    { 0x26C, 0x26C, 1, 42305 },
    { 0x26F, 0x26F, 1, -211 },
    { 0x271, 0x271, 1, 10749 },
    { 0x272, 0x272, 1, -213 },
    { 0x275, 0x275, 1, -214 },
    { 0x27D, 0x27D, 1, 10727 },
    { 0x280, 0x280, 1, -218 },
    { 0x282, 0x282, 1, 42307 },
    { 0x283, 0x283, 1, -218 },
    { 0x287, 0x287, 1, 42282 },
    { 0x288, 0x288, 1, -218 },
    { 0x289, 0x289, 1, -69 },
    { 0x28A, 0x28B, 1, -217 },
    { 0x28C, 0x28C, 1, -71 },
    { 0x292, 0x292, 1, -219 },
    { 0x29D, 0x29D, 1, 42261 },
    { 0x29E, 0x29E, 1, 42258 },
    { 0x345, 0x345, 1, 84 },
    { 0x371, 0x373, 2, -1 },
    { 0x377, 0x377, 1, -1 },
    { 0x37B, 0x37D, 1, 130 },
    { 0x3AC, 0x3AC, 1, -38 },
    { 0x3AD, 0x3AF, 1, -37 },
    { 0x3B1, 0x3C1, 1, -32 },
    { 0x3C2, 0x3C2, 1, -31 },
    { 0x3C3, 0x3CB, 1, -32 },
    { 0x3CC, 0x3CC, 1, -64 },
    { 0x3CD, 0x3CE, 1, -63 },
    { 0x3D0, 0x3D0, 1, -62 },
    { 0x3D1, 0x3D1, 1, -57 },
    { 0x3D5, 0x3D5, 1, -47 },
    { 0x3D6, 0x3D6, 1, -54 },
    { 0x3D7, 0x3D7, 1, -8 },
    { 0x3D9, 0x3EF, 2, -1 },
    { 0x3F0, 0x3F0, 1, -86 },
    { 0x3F1, 0x3F1, 1, -80 },
    { 0x3F2, 0x3F2, 1, 7 },
    { 0x3F3, 0x3F3, 1, -116 },
    { 0x3F5, 0x3F5, 1, -96 },
    { 0x3F8, 0x3FB, 3, -1 },
    { 0x430, 0x44F, 1, -32 },
    { 0x450, 0x45F, 1, -80 },
    { 0x461, 0x481, 2, -1 },
    { 0x48B, 0x4BF, 2, -1 },
    { 0x4C2, 0x4CE, 2, -1 },
    { 0x4CF, 0x4CF, 1, -15 },
    { 0x4D1, 0x52F, 2, -1 },
    { 0x561, 0x586, 1, -48 },
    { 0x10D0, 0x10FA, 1, 3008 },
    { 0x10FD, 0x10FF, 1, 3008 },
    { 0x13F8, 0x13FD, 1, -8 },
    { 0x1C80, 0x1C80, 1, -6254 },
    { 0x1C81, 0x1C81, 1, -6253 },
    { 0x1C82, 0x1C82, 1, -6244 },
    { 0x1C83, 0x1C84, 1, -6242 },
    { 0x1C85, 0x1C85, 1, -6243 },
    { 0x1C86, 0x1C86, 1, -6236 },
    { 0x1C87, 0x1C87, 1, -6181 },
    { 0x1C88, 0x1C88, 1, 35266 },
    { 0x1D79, 0x1D79, 1, 35332 },
    { 0x1D7D, 0x1D7D, 1, 3814 },
    { 0x1D8E, 0x1D8E, 1, 35384 },
    { 0x1E01, 0x1E95, 2, -1 },
    { 0x1E9B, 0x1E9B, 1, -59 },
    { 0x1EA1, 0x1EFF, 2, -1 },
    { 0x1F00, 0x1F07, 1, 8 },
    { 0x1F10, 0x1F15, 1, 8 },
    { 0x1F20, 0x1F27, 1, 8 },
    { 0x1F30, 0x1F37, 1, 8 },
    { 0x1F40, 0x1F45, 1, 8 },
    { 0x1F51, 0x1F57, 2, 8 },
    { 0x1F60, 0x1F67, 1, 8 },
    { 0x1F70, 0x1F71, 1, 74 },
    { 0x1F72, 0x1F75, 1, 86 },
    { 0x1F76, 0x1F77, 1, 100 },
    { 0x1F78, 0x1F79, 1, 128 },
    { 0x1F7A, 0x1F7B, 1, 112 },
    { 0x1F7C, 0x1F7D, 1, 126 },
    { 0x1F80, 0x1F87, 1, 8 },
    { 0x1F90, 0x1F97, 1, 8 },
    { 0x1FA0, 0x1FA7, 1, 8 },
    { 0x1FB0, 0x1FB1, 1, 8 },
    { 0x1FB3, 0x1FB3, 1, 9 },
    { 0x1FBE, 0x1FBE, 1, -7205 },
    { 0x1FC3, 0x1FC3, 1, 9 },
    { 0x1FD0, 0x1FD1, 1, 8 },
    { 0x1FE0, 0x1FE1, 1, 8 },
    { 0x1FE5, 0x1FE5, 1, 7 },
    { 0x1FF3, 0x1FF3, 1, 9 },
    { 0x214E, 0x214E, 1, -28 },
    { 0x2170, 0x217F, 1, -16 },
    { 0x2184, 0x2184, 1, -1 },
    { 0x24D0, 0x24E9, 1, -26 },
    { 0x2C30, 0x2C5F, 1, -48 },
    { 0x2C61, 0x2C61, 1, -1 },
    { 0x2C65, 0x2C65, 1, -10795 },
    { 0x2C66, 0x2C66, 1, -10792 },
    { 0x2C68, 0x2C6C, 2, -1 },
    { 0x2C73, 0x2C76, 3, -1 },
    { 0x2C81, 0x2CE3, 2, -1 },
    { 0x2CEC, 0x2CEE, 2, -1 },
    { 0x2CF3, 0x2CF3, 1, -1 },
    { 0x2D00, 0x2D25, 1, -7264 },
    { 0x2D27, 0x2D2D, 6, -7264 },
    { 0xA641, 0xA66D, 2, -1 },
    { 0xA681, 0xA69B, 2, -1 },
    { 0xA723, 0xA72F, 2, -1 },
    { 0xA733, 0xA76F, 2, -1 },
    { 0xA77A, 0xA77C, 2, -1 },
    { 0xA77F, 0xA787, 2, -1 },
    { 0xA78C, 0xA791, 5, -1 },
    { 0xA793, 0xA793, 1, -1 },
    { 0xA794, 0xA794, 1, 48 },
    { 0xA797, 0xA7A9, 2, -1 },
    { 0xA7B5, 0xA7C3, 2, -1 },
    { 0xA7C8, 0xA7CA, 2, -1 },
    { 0xA7D1, 0xA7D7, 6, -1 },
    { 0xA7D9, 0xA7F6, 29, -1 },
    { 0xAB53, 0xAB53, 1, -928 },
    { 0xAB70, 0xABBF, 1, -38864 },
    { 0xFF41, 0xFF5A, 1, -32 },
    { 0x10428, 0x1044F, 1, -40 },
    { 0x104D8, 0x104FB, 1, -40 },
    { 0x10597, 0x105A1, 1, -39 },
    { 0x105A3, 0x105B1, 1, -39 },
    { 0x105B3, 0x105B9, 1, -39 },
    { 0x105BB, 0x105BC, 1, -39 },
    { 0x10CC0, 0x10CF2, 1, -64 },
    { 0x118C0, 0x118DF, 1, -32 },
    { 0x16E60, 0x16E7F, 1, -32 },
    { 0x1E922, 0x1E943, 1, -34 },
};

static struct conv_table totitle_table[] = {
    { 0x61, 0x7A, 1, -32 },
    { 0xB5, 0xB5, 1, 743 },
    { 0xE0, 0xF6, 1, -32 },
    { 0xF8, 0xFE, 1, -32 },
    { 0xFF, 0xFF, 1, 121 },
    { 0x101, 0x12F, 2, -1 },
    { 0x131, 0x131, 1, -232 },
    { 0x133, 0x137, 2, -1 },
    { 0x13A, 0x148, 2, -1 },
    { 0x14B, 0x177, 2, -1 },
    { 0x17A, 0x17E, 2, -1 },
    { 0x17F, 0x17F, 1, -300 },
    { 0x180, 0x180, 1, 195 },
    { 0x183, 0x185, 2, -1 },
    { 0x188, 0x18C, 4, -1 },
    { 0x192, 0x192, 1, -1 },
    { 0x195, 0x195, 1, 97 },
    { 0x199, 0x199, 1, -1 },
    { 0x19A, 0x19A, 1, 163 },
    { 0x19E, 0x19E, 1, 130 },
    { 0x1A1, 0x1A5, 2, -1 },
    { 0x1A8, 0x1AD, 5, -1 },
    { 0x1B0, 0x1B4, 4, -1 },
    { 0x1B6, 0x1B9, 3, -1 },
    { 0x1BD, 0x1BD, 1, -1 },
    { 0x1BF, 0x1BF, 1, 56 },
    { 0x1C4, 0x1C4, 1, 1 },
    { 0x1C5, 0x1C5, 1, 0 },
    { 0x1C6, 0x1C6, 1, -1 },
    { 0x1C7, 0x1C7, 1, 1 },
    { 0x1C8, 0x1C8, 1, 0 },
    { 0x1C9, 0x1C9, 1, -1 },
    { 0x1CA, 0x1CA, 1, 1 },
    { 0x1CB, 0x1CB, 1, 0 },
    { 0x1CC, 0x1DC, 2, -1 },
    { 0x1DD, 0x1DD, 1, -79 },
    { 0x1DF, 0x1EF, 2, -1 },
    { 0x1F1, 0x1F1, 1, 1 },
    { 0x1F2, 0x1F2, 1, 0 },
    { 0x1F3, 0x1F5, 2, -1 },
    { 0x1F9, 0x21F, 2, -1 },
    { 0x223, 0x233, 2, -1 },
    { 0x23C, 0x23C, 1, -1 },
    { 0x23F, 0x240, 1, 10815 },
    { 0x242, 0x247, 5, -1 },
    { 0x249, 0x24F, 2, -1 },
    { 0x250, 0x250, 1, 10783 },
    { 0x251, 0x251, 1, 10780 },
    { 0x252, 0x252, 1, 10782 },
    { 0x253, 0x253, 1, -210 },
    { 0x254, 0x254, 1, -206 },
    { 0x256, 0x257, 1, -205 },
    { 0x259, 0x259, 1, -202 },
    { 0x25B, 0x25B, 1, -203 },
    { 0x25C, 0x25C, 1, 42319 },
    { 0x260, 0x260, 1, -205 },
    { 0x261, 0x261, 1, 42315 },
    { 0x263, 0x263, 1, -207 },
    { 0x265, 0x265, 1, 42280 },
    { 0x266, 0x266, 1, 42308 },
    { 0x268, 0x268, 1, -209 },
    { 0x269, 0x269, 1, -211 },
    { 0x26A, 0x26A, 1, 42308 },
    { 0x26B, 0x26B, 1, 10743 },
    { 0x26C, 0x26C, 1, 42305 },
    { 0x26F, 0x26F, 1, -211 },
    { 0x271, 0x271, 1, 10749 },
    { 0x272, 0x272, 1, -213 },
    { 0x275, 0x275, 1, -214 },
    { 0x27D, 0x27D, 1, 10727 },
    { 0x280, 0x280, 1, -218 },
    { 0x282, 0x282, 1, 42307 },
    { 0x283, 0x283, 1, -218 },
    { 0x287, 0x287, 1, 42282 },
    { 0x288, 0x288, 1, -218 },
    { 0x289, 0x289, 1, -69 },
    { 0x28A, 0x28B, 1, -217 },
    { 0x28C, 0x28C, 1, -71 },
    { 0x292, 0x292, 1, -219 },
    { 0x29D, 0x29D, 1, 42261 },
    { 0x29E, 0x29E, 1, 42258 },
    { 0x345, 0x345, 1, 84 },
    { 0x371, 0x373, 2, -1 },
    { 0x377, 0x377, 1, -1 },
    { 0x37B, 0x37D, 1, 130 },
    { 0x3AC, 0x3AC, 1, -38 },
    { 0x3AD, 0x3AF, 1, -37 },
    { 0x3B1, 0x3C1, 1, -32 },
    { 0x3C2, 0x3C2, 1, -31 },
    { 0x3C3, 0x3CB, 1, -32 },
    { 0x3CC, 0x3CC, 1, -64 },
    { 0x3CD, 0x3CE, 1, -63 },
    { 0x3D0, 0x3D0, 1, -62 },
    { 0x3D1, 0x3D1, 1, -57 },
    { 0x3D5, 0x3D5, 1, -47 },
    { 0x3D6, 0x3D6, 1, -54 },
    { 0x3D7, 0x3D7, 1, -8 },
    { 0x3D9, 0x3EF, 2, -1 },
    { 0x3F0, 0x3F0, 1, -86 },
    { 0x3F1, 0x3F1, 1, -80 },
    { 0x3F2, 0x3F2, 1, 7 },
    { 0x3F3, 0x3F3, 1, -116 },
    { 0x3F5, 0x3F5, 1, -96 },
    { 0x3F8, 0x3FB, 3, -1 },
    { 0x430, 0x44F, 1, -32 },
    { 0x450, 0x45F, 1, -80 },
    { 0x461, 0x481, 2, -1 },
    { 0x48B, 0x4BF, 2, -1 },
    { 0x4C2, 0x4CE, 2, -1 },
    { 0x4CF, 0x4CF, 1, -15 },
    { 0x4D1, 0x52F, 2, -1 },
    { 0x561, 0x586, 1, -48 },
    { 0x10D0, 0x10FA, 1, 0 },
    { 0x10FD, 0x10FF, 1, 0 },
    { 0x13F8, 0x13FD, 1, -8 },
    { 0x1C80, 0x1C80, 1, -6254 },
    { 0x1C81, 0x1C81, 1, -6253 },
    { 0x1C82, 0x1C82, 1, -6244 },
    { 0x1C83, 0x1C84, 1, -6242 },
    { 0x1C85, 0x1C85, 1, -6243 },
    { 0x1C86, 0x1C86, 1, -6236 },
    { 0x1C87, 0x1C87, 1, -6181 },
    { 0x1C88, 0x1C88, 1, 35266 },
    { 0x1D79, 0x1D79, 1, 35332 },
    { 0x1D7D, 0x1D7D, 1, 3814 },
    { 0x1D8E, 0x1D8E, 1, 35384 },
    { 0x1E01, 0x1E95, 2, -1 },
    { 0x1E9B, 0x1E9B, 1, -59 },
    { 0x1EA1, 0x1EFF, 2, -1 },
    { 0x1F00, 0x1F07, 1, 8 },
    { 0x1F10, 0x1F15, 1, 8 },
    { 0x1F20, 0x1F27, 1, 8 },
    { 0x1F30, 0x1F37, 1, 8 },
    { 0x1F40, 0x1F45, 1, 8 },
    { 0x1F51, 0x1F57, 2, 8 },
    { 0x1F60, 0x1F67, 1, 8 },
    { 0x1F70, 0x1F71, 1, 74 },
    { 0x1F72, 0x1F75, 1, 86 },
    { 0x1F76, 0x1F77, 1, 100 },
    { 0x1F78, 0x1F79, 1, 128 },
    { 0x1F7A, 0x1F7B, 1, 112 },
    { 0x1F7C, 0x1F7D, 1, 126 },
    { 0x1F80, 0x1F87, 1, 8 },
    { 0x1F90, 0x1F97, 1, 8 },
    { 0x1FA0, 0x1FA7, 1, 8 },
    { 0x1FB0, 0x1FB1, 1, 8 },
    { 0x1FB3, 0x1FB3, 1, 9 },
    { 0x1FBE, 0x1FBE, 1, -7205 },
    { 0x1FC3, 0x1FC3, 1, 9 },
    { 0x1FD0, 0x1FD1, 1, 8 },
    { 0x1FE0, 0x1FE1, 1, 8 },
    { 0x1FE5, 0x1FE5, 1, 7 },
    { 0x1FF3, 0x1FF3, 1, 9 },
    { 0x214E, 0x214E, 1, -28 },
    { 0x2170, 0x217F, 1, -16 },
    { 0x2184, 0x2184, 1, -1 },
    { 0x24D0, 0x24E9, 1, -26 },
    { 0x2C30, 0x2C5F, 1, -48 },
    { 0x2C61, 0x2C61, 1, -1 },
    { 0x2C65, 0x2C65, 1, -10795 },
    { 0x2C66, 0x2C66, 1, -10792 },
    { 0x2C68, 0x2C6C, 2, -1 },
    { 0x2C73, 0x2C76, 3, -1 },
    { 0x2C81, 0x2CE3, 2, -1 },
    { 0x2CEC, 0x2CEE, 2, -1 },
    { 0x2CF3, 0x2CF3, 1, -1 },
    { 0x2D00, 0x2D25, 1, -7264 },
    { 0x2D27, 0x2D2D, 6, -7264 },
    { 0xA641, 0xA66D, 2, -1 },
    { 0xA681, 0xA69B, 2, -1 },
    { 0xA723, 0xA72F, 2, -1 },
    { 0xA733, 0xA76F, 2, -1 },
    { 0xA77A, 0xA77C, 2, -1 },
    { 0xA77F, 0xA787, 2, -1 },
    { 0xA78C, 0xA791, 5, -1 },
    { 0xA793, 0xA793, 1, -1 },
    { 0xA794, 0xA794, 1, 48 },
    { 0xA797, 0xA7A9, 2, -1 },
    { 0xA7B5, 0xA7C3, 2, -1 },
    { 0xA7C8, 0xA7CA, 2, -1 },
    { 0xA7D1, 0xA7D7, 6, -1 },
    { 0xA7D9, 0xA7F6, 29, -1 },
    { 0xAB53, 0xAB53, 1, -928 },
    { 0xAB70, 0xABBF, 1, -38864 },
    { 0xFF41, 0xFF5A, 1, -32 },
    { 0x10428, 0x1044F, 1, -40 },
    { 0x104D8, 0x104FB, 1, -40 },
    { 0x10597, 0x105A1, 1, -39 },
    { 0x105A3, 0x105B1, 1, -39 },
    { 0x105B3, 0x105B9, 1, -39 },
    { 0x105BB, 0x105BC, 1, -39 },
    { 0x10CC0, 0x10CF2, 1, -64 },
    { 0x118C0, 0x118DF, 1, -32 },
    { 0x16E60, 0x16E7F, 1, -32 },
    { 0x1E922, 0x1E943, 1, -34 },
};

static struct conv_table tofold_table[] = {
    { 0x41, 0x5A, 1, 32 },
    { 0xB5, 0xB5, 1, 775 },
    { 0xC0, 0xD6, 1, 32 },
    { 0xD8, 0xDE, 1, 32 },
    { 0x100, 0x12E, 2, 1 },
    { 0x132, 0x136, 2, 1 },
    { 0x139, 0x147, 2, 1 },
    { 0x14A, 0x176, 2, 1 },
    { 0x178, 0x178, 1, -121 },
    { 0x179, 0x17D, 2, 1 },
    { 0x17F, 0x17F, 1, -268 },
    { 0x181, 0x181, 1, 210 },
    { 0x182, 0x184, 2, 1 },
    { 0x186, 0x186, 1, 206 },
    { 0x187, 0x187, 1, 1 },
    { 0x189, 0x18A, 1, 205 },
    { 0x18B, 0x18B, 1, 1 },
    { 0x18E, 0x18E, 1, 79 },
    { 0x18F, 0x18F, 1, 202 },
    { 0x190, 0x190, 1, 203 },
    { 0x191, 0x191, 1, 1 },
    { 0x193, 0x193, 1, 205 },
    { 0x194, 0x194, 1, 207 },
    { 0x196, 0x196, 1, 211 },
    { 0x197, 0x197, 1, 209 },
    { 0x198, 0x198, 1, 1 },
    { 0x19C, 0x19C, 1, 211 },
    { 0x19D, 0x19D, 1, 213 },
    { 0x19F, 0x19F, 1, 214 },
    { 0x1A0, 0x1A4, 2, 1 },
    { 0x1A6, 0x1A6, 1, 218 },
    { 0x1A7, 0x1A7, 1, 1 },
    { 0x1A9, 0x1A9, 1, 218 },
    { 0x1AC, 0x1AC, 1, 1 },
    { 0x1AE, 0x1AE, 1, 218 },
    { 0x1AF, 0x1AF, 1, 1 },
    { 0x1B1, 0x1B2, 1, 217 },
    { 0x1B3, 0x1B5, 2, 1 },
    { 0x1B7, 0x1B7, 1, 219 },
    { 0x1B8, 0x1BC, 4, 1 },
    { 0x1C4, 0x1C4, 1, 2 },
    { 0x1C5, 0x1C5, 1, 1 },
    { 0x1C7, 0x1C7, 1, 2 },
    { 0x1C8, 0x1C8, 1, 1 },
    { 0x1CA, 0x1CA, 1, 2 },
    { 0x1CB, 0x1DB, 2, 1 },
    { 0x1DE, 0x1EE, 2, 1 },
    { 0x1F1, 0x1F1, 1, 2 },
    { 0x1F2, 0x1F4, 2, 1 },
    { 0x1F6, 0x1F6, 1, -97 },
    { 0x1F7, 0x1F7, 1, -56 },
    { 0x1F8, 0x21E, 2, 1 },
    { 0x220, 0x220, 1, -130 },
    { 0x222, 0x232, 2, 1 },
    { 0x23A, 0x23A, 1, 10795 },
    { 0x23B, 0x23B, 1, 1 },
    { 0x23D, 0x23D, 1, -163 },
    { 0x23E, 0x23E, 1, 10792 },
    { 0x241, 0x241, 1, 1 },
    { 0x243, 0x243, 1, -195 },
    { 0x244, 0x244, 1, 69 },
    { 0x245, 0x245, 1, 71 },
    { 0x246, 0x24E, 2, 1 },
    { 0x345, 0x345, 1, 116 },
    { 0x370, 0x372, 2, 1 },
    { 0x376, 0x376, 1, 1 },
    { 0x37F, 0x37F, 1, 116 },
    { 0x386, 0x386, 1, 38 },
    { 0x388, 0x38A, 1, 37 },
    { 0x38C, 0x38C, 1, 64 },
    { 0x38E, 0x38F, 1, 63 },
    { 0x391, 0x3A1, 1, 32 },
    { 0x3A3, 0x3AB, 1, 32 },
    { 0x3C2, 0x3C2, 1, 1 },
    { 0x3CF, 0x3CF, 1, 8 },
    { 0x3D0, 0x3D0, 1, -30 },
    { 0x3D1, 0x3D1, 1, -25 },
    { 0x3D5, 0x3D5, 1, -15 },
    { 0x3D6, 0x3D6, 1, -22 },
    { 0x3D8, 0x3EE, 2, 1 },
    { 0x3F0, 0x3F0, 1, -54 },
    { 0x3F1, 0x3F1, 1, -48 },
    { 0x3F4, 0x3F4, 1, -60 },
    { 0x3F5, 0x3F5, 1, -64 },
    { 0x3F7, 0x3F7, 1, 1 },
    { 0x3F9, 0x3F9, 1, -7 },
    { 0x3FA, 0x3FA, 1, 1 },
    { 0x3FD, 0x3FF, 1, -130 },
    { 0x400, 0x40F, 1, 80 },
    { 0x410, 0x42F, 1, 32 },
    { 0x460, 0x480, 2, 1 },
    { 0x48A, 0x4BE, 2, 1 },
    { 0x4C0, 0x4C0, 1, 15 },
    { 0x4C1, 0x4CD, 2, 1 },
    { 0x4D0, 0x52E, 2, 1 },
    { 0x531, 0x556, 1, 48 },
    { 0x10A0, 0x10C5, 1, 7264 },
    { 0x10C7, 0x10CD, 6, 7264 },
    { 0x13F8, 0x13FD, 1, -8 },
    { 0x1C80, 0x1C80, 1, -6222 },
    { 0x1C81, 0x1C81, 1, -6221 },
    { 0x1C82, 0x1C82, 1, -6212 },
    { 0x1C83, 0x1C84, 1, -6210 },
    { 0x1C85, 0x1C85, 1, -6211 },
    { 0x1C86, 0x1C86, 1, -6204 },
    { 0x1C87, 0x1C87, 1, -6180 },
    { 0x1C88, 0x1C88, 1, 35267 },
    { 0x1C90, 0x1CBA, 1, -3008 },
    { 0x1CBD, 0x1CBF, 1, -3008 },
    { 0x1E00, 0x1E94, 2, 1 },
    { 0x1E9B, 0x1E9B, 1, -58 },
    { 0x1E9E, 0x1E9E, 1, -7615 },
    { 0x1EA0, 0x1EFE, 2, 1 },
    { 0x1F08, 0x1F0F, 1, -8 },
    { 0x1F18, 0x1F1D, 1, -8 },
    { 0x1F28, 0x1F2F, 1, -8 },
    { 0x1F38, 0x1F3F, 1, -8 },
    { 0x1F48, 0x1F4D, 1, -8 },
    { 0x1F59, 0x1F5F, 2, -8 },
    { 0x1F68, 0x1F6F, 1, -8 },
    { 0x1F88, 0x1F8F, 1, -8 },
    { 0x1F98, 0x1F9F, 1, -8 },
    { 0x1FA8, 0x1FAF, 1, -8 },
    { 0x1FB8, 0x1FB9, 1, -8 },
    { 0x1FBA, 0x1FBB, 1, -74 },
    { 0x1FBC, 0x1FBC, 1, -9 },
    { 0x1FBE, 0x1FBE, 1, -7173 },
    { 0x1FC8, 0x1FCB, 1, -86 },
    { 0x1FCC, 0x1FCC, 1, -9 },
    { 0x1FD3, 0x1FD3, 1, -7235 },
    { 0x1FD8, 0x1FD9, 1, -8 },
    { 0x1FDA, 0x1FDB, 1, -100 },
    { 0x1FE3, 0x1FE3, 1, -7219 },
    { 0x1FE8, 0x1FE9, 1, -8 },
    { 0x1FEA, 0x1FEB, 1, -112 },
    { 0x1FEC, 0x1FEC, 1, -7 },
    { 0x1FF8, 0x1FF9, 1, -128 },
    { 0x1FFA, 0x1FFB, 1, -126 },
    { 0x1FFC, 0x1FFC, 1, -9 },
    { 0x2126, 0x2126, 1, -7517 },
    { 0x212A, 0x212A, 1, -8383 },
    { 0x212B, 0x212B, 1, -8262 },
    { 0x2132, 0x2132, 1, 28 },
    { 0x2160, 0x216F, 1, 16 },
    { 0x2183, 0x2183, 1, 1 },
    { 0x24B6, 0x24CF, 1, 26 },
    { 0x2C00, 0x2C2F, 1, 48 },
    { 0x2C60, 0x2C60, 1, 1 },
    { 0x2C62, 0x2C62, 1, -10743 },
    { 0x2C63, 0x2C63, 1, -3814 },
    { 0x2C64, 0x2C64, 1, -10727 },
    { 0x2C67, 0x2C6B, 2, 1 },
    { 0x2C6D, 0x2C6D, 1, -10780 },
    { 0x2C6E, 0x2C6E, 1, -10749 },
    { 0x2C6F, 0x2C6F, 1, -10783 },
    { 0x2C70, 0x2C70, 1, -10782 },
    { 0x2C72, 0x2C75, 3, 1 },
    { 0x2C7E, 0x2C7F, 1, -10815 },
    { 0x2C80, 0x2CE2, 2, 1 },
    { 0x2CEB, 0x2CED, 2, 1 },
    { 0x2CF2, 0xA640, 31054, 1 },
    { 0xA642, 0xA66C, 2, 1 },
    { 0xA680, 0xA69A, 2, 1 },
    { 0xA722, 0xA72E, 2, 1 },
    { 0xA732, 0xA76E, 2, 1 },
    { 0xA779, 0xA77B, 2, 1 },
    { 0xA77D, 0xA77D, 1, -35332 },
    { 0xA77E, 0xA786, 2, 1 },
    { 0xA78B, 0xA78B, 1, 1 },
    { 0xA78D, 0xA78D, 1, -42280 },
    { 0xA790, 0xA792, 2, 1 },
    { 0xA796, 0xA7A8, 2, 1 },
    { 0xA7AA, 0xA7AA, 1, -42308 },
    { 0xA7AB, 0xA7AB, 1, -42319 },
    { 0xA7AC, 0xA7AC, 1, -42315 },
    { 0xA7AD, 0xA7AD, 1, -42305 },
    { 0xA7AE, 0xA7AE, 1, -42308 },
    { 0xA7B0, 0xA7B0, 1, -42258 },
    { 0xA7B1, 0xA7B1, 1, -42282 },
    { 0xA7B2, 0xA7B2, 1, -42261 },
    { 0xA7B3, 0xA7B3, 1, 928 },
    { 0xA7B4, 0xA7C2, 2, 1 },
    { 0xA7C4, 0xA7C4, 1, -48 },
    { 0xA7C5, 0xA7C5, 1, -42307 },
    { 0xA7C6, 0xA7C6, 1, -35384 },
    { 0xA7C7, 0xA7C9, 2, 1 },
    { 0xA7D0, 0xA7D6, 6, 1 },
    { 0xA7D8, 0xA7F5, 29, 1 },
    { 0xAB70, 0xABBF, 1, -38864 },
    { 0xFB05, 0xFB05, 1, 1 },
    { 0xFF21, 0xFF3A, 1, 32 },
    { 0x10400, 0x10427, 1, 40 },
    { 0x104B0, 0x104D3, 1, 40 },
    { 0x10570, 0x1057A, 1, 39 },
    { 0x1057C, 0x1058A, 1, 39 },
    { 0x1058C, 0x10592, 1, 39 },
    { 0x10594, 0x10595, 1, 39 },
    { 0x10C80, 0x10CB2, 1, 64 },
    { 0x118A0, 0x118BF, 1, 32 },
    { 0x16E40, 0x16E5F, 1, 32 },
    { 0x1E900, 0x1E921, 1, 34 },
};

static struct range_table doublewidth_table[] = {
    { 0x1100, 0x115F, 1 },
    { 0x231A, 0x231B, 1 },
    { 0x2329, 0x232A, 1 },
    { 0x23E9, 0x23EC, 1 },
    { 0x23F0, 0x23F3, 3 },
    { 0x25FD, 0x25FE, 1 },
    { 0x2614, 0x2615, 1 },
    { 0x2648, 0x2653, 1 },
    { 0x267F, 0x2693, 20 },
    { 0x26A1, 0x26AA, 9 },
    { 0x26AB, 0x26BD, 18 },
    { 0x26BE, 0x26C4, 6 },
    { 0x26C5, 0x26CE, 9 },
    { 0x26D4, 0x26EA, 22 },
    { 0x26F2, 0x26F3, 1 },
    { 0x26F5, 0x26FA, 5 },
    { 0x26FD, 0x2705, 8 },
    { 0x270A, 0x270B, 1 },
    { 0x2728, 0x274C, 36 },
    { 0x274E, 0x2753, 5 },
    { 0x2754, 0x2755, 1 },
    { 0x2757, 0x2795, 62 },
    { 0x2796, 0x2797, 1 },
    { 0x27B0, 0x27BF, 15 },
    { 0x2B1B, 0x2B1C, 1 },
    { 0x2B50, 0x2B55, 5 },
    { 0x2E80, 0x2E99, 1 },
    { 0x2E9B, 0x2EF3, 1 },
    { 0x2F00, 0x2FD5, 1 },
    { 0x2FF0, 0x303E, 1 },
    { 0x3041, 0x3096, 1 },
    { 0x3099, 0x30FF, 1 },
    { 0x3105, 0x312F, 1 },
    { 0x3131, 0x318E, 1 },
    { 0x3190, 0x31E3, 1 },
    { 0x31EF, 0x321E, 1 },
    { 0x3220, 0x3247, 1 },
    { 0x3250, 0x4DBF, 1 },
    { 0x4E00, 0xA48C, 1 },
    { 0xA490, 0xA4C6, 1 },
    { 0xA960, 0xA97C, 1 },
    { 0xAC00, 0xD7A3, 1 },
    { 0xF900, 0xFAFF, 1 },
    { 0xFE10, 0xFE19, 1 },
    { 0xFE30, 0xFE52, 1 },
    { 0xFE54, 0xFE66, 1 },
    { 0xFE68, 0xFE6B, 1 },
    { 0xFF01, 0xFF60, 1 },
    { 0xFFE0, 0xFFE6, 1 },
    { 0x16FE0, 0x16FE4, 1 },
    { 0x16FF0, 0x16FF1, 1 },
    { 0x17000, 0x187F7, 1 },
    { 0x18800, 0x18CD5, 1 },
    { 0x18D00, 0x18D08, 1 },
    { 0x1AFF0, 0x1AFF3, 1 },
    { 0x1AFF5, 0x1AFFB, 1 },
    { 0x1AFFD, 0x1AFFE, 1 },
    { 0x1B000, 0x1B122, 1 },
    { 0x1B132, 0x1B150, 30 },
    { 0x1B151, 0x1B152, 1 },
    { 0x1B155, 0x1B164, 15 },
    { 0x1B165, 0x1B167, 1 },
    { 0x1B170, 0x1B2FB, 1 },
    { 0x1F004, 0x1F0CF, 203 },
    { 0x1F18E, 0x1F191, 3 },
    { 0x1F192, 0x1F19A, 1 },
    { 0x1F200, 0x1F202, 1 },
    { 0x1F210, 0x1F23B, 1 },
    { 0x1F240, 0x1F248, 1 },
    { 0x1F250, 0x1F251, 1 },
    { 0x1F260, 0x1F265, 1 },
    { 0x1F300, 0x1F320, 1 },
    { 0x1F32D, 0x1F335, 1 },
    { 0x1F337, 0x1F37C, 1 },
    { 0x1F37E, 0x1F393, 1 },
    { 0x1F3A0, 0x1F3CA, 1 },
    { 0x1F3CF, 0x1F3D3, 1 },
    { 0x1F3E0, 0x1F3F0, 1 },
    { 0x1F3F4, 0x1F3F8, 4 },
    { 0x1F3F9, 0x1F43E, 1 },
    { 0x1F440, 0x1F442, 2 },
    { 0x1F443, 0x1F4FC, 1 },
    { 0x1F4FF, 0x1F53D, 1 },
    { 0x1F54B, 0x1F54E, 1 },
    { 0x1F550, 0x1F567, 1 },
    { 0x1F57A, 0x1F595, 27 },
    { 0x1F596, 0x1F5A4, 14 },
    { 0x1F5FB, 0x1F64F, 1 },
    { 0x1F680, 0x1F6C5, 1 },
    { 0x1F6CC, 0x1F6D0, 4 },
    { 0x1F6D1, 0x1F6D2, 1 },
    { 0x1F6D5, 0x1F6D7, 1 },
    { 0x1F6DC, 0x1F6DF, 1 },
    { 0x1F6EB, 0x1F6EC, 1 },
    { 0x1F6F4, 0x1F6FC, 1 },
    { 0x1F7E0, 0x1F7EB, 1 },
    { 0x1F7F0, 0x1F90C, 284 },
    { 0x1F90D, 0x1F93A, 1 },
    { 0x1F93C, 0x1F945, 1 },
    { 0x1F947, 0x1F9FF, 1 },
    { 0x1FA70, 0x1FA7C, 1 },
    { 0x1FA80, 0x1FA88, 1 },
    { 0x1FA90, 0x1FABD, 1 },
    { 0x1FABF, 0x1FAC5, 1 },
    { 0x1FACE, 0x1FADB, 1 },
    { 0x1FAE0, 0x1FAE8, 1 },
    { 0x1FAF0, 0x1FAF8, 1 },
    { 0x20000, 0x2FFFD, 1 },
    { 0x30000, 0x3FFFD, 1 },
};

static struct range_table ambiwidth_table[] = {
    { 0xA1, 0xA7, 3 },
    { 0xA8, 0xAA, 2 },
    { 0xAD, 0xAE, 1 },
    { 0xB0, 0xB4, 1 },
    { 0xB6, 0xBA, 1 },
    { 0xBC, 0xBF, 1 },
    { 0xC6, 0xD0, 10 },
    { 0xD7, 0xD8, 1 },
    { 0xDE, 0xE1, 1 },
    { 0xE6, 0xE8, 2 },
    { 0xE9, 0xEA, 1 },
    { 0xEC, 0xED, 1 },
    { 0xF0, 0xF2, 2 },
    { 0xF3, 0xF7, 4 },
    { 0xF8, 0xFA, 1 },
    { 0xFC, 0xFE, 2 },
    { 0x101, 0x111, 16 },
    { 0x113, 0x11B, 8 },
    { 0x126, 0x127, 1 },
    { 0x12B, 0x131, 6 },
    { 0x132, 0x133, 1 },
    { 0x138, 0x13F, 7 },
    { 0x140, 0x142, 1 },
    { 0x144, 0x148, 4 },
    { 0x149, 0x14B, 1 },
    { 0x14D, 0x152, 5 },
    { 0x153, 0x166, 19 },
    { 0x167, 0x16B, 4 },
    { 0x1CE, 0x1DC, 2 },
    { 0x251, 0x261, 16 },
    { 0x2C4, 0x2C7, 3 },
    { 0x2C9, 0x2CB, 1 },
    { 0x2CD, 0x2D0, 3 },
    { 0x2D8, 0x2DB, 1 },
    { 0x2DD, 0x2DF, 2 },
    { 0x300, 0x36F, 1 },
    { 0x391, 0x3A1, 1 },
    { 0x3A3, 0x3A9, 1 },
    { 0x3B1, 0x3C1, 1 },
    { 0x3C3, 0x3C9, 1 },
    { 0x401, 0x410, 15 },
    { 0x411, 0x44F, 1 },
    { 0x451, 0x2010, 7103 },
    { 0x2013, 0x2016, 1 },
    { 0x2018, 0x2019, 1 },
    { 0x201C, 0x201D, 1 },
    { 0x2020, 0x2022, 1 },
    { 0x2024, 0x2027, 1 },
    { 0x2030, 0x2032, 2 },
    { 0x2033, 0x2035, 2 },
    { 0x203B, 0x203E, 3 },
    { 0x2074, 0x207F, 11 },
    { 0x2081, 0x2084, 1 },
    { 0x20AC, 0x2103, 87 },
    { 0x2105, 0x2109, 4 },
    { 0x2113, 0x2116, 3 },
    { 0x2121, 0x2122, 1 },
    { 0x2126, 0x212B, 5 },
    { 0x2153, 0x2154, 1 },
    { 0x215B, 0x215E, 1 },
    { 0x2160, 0x216B, 1 },
    { 0x2170, 0x2179, 1 },
    { 0x2189, 0x2190, 7 },
    { 0x2191, 0x2199, 1 },
    { 0x21B8, 0x21B9, 1 },
    { 0x21D2, 0x21D4, 2 },
    { 0x21E7, 0x2200, 25 },
    { 0x2202, 0x2203, 1 },
    { 0x2207, 0x2208, 1 },
    { 0x220B, 0x220F, 4 },
    { 0x2211, 0x2215, 4 },
    { 0x221A, 0x221D, 3 },
    { 0x221E, 0x2220, 1 },
    { 0x2223, 0x2227, 2 },
    { 0x2228, 0x222C, 1 },
    { 0x222E, 0x2234, 6 },
    { 0x2235, 0x2237, 1 },
    { 0x223C, 0x223D, 1 },
    { 0x2248, 0x224C, 4 },
    { 0x2252, 0x2260, 14 },
    { 0x2261, 0x2264, 3 },
    { 0x2265, 0x2267, 1 },
    { 0x226A, 0x226B, 1 },
    { 0x226E, 0x226F, 1 },
    { 0x2282, 0x2283, 1 },
    { 0x2286, 0x2287, 1 },
    { 0x2295, 0x2299, 4 },
    { 0x22A5, 0x22BF, 26 },
    { 0x2312, 0x2460, 334 },
    { 0x2461, 0x24E9, 1 },
    { 0x24EB, 0x254B, 1 },
    { 0x2550, 0x2573, 1 },
    { 0x2580, 0x258F, 1 },
    { 0x2592, 0x2595, 1 },
    { 0x25A0, 0x25A1, 1 },
    { 0x25A3, 0x25A9, 1 },
    { 0x25B2, 0x25B3, 1 },
    { 0x25B6, 0x25B7, 1 },
    { 0x25BC, 0x25BD, 1 },
    { 0x25C0, 0x25C1, 1 },
    { 0x25C6, 0x25C8, 1 },
    { 0x25CB, 0x25CE, 3 },
    { 0x25CF, 0x25D1, 1 },
    { 0x25E2, 0x25E5, 1 },
    { 0x25EF, 0x2605, 22 },
    { 0x2606, 0x2609, 3 },
    { 0x260E, 0x260F, 1 },
    { 0x261C, 0x261E, 2 },
    { 0x2640, 0x2642, 2 },
    { 0x2660, 0x2661, 1 },
    { 0x2663, 0x2665, 1 },
    { 0x2667, 0x266A, 1 },
    { 0x266C, 0x266D, 1 },
    { 0x266F, 0x269E, 47 },
    { 0x269F, 0x26BF, 32 },
    { 0x26C6, 0x26CD, 1 },
    { 0x26CF, 0x26D3, 1 },
    { 0x26D5, 0x26E1, 1 },
    { 0x26E3, 0x26E8, 5 },
    { 0x26E9, 0x26EB, 2 },
    { 0x26EC, 0x26F1, 1 },
    { 0x26F4, 0x26F6, 2 },
    { 0x26F7, 0x26F9, 1 },
    { 0x26FB, 0x26FC, 1 },
    { 0x26FE, 0x26FF, 1 },
    { 0x273D, 0x2776, 57 },
    { 0x2777, 0x277F, 1 },
    { 0x2B56, 0x2B59, 1 },
    { 0x3248, 0x324F, 1 },
    { 0xE000, 0xF8FF, 1 },
    { 0xFE00, 0xFE0F, 1 },
    { 0xFFFD, 0x1F100, 61699 },
    { 0x1F101, 0x1F10A, 1 },
    { 0x1F110, 0x1F12D, 1 },
    { 0x1F130, 0x1F169, 1 },
    { 0x1F170, 0x1F18D, 1 },
    { 0x1F18F, 0x1F190, 1 },
    { 0x1F19B, 0x1F1AC, 1 },
    { 0xE0100, 0xE01EF, 1 },
    { 0xF0000, 0xFFFFD, 1 },
    { 0x100000, 0x10FFFD, 1 },
};

static struct canon_cls_table nfc_combining_table[] = {
    { 0x300, 0x314, 230 },
    { 0x315, 0x315, 232 },
    { 0x316, 0x319, 220 },
    { 0x31A, 0x31A, 232 },
    { 0x31B, 0x31B, 216 },
    { 0x31C, 0x320, 220 },
    { 0x321, 0x322, 202 },
    { 0x323, 0x326, 220 },
    { 0x327, 0x328, 202 },
    { 0x329, 0x333, 220 },
    { 0x334, 0x338, 1 },
    { 0x339, 0x33C, 220 },
    { 0x33D, 0x344, 230 },
    { 0x345, 0x345, 240 },
    { 0x346, 0x346, 230 },
    { 0x347, 0x349, 220 },
    { 0x34A, 0x34C, 230 },
    { 0x34D, 0x34E, 220 },
    { 0x350, 0x352, 230 },
    { 0x353, 0x356, 220 },
    { 0x357, 0x357, 230 },
    { 0x358, 0x358, 232 },
    { 0x359, 0x35A, 220 },
    { 0x35B, 0x35B, 230 },
    { 0x35C, 0x35C, 233 },
    { 0x35D, 0x35E, 234 },
    { 0x35F, 0x35F, 233 },
    { 0x360, 0x361, 234 },
    { 0x362, 0x362, 233 },
    { 0x363, 0x36F, 230 },
    { 0x483, 0x487, 230 },
    { 0x591, 0x591, 220 },
    { 0x592, 0x595, 230 },
    { 0x596, 0x596, 220 },
    { 0x597, 0x599, 230 },
    { 0x59A, 0x59A, 222 },
    { 0x59B, 0x59B, 220 },
    { 0x59C, 0x5A1, 230 },
    { 0x5A2, 0x5A7, 220 },
    { 0x5A8, 0x5A9, 230 },
    { 0x5AA, 0x5AA, 220 },
    { 0x5AB, 0x5AC, 230 },
    { 0x5AD, 0x5AD, 222 },
    { 0x5AE, 0x5AE, 228 },
    { 0x5AF, 0x5AF, 230 },
    { 0x5B0, 0x5B0, 10 },
    { 0x5B1, 0x5B1, 11 },
    { 0x5B2, 0x5B2, 12 },
    { 0x5B3, 0x5B3, 13 },
    { 0x5B4, 0x5B4, 14 },
    { 0x5B5, 0x5B5, 15 },
    { 0x5B6, 0x5B6, 16 },
    { 0x5B7, 0x5B7, 17 },
    { 0x5B8, 0x5B8, 18 },
    { 0x5B9, 0x5BA, 19 },
    { 0x5BB, 0x5BB, 20 },
    { 0x5BC, 0x5BC, 21 },
    { 0x5BD, 0x5BD, 22 },
    { 0x5BF, 0x5BF, 23 },
    { 0x5C1, 0x5C1, 24 },
    { 0x5C2, 0x5C2, 25 },
    { 0x5C4, 0x5C4, 230 },
    { 0x5C5, 0x5C5, 220 },
    { 0x5C7, 0x5C7, 18 },
    { 0x610, 0x617, 230 },
    { 0x618, 0x618, 30 },
    { 0x619, 0x619, 31 },
    { 0x61A, 0x61A, 32 },
    { 0x64B, 0x64B, 27 },
    { 0x64C, 0x64C, 28 },
    { 0x64D, 0x64D, 29 },
    { 0x64E, 0x64E, 30 },
    { 0x64F, 0x64F, 31 },
    { 0x650, 0x650, 32 },
    { 0x651, 0x651, 33 },
    { 0x652, 0x652, 34 },
    { 0x653, 0x654, 230 },
    { 0x655, 0x656, 220 },
    { 0x657, 0x65B, 230 },
    { 0x65C, 0x65C, 220 },
    { 0x65D, 0x65E, 230 },
    { 0x65F, 0x65F, 220 },
    { 0x670, 0x670, 35 },
    { 0x6D6, 0x6DC, 230 },
    { 0x6DF, 0x6E2, 230 },
    { 0x6E3, 0x6E3, 220 },
    { 0x6E4, 0x6E4, 230 },
    { 0x6E7, 0x6E8, 230 },
    { 0x6EA, 0x6EA, 220 },
    { 0x6EB, 0x6EC, 230 },
    { 0x6ED, 0x6ED, 220 },
    { 0x711, 0x711, 36 },
    { 0x730, 0x730, 230 },
    { 0x731, 0x731, 220 },
    { 0x732, 0x733, 230 },
    { 0x734, 0x734, 220 },
    { 0x735, 0x736, 230 },
    { 0x737, 0x739, 220 },
    { 0x73A, 0x73A, 230 },
    { 0x73B, 0x73C, 220 },
    { 0x73D, 0x73D, 230 },
    { 0x73E, 0x73E, 220 },
    { 0x73F, 0x741, 230 },
    { 0x742, 0x742, 220 },
    { 0x743, 0x743, 230 },
    { 0x744, 0x744, 220 },
    { 0x745, 0x745, 230 },
    { 0x746, 0x746, 220 },
    { 0x747, 0x747, 230 },
    { 0x748, 0x748, 220 },
    { 0x749, 0x74A, 230 },
    { 0x7EB, 0x7F1, 230 },
    { 0x7F2, 0x7F2, 220 },
    { 0x7F3, 0x7F3, 230 },
    { 0x7FD, 0x7FD, 220 },
    { 0x816, 0x819, 230 },
    { 0x81B, 0x823, 230 },
    { 0x825, 0x827, 230 },
    { 0x829, 0x82D, 230 },
    { 0x859, 0x85B, 220 },
    { 0x898, 0x898, 230 },
    { 0x899, 0x89B, 220 },
    { 0x89C, 0x89F, 230 },
    { 0x8CA, 0x8CE, 230 },
    { 0x8CF, 0x8D3, 220 },
    { 0x8D4, 0x8E1, 230 },
    { 0x8E3, 0x8E3, 220 },
    { 0x8E4, 0x8E5, 230 },
    { 0x8E6, 0x8E6, 220 },
    { 0x8E7, 0x8E8, 230 },
    { 0x8E9, 0x8E9, 220 },
    { 0x8EA, 0x8EC, 230 },
    { 0x8ED, 0x8EF, 220 },
    { 0x8F0, 0x8F0, 27 },
    { 0x8F1, 0x8F1, 28 },
    { 0x8F2, 0x8F2, 29 },
    { 0x8F3, 0x8F5, 230 },
    { 0x8F6, 0x8F6, 220 },
    { 0x8F7, 0x8F8, 230 },
    { 0x8F9, 0x8FA, 220 },
    { 0x8FB, 0x8FF, 230 },
    { 0x93C, 0x93C, 7 },
    { 0x94D, 0x94D, 9 },
    { 0x951, 0x951, 230 },
    { 0x952, 0x952, 220 },
    { 0x953, 0x954, 230 },
    { 0x9BC, 0x9BC, 7 },
    { 0x9CD, 0x9CD, 9 },
    { 0x9FE, 0x9FE, 230 },
    { 0xA3C, 0xA3C, 7 },
    { 0xA4D, 0xA4D, 9 },
    { 0xABC, 0xABC, 7 },
    { 0xACD, 0xACD, 9 },
    { 0xB3C, 0xB3C, 7 },
    { 0xB4D, 0xB4D, 9 },
    { 0xBCD, 0xBCD, 9 },
    { 0xC3C, 0xC3C, 7 },
    { 0xC4D, 0xC4D, 9 },
    { 0xC55, 0xC55, 84 },
    { 0xC56, 0xC56, 91 },
    { 0xCBC, 0xCBC, 7 },
    { 0xCCD, 0xCCD, 9 },
    { 0xD3B, 0xD3C, 9 },
    { 0xD4D, 0xD4D, 9 },
    { 0xDCA, 0xDCA, 9 },
    { 0xE38, 0xE39, 103 },
    { 0xE3A, 0xE3A, 9 },
    { 0xE48, 0xE4B, 107 },
    { 0xEB8, 0xEB9, 118 },
    { 0xEBA, 0xEBA, 9 },
    { 0xEC8, 0xECB, 122 },
    { 0xF18, 0xF19, 220 },
    { 0xF35, 0xF35, 220 },
    { 0xF37, 0xF37, 220 },
    { 0xF39, 0xF39, 216 },
    { 0xF71, 0xF71, 129 },
    { 0xF72, 0xF72, 130 },
    { 0xF74, 0xF74, 132 },
    { 0xF7A, 0xF7D, 130 },
    { 0xF80, 0xF80, 130 },
    { 0xF82, 0xF83, 230 },
    { 0xF84, 0xF84, 9 },
    { 0xF86, 0xF87, 230 },
    { 0xFC6, 0xFC6, 220 },
    { 0x1037, 0x1037, 7 },
    { 0x1039, 0x103A, 9 },
    { 0x108D, 0x108D, 220 },
    { 0x135D, 0x135F, 230 },
    { 0x1714, 0x1715, 9 },
    { 0x1734, 0x1734, 9 },
    { 0x17D2, 0x17D2, 9 },
    { 0x17DD, 0x17DD, 230 },
    { 0x18A9, 0x18A9, 228 },
    { 0x1939, 0x1939, 222 },
    { 0x193A, 0x193A, 230 },
    { 0x193B, 0x193B, 220 },
    { 0x1A17, 0x1A17, 230 },
    { 0x1A18, 0x1A18, 220 },
    { 0x1A60, 0x1A60, 9 },
    { 0x1A75, 0x1A7C, 230 },
    { 0x1A7F, 0x1A7F, 220 },
    { 0x1AB0, 0x1AB4, 230 },
    { 0x1AB5, 0x1ABA, 220 },
    { 0x1ABB, 0x1ABC, 230 },
    { 0x1ABD, 0x1ABD, 220 },
    { 0x1ABF, 0x1AC0, 220 },
    { 0x1AC1, 0x1AC2, 230 },
    { 0x1AC3, 0x1AC4, 220 },
    { 0x1AC5, 0x1AC9, 230 },
    { 0x1ACA, 0x1ACA, 220 },
    { 0x1ACB, 0x1ACE, 230 },
    { 0x1B34, 0x1B34, 7 },
    { 0x1B44, 0x1B44, 9 },
    { 0x1B6B, 0x1B6B, 230 },
    { 0x1B6C, 0x1B6C, 220 },
    { 0x1B6D, 0x1B73, 230 },
    { 0x1BAA, 0x1BAB, 9 },
    { 0x1BE6, 0x1BE6, 7 },
    { 0x1BF2, 0x1BF3, 9 },
    { 0x1C37, 0x1C37, 7 },
    { 0x1CD0, 0x1CD2, 230 },
    { 0x1CD4, 0x1CD4, 1 },
    { 0x1CD5, 0x1CD9, 220 },
    { 0x1CDA, 0x1CDB, 230 },
    { 0x1CDC, 0x1CDF, 220 },
    { 0x1CE0, 0x1CE0, 230 },
    { 0x1CE2, 0x1CE8, 1 },
    { 0x1CED, 0x1CED, 220 },
    { 0x1CF4, 0x1CF4, 230 },
    { 0x1CF8, 0x1CF9, 230 },
    { 0x1DC0, 0x1DC1, 230 },
    { 0x1DC2, 0x1DC2, 220 },
    { 0x1DC3, 0x1DC9, 230 },
    { 0x1DCA, 0x1DCA, 220 },
    { 0x1DCB, 0x1DCC, 230 },
    { 0x1DCD, 0x1DCD, 234 },
    { 0x1DCE, 0x1DCE, 214 },
    { 0x1DCF, 0x1DCF, 220 },
    { 0x1DD0, 0x1DD0, 202 },
    { 0x1DD1, 0x1DF5, 230 },
    { 0x1DF6, 0x1DF6, 232 },
    { 0x1DF7, 0x1DF8, 228 },
    { 0x1DF9, 0x1DF9, 220 },
    { 0x1DFA, 0x1DFA, 218 },
    { 0x1DFB, 0x1DFB, 230 },
    { 0x1DFC, 0x1DFC, 233 },
    { 0x1DFD, 0x1DFD, 220 },
    { 0x1DFE, 0x1DFE, 230 },
    { 0x1DFF, 0x1DFF, 220 },
    { 0x20D0, 0x20D1, 230 },
    { 0x20D2, 0x20D3, 1 },
    { 0x20D4, 0x20D7, 230 },
    { 0x20D8, 0x20DA, 1 },
    { 0x20DB, 0x20DC, 230 },
    { 0x20E1, 0x20E1, 230 },
    { 0x20E5, 0x20E6, 1 },
    { 0x20E7, 0x20E7, 230 },
    { 0x20E8, 0x20E8, 220 },
    { 0x20E9, 0x20E9, 230 },
    { 0x20EA, 0x20EB, 1 },
    { 0x20EC, 0x20EF, 220 },
    { 0x20F0, 0x20F0, 230 },
    { 0x2CEF, 0x2CF1, 230 },
    { 0x2D7F, 0x2D7F, 9 },
    { 0x2DE0, 0x2DFF, 230 },
    { 0x302A, 0x302A, 218 },
    { 0x302B, 0x302B, 228 },
    { 0x302C, 0x302C, 232 },
    { 0x302D, 0x302D, 222 },
    { 0x302E, 0x302F, 224 },
    { 0x3099, 0x309A, 8 },
    { 0xA66F, 0xA66F, 230 },
    { 0xA674, 0xA67D, 230 },
    { 0xA69E, 0xA69F, 230 },
    { 0xA6F0, 0xA6F1, 230 },
    { 0xA806, 0xA806, 9 },
    { 0xA82C, 0xA82C, 9 },
    { 0xA8C4, 0xA8C4, 9 },
    { 0xA8E0, 0xA8F1, 230 },
    { 0xA92B, 0xA92D, 220 },
    { 0xA953, 0xA953, 9 },
    { 0xA9B3, 0xA9B3, 7 },
    { 0xA9C0, 0xA9C0, 9 },
    { 0xAAB0, 0xAAB0, 230 },
    { 0xAAB2, 0xAAB3, 230 },
    { 0xAAB4, 0xAAB4, 220 },
    { 0xAAB7, 0xAAB8, 230 },
    { 0xAABE, 0xAABF, 230 },
    { 0xAAC1, 0xAAC1, 230 },
    { 0xAAF6, 0xAAF6, 9 },
    { 0xABED, 0xABED, 9 },
    { 0xFB1E, 0xFB1E, 26 },
    { 0xFE20, 0xFE26, 230 },
    { 0xFE27, 0xFE2D, 220 },
    { 0xFE2E, 0xFE2F, 230 },
    { 0x101FD, 0x101FD, 220 },
    { 0x102E0, 0x102E0, 220 },
    { 0x10376, 0x1037A, 230 },
    { 0x10A0D, 0x10A0D, 220 },
    { 0x10A0F, 0x10A0F, 230 },
    { 0x10A38, 0x10A38, 230 },
    { 0x10A39, 0x10A39, 1 },
    { 0x10A3A, 0x10A3A, 220 },
    { 0x10A3F, 0x10A3F, 9 },
    { 0x10AE5, 0x10AE5, 230 },
    { 0x10AE6, 0x10AE6, 220 },
    { 0x10D24, 0x10D27, 230 },
    { 0x10EAB, 0x10EAC, 230 },
    { 0x10EFD, 0x10EFF, 220 },
    { 0x10F46, 0x10F47, 220 },
    { 0x10F48, 0x10F4A, 230 },
    { 0x10F4B, 0x10F4B, 220 },
    { 0x10F4C, 0x10F4C, 230 },
    { 0x10F4D, 0x10F50, 220 },
    { 0x10F82, 0x10F82, 230 },
    { 0x10F83, 0x10F83, 220 },
    { 0x10F84, 0x10F84, 230 },
    { 0x10F85, 0x10F85, 220 },
    { 0x11046, 0x11046, 9 },
    { 0x11070, 0x11070, 9 },
    { 0x1107F, 0x1107F, 9 },
    { 0x110B9, 0x110B9, 9 },
    { 0x110BA, 0x110BA, 7 },
    { 0x11100, 0x11102, 230 },
    { 0x11133, 0x11134, 9 },
    { 0x11173, 0x11173, 7 },
    { 0x111C0, 0x111C0, 9 },
    { 0x111CA, 0x111CA, 7 },
    { 0x11235, 0x11235, 9 },
    { 0x11236, 0x11236, 7 },
    { 0x112E9, 0x112E9, 7 },
    { 0x112EA, 0x112EA, 9 },
    { 0x1133B, 0x1133C, 7 },
    { 0x1134D, 0x1134D, 9 },
    { 0x11366, 0x11374, 230 },
    { 0x11442, 0x11442, 9 },
    { 0x11446, 0x11446, 7 },
    { 0x1145E, 0x1145E, 230 },
    { 0x114C2, 0x114C2, 9 },
    { 0x114C3, 0x114C3, 7 },
    { 0x115BF, 0x115BF, 9 },
    { 0x115C0, 0x115C0, 7 },
    { 0x1163F, 0x1163F, 9 },
    { 0x116B6, 0x116B6, 9 },
    { 0x116B7, 0x116B7, 7 },
    { 0x1172B, 0x1172B, 9 },
    { 0x11839, 0x11839, 9 },
    { 0x1183A, 0x1183A, 7 },
    { 0x1193D, 0x1193E, 9 },
    { 0x11943, 0x11943, 7 },
    { 0x119E0, 0x119E0, 9 },
    { 0x11A34, 0x11A34, 9 },
    { 0x11A47, 0x11A47, 9 },
    { 0x11A99, 0x11A99, 9 },
    { 0x11C3F, 0x11C3F, 9 },
    { 0x11D42, 0x11D42, 7 },
    { 0x11D44, 0x11D45, 9 },
    { 0x11D97, 0x11D97, 9 },
    { 0x11F41, 0x11F42, 9 },
    { 0x16AF0, 0x16AF4, 1 },
    { 0x16B30, 0x16B36, 230 },
    { 0x16FF0, 0x16FF1, 6 },
    { 0x1BC9E, 0x1BC9E, 1 },
    { 0x1D165, 0x1D166, 216 },
    { 0x1D167, 0x1D169, 1 },
    { 0x1D16D, 0x1D16D, 226 },
    { 0x1D16E, 0x1D172, 216 },
    { 0x1D17B, 0x1D182, 220 },
    { 0x1D185, 0x1D189, 230 },
    { 0x1D18A, 0x1D18B, 220 },
    { 0x1D1AA, 0x1D1AD, 230 },
    { 0x1D242, 0x1D244, 230 },
    { 0x1E000, 0x1E02A, 230 },
    { 0x1E08F, 0x1E08F, 230 },
    { 0x1E130, 0x1E136, 230 },
    { 0x1E2AE, 0x1E2AE, 230 },
    { 0x1E2EC, 0x1E2EF, 230 },
    { 0x1E4EC, 0x1E4ED, 232 },
    { 0x1E4EE, 0x1E4EE, 220 },
    { 0x1E4EF, 0x1E4EF, 230 },
    { 0x1E8D0, 0x1E8D6, 220 },
    { 0x1E944, 0x1E949, 230 },
    { 0x1E94A, 0x1E94A, 7 },
};

static struct combine_table nfc_composite_table[] = {
    { 0x3524, 0x3C, 0x338, 0x226E },
    { 0x35F9, 0x3D, 0x338, 0x2260 },
    { 0x36CE, 0x3E, 0x338, 0x226F },
    { 0x3915, 0x41, 0x300, 0xC0 },
    { 0x3916, 0x41, 0x301, 0xC1 },
    { 0x3917, 0x41, 0x302, 0xC2 },
    { 0x3918, 0x41, 0x303, 0xC3 },
    { 0x3919, 0x41, 0x304, 0x100 },
    { 0x391B, 0x41, 0x306, 0x102 },
    { 0x391C, 0x41, 0x307, 0x226 },
    { 0x391D, 0x41, 0x308, 0xC4 },
    { 0x391E, 0x41, 0x309, 0x1EA2 },
    { 0x391F, 0x41, 0x30A, 0xC5 },
    { 0x3921, 0x41, 0x30C, 0x1CD },
    { 0x3924, 0x41, 0x30F, 0x200 },
    { 0x3926, 0x41, 0x311, 0x202 },
    { 0x3938, 0x41, 0x323, 0x1EA0 },
    { 0x393A, 0x41, 0x325, 0x1E00 },
    { 0x393D, 0x41, 0x328, 0x104 },
    { 0x39F1, 0x42, 0x307, 0x1E02 },
    { 0x3A0D, 0x42, 0x323, 0x1E04 },
    { 0x3A1B, 0x42, 0x331, 0x1E06 },
    { 0x3AC0, 0x43, 0x301, 0x106 },
    { 0x3AC1, 0x43, 0x302, 0x108 },
    { 0x3AC6, 0x43, 0x307, 0x10A },
    { 0x3ACB, 0x43, 0x30C, 0x10C },
    { 0x3AE6, 0x43, 0x327, 0xC7 },
    { 0x3B9B, 0x44, 0x307, 0x1E0A },
    { 0x3BA0, 0x44, 0x30C, 0x10E },
    { 0x3BB7, 0x44, 0x323, 0x1E0C },
    { 0x3BBB, 0x44, 0x327, 0x1E10 },
    { 0x3BC1, 0x44, 0x32D, 0x1E12 },
    { 0x3BC5, 0x44, 0x331, 0x1E0E },
    { 0x3C69, 0x45, 0x300, 0xC8 },
    { 0x3C6A, 0x45, 0x301, 0xC9 },
    { 0x3C6B, 0x45, 0x302, 0xCA },
    { 0x3C6C, 0x45, 0x303, 0x1EBC },
    { 0x3C6D, 0x45, 0x304, 0x112 },
    { 0x3C6F, 0x45, 0x306, 0x114 },
    { 0x3C70, 0x45, 0x307, 0x116 },
    { 0x3C71, 0x45, 0x308, 0xCB },
    { 0x3C72, 0x45, 0x309, 0x1EBA },
    { 0x3C75, 0x45, 0x30C, 0x11A },
    { 0x3C78, 0x45, 0x30F, 0x204 },
    { 0x3C7A, 0x45, 0x311, 0x206 },
    { 0x3C8C, 0x45, 0x323, 0x1EB8 },
    { 0x3C90, 0x45, 0x327, 0x228 },
    { 0x3C91, 0x45, 0x328, 0x118 },
    { 0x3C96, 0x45, 0x32D, 0x1E18 },
    { 0x3C99, 0x45, 0x330, 0x1E1A },
    { 0x3D45, 0x46, 0x307, 0x1E1E },
    { 0x3E14, 0x47, 0x301, 0x1F4 },
    { 0x3E15, 0x47, 0x302, 0x11C },
    { 0x3E17, 0x47, 0x304, 0x1E20 },
    { 0x3E19, 0x47, 0x306, 0x11E },
    { 0x3E1A, 0x47, 0x307, 0x120 },
    { 0x3E1F, 0x47, 0x30C, 0x1E6 },
    { 0x3E3A, 0x47, 0x327, 0x122 },
    { 0x3EEA, 0x48, 0x302, 0x124 },
    { 0x3EEF, 0x48, 0x307, 0x1E22 },
    { 0x3EF0, 0x48, 0x308, 0x1E26 },
    { 0x3EF4, 0x48, 0x30C, 0x21E },
    { 0x3F0B, 0x48, 0x323, 0x1E24 },
    { 0x3F0F, 0x48, 0x327, 0x1E28 },
    { 0x3F16, 0x48, 0x32E, 0x1E2A },
    { 0x3FBD, 0x49, 0x300, 0xCC },
    { 0x3FBE, 0x49, 0x301, 0xCD },
    { 0x3FBF, 0x49, 0x302, 0xCE },
    { 0x3FC0, 0x49, 0x303, 0x128 },
    { 0x3FC1, 0x49, 0x304, 0x12A },
    { 0x3FC3, 0x49, 0x306, 0x12C },
    { 0x3FC4, 0x49, 0x307, 0x130 },
    { 0x3FC5, 0x49, 0x308, 0xCF },
    { 0x3FC6, 0x49, 0x309, 0x1EC8 },
    { 0x3FC9, 0x49, 0x30C, 0x1CF },
    { 0x3FCC, 0x49, 0x30F, 0x208 },
    { 0x3FCE, 0x49, 0x311, 0x20A },
    { 0x3FE0, 0x49, 0x323, 0x1ECA },
    { 0x3FE5, 0x49, 0x328, 0x12E },
    { 0x3FED, 0x49, 0x330, 0x1E2C },
    { 0x4094, 0x4A, 0x302, 0x134 },
    { 0x4168, 0x4B, 0x301, 0x1E30 },
    { 0x4173, 0x4B, 0x30C, 0x1E8 },
    { 0x418A, 0x4B, 0x323, 0x1E32 },
    { 0x418E, 0x4B, 0x327, 0x136 },
    { 0x4198, 0x4B, 0x331, 0x1E34 },
    { 0x423D, 0x4C, 0x301, 0x139 },
    { 0x4248, 0x4C, 0x30C, 0x13D },
    { 0x425F, 0x4C, 0x323, 0x1E36 },
    { 0x4263, 0x4C, 0x327, 0x13B },
    { 0x4269, 0x4C, 0x32D, 0x1E3C },
    { 0x426D, 0x4C, 0x331, 0x1E3A },
    { 0x4312, 0x4D, 0x301, 0x1E3E },
    { 0x4318, 0x4D, 0x307, 0x1E40 },
    { 0x4334, 0x4D, 0x323, 0x1E42 },
    { 0x43E6, 0x4E, 0x300, 0x1F8 },
    { 0x43E7, 0x4E, 0x301, 0x143 },
    { 0x43E9, 0x4E, 0x303, 0xD1 },
    { 0x43ED, 0x4E, 0x307, 0x1E44 },
    { 0x43F2, 0x4E, 0x30C, 0x147 },
    { 0x4409, 0x4E, 0x323, 0x1E46 },
    { 0x440D, 0x4E, 0x327, 0x145 },
    { 0x4413, 0x4E, 0x32D, 0x1E4A },
    { 0x4417, 0x4E, 0x331, 0x1E48 },
    { 0x44BB, 0x4F, 0x300, 0xD2 },
    { 0x44BC, 0x4F, 0x301, 0xD3 },
    { 0x44BD, 0x4F, 0x302, 0xD4 },
    { 0x44BE, 0x4F, 0x303, 0xD5 },
    { 0x44BF, 0x4F, 0x304, 0x14C },
    { 0x44C1, 0x4F, 0x306, 0x14E },
    { 0x44C2, 0x4F, 0x307, 0x22E },
    { 0x44C3, 0x4F, 0x308, 0xD6 },
    { 0x44C4, 0x4F, 0x309, 0x1ECE },
    { 0x44C6, 0x4F, 0x30B, 0x150 },
    { 0x44C7, 0x4F, 0x30C, 0x1D1 },
    { 0x44CA, 0x4F, 0x30F, 0x20C },
    { 0x44CC, 0x4F, 0x311, 0x20E },
    { 0x44D6, 0x4F, 0x31B, 0x1A0 },
    { 0x44DE, 0x4F, 0x323, 0x1ECC },
    { 0x44E3, 0x4F, 0x328, 0x1EA },
    { 0x4591, 0x50, 0x301, 0x1E54 },
    { 0x4597, 0x50, 0x307, 0x1E56 },
    { 0x473B, 0x52, 0x301, 0x154 },
    { 0x4741, 0x52, 0x307, 0x1E58 },
    { 0x4746, 0x52, 0x30C, 0x158 },
    { 0x4749, 0x52, 0x30F, 0x210 },
    { 0x474B, 0x52, 0x311, 0x212 },
    { 0x475D, 0x52, 0x323, 0x1E5A },
    { 0x4761, 0x52, 0x327, 0x156 },
    { 0x476B, 0x52, 0x331, 0x1E5E },
    { 0x4810, 0x53, 0x301, 0x15A },
    { 0x4811, 0x53, 0x302, 0x15C },
    { 0x4816, 0x53, 0x307, 0x1E60 },
    { 0x481B, 0x53, 0x30C, 0x160 },
    { 0x4832, 0x53, 0x323, 0x1E62 },
    { 0x4835, 0x53, 0x326, 0x218 },
    { 0x4836, 0x53, 0x327, 0x15E },
    { 0x48EB, 0x54, 0x307, 0x1E6A },
    { 0x48F0, 0x54, 0x30C, 0x164 },
    { 0x4907, 0x54, 0x323, 0x1E6C },
    { 0x490A, 0x54, 0x326, 0x21A },
    { 0x490B, 0x54, 0x327, 0x162 },
    { 0x4911, 0x54, 0x32D, 0x1E70 },
    { 0x4915, 0x54, 0x331, 0x1E6E },
    { 0x49B9, 0x55, 0x300, 0xD9 },
    { 0x49BA, 0x55, 0x301, 0xDA },
    { 0x49BB, 0x55, 0x302, 0xDB },
    { 0x49BC, 0x55, 0x303, 0x168 },
    { 0x49BD, 0x55, 0x304, 0x16A },
    { 0x49BF, 0x55, 0x306, 0x16C },
    { 0x49C1, 0x55, 0x308, 0xDC },
    { 0x49C2, 0x55, 0x309, 0x1EE6 },
    { 0x49C3, 0x55, 0x30A, 0x16E },
    { 0x49C4, 0x55, 0x30B, 0x170 },
    { 0x49C5, 0x55, 0x30C, 0x1D3 },
    { 0x49C8, 0x55, 0x30F, 0x214 },
    { 0x49CA, 0x55, 0x311, 0x216 },
    { 0x49D4, 0x55, 0x31B, 0x1AF },
    { 0x49DC, 0x55, 0x323, 0x1EE4 },
    { 0x49DD, 0x55, 0x324, 0x1E72 },
    { 0x49E1, 0x55, 0x328, 0x172 },
    { 0x49E6, 0x55, 0x32D, 0x1E76 },
    { 0x49E9, 0x55, 0x330, 0x1E74 },
    { 0x4A91, 0x56, 0x303, 0x1E7C },
    { 0x4AB1, 0x56, 0x323, 0x1E7E },
    { 0x4B63, 0x57, 0x300, 0x1E80 },
    { 0x4B64, 0x57, 0x301, 0x1E82 },
    { 0x4B65, 0x57, 0x302, 0x174 },
    { 0x4B6A, 0x57, 0x307, 0x1E86 },
    { 0x4B6B, 0x57, 0x308, 0x1E84 },
    { 0x4B86, 0x57, 0x323, 0x1E88 },
    { 0x4C3F, 0x58, 0x307, 0x1E8A },
    { 0x4C40, 0x58, 0x308, 0x1E8C },
    { 0x4D0D, 0x59, 0x300, 0x1EF2 },
    { 0x4D0E, 0x59, 0x301, 0xDD },
    { 0x4D0F, 0x59, 0x302, 0x176 },
    { 0x4D10, 0x59, 0x303, 0x1EF8 },
    { 0x4D11, 0x59, 0x304, 0x232 },
    { 0x4D14, 0x59, 0x307, 0x1E8E },
    { 0x4D15, 0x59, 0x308, 0x178 },
    { 0x4D16, 0x59, 0x309, 0x1EF6 },
    { 0x4D30, 0x59, 0x323, 0x1EF4 },
    { 0x4DE3, 0x5A, 0x301, 0x179 },
    { 0x4DE4, 0x5A, 0x302, 0x1E90 },
    { 0x4DE9, 0x5A, 0x307, 0x17B },
    { 0x4DEE, 0x5A, 0x30C, 0x17D },
    { 0x4E05, 0x5A, 0x323, 0x1E92 },
    { 0x4E13, 0x5A, 0x331, 0x1E94 },
    { 0x53B5, 0x61, 0x300, 0xE0 },
    { 0x53B6, 0x61, 0x301, 0xE1 },
    { 0x53B7, 0x61, 0x302, 0xE2 },
    { 0x53B8, 0x61, 0x303, 0xE3 },
    { 0x53B9, 0x61, 0x304, 0x101 },
    { 0x53BB, 0x61, 0x306, 0x103 },
    { 0x53BC, 0x61, 0x307, 0x227 },
    { 0x53BD, 0x61, 0x308, 0xE4 },
    { 0x53BE, 0x61, 0x309, 0x1EA3 },
    { 0x53BF, 0x61, 0x30A, 0xE5 },
    { 0x53C1, 0x61, 0x30C, 0x1CE },
    { 0x53C4, 0x61, 0x30F, 0x201 },
    { 0x53C6, 0x61, 0x311, 0x203 },
    { 0x53D8, 0x61, 0x323, 0x1EA1 },
    { 0x53DA, 0x61, 0x325, 0x1E01 },
    { 0x53DD, 0x61, 0x328, 0x105 },
    { 0x5491, 0x62, 0x307, 0x1E03 },
    { 0x54AD, 0x62, 0x323, 0x1E05 },
    { 0x54BB, 0x62, 0x331, 0x1E07 },
    { 0x5560, 0x63, 0x301, 0x107 },
    { 0x5561, 0x63, 0x302, 0x109 },
    { 0x5566, 0x63, 0x307, 0x10B },
    { 0x556B, 0x63, 0x30C, 0x10D },
    { 0x5586, 0x63, 0x327, 0xE7 },
    { 0x563B, 0x64, 0x307, 0x1E0B },
    { 0x5640, 0x64, 0x30C, 0x10F },
    { 0x5657, 0x64, 0x323, 0x1E0D },
    { 0x565B, 0x64, 0x327, 0x1E11 },
    { 0x5661, 0x64, 0x32D, 0x1E13 },
    { 0x5665, 0x64, 0x331, 0x1E0F },
    { 0x5709, 0x65, 0x300, 0xE8 },
    { 0x570A, 0x65, 0x301, 0xE9 },
    { 0x570B, 0x65, 0x302, 0xEA },
    { 0x570C, 0x65, 0x303, 0x1EBD },
    { 0x570D, 0x65, 0x304, 0x113 },
    { 0x570F, 0x65, 0x306, 0x115 },
    { 0x5710, 0x65, 0x307, 0x117 },
    { 0x5711, 0x65, 0x308, 0xEB },
    { 0x5712, 0x65, 0x309, 0x1EBB },
    { 0x5715, 0x65, 0x30C, 0x11B },
    { 0x5718, 0x65, 0x30F, 0x205 },
    { 0x571A, 0x65, 0x311, 0x207 },
    { 0x572C, 0x65, 0x323, 0x1EB9 },
    { 0x5730, 0x65, 0x327, 0x229 },
    { 0x5731, 0x65, 0x328, 0x119 },
    { 0x5736, 0x65, 0x32D, 0x1E19 },
    { 0x5739, 0x65, 0x330, 0x1E1B },
    { 0x57E5, 0x66, 0x307, 0x1E1F },
    { 0x58B4, 0x67, 0x301, 0x1F5 },
    { 0x58B5, 0x67, 0x302, 0x11D },
    { 0x58B7, 0x67, 0x304, 0x1E21 },
    { 0x58B9, 0x67, 0x306, 0x11F },
    { 0x58BA, 0x67, 0x307, 0x121 },
    { 0x58BF, 0x67, 0x30C, 0x1E7 },
    { 0x58DA, 0x67, 0x327, 0x123 },
    { 0x598A, 0x68, 0x302, 0x125 },
    { 0x598F, 0x68, 0x307, 0x1E23 },
    { 0x5990, 0x68, 0x308, 0x1E27 },
    { 0x5994, 0x68, 0x30C, 0x21F },
    { 0x59AB, 0x68, 0x323, 0x1E25 },
    { 0x59AF, 0x68, 0x327, 0x1E29 },
    { 0x59B6, 0x68, 0x32E, 0x1E2B },
    { 0x59B9, 0x68, 0x331, 0x1E96 },
    { 0x5A5D, 0x69, 0x300, 0xEC },
    { 0x5A5E, 0x69, 0x301, 0xED },
    { 0x5A5F, 0x69, 0x302, 0xEE },
    { 0x5A60, 0x69, 0x303, 0x129 },
    { 0x5A61, 0x69, 0x304, 0x12B },
    { 0x5A63, 0x69, 0x306, 0x12D },
    { 0x5A65, 0x69, 0x308, 0xEF },
    { 0x5A66, 0x69, 0x309, 0x1EC9 },
    { 0x5A69, 0x69, 0x30C, 0x1D0 },
    { 0x5A6C, 0x69, 0x30F, 0x209 },
    { 0x5A6E, 0x69, 0x311, 0x20B },
    { 0x5A80, 0x69, 0x323, 0x1ECB },
    { 0x5A85, 0x69, 0x328, 0x12F },
    { 0x5A8D, 0x69, 0x330, 0x1E2D },
    { 0x5B34, 0x6A, 0x302, 0x135 },
    { 0x5B3E, 0x6A, 0x30C, 0x1F0 },
    { 0x5C08, 0x6B, 0x301, 0x1E31 },
    { 0x5C13, 0x6B, 0x30C, 0x1E9 },
    { 0x5C2A, 0x6B, 0x323, 0x1E33 },
    { 0x5C2E, 0x6B, 0x327, 0x137 },
    { 0x5C38, 0x6B, 0x331, 0x1E35 },
    { 0x5CDD, 0x6C, 0x301, 0x13A },
    { 0x5CE8, 0x6C, 0x30C, 0x13E },
    { 0x5CFF, 0x6C, 0x323, 0x1E37 },
    { 0x5D03, 0x6C, 0x327, 0x13C },
    { 0x5D09, 0x6C, 0x32D, 0x1E3D },
    { 0x5D0D, 0x6C, 0x331, 0x1E3B },
    { 0x5DB2, 0x6D, 0x301, 0x1E3F },
    { 0x5DB8, 0x6D, 0x307, 0x1E41 },
    { 0x5DD4, 0x6D, 0x323, 0x1E43 },
    { 0x5E86, 0x6E, 0x300, 0x1F9 },
    { 0x5E87, 0x6E, 0x301, 0x144 },
    { 0x5E89, 0x6E, 0x303, 0xF1 },
    { 0x5E8D, 0x6E, 0x307, 0x1E45 },
    { 0x5E92, 0x6E, 0x30C, 0x148 },
    { 0x5EA9, 0x6E, 0x323, 0x1E47 },
    { 0x5EAD, 0x6E, 0x327, 0x146 },
    { 0x5EB3, 0x6E, 0x32D, 0x1E4B },
    { 0x5EB7, 0x6E, 0x331, 0x1E49 },
    { 0x5F5B, 0x6F, 0x300, 0xF2 },
    { 0x5F5C, 0x6F, 0x301, 0xF3 },
    { 0x5F5D, 0x6F, 0x302, 0xF4 },
    { 0x5F5E, 0x6F, 0x303, 0xF5 },
    { 0x5F5F, 0x6F, 0x304, 0x14D },
    { 0x5F61, 0x6F, 0x306, 0x14F },
    { 0x5F62, 0x6F, 0x307, 0x22F },
    { 0x5F63, 0x6F, 0x308, 0xF6 },
    { 0x5F64, 0x6F, 0x309, 0x1ECF },
    { 0x5F66, 0x6F, 0x30B, 0x151 },
    { 0x5F67, 0x6F, 0x30C, 0x1D2 },
    { 0x5F6A, 0x6F, 0x30F, 0x20D },
    { 0x5F6C, 0x6F, 0x311, 0x20F },
    { 0x5F76, 0x6F, 0x31B, 0x1A1 },
    { 0x5F7E, 0x6F, 0x323, 0x1ECD },
    { 0x5F83, 0x6F, 0x328, 0x1EB },
    { 0x6031, 0x70, 0x301, 0x1E55 },
    { 0x6037, 0x70, 0x307, 0x1E57 },
    { 0x61DB, 0x72, 0x301, 0x155 },
    { 0x61E1, 0x72, 0x307, 0x1E59 },
    { 0x61E6, 0x72, 0x30C, 0x159 },
    { 0x61E9, 0x72, 0x30F, 0x211 },
    { 0x61EB, 0x72, 0x311, 0x213 },
    { 0x61FD, 0x72, 0x323, 0x1E5B },
    { 0x6201, 0x72, 0x327, 0x157 },
    { 0x620B, 0x72, 0x331, 0x1E5F },
    { 0x62B0, 0x73, 0x301, 0x15B },
    { 0x62B1, 0x73, 0x302, 0x15D },
    { 0x62B6, 0x73, 0x307, 0x1E61 },
    { 0x62BB, 0x73, 0x30C, 0x161 },
    { 0x62D2, 0x73, 0x323, 0x1E63 },
    { 0x62D5, 0x73, 0x326, 0x219 },
    { 0x62D6, 0x73, 0x327, 0x15F },
    { 0x638B, 0x74, 0x307, 0x1E6B },
    { 0x638C, 0x74, 0x308, 0x1E97 },
    { 0x6390, 0x74, 0x30C, 0x165 },
    { 0x63A7, 0x74, 0x323, 0x1E6D },
    { 0x63AA, 0x74, 0x326, 0x21B },
    { 0x63AB, 0x74, 0x327, 0x163 },
    { 0x63B1, 0x74, 0x32D, 0x1E71 },
    { 0x63B5, 0x74, 0x331, 0x1E6F },
    { 0x6459, 0x75, 0x300, 0xF9 },
    { 0x645A, 0x75, 0x301, 0xFA },
    { 0x645B, 0x75, 0x302, 0xFB },
    { 0x645C, 0x75, 0x303, 0x169 },
    { 0x645D, 0x75, 0x304, 0x16B },
    { 0x645F, 0x75, 0x306, 0x16D },
    { 0x6461, 0x75, 0x308, 0xFC },
    { 0x6462, 0x75, 0x309, 0x1EE7 },
    { 0x6463, 0x75, 0x30A, 0x16F },
    { 0x6464, 0x75, 0x30B, 0x171 },
    { 0x6465, 0x75, 0x30C, 0x1D4 },
    { 0x6468, 0x75, 0x30F, 0x215 },
    { 0x646A, 0x75, 0x311, 0x217 },
    { 0x6474, 0x75, 0x31B, 0x1B0 },
    { 0x647C, 0x75, 0x323, 0x1EE5 },
    { 0x647D, 0x75, 0x324, 0x1E73 },
    { 0x6481, 0x75, 0x328, 0x173 },
    { 0x6486, 0x75, 0x32D, 0x1E77 },
    { 0x6489, 0x75, 0x330, 0x1E75 },
    { 0x6531, 0x76, 0x303, 0x1E7D },
    { 0x6551, 0x76, 0x323, 0x1E7F },
    { 0x6603, 0x77, 0x300, 0x1E81 },
    { 0x6604, 0x77, 0x301, 0x1E83 },
    { 0x6605, 0x77, 0x302, 0x175 },
    { 0x660A, 0x77, 0x307, 0x1E87 },
    { 0x660B, 0x77, 0x308, 0x1E85 },
    { 0x660D, 0x77, 0x30A, 0x1E98 },
    { 0x6626, 0x77, 0x323, 0x1E89 },
    { 0x66DF, 0x78, 0x307, 0x1E8B },
    { 0x66E0, 0x78, 0x308, 0x1E8D },
    { 0x67AD, 0x79, 0x300, 0x1EF3 },
    { 0x67AE, 0x79, 0x301, 0xFD },
    { 0x67AF, 0x79, 0x302, 0x177 },
    { 0x67B0, 0x79, 0x303, 0x1EF9 },
    { 0x67B1, 0x79, 0x304, 0x233 },
    { 0x67B4, 0x79, 0x307, 0x1E8F },
    { 0x67B5, 0x79, 0x308, 0xFF },
    { 0x67B6, 0x79, 0x309, 0x1EF7 },
    { 0x67B7, 0x79, 0x30A, 0x1E99 },
    { 0x67D0, 0x79, 0x323, 0x1EF5 },
    { 0x6883, 0x7A, 0x301, 0x17A },
    { 0x6884, 0x7A, 0x302, 0x1E91 },
    { 0x6889, 0x7A, 0x307, 0x17C },
    { 0x688E, 0x7A, 0x30C, 0x17E },
    { 0x68A5, 0x7A, 0x323, 0x1E93 },
    { 0x68B3, 0x7A, 0x331, 0x1E95 },
    { 0x8EC8, 0xA8, 0x300, 0x1FED },
    { 0x8EC9, 0xA8, 0x301, 0x385 },
    { 0x8F0A, 0xA8, 0x342, 0x1FC1 },
    { 0xA46A, 0xC2, 0x300, 0x1EA6 },
    { 0xA46B, 0xC2, 0x301, 0x1EA4 },
    { 0xA46D, 0xC2, 0x303, 0x1EAA },
    { 0xA473, 0xC2, 0x309, 0x1EA8 },
    { 0xA618, 0xC4, 0x304, 0x1DE },
    { 0xA6EA, 0xC5, 0x301, 0x1FA },
    { 0xA7BF, 0xC6, 0x301, 0x1FC },
    { 0xA7C2, 0xC6, 0x304, 0x1E2 },
    { 0xA894, 0xC7, 0x301, 0x1E08 },
    { 0xAB12, 0xCA, 0x300, 0x1EC0 },
    { 0xAB13, 0xCA, 0x301, 0x1EBE },
    { 0xAB15, 0xCA, 0x303, 0x1EC4 },
    { 0xAB1B, 0xCA, 0x309, 0x1EC2 },
    { 0xAF3C, 0xCF, 0x301, 0x1E2E },
    { 0xB364, 0xD4, 0x300, 0x1ED2 },
    { 0xB365, 0xD4, 0x301, 0x1ED0 },
    { 0xB367, 0xD4, 0x303, 0x1ED6 },
    { 0xB36D, 0xD4, 0x309, 0x1ED4 },
    { 0xB43A, 0xD5, 0x301, 0x1E4C },
    { 0xB43D, 0xD5, 0x304, 0x22C },
    { 0xB441, 0xD5, 0x308, 0x1E4E },
    { 0xB512, 0xD6, 0x304, 0x22A },
    { 0xB6B9, 0xD8, 0x301, 0x1FE },
    { 0xBA0C, 0xDC, 0x300, 0x1DB },
    { 0xBA0D, 0xDC, 0x301, 0x1D7 },
    { 0xBA10, 0xDC, 0x304, 0x1D5 },
    { 0xBA18, 0xDC, 0x30C, 0x1D9 },
    { 0xBF0A, 0xE2, 0x300, 0x1EA7 },
    { 0xBF0B, 0xE2, 0x301, 0x1EA5 },
    { 0xBF0D, 0xE2, 0x303, 0x1EAB },
    { 0xBF13, 0xE2, 0x309, 0x1EA9 },
    { 0xC0B8, 0xE4, 0x304, 0x1DF },
    { 0xC18A, 0xE5, 0x301, 0x1FB },
    { 0xC25F, 0xE6, 0x301, 0x1FD },
    { 0xC262, 0xE6, 0x304, 0x1E3 },
    { 0xC334, 0xE7, 0x301, 0x1E09 },
    { 0xC5B2, 0xEA, 0x300, 0x1EC1 },
    { 0xC5B3, 0xEA, 0x301, 0x1EBF },
    { 0xC5B5, 0xEA, 0x303, 0x1EC5 },
    { 0xC5BB, 0xEA, 0x309, 0x1EC3 },
    { 0xC9DC, 0xEF, 0x301, 0x1E2F },
    { 0xCE04, 0xF4, 0x300, 0x1ED3 },
    { 0xCE05, 0xF4, 0x301, 0x1ED1 },
    { 0xCE07, 0xF4, 0x303, 0x1ED7 },
    { 0xCE0D, 0xF4, 0x309, 0x1ED5 },
    { 0xCEDA, 0xF5, 0x301, 0x1E4D },
    { 0xCEDD, 0xF5, 0x304, 0x22D },
    { 0xCEE1, 0xF5, 0x308, 0x1E4F },
    { 0xCFB2, 0xF6, 0x304, 0x22B },
    { 0xD159, 0xF8, 0x301, 0x1FF },
    { 0xD4AC, 0xFC, 0x300, 0x1DC },
    { 0xD4AD, 0xFC, 0x301, 0x1D8 },
    { 0xD4B0, 0xFC, 0x304, 0x1D6 },
    { 0xD4B8, 0xFC, 0x30C, 0x1DA },
    { 0xD9AA, 0x102, 0x300, 0x1EB0 },
    { 0xD9AB, 0x102, 0x301, 0x1EAE },
    { 0xD9AD, 0x102, 0x303, 0x1EB4 },
    { 0xD9B3, 0x102, 0x309, 0x1EB2 },
    { 0xDA7F, 0x103, 0x300, 0x1EB1 },
    { 0xDA80, 0x103, 0x301, 0x1EAF },
    { 0xDA82, 0x103, 0x303, 0x1EB5 },
    { 0xDA88, 0x103, 0x309, 0x1EB3 },
    { 0xE6FA, 0x112, 0x300, 0x1E14 },
    { 0xE6FB, 0x112, 0x301, 0x1E16 },
    { 0xE7CF, 0x113, 0x300, 0x1E15 },
    { 0xE7D0, 0x113, 0x301, 0x1E17 },
    { 0x1173C, 0x14C, 0x300, 0x1E50 },
    { 0x1173D, 0x14C, 0x301, 0x1E52 },
    { 0x11811, 0x14D, 0x300, 0x1E51 },
    { 0x11812, 0x14D, 0x301, 0x1E53 },
    { 0x122E9, 0x15A, 0x307, 0x1E64 },
    { 0x123BE, 0x15B, 0x307, 0x1E65 },
    { 0x127E7, 0x160, 0x307, 0x1E66 },
    { 0x128BC, 0x161, 0x307, 0x1E67 },
    { 0x12E89, 0x168, 0x301, 0x1E78 },
    { 0x12F5E, 0x169, 0x301, 0x1E79 },
    { 0x1303A, 0x16A, 0x308, 0x1E7A },
    { 0x1310F, 0x16B, 0x308, 0x1E7B },
    { 0x141B2, 0x17F, 0x307, 0x1E9B },
    { 0x15D20, 0x1A0, 0x300, 0x1EDC },
    { 0x15D21, 0x1A0, 0x301, 0x1EDA },
    { 0x15D23, 0x1A0, 0x303, 0x1EE0 },
    { 0x15D29, 0x1A0, 0x309, 0x1EDE },
    { 0x15D43, 0x1A0, 0x323, 0x1EE2 },
    { 0x15DF5, 0x1A1, 0x300, 0x1EDD },
    { 0x15DF6, 0x1A1, 0x301, 0x1EDB },
    { 0x15DF8, 0x1A1, 0x303, 0x1EE1 },
    { 0x15DFE, 0x1A1, 0x309, 0x1EDF },
    { 0x15E18, 0x1A1, 0x323, 0x1EE3 },
    { 0x1699B, 0x1AF, 0x300, 0x1EEA },
    { 0x1699C, 0x1AF, 0x301, 0x1EE8 },
    { 0x1699E, 0x1AF, 0x303, 0x1EEE },
    { 0x169A4, 0x1AF, 0x309, 0x1EEC },
    { 0x169BE, 0x1AF, 0x323, 0x1EF0 },
    { 0x16A70, 0x1B0, 0x300, 0x1EEB },
    { 0x16A71, 0x1B0, 0x301, 0x1EE9 },
    { 0x16A73, 0x1B0, 0x303, 0x1EEF },
    { 0x16A79, 0x1B0, 0x309, 0x1EED },
    { 0x16A93, 0x1B0, 0x323, 0x1EF1 },
    { 0x1704F, 0x1B7, 0x30C, 0x1EE },
    { 0x19AB6, 0x1EA, 0x304, 0x1EC },
    { 0x19B8B, 0x1EB, 0x304, 0x1ED },
    { 0x1CCA2, 0x226, 0x304, 0x1E0 },
    { 0x1CD77, 0x227, 0x304, 0x1E1 },
    { 0x1CE4E, 0x228, 0x306, 0x1E1C },
    { 0x1CF23, 0x229, 0x306, 0x1E1D },
    { 0x1D34A, 0x22E, 0x304, 0x230 },
    { 0x1D41F, 0x22F, 0x304, 0x231 },
    { 0x22686, 0x292, 0x30C, 0x1EF },
    { 0x2FAA5, 0x391, 0x300, 0x1FBA },
    { 0x2FAA6, 0x391, 0x301, 0x386 },
    { 0x2FAA9, 0x391, 0x304, 0x1FB9 },
    { 0x2FAAB, 0x391, 0x306, 0x1FB8 },
    { 0x2FAB8, 0x391, 0x313, 0x1F08 },
    { 0x2FAB9, 0x391, 0x314, 0x1F09 },
    { 0x2FAEA, 0x391, 0x345, 0x1FBC },
    { 0x2FDF9, 0x395, 0x300, 0x1FC8 },
    { 0x2FDFA, 0x395, 0x301, 0x388 },
    { 0x2FE0C, 0x395, 0x313, 0x1F18 },
    { 0x2FE0D, 0x395, 0x314, 0x1F19 },
    { 0x2FFA3, 0x397, 0x300, 0x1FCA },
    { 0x2FFA4, 0x397, 0x301, 0x389 },
    { 0x2FFB6, 0x397, 0x313, 0x1F28 },
    { 0x2FFB7, 0x397, 0x314, 0x1F29 },
    { 0x2FFE8, 0x397, 0x345, 0x1FCC },
    { 0x3014D, 0x399, 0x300, 0x1FDA },
    { 0x3014E, 0x399, 0x301, 0x38A },
    { 0x30151, 0x399, 0x304, 0x1FD9 },
    { 0x30153, 0x399, 0x306, 0x1FD8 },
    { 0x30155, 0x399, 0x308, 0x3AA },
    { 0x30160, 0x399, 0x313, 0x1F38 },
    { 0x30161, 0x399, 0x314, 0x1F39 },
    { 0x3064B, 0x39F, 0x300, 0x1FF8 },
    { 0x3064C, 0x39F, 0x301, 0x38C },
    { 0x3065E, 0x39F, 0x313, 0x1F48 },
    { 0x3065F, 0x39F, 0x314, 0x1F49 },
    { 0x30809, 0x3A1, 0x314, 0x1FEC },
    { 0x30B49, 0x3A5, 0x300, 0x1FEA },
    { 0x30B4A, 0x3A5, 0x301, 0x38E },
    { 0x30B4D, 0x3A5, 0x304, 0x1FE9 },
    { 0x30B4F, 0x3A5, 0x306, 0x1FE8 },
    { 0x30B51, 0x3A5, 0x308, 0x3AB },
    { 0x30B5D, 0x3A5, 0x314, 0x1F59 },
    { 0x30E9D, 0x3A9, 0x300, 0x1FFA },
    { 0x30E9E, 0x3A9, 0x301, 0x38F },
    { 0x30EB0, 0x3A9, 0x313, 0x1F68 },
    { 0x30EB1, 0x3A9, 0x314, 0x1F69 },
    { 0x30EE2, 0x3A9, 0x345, 0x1FFC },
    { 0x31161, 0x3AC, 0x345, 0x1FB4 },
    { 0x3130B, 0x3AE, 0x345, 0x1FC4 },
    { 0x31545, 0x3B1, 0x300, 0x1F70 },
    { 0x31546, 0x3B1, 0x301, 0x3AC },
    { 0x31549, 0x3B1, 0x304, 0x1FB1 },
    { 0x3154B, 0x3B1, 0x306, 0x1FB0 },
    { 0x31558, 0x3B1, 0x313, 0x1F00 },
    { 0x31559, 0x3B1, 0x314, 0x1F01 },
    { 0x31587, 0x3B1, 0x342, 0x1FB6 },
    { 0x3158A, 0x3B1, 0x345, 0x1FB3 },
    { 0x31899, 0x3B5, 0x300, 0x1F72 },
    { 0x3189A, 0x3B5, 0x301, 0x3AD },
    { 0x318AC, 0x3B5, 0x313, 0x1F10 },
    { 0x318AD, 0x3B5, 0x314, 0x1F11 },
    { 0x31A43, 0x3B7, 0x300, 0x1F74 },
    { 0x31A44, 0x3B7, 0x301, 0x3AE },
    { 0x31A56, 0x3B7, 0x313, 0x1F20 },
    { 0x31A57, 0x3B7, 0x314, 0x1F21 },
    { 0x31A85, 0x3B7, 0x342, 0x1FC6 },
    { 0x31A88, 0x3B7, 0x345, 0x1FC3 },
    { 0x31BED, 0x3B9, 0x300, 0x1F76 },
    { 0x31BEE, 0x3B9, 0x301, 0x3AF },
    { 0x31BF1, 0x3B9, 0x304, 0x1FD1 },
    { 0x31BF3, 0x3B9, 0x306, 0x1FD0 },
    { 0x31BF5, 0x3B9, 0x308, 0x3CA },
    { 0x31C00, 0x3B9, 0x313, 0x1F30 },
    { 0x31C01, 0x3B9, 0x314, 0x1F31 },
    { 0x31C2F, 0x3B9, 0x342, 0x1FD6 },
    { 0x320EB, 0x3BF, 0x300, 0x1F78 },
    { 0x320EC, 0x3BF, 0x301, 0x3CC },
    { 0x320FE, 0x3BF, 0x313, 0x1F40 },
    { 0x320FF, 0x3BF, 0x314, 0x1F41 },
    { 0x322A8, 0x3C1, 0x313, 0x1FE4 },
    { 0x322A9, 0x3C1, 0x314, 0x1FE5 },
    { 0x325E9, 0x3C5, 0x300, 0x1F7A },
    { 0x325EA, 0x3C5, 0x301, 0x3CD },
    { 0x325ED, 0x3C5, 0x304, 0x1FE1 },
    { 0x325EF, 0x3C5, 0x306, 0x1FE0 },
    { 0x325F1, 0x3C5, 0x308, 0x3CB },
    { 0x325FC, 0x3C5, 0x313, 0x1F50 },
    { 0x325FD, 0x3C5, 0x314, 0x1F51 },
    { 0x3262B, 0x3C5, 0x342, 0x1FE6 },
    { 0x3293D, 0x3C9, 0x300, 0x1F7C },
    { 0x3293E, 0x3C9, 0x301, 0x3CE },
    { 0x32950, 0x3C9, 0x313, 0x1F60 },
    { 0x32951, 0x3C9, 0x314, 0x1F61 },
    { 0x3297F, 0x3C9, 0x342, 0x1FF6 },
    { 0x32982, 0x3C9, 0x345, 0x1FF3 },
    { 0x32A12, 0x3CA, 0x300, 0x1FD2 },
    { 0x32A13, 0x3CA, 0x301, 0x390 },
    { 0x32A54, 0x3CA, 0x342, 0x1FD7 },
    { 0x32AE7, 0x3CB, 0x300, 0x1FE2 },
    { 0x32AE8, 0x3CB, 0x301, 0x3B0 },
    { 0x32B29, 0x3CB, 0x342, 0x1FE7 },
    { 0x32DAB, 0x3CE, 0x345, 0x1FF4 },
    { 0x330BB, 0x3D2, 0x301, 0x3D3 },
    { 0x330C2, 0x3D2, 0x308, 0x3D4 },
    { 0x35C06, 0x406, 0x308, 0x407 },
    { 0x36456, 0x410, 0x306, 0x4D0 },
    { 0x36458, 0x410, 0x308, 0x4D2 },
    { 0x366D0, 0x413, 0x301, 0x403 },
    { 0x36879, 0x415, 0x300, 0x400 },
    { 0x3687F, 0x415, 0x306, 0x4D6 },
    { 0x36881, 0x415, 0x308, 0x401 },
    { 0x36954, 0x416, 0x306, 0x4C1 },
    { 0x36956, 0x416, 0x308, 0x4DC },
    { 0x36A2B, 0x417, 0x308, 0x4DE },
    { 0x36AF8, 0x418, 0x300, 0x40D },
    { 0x36AFC, 0x418, 0x304, 0x4E2 },
    { 0x36AFE, 0x418, 0x306, 0x419 },
    { 0x36B00, 0x418, 0x308, 0x4E4 },
    { 0x36CA3, 0x41A, 0x301, 0x40C },
    { 0x36FFE, 0x41E, 0x308, 0x4E6 },
    { 0x37423, 0x423, 0x304, 0x4EE },
    { 0x37425, 0x423, 0x306, 0x40E },
    { 0x37427, 0x423, 0x308, 0x4F0 },
    { 0x3742A, 0x423, 0x30B, 0x4F2 },
    { 0x3777B, 0x427, 0x308, 0x4F4 },
    { 0x37ACF, 0x42B, 0x308, 0x4F8 },
    { 0x37C79, 0x42D, 0x308, 0x4EC },
    { 0x37EF6, 0x430, 0x306, 0x4D1 },
    { 0x37EF8, 0x430, 0x308, 0x4D3 },
    { 0x38170, 0x433, 0x301, 0x453 },
    { 0x38319, 0x435, 0x300, 0x450 },
    { 0x3831F, 0x435, 0x306, 0x4D7 },
    { 0x38321, 0x435, 0x308, 0x451 },
    { 0x383F4, 0x436, 0x306, 0x4C2 },
    { 0x383F6, 0x436, 0x308, 0x4DD },
    { 0x384CB, 0x437, 0x308, 0x4DF },
    { 0x38598, 0x438, 0x300, 0x45D },
    { 0x3859C, 0x438, 0x304, 0x4E3 },
    { 0x3859E, 0x438, 0x306, 0x439 },
    { 0x385A0, 0x438, 0x308, 0x4E5 },
    { 0x38743, 0x43A, 0x301, 0x45C },
    { 0x38A9E, 0x43E, 0x308, 0x4E7 },
    { 0x38EC3, 0x443, 0x304, 0x4EF },
    { 0x38EC5, 0x443, 0x306, 0x45E },
    { 0x38EC7, 0x443, 0x308, 0x4F1 },
    { 0x38ECA, 0x443, 0x30B, 0x4F3 },
    { 0x3921B, 0x447, 0x308, 0x4F5 },
    { 0x3956F, 0x44B, 0x308, 0x4F9 },
    { 0x39719, 0x44D, 0x308, 0x4ED },
    { 0x39E96, 0x456, 0x308, 0x457 },
    { 0x3B793, 0x474, 0x30F, 0x476 },
    { 0x3B868, 0x475, 0x30F, 0x477 },
    { 0x40AC0, 0x4D8, 0x308, 0x4DA },
    { 0x40B95, 0x4D9, 0x308, 0x4DB },
    { 0x41810, 0x4E8, 0x308, 0x4EA },
    { 0x418E5, 0x4E9, 0x308, 0x4EB },
    { 0x524C6, 0x627, 0x653, 0x622 },
    { 0x524C7, 0x627, 0x654, 0x623 },
    { 0x524C8, 0x627, 0x655, 0x625 },
    { 0x5403C, 0x648, 0x654, 0x624 },
    { 0x541E6, 0x64A, 0x654, 0x626 },
    { 0x5A4E9, 0x6C1, 0x654, 0x6C2 },
    { 0x5B30E, 0x6D2, 0x654, 0x6D3 },
    { 0x5B58D, 0x6D5, 0x654, 0x6C0 },
    { 0x7A784, 0x928, 0x93C, 0x929 },
    { 0x7AE2C, 0x930, 0x93C, 0x931 },
    { 0x7B0AB, 0x933, 0x93C, 0x934 },
    { 0x82C51, 0x9C7, 0x9BE, 0x9CB },
    { 0x82C6A, 0x9C7, 0x9D7, 0x9CC },
    { 0x96D51, 0xB47, 0xB3E, 0xB4B },
    { 0x96D69, 0xB47, 0xB56, 0xB48 },
    { 0x96D6A, 0xB47, 0xB57, 0xB4C },
    { 0x9AC51, 0xB92, 0xBD7, 0xB94 },
    { 0x9D77C, 0xBC6, 0xBBE, 0xBCA },
    { 0x9D795, 0xBC6, 0xBD7, 0xBCC },
    { 0x9D851, 0xBC7, 0xBBE, 0xBCB },
    { 0xA4294, 0xC46, 0xC56, 0xC48 },
    { 0xAA7C0, 0xCBF, 0xCD5, 0xCC0 },
    { 0xAAD80, 0xCC6, 0xCC2, 0xCCA },
    { 0xAAD93, 0xCC6, 0xCD5, 0xCC7 },
    { 0xAAD94, 0xCC6, 0xCD6, 0xCC8 },
    { 0xAB0E7, 0xCCA, 0xCD5, 0xCCB },
    { 0xB187C, 0xD46, 0xD3E, 0xD4A },
    { 0xB1895, 0xD46, 0xD57, 0xD4C },
    { 0xB1951, 0xD47, 0xD3E, 0xD4B },
    { 0xB9357, 0xDD9, 0xDCA, 0xDDA },
    { 0xB935C, 0xDD9, 0xDCF, 0xDDC },
    { 0xB936C, 0xDD9, 0xDDF, 0xDDE },
    { 0xB95D6, 0xDDC, 0xDCA, 0xDDD },
    { 0xD7EF7, 0x1025, 0x102E, 0x1026 },
    { 0x16965E, 0x1B05, 0x1B35, 0x1B06 },
    { 0x169808, 0x1B07, 0x1B35, 0x1B08 },
    { 0x1699B2, 0x1B09, 0x1B35, 0x1B0A },
    { 0x169B5C, 0x1B0B, 0x1B35, 0x1B0C },
    { 0x169D06, 0x1B0D, 0x1B35, 0x1B0E },
    { 0x16A05A, 0x1B11, 0x1B35, 0x1B12 },
    { 0x16C277, 0x1B3A, 0x1B35, 0x1B3B },
    { 0x16C421, 0x1B3C, 0x1B35, 0x1B3D },
    { 0x16C5CB, 0x1B3E, 0x1B35, 0x1B40 },
    { 0x16C6A0, 0x1B3F, 0x1B35, 0x1B41 },
    { 0x16C91F, 0x1B42, 0x1B35, 0x1B43 },
    { 0x1925F2, 0x1E36, 0x304, 0x1E38 },
    { 0x1926C7, 0x1E37, 0x304, 0x1E39 },
    { 0x1943E6, 0x1E5A, 0x304, 0x1E5C },
    { 0x1944BB, 0x1E5B, 0x304, 0x1E5D },
    { 0x194A91, 0x1E62, 0x307, 0x1E68 },
    { 0x194B66, 0x1E63, 0x307, 0x1E69 },
    { 0x197E22, 0x1EA0, 0x302, 0x1EAC },
    { 0x197E26, 0x1EA0, 0x306, 0x1EB6 },
    { 0x197EF7, 0x1EA1, 0x302, 0x1EAD },
    { 0x197EFB, 0x1EA1, 0x306, 0x1EB7 },
    { 0x19921A, 0x1EB8, 0x302, 0x1EC6 },
    { 0x1992EF, 0x1EB9, 0x302, 0x1EC7 },
    { 0x19A2BE, 0x1ECC, 0x302, 0x1ED8 },
    { 0x19A393, 0x1ECD, 0x302, 0x1ED9 },
    { 0x19CE00, 0x1F00, 0x300, 0x1F02 },
    { 0x19CE01, 0x1F00, 0x301, 0x1F04 },
    { 0x19CE42, 0x1F00, 0x342, 0x1F06 },
    { 0x19CE45, 0x1F00, 0x345, 0x1F80 },
    { 0x19CED5, 0x1F01, 0x300, 0x1F03 },
    { 0x19CED6, 0x1F01, 0x301, 0x1F05 },
    { 0x19CF17, 0x1F01, 0x342, 0x1F07 },
    { 0x19CF1A, 0x1F01, 0x345, 0x1F81 },
    { 0x19CFEF, 0x1F02, 0x345, 0x1F82 },
    { 0x19D0C4, 0x1F03, 0x345, 0x1F83 },
    { 0x19D199, 0x1F04, 0x345, 0x1F84 },
    { 0x19D26E, 0x1F05, 0x345, 0x1F85 },
    { 0x19D343, 0x1F06, 0x345, 0x1F86 },
    { 0x19D418, 0x1F07, 0x345, 0x1F87 },
    { 0x19D4A8, 0x1F08, 0x300, 0x1F0A },
    { 0x19D4A9, 0x1F08, 0x301, 0x1F0C },
    { 0x19D4EA, 0x1F08, 0x342, 0x1F0E },
    { 0x19D4ED, 0x1F08, 0x345, 0x1F88 },
    { 0x19D57D, 0x1F09, 0x300, 0x1F0B },
    { 0x19D57E, 0x1F09, 0x301, 0x1F0D },
    { 0x19D5BF, 0x1F09, 0x342, 0x1F0F },
    { 0x19D5C2, 0x1F09, 0x345, 0x1F89 },
    { 0x19D697, 0x1F0A, 0x345, 0x1F8A },
    { 0x19D76C, 0x1F0B, 0x345, 0x1F8B },
    { 0x19D841, 0x1F0C, 0x345, 0x1F8C },
    { 0x19D916, 0x1F0D, 0x345, 0x1F8D },
    { 0x19D9EB, 0x1F0E, 0x345, 0x1F8E },
    { 0x19DAC0, 0x1F0F, 0x345, 0x1F8F },
    { 0x19DB50, 0x1F10, 0x300, 0x1F12 },
    { 0x19DB51, 0x1F10, 0x301, 0x1F14 },
    { 0x19DC25, 0x1F11, 0x300, 0x1F13 },
    { 0x19DC26, 0x1F11, 0x301, 0x1F15 },
    { 0x19E1F8, 0x1F18, 0x300, 0x1F1A },
    { 0x19E1F9, 0x1F18, 0x301, 0x1F1C },
    { 0x19E2CD, 0x1F19, 0x300, 0x1F1B },
    { 0x19E2CE, 0x1F19, 0x301, 0x1F1D },
    { 0x19E8A0, 0x1F20, 0x300, 0x1F22 },
    { 0x19E8A1, 0x1F20, 0x301, 0x1F24 },
    { 0x19E8E2, 0x1F20, 0x342, 0x1F26 },
    { 0x19E8E5, 0x1F20, 0x345, 0x1F90 },
    { 0x19E975, 0x1F21, 0x300, 0x1F23 },
    { 0x19E976, 0x1F21, 0x301, 0x1F25 },
    { 0x19E9B7, 0x1F21, 0x342, 0x1F27 },
    { 0x19E9BA, 0x1F21, 0x345, 0x1F91 },
    { 0x19EA8F, 0x1F22, 0x345, 0x1F92 },
    { 0x19EB64, 0x1F23, 0x345, 0x1F93 },
    { 0x19EC39, 0x1F24, 0x345, 0x1F94 },
    { 0x19ED0E, 0x1F25, 0x345, 0x1F95 },
    { 0x19EDE3, 0x1F26, 0x345, 0x1F96 },
    { 0x19EEB8, 0x1F27, 0x345, 0x1F97 },
    { 0x19EF48, 0x1F28, 0x300, 0x1F2A },
    { 0x19EF49, 0x1F28, 0x301, 0x1F2C },
    { 0x19EF8A, 0x1F28, 0x342, 0x1F2E },
    { 0x19EF8D, 0x1F28, 0x345, 0x1F98 },
    { 0x19F01D, 0x1F29, 0x300, 0x1F2B },
    { 0x19F01E, 0x1F29, 0x301, 0x1F2D },
    { 0x19F05F, 0x1F29, 0x342, 0x1F2F },
    { 0x19F062, 0x1F29, 0x345, 0x1F99 },
    { 0x19F137, 0x1F2A, 0x345, 0x1F9A },
    { 0x19F20C, 0x1F2B, 0x345, 0x1F9B },
    { 0x19F2E1, 0x1F2C, 0x345, 0x1F9C },
    { 0x19F3B6, 0x1F2D, 0x345, 0x1F9D },
    { 0x19F48B, 0x1F2E, 0x345, 0x1F9E },
    { 0x19F560, 0x1F2F, 0x345, 0x1F9F },
    { 0x19F5F0, 0x1F30, 0x300, 0x1F32 },
    { 0x19F5F1, 0x1F30, 0x301, 0x1F34 },
    { 0x19F632, 0x1F30, 0x342, 0x1F36 },
    { 0x19F6C5, 0x1F31, 0x300, 0x1F33 },
    { 0x19F6C6, 0x1F31, 0x301, 0x1F35 },
    { 0x19F707, 0x1F31, 0x342, 0x1F37 },
    { 0x19FC98, 0x1F38, 0x300, 0x1F3A },
    { 0x19FC99, 0x1F38, 0x301, 0x1F3C },
    { 0x19FCDA, 0x1F38, 0x342, 0x1F3E },
    { 0x19FD6D, 0x1F39, 0x300, 0x1F3B },
    { 0x19FD6E, 0x1F39, 0x301, 0x1F3D },
    { 0x19FDAF, 0x1F39, 0x342, 0x1F3F },
    { 0x1A0340, 0x1F40, 0x300, 0x1F42 },
    { 0x1A0341, 0x1F40, 0x301, 0x1F44 },
    { 0x1A0415, 0x1F41, 0x300, 0x1F43 },
    { 0x1A0416, 0x1F41, 0x301, 0x1F45 },
    { 0x1A09E8, 0x1F48, 0x300, 0x1F4A },
    { 0x1A09E9, 0x1F48, 0x301, 0x1F4C },
    { 0x1A0ABD, 0x1F49, 0x300, 0x1F4B },
    { 0x1A0ABE, 0x1F49, 0x301, 0x1F4D },
    { 0x1A1090, 0x1F50, 0x300, 0x1F52 },
    { 0x1A1091, 0x1F50, 0x301, 0x1F54 },
    { 0x1A10D2, 0x1F50, 0x342, 0x1F56 },
    { 0x1A1165, 0x1F51, 0x300, 0x1F53 },
    { 0x1A1166, 0x1F51, 0x301, 0x1F55 },
    { 0x1A11A7, 0x1F51, 0x342, 0x1F57 },
    { 0x1A180D, 0x1F59, 0x300, 0x1F5B },
    { 0x1A180E, 0x1F59, 0x301, 0x1F5D },
    { 0x1A184F, 0x1F59, 0x342, 0x1F5F },
    { 0x1A1DE0, 0x1F60, 0x300, 0x1F62 },
    { 0x1A1DE1, 0x1F60, 0x301, 0x1F64 },
    { 0x1A1E22, 0x1F60, 0x342, 0x1F66 },
    { 0x1A1E25, 0x1F60, 0x345, 0x1FA0 },
    { 0x1A1EB5, 0x1F61, 0x300, 0x1F63 },
    { 0x1A1EB6, 0x1F61, 0x301, 0x1F65 },
    { 0x1A1EF7, 0x1F61, 0x342, 0x1F67 },
    { 0x1A1EFA, 0x1F61, 0x345, 0x1FA1 },
    { 0x1A1FCF, 0x1F62, 0x345, 0x1FA2 },
    { 0x1A20A4, 0x1F63, 0x345, 0x1FA3 },
    { 0x1A2179, 0x1F64, 0x345, 0x1FA4 },
    { 0x1A224E, 0x1F65, 0x345, 0x1FA5 },
    { 0x1A2323, 0x1F66, 0x345, 0x1FA6 },
    { 0x1A23F8, 0x1F67, 0x345, 0x1FA7 },
    { 0x1A2488, 0x1F68, 0x300, 0x1F6A },
    { 0x1A2489, 0x1F68, 0x301, 0x1F6C },
    { 0x1A24CA, 0x1F68, 0x342, 0x1F6E },
    { 0x1A24CD, 0x1F68, 0x345, 0x1FA8 },
    { 0x1A255D, 0x1F69, 0x300, 0x1F6B },
    { 0x1A255E, 0x1F69, 0x301, 0x1F6D },
    { 0x1A259F, 0x1F69, 0x342, 0x1F6F },
    { 0x1A25A2, 0x1F69, 0x345, 0x1FA9 },
    { 0x1A2677, 0x1F6A, 0x345, 0x1FAA },
    { 0x1A274C, 0x1F6B, 0x345, 0x1FAB },
    { 0x1A2821, 0x1F6C, 0x345, 0x1FAC },
    { 0x1A28F6, 0x1F6D, 0x345, 0x1FAD },
    { 0x1A29CB, 0x1F6E, 0x345, 0x1FAE },
    { 0x1A2AA0, 0x1F6F, 0x345, 0x1FAF },
    { 0x1A2B75, 0x1F70, 0x345, 0x1FB2 },
    { 0x1A2EC9, 0x1F74, 0x345, 0x1FC2 },
    { 0x1A3571, 0x1F7C, 0x345, 0x1FF2 },
    { 0x1A65B3, 0x1FB6, 0x345, 0x1FB7 },
    { 0x1A6CEB, 0x1FBF, 0x300, 0x1FCD },
    { 0x1A6CEC, 0x1FBF, 0x301, 0x1FCE },
    { 0x1A6D2D, 0x1FBF, 0x342, 0x1FCF },
    { 0x1A7303, 0x1FC6, 0x345, 0x1FC7 },
    { 0x1A9AF3, 0x1FF6, 0x345, 0x1FF7 },
    { 0x1AA156, 0x1FFE, 0x300, 0x1FDD },
    { 0x1AA157, 0x1FFE, 0x301, 0x1FDE },
    { 0x1AA198, 0x1FFE, 0x342, 0x1FDF },
    { 0x1BF008, 0x2190, 0x338, 0x219A },
    { 0x1BF1B2, 0x2192, 0x338, 0x219B },
    { 0x1BF35C, 0x2194, 0x338, 0x21AE },
    { 0x1C2548, 0x21D0, 0x338, 0x21CD },
    { 0x1C26F2, 0x21D2, 0x338, 0x21CF },
    { 0x1C289C, 0x21D4, 0x338, 0x21CE },
    { 0x1C4FB7, 0x2203, 0x338, 0x2204 },
    { 0x1C53E0, 0x2208, 0x338, 0x2209 },
    { 0x1C565F, 0x220B, 0x338, 0x220C },
    { 0x1C6A57, 0x2223, 0x338, 0x2224 },
    { 0x1C6C01, 0x2225, 0x338, 0x2226 },
    { 0x1C7F24, 0x223C, 0x338, 0x2241 },
    { 0x1C84F7, 0x2243, 0x338, 0x2244 },
    { 0x1C86A1, 0x2245, 0x338, 0x2247 },
    { 0x1C8920, 0x2248, 0x338, 0x2249 },
    { 0x1C8D49, 0x224D, 0x338, 0x226D },
    { 0x1C9DED, 0x2261, 0x338, 0x2262 },
    { 0x1CA06C, 0x2264, 0x338, 0x2270 },
    { 0x1CA141, 0x2265, 0x338, 0x2271 },
    { 0x1CAC12, 0x2272, 0x338, 0x2274 },
    { 0x1CACE7, 0x2273, 0x338, 0x2275 },
    { 0x1CAF66, 0x2276, 0x338, 0x2278 },
    { 0x1CB03B, 0x2277, 0x338, 0x2279 },
    { 0x1CB2BA, 0x227A, 0x338, 0x2280 },
    { 0x1CB38F, 0x227B, 0x338, 0x2281 },
    { 0x1CB464, 0x227C, 0x338, 0x22E0 },
    { 0x1CB539, 0x227D, 0x338, 0x22E1 },
    { 0x1CB962, 0x2282, 0x338, 0x2284 },
    { 0x1CBA37, 0x2283, 0x338, 0x2285 },
    { 0x1CBCB6, 0x2286, 0x338, 0x2288 },
    { 0x1CBD8B, 0x2287, 0x338, 0x2289 },
    { 0x1CC5DD, 0x2291, 0x338, 0x22E2 },
    { 0x1CC6B2, 0x2292, 0x338, 0x22E3 },
    { 0x1CD402, 0x22A2, 0x338, 0x22AC },
    { 0x1CD900, 0x22A8, 0x338, 0x22AD },
    { 0x1CD9D5, 0x22A9, 0x338, 0x22AE },
    { 0x1CDB7F, 0x22AB, 0x338, 0x22AF },
    { 0x1CE152, 0x22B2, 0x338, 0x22EA },
    { 0x1CE227, 0x22B3, 0x338, 0x22EB },
    { 0x1CE2FC, 0x22B4, 0x338, 0x22EC },
    { 0x1CE3D1, 0x22B5, 0x338, 0x22ED },
    { 0x285AD7, 0x3046, 0x3099, 0x3094 },
    { 0x285F00, 0x304B, 0x3099, 0x304C },
    { 0x2860AA, 0x304D, 0x3099, 0x304E },
    { 0x286254, 0x304F, 0x3099, 0x3050 },
    { 0x2863FE, 0x3051, 0x3099, 0x3052 },
    { 0x2865A8, 0x3053, 0x3099, 0x3054 },
    { 0x286752, 0x3055, 0x3099, 0x3056 },
    { 0x2868FC, 0x3057, 0x3099, 0x3058 },
    { 0x286AA6, 0x3059, 0x3099, 0x305A },
    { 0x286C50, 0x305B, 0x3099, 0x305C },
    { 0x286DFA, 0x305D, 0x3099, 0x305E },
    { 0x286FA4, 0x305F, 0x3099, 0x3060 },
    { 0x28714E, 0x3061, 0x3099, 0x3062 },
    { 0x2873CD, 0x3064, 0x3099, 0x3065 },
    { 0x287577, 0x3066, 0x3099, 0x3067 },
    { 0x287721, 0x3068, 0x3099, 0x3069 },
    { 0x287CF4, 0x306F, 0x3099, 0x3070 },
    { 0x287CF5, 0x306F, 0x309A, 0x3071 },
    { 0x287F73, 0x3072, 0x3099, 0x3073 },
    { 0x287F74, 0x3072, 0x309A, 0x3074 },
    { 0x2881F2, 0x3075, 0x3099, 0x3076 },
    { 0x2881F3, 0x3075, 0x309A, 0x3077 },
    { 0x288471, 0x3078, 0x3099, 0x3079 },
    { 0x288472, 0x3078, 0x309A, 0x307A },
    { 0x2886F0, 0x307B, 0x3099, 0x307C },
    { 0x2886F1, 0x307B, 0x309A, 0x307D },
    { 0x28A33A, 0x309D, 0x3099, 0x309E },
    { 0x28AAB7, 0x30A6, 0x3099, 0x30F4 },
    { 0x28AEE0, 0x30AB, 0x3099, 0x30AC },
    { 0x28B08A, 0x30AD, 0x3099, 0x30AE },
    { 0x28B234, 0x30AF, 0x3099, 0x30B0 },
    { 0x28B3DE, 0x30B1, 0x3099, 0x30B2 },
    { 0x28B588, 0x30B3, 0x3099, 0x30B4 },
    { 0x28B732, 0x30B5, 0x3099, 0x30B6 },
    { 0x28B8DC, 0x30B7, 0x3099, 0x30B8 },
    { 0x28BA86, 0x30B9, 0x3099, 0x30BA },
    { 0x28BC30, 0x30BB, 0x3099, 0x30BC },
    { 0x28BDDA, 0x30BD, 0x3099, 0x30BE },
    { 0x28BF84, 0x30BF, 0x3099, 0x30C0 },
    { 0x28C12E, 0x30C1, 0x3099, 0x30C2 },
    { 0x28C3AD, 0x30C4, 0x3099, 0x30C5 },
    { 0x28C557, 0x30C6, 0x3099, 0x30C7 },
    { 0x28C701, 0x30C8, 0x3099, 0x30C9 },
    { 0x28CCD4, 0x30CF, 0x3099, 0x30D0 },
    { 0x28CCD5, 0x30CF, 0x309A, 0x30D1 },
    { 0x28CF53, 0x30D2, 0x3099, 0x30D3 },
    { 0x28CF54, 0x30D2, 0x309A, 0x30D4 },
    { 0x28D1D2, 0x30D5, 0x3099, 0x30D6 },
    { 0x28D1D3, 0x30D5, 0x309A, 0x30D7 },
    { 0x28D451, 0x30D8, 0x3099, 0x30D9 },
    { 0x28D452, 0x30D8, 0x309A, 0x30DA },
    { 0x28D6D0, 0x30DB, 0x3099, 0x30DC },
    { 0x28D6D1, 0x30DB, 0x309A, 0x30DD },
    { 0x28E774, 0x30EF, 0x3099, 0x30F7 },
    { 0x28E849, 0x30F0, 0x3099, 0x30F8 },
    { 0x28E91E, 0x30F1, 0x3099, 0x30F9 },
    { 0x28E9F3, 0x30F2, 0x3099, 0x30FA },
    { 0x28F31A, 0x30FD, 0x3099, 0x30FE },
    { 0xE3E007, 0x11099, 0x110BA, 0x1109A },
    { 0xE3E1B1, 0x1109B, 0x110BA, 0x1109C },
    { 0xE3EA03, 0x110A5, 0x110BA, 0x110AB },
    { 0xE45EEC, 0x11131, 0x11127, 0x1112E },
    { 0xE45FC1, 0x11132, 0x11127, 0x1112F },
    { 0xE61D51, 0x11347, 0x1133E, 0x1134B },
    { 0xE61D6A, 0x11347, 0x11357, 0x1134C },
    { 0xE7529D, 0x114B9, 0x114B0, 0x114BC },
    { 0xE752A7, 0x114B9, 0x114BA, 0x114BB },
    { 0xE752AA, 0x114B9, 0x114BD, 0x114BE },
    { 0xE827C7, 0x115B8, 0x115AF, 0x115BA },
    { 0xE8289C, 0x115B9, 0x115AF, 0x115BB },
    { 0xEB1249, 0x11935, 0x11930, 0x11938 },
};

static struct decompose_table nfc_decompose_table[] = {
    { 0xC0, 0x41, 0x300, 230 },
    { 0xC1, 0x41, 0x301, 230 },
    { 0xC2, 0x41, 0x302, 230 },
    { 0xC3, 0x41, 0x303, 230 },
    { 0xC4, 0x41, 0x308, 230 },
    { 0xC5, 0x41, 0x30A, 230 },
    { 0xC7, 0x43, 0x327, 202 },
    { 0xC8, 0x45, 0x300, 230 },
    { 0xC9, 0x45, 0x301, 230 },
    { 0xCA, 0x45, 0x302, 230 },
    { 0xCB, 0x45, 0x308, 230 },
    { 0xCC, 0x49, 0x300, 230 },
    { 0xCD, 0x49, 0x301, 230 },
    { 0xCE, 0x49, 0x302, 230 },
    { 0xCF, 0x49, 0x308, 230 },
    { 0xD1, 0x4E, 0x303, 230 },
    { 0xD2, 0x4F, 0x300, 230 },
    { 0xD3, 0x4F, 0x301, 230 },
    { 0xD4, 0x4F, 0x302, 230 },
    { 0xD5, 0x4F, 0x303, 230 },
    { 0xD6, 0x4F, 0x308, 230 },
    { 0xD9, 0x55, 0x300, 230 },
    { 0xDA, 0x55, 0x301, 230 },
    { 0xDB, 0x55, 0x302, 230 },
    { 0xDC, 0x55, 0x308, 230 },
    { 0xDD, 0x59, 0x301, 230 },
    { 0xE0, 0x61, 0x300, 230 },
    { 0xE1, 0x61, 0x301, 230 },
    { 0xE2, 0x61, 0x302, 230 },
    { 0xE3, 0x61, 0x303, 230 },
    { 0xE4, 0x61, 0x308, 230 },
    { 0xE5, 0x61, 0x30A, 230 },
    { 0xE7, 0x63, 0x327, 202 },
    { 0xE8, 0x65, 0x300, 230 },
    { 0xE9, 0x65, 0x301, 230 },
    { 0xEA, 0x65, 0x302, 230 },
    { 0xEB, 0x65, 0x308, 230 },
    { 0xEC, 0x69, 0x300, 230 },
    { 0xED, 0x69, 0x301, 230 },
    { 0xEE, 0x69, 0x302, 230 },
    { 0xEF, 0x69, 0x308, 230 },
    { 0xF1, 0x6E, 0x303, 230 },
    { 0xF2, 0x6F, 0x300, 230 },
    { 0xF3, 0x6F, 0x301, 230 },
    { 0xF4, 0x6F, 0x302, 230 },
    { 0xF5, 0x6F, 0x303, 230 },
    { 0xF6, 0x6F, 0x308, 230 },
    { 0xF9, 0x75, 0x300, 230 },
    { 0xFA, 0x75, 0x301, 230 },
    { 0xFB, 0x75, 0x302, 230 },
    { 0xFC, 0x75, 0x308, 230 },
    { 0xFD, 0x79, 0x301, 230 },
    { 0xFF, 0x79, 0x308, 230 },
    { 0x100, 0x41, 0x304, 230 },
    { 0x101, 0x61, 0x304, 230 },
    { 0x102, 0x41, 0x306, 230 },
    { 0x103, 0x61, 0x306, 230 },
    { 0x104, 0x41, 0x328, 202 },
    { 0x105, 0x61, 0x328, 202 },
    { 0x106, 0x43, 0x301, 230 },
    { 0x107, 0x63, 0x301, 230 },
    { 0x108, 0x43, 0x302, 230 },
    { 0x109, 0x63, 0x302, 230 },
    { 0x10A, 0x43, 0x307, 230 },
    { 0x10B, 0x63, 0x307, 230 },
    { 0x10C, 0x43, 0x30C, 230 },
    { 0x10D, 0x63, 0x30C, 230 },
    { 0x10E, 0x44, 0x30C, 230 },
    { 0x10F, 0x64, 0x30C, 230 },
    { 0x112, 0x45, 0x304, 230 },
    { 0x113, 0x65, 0x304, 230 },
    { 0x114, 0x45, 0x306, 230 },
    { 0x115, 0x65, 0x306, 230 },
    { 0x116, 0x45, 0x307, 230 },
    { 0x117, 0x65, 0x307, 230 },
    { 0x118, 0x45, 0x328, 202 },
    { 0x119, 0x65, 0x328, 202 },
    { 0x11A, 0x45, 0x30C, 230 },
    { 0x11B, 0x65, 0x30C, 230 },
    { 0x11C, 0x47, 0x302, 230 },
    { 0x11D, 0x67, 0x302, 230 },
    { 0x11E, 0x47, 0x306, 230 },
    { 0x11F, 0x67, 0x306, 230 },
    { 0x120, 0x47, 0x307, 230 },
    { 0x121, 0x67, 0x307, 230 },
    { 0x122, 0x47, 0x327, 202 },
    { 0x123, 0x67, 0x327, 202 },
    { 0x124, 0x48, 0x302, 230 },
    { 0x125, 0x68, 0x302, 230 },
    { 0x128, 0x49, 0x303, 230 },
    { 0x129, 0x69, 0x303, 230 },
    { 0x12A, 0x49, 0x304, 230 },
    { 0x12B, 0x69, 0x304, 230 },
    { 0x12C, 0x49, 0x306, 230 },
    { 0x12D, 0x69, 0x306, 230 },
    { 0x12E, 0x49, 0x328, 202 },
    { 0x12F, 0x69, 0x328, 202 },
    { 0x130, 0x49, 0x307, 230 },
    { 0x134, 0x4A, 0x302, 230 },
    { 0x135, 0x6A, 0x302, 230 },
    { 0x136, 0x4B, 0x327, 202 },
    { 0x137, 0x6B, 0x327, 202 },
    { 0x139, 0x4C, 0x301, 230 },
    { 0x13A, 0x6C, 0x301, 230 },
    { 0x13B, 0x4C, 0x327, 202 },
    { 0x13C, 0x6C, 0x327, 202 },
    { 0x13D, 0x4C, 0x30C, 230 },
    { 0x13E, 0x6C, 0x30C, 230 },
    { 0x143, 0x4E, 0x301, 230 },
    { 0x144, 0x6E, 0x301, 230 },
    { 0x145, 0x4E, 0x327, 202 },
    { 0x146, 0x6E, 0x327, 202 },
    { 0x147, 0x4E, 0x30C, 230 },
    { 0x148, 0x6E, 0x30C, 230 },
    { 0x14C, 0x4F, 0x304, 230 },
    { 0x14D, 0x6F, 0x304, 230 },
    { 0x14E, 0x4F, 0x306, 230 },
    { 0x14F, 0x6F, 0x306, 230 },
    { 0x150, 0x4F, 0x30B, 230 },
    { 0x151, 0x6F, 0x30B, 230 },
    { 0x154, 0x52, 0x301, 230 },
    { 0x155, 0x72, 0x301, 230 },
    { 0x156, 0x52, 0x327, 202 },
    { 0x157, 0x72, 0x327, 202 },
    { 0x158, 0x52, 0x30C, 230 },
    { 0x159, 0x72, 0x30C, 230 },
    { 0x15A, 0x53, 0x301, 230 },
    { 0x15B, 0x73, 0x301, 230 },
    { 0x15C, 0x53, 0x302, 230 },
    { 0x15D, 0x73, 0x302, 230 },
    { 0x15E, 0x53, 0x327, 202 },
    { 0x15F, 0x73, 0x327, 202 },
    { 0x160, 0x53, 0x30C, 230 },
    { 0x161, 0x73, 0x30C, 230 },
    { 0x162, 0x54, 0x327, 202 },
    { 0x163, 0x74, 0x327, 202 },
    { 0x164, 0x54, 0x30C, 230 },
    { 0x165, 0x74, 0x30C, 230 },
    { 0x168, 0x55, 0x303, 230 },
    { 0x169, 0x75, 0x303, 230 },
    { 0x16A, 0x55, 0x304, 230 },
    { 0x16B, 0x75, 0x304, 230 },
    { 0x16C, 0x55, 0x306, 230 },
    { 0x16D, 0x75, 0x306, 230 },
    { 0x16E, 0x55, 0x30A, 230 },
    { 0x16F, 0x75, 0x30A, 230 },
    { 0x170, 0x55, 0x30B, 230 },
    { 0x171, 0x75, 0x30B, 230 },
    { 0x172, 0x55, 0x328, 202 },
    { 0x173, 0x75, 0x328, 202 },
    { 0x174, 0x57, 0x302, 230 },
    { 0x175, 0x77, 0x302, 230 },
    { 0x176, 0x59, 0x302, 230 },
    { 0x177, 0x79, 0x302, 230 },
    { 0x178, 0x59, 0x308, 230 },
    { 0x179, 0x5A, 0x301, 230 },
    { 0x17A, 0x7A, 0x301, 230 },
    { 0x17B, 0x5A, 0x307, 230 },
    { 0x17C, 0x7A, 0x307, 230 },
    { 0x17D, 0x5A, 0x30C, 230 },
    { 0x17E, 0x7A, 0x30C, 230 },
    { 0x1A0, 0x4F, 0x31B, 216 },
    { 0x1A1, 0x6F, 0x31B, 216 },
    { 0x1AF, 0x55, 0x31B, 216 },
    { 0x1B0, 0x75, 0x31B, 216 },
    { 0x1CD, 0x41, 0x30C, 230 },
    { 0x1CE, 0x61, 0x30C, 230 },
    { 0x1CF, 0x49, 0x30C, 230 },
    { 0x1D0, 0x69, 0x30C, 230 },
    { 0x1D1, 0x4F, 0x30C, 230 },
    { 0x1D2, 0x6F, 0x30C, 230 },
    { 0x1D3, 0x55, 0x30C, 230 },
    { 0x1D4, 0x75, 0x30C, 230 },
    { 0x1D5, 0xDC, 0x304, 230 },
    { 0x1D6, 0xFC, 0x304, 230 },
    { 0x1D7, 0xDC, 0x301, 230 },
    { 0x1D8, 0xFC, 0x301, 230 },
    { 0x1D9, 0xDC, 0x30C, 230 },
    { 0x1DA, 0xFC, 0x30C, 230 },
    { 0x1DB, 0xDC, 0x300, 230 },
    { 0x1DC, 0xFC, 0x300, 230 },
    { 0x1DE, 0xC4, 0x304, 230 },
    { 0x1DF, 0xE4, 0x304, 230 },
    { 0x1E0, 0x226, 0x304, 230 },
    { 0x1E1, 0x227, 0x304, 230 },
    { 0x1E2, 0xC6, 0x304, 230 },
    { 0x1E3, 0xE6, 0x304, 230 },
    { 0x1E6, 0x47, 0x30C, 230 },
    { 0x1E7, 0x67, 0x30C, 230 },
    { 0x1E8, 0x4B, 0x30C, 230 },
    { 0x1E9, 0x6B, 0x30C, 230 },
    { 0x1EA, 0x4F, 0x328, 202 },
    { 0x1EB, 0x6F, 0x328, 202 },
    { 0x1EC, 0x1EA, 0x304, 230 },
    { 0x1ED, 0x1EB, 0x304, 230 },
    { 0x1EE, 0x1B7, 0x30C, 230 },
    { 0x1EF, 0x292, 0x30C, 230 },
    { 0x1F0, 0x6A, 0x30C, 230 },
    { 0x1F4, 0x47, 0x301, 230 },
    { 0x1F5, 0x67, 0x301, 230 },
    { 0x1F8, 0x4E, 0x300, 230 },
    { 0x1F9, 0x6E, 0x300, 230 },
    { 0x1FA, 0xC5, 0x301, 230 },
    { 0x1FB, 0xE5, 0x301, 230 },
    { 0x1FC, 0xC6, 0x301, 230 },
    { 0x1FD, 0xE6, 0x301, 230 },
    { 0x1FE, 0xD8, 0x301, 230 },
    { 0x1FF, 0xF8, 0x301, 230 },
    { 0x200, 0x41, 0x30F, 230 },
    { 0x201, 0x61, 0x30F, 230 },
    { 0x202, 0x41, 0x311, 230 },
    { 0x203, 0x61, 0x311, 230 },
    { 0x204, 0x45, 0x30F, 230 },
    { 0x205, 0x65, 0x30F, 230 },
    { 0x206, 0x45, 0x311, 230 },
    { 0x207, 0x65, 0x311, 230 },
    { 0x208, 0x49, 0x30F, 230 },
    { 0x209, 0x69, 0x30F, 230 },
    { 0x20A, 0x49, 0x311, 230 },
    { 0x20B, 0x69, 0x311, 230 },
    { 0x20C, 0x4F, 0x30F, 230 },
    { 0x20D, 0x6F, 0x30F, 230 },
    { 0x20E, 0x4F, 0x311, 230 },
    { 0x20F, 0x6F, 0x311, 230 },
    { 0x210, 0x52, 0x30F, 230 },
    { 0x211, 0x72, 0x30F, 230 },
    { 0x212, 0x52, 0x311, 230 },
    { 0x213, 0x72, 0x311, 230 },
    { 0x214, 0x55, 0x30F, 230 },
    { 0x215, 0x75, 0x30F, 230 },
    { 0x216, 0x55, 0x311, 230 },
    { 0x217, 0x75, 0x311, 230 },
    { 0x218, 0x53, 0x326, 220 },
    { 0x219, 0x73, 0x326, 220 },
    { 0x21A, 0x54, 0x326, 220 },
    { 0x21B, 0x74, 0x326, 220 },
    { 0x21E, 0x48, 0x30C, 230 },
    { 0x21F, 0x68, 0x30C, 230 },
    { 0x226, 0x41, 0x307, 230 },
    { 0x227, 0x61, 0x307, 230 },
    { 0x228, 0x45, 0x327, 202 },
    { 0x229, 0x65, 0x327, 202 },
    { 0x22A, 0xD6, 0x304, 230 },
    { 0x22B, 0xF6, 0x304, 230 },
    { 0x22C, 0xD5, 0x304, 230 },
    { 0x22D, 0xF5, 0x304, 230 },
    { 0x22E, 0x4F, 0x307, 230 },
    { 0x22F, 0x6F, 0x307, 230 },
    { 0x230, 0x22E, 0x304, 230 },
    { 0x231, 0x22F, 0x304, 230 },
    { 0x232, 0x59, 0x304, 230 },
    { 0x233, 0x79, 0x304, 230 },
    { 0x385, 0xA8, 0x301, 230 },
    { 0x386, 0x391, 0x301, 230 },
    { 0x388, 0x395, 0x301, 230 },
    { 0x389, 0x397, 0x301, 230 },
    { 0x38A, 0x399, 0x301, 230 },
    { 0x38C, 0x39F, 0x301, 230 },
    { 0x38E, 0x3A5, 0x301, 230 },
    { 0x38F, 0x3A9, 0x301, 230 },
    { 0x390, 0x3CA, 0x301, 230 },
    { 0x3AA, 0x399, 0x308, 230 },
    { 0x3AB, 0x3A5, 0x308, 230 },
    { 0x3AC, 0x3B1, 0x301, 230 },
    { 0x3AD, 0x3B5, 0x301, 230 },
    { 0x3AE, 0x3B7, 0x301, 230 },
    { 0x3AF, 0x3B9, 0x301, 230 },
    { 0x3B0, 0x3CB, 0x301, 230 },
    { 0x3CA, 0x3B9, 0x308, 230 },
    { 0x3CB, 0x3C5, 0x308, 230 },
    { 0x3CC, 0x3BF, 0x301, 230 },
    { 0x3CD, 0x3C5, 0x301, 230 },
    { 0x3CE, 0x3C9, 0x301, 230 },
    { 0x3D3, 0x3D2, 0x301, 230 },
    { 0x3D4, 0x3D2, 0x308, 230 },
    { 0x400, 0x415, 0x300, 230 },
    { 0x401, 0x415, 0x308, 230 },
    { 0x403, 0x413, 0x301, 230 },
    { 0x407, 0x406, 0x308, 230 },
    { 0x40C, 0x41A, 0x301, 230 },
    { 0x40D, 0x418, 0x300, 230 },
    { 0x40E, 0x423, 0x306, 230 },
    { 0x419, 0x418, 0x306, 230 },
    { 0x439, 0x438, 0x306, 230 },
    { 0x450, 0x435, 0x300, 230 },
    { 0x451, 0x435, 0x308, 230 },
    { 0x453, 0x433, 0x301, 230 },
    { 0x457, 0x456, 0x308, 230 },
    { 0x45C, 0x43A, 0x301, 230 },
    { 0x45D, 0x438, 0x300, 230 },
    { 0x45E, 0x443, 0x306, 230 },
    { 0x476, 0x474, 0x30F, 230 },
    { 0x477, 0x475, 0x30F, 230 },
    { 0x4C1, 0x416, 0x306, 230 },
    { 0x4C2, 0x436, 0x306, 230 },
    { 0x4D0, 0x410, 0x306, 230 },
    { 0x4D1, 0x430, 0x306, 230 },
    { 0x4D2, 0x410, 0x308, 230 },
    { 0x4D3, 0x430, 0x308, 230 },
    { 0x4D6, 0x415, 0x306, 230 },
    { 0x4D7, 0x435, 0x306, 230 },
    { 0x4DA, 0x4D8, 0x308, 230 },
    { 0x4DB, 0x4D9, 0x308, 230 },
    { 0x4DC, 0x416, 0x308, 230 },
    { 0x4DD, 0x436, 0x308, 230 },
    { 0x4DE, 0x417, 0x308, 230 },
    { 0x4DF, 0x437, 0x308, 230 },
    { 0x4E2, 0x418, 0x304, 230 },
    { 0x4E3, 0x438, 0x304, 230 },
    { 0x4E4, 0x418, 0x308, 230 },
    { 0x4E5, 0x438, 0x308, 230 },
    { 0x4E6, 0x41E, 0x308, 230 },
    { 0x4E7, 0x43E, 0x308, 230 },
    { 0x4EA, 0x4E8, 0x308, 230 },
    { 0x4EB, 0x4E9, 0x308, 230 },
    { 0x4EC, 0x42D, 0x308, 230 },
    { 0x4ED, 0x44D, 0x308, 230 },
    { 0x4EE, 0x423, 0x304, 230 },
    { 0x4EF, 0x443, 0x304, 230 },
    { 0x4F0, 0x423, 0x308, 230 },
    { 0x4F1, 0x443, 0x308, 230 },
    { 0x4F2, 0x423, 0x30B, 230 },
    { 0x4F3, 0x443, 0x30B, 230 },
    { 0x4F4, 0x427, 0x308, 230 },
    { 0x4F5, 0x447, 0x308, 230 },
    { 0x4F8, 0x42B, 0x308, 230 },
    { 0x4F9, 0x44B, 0x308, 230 },
    { 0x622, 0x627, 0x653, 230 },
    { 0x623, 0x627, 0x654, 230 },
    { 0x624, 0x648, 0x654, 230 },
    { 0x625, 0x627, 0x655, 220 },
    { 0x626, 0x64A, 0x654, 230 },
    { 0x6C0, 0x6D5, 0x654, 230 },
    { 0x6C2, 0x6C1, 0x654, 230 },
    { 0x6D3, 0x6D2, 0x654, 230 },
    { 0x929, 0x928, 0x93C, 7 },
    { 0x931, 0x930, 0x93C, 7 },
    { 0x934, 0x933, 0x93C, 7 },
    { 0x9CB, 0x9C7, 0x9BE, 0 },
    { 0x9CC, 0x9C7, 0x9D7, 0 },
    { 0xB48, 0xB47, 0xB56, 0 },
    { 0xB4B, 0xB47, 0xB3E, 0 },
    { 0xB4C, 0xB47, 0xB57, 0 },
    { 0xB94, 0xB92, 0xBD7, 0 },
    { 0xBCA, 0xBC6, 0xBBE, 0 },
    { 0xBCB, 0xBC7, 0xBBE, 0 },
    { 0xBCC, 0xBC6, 0xBD7, 0 },
    { 0xC48, 0xC46, 0xC56, 91 },
    { 0xCC0, 0xCBF, 0xCD5, 0 },
    { 0xCC7, 0xCC6, 0xCD5, 0 },
    { 0xCC8, 0xCC6, 0xCD6, 0 },
    { 0xCCA, 0xCC6, 0xCC2, 0 },
    { 0xCCB, 0xCCA, 0xCD5, 0 },
    { 0xD4A, 0xD46, 0xD3E, 0 },
    { 0xD4B, 0xD47, 0xD3E, 0 },
    { 0xD4C, 0xD46, 0xD57, 0 },
    { 0xDDA, 0xDD9, 0xDCA, 9 },
    { 0xDDC, 0xDD9, 0xDCF, 0 },
    { 0xDDD, 0xDDC, 0xDCA, 9 },
    { 0xDDE, 0xDD9, 0xDDF, 0 },
    { 0x1026, 0x1025, 0x102E, 0 },
    { 0x1B06, 0x1B05, 0x1B35, 0 },
    { 0x1B08, 0x1B07, 0x1B35, 0 },
    { 0x1B0A, 0x1B09, 0x1B35, 0 },
    { 0x1B0C, 0x1B0B, 0x1B35, 0 },
    { 0x1B0E, 0x1B0D, 0x1B35, 0 },
    { 0x1B12, 0x1B11, 0x1B35, 0 },
    { 0x1B3B, 0x1B3A, 0x1B35, 0 },
    { 0x1B3D, 0x1B3C, 0x1B35, 0 },
    { 0x1B40, 0x1B3E, 0x1B35, 0 },
    { 0x1B41, 0x1B3F, 0x1B35, 0 },
    { 0x1B43, 0x1B42, 0x1B35, 0 },
    { 0x1E00, 0x41, 0x325, 220 },
    { 0x1E01, 0x61, 0x325, 220 },
    { 0x1E02, 0x42, 0x307, 230 },
    { 0x1E03, 0x62, 0x307, 230 },
    { 0x1E04, 0x42, 0x323, 220 },
    { 0x1E05, 0x62, 0x323, 220 },
    { 0x1E06, 0x42, 0x331, 220 },
    { 0x1E07, 0x62, 0x331, 220 },
    { 0x1E08, 0xC7, 0x301, 230 },
    { 0x1E09, 0xE7, 0x301, 230 },
    { 0x1E0A, 0x44, 0x307, 230 },
    { 0x1E0B, 0x64, 0x307, 230 },
    { 0x1E0C, 0x44, 0x323, 220 },
    { 0x1E0D, 0x64, 0x323, 220 },
    { 0x1E0E, 0x44, 0x331, 220 },
    { 0x1E0F, 0x64, 0x331, 220 },
    { 0x1E10, 0x44, 0x327, 202 },
    { 0x1E11, 0x64, 0x327, 202 },
    { 0x1E12, 0x44, 0x32D, 220 },
    { 0x1E13, 0x64, 0x32D, 220 },
    { 0x1E14, 0x112, 0x300, 230 },
    { 0x1E15, 0x113, 0x300, 230 },
    { 0x1E16, 0x112, 0x301, 230 },
    { 0x1E17, 0x113, 0x301, 230 },
    { 0x1E18, 0x45, 0x32D, 220 },
    { 0x1E19, 0x65, 0x32D, 220 },
    { 0x1E1A, 0x45, 0x330, 220 },
    { 0x1E1B, 0x65, 0x330, 220 },
    { 0x1E1C, 0x228, 0x306, 230 },
    { 0x1E1D, 0x229, 0x306, 230 },
    { 0x1E1E, 0x46, 0x307, 230 },
    { 0x1E1F, 0x66, 0x307, 230 },
    { 0x1E20, 0x47, 0x304, 230 },
    { 0x1E21, 0x67, 0x304, 230 },
    { 0x1E22, 0x48, 0x307, 230 },
    { 0x1E23, 0x68, 0x307, 230 },
    { 0x1E24, 0x48, 0x323, 220 },
    { 0x1E25, 0x68, 0x323, 220 },
    { 0x1E26, 0x48, 0x308, 230 },
    { 0x1E27, 0x68, 0x308, 230 },
    { 0x1E28, 0x48, 0x327, 202 },
    { 0x1E29, 0x68, 0x327, 202 },
    { 0x1E2A, 0x48, 0x32E, 220 },
    { 0x1E2B, 0x68, 0x32E, 220 },
    { 0x1E2C, 0x49, 0x330, 220 },
    { 0x1E2D, 0x69, 0x330, 220 },
    { 0x1E2E, 0xCF, 0x301, 230 },
    { 0x1E2F, 0xEF, 0x301, 230 },
    { 0x1E30, 0x4B, 0x301, 230 },
    { 0x1E31, 0x6B, 0x301, 230 },
    { 0x1E32, 0x4B, 0x323, 220 },
    { 0x1E33, 0x6B, 0x323, 220 },
    { 0x1E34, 0x4B, 0x331, 220 },
    { 0x1E35, 0x6B, 0x331, 220 },
    { 0x1E36, 0x4C, 0x323, 220 },
    { 0x1E37, 0x6C, 0x323, 220 },
    { 0x1E38, 0x1E36, 0x304, 230 },
    { 0x1E39, 0x1E37, 0x304, 230 },
    { 0x1E3A, 0x4C, 0x331, 220 },
    { 0x1E3B, 0x6C, 0x331, 220 },
    { 0x1E3C, 0x4C, 0x32D, 220 },
    { 0x1E3D, 0x6C, 0x32D, 220 },
    { 0x1E3E, 0x4D, 0x301, 230 },
    { 0x1E3F, 0x6D, 0x301, 230 },
    { 0x1E40, 0x4D, 0x307, 230 },
    { 0x1E41, 0x6D, 0x307, 230 },
    { 0x1E42, 0x4D, 0x323, 220 },
    { 0x1E43, 0x6D, 0x323, 220 },
    { 0x1E44, 0x4E, 0x307, 230 },
    { 0x1E45, 0x6E, 0x307, 230 },
    { 0x1E46, 0x4E, 0x323, 220 },
    { 0x1E47, 0x6E, 0x323, 220 },
    { 0x1E48, 0x4E, 0x331, 220 },
    { 0x1E49, 0x6E, 0x331, 220 },
    { 0x1E4A, 0x4E, 0x32D, 220 },
    { 0x1E4B, 0x6E, 0x32D, 220 },
    { 0x1E4C, 0xD5, 0x301, 230 },
    { 0x1E4D, 0xF5, 0x301, 230 },
    { 0x1E4E, 0xD5, 0x308, 230 },
    { 0x1E4F, 0xF5, 0x308, 230 },
    { 0x1E50, 0x14C, 0x300, 230 },
    { 0x1E51, 0x14D, 0x300, 230 },
    { 0x1E52, 0x14C, 0x301, 230 },
    { 0x1E53, 0x14D, 0x301, 230 },
    { 0x1E54, 0x50, 0x301, 230 },
    { 0x1E55, 0x70, 0x301, 230 },
    { 0x1E56, 0x50, 0x307, 230 },
    { 0x1E57, 0x70, 0x307, 230 },
    { 0x1E58, 0x52, 0x307, 230 },
    { 0x1E59, 0x72, 0x307, 230 },
    { 0x1E5A, 0x52, 0x323, 220 },
    { 0x1E5B, 0x72, 0x323, 220 },
    { 0x1E5C, 0x1E5A, 0x304, 230 },
    { 0x1E5D, 0x1E5B, 0x304, 230 },
    { 0x1E5E, 0x52, 0x331, 220 },
    { 0x1E5F, 0x72, 0x331, 220 },
    { 0x1E60, 0x53, 0x307, 230 },
    { 0x1E61, 0x73, 0x307, 230 },
    { 0x1E62, 0x53, 0x323, 220 },
    { 0x1E63, 0x73, 0x323, 220 },
    { 0x1E64, 0x15A, 0x307, 230 },
    { 0x1E65, 0x15B, 0x307, 230 },
    { 0x1E66, 0x160, 0x307, 230 },
    { 0x1E67, 0x161, 0x307, 230 },
    { 0x1E68, 0x1E62, 0x307, 230 },
    { 0x1E69, 0x1E63, 0x307, 230 },
    { 0x1E6A, 0x54, 0x307, 230 },
    { 0x1E6B, 0x74, 0x307, 230 },
    { 0x1E6C, 0x54, 0x323, 220 },
    { 0x1E6D, 0x74, 0x323, 220 },
    { 0x1E6E, 0x54, 0x331, 220 },
    { 0x1E6F, 0x74, 0x331, 220 },
    { 0x1E70, 0x54, 0x32D, 220 },
    { 0x1E71, 0x74, 0x32D, 220 },
    { 0x1E72, 0x55, 0x324, 220 },
    { 0x1E73, 0x75, 0x324, 220 },
    { 0x1E74, 0x55, 0x330, 220 },
    { 0x1E75, 0x75, 0x330, 220 },
    { 0x1E76, 0x55, 0x32D, 220 },
    { 0x1E77, 0x75, 0x32D, 220 },
    { 0x1E78, 0x168, 0x301, 230 },
    { 0x1E79, 0x169, 0x301, 230 },
    { 0x1E7A, 0x16A, 0x308, 230 },
    { 0x1E7B, 0x16B, 0x308, 230 },
    { 0x1E7C, 0x56, 0x303, 230 },
    { 0x1E7D, 0x76, 0x303, 230 },
    { 0x1E7E, 0x56, 0x323, 220 },
    { 0x1E7F, 0x76, 0x323, 220 },
    { 0x1E80, 0x57, 0x300, 230 },
    { 0x1E81, 0x77, 0x300, 230 },
    { 0x1E82, 0x57, 0x301, 230 },
    { 0x1E83, 0x77, 0x301, 230 },
    { 0x1E84, 0x57, 0x308, 230 },
    { 0x1E85, 0x77, 0x308, 230 },
    { 0x1E86, 0x57, 0x307, 230 },
    { 0x1E87, 0x77, 0x307, 230 },
    { 0x1E88, 0x57, 0x323, 220 },
    { 0x1E89, 0x77, 0x323, 220 },
    { 0x1E8A, 0x58, 0x307, 230 },
    { 0x1E8B, 0x78, 0x307, 230 },
    { 0x1E8C, 0x58, 0x308, 230 },
    { 0x1E8D, 0x78, 0x308, 230 },
    { 0x1E8E, 0x59, 0x307, 230 },
    { 0x1E8F, 0x79, 0x307, 230 },
    { 0x1E90, 0x5A, 0x302, 230 },
    { 0x1E91, 0x7A, 0x302, 230 },
    { 0x1E92, 0x5A, 0x323, 220 },
    { 0x1E93, 0x7A, 0x323, 220 },
    { 0x1E94, 0x5A, 0x331, 220 },
    { 0x1E95, 0x7A, 0x331, 220 },
    { 0x1E96, 0x68, 0x331, 220 },
    { 0x1E97, 0x74, 0x308, 230 },
    { 0x1E98, 0x77, 0x30A, 230 },
    { 0x1E99, 0x79, 0x30A, 230 },
    { 0x1E9B, 0x17F, 0x307, 230 },
    { 0x1EA0, 0x41, 0x323, 220 },
    { 0x1EA1, 0x61, 0x323, 220 },
    { 0x1EA2, 0x41, 0x309, 230 },
    { 0x1EA3, 0x61, 0x309, 230 },
    { 0x1EA4, 0xC2, 0x301, 230 },
    { 0x1EA5, 0xE2, 0x301, 230 },
    { 0x1EA6, 0xC2, 0x300, 230 },
    { 0x1EA7, 0xE2, 0x300, 230 },
    { 0x1EA8, 0xC2, 0x309, 230 },
    { 0x1EA9, 0xE2, 0x309, 230 },
    { 0x1EAA, 0xC2, 0x303, 230 },
    { 0x1EAB, 0xE2, 0x303, 230 },
    { 0x1EAC, 0x1EA0, 0x302, 230 },
    { 0x1EAD, 0x1EA1, 0x302, 230 },
    { 0x1EAE, 0x102, 0x301, 230 },
    { 0x1EAF, 0x103, 0x301, 230 },
    { 0x1EB0, 0x102, 0x300, 230 },
    { 0x1EB1, 0x103, 0x300, 230 },
    { 0x1EB2, 0x102, 0x309, 230 },
    { 0x1EB3, 0x103, 0x309, 230 },
    { 0x1EB4, 0x102, 0x303, 230 },
    { 0x1EB5, 0x103, 0x303, 230 },
    { 0x1EB6, 0x1EA0, 0x306, 230 },
    { 0x1EB7, 0x1EA1, 0x306, 230 },
    { 0x1EB8, 0x45, 0x323, 220 },
    { 0x1EB9, 0x65, 0x323, 220 },
    { 0x1EBA, 0x45, 0x309, 230 },
    { 0x1EBB, 0x65, 0x309, 230 },
    { 0x1EBC, 0x45, 0x303, 230 },
    { 0x1EBD, 0x65, 0x303, 230 },
    { 0x1EBE, 0xCA, 0x301, 230 },
    { 0x1EBF, 0xEA, 0x301, 230 },
    { 0x1EC0, 0xCA, 0x300, 230 },
    { 0x1EC1, 0xEA, 0x300, 230 },
    { 0x1EC2, 0xCA, 0x309, 230 },
    { 0x1EC3, 0xEA, 0x309, 230 },
    { 0x1EC4, 0xCA, 0x303, 230 },
    { 0x1EC5, 0xEA, 0x303, 230 },
    { 0x1EC6, 0x1EB8, 0x302, 230 },
    { 0x1EC7, 0x1EB9, 0x302, 230 },
    { 0x1EC8, 0x49, 0x309, 230 },
    { 0x1EC9, 0x69, 0x309, 230 },
    { 0x1ECA, 0x49, 0x323, 220 },
    { 0x1ECB, 0x69, 0x323, 220 },
    { 0x1ECC, 0x4F, 0x323, 220 },
    { 0x1ECD, 0x6F, 0x323, 220 },
    { 0x1ECE, 0x4F, 0x309, 230 },
    { 0x1ECF, 0x6F, 0x309, 230 },
    { 0x1ED0, 0xD4, 0x301, 230 },
    { 0x1ED1, 0xF4, 0x301, 230 },
    { 0x1ED2, 0xD4, 0x300, 230 },
    { 0x1ED3, 0xF4, 0x300, 230 },
    { 0x1ED4, 0xD4, 0x309, 230 },
    { 0x1ED5, 0xF4, 0x309, 230 },
    { 0x1ED6, 0xD4, 0x303, 230 },
    { 0x1ED7, 0xF4, 0x303, 230 },
    { 0x1ED8, 0x1ECC, 0x302, 230 },
    { 0x1ED9, 0x1ECD, 0x302, 230 },
    { 0x1EDA, 0x1A0, 0x301, 230 },
    { 0x1EDB, 0x1A1, 0x301, 230 },
    { 0x1EDC, 0x1A0, 0x300, 230 },
    { 0x1EDD, 0x1A1, 0x300, 230 },
    { 0x1EDE, 0x1A0, 0x309, 230 },
    { 0x1EDF, 0x1A1, 0x309, 230 },
    { 0x1EE0, 0x1A0, 0x303, 230 },
    { 0x1EE1, 0x1A1, 0x303, 230 },
    { 0x1EE2, 0x1A0, 0x323, 220 },
    { 0x1EE3, 0x1A1, 0x323, 220 },
    { 0x1EE4, 0x55, 0x323, 220 },
    { 0x1EE5, 0x75, 0x323, 220 },
    { 0x1EE6, 0x55, 0x309, 230 },
    { 0x1EE7, 0x75, 0x309, 230 },
    { 0x1EE8, 0x1AF, 0x301, 230 },
    { 0x1EE9, 0x1B0, 0x301, 230 },
    { 0x1EEA, 0x1AF, 0x300, 230 },
    { 0x1EEB, 0x1B0, 0x300, 230 },
    { 0x1EEC, 0x1AF, 0x309, 230 },
    { 0x1EED, 0x1B0, 0x309, 230 },
    { 0x1EEE, 0x1AF, 0x303, 230 },
    { 0x1EEF, 0x1B0, 0x303, 230 },
    { 0x1EF0, 0x1AF, 0x323, 220 },
    { 0x1EF1, 0x1B0, 0x323, 220 },
    { 0x1EF2, 0x59, 0x300, 230 },
    { 0x1EF3, 0x79, 0x300, 230 },
    { 0x1EF4, 0x59, 0x323, 220 },
    { 0x1EF5, 0x79, 0x323, 220 },
    { 0x1EF6, 0x59, 0x309, 230 },
    { 0x1EF7, 0x79, 0x309, 230 },
    { 0x1EF8, 0x59, 0x303, 230 },
    { 0x1EF9, 0x79, 0x303, 230 },
    { 0x1F00, 0x3B1, 0x313, 230 },
    { 0x1F01, 0x3B1, 0x314, 230 },
    { 0x1F02, 0x1F00, 0x300, 230 },
    { 0x1F03, 0x1F01, 0x300, 230 },
    { 0x1F04, 0x1F00, 0x301, 230 },
    { 0x1F05, 0x1F01, 0x301, 230 },
    { 0x1F06, 0x1F00, 0x342, 230 },
    { 0x1F07, 0x1F01, 0x342, 230 },
    { 0x1F08, 0x391, 0x313, 230 },
    { 0x1F09, 0x391, 0x314, 230 },
    { 0x1F0A, 0x1F08, 0x300, 230 },
    { 0x1F0B, 0x1F09, 0x300, 230 },
    { 0x1F0C, 0x1F08, 0x301, 230 },
    { 0x1F0D, 0x1F09, 0x301, 230 },
    { 0x1F0E, 0x1F08, 0x342, 230 },
    { 0x1F0F, 0x1F09, 0x342, 230 },
    { 0x1F10, 0x3B5, 0x313, 230 },
    { 0x1F11, 0x3B5, 0x314, 230 },
    { 0x1F12, 0x1F10, 0x300, 230 },
    { 0x1F13, 0x1F11, 0x300, 230 },
    { 0x1F14, 0x1F10, 0x301, 230 },
    { 0x1F15, 0x1F11, 0x301, 230 },
    { 0x1F18, 0x395, 0x313, 230 },
    { 0x1F19, 0x395, 0x314, 230 },
    { 0x1F1A, 0x1F18, 0x300, 230 },
    { 0x1F1B, 0x1F19, 0x300, 230 },
    { 0x1F1C, 0x1F18, 0x301, 230 },
    { 0x1F1D, 0x1F19, 0x301, 230 },
    { 0x1F20, 0x3B7, 0x313, 230 },
    { 0x1F21, 0x3B7, 0x314, 230 },
    { 0x1F22, 0x1F20, 0x300, 230 },
    { 0x1F23, 0x1F21, 0x300, 230 },
    { 0x1F24, 0x1F20, 0x301, 230 },
    { 0x1F25, 0x1F21, 0x301, 230 },
    { 0x1F26, 0x1F20, 0x342, 230 },
    { 0x1F27, 0x1F21, 0x342, 230 },
    { 0x1F28, 0x397, 0x313, 230 },
    { 0x1F29, 0x397, 0x314, 230 },
    { 0x1F2A, 0x1F28, 0x300, 230 },
    { 0x1F2B, 0x1F29, 0x300, 230 },
    { 0x1F2C, 0x1F28, 0x301, 230 },
    { 0x1F2D, 0x1F29, 0x301, 230 },
    { 0x1F2E, 0x1F28, 0x342, 230 },
    { 0x1F2F, 0x1F29, 0x342, 230 },
    { 0x1F30, 0x3B9, 0x313, 230 },
    { 0x1F31, 0x3B9, 0x314, 230 },
    { 0x1F32, 0x1F30, 0x300, 230 },
    { 0x1F33, 0x1F31, 0x300, 230 },
    { 0x1F34, 0x1F30, 0x301, 230 },
    { 0x1F35, 0x1F31, 0x301, 230 },
    { 0x1F36, 0x1F30, 0x342, 230 },
    { 0x1F37, 0x1F31, 0x342, 230 },
    { 0x1F38, 0x399, 0x313, 230 },
    { 0x1F39, 0x399, 0x314, 230 },
    { 0x1F3A, 0x1F38, 0x300, 230 },
    { 0x1F3B, 0x1F39, 0x300, 230 },
    { 0x1F3C, 0x1F38, 0x301, 230 },
    { 0x1F3D, 0x1F39, 0x301, 230 },
    { 0x1F3E, 0x1F38, 0x342, 230 },
    { 0x1F3F, 0x1F39, 0x342, 230 },
    { 0x1F40, 0x3BF, 0x313, 230 },
    { 0x1F41, 0x3BF, 0x314, 230 },
    { 0x1F42, 0x1F40, 0x300, 230 },
    { 0x1F43, 0x1F41, 0x300, 230 },
    { 0x1F44, 0x1F40, 0x301, 230 },
    { 0x1F45, 0x1F41, 0x301, 230 },
    { 0x1F48, 0x39F, 0x313, 230 },
    { 0x1F49, 0x39F, 0x314, 230 },
    { 0x1F4A, 0x1F48, 0x300, 230 },
    { 0x1F4B, 0x1F49, 0x300, 230 },
    { 0x1F4C, 0x1F48, 0x301, 230 },
    { 0x1F4D, 0x1F49, 0x301, 230 },
    { 0x1F50, 0x3C5, 0x313, 230 },
    { 0x1F51, 0x3C5, 0x314, 230 },
    { 0x1F52, 0x1F50, 0x300, 230 },
    { 0x1F53, 0x1F51, 0x300, 230 },
    { 0x1F54, 0x1F50, 0x301, 230 },
    { 0x1F55, 0x1F51, 0x301, 230 },
    { 0x1F56, 0x1F50, 0x342, 230 },
    { 0x1F57, 0x1F51, 0x342, 230 },
    { 0x1F59, 0x3A5, 0x314, 230 },
    { 0x1F5B, 0x1F59, 0x300, 230 },
    { 0x1F5D, 0x1F59, 0x301, 230 },
    { 0x1F5F, 0x1F59, 0x342, 230 },
    { 0x1F60, 0x3C9, 0x313, 230 },
    { 0x1F61, 0x3C9, 0x314, 230 },
    { 0x1F62, 0x1F60, 0x300, 230 },
    { 0x1F63, 0x1F61, 0x300, 230 },
    { 0x1F64, 0x1F60, 0x301, 230 },
    { 0x1F65, 0x1F61, 0x301, 230 },
    { 0x1F66, 0x1F60, 0x342, 230 },
    { 0x1F67, 0x1F61, 0x342, 230 },
    { 0x1F68, 0x3A9, 0x313, 230 },
    { 0x1F69, 0x3A9, 0x314, 230 },
    { 0x1F6A, 0x1F68, 0x300, 230 },
    { 0x1F6B, 0x1F69, 0x300, 230 },
    { 0x1F6C, 0x1F68, 0x301, 230 },
    { 0x1F6D, 0x1F69, 0x301, 230 },
    { 0x1F6E, 0x1F68, 0x342, 230 },
    { 0x1F6F, 0x1F69, 0x342, 230 },
    { 0x1F70, 0x3B1, 0x300, 230 },
    { 0x1F72, 0x3B5, 0x300, 230 },
    { 0x1F74, 0x3B7, 0x300, 230 },
    { 0x1F76, 0x3B9, 0x300, 230 },
    { 0x1F78, 0x3BF, 0x300, 230 },
    { 0x1F7A, 0x3C5, 0x300, 230 },
    { 0x1F7C, 0x3C9, 0x300, 230 },
    { 0x1F80, 0x1F00, 0x345, 240 },
    { 0x1F81, 0x1F01, 0x345, 240 },
    { 0x1F82, 0x1F02, 0x345, 240 },
    { 0x1F83, 0x1F03, 0x345, 240 },
    { 0x1F84, 0x1F04, 0x345, 240 },
    { 0x1F85, 0x1F05, 0x345, 240 },
    { 0x1F86, 0x1F06, 0x345, 240 },
    { 0x1F87, 0x1F07, 0x345, 240 },
    { 0x1F88, 0x1F08, 0x345, 240 },
    { 0x1F89, 0x1F09, 0x345, 240 },
    { 0x1F8A, 0x1F0A, 0x345, 240 },
    { 0x1F8B, 0x1F0B, 0x345, 240 },
    { 0x1F8C, 0x1F0C, 0x345, 240 },
    { 0x1F8D, 0x1F0D, 0x345, 240 },
    { 0x1F8E, 0x1F0E, 0x345, 240 },
    { 0x1F8F, 0x1F0F, 0x345, 240 },
    { 0x1F90, 0x1F20, 0x345, 240 },
    { 0x1F91, 0x1F21, 0x345, 240 },
    { 0x1F92, 0x1F22, 0x345, 240 },
    { 0x1F93, 0x1F23, 0x345, 240 },
    { 0x1F94, 0x1F24, 0x345, 240 },
    { 0x1F95, 0x1F25, 0x345, 240 },
    { 0x1F96, 0x1F26, 0x345, 240 },
    { 0x1F97, 0x1F27, 0x345, 240 },
    { 0x1F98, 0x1F28, 0x345, 240 },
    { 0x1F99, 0x1F29, 0x345, 240 },
    { 0x1F9A, 0x1F2A, 0x345, 240 },
    { 0x1F9B, 0x1F2B, 0x345, 240 },
    { 0x1F9C, 0x1F2C, 0x345, 240 },
    { 0x1F9D, 0x1F2D, 0x345, 240 },
    { 0x1F9E, 0x1F2E, 0x345, 240 },
    { 0x1F9F, 0x1F2F, 0x345, 240 },
    { 0x1FA0, 0x1F60, 0x345, 240 },
    { 0x1FA1, 0x1F61, 0x345, 240 },
    { 0x1FA2, 0x1F62, 0x345, 240 },
    { 0x1FA3, 0x1F63, 0x345, 240 },
    { 0x1FA4, 0x1F64, 0x345, 240 },
    { 0x1FA5, 0x1F65, 0x345, 240 },
    { 0x1FA6, 0x1F66, 0x345, 240 },
    { 0x1FA7, 0x1F67, 0x345, 240 },
    { 0x1FA8, 0x1F68, 0x345, 240 },
    { 0x1FA9, 0x1F69, 0x345, 240 },
    { 0x1FAA, 0x1F6A, 0x345, 240 },
    { 0x1FAB, 0x1F6B, 0x345, 240 },
    { 0x1FAC, 0x1F6C, 0x345, 240 },
    { 0x1FAD, 0x1F6D, 0x345, 240 },
    { 0x1FAE, 0x1F6E, 0x345, 240 },
    { 0x1FAF, 0x1F6F, 0x345, 240 },
    { 0x1FB0, 0x3B1, 0x306, 230 },
    { 0x1FB1, 0x3B1, 0x304, 230 },
    { 0x1FB2, 0x1F70, 0x345, 240 },
    { 0x1FB3, 0x3B1, 0x345, 240 },
    { 0x1FB4, 0x3AC, 0x345, 240 },
    { 0x1FB6, 0x3B1, 0x342, 230 },
    { 0x1FB7, 0x1FB6, 0x345, 240 },
    { 0x1FB8, 0x391, 0x306, 230 },
    { 0x1FB9, 0x391, 0x304, 230 },
    { 0x1FBA, 0x391, 0x300, 230 },
    { 0x1FBC, 0x391, 0x345, 240 },
    { 0x1FC1, 0xA8, 0x342, 230 },
    { 0x1FC2, 0x1F74, 0x345, 240 },
    { 0x1FC3, 0x3B7, 0x345, 240 },
    { 0x1FC4, 0x3AE, 0x345, 240 },
    { 0x1FC6, 0x3B7, 0x342, 230 },
    { 0x1FC7, 0x1FC6, 0x345, 240 },
    { 0x1FC8, 0x395, 0x300, 230 },
    { 0x1FCA, 0x397, 0x300, 230 },
    { 0x1FCC, 0x397, 0x345, 240 },
    { 0x1FCD, 0x1FBF, 0x300, 230 },
    { 0x1FCE, 0x1FBF, 0x301, 230 },
    { 0x1FCF, 0x1FBF, 0x342, 230 },
    { 0x1FD0, 0x3B9, 0x306, 230 },
    { 0x1FD1, 0x3B9, 0x304, 230 },
    { 0x1FD2, 0x3CA, 0x300, 230 },
    { 0x1FD6, 0x3B9, 0x342, 230 },
    { 0x1FD7, 0x3CA, 0x342, 230 },
    { 0x1FD8, 0x399, 0x306, 230 },
    { 0x1FD9, 0x399, 0x304, 230 },
    { 0x1FDA, 0x399, 0x300, 230 },
    { 0x1FDD, 0x1FFE, 0x300, 230 },
    { 0x1FDE, 0x1FFE, 0x301, 230 },
    { 0x1FDF, 0x1FFE, 0x342, 230 },
    { 0x1FE0, 0x3C5, 0x306, 230 },
    { 0x1FE1, 0x3C5, 0x304, 230 },
    { 0x1FE2, 0x3CB, 0x300, 230 },
    { 0x1FE4, 0x3C1, 0x313, 230 },
    { 0x1FE5, 0x3C1, 0x314, 230 },
    { 0x1FE6, 0x3C5, 0x342, 230 },
    { 0x1FE7, 0x3CB, 0x342, 230 },
    { 0x1FE8, 0x3A5, 0x306, 230 },
    { 0x1FE9, 0x3A5, 0x304, 230 },
    { 0x1FEA, 0x3A5, 0x300, 230 },
    { 0x1FEC, 0x3A1, 0x314, 230 },
    { 0x1FED, 0xA8, 0x300, 230 },
    { 0x1FF2, 0x1F7C, 0x345, 240 },
    { 0x1FF3, 0x3C9, 0x345, 240 },
    { 0x1FF4, 0x3CE, 0x345, 240 },
    { 0x1FF6, 0x3C9, 0x342, 230 },
    { 0x1FF7, 0x1FF6, 0x345, 240 },
    { 0x1FF8, 0x39F, 0x300, 230 },
    { 0x1FFA, 0x3A9, 0x300, 230 },
    { 0x1FFC, 0x3A9, 0x345, 240 },
    { 0x219A, 0x2190, 0x338, 1 },
    { 0x219B, 0x2192, 0x338, 1 },
    { 0x21AE, 0x2194, 0x338, 1 },
    { 0x21CD, 0x21D0, 0x338, 1 },
    { 0x21CE, 0x21D4, 0x338, 1 },
    { 0x21CF, 0x21D2, 0x338, 1 },
    { 0x2204, 0x2203, 0x338, 1 },
    { 0x2209, 0x2208, 0x338, 1 },
    { 0x220C, 0x220B, 0x338, 1 },
    { 0x2224, 0x2223, 0x338, 1 },
    { 0x2226, 0x2225, 0x338, 1 },
    { 0x2241, 0x223C, 0x338, 1 },
    { 0x2244, 0x2243, 0x338, 1 },
    { 0x2247, 0x2245, 0x338, 1 },
    { 0x2249, 0x2248, 0x338, 1 },
    { 0x2260, 0x3D, 0x338, 1 },
    { 0x2262, 0x2261, 0x338, 1 },
    { 0x226D, 0x224D, 0x338, 1 },
    { 0x226E, 0x3C, 0x338, 1 },
    { 0x226F, 0x3E, 0x338, 1 },
    { 0x2270, 0x2264, 0x338, 1 },
    { 0x2271, 0x2265, 0x338, 1 },
    { 0x2274, 0x2272, 0x338, 1 },
    { 0x2275, 0x2273, 0x338, 1 },
    { 0x2278, 0x2276, 0x338, 1 },
    { 0x2279, 0x2277, 0x338, 1 },
    { 0x2280, 0x227A, 0x338, 1 },
    { 0x2281, 0x227B, 0x338, 1 },
    { 0x2284, 0x2282, 0x338, 1 },
    { 0x2285, 0x2283, 0x338, 1 },
    { 0x2288, 0x2286, 0x338, 1 },
    { 0x2289, 0x2287, 0x338, 1 },
    { 0x22AC, 0x22A2, 0x338, 1 },
    { 0x22AD, 0x22A8, 0x338, 1 },
    { 0x22AE, 0x22A9, 0x338, 1 },
    { 0x22AF, 0x22AB, 0x338, 1 },
    { 0x22E0, 0x227C, 0x338, 1 },
    { 0x22E1, 0x227D, 0x338, 1 },
    { 0x22E2, 0x2291, 0x338, 1 },
    { 0x22E3, 0x2292, 0x338, 1 },
    { 0x22EA, 0x22B2, 0x338, 1 },
    { 0x22EB, 0x22B3, 0x338, 1 },
    { 0x22EC, 0x22B4, 0x338, 1 },
    { 0x22ED, 0x22B5, 0x338, 1 },
    { 0x304C, 0x304B, 0x3099, 8 },
    { 0x304E, 0x304D, 0x3099, 8 },
    { 0x3050, 0x304F, 0x3099, 8 },
    { 0x3052, 0x3051, 0x3099, 8 },
    { 0x3054, 0x3053, 0x3099, 8 },
    { 0x3056, 0x3055, 0x3099, 8 },
    { 0x3058, 0x3057, 0x3099, 8 },
    { 0x305A, 0x3059, 0x3099, 8 },
    { 0x305C, 0x305B, 0x3099, 8 },
    { 0x305E, 0x305D, 0x3099, 8 },
    { 0x3060, 0x305F, 0x3099, 8 },
    { 0x3062, 0x3061, 0x3099, 8 },
    { 0x3065, 0x3064, 0x3099, 8 },
    { 0x3067, 0x3066, 0x3099, 8 },
    { 0x3069, 0x3068, 0x3099, 8 },
    { 0x3070, 0x306F, 0x3099, 8 },
    { 0x3071, 0x306F, 0x309A, 8 },
    { 0x3073, 0x3072, 0x3099, 8 },
    { 0x3074, 0x3072, 0x309A, 8 },
    { 0x3076, 0x3075, 0x3099, 8 },
    { 0x3077, 0x3075, 0x309A, 8 },
    { 0x3079, 0x3078, 0x3099, 8 },
    { 0x307A, 0x3078, 0x309A, 8 },
    { 0x307C, 0x307B, 0x3099, 8 },
    { 0x307D, 0x307B, 0x309A, 8 },
    { 0x3094, 0x3046, 0x3099, 8 },
    { 0x309E, 0x309D, 0x3099, 8 },
    { 0x30AC, 0x30AB, 0x3099, 8 },
    { 0x30AE, 0x30AD, 0x3099, 8 },
    { 0x30B0, 0x30AF, 0x3099, 8 },
    { 0x30B2, 0x30B1, 0x3099, 8 },
    { 0x30B4, 0x30B3, 0x3099, 8 },
    { 0x30B6, 0x30B5, 0x3099, 8 },
    { 0x30B8, 0x30B7, 0x3099, 8 },
    { 0x30BA, 0x30B9, 0x3099, 8 },
    { 0x30BC, 0x30BB, 0x3099, 8 },
    { 0x30BE, 0x30BD, 0x3099, 8 },
    { 0x30C0, 0x30BF, 0x3099, 8 },
    { 0x30C2, 0x30C1, 0x3099, 8 },
    { 0x30C5, 0x30C4, 0x3099, 8 },
    { 0x30C7, 0x30C6, 0x3099, 8 },
    { 0x30C9, 0x30C8, 0x3099, 8 },
    { 0x30D0, 0x30CF, 0x3099, 8 },
    { 0x30D1, 0x30CF, 0x309A, 8 },
    { 0x30D3, 0x30D2, 0x3099, 8 },
    { 0x30D4, 0x30D2, 0x309A, 8 },
    { 0x30D6, 0x30D5, 0x3099, 8 },
    { 0x30D7, 0x30D5, 0x309A, 8 },
    { 0x30D9, 0x30D8, 0x3099, 8 },
    { 0x30DA, 0x30D8, 0x309A, 8 },
    { 0x30DC, 0x30DB, 0x3099, 8 },
    { 0x30DD, 0x30DB, 0x309A, 8 },
    { 0x30F4, 0x30A6, 0x3099, 8 },
    { 0x30F7, 0x30EF, 0x3099, 8 },
    { 0x30F8, 0x30F0, 0x3099, 8 },
    { 0x30F9, 0x30F1, 0x3099, 8 },
    { 0x30FA, 0x30F2, 0x3099, 8 },
    { 0x30FE, 0x30FD, 0x3099, 8 },
    { 0x1109A, 0x11099, 0x110BA, 7 },
    { 0x1109C, 0x1109B, 0x110BA, 7 },
    { 0x110AB, 0x110A5, 0x110BA, 7 },
    { 0x1112E, 0x11131, 0x11127, 0 },
    { 0x1112F, 0x11132, 0x11127, 0 },
    { 0x1134B, 0x11347, 0x1133E, 0 },
    { 0x1134C, 0x11347, 0x11357, 0 },
    { 0x114BB, 0x114B9, 0x114BA, 0 },
    { 0x114BC, 0x114B9, 0x114B0, 0 },
    { 0x114BE, 0x114B9, 0x114BD, 0 },
    { 0x115BA, 0x115B8, 0x115AF, 0 },
    { 0x115BB, 0x115B9, 0x115AF, 0 },
    { 0x11938, 0x11935, 0x11930, 0 },
};

static struct nfc_table nfc_quickcheck_table[] = {
    { 0x300, REASON_COMBINING_MARK, 0, 0 },
    { 0x301, REASON_COMBINING_MARK, 0, 0 },
    { 0x302, REASON_COMBINING_MARK, 0, 0 },
    { 0x303, REASON_COMBINING_MARK, 0, 0 },
    { 0x304, REASON_COMBINING_MARK, 0, 0 },
    { 0x306, REASON_COMBINING_MARK, 0, 0 },
    { 0x307, REASON_COMBINING_MARK, 0, 0 },
    { 0x308, REASON_COMBINING_MARK, 0, 0 },
    { 0x309, REASON_COMBINING_MARK, 0, 0 },
    { 0x30A, REASON_COMBINING_MARK, 0, 0 },
    { 0x30B, REASON_COMBINING_MARK, 0, 0 },
    { 0x30C, REASON_COMBINING_MARK, 0, 0 },
    { 0x30F, REASON_COMBINING_MARK, 0, 0 },
    { 0x311, REASON_COMBINING_MARK, 0, 0 },
    { 0x313, REASON_COMBINING_MARK, 0, 0 },
    { 0x314, REASON_COMBINING_MARK, 0, 0 },
    { 0x31B, REASON_COMBINING_MARK, 0, 0 },
    { 0x323, REASON_COMBINING_MARK, 0, 0 },
    { 0x324, REASON_COMBINING_MARK, 0, 0 },
    { 0x325, REASON_COMBINING_MARK, 0, 0 },
    { 0x326, REASON_COMBINING_MARK, 0, 0 },
    { 0x327, REASON_COMBINING_MARK, 0, 0 },
    { 0x328, REASON_COMBINING_MARK, 0, 0 },
    { 0x32D, REASON_COMBINING_MARK, 0, 0 },
    { 0x32E, REASON_COMBINING_MARK, 0, 0 },
    { 0x330, REASON_COMBINING_MARK, 0, 0 },
    { 0x331, REASON_COMBINING_MARK, 0, 0 },
    { 0x338, REASON_COMBINING_MARK, 0, 0 },
    { 0x340, REASON_MUST_CONVERT_1, 0x300, 230 },
    { 0x341, REASON_MUST_CONVERT_1, 0x301, 230 },
    { 0x342, REASON_COMBINING_MARK, 0, 0 },
    { 0x343, REASON_MUST_CONVERT_1, 0x313, 230 },
    { 0x344, REASON_MUST_CONVERT_2, 0x308, 0x301 },
    { 0x345, REASON_COMBINING_MARK, 0, 0 },
    { 0x374, REASON_MUST_CONVERT_1, 0x2B9, 0 },
    { 0x37E, REASON_MUST_CONVERT_1, 0x3B, 0 },
    { 0x387, REASON_MUST_CONVERT_1, 0xB7, 0 },
    { 0x653, REASON_COMBINING_MARK, 0, 0 },
    { 0x654, REASON_COMBINING_MARK, 0, 0 },
    { 0x655, REASON_COMBINING_MARK, 0, 0 },
    { 0x93C, REASON_COMBINING_MARK, 0, 0 },
    { 0x958, REASON_MUST_CONVERT_2, 0x915, 0x93C },
    { 0x959, REASON_MUST_CONVERT_2, 0x916, 0x93C },
    { 0x95A, REASON_MUST_CONVERT_2, 0x917, 0x93C },
    { 0x95B, REASON_MUST_CONVERT_2, 0x91C, 0x93C },
    { 0x95C, REASON_MUST_CONVERT_2, 0x921, 0x93C },
    { 0x95D, REASON_MUST_CONVERT_2, 0x922, 0x93C },
    { 0x95E, REASON_MUST_CONVERT_2, 0x92B, 0x93C },
    { 0x95F, REASON_MUST_CONVERT_2, 0x92F, 0x93C },
    { 0x9BE, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0x9D7, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0x9DC, REASON_MUST_CONVERT_2, 0x9A1, 0x9BC },
    { 0x9DD, REASON_MUST_CONVERT_2, 0x9A2, 0x9BC },
    { 0x9DF, REASON_MUST_CONVERT_2, 0x9AF, 0x9BC },
    { 0xA33, REASON_MUST_CONVERT_2, 0xA32, 0xA3C },
    { 0xA36, REASON_MUST_CONVERT_2, 0xA38, 0xA3C },
    { 0xA59, REASON_MUST_CONVERT_2, 0xA16, 0xA3C },
    { 0xA5A, REASON_MUST_CONVERT_2, 0xA17, 0xA3C },
    { 0xA5B, REASON_MUST_CONVERT_2, 0xA1C, 0xA3C },
    { 0xA5E, REASON_MUST_CONVERT_2, 0xA2B, 0xA3C },
    { 0xB3E, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0xB56, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0xB57, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0xB5C, REASON_MUST_CONVERT_2, 0xB21, 0xB3C },
    { 0xB5D, REASON_MUST_CONVERT_2, 0xB22, 0xB3C },
    { 0xBBE, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0xBD7, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0xC56, REASON_COMBINING_MARK, 0, 0 },
    { 0xCC2, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0xCD5, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0xCD6, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0xD3E, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0xD57, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0xDCA, REASON_COMBINING_MARK, 0, 0 },
    { 0xDCF, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0xDDF, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0xF43, REASON_MUST_CONVERT_2, 0xF42, 0xFB7 },
    { 0xF4D, REASON_MUST_CONVERT_2, 0xF4C, 0xFB7 },
    { 0xF52, REASON_MUST_CONVERT_2, 0xF51, 0xFB7 },
    { 0xF57, REASON_MUST_CONVERT_2, 0xF56, 0xFB7 },
    { 0xF5C, REASON_MUST_CONVERT_2, 0xF5B, 0xFB7 },
    { 0xF69, REASON_MUST_CONVERT_2, 0xF40, 0xFB5 },
    { 0xF73, REASON_MUST_CONVERT_2, 0xF71, 0xF72 },
    { 0xF75, REASON_MUST_CONVERT_2, 0xF71, 0xF74 },
    { 0xF76, REASON_MUST_CONVERT_2, 0xFB2, 0xF80 },
    { 0xF78, REASON_MUST_CONVERT_2, 0xFB3, 0xF80 },
    { 0xF81, REASON_MUST_CONVERT_2, 0xF71, 0xF80 },
    { 0xF93, REASON_MUST_CONVERT_2, 0xF92, 0xFB7 },
    { 0xF9D, REASON_MUST_CONVERT_2, 0xF9C, 0xFB7 },
    { 0xFA2, REASON_MUST_CONVERT_2, 0xFA1, 0xFB7 },
    { 0xFA7, REASON_MUST_CONVERT_2, 0xFA6, 0xFB7 },
    { 0xFAC, REASON_MUST_CONVERT_2, 0xFAB, 0xFB7 },
    { 0xFB9, REASON_MUST_CONVERT_2, 0xF90, 0xFB5 },
    { 0x102E, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0x1161, REASON_JAMO_VOWEL, 0, 0 },
    { 0x1162, REASON_JAMO_VOWEL, 0, 0 },
    { 0x1163, REASON_JAMO_VOWEL, 0, 0 },
    { 0x1164, REASON_JAMO_VOWEL, 0, 0 },
    { 0x1165, REASON_JAMO_VOWEL, 0, 0 },
    { 0x1166, REASON_JAMO_VOWEL, 0, 0 },
    { 0x1167, REASON_JAMO_VOWEL, 0, 0 },
    { 0x1168, REASON_JAMO_VOWEL, 0, 0 },
    { 0x1169, REASON_JAMO_VOWEL, 0, 0 },
    { 0x116A, REASON_JAMO_VOWEL, 0, 0 },
    { 0x116B, REASON_JAMO_VOWEL, 0, 0 },
    { 0x116C, REASON_JAMO_VOWEL, 0, 0 },
    { 0x116D, REASON_JAMO_VOWEL, 0, 0 },
    { 0x116E, REASON_JAMO_VOWEL, 0, 0 },
    { 0x116F, REASON_JAMO_VOWEL, 0, 0 },
    { 0x1170, REASON_JAMO_VOWEL, 0, 0 },
    { 0x1171, REASON_JAMO_VOWEL, 0, 0 },
    { 0x1172, REASON_JAMO_VOWEL, 0, 0 },
    { 0x1173, REASON_JAMO_VOWEL, 0, 0 },
    { 0x1174, REASON_JAMO_VOWEL, 0, 0 },
    { 0x1175, REASON_JAMO_VOWEL, 0, 0 },
    { 0x11A8, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11A9, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11AA, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11AB, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11AC, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11AD, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11AE, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11AF, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11B0, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11B1, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11B2, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11B3, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11B4, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11B5, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11B6, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11B7, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11B8, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11B9, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11BA, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11BB, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11BC, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11BD, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11BE, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11BF, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11C0, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11C1, REASON_JAMO_TRAILING, 0, 0 },
    { 0x11C2, REASON_JAMO_TRAILING, 0, 0 },
    { 0x1B35, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0x1F71, REASON_MUST_CONVERT_1, 0x3AC, 0 },
    { 0x1F73, REASON_MUST_CONVERT_1, 0x3AD, 0 },
    { 0x1F75, REASON_MUST_CONVERT_1, 0x3AE, 0 },
    { 0x1F77, REASON_MUST_CONVERT_1, 0x3AF, 0 },
    { 0x1F79, REASON_MUST_CONVERT_1, 0x3CC, 0 },
    { 0x1F7B, REASON_MUST_CONVERT_1, 0x3CD, 0 },
    { 0x1F7D, REASON_MUST_CONVERT_1, 0x3CE, 0 },
    { 0x1FBB, REASON_MUST_CONVERT_1, 0x386, 0 },
    { 0x1FBE, REASON_MUST_CONVERT_1, 0x3B9, 0 },
    { 0x1FC9, REASON_MUST_CONVERT_1, 0x388, 0 },
    { 0x1FCB, REASON_MUST_CONVERT_1, 0x389, 0 },
    { 0x1FD3, REASON_MUST_CONVERT_1, 0x390, 0 },
    { 0x1FDB, REASON_MUST_CONVERT_1, 0x38A, 0 },
    { 0x1FE3, REASON_MUST_CONVERT_1, 0x3B0, 0 },
    { 0x1FEB, REASON_MUST_CONVERT_1, 0x38E, 0 },
    { 0x1FEE, REASON_MUST_CONVERT_1, 0x385, 0 },
    { 0x1FEF, REASON_MUST_CONVERT_1, 0x60, 0 },
    { 0x1FF9, REASON_MUST_CONVERT_1, 0x38C, 0 },
    { 0x1FFB, REASON_MUST_CONVERT_1, 0x38F, 0 },
    { 0x1FFD, REASON_MUST_CONVERT_1, 0xB4, 0 },
    { 0x2000, REASON_MUST_CONVERT_1, 0x2002, 0 },
    { 0x2001, REASON_MUST_CONVERT_1, 0x2003, 0 },
    { 0x2126, REASON_MUST_CONVERT_1, 0x3A9, 0 },
    { 0x212A, REASON_MUST_CONVERT_1, 0x4B, 0 },
    { 0x212B, REASON_MUST_CONVERT_1, 0xC5, 0 },
    { 0x2329, REASON_MUST_CONVERT_1, 0x3008, 0 },
    { 0x232A, REASON_MUST_CONVERT_1, 0x3009, 0 },
    { 0x2ADC, REASON_MUST_CONVERT_2, 0x2ADD, 0x338 },
    { 0x3099, REASON_COMBINING_MARK, 0, 0 },
    { 0x309A, REASON_COMBINING_MARK, 0, 0 },
    { 0xF900, REASON_MUST_CONVERT_1, 0x8C48, 0 },
    { 0xF901, REASON_MUST_CONVERT_1, 0x66F4, 0 },
    { 0xF902, REASON_MUST_CONVERT_1, 0x8ECA, 0 },
    { 0xF903, REASON_MUST_CONVERT_1, 0x8CC8, 0 },
    { 0xF904, REASON_MUST_CONVERT_1, 0x6ED1, 0 },
    { 0xF905, REASON_MUST_CONVERT_1, 0x4E32, 0 },
    { 0xF906, REASON_MUST_CONVERT_1, 0x53E5, 0 },
    { 0xF907, REASON_MUST_CONVERT_1, 0x9F9C, 0 },
    { 0xF908, REASON_MUST_CONVERT_1, 0x9F9C, 0 },
    { 0xF909, REASON_MUST_CONVERT_1, 0x5951, 0 },
    { 0xF90A, REASON_MUST_CONVERT_1, 0x91D1, 0 },
    { 0xF90B, REASON_MUST_CONVERT_1, 0x5587, 0 },
    { 0xF90C, REASON_MUST_CONVERT_1, 0x5948, 0 },
    { 0xF90D, REASON_MUST_CONVERT_1, 0x61F6, 0 },
    { 0xF90E, REASON_MUST_CONVERT_1, 0x7669, 0 },
    { 0xF90F, REASON_MUST_CONVERT_1, 0x7F85, 0 },
    { 0xF910, REASON_MUST_CONVERT_1, 0x863F, 0 },
    { 0xF911, REASON_MUST_CONVERT_1, 0x87BA, 0 },
    { 0xF912, REASON_MUST_CONVERT_1, 0x88F8, 0 },
    { 0xF913, REASON_MUST_CONVERT_1, 0x908F, 0 },
    { 0xF914, REASON_MUST_CONVERT_1, 0x6A02, 0 },
    { 0xF915, REASON_MUST_CONVERT_1, 0x6D1B, 0 },
    { 0xF916, REASON_MUST_CONVERT_1, 0x70D9, 0 },
    { 0xF917, REASON_MUST_CONVERT_1, 0x73DE, 0 },
    { 0xF918, REASON_MUST_CONVERT_1, 0x843D, 0 },
    { 0xF919, REASON_MUST_CONVERT_1, 0x916A, 0 },
    { 0xF91A, REASON_MUST_CONVERT_1, 0x99F1, 0 },
    { 0xF91B, REASON_MUST_CONVERT_1, 0x4E82, 0 },
    { 0xF91C, REASON_MUST_CONVERT_1, 0x5375, 0 },
    { 0xF91D, REASON_MUST_CONVERT_1, 0x6B04, 0 },
    { 0xF91E, REASON_MUST_CONVERT_1, 0x721B, 0 },
    { 0xF91F, REASON_MUST_CONVERT_1, 0x862D, 0 },
    { 0xF920, REASON_MUST_CONVERT_1, 0x9E1E, 0 },
    { 0xF921, REASON_MUST_CONVERT_1, 0x5D50, 0 },
    { 0xF922, REASON_MUST_CONVERT_1, 0x6FEB, 0 },
    { 0xF923, REASON_MUST_CONVERT_1, 0x85CD, 0 },
    { 0xF924, REASON_MUST_CONVERT_1, 0x8964, 0 },
    { 0xF925, REASON_MUST_CONVERT_1, 0x62C9, 0 },
    { 0xF926, REASON_MUST_CONVERT_1, 0x81D8, 0 },
    { 0xF927, REASON_MUST_CONVERT_1, 0x881F, 0 },
    { 0xF928, REASON_MUST_CONVERT_1, 0x5ECA, 0 },
    { 0xF929, REASON_MUST_CONVERT_1, 0x6717, 0 },
    { 0xF92A, REASON_MUST_CONVERT_1, 0x6D6A, 0 },
    { 0xF92B, REASON_MUST_CONVERT_1, 0x72FC, 0 },
    { 0xF92C, REASON_MUST_CONVERT_1, 0x90CE, 0 },
    { 0xF92D, REASON_MUST_CONVERT_1, 0x4F86, 0 },
    { 0xF92E, REASON_MUST_CONVERT_1, 0x51B7, 0 },
    { 0xF92F, REASON_MUST_CONVERT_1, 0x52DE, 0 },
    { 0xF930, REASON_MUST_CONVERT_1, 0x64C4, 0 },
    { 0xF931, REASON_MUST_CONVERT_1, 0x6AD3, 0 },
    { 0xF932, REASON_MUST_CONVERT_1, 0x7210, 0 },
    { 0xF933, REASON_MUST_CONVERT_1, 0x76E7, 0 },
    { 0xF934, REASON_MUST_CONVERT_1, 0x8001, 0 },
    { 0xF935, REASON_MUST_CONVERT_1, 0x8606, 0 },
    { 0xF936, REASON_MUST_CONVERT_1, 0x865C, 0 },
    { 0xF937, REASON_MUST_CONVERT_1, 0x8DEF, 0 },
    { 0xF938, REASON_MUST_CONVERT_1, 0x9732, 0 },
    { 0xF939, REASON_MUST_CONVERT_1, 0x9B6F, 0 },
    { 0xF93A, REASON_MUST_CONVERT_1, 0x9DFA, 0 },
    { 0xF93B, REASON_MUST_CONVERT_1, 0x788C, 0 },
    { 0xF93C, REASON_MUST_CONVERT_1, 0x797F, 0 },
    { 0xF93D, REASON_MUST_CONVERT_1, 0x7DA0, 0 },
    { 0xF93E, REASON_MUST_CONVERT_1, 0x83C9, 0 },
    { 0xF93F, REASON_MUST_CONVERT_1, 0x9304, 0 },
    { 0xF940, REASON_MUST_CONVERT_1, 0x9E7F, 0 },
    { 0xF941, REASON_MUST_CONVERT_1, 0x8AD6, 0 },
    { 0xF942, REASON_MUST_CONVERT_1, 0x58DF, 0 },
    { 0xF943, REASON_MUST_CONVERT_1, 0x5F04, 0 },
    { 0xF944, REASON_MUST_CONVERT_1, 0x7C60, 0 },
    { 0xF945, REASON_MUST_CONVERT_1, 0x807E, 0 },
    { 0xF946, REASON_MUST_CONVERT_1, 0x7262, 0 },
    { 0xF947, REASON_MUST_CONVERT_1, 0x78CA, 0 },
    { 0xF948, REASON_MUST_CONVERT_1, 0x8CC2, 0 },
    { 0xF949, REASON_MUST_CONVERT_1, 0x96F7, 0 },
    { 0xF94A, REASON_MUST_CONVERT_1, 0x58D8, 0 },
    { 0xF94B, REASON_MUST_CONVERT_1, 0x5C62, 0 },
    { 0xF94C, REASON_MUST_CONVERT_1, 0x6A13, 0 },
    { 0xF94D, REASON_MUST_CONVERT_1, 0x6DDA, 0 },
    { 0xF94E, REASON_MUST_CONVERT_1, 0x6F0F, 0 },
    { 0xF94F, REASON_MUST_CONVERT_1, 0x7D2F, 0 },
    { 0xF950, REASON_MUST_CONVERT_1, 0x7E37, 0 },
    { 0xF951, REASON_MUST_CONVERT_1, 0x964B, 0 },
    { 0xF952, REASON_MUST_CONVERT_1, 0x52D2, 0 },
    { 0xF953, REASON_MUST_CONVERT_1, 0x808B, 0 },
    { 0xF954, REASON_MUST_CONVERT_1, 0x51DC, 0 },
    { 0xF955, REASON_MUST_CONVERT_1, 0x51CC, 0 },
    { 0xF956, REASON_MUST_CONVERT_1, 0x7A1C, 0 },
    { 0xF957, REASON_MUST_CONVERT_1, 0x7DBE, 0 },
    { 0xF958, REASON_MUST_CONVERT_1, 0x83F1, 0 },
    { 0xF959, REASON_MUST_CONVERT_1, 0x9675, 0 },
    { 0xF95A, REASON_MUST_CONVERT_1, 0x8B80, 0 },
    { 0xF95B, REASON_MUST_CONVERT_1, 0x62CF, 0 },
    { 0xF95C, REASON_MUST_CONVERT_1, 0x6A02, 0 },
    { 0xF95D, REASON_MUST_CONVERT_1, 0x8AFE, 0 },
    { 0xF95E, REASON_MUST_CONVERT_1, 0x4E39, 0 },
    { 0xF95F, REASON_MUST_CONVERT_1, 0x5BE7, 0 },
    { 0xF960, REASON_MUST_CONVERT_1, 0x6012, 0 },
    { 0xF961, REASON_MUST_CONVERT_1, 0x7387, 0 },
    { 0xF962, REASON_MUST_CONVERT_1, 0x7570, 0 },
    { 0xF963, REASON_MUST_CONVERT_1, 0x5317, 0 },
    { 0xF964, REASON_MUST_CONVERT_1, 0x78FB, 0 },
    { 0xF965, REASON_MUST_CONVERT_1, 0x4FBF, 0 },
    { 0xF966, REASON_MUST_CONVERT_1, 0x5FA9, 0 },
    { 0xF967, REASON_MUST_CONVERT_1, 0x4E0D, 0 },
    { 0xF968, REASON_MUST_CONVERT_1, 0x6CCC, 0 },
    { 0xF969, REASON_MUST_CONVERT_1, 0x6578, 0 },
    { 0xF96A, REASON_MUST_CONVERT_1, 0x7D22, 0 },
    { 0xF96B, REASON_MUST_CONVERT_1, 0x53C3, 0 },
    { 0xF96C, REASON_MUST_CONVERT_1, 0x585E, 0 },
    { 0xF96D, REASON_MUST_CONVERT_1, 0x7701, 0 },
    { 0xF96E, REASON_MUST_CONVERT_1, 0x8449, 0 },
    { 0xF96F, REASON_MUST_CONVERT_1, 0x8AAA, 0 },
    { 0xF970, REASON_MUST_CONVERT_1, 0x6BBA, 0 },
    { 0xF971, REASON_MUST_CONVERT_1, 0x8FB0, 0 },
    { 0xF972, REASON_MUST_CONVERT_1, 0x6C88, 0 },
    { 0xF973, REASON_MUST_CONVERT_1, 0x62FE, 0 },
    { 0xF974, REASON_MUST_CONVERT_1, 0x82E5, 0 },
    { 0xF975, REASON_MUST_CONVERT_1, 0x63A0, 0 },
    { 0xF976, REASON_MUST_CONVERT_1, 0x7565, 0 },
    { 0xF977, REASON_MUST_CONVERT_1, 0x4EAE, 0 },
    { 0xF978, REASON_MUST_CONVERT_1, 0x5169, 0 },
    { 0xF979, REASON_MUST_CONVERT_1, 0x51C9, 0 },
    { 0xF97A, REASON_MUST_CONVERT_1, 0x6881, 0 },
    { 0xF97B, REASON_MUST_CONVERT_1, 0x7CE7, 0 },
    { 0xF97C, REASON_MUST_CONVERT_1, 0x826F, 0 },
    { 0xF97D, REASON_MUST_CONVERT_1, 0x8AD2, 0 },
    { 0xF97E, REASON_MUST_CONVERT_1, 0x91CF, 0 },
    { 0xF97F, REASON_MUST_CONVERT_1, 0x52F5, 0 },
    { 0xF980, REASON_MUST_CONVERT_1, 0x5442, 0 },
    { 0xF981, REASON_MUST_CONVERT_1, 0x5973, 0 },
    { 0xF982, REASON_MUST_CONVERT_1, 0x5EEC, 0 },
    { 0xF983, REASON_MUST_CONVERT_1, 0x65C5, 0 },
    { 0xF984, REASON_MUST_CONVERT_1, 0x6FFE, 0 },
    { 0xF985, REASON_MUST_CONVERT_1, 0x792A, 0 },
    { 0xF986, REASON_MUST_CONVERT_1, 0x95AD, 0 },
    { 0xF987, REASON_MUST_CONVERT_1, 0x9A6A, 0 },
    { 0xF988, REASON_MUST_CONVERT_1, 0x9E97, 0 },
    { 0xF989, REASON_MUST_CONVERT_1, 0x9ECE, 0 },
    { 0xF98A, REASON_MUST_CONVERT_1, 0x529B, 0 },
    { 0xF98B, REASON_MUST_CONVERT_1, 0x66C6, 0 },
    { 0xF98C, REASON_MUST_CONVERT_1, 0x6B77, 0 },
    { 0xF98D, REASON_MUST_CONVERT_1, 0x8F62, 0 },
    { 0xF98E, REASON_MUST_CONVERT_1, 0x5E74, 0 },
    { 0xF98F, REASON_MUST_CONVERT_1, 0x6190, 0 },
    { 0xF990, REASON_MUST_CONVERT_1, 0x6200, 0 },
    { 0xF991, REASON_MUST_CONVERT_1, 0x649A, 0 },
    { 0xF992, REASON_MUST_CONVERT_1, 0x6F23, 0 },
    { 0xF993, REASON_MUST_CONVERT_1, 0x7149, 0 },
    { 0xF994, REASON_MUST_CONVERT_1, 0x7489, 0 },
    { 0xF995, REASON_MUST_CONVERT_1, 0x79CA, 0 },
    { 0xF996, REASON_MUST_CONVERT_1, 0x7DF4, 0 },
    { 0xF997, REASON_MUST_CONVERT_1, 0x806F, 0 },
    { 0xF998, REASON_MUST_CONVERT_1, 0x8F26, 0 },
    { 0xF999, REASON_MUST_CONVERT_1, 0x84EE, 0 },
    { 0xF99A, REASON_MUST_CONVERT_1, 0x9023, 0 },
    { 0xF99B, REASON_MUST_CONVERT_1, 0x934A, 0 },
    { 0xF99C, REASON_MUST_CONVERT_1, 0x5217, 0 },
    { 0xF99D, REASON_MUST_CONVERT_1, 0x52A3, 0 },
    { 0xF99E, REASON_MUST_CONVERT_1, 0x54BD, 0 },
    { 0xF99F, REASON_MUST_CONVERT_1, 0x70C8, 0 },
    { 0xF9A0, REASON_MUST_CONVERT_1, 0x88C2, 0 },
    { 0xF9A1, REASON_MUST_CONVERT_1, 0x8AAA, 0 },
    { 0xF9A2, REASON_MUST_CONVERT_1, 0x5EC9, 0 },
    { 0xF9A3, REASON_MUST_CONVERT_1, 0x5FF5, 0 },
    { 0xF9A4, REASON_MUST_CONVERT_1, 0x637B, 0 },
    { 0xF9A5, REASON_MUST_CONVERT_1, 0x6BAE, 0 },
    { 0xF9A6, REASON_MUST_CONVERT_1, 0x7C3E, 0 },
    { 0xF9A7, REASON_MUST_CONVERT_1, 0x7375, 0 },
    { 0xF9A8, REASON_MUST_CONVERT_1, 0x4EE4, 0 },
    { 0xF9A9, REASON_MUST_CONVERT_1, 0x56F9, 0 },
    { 0xF9AA, REASON_MUST_CONVERT_1, 0x5BE7, 0 },
    { 0xF9AB, REASON_MUST_CONVERT_1, 0x5DBA, 0 },
    { 0xF9AC, REASON_MUST_CONVERT_1, 0x601C, 0 },
    { 0xF9AD, REASON_MUST_CONVERT_1, 0x73B2, 0 },
    { 0xF9AE, REASON_MUST_CONVERT_1, 0x7469, 0 },
    { 0xF9AF, REASON_MUST_CONVERT_1, 0x7F9A, 0 },
    { 0xF9B0, REASON_MUST_CONVERT_1, 0x8046, 0 },
    { 0xF9B1, REASON_MUST_CONVERT_1, 0x9234, 0 },
    { 0xF9B2, REASON_MUST_CONVERT_1, 0x96F6, 0 },
    { 0xF9B3, REASON_MUST_CONVERT_1, 0x9748, 0 },
    { 0xF9B4, REASON_MUST_CONVERT_1, 0x9818, 0 },
    { 0xF9B5, REASON_MUST_CONVERT_1, 0x4F8B, 0 },
    { 0xF9B6, REASON_MUST_CONVERT_1, 0x79AE, 0 },
    { 0xF9B7, REASON_MUST_CONVERT_1, 0x91B4, 0 },
    { 0xF9B8, REASON_MUST_CONVERT_1, 0x96B8, 0 },
    { 0xF9B9, REASON_MUST_CONVERT_1, 0x60E1, 0 },
    { 0xF9BA, REASON_MUST_CONVERT_1, 0x4E86, 0 },
    { 0xF9BB, REASON_MUST_CONVERT_1, 0x50DA, 0 },
    { 0xF9BC, REASON_MUST_CONVERT_1, 0x5BEE, 0 },
    { 0xF9BD, REASON_MUST_CONVERT_1, 0x5C3F, 0 },
    { 0xF9BE, REASON_MUST_CONVERT_1, 0x6599, 0 },
    { 0xF9BF, REASON_MUST_CONVERT_1, 0x6A02, 0 },
    { 0xF9C0, REASON_MUST_CONVERT_1, 0x71CE, 0 },
    { 0xF9C1, REASON_MUST_CONVERT_1, 0x7642, 0 },
    { 0xF9C2, REASON_MUST_CONVERT_1, 0x84FC, 0 },
    { 0xF9C3, REASON_MUST_CONVERT_1, 0x907C, 0 },
    { 0xF9C4, REASON_MUST_CONVERT_1, 0x9F8D, 0 },
    { 0xF9C5, REASON_MUST_CONVERT_1, 0x6688, 0 },
    { 0xF9C6, REASON_MUST_CONVERT_1, 0x962E, 0 },
    { 0xF9C7, REASON_MUST_CONVERT_1, 0x5289, 0 },
    { 0xF9C8, REASON_MUST_CONVERT_1, 0x677B, 0 },
    { 0xF9C9, REASON_MUST_CONVERT_1, 0x67F3, 0 },
    { 0xF9CA, REASON_MUST_CONVERT_1, 0x6D41, 0 },
    { 0xF9CB, REASON_MUST_CONVERT_1, 0x6E9C, 0 },
    { 0xF9CC, REASON_MUST_CONVERT_1, 0x7409, 0 },
    { 0xF9CD, REASON_MUST_CONVERT_1, 0x7559, 0 },
    { 0xF9CE, REASON_MUST_CONVERT_1, 0x786B, 0 },
    { 0xF9CF, REASON_MUST_CONVERT_1, 0x7D10, 0 },
    { 0xF9D0, REASON_MUST_CONVERT_1, 0x985E, 0 },
    { 0xF9D1, REASON_MUST_CONVERT_1, 0x516D, 0 },
    { 0xF9D2, REASON_MUST_CONVERT_1, 0x622E, 0 },
    { 0xF9D3, REASON_MUST_CONVERT_1, 0x9678, 0 },
    { 0xF9D4, REASON_MUST_CONVERT_1, 0x502B, 0 },
    { 0xF9D5, REASON_MUST_CONVERT_1, 0x5D19, 0 },
    { 0xF9D6, REASON_MUST_CONVERT_1, 0x6DEA, 0 },
    { 0xF9D7, REASON_MUST_CONVERT_1, 0x8F2A, 0 },
    { 0xF9D8, REASON_MUST_CONVERT_1, 0x5F8B, 0 },
    { 0xF9D9, REASON_MUST_CONVERT_1, 0x6144, 0 },
    { 0xF9DA, REASON_MUST_CONVERT_1, 0x6817, 0 },
    { 0xF9DB, REASON_MUST_CONVERT_1, 0x7387, 0 },
    { 0xF9DC, REASON_MUST_CONVERT_1, 0x9686, 0 },
    { 0xF9DD, REASON_MUST_CONVERT_1, 0x5229, 0 },
    { 0xF9DE, REASON_MUST_CONVERT_1, 0x540F, 0 },
    { 0xF9DF, REASON_MUST_CONVERT_1, 0x5C65, 0 },
    { 0xF9E0, REASON_MUST_CONVERT_1, 0x6613, 0 },
    { 0xF9E1, REASON_MUST_CONVERT_1, 0x674E, 0 },
    { 0xF9E2, REASON_MUST_CONVERT_1, 0x68A8, 0 },
    { 0xF9E3, REASON_MUST_CONVERT_1, 0x6CE5, 0 },
    { 0xF9E4, REASON_MUST_CONVERT_1, 0x7406, 0 },
    { 0xF9E5, REASON_MUST_CONVERT_1, 0x75E2, 0 },
    { 0xF9E6, REASON_MUST_CONVERT_1, 0x7F79, 0 },
    { 0xF9E7, REASON_MUST_CONVERT_1, 0x88CF, 0 },
    { 0xF9E8, REASON_MUST_CONVERT_1, 0x88E1, 0 },
    { 0xF9E9, REASON_MUST_CONVERT_1, 0x91CC, 0 },
    { 0xF9EA, REASON_MUST_CONVERT_1, 0x96E2, 0 },
    { 0xF9EB, REASON_MUST_CONVERT_1, 0x533F, 0 },
    { 0xF9EC, REASON_MUST_CONVERT_1, 0x6EBA, 0 },
    { 0xF9ED, REASON_MUST_CONVERT_1, 0x541D, 0 },
    { 0xF9EE, REASON_MUST_CONVERT_1, 0x71D0, 0 },
    { 0xF9EF, REASON_MUST_CONVERT_1, 0x7498, 0 },
    { 0xF9F0, REASON_MUST_CONVERT_1, 0x85FA, 0 },
    { 0xF9F1, REASON_MUST_CONVERT_1, 0x96A3, 0 },
    { 0xF9F2, REASON_MUST_CONVERT_1, 0x9C57, 0 },
    { 0xF9F3, REASON_MUST_CONVERT_1, 0x9E9F, 0 },
    { 0xF9F4, REASON_MUST_CONVERT_1, 0x6797, 0 },
    { 0xF9F5, REASON_MUST_CONVERT_1, 0x6DCB, 0 },
    { 0xF9F6, REASON_MUST_CONVERT_1, 0x81E8, 0 },
    { 0xF9F7, REASON_MUST_CONVERT_1, 0x7ACB, 0 },
    { 0xF9F8, REASON_MUST_CONVERT_1, 0x7B20, 0 },
    { 0xF9F9, REASON_MUST_CONVERT_1, 0x7C92, 0 },
    { 0xF9FA, REASON_MUST_CONVERT_1, 0x72C0, 0 },
    { 0xF9FB, REASON_MUST_CONVERT_1, 0x7099, 0 },
    { 0xF9FC, REASON_MUST_CONVERT_1, 0x8B58, 0 },
    { 0xF9FD, REASON_MUST_CONVERT_1, 0x4EC0, 0 },
    { 0xF9FE, REASON_MUST_CONVERT_1, 0x8336, 0 },
    { 0xF9FF, REASON_MUST_CONVERT_1, 0x523A, 0 },
    { 0xFA00, REASON_MUST_CONVERT_1, 0x5207, 0 },
    { 0xFA01, REASON_MUST_CONVERT_1, 0x5EA6, 0 },
    { 0xFA02, REASON_MUST_CONVERT_1, 0x62D3, 0 },
    { 0xFA03, REASON_MUST_CONVERT_1, 0x7CD6, 0 },
    { 0xFA04, REASON_MUST_CONVERT_1, 0x5B85, 0 },
    { 0xFA05, REASON_MUST_CONVERT_1, 0x6D1E, 0 },
    { 0xFA06, REASON_MUST_CONVERT_1, 0x66B4, 0 },
    { 0xFA07, REASON_MUST_CONVERT_1, 0x8F3B, 0 },
    { 0xFA08, REASON_MUST_CONVERT_1, 0x884C, 0 },
    { 0xFA09, REASON_MUST_CONVERT_1, 0x964D, 0 },
    { 0xFA0A, REASON_MUST_CONVERT_1, 0x898B, 0 },
    { 0xFA0B, REASON_MUST_CONVERT_1, 0x5ED3, 0 },
    { 0xFA0C, REASON_MUST_CONVERT_1, 0x5140, 0 },
    { 0xFA0D, REASON_MUST_CONVERT_1, 0x55C0, 0 },
    { 0xFA10, REASON_MUST_CONVERT_1, 0x585A, 0 },
    { 0xFA12, REASON_MUST_CONVERT_1, 0x6674, 0 },
    { 0xFA15, REASON_MUST_CONVERT_1, 0x51DE, 0 },
    { 0xFA16, REASON_MUST_CONVERT_1, 0x732A, 0 },
    { 0xFA17, REASON_MUST_CONVERT_1, 0x76CA, 0 },
    { 0xFA18, REASON_MUST_CONVERT_1, 0x793C, 0 },
    { 0xFA19, REASON_MUST_CONVERT_1, 0x795E, 0 },
    { 0xFA1A, REASON_MUST_CONVERT_1, 0x7965, 0 },
    { 0xFA1B, REASON_MUST_CONVERT_1, 0x798F, 0 },
    { 0xFA1C, REASON_MUST_CONVERT_1, 0x9756, 0 },
    { 0xFA1D, REASON_MUST_CONVERT_1, 0x7CBE, 0 },
    { 0xFA1E, REASON_MUST_CONVERT_1, 0x7FBD, 0 },
    { 0xFA20, REASON_MUST_CONVERT_1, 0x8612, 0 },
    { 0xFA22, REASON_MUST_CONVERT_1, 0x8AF8, 0 },
    { 0xFA25, REASON_MUST_CONVERT_1, 0x9038, 0 },
    { 0xFA26, REASON_MUST_CONVERT_1, 0x90FD, 0 },
    { 0xFA2A, REASON_MUST_CONVERT_1, 0x98EF, 0 },
    { 0xFA2B, REASON_MUST_CONVERT_1, 0x98FC, 0 },
    { 0xFA2C, REASON_MUST_CONVERT_1, 0x9928, 0 },
    { 0xFA2D, REASON_MUST_CONVERT_1, 0x9DB4, 0 },
    { 0xFA2E, REASON_MUST_CONVERT_1, 0x90DE, 0 },
    { 0xFA2F, REASON_MUST_CONVERT_1, 0x96B7, 0 },
    { 0xFA30, REASON_MUST_CONVERT_1, 0x4FAE, 0 },
    { 0xFA31, REASON_MUST_CONVERT_1, 0x50E7, 0 },
    { 0xFA32, REASON_MUST_CONVERT_1, 0x514D, 0 },
    { 0xFA33, REASON_MUST_CONVERT_1, 0x52C9, 0 },
    { 0xFA34, REASON_MUST_CONVERT_1, 0x52E4, 0 },
    { 0xFA35, REASON_MUST_CONVERT_1, 0x5351, 0 },
    { 0xFA36, REASON_MUST_CONVERT_1, 0x559D, 0 },
    { 0xFA37, REASON_MUST_CONVERT_1, 0x5606, 0 },
    { 0xFA38, REASON_MUST_CONVERT_1, 0x5668, 0 },
    { 0xFA39, REASON_MUST_CONVERT_1, 0x5840, 0 },
    { 0xFA3A, REASON_MUST_CONVERT_1, 0x58A8, 0 },
    { 0xFA3B, REASON_MUST_CONVERT_1, 0x5C64, 0 },
    { 0xFA3C, REASON_MUST_CONVERT_1, 0x5C6E, 0 },
    { 0xFA3D, REASON_MUST_CONVERT_1, 0x6094, 0 },
    { 0xFA3E, REASON_MUST_CONVERT_1, 0x6168, 0 },
    { 0xFA3F, REASON_MUST_CONVERT_1, 0x618E, 0 },
    { 0xFA40, REASON_MUST_CONVERT_1, 0x61F2, 0 },
    { 0xFA41, REASON_MUST_CONVERT_1, 0x654F, 0 },
    { 0xFA42, REASON_MUST_CONVERT_1, 0x65E2, 0 },
    { 0xFA43, REASON_MUST_CONVERT_1, 0x6691, 0 },
    { 0xFA44, REASON_MUST_CONVERT_1, 0x6885, 0 },
    { 0xFA45, REASON_MUST_CONVERT_1, 0x6D77, 0 },
    { 0xFA46, REASON_MUST_CONVERT_1, 0x6E1A, 0 },
    { 0xFA47, REASON_MUST_CONVERT_1, 0x6F22, 0 },
    { 0xFA48, REASON_MUST_CONVERT_1, 0x716E, 0 },
    { 0xFA49, REASON_MUST_CONVERT_1, 0x722B, 0 },
    { 0xFA4A, REASON_MUST_CONVERT_1, 0x7422, 0 },
    { 0xFA4B, REASON_MUST_CONVERT_1, 0x7891, 0 },
    { 0xFA4C, REASON_MUST_CONVERT_1, 0x793E, 0 },
    { 0xFA4D, REASON_MUST_CONVERT_1, 0x7949, 0 },
    { 0xFA4E, REASON_MUST_CONVERT_1, 0x7948, 0 },
    { 0xFA4F, REASON_MUST_CONVERT_1, 0x7950, 0 },
    { 0xFA50, REASON_MUST_CONVERT_1, 0x7956, 0 },
    { 0xFA51, REASON_MUST_CONVERT_1, 0x795D, 0 },
    { 0xFA52, REASON_MUST_CONVERT_1, 0x798D, 0 },
    { 0xFA53, REASON_MUST_CONVERT_1, 0x798E, 0 },
    { 0xFA54, REASON_MUST_CONVERT_1, 0x7A40, 0 },
    { 0xFA55, REASON_MUST_CONVERT_1, 0x7A81, 0 },
    { 0xFA56, REASON_MUST_CONVERT_1, 0x7BC0, 0 },
    { 0xFA57, REASON_MUST_CONVERT_1, 0x7DF4, 0 },
    { 0xFA58, REASON_MUST_CONVERT_1, 0x7E09, 0 },
    { 0xFA59, REASON_MUST_CONVERT_1, 0x7E41, 0 },
    { 0xFA5A, REASON_MUST_CONVERT_1, 0x7F72, 0 },
    { 0xFA5B, REASON_MUST_CONVERT_1, 0x8005, 0 },
    { 0xFA5C, REASON_MUST_CONVERT_1, 0x81ED, 0 },
    { 0xFA5D, REASON_MUST_CONVERT_1, 0x8279, 0 },
    { 0xFA5E, REASON_MUST_CONVERT_1, 0x8279, 0 },
    { 0xFA5F, REASON_MUST_CONVERT_1, 0x8457, 0 },
    { 0xFA60, REASON_MUST_CONVERT_1, 0x8910, 0 },
    { 0xFA61, REASON_MUST_CONVERT_1, 0x8996, 0 },
    { 0xFA62, REASON_MUST_CONVERT_1, 0x8B01, 0 },
    { 0xFA63, REASON_MUST_CONVERT_1, 0x8B39, 0 },
    { 0xFA64, REASON_MUST_CONVERT_1, 0x8CD3, 0 },
    { 0xFA65, REASON_MUST_CONVERT_1, 0x8D08, 0 },
    { 0xFA66, REASON_MUST_CONVERT_1, 0x8FB6, 0 },
    { 0xFA67, REASON_MUST_CONVERT_1, 0x9038, 0 },
    { 0xFA68, REASON_MUST_CONVERT_1, 0x96E3, 0 },
    { 0xFA69, REASON_MUST_CONVERT_1, 0x97FF, 0 },
    { 0xFA6A, REASON_MUST_CONVERT_1, 0x983B, 0 },
    { 0xFA6B, REASON_MUST_CONVERT_1, 0x6075, 0 },
    { 0xFA6C, REASON_MUST_CONVERT_1, 0x242EE, 0 },
    { 0xFA6D, REASON_MUST_CONVERT_1, 0x8218, 0 },
    { 0xFA70, REASON_MUST_CONVERT_1, 0x4E26, 0 },
    { 0xFA71, REASON_MUST_CONVERT_1, 0x51B5, 0 },
    { 0xFA72, REASON_MUST_CONVERT_1, 0x5168, 0 },
    { 0xFA73, REASON_MUST_CONVERT_1, 0x4F80, 0 },
    { 0xFA74, REASON_MUST_CONVERT_1, 0x5145, 0 },
    { 0xFA75, REASON_MUST_CONVERT_1, 0x5180, 0 },
    { 0xFA76, REASON_MUST_CONVERT_1, 0x52C7, 0 },
    { 0xFA77, REASON_MUST_CONVERT_1, 0x52FA, 0 },
    { 0xFA78, REASON_MUST_CONVERT_1, 0x559D, 0 },
    { 0xFA79, REASON_MUST_CONVERT_1, 0x5555, 0 },
    { 0xFA7A, REASON_MUST_CONVERT_1, 0x5599, 0 },
    { 0xFA7B, REASON_MUST_CONVERT_1, 0x55E2, 0 },
    { 0xFA7C, REASON_MUST_CONVERT_1, 0x585A, 0 },
    { 0xFA7D, REASON_MUST_CONVERT_1, 0x58B3, 0 },
    { 0xFA7E, REASON_MUST_CONVERT_1, 0x5944, 0 },
    { 0xFA7F, REASON_MUST_CONVERT_1, 0x5954, 0 },
    { 0xFA80, REASON_MUST_CONVERT_1, 0x5A62, 0 },
    { 0xFA81, REASON_MUST_CONVERT_1, 0x5B28, 0 },
    { 0xFA82, REASON_MUST_CONVERT_1, 0x5ED2, 0 },
    { 0xFA83, REASON_MUST_CONVERT_1, 0x5ED9, 0 },
    { 0xFA84, REASON_MUST_CONVERT_1, 0x5F69, 0 },
    { 0xFA85, REASON_MUST_CONVERT_1, 0x5FAD, 0 },
    { 0xFA86, REASON_MUST_CONVERT_1, 0x60D8, 0 },
    { 0xFA87, REASON_MUST_CONVERT_1, 0x614E, 0 },
    { 0xFA88, REASON_MUST_CONVERT_1, 0x6108, 0 },
    { 0xFA89, REASON_MUST_CONVERT_1, 0x618E, 0 },
    { 0xFA8A, REASON_MUST_CONVERT_1, 0x6160, 0 },
    { 0xFA8B, REASON_MUST_CONVERT_1, 0x61F2, 0 },
    { 0xFA8C, REASON_MUST_CONVERT_1, 0x6234, 0 },
    { 0xFA8D, REASON_MUST_CONVERT_1, 0x63C4, 0 },
    { 0xFA8E, REASON_MUST_CONVERT_1, 0x641C, 0 },
    { 0xFA8F, REASON_MUST_CONVERT_1, 0x6452, 0 },
    { 0xFA90, REASON_MUST_CONVERT_1, 0x6556, 0 },
    { 0xFA91, REASON_MUST_CONVERT_1, 0x6674, 0 },
    { 0xFA92, REASON_MUST_CONVERT_1, 0x6717, 0 },
    { 0xFA93, REASON_MUST_CONVERT_1, 0x671B, 0 },
    { 0xFA94, REASON_MUST_CONVERT_1, 0x6756, 0 },
    { 0xFA95, REASON_MUST_CONVERT_1, 0x6B79, 0 },
    { 0xFA96, REASON_MUST_CONVERT_1, 0x6BBA, 0 },
    { 0xFA97, REASON_MUST_CONVERT_1, 0x6D41, 0 },
    { 0xFA98, REASON_MUST_CONVERT_1, 0x6EDB, 0 },
    { 0xFA99, REASON_MUST_CONVERT_1, 0x6ECB, 0 },
    { 0xFA9A, REASON_MUST_CONVERT_1, 0x6F22, 0 },
    { 0xFA9B, REASON_MUST_CONVERT_1, 0x701E, 0 },
    { 0xFA9C, REASON_MUST_CONVERT_1, 0x716E, 0 },
    { 0xFA9D, REASON_MUST_CONVERT_1, 0x77A7, 0 },
    { 0xFA9E, REASON_MUST_CONVERT_1, 0x7235, 0 },
    { 0xFA9F, REASON_MUST_CONVERT_1, 0x72AF, 0 },
    { 0xFAA0, REASON_MUST_CONVERT_1, 0x732A, 0 },
    { 0xFAA1, REASON_MUST_CONVERT_1, 0x7471, 0 },
    { 0xFAA2, REASON_MUST_CONVERT_1, 0x7506, 0 },
    { 0xFAA3, REASON_MUST_CONVERT_1, 0x753B, 0 },
    { 0xFAA4, REASON_MUST_CONVERT_1, 0x761D, 0 },
    { 0xFAA5, REASON_MUST_CONVERT_1, 0x761F, 0 },
    { 0xFAA6, REASON_MUST_CONVERT_1, 0x76CA, 0 },
    { 0xFAA7, REASON_MUST_CONVERT_1, 0x76DB, 0 },
    { 0xFAA8, REASON_MUST_CONVERT_1, 0x76F4, 0 },
    { 0xFAA9, REASON_MUST_CONVERT_1, 0x774A, 0 },
    { 0xFAAA, REASON_MUST_CONVERT_1, 0x7740, 0 },
    { 0xFAAB, REASON_MUST_CONVERT_1, 0x78CC, 0 },
    { 0xFAAC, REASON_MUST_CONVERT_1, 0x7AB1, 0 },
    { 0xFAAD, REASON_MUST_CONVERT_1, 0x7BC0, 0 },
    { 0xFAAE, REASON_MUST_CONVERT_1, 0x7C7B, 0 },
    { 0xFAAF, REASON_MUST_CONVERT_1, 0x7D5B, 0 },
    { 0xFAB0, REASON_MUST_CONVERT_1, 0x7DF4, 0 },
    { 0xFAB1, REASON_MUST_CONVERT_1, 0x7F3E, 0 },
    { 0xFAB2, REASON_MUST_CONVERT_1, 0x8005, 0 },
    { 0xFAB3, REASON_MUST_CONVERT_1, 0x8352, 0 },
    { 0xFAB4, REASON_MUST_CONVERT_1, 0x83EF, 0 },
    { 0xFAB5, REASON_MUST_CONVERT_1, 0x8779, 0 },
    { 0xFAB6, REASON_MUST_CONVERT_1, 0x8941, 0 },
    { 0xFAB7, REASON_MUST_CONVERT_1, 0x8986, 0 },
    { 0xFAB8, REASON_MUST_CONVERT_1, 0x8996, 0 },
    { 0xFAB9, REASON_MUST_CONVERT_1, 0x8ABF, 0 },
    { 0xFABA, REASON_MUST_CONVERT_1, 0x8AF8, 0 },
    { 0xFABB, REASON_MUST_CONVERT_1, 0x8ACB, 0 },
    { 0xFABC, REASON_MUST_CONVERT_1, 0x8B01, 0 },
    { 0xFABD, REASON_MUST_CONVERT_1, 0x8AFE, 0 },
    { 0xFABE, REASON_MUST_CONVERT_1, 0x8AED, 0 },
    { 0xFABF, REASON_MUST_CONVERT_1, 0x8B39, 0 },
    { 0xFAC0, REASON_MUST_CONVERT_1, 0x8B8A, 0 },
    { 0xFAC1, REASON_MUST_CONVERT_1, 0x8D08, 0 },
    { 0xFAC2, REASON_MUST_CONVERT_1, 0x8F38, 0 },
    { 0xFAC3, REASON_MUST_CONVERT_1, 0x9072, 0 },
    { 0xFAC4, REASON_MUST_CONVERT_1, 0x9199, 0 },
    { 0xFAC5, REASON_MUST_CONVERT_1, 0x9276, 0 },
    { 0xFAC6, REASON_MUST_CONVERT_1, 0x967C, 0 },
    { 0xFAC7, REASON_MUST_CONVERT_1, 0x96E3, 0 },
    { 0xFAC8, REASON_MUST_CONVERT_1, 0x9756, 0 },
    { 0xFAC9, REASON_MUST_CONVERT_1, 0x97DB, 0 },
    { 0xFACA, REASON_MUST_CONVERT_1, 0x97FF, 0 },
    { 0xFACB, REASON_MUST_CONVERT_1, 0x980B, 0 },
    { 0xFACC, REASON_MUST_CONVERT_1, 0x983B, 0 },
    { 0xFACD, REASON_MUST_CONVERT_1, 0x9B12, 0 },
    { 0xFACE, REASON_MUST_CONVERT_1, 0x9F9C, 0 },
    { 0xFACF, REASON_MUST_CONVERT_1, 0x2284A, 0 },
    { 0xFAD0, REASON_MUST_CONVERT_1, 0x22844, 0 },
    { 0xFAD1, REASON_MUST_CONVERT_1, 0x233D5, 0 },
    { 0xFAD2, REASON_MUST_CONVERT_1, 0x3B9D, 0 },
    { 0xFAD3, REASON_MUST_CONVERT_1, 0x4018, 0 },
    { 0xFAD4, REASON_MUST_CONVERT_1, 0x4039, 0 },
    { 0xFAD5, REASON_MUST_CONVERT_1, 0x25249, 0 },
    { 0xFAD6, REASON_MUST_CONVERT_1, 0x25CD0, 0 },
    { 0xFAD7, REASON_MUST_CONVERT_1, 0x27ED3, 0 },
    { 0xFAD8, REASON_MUST_CONVERT_1, 0x9F43, 0 },
    { 0xFAD9, REASON_MUST_CONVERT_1, 0x9F8E, 0 },
    { 0xFB1D, REASON_MUST_CONVERT_2, 0x5D9, 0x5B4 },
    { 0xFB1F, REASON_MUST_CONVERT_2, 0x5F2, 0x5B7 },
    { 0xFB2A, REASON_MUST_CONVERT_2, 0x5E9, 0x5C1 },
    { 0xFB2B, REASON_MUST_CONVERT_2, 0x5E9, 0x5C2 },
    { 0xFB2C, REASON_MUST_CONVERT_2, 0xFB49, 0x5C1 },
    { 0xFB2D, REASON_MUST_CONVERT_2, 0xFB49, 0x5C2 },
    { 0xFB2E, REASON_MUST_CONVERT_2, 0x5D0, 0x5B7 },
    { 0xFB2F, REASON_MUST_CONVERT_2, 0x5D0, 0x5B8 },
    { 0xFB30, REASON_MUST_CONVERT_2, 0x5D0, 0x5BC },
    { 0xFB31, REASON_MUST_CONVERT_2, 0x5D1, 0x5BC },
    { 0xFB32, REASON_MUST_CONVERT_2, 0x5D2, 0x5BC },
    { 0xFB33, REASON_MUST_CONVERT_2, 0x5D3, 0x5BC },
    { 0xFB34, REASON_MUST_CONVERT_2, 0x5D4, 0x5BC },
    { 0xFB35, REASON_MUST_CONVERT_2, 0x5D5, 0x5BC },
    { 0xFB36, REASON_MUST_CONVERT_2, 0x5D6, 0x5BC },
    { 0xFB38, REASON_MUST_CONVERT_2, 0x5D8, 0x5BC },
    { 0xFB39, REASON_MUST_CONVERT_2, 0x5D9, 0x5BC },
    { 0xFB3A, REASON_MUST_CONVERT_2, 0x5DA, 0x5BC },
    { 0xFB3B, REASON_MUST_CONVERT_2, 0x5DB, 0x5BC },
    { 0xFB3C, REASON_MUST_CONVERT_2, 0x5DC, 0x5BC },
    { 0xFB3E, REASON_MUST_CONVERT_2, 0x5DE, 0x5BC },
    { 0xFB40, REASON_MUST_CONVERT_2, 0x5E0, 0x5BC },
    { 0xFB41, REASON_MUST_CONVERT_2, 0x5E1, 0x5BC },
    { 0xFB43, REASON_MUST_CONVERT_2, 0x5E3, 0x5BC },
    { 0xFB44, REASON_MUST_CONVERT_2, 0x5E4, 0x5BC },
    { 0xFB46, REASON_MUST_CONVERT_2, 0x5E6, 0x5BC },
    { 0xFB47, REASON_MUST_CONVERT_2, 0x5E7, 0x5BC },
    { 0xFB48, REASON_MUST_CONVERT_2, 0x5E8, 0x5BC },
    { 0xFB49, REASON_MUST_CONVERT_2, 0x5E9, 0x5BC },
    { 0xFB4A, REASON_MUST_CONVERT_2, 0x5EA, 0x5BC },
    { 0xFB4B, REASON_MUST_CONVERT_2, 0x5D5, 0x5B9 },
    { 0xFB4C, REASON_MUST_CONVERT_2, 0x5D1, 0x5BF },
    { 0xFB4D, REASON_MUST_CONVERT_2, 0x5DB, 0x5BF },
    { 0xFB4E, REASON_MUST_CONVERT_2, 0x5E4, 0x5BF },
    { 0x110BA, REASON_COMBINING_MARK, 0, 0 },
    { 0x11127, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0x1133E, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0x11357, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0x114B0, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0x114BA, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0x114BD, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0x115AF, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0x11930, REASON_STARTER_CAN_COMBINE, 0, 0 },
    { 0x1D15E, REASON_MUST_CONVERT_2, 0x1D157, 0x1D165 },
    { 0x1D15F, REASON_MUST_CONVERT_2, 0x1D158, 0x1D165 },
    { 0x1D160, REASON_MUST_CONVERT_2, 0x1D15F, 0x1D16E },
    { 0x1D161, REASON_MUST_CONVERT_2, 0x1D15F, 0x1D16F },
    { 0x1D162, REASON_MUST_CONVERT_2, 0x1D15F, 0x1D170 },
    { 0x1D163, REASON_MUST_CONVERT_2, 0x1D15F, 0x1D171 },
    { 0x1D164, REASON_MUST_CONVERT_2, 0x1D15F, 0x1D172 },
    { 0x1D1BB, REASON_MUST_CONVERT_2, 0x1D1B9, 0x1D165 },
    { 0x1D1BC, REASON_MUST_CONVERT_2, 0x1D1BA, 0x1D165 },
    { 0x1D1BD, REASON_MUST_CONVERT_2, 0x1D1BB, 0x1D16E },
    { 0x1D1BE, REASON_MUST_CONVERT_2, 0x1D1BC, 0x1D16E },
    { 0x1D1BF, REASON_MUST_CONVERT_2, 0x1D1BB, 0x1D16F },
    { 0x1D1C0, REASON_MUST_CONVERT_2, 0x1D1BC, 0x1D16F },
    { 0x2F800, REASON_MUST_CONVERT_1, 0x4E3D, 0 },
    { 0x2F801, REASON_MUST_CONVERT_1, 0x4E38, 0 },
    { 0x2F802, REASON_MUST_CONVERT_1, 0x4E41, 0 },
    { 0x2F803, REASON_MUST_CONVERT_1, 0x20122, 0 },
    { 0x2F804, REASON_MUST_CONVERT_1, 0x4F60, 0 },
    { 0x2F805, REASON_MUST_CONVERT_1, 0x4FAE, 0 },
    { 0x2F806, REASON_MUST_CONVERT_1, 0x4FBB, 0 },
    { 0x2F807, REASON_MUST_CONVERT_1, 0x5002, 0 },
    { 0x2F808, REASON_MUST_CONVERT_1, 0x507A, 0 },
    { 0x2F809, REASON_MUST_CONVERT_1, 0x5099, 0 },
    { 0x2F80A, REASON_MUST_CONVERT_1, 0x50E7, 0 },
    { 0x2F80B, REASON_MUST_CONVERT_1, 0x50CF, 0 },
    { 0x2F80C, REASON_MUST_CONVERT_1, 0x349E, 0 },
    { 0x2F80D, REASON_MUST_CONVERT_1, 0x2063A, 0 },
    { 0x2F80E, REASON_MUST_CONVERT_1, 0x514D, 0 },
    { 0x2F80F, REASON_MUST_CONVERT_1, 0x5154, 0 },
    { 0x2F810, REASON_MUST_CONVERT_1, 0x5164, 0 },
    { 0x2F811, REASON_MUST_CONVERT_1, 0x5177, 0 },
    { 0x2F812, REASON_MUST_CONVERT_1, 0x2051C, 0 },
    { 0x2F813, REASON_MUST_CONVERT_1, 0x34B9, 0 },
    { 0x2F814, REASON_MUST_CONVERT_1, 0x5167, 0 },
    { 0x2F815, REASON_MUST_CONVERT_1, 0x518D, 0 },
    { 0x2F816, REASON_MUST_CONVERT_1, 0x2054B, 0 },
    { 0x2F817, REASON_MUST_CONVERT_1, 0x5197, 0 },
    { 0x2F818, REASON_MUST_CONVERT_1, 0x51A4, 0 },
    { 0x2F819, REASON_MUST_CONVERT_1, 0x4ECC, 0 },
    { 0x2F81A, REASON_MUST_CONVERT_1, 0x51AC, 0 },
    { 0x2F81B, REASON_MUST_CONVERT_1, 0x51B5, 0 },
    { 0x2F81C, REASON_MUST_CONVERT_1, 0x291DF, 0 },
    { 0x2F81D, REASON_MUST_CONVERT_1, 0x51F5, 0 },
    { 0x2F81E, REASON_MUST_CONVERT_1, 0x5203, 0 },
    { 0x2F81F, REASON_MUST_CONVERT_1, 0x34DF, 0 },
    { 0x2F820, REASON_MUST_CONVERT_1, 0x523B, 0 },
    { 0x2F821, REASON_MUST_CONVERT_1, 0x5246, 0 },
    { 0x2F822, REASON_MUST_CONVERT_1, 0x5272, 0 },
    { 0x2F823, REASON_MUST_CONVERT_1, 0x5277, 0 },
    { 0x2F824, REASON_MUST_CONVERT_1, 0x3515, 0 },
    { 0x2F825, REASON_MUST_CONVERT_1, 0x52C7, 0 },
    { 0x2F826, REASON_MUST_CONVERT_1, 0x52C9, 0 },
    { 0x2F827, REASON_MUST_CONVERT_1, 0x52E4, 0 },
    { 0x2F828, REASON_MUST_CONVERT_1, 0x52FA, 0 },
    { 0x2F829, REASON_MUST_CONVERT_1, 0x5305, 0 },
    { 0x2F82A, REASON_MUST_CONVERT_1, 0x5306, 0 },
    { 0x2F82B, REASON_MUST_CONVERT_1, 0x5317, 0 },
    { 0x2F82C, REASON_MUST_CONVERT_1, 0x5349, 0 },
    { 0x2F82D, REASON_MUST_CONVERT_1, 0x5351, 0 },
    { 0x2F82E, REASON_MUST_CONVERT_1, 0x535A, 0 },
    { 0x2F82F, REASON_MUST_CONVERT_1, 0x5373, 0 },
    { 0x2F830, REASON_MUST_CONVERT_1, 0x537D, 0 },
    { 0x2F831, REASON_MUST_CONVERT_1, 0x537F, 0 },
    { 0x2F832, REASON_MUST_CONVERT_1, 0x537F, 0 },
    { 0x2F833, REASON_MUST_CONVERT_1, 0x537F, 0 },
    { 0x2F834, REASON_MUST_CONVERT_1, 0x20A2C, 0 },
    { 0x2F835, REASON_MUST_CONVERT_1, 0x7070, 0 },
    { 0x2F836, REASON_MUST_CONVERT_1, 0x53CA, 0 },
    { 0x2F837, REASON_MUST_CONVERT_1, 0x53DF, 0 },
    { 0x2F838, REASON_MUST_CONVERT_1, 0x20B63, 0 },
    { 0x2F839, REASON_MUST_CONVERT_1, 0x53EB, 0 },
    { 0x2F83A, REASON_MUST_CONVERT_1, 0x53F1, 0 },
    { 0x2F83B, REASON_MUST_CONVERT_1, 0x5406, 0 },
    { 0x2F83C, REASON_MUST_CONVERT_1, 0x549E, 0 },
    { 0x2F83D, REASON_MUST_CONVERT_1, 0x5438, 0 },
    { 0x2F83E, REASON_MUST_CONVERT_1, 0x5448, 0 },
    { 0x2F83F, REASON_MUST_CONVERT_1, 0x5468, 0 },
    { 0x2F840, REASON_MUST_CONVERT_1, 0x54A2, 0 },
    { 0x2F841, REASON_MUST_CONVERT_1, 0x54F6, 0 },
    { 0x2F842, REASON_MUST_CONVERT_1, 0x5510, 0 },
    { 0x2F843, REASON_MUST_CONVERT_1, 0x5553, 0 },
    { 0x2F844, REASON_MUST_CONVERT_1, 0x5563, 0 },
    { 0x2F845, REASON_MUST_CONVERT_1, 0x5584, 0 },
    { 0x2F846, REASON_MUST_CONVERT_1, 0x5584, 0 },
    { 0x2F847, REASON_MUST_CONVERT_1, 0x5599, 0 },
    { 0x2F848, REASON_MUST_CONVERT_1, 0x55AB, 0 },
    { 0x2F849, REASON_MUST_CONVERT_1, 0x55B3, 0 },
    { 0x2F84A, REASON_MUST_CONVERT_1, 0x55C2, 0 },
    { 0x2F84B, REASON_MUST_CONVERT_1, 0x5716, 0 },
    { 0x2F84C, REASON_MUST_CONVERT_1, 0x5606, 0 },
    { 0x2F84D, REASON_MUST_CONVERT_1, 0x5717, 0 },
    { 0x2F84E, REASON_MUST_CONVERT_1, 0x5651, 0 },
    { 0x2F84F, REASON_MUST_CONVERT_1, 0x5674, 0 },
    { 0x2F850, REASON_MUST_CONVERT_1, 0x5207, 0 },
    { 0x2F851, REASON_MUST_CONVERT_1, 0x58EE, 0 },
    { 0x2F852, REASON_MUST_CONVERT_1, 0x57CE, 0 },
    { 0x2F853, REASON_MUST_CONVERT_1, 0x57F4, 0 },
    { 0x2F854, REASON_MUST_CONVERT_1, 0x580D, 0 },
    { 0x2F855, REASON_MUST_CONVERT_1, 0x578B, 0 },
    { 0x2F856, REASON_MUST_CONVERT_1, 0x5832, 0 },
    { 0x2F857, REASON_MUST_CONVERT_1, 0x5831, 0 },
    { 0x2F858, REASON_MUST_CONVERT_1, 0x58AC, 0 },
    { 0x2F859, REASON_MUST_CONVERT_1, 0x214E4, 0 },
    { 0x2F85A, REASON_MUST_CONVERT_1, 0x58F2, 0 },
    { 0x2F85B, REASON_MUST_CONVERT_1, 0x58F7, 0 },
    { 0x2F85C, REASON_MUST_CONVERT_1, 0x5906, 0 },
    { 0x2F85D, REASON_MUST_CONVERT_1, 0x591A, 0 },
    { 0x2F85E, REASON_MUST_CONVERT_1, 0x5922, 0 },
    { 0x2F85F, REASON_MUST_CONVERT_1, 0x5962, 0 },
    { 0x2F860, REASON_MUST_CONVERT_1, 0x216A8, 0 },
    { 0x2F861, REASON_MUST_CONVERT_1, 0x216EA, 0 },
    { 0x2F862, REASON_MUST_CONVERT_1, 0x59EC, 0 },
    { 0x2F863, REASON_MUST_CONVERT_1, 0x5A1B, 0 },
    { 0x2F864, REASON_MUST_CONVERT_1, 0x5A27, 0 },
    { 0x2F865, REASON_MUST_CONVERT_1, 0x59D8, 0 },
    { 0x2F866, REASON_MUST_CONVERT_1, 0x5A66, 0 },
    { 0x2F867, REASON_MUST_CONVERT_1, 0x36EE, 0 },
    { 0x2F868, REASON_MUST_CONVERT_1, 0x36FC, 0 },
    { 0x2F869, REASON_MUST_CONVERT_1, 0x5B08, 0 },
    { 0x2F86A, REASON_MUST_CONVERT_1, 0x5B3E, 0 },
    { 0x2F86B, REASON_MUST_CONVERT_1, 0x5B3E, 0 },
    { 0x2F86C, REASON_MUST_CONVERT_1, 0x219C8, 0 },
    { 0x2F86D, REASON_MUST_CONVERT_1, 0x5BC3, 0 },
    { 0x2F86E, REASON_MUST_CONVERT_1, 0x5BD8, 0 },
    { 0x2F86F, REASON_MUST_CONVERT_1, 0x5BE7, 0 },
    { 0x2F870, REASON_MUST_CONVERT_1, 0x5BF3, 0 },
    { 0x2F871, REASON_MUST_CONVERT_1, 0x21B18, 0 },
    { 0x2F872, REASON_MUST_CONVERT_1, 0x5BFF, 0 },
    { 0x2F873, REASON_MUST_CONVERT_1, 0x5C06, 0 },
    { 0x2F874, REASON_MUST_CONVERT_1, 0x5F53, 0 },
    { 0x2F875, REASON_MUST_CONVERT_1, 0x5C22, 0 },
    { 0x2F876, REASON_MUST_CONVERT_1, 0x3781, 0 },
    { 0x2F877, REASON_MUST_CONVERT_1, 0x5C60, 0 },
    { 0x2F878, REASON_MUST_CONVERT_1, 0x5C6E, 0 },
    { 0x2F879, REASON_MUST_CONVERT_1, 0x5CC0, 0 },
    { 0x2F87A, REASON_MUST_CONVERT_1, 0x5C8D, 0 },
    { 0x2F87B, REASON_MUST_CONVERT_1, 0x21DE4, 0 },
    { 0x2F87C, REASON_MUST_CONVERT_1, 0x5D43, 0 },
    { 0x2F87D, REASON_MUST_CONVERT_1, 0x21DE6, 0 },
    { 0x2F87E, REASON_MUST_CONVERT_1, 0x5D6E, 0 },
    { 0x2F87F, REASON_MUST_CONVERT_1, 0x5D6B, 0 },
    { 0x2F880, REASON_MUST_CONVERT_1, 0x5D7C, 0 },
    { 0x2F881, REASON_MUST_CONVERT_1, 0x5DE1, 0 },
    { 0x2F882, REASON_MUST_CONVERT_1, 0x5DE2, 0 },
    { 0x2F883, REASON_MUST_CONVERT_1, 0x382F, 0 },
    { 0x2F884, REASON_MUST_CONVERT_1, 0x5DFD, 0 },
    { 0x2F885, REASON_MUST_CONVERT_1, 0x5E28, 0 },
    { 0x2F886, REASON_MUST_CONVERT_1, 0x5E3D, 0 },
    { 0x2F887, REASON_MUST_CONVERT_1, 0x5E69, 0 },
    { 0x2F888, REASON_MUST_CONVERT_1, 0x3862, 0 },
    { 0x2F889, REASON_MUST_CONVERT_1, 0x22183, 0 },
    { 0x2F88A, REASON_MUST_CONVERT_1, 0x387C, 0 },
    { 0x2F88B, REASON_MUST_CONVERT_1, 0x5EB0, 0 },
    { 0x2F88C, REASON_MUST_CONVERT_1, 0x5EB3, 0 },
    { 0x2F88D, REASON_MUST_CONVERT_1, 0x5EB6, 0 },
    { 0x2F88E, REASON_MUST_CONVERT_1, 0x5ECA, 0 },
    { 0x2F88F, REASON_MUST_CONVERT_1, 0x2A392, 0 },
    { 0x2F890, REASON_MUST_CONVERT_1, 0x5EFE, 0 },
    { 0x2F891, REASON_MUST_CONVERT_1, 0x22331, 0 },
    { 0x2F892, REASON_MUST_CONVERT_1, 0x22331, 0 },
    { 0x2F893, REASON_MUST_CONVERT_1, 0x8201, 0 },
    { 0x2F894, REASON_MUST_CONVERT_1, 0x5F22, 0 },
    { 0x2F895, REASON_MUST_CONVERT_1, 0x5F22, 0 },
    { 0x2F896, REASON_MUST_CONVERT_1, 0x38C7, 0 },
    { 0x2F897, REASON_MUST_CONVERT_1, 0x232B8, 0 },
    { 0x2F898, REASON_MUST_CONVERT_1, 0x261DA, 0 },
    { 0x2F899, REASON_MUST_CONVERT_1, 0x5F62, 0 },
    { 0x2F89A, REASON_MUST_CONVERT_1, 0x5F6B, 0 },
    { 0x2F89B, REASON_MUST_CONVERT_1, 0x38E3, 0 },
    { 0x2F89C, REASON_MUST_CONVERT_1, 0x5F9A, 0 },
    { 0x2F89D, REASON_MUST_CONVERT_1, 0x5FCD, 0 },
    { 0x2F89E, REASON_MUST_CONVERT_1, 0x5FD7, 0 },
    { 0x2F89F, REASON_MUST_CONVERT_1, 0x5FF9, 0 },
    { 0x2F8A0, REASON_MUST_CONVERT_1, 0x6081, 0 },
    { 0x2F8A1, REASON_MUST_CONVERT_1, 0x393A, 0 },
    { 0x2F8A2, REASON_MUST_CONVERT_1, 0x391C, 0 },
    { 0x2F8A3, REASON_MUST_CONVERT_1, 0x6094, 0 },
    { 0x2F8A4, REASON_MUST_CONVERT_1, 0x226D4, 0 },
    { 0x2F8A5, REASON_MUST_CONVERT_1, 0x60C7, 0 },
    { 0x2F8A6, REASON_MUST_CONVERT_1, 0x6148, 0 },
    { 0x2F8A7, REASON_MUST_CONVERT_1, 0x614C, 0 },
    { 0x2F8A8, REASON_MUST_CONVERT_1, 0x614E, 0 },
    { 0x2F8A9, REASON_MUST_CONVERT_1, 0x614C, 0 },
    { 0x2F8AA, REASON_MUST_CONVERT_1, 0x617A, 0 },
    { 0x2F8AB, REASON_MUST_CONVERT_1, 0x618E, 0 },
    { 0x2F8AC, REASON_MUST_CONVERT_1, 0x61B2, 0 },
    { 0x2F8AD, REASON_MUST_CONVERT_1, 0x61A4, 0 },
    { 0x2F8AE, REASON_MUST_CONVERT_1, 0x61AF, 0 },
    { 0x2F8AF, REASON_MUST_CONVERT_1, 0x61DE, 0 },
    { 0x2F8B0, REASON_MUST_CONVERT_1, 0x61F2, 0 },
    { 0x2F8B1, REASON_MUST_CONVERT_1, 0x61F6, 0 },
    { 0x2F8B2, REASON_MUST_CONVERT_1, 0x6210, 0 },
    { 0x2F8B3, REASON_MUST_CONVERT_1, 0x621B, 0 },
    { 0x2F8B4, REASON_MUST_CONVERT_1, 0x625D, 0 },
    { 0x2F8B5, REASON_MUST_CONVERT_1, 0x62B1, 0 },
    { 0x2F8B6, REASON_MUST_CONVERT_1, 0x62D4, 0 },
    { 0x2F8B7, REASON_MUST_CONVERT_1, 0x6350, 0 },
    { 0x2F8B8, REASON_MUST_CONVERT_1, 0x22B0C, 0 },
    { 0x2F8B9, REASON_MUST_CONVERT_1, 0x633D, 0 },
    { 0x2F8BA, REASON_MUST_CONVERT_1, 0x62FC, 0 },
    { 0x2F8BB, REASON_MUST_CONVERT_1, 0x6368, 0 },
    { 0x2F8BC, REASON_MUST_CONVERT_1, 0x6383, 0 },
    { 0x2F8BD, REASON_MUST_CONVERT_1, 0x63E4, 0 },
    { 0x2F8BE, REASON_MUST_CONVERT_1, 0x22BF1, 0 },
    { 0x2F8BF, REASON_MUST_CONVERT_1, 0x6422, 0 },
    { 0x2F8C0, REASON_MUST_CONVERT_1, 0x63C5, 0 },
    { 0x2F8C1, REASON_MUST_CONVERT_1, 0x63A9, 0 },
    { 0x2F8C2, REASON_MUST_CONVERT_1, 0x3A2E, 0 },
    { 0x2F8C3, REASON_MUST_CONVERT_1, 0x6469, 0 },
    { 0x2F8C4, REASON_MUST_CONVERT_1, 0x647E, 0 },
    { 0x2F8C5, REASON_MUST_CONVERT_1, 0x649D, 0 },
    { 0x2F8C6, REASON_MUST_CONVERT_1, 0x6477, 0 },
    { 0x2F8C7, REASON_MUST_CONVERT_1, 0x3A6C, 0 },
    { 0x2F8C8, REASON_MUST_CONVERT_1, 0x654F, 0 },
    { 0x2F8C9, REASON_MUST_CONVERT_1, 0x656C, 0 },
    { 0x2F8CA, REASON_MUST_CONVERT_1, 0x2300A, 0 },
    { 0x2F8CB, REASON_MUST_CONVERT_1, 0x65E3, 0 },
    { 0x2F8CC, REASON_MUST_CONVERT_1, 0x66F8, 0 },
    { 0x2F8CD, REASON_MUST_CONVERT_1, 0x6649, 0 },
    { 0x2F8CE, REASON_MUST_CONVERT_1, 0x3B19, 0 },
    { 0x2F8CF, REASON_MUST_CONVERT_1, 0x6691, 0 },
    { 0x2F8D0, REASON_MUST_CONVERT_1, 0x3B08, 0 },
    { 0x2F8D1, REASON_MUST_CONVERT_1, 0x3AE4, 0 },
    { 0x2F8D2, REASON_MUST_CONVERT_1, 0x5192, 0 },
    { 0x2F8D3, REASON_MUST_CONVERT_1, 0x5195, 0 },
    { 0x2F8D4, REASON_MUST_CONVERT_1, 0x6700, 0 },
    { 0x2F8D5, REASON_MUST_CONVERT_1, 0x669C, 0 },
    { 0x2F8D6, REASON_MUST_CONVERT_1, 0x80AD, 0 },
    { 0x2F8D7, REASON_MUST_CONVERT_1, 0x43D9, 0 },
    { 0x2F8D8, REASON_MUST_CONVERT_1, 0x6717, 0 },
    { 0x2F8D9, REASON_MUST_CONVERT_1, 0x671B, 0 },
    { 0x2F8DA, REASON_MUST_CONVERT_1, 0x6721, 0 },
    { 0x2F8DB, REASON_MUST_CONVERT_1, 0x675E, 0 },
    { 0x2F8DC, REASON_MUST_CONVERT_1, 0x6753, 0 },
    { 0x2F8DD, REASON_MUST_CONVERT_1, 0x233C3, 0 },
    { 0x2F8DE, REASON_MUST_CONVERT_1, 0x3B49, 0 },
    { 0x2F8DF, REASON_MUST_CONVERT_1, 0x67FA, 0 },
    { 0x2F8E0, REASON_MUST_CONVERT_1, 0x6785, 0 },
    { 0x2F8E1, REASON_MUST_CONVERT_1, 0x6852, 0 },
    { 0x2F8E2, REASON_MUST_CONVERT_1, 0x6885, 0 },
    { 0x2F8E3, REASON_MUST_CONVERT_1, 0x2346D, 0 },
    { 0x2F8E4, REASON_MUST_CONVERT_1, 0x688E, 0 },
    { 0x2F8E5, REASON_MUST_CONVERT_1, 0x681F, 0 },
    { 0x2F8E6, REASON_MUST_CONVERT_1, 0x6914, 0 },
    { 0x2F8E7, REASON_MUST_CONVERT_1, 0x3B9D, 0 },
    { 0x2F8E8, REASON_MUST_CONVERT_1, 0x6942, 0 },
    { 0x2F8E9, REASON_MUST_CONVERT_1, 0x69A3, 0 },
    { 0x2F8EA, REASON_MUST_CONVERT_1, 0x69EA, 0 },
    { 0x2F8EB, REASON_MUST_CONVERT_1, 0x6AA8, 0 },
    { 0x2F8EC, REASON_MUST_CONVERT_1, 0x236A3, 0 },
    { 0x2F8ED, REASON_MUST_CONVERT_1, 0x6ADB, 0 },
    { 0x2F8EE, REASON_MUST_CONVERT_1, 0x3C18, 0 },
    { 0x2F8EF, REASON_MUST_CONVERT_1, 0x6B21, 0 },
    { 0x2F8F0, REASON_MUST_CONVERT_1, 0x238A7, 0 },
    { 0x2F8F1, REASON_MUST_CONVERT_1, 0x6B54, 0 },
    { 0x2F8F2, REASON_MUST_CONVERT_1, 0x3C4E, 0 },
    { 0x2F8F3, REASON_MUST_CONVERT_1, 0x6B72, 0 },
    { 0x2F8F4, REASON_MUST_CONVERT_1, 0x6B9F, 0 },
    { 0x2F8F5, REASON_MUST_CONVERT_1, 0x6BBA, 0 },
    { 0x2F8F6, REASON_MUST_CONVERT_1, 0x6BBB, 0 },
    { 0x2F8F7, REASON_MUST_CONVERT_1, 0x23A8D, 0 },
    { 0x2F8F8, REASON_MUST_CONVERT_1, 0x21D0B, 0 },
    { 0x2F8F9, REASON_MUST_CONVERT_1, 0x23AFA, 0 },
    { 0x2F8FA, REASON_MUST_CONVERT_1, 0x6C4E, 0 },
    { 0x2F8FB, REASON_MUST_CONVERT_1, 0x23CBC, 0 },
    { 0x2F8FC, REASON_MUST_CONVERT_1, 0x6CBF, 0 },
    { 0x2F8FD, REASON_MUST_CONVERT_1, 0x6CCD, 0 },
    { 0x2F8FE, REASON_MUST_CONVERT_1, 0x6C67, 0 },
    { 0x2F8FF, REASON_MUST_CONVERT_1, 0x6D16, 0 },
    { 0x2F900, REASON_MUST_CONVERT_1, 0x6D3E, 0 },
    { 0x2F901, REASON_MUST_CONVERT_1, 0x6D77, 0 },
    { 0x2F902, REASON_MUST_CONVERT_1, 0x6D41, 0 },
    { 0x2F903, REASON_MUST_CONVERT_1, 0x6D69, 0 },
    { 0x2F904, REASON_MUST_CONVERT_1, 0x6D78, 0 },
    { 0x2F905, REASON_MUST_CONVERT_1, 0x6D85, 0 },
    { 0x2F906, REASON_MUST_CONVERT_1, 0x23D1E, 0 },
    { 0x2F907, REASON_MUST_CONVERT_1, 0x6D34, 0 },
    { 0x2F908, REASON_MUST_CONVERT_1, 0x6E2F, 0 },
    { 0x2F909, REASON_MUST_CONVERT_1, 0x6E6E, 0 },
    { 0x2F90A, REASON_MUST_CONVERT_1, 0x3D33, 0 },
    { 0x2F90B, REASON_MUST_CONVERT_1, 0x6ECB, 0 },
    { 0x2F90C, REASON_MUST_CONVERT_1, 0x6EC7, 0 },
    { 0x2F90D, REASON_MUST_CONVERT_1, 0x23ED1, 0 },
    { 0x2F90E, REASON_MUST_CONVERT_1, 0x6DF9, 0 },
    { 0x2F90F, REASON_MUST_CONVERT_1, 0x6F6E, 0 },
    { 0x2F910, REASON_MUST_CONVERT_1, 0x23F5E, 0 },
    { 0x2F911, REASON_MUST_CONVERT_1, 0x23F8E, 0 },
    { 0x2F912, REASON_MUST_CONVERT_1, 0x6FC6, 0 },
    { 0x2F913, REASON_MUST_CONVERT_1, 0x7039, 0 },
    { 0x2F914, REASON_MUST_CONVERT_1, 0x701E, 0 },
    { 0x2F915, REASON_MUST_CONVERT_1, 0x701B, 0 },
    { 0x2F916, REASON_MUST_CONVERT_1, 0x3D96, 0 },
    { 0x2F917, REASON_MUST_CONVERT_1, 0x704A, 0 },
    { 0x2F918, REASON_MUST_CONVERT_1, 0x707D, 0 },
    { 0x2F919, REASON_MUST_CONVERT_1, 0x7077, 0 },
    { 0x2F91A, REASON_MUST_CONVERT_1, 0x70AD, 0 },
    { 0x2F91B, REASON_MUST_CONVERT_1, 0x20525, 0 },
    { 0x2F91C, REASON_MUST_CONVERT_1, 0x7145, 0 },
    { 0x2F91D, REASON_MUST_CONVERT_1, 0x24263, 0 },
    { 0x2F91E, REASON_MUST_CONVERT_1, 0x719C, 0 },
    { 0x2F91F, REASON_MUST_CONVERT_1, 0x243AB, 0 },
    { 0x2F920, REASON_MUST_CONVERT_1, 0x7228, 0 },
    { 0x2F921, REASON_MUST_CONVERT_1, 0x7235, 0 },
    { 0x2F922, REASON_MUST_CONVERT_1, 0x7250, 0 },
    { 0x2F923, REASON_MUST_CONVERT_1, 0x24608, 0 },
    { 0x2F924, REASON_MUST_CONVERT_1, 0x7280, 0 },
    { 0x2F925, REASON_MUST_CONVERT_1, 0x7295, 0 },
    { 0x2F926, REASON_MUST_CONVERT_1, 0x24735, 0 },
    { 0x2F927, REASON_MUST_CONVERT_1, 0x24814, 0 },
    { 0x2F928, REASON_MUST_CONVERT_1, 0x737A, 0 },
    { 0x2F929, REASON_MUST_CONVERT_1, 0x738B, 0 },
    { 0x2F92A, REASON_MUST_CONVERT_1, 0x3EAC, 0 },
    { 0x2F92B, REASON_MUST_CONVERT_1, 0x73A5, 0 },
    { 0x2F92C, REASON_MUST_CONVERT_1, 0x3EB8, 0 },
    { 0x2F92D, REASON_MUST_CONVERT_1, 0x3EB8, 0 },
    { 0x2F92E, REASON_MUST_CONVERT_1, 0x7447, 0 },
    { 0x2F92F, REASON_MUST_CONVERT_1, 0x745C, 0 },
    { 0x2F930, REASON_MUST_CONVERT_1, 0x7471, 0 },
    { 0x2F931, REASON_MUST_CONVERT_1, 0x7485, 0 },
    { 0x2F932, REASON_MUST_CONVERT_1, 0x74CA, 0 },
    { 0x2F933, REASON_MUST_CONVERT_1, 0x3F1B, 0 },
    { 0x2F934, REASON_MUST_CONVERT_1, 0x7524, 0 },
    { 0x2F935, REASON_MUST_CONVERT_1, 0x24C36, 0 },
    { 0x2F936, REASON_MUST_CONVERT_1, 0x753E, 0 },
    { 0x2F937, REASON_MUST_CONVERT_1, 0x24C92, 0 },
    { 0x2F938, REASON_MUST_CONVERT_1, 0x7570, 0 },
    { 0x2F939, REASON_MUST_CONVERT_1, 0x2219F, 0 },
    { 0x2F93A, REASON_MUST_CONVERT_1, 0x7610, 0 },
    { 0x2F93B, REASON_MUST_CONVERT_1, 0x24FA1, 0 },
    { 0x2F93C, REASON_MUST_CONVERT_1, 0x24FB8, 0 },
    { 0x2F93D, REASON_MUST_CONVERT_1, 0x25044, 0 },
    { 0x2F93E, REASON_MUST_CONVERT_1, 0x3FFC, 0 },
    { 0x2F93F, REASON_MUST_CONVERT_1, 0x4008, 0 },
    { 0x2F940, REASON_MUST_CONVERT_1, 0x76F4, 0 },
    { 0x2F941, REASON_MUST_CONVERT_1, 0x250F3, 0 },
    { 0x2F942, REASON_MUST_CONVERT_1, 0x250F2, 0 },
    { 0x2F943, REASON_MUST_CONVERT_1, 0x25119, 0 },
    { 0x2F944, REASON_MUST_CONVERT_1, 0x25133, 0 },
    { 0x2F945, REASON_MUST_CONVERT_1, 0x771E, 0 },
    { 0x2F946, REASON_MUST_CONVERT_1, 0x771F, 0 },
    { 0x2F947, REASON_MUST_CONVERT_1, 0x771F, 0 },
    { 0x2F948, REASON_MUST_CONVERT_1, 0x774A, 0 },
    { 0x2F949, REASON_MUST_CONVERT_1, 0x4039, 0 },
    { 0x2F94A, REASON_MUST_CONVERT_1, 0x778B, 0 },
    { 0x2F94B, REASON_MUST_CONVERT_1, 0x4046, 0 },
    { 0x2F94C, REASON_MUST_CONVERT_1, 0x4096, 0 },
    { 0x2F94D, REASON_MUST_CONVERT_1, 0x2541D, 0 },
    { 0x2F94E, REASON_MUST_CONVERT_1, 0x784E, 0 },
    { 0x2F94F, REASON_MUST_CONVERT_1, 0x788C, 0 },
    { 0x2F950, REASON_MUST_CONVERT_1, 0x78CC, 0 },
    { 0x2F951, REASON_MUST_CONVERT_1, 0x40E3, 0 },
    { 0x2F952, REASON_MUST_CONVERT_1, 0x25626, 0 },
    { 0x2F953, REASON_MUST_CONVERT_1, 0x7956, 0 },
    { 0x2F954, REASON_MUST_CONVERT_1, 0x2569A, 0 },
    { 0x2F955, REASON_MUST_CONVERT_1, 0x256C5, 0 },
    { 0x2F956, REASON_MUST_CONVERT_1, 0x798F, 0 },
    { 0x2F957, REASON_MUST_CONVERT_1, 0x79EB, 0 },
    { 0x2F958, REASON_MUST_CONVERT_1, 0x412F, 0 },
    { 0x2F959, REASON_MUST_CONVERT_1, 0x7A40, 0 },
    { 0x2F95A, REASON_MUST_CONVERT_1, 0x7A4A, 0 },
    { 0x2F95B, REASON_MUST_CONVERT_1, 0x7A4F, 0 },
    { 0x2F95C, REASON_MUST_CONVERT_1, 0x2597C, 0 },
    { 0x2F95D, REASON_MUST_CONVERT_1, 0x25AA7, 0 },
    { 0x2F95E, REASON_MUST_CONVERT_1, 0x25AA7, 0 },
    { 0x2F95F, REASON_MUST_CONVERT_1, 0x7AEE, 0 },
    { 0x2F960, REASON_MUST_CONVERT_1, 0x4202, 0 },
    { 0x2F961, REASON_MUST_CONVERT_1, 0x25BAB, 0 },
    { 0x2F962, REASON_MUST_CONVERT_1, 0x7BC6, 0 },
    { 0x2F963, REASON_MUST_CONVERT_1, 0x7BC9, 0 },
    { 0x2F964, REASON_MUST_CONVERT_1, 0x4227, 0 },
    { 0x2F965, REASON_MUST_CONVERT_1, 0x25C80, 0 },
    { 0x2F966, REASON_MUST_CONVERT_1, 0x7CD2, 0 },
    { 0x2F967, REASON_MUST_CONVERT_1, 0x42A0, 0 },
    { 0x2F968, REASON_MUST_CONVERT_1, 0x7CE8, 0 },
    { 0x2F969, REASON_MUST_CONVERT_1, 0x7CE3, 0 },
    { 0x2F96A, REASON_MUST_CONVERT_1, 0x7D00, 0 },
    { 0x2F96B, REASON_MUST_CONVERT_1, 0x25F86, 0 },
    { 0x2F96C, REASON_MUST_CONVERT_1, 0x7D63, 0 },
    { 0x2F96D, REASON_MUST_CONVERT_1, 0x4301, 0 },
    { 0x2F96E, REASON_MUST_CONVERT_1, 0x7DC7, 0 },
    { 0x2F96F, REASON_MUST_CONVERT_1, 0x7E02, 0 },
    { 0x2F970, REASON_MUST_CONVERT_1, 0x7E45, 0 },
    { 0x2F971, REASON_MUST_CONVERT_1, 0x4334, 0 },
    { 0x2F972, REASON_MUST_CONVERT_1, 0x26228, 0 },
    { 0x2F973, REASON_MUST_CONVERT_1, 0x26247, 0 },
    { 0x2F974, REASON_MUST_CONVERT_1, 0x4359, 0 },
    { 0x2F975, REASON_MUST_CONVERT_1, 0x262D9, 0 },
    { 0x2F976, REASON_MUST_CONVERT_1, 0x7F7A, 0 },
    { 0x2F977, REASON_MUST_CONVERT_1, 0x2633E, 0 },
    { 0x2F978, REASON_MUST_CONVERT_1, 0x7F95, 0 },
    { 0x2F979, REASON_MUST_CONVERT_1, 0x7FFA, 0 },
    { 0x2F97A, REASON_MUST_CONVERT_1, 0x8005, 0 },
    { 0x2F97B, REASON_MUST_CONVERT_1, 0x264DA, 0 },
    { 0x2F97C, REASON_MUST_CONVERT_1, 0x26523, 0 },
    { 0x2F97D, REASON_MUST_CONVERT_1, 0x8060, 0 },
    { 0x2F97E, REASON_MUST_CONVERT_1, 0x265A8, 0 },
    { 0x2F97F, REASON_MUST_CONVERT_1, 0x8070, 0 },
    { 0x2F980, REASON_MUST_CONVERT_1, 0x2335F, 0 },
    { 0x2F981, REASON_MUST_CONVERT_1, 0x43D5, 0 },
    { 0x2F982, REASON_MUST_CONVERT_1, 0x80B2, 0 },
    { 0x2F983, REASON_MUST_CONVERT_1, 0x8103, 0 },
    { 0x2F984, REASON_MUST_CONVERT_1, 0x440B, 0 },
    { 0x2F985, REASON_MUST_CONVERT_1, 0x813E, 0 },
    { 0x2F986, REASON_MUST_CONVERT_1, 0x5AB5, 0 },
    { 0x2F987, REASON_MUST_CONVERT_1, 0x267A7, 0 },
    { 0x2F988, REASON_MUST_CONVERT_1, 0x267B5, 0 },
    { 0x2F989, REASON_MUST_CONVERT_1, 0x23393, 0 },
    { 0x2F98A, REASON_MUST_CONVERT_1, 0x2339C, 0 },
    { 0x2F98B, REASON_MUST_CONVERT_1, 0x8201, 0 },
    { 0x2F98C, REASON_MUST_CONVERT_1, 0x8204, 0 },
    { 0x2F98D, REASON_MUST_CONVERT_1, 0x8F9E, 0 },
    { 0x2F98E, REASON_MUST_CONVERT_1, 0x446B, 0 },
    { 0x2F98F, REASON_MUST_CONVERT_1, 0x8291, 0 },
    { 0x2F990, REASON_MUST_CONVERT_1, 0x828B, 0 },
    { 0x2F991, REASON_MUST_CONVERT_1, 0x829D, 0 },
    { 0x2F992, REASON_MUST_CONVERT_1, 0x52B3, 0 },
    { 0x2F993, REASON_MUST_CONVERT_1, 0x82B1, 0 },
    { 0x2F994, REASON_MUST_CONVERT_1, 0x82B3, 0 },
    { 0x2F995, REASON_MUST_CONVERT_1, 0x82BD, 0 },
    { 0x2F996, REASON_MUST_CONVERT_1, 0x82E6, 0 },
    { 0x2F997, REASON_MUST_CONVERT_1, 0x26B3C, 0 },
    { 0x2F998, REASON_MUST_CONVERT_1, 0x82E5, 0 },
    { 0x2F999, REASON_MUST_CONVERT_1, 0x831D, 0 },
    { 0x2F99A, REASON_MUST_CONVERT_1, 0x8363, 0 },
    { 0x2F99B, REASON_MUST_CONVERT_1, 0x83AD, 0 },
    { 0x2F99C, REASON_MUST_CONVERT_1, 0x8323, 0 },
    { 0x2F99D, REASON_MUST_CONVERT_1, 0x83BD, 0 },
    { 0x2F99E, REASON_MUST_CONVERT_1, 0x83E7, 0 },
    { 0x2F99F, REASON_MUST_CONVERT_1, 0x8457, 0 },
    { 0x2F9A0, REASON_MUST_CONVERT_1, 0x8353, 0 },
    { 0x2F9A1, REASON_MUST_CONVERT_1, 0x83CA, 0 },
    { 0x2F9A2, REASON_MUST_CONVERT_1, 0x83CC, 0 },
    { 0x2F9A3, REASON_MUST_CONVERT_1, 0x83DC, 0 },
    { 0x2F9A4, REASON_MUST_CONVERT_1, 0x26C36, 0 },
    { 0x2F9A5, REASON_MUST_CONVERT_1, 0x26D6B, 0 },
    { 0x2F9A6, REASON_MUST_CONVERT_1, 0x26CD5, 0 },
    { 0x2F9A7, REASON_MUST_CONVERT_1, 0x452B, 0 },
    { 0x2F9A8, REASON_MUST_CONVERT_1, 0x84F1, 0 },
    { 0x2F9A9, REASON_MUST_CONVERT_1, 0x84F3, 0 },
    { 0x2F9AA, REASON_MUST_CONVERT_1, 0x8516, 0 },
    { 0x2F9AB, REASON_MUST_CONVERT_1, 0x273CA, 0 },
    { 0x2F9AC, REASON_MUST_CONVERT_1, 0x8564, 0 },
    { 0x2F9AD, REASON_MUST_CONVERT_1, 0x26F2C, 0 },
    { 0x2F9AE, REASON_MUST_CONVERT_1, 0x455D, 0 },
    { 0x2F9AF, REASON_MUST_CONVERT_1, 0x4561, 0 },
    { 0x2F9B0, REASON_MUST_CONVERT_1, 0x26FB1, 0 },
    { 0x2F9B1, REASON_MUST_CONVERT_1, 0x270D2, 0 },
    { 0x2F9B2, REASON_MUST_CONVERT_1, 0x456B, 0 },
    { 0x2F9B3, REASON_MUST_CONVERT_1, 0x8650, 0 },
    { 0x2F9B4, REASON_MUST_CONVERT_1, 0x865C, 0 },
    { 0x2F9B5, REASON_MUST_CONVERT_1, 0x8667, 0 },
    { 0x2F9B6, REASON_MUST_CONVERT_1, 0x8669, 0 },
    { 0x2F9B7, REASON_MUST_CONVERT_1, 0x86A9, 0 },
    { 0x2F9B8, REASON_MUST_CONVERT_1, 0x8688, 0 },
    { 0x2F9B9, REASON_MUST_CONVERT_1, 0x870E, 0 },
    { 0x2F9BA, REASON_MUST_CONVERT_1, 0x86E2, 0 },
    { 0x2F9BB, REASON_MUST_CONVERT_1, 0x8779, 0 },
    { 0x2F9BC, REASON_MUST_CONVERT_1, 0x8728, 0 },
    { 0x2F9BD, REASON_MUST_CONVERT_1, 0x876B, 0 },
    { 0x2F9BE, REASON_MUST_CONVERT_1, 0x8786, 0 },
    { 0x2F9BF, REASON_MUST_CONVERT_1, 0x45D7, 0 },
    { 0x2F9C0, REASON_MUST_CONVERT_1, 0x87E1, 0 },
    { 0x2F9C1, REASON_MUST_CONVERT_1, 0x8801, 0 },
    { 0x2F9C2, REASON_MUST_CONVERT_1, 0x45F9, 0 },
    { 0x2F9C3, REASON_MUST_CONVERT_1, 0x8860, 0 },
    { 0x2F9C4, REASON_MUST_CONVERT_1, 0x8863, 0 },
    { 0x2F9C5, REASON_MUST_CONVERT_1, 0x27667, 0 },
    { 0x2F9C6, REASON_MUST_CONVERT_1, 0x88D7, 0 },
    { 0x2F9C7, REASON_MUST_CONVERT_1, 0x88DE, 0 },
    { 0x2F9C8, REASON_MUST_CONVERT_1, 0x4635, 0 },
    { 0x2F9C9, REASON_MUST_CONVERT_1, 0x88FA, 0 },
    { 0x2F9CA, REASON_MUST_CONVERT_1, 0x34BB, 0 },
    { 0x2F9CB, REASON_MUST_CONVERT_1, 0x278AE, 0 },
    { 0x2F9CC, REASON_MUST_CONVERT_1, 0x27966, 0 },
    { 0x2F9CD, REASON_MUST_CONVERT_1, 0x46BE, 0 },
    { 0x2F9CE, REASON_MUST_CONVERT_1, 0x46C7, 0 },
    { 0x2F9CF, REASON_MUST_CONVERT_1, 0x8AA0, 0 },
    { 0x2F9D0, REASON_MUST_CONVERT_1, 0x8AED, 0 },
    { 0x2F9D1, REASON_MUST_CONVERT_1, 0x8B8A, 0 },
    { 0x2F9D2, REASON_MUST_CONVERT_1, 0x8C55, 0 },
    { 0x2F9D3, REASON_MUST_CONVERT_1, 0x27CA8, 0 },
    { 0x2F9D4, REASON_MUST_CONVERT_1, 0x8CAB, 0 },
    { 0x2F9D5, REASON_MUST_CONVERT_1, 0x8CC1, 0 },
    { 0x2F9D6, REASON_MUST_CONVERT_1, 0x8D1B, 0 },
    { 0x2F9D7, REASON_MUST_CONVERT_1, 0x8D77, 0 },
    { 0x2F9D8, REASON_MUST_CONVERT_1, 0x27F2F, 0 },
    { 0x2F9D9, REASON_MUST_CONVERT_1, 0x20804, 0 },
    { 0x2F9DA, REASON_MUST_CONVERT_1, 0x8DCB, 0 },
    { 0x2F9DB, REASON_MUST_CONVERT_1, 0x8DBC, 0 },
    { 0x2F9DC, REASON_MUST_CONVERT_1, 0x8DF0, 0 },
    { 0x2F9DD, REASON_MUST_CONVERT_1, 0x208DE, 0 },
    { 0x2F9DE, REASON_MUST_CONVERT_1, 0x8ED4, 0 },
    { 0x2F9DF, REASON_MUST_CONVERT_1, 0x8F38, 0 },
    { 0x2F9E0, REASON_MUST_CONVERT_1, 0x285D2, 0 },
    { 0x2F9E1, REASON_MUST_CONVERT_1, 0x285ED, 0 },
    { 0x2F9E2, REASON_MUST_CONVERT_1, 0x9094, 0 },
    { 0x2F9E3, REASON_MUST_CONVERT_1, 0x90F1, 0 },
    { 0x2F9E4, REASON_MUST_CONVERT_1, 0x9111, 0 },
    { 0x2F9E5, REASON_MUST_CONVERT_1, 0x2872E, 0 },
    { 0x2F9E6, REASON_MUST_CONVERT_1, 0x911B, 0 },
    { 0x2F9E7, REASON_MUST_CONVERT_1, 0x9238, 0 },
    { 0x2F9E8, REASON_MUST_CONVERT_1, 0x92D7, 0 },
    { 0x2F9E9, REASON_MUST_CONVERT_1, 0x92D8, 0 },
    { 0x2F9EA, REASON_MUST_CONVERT_1, 0x927C, 0 },
    { 0x2F9EB, REASON_MUST_CONVERT_1, 0x93F9, 0 },
    { 0x2F9EC, REASON_MUST_CONVERT_1, 0x9415, 0 },
    { 0x2F9ED, REASON_MUST_CONVERT_1, 0x28BFA, 0 },
    { 0x2F9EE, REASON_MUST_CONVERT_1, 0x958B, 0 },
    { 0x2F9EF, REASON_MUST_CONVERT_1, 0x4995, 0 },
    { 0x2F9F0, REASON_MUST_CONVERT_1, 0x95B7, 0 },
    { 0x2F9F1, REASON_MUST_CONVERT_1, 0x28D77, 0 },
    { 0x2F9F2, REASON_MUST_CONVERT_1, 0x49E6, 0 },
    { 0x2F9F3, REASON_MUST_CONVERT_1, 0x96C3, 0 },
    { 0x2F9F4, REASON_MUST_CONVERT_1, 0x5DB2, 0 },
    { 0x2F9F5, REASON_MUST_CONVERT_1, 0x9723, 0 },
    { 0x2F9F6, REASON_MUST_CONVERT_1, 0x29145, 0 },
    { 0x2F9F7, REASON_MUST_CONVERT_1, 0x2921A, 0 },
    { 0x2F9F8, REASON_MUST_CONVERT_1, 0x4A6E, 0 },
    { 0x2F9F9, REASON_MUST_CONVERT_1, 0x4A76, 0 },
    { 0x2F9FA, REASON_MUST_CONVERT_1, 0x97E0, 0 },
    { 0x2F9FB, REASON_MUST_CONVERT_1, 0x2940A, 0 },
    { 0x2F9FC, REASON_MUST_CONVERT_1, 0x4AB2, 0 },
    { 0x2F9FD, REASON_MUST_CONVERT_1, 0x29496, 0 },
    { 0x2F9FE, REASON_MUST_CONVERT_1, 0x980B, 0 },
    { 0x2F9FF, REASON_MUST_CONVERT_1, 0x980B, 0 },
    { 0x2FA00, REASON_MUST_CONVERT_1, 0x9829, 0 },
    { 0x2FA01, REASON_MUST_CONVERT_1, 0x295B6, 0 },
    { 0x2FA02, REASON_MUST_CONVERT_1, 0x98E2, 0 },
    { 0x2FA03, REASON_MUST_CONVERT_1, 0x4B33, 0 },
    { 0x2FA04, REASON_MUST_CONVERT_1, 0x9929, 0 },
    { 0x2FA05, REASON_MUST_CONVERT_1, 0x99A7, 0 },
    { 0x2FA06, REASON_MUST_CONVERT_1, 0x99C2, 0 },
    { 0x2FA07, REASON_MUST_CONVERT_1, 0x99FE, 0 },
    { 0x2FA08, REASON_MUST_CONVERT_1, 0x4BCE, 0 },
    { 0x2FA09, REASON_MUST_CONVERT_1, 0x29B30, 0 },
    { 0x2FA0A, REASON_MUST_CONVERT_1, 0x9B12, 0 },
    { 0x2FA0B, REASON_MUST_CONVERT_1, 0x9C40, 0 },
    { 0x2FA0C, REASON_MUST_CONVERT_1, 0x9CFD, 0 },
    { 0x2FA0D, REASON_MUST_CONVERT_1, 0x4CCE, 0 },
    { 0x2FA0E, REASON_MUST_CONVERT_1, 0x4CED, 0 },
    { 0x2FA0F, REASON_MUST_CONVERT_1, 0x9D67, 0 },
    { 0x2FA10, REASON_MUST_CONVERT_1, 0x2A0CE, 0 },
    { 0x2FA11, REASON_MUST_CONVERT_1, 0x4CF8, 0 },
    { 0x2FA12, REASON_MUST_CONVERT_1, 0x2A105, 0 },
    { 0x2FA13, REASON_MUST_CONVERT_1, 0x2A20E, 0 },
    { 0x2FA14, REASON_MUST_CONVERT_1, 0x2A291, 0 },
    { 0x2FA15, REASON_MUST_CONVERT_1, 0x9EBB, 0 },
    { 0x2FA16, REASON_MUST_CONVERT_1, 0x4D56, 0 },
    { 0x2FA17, REASON_MUST_CONVERT_1, 0x9EF9, 0 },
    { 0x2FA18, REASON_MUST_CONVERT_1, 0x9EFE, 0 },
    { 0x2FA19, REASON_MUST_CONVERT_1, 0x9F05, 0 },
    { 0x2FA1A, REASON_MUST_CONVERT_1, 0x9F0F, 0 },
    { 0x2FA1B, REASON_MUST_CONVERT_1, 0x9F16, 0 },
    { 0x2FA1C, REASON_MUST_CONVERT_1, 0x9F3B, 0 },
    { 0x2FA1D, REASON_MUST_CONVERT_1, 0x2A600, 0 },
};

#endif /* unidata_h */
