﻿#ifndef KEYS_HPP_C9983354_D8EA_4A70_9E16_722A332B503D
#define KEYS_HPP_C9983354_D8EA_4A70_9E16_722A332B503D
#pragma once

/*
keys.hpp

Внутренние фаровские имена клавиш

ВНИМАНИЕ!
  Новые пвсевдоклавиши, типа KEY_FOCUS_CHANGED и KEY_CONSOLE_BUFFER_RESIZE
  добавлять между KEY_END_FKEY и KEY_END_SKEY
*/
/*
Copyright © 1996 Eugene Roshal
Copyright © 2000 Far Group
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the authors may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

// Internal:

// Platform:

// Common:

// External:

//----------------------------------------------------------------------------

constexpr unsigned int
	KEY_CTRLMASK        = 0xFF000000,
	EXTENDED_KEY_BASE   = 0x00010000,
	INTERNAL_KEY_BASE   = 0x00020000,
	INTERNAL_KEY_BASE_2 = 0x00030000,
	INTERNAL_MACRO_BASE = 0x00080000;

enum far_key_code: unsigned int
{
	NO_KEY = 0,

	KEY_CTRL                 =0x01000000,
	KEY_ALT                  =0x02000000,
	KEY_SHIFT                =0x04000000,
	//
	KEY_RCTRL                =0x10000000,
	KEY_RALT                 =0x20000000,
	KEY_RSHIFT               =0x40000000,

	KEY_BRACKET              ='[',
	KEY_BACKBRACKET          =']',
	KEY_COMMA                =',',
	KEY_QUOTE                ='"',
	KEY_DOT                  ='.',
	KEY_SLASH                ='/',
	KEY_COLON                =':',
	KEY_SEMICOLON            =';',
	KEY_BACKSLASH            ='\\',

	KEY_BS                   =0x00000008,
	KEY_TAB                  =0x00000009,
	KEY_ENTER                =0x0000000D,
	KEY_ESC                  =0x0000001B,
	KEY_SPACE                =0x00000020,

	KEY_MASKF                =0x0001FFFF,

	                       // 0x00010000
	KEY_FKEY_BEGIN           =EXTENDED_KEY_BASE,

	KEY_BREAK                =EXTENDED_KEY_BASE+VK_CANCEL,

	KEY_PAUSE                =EXTENDED_KEY_BASE+VK_PAUSE,
	KEY_CAPSLOCK             =EXTENDED_KEY_BASE+VK_CAPITAL,

	KEY_PGUP                 =EXTENDED_KEY_BASE+VK_PRIOR,
	KEY_PGDN                 =EXTENDED_KEY_BASE+VK_NEXT,
	KEY_END                  =EXTENDED_KEY_BASE+VK_END,
	KEY_HOME                 =EXTENDED_KEY_BASE+VK_HOME,
	KEY_LEFT                 =EXTENDED_KEY_BASE+VK_LEFT,
	KEY_UP                   =EXTENDED_KEY_BASE+VK_UP,
	KEY_RIGHT                =EXTENDED_KEY_BASE+VK_RIGHT,
	KEY_DOWN                 =EXTENDED_KEY_BASE+VK_DOWN,
	KEY_PRNTSCRN             =EXTENDED_KEY_BASE+VK_SNAPSHOT,
	KEY_INS                  =EXTENDED_KEY_BASE+VK_INSERT,
	KEY_DEL                  =EXTENDED_KEY_BASE+VK_DELETE,

	KEY_LWIN                 =EXTENDED_KEY_BASE+VK_LWIN,
	KEY_RWIN                 =EXTENDED_KEY_BASE+VK_RWIN,
	KEY_APPS                 =EXTENDED_KEY_BASE+VK_APPS,
	KEY_STANDBY              =EXTENDED_KEY_BASE+VK_SLEEP,

	KEY_NUMPAD0              =EXTENDED_KEY_BASE+VK_NUMPAD0,
	KEY_NUMPAD1              =EXTENDED_KEY_BASE+VK_NUMPAD1,
	KEY_NUMPAD2              =EXTENDED_KEY_BASE+VK_NUMPAD2,
	KEY_NUMPAD3              =EXTENDED_KEY_BASE+VK_NUMPAD3,
	KEY_NUMPAD4              =EXTENDED_KEY_BASE+VK_NUMPAD4,
	KEY_NUMPAD5              =EXTENDED_KEY_BASE+VK_NUMPAD5,
	KEY_CLEAR                =KEY_NUMPAD5,
	KEY_NUMPAD6              =EXTENDED_KEY_BASE+VK_NUMPAD6,
	KEY_NUMPAD7              =EXTENDED_KEY_BASE+VK_NUMPAD7,
	KEY_NUMPAD8              =EXTENDED_KEY_BASE+VK_NUMPAD8,
	KEY_NUMPAD9              =EXTENDED_KEY_BASE+VK_NUMPAD9,

	KEY_MULTIPLY             =EXTENDED_KEY_BASE+VK_MULTIPLY,
	KEY_ADD                  =EXTENDED_KEY_BASE+VK_ADD,
	KEY_SUBTRACT             =EXTENDED_KEY_BASE+VK_SUBTRACT,
	KEY_DECIMAL              =EXTENDED_KEY_BASE+VK_DECIMAL,
	KEY_DIVIDE               =EXTENDED_KEY_BASE+VK_DIVIDE,

	KEY_F1                   =EXTENDED_KEY_BASE+VK_F1,
	KEY_F2                   =EXTENDED_KEY_BASE+VK_F2,
	KEY_F3                   =EXTENDED_KEY_BASE+VK_F3,
	KEY_F4                   =EXTENDED_KEY_BASE+VK_F4,
	KEY_F5                   =EXTENDED_KEY_BASE+VK_F5,
	KEY_F6                   =EXTENDED_KEY_BASE+VK_F6,
	KEY_F7                   =EXTENDED_KEY_BASE+VK_F7,
	KEY_F8                   =EXTENDED_KEY_BASE+VK_F8,
	KEY_F9                   =EXTENDED_KEY_BASE+VK_F9,
	KEY_F10                  =EXTENDED_KEY_BASE+VK_F10,
	KEY_F11                  =EXTENDED_KEY_BASE+VK_F11,
	KEY_F12                  =EXTENDED_KEY_BASE+VK_F12,

	KEY_F13                  =EXTENDED_KEY_BASE+VK_F13,
	KEY_F14                  =EXTENDED_KEY_BASE+VK_F14,
	KEY_F15                  =EXTENDED_KEY_BASE+VK_F15,
	KEY_F16                  =EXTENDED_KEY_BASE+VK_F16,
	KEY_F17                  =EXTENDED_KEY_BASE+VK_F17,
	KEY_F18                  =EXTENDED_KEY_BASE+VK_F18,
	KEY_F19                  =EXTENDED_KEY_BASE+VK_F19,
	KEY_F20                  =EXTENDED_KEY_BASE+VK_F20,
	KEY_F21                  =EXTENDED_KEY_BASE+VK_F21,
	KEY_F22                  =EXTENDED_KEY_BASE+VK_F22,
	KEY_F23                  =EXTENDED_KEY_BASE+VK_F23,
	KEY_F24                  =EXTENDED_KEY_BASE+VK_F24,

	KEY_NUMLOCK              =EXTENDED_KEY_BASE+VK_NUMLOCK,
	KEY_SCROLLLOCK           =EXTENDED_KEY_BASE+VK_SCROLL,

	KEY_BROWSER_BACK         =EXTENDED_KEY_BASE+VK_BROWSER_BACK,
	KEY_BROWSER_FORWARD      =EXTENDED_KEY_BASE+VK_BROWSER_FORWARD,
	KEY_BROWSER_REFRESH      =EXTENDED_KEY_BASE+VK_BROWSER_REFRESH,
	KEY_BROWSER_STOP         =EXTENDED_KEY_BASE+VK_BROWSER_STOP,
	KEY_BROWSER_SEARCH       =EXTENDED_KEY_BASE+VK_BROWSER_SEARCH,
	KEY_BROWSER_FAVORITES    =EXTENDED_KEY_BASE+VK_BROWSER_FAVORITES,
	KEY_BROWSER_HOME         =EXTENDED_KEY_BASE+VK_BROWSER_HOME,
	KEY_VOLUME_MUTE          =EXTENDED_KEY_BASE+VK_VOLUME_MUTE,
	KEY_VOLUME_DOWN          =EXTENDED_KEY_BASE+VK_VOLUME_DOWN,
	KEY_VOLUME_UP            =EXTENDED_KEY_BASE+VK_VOLUME_UP,
	KEY_MEDIA_NEXT_TRACK     =EXTENDED_KEY_BASE+VK_MEDIA_NEXT_TRACK,
	KEY_MEDIA_PREV_TRACK     =EXTENDED_KEY_BASE+VK_MEDIA_PREV_TRACK,
	KEY_MEDIA_STOP           =EXTENDED_KEY_BASE+VK_MEDIA_STOP,
	KEY_MEDIA_PLAY_PAUSE     =EXTENDED_KEY_BASE+VK_MEDIA_PLAY_PAUSE,
	KEY_LAUNCH_MAIL          =EXTENDED_KEY_BASE+VK_LAUNCH_MAIL,
	KEY_LAUNCH_MEDIA_SELECT  =EXTENDED_KEY_BASE+VK_LAUNCH_MEDIA_SELECT,
	KEY_LAUNCH_APP1          =EXTENDED_KEY_BASE+VK_LAUNCH_APP1,
	KEY_LAUNCH_APP2          =EXTENDED_KEY_BASE+VK_LAUNCH_APP2,

	KEY_VK_0xFF_BEGIN        =EXTENDED_KEY_BASE+0x00000100,

//  KEY_HP_INTERNET          =KEY_VK_0xFF_BEGIN+0x00000023,
//  KEY_HP_HOME              =KEY_VK_0xFF_BEGIN+0x0000001F,
//  KEY_HP_SEARCH            =KEY_VK_0xFF_BEGIN+0x0000001A,
//  KEY_HP_MAIL              =KEY_VK_0xFF_BEGIN+0x0000001E,
//  KEY_HP_COMMUNITIES       =KEY_VK_0xFF_BEGIN+0x00000013,
//  KEY_HP_MARKET            =KEY_VK_0xFF_BEGIN+0x00000014,
//  KEY_HP_MEETING           =KEY_VK_0xFF_BEGIN+0x00000015,
//  KEY_HP_NEWS              =KEY_VK_0xFF_BEGIN+0x0000001B,
//
//  KEY_AC_HOME              =KEY_VK_0xFF_BEGIN+0x00000023,
//  KEY_AC_BACK              =KEY_VK_0xFF_BEGIN+0x00000024,
//  KEY_AC_FORWARD           =KEY_VK_0xFF_BEGIN+0x00000025,
//  KEY_AC_STOP              =KEY_VK_0xFF_BEGIN+0x00000026,
//  KEY_AC_REFRESH           =KEY_VK_0xFF_BEGIN+0x00000027,
//  KEY_AC_BOOKMARKS         =KEY_VK_0xFF_BEGIN+0x0000002A,

	KEY_VK_0xFF_END          =EXTENDED_KEY_BASE+0x000001FF,

	KEY_END_FKEY             =0x0001FFFF,

	                       // 0x00020000
	KEY_MSWHEEL_UP           =INTERNAL_KEY_BASE+3,
	KEY_MSWHEEL_DOWN         =INTERNAL_KEY_BASE+4,

	KEY_NUMDEL               =INTERNAL_KEY_BASE+9,
	KEY_NUMENTER             =INTERNAL_KEY_BASE+0xB,

	KEY_MSWHEEL_LEFT         =INTERNAL_KEY_BASE+0xC,
	KEY_MSWHEEL_RIGHT        =INTERNAL_KEY_BASE+0xD,

	KEY_MSLCLICK             =INTERNAL_KEY_BASE+0xF,
	KEY_MSRCLICK             =INTERNAL_KEY_BASE+0x10,

	KEY_MSM1CLICK            =INTERNAL_KEY_BASE+0x11,
	KEY_MSM2CLICK            =INTERNAL_KEY_BASE+0x12,
	KEY_MSM3CLICK            =INTERNAL_KEY_BASE+0x13,

#if 0
	KEY_MSLDBLCLICK          =INTERNAL_KEY_BASE+0x14,
	KEY_MSRDBLCLICK          =INTERNAL_KEY_BASE+0x15,

	KEY_MSM1DBLCLICK         =INTERNAL_KEY_BASE+0x16,
	KEY_MSM2DBLCLICK         =INTERNAL_KEY_BASE+0x17,
	KEY_MSM3DBLCLICK         =INTERNAL_KEY_BASE+0x18,
#endif

	KEY_NONE                 =INTERNAL_KEY_BASE_2+1,

	KEY_DRAGCOPY             =INTERNAL_KEY_BASE_2+3,
	KEY_DRAGMOVE             =INTERNAL_KEY_BASE_2+4,

	KEY_KILLFOCUS            =INTERNAL_KEY_BASE_2+6,
	KEY_GOTFOCUS             =INTERNAL_KEY_BASE_2+7,
	KEY_CONSOLE_BUFFER_RESIZE=INTERNAL_KEY_BASE_2+8,

	KEY_OP_BASE              =INTERNAL_KEY_BASE_2+0x100,
	KEY_OP_XLAT              =KEY_OP_BASE+0,
	KEY_OP_PLAINTEXT         =KEY_OP_BASE+2,
	KEY_OP_SELWORD           =KEY_OP_BASE+3,
	KEY_OP_ENDBASE           =INTERNAL_KEY_BASE_2+0x1FF,

	KEY_END_SKEY             =0x0003FFFF,
	KEY_LAST_BASE            =KEY_END_SKEY,

	// см macroopcode.hpp
	                       // 0x00080000
	KEY_MACRO_BASE           =INTERNAL_MACRO_BASE,
	KEY_MACRO_C_BASE         =INTERNAL_MACRO_BASE+0x0400,     // булевые условия    0x00080400 - 0x000807FF
	KEY_MACRO_V_BASE         =INTERNAL_MACRO_BASE+0x0800,     // разные переменные  0x00080800 - 0x00080BFF
	KEY_MACRO_F_BASE         =INTERNAL_MACRO_BASE+0x0C00,     // функции            0x00080C00 -

	KEY_MACRO_ENDBASE        =0x000FFFFF,

	// Additional

	KEY_CTRLSHIFT            = KEY_CTRL  | KEY_SHIFT,
	KEY_RCTRLSHIFT           = KEY_RCTRL | KEY_SHIFT,
	KEY_ALTSHIFT             = KEY_ALT   | KEY_SHIFT,
	KEY_RALTSHIFT            = KEY_RALT  | KEY_SHIFT,
	KEY_CTRLALT              = KEY_CTRL  | KEY_ALT,
	KEY_CTRLRALT             = KEY_CTRL  | KEY_RALT,
	KEY_RCTRLALT             = KEY_RCTRL | KEY_ALT,
	KEY_RCTRLRALT            = KEY_RCTRL | KEY_RALT,
	KEY_CTRLALTSHIFT         = KEY_CTRL  | KEY_ALT  | KEY_SHIFT,
	KEY_CTRLRALTSHIFT        = KEY_CTRL  | KEY_RALT | KEY_SHIFT,
	KEY_RCTRLALTSHIFT        = KEY_RCTRL | KEY_ALT  | KEY_SHIFT,
	KEY_RCTRLRALTSHIFT       = KEY_RCTRL | KEY_RALT | KEY_SHIFT,

	KEY_CTRL0                =KEY_CTRL+'0',
	KEY_CTRL1                =KEY_CTRL+'1',
	KEY_CTRL2                =KEY_CTRL+'2',
	KEY_CTRL3                =KEY_CTRL+'3',
	KEY_CTRL4                =KEY_CTRL+'4',
	KEY_CTRL5                =KEY_CTRL+'5',
	KEY_CTRL6                =KEY_CTRL+'6',
	KEY_CTRL7                =KEY_CTRL+'7',
	KEY_CTRL8                =KEY_CTRL+'8',
	KEY_CTRL9                =KEY_CTRL+'9',

	KEY_RCTRL0               =KEY_RCTRL+'0',
	KEY_RCTRL1               =KEY_RCTRL+'1',
	KEY_RCTRL2               =KEY_RCTRL+'2',
	KEY_RCTRL3               =KEY_RCTRL+'3',
	KEY_RCTRL4               =KEY_RCTRL+'4',
	KEY_RCTRL5               =KEY_RCTRL+'5',
	KEY_RCTRL6               =KEY_RCTRL+'6',
	KEY_RCTRL7               =KEY_RCTRL+'7',
	KEY_RCTRL8               =KEY_RCTRL+'8',
	KEY_RCTRL9               =KEY_RCTRL+'9',

	KEY_CTRLA                =KEY_CTRL+'A',
	KEY_CTRLB                =KEY_CTRL+'B',
	KEY_CTRLC                =KEY_CTRL+'C',
	KEY_CTRLD                =KEY_CTRL+'D',
	KEY_CTRLE                =KEY_CTRL+'E',
	KEY_CTRLF                =KEY_CTRL+'F',
	KEY_CTRLG                =KEY_CTRL+'G',
	KEY_CTRLH                =KEY_CTRL+'H',
	KEY_CTRLI                =KEY_CTRL+'I',
	KEY_CTRLJ                =KEY_CTRL+'J',
	KEY_CTRLK                =KEY_CTRL+'K',
	KEY_CTRLL                =KEY_CTRL+'L',
	KEY_CTRLM                =KEY_CTRL+'M',
	KEY_CTRLN                =KEY_CTRL+'N',
	KEY_CTRLO                =KEY_CTRL+'O',
	KEY_CTRLP                =KEY_CTRL+'P',
	KEY_CTRLQ                =KEY_CTRL+'Q',
	KEY_CTRLR                =KEY_CTRL+'R',
	KEY_CTRLS                =KEY_CTRL+'S',
	KEY_CTRLT                =KEY_CTRL+'T',
	KEY_CTRLU                =KEY_CTRL+'U',
	KEY_CTRLV                =KEY_CTRL+'V',
	KEY_CTRLW                =KEY_CTRL+'W',
	KEY_CTRLX                =KEY_CTRL+'X',
	KEY_CTRLY                =KEY_CTRL+'Y',
	KEY_CTRLZ                =KEY_CTRL+'Z',

	KEY_RCTRLA               =KEY_RCTRL+'A',
	KEY_RCTRLB               =KEY_RCTRL+'B',
	KEY_RCTRLC               =KEY_RCTRL+'C',
	KEY_RCTRLD               =KEY_RCTRL+'D',
	KEY_RCTRLE               =KEY_RCTRL+'E',
	KEY_RCTRLF               =KEY_RCTRL+'F',
	KEY_RCTRLG               =KEY_RCTRL+'G',
	KEY_RCTRLH               =KEY_RCTRL+'H',
	KEY_RCTRLI               =KEY_RCTRL+'I',
	KEY_RCTRLJ               =KEY_RCTRL+'J',
	KEY_RCTRLK               =KEY_RCTRL+'K',
	KEY_RCTRLL               =KEY_RCTRL+'L',
	KEY_RCTRLM               =KEY_RCTRL+'M',
	KEY_RCTRLN               =KEY_RCTRL+'N',
	KEY_RCTRLO               =KEY_RCTRL+'O',
	KEY_RCTRLP               =KEY_RCTRL+'P',
	KEY_RCTRLQ               =KEY_RCTRL+'Q',
	KEY_RCTRLR               =KEY_RCTRL+'R',
	KEY_RCTRLS               =KEY_RCTRL+'S',
	KEY_RCTRLT               =KEY_RCTRL+'T',
	KEY_RCTRLU               =KEY_RCTRL+'U',
	KEY_RCTRLV               =KEY_RCTRL+'V',
	KEY_RCTRLW               =KEY_RCTRL+'W',
	KEY_RCTRLX               =KEY_RCTRL+'X',
	KEY_RCTRLY               =KEY_RCTRL+'Y',
	KEY_RCTRLZ               =KEY_RCTRL+'Z',

	KEY_CTRLBRACKET          =KEY_CTRL|KEY_BRACKET,
	KEY_CTRLBACKBRACKET      =KEY_CTRL|KEY_BACKBRACKET,
	KEY_CTRLCOMMA            =KEY_CTRL|KEY_COMMA,
	KEY_CTRLQUOTE            =KEY_CTRL|KEY_QUOTE,
	KEY_CTRLDOT              =KEY_CTRL|KEY_DOT,

	KEY_RCTRLBRACKET         =KEY_RCTRL|KEY_BRACKET,
	KEY_RCTRLBACKBRACKET     =KEY_RCTRL|KEY_BACKBRACKET,
	KEY_RCTRLCOMMA           =KEY_RCTRL|KEY_COMMA,
	KEY_RCTRLQUOTE           =KEY_RCTRL|KEY_QUOTE,
	KEY_RCTRLDOT             =KEY_RCTRL|KEY_DOT,

	KEY_ALT0                 =KEY_ALT+'0',
	KEY_ALT1                 =KEY_ALT+'1',
	KEY_ALT2                 =KEY_ALT+'2',
	KEY_ALT3                 =KEY_ALT+'3',
	KEY_ALT4                 =KEY_ALT+'4',
	KEY_ALT5                 =KEY_ALT+'5',
	KEY_ALT6                 =KEY_ALT+'6',
	KEY_ALT7                 =KEY_ALT+'7',
	KEY_ALT8                 =KEY_ALT+'8',
	KEY_ALT9                 =KEY_ALT+'9',

	KEY_ALTADD               =KEY_ALT|KEY_ADD,
	KEY_ALTDOT               =KEY_ALT|KEY_DOT,
	KEY_ALTCOMMA             =KEY_ALT|KEY_COMMA,
	KEY_ALTMULTIPLY          =KEY_ALT|KEY_MULTIPLY,

	KEY_RALTADD              =KEY_RALT|KEY_ADD,
	KEY_RALTDOT              =KEY_RALT|KEY_DOT,
	KEY_RALTCOMMA            =KEY_RALT|KEY_COMMA,
	KEY_RALTMULTIPLY         =KEY_RALT|KEY_MULTIPLY,

	KEY_ALTA                 =KEY_ALT+'A',
	KEY_ALTB                 =KEY_ALT+'B',
	KEY_ALTC                 =KEY_ALT+'C',
	KEY_ALTD                 =KEY_ALT+'D',
	KEY_ALTE                 =KEY_ALT+'E',
	KEY_ALTF                 =KEY_ALT+'F',
	KEY_ALTG                 =KEY_ALT+'G',
	KEY_ALTH                 =KEY_ALT+'H',
	KEY_ALTI                 =KEY_ALT+'I',
	KEY_ALTJ                 =KEY_ALT+'J',
	KEY_ALTK                 =KEY_ALT+'K',
	KEY_ALTL                 =KEY_ALT+'L',
	KEY_ALTM                 =KEY_ALT+'M',
	KEY_ALTN                 =KEY_ALT+'N',
	KEY_ALTO                 =KEY_ALT+'O',
	KEY_ALTP                 =KEY_ALT+'P',
	KEY_ALTQ                 =KEY_ALT+'Q',
	KEY_ALTR                 =KEY_ALT+'R',
	KEY_ALTS                 =KEY_ALT+'S',
	KEY_ALTT                 =KEY_ALT+'T',
	KEY_ALTU                 =KEY_ALT+'U',
	KEY_ALTV                 =KEY_ALT+'V',
	KEY_ALTW                 =KEY_ALT+'W',
	KEY_ALTX                 =KEY_ALT+'X',
	KEY_ALTY                 =KEY_ALT+'Y',
	KEY_ALTZ                 =KEY_ALT+'Z',

	KEY_RALTA                =KEY_RALT+'A',
	KEY_RALTB                =KEY_RALT+'B',
	KEY_RALTC                =KEY_RALT+'C',
	KEY_RALTD                =KEY_RALT+'D',
	KEY_RALTE                =KEY_RALT+'E',
	KEY_RALTF                =KEY_RALT+'F',
	KEY_RALTG                =KEY_RALT+'G',
	KEY_RALTH                =KEY_RALT+'H',
	KEY_RALTI                =KEY_RALT+'I',
	KEY_RALTJ                =KEY_RALT+'J',
	KEY_RALTK                =KEY_RALT+'K',
	KEY_RALTL                =KEY_RALT+'L',
	KEY_RALTM                =KEY_RALT+'M',
	KEY_RALTN                =KEY_RALT+'N',
	KEY_RALTO                =KEY_RALT+'O',
	KEY_RALTP                =KEY_RALT+'P',
	KEY_RALTQ                =KEY_RALT+'Q',
	KEY_RALTR                =KEY_RALT+'R',
	KEY_RALTS                =KEY_RALT+'S',
	KEY_RALTT                =KEY_RALT+'T',
	KEY_RALTU                =KEY_RALT+'U',
	KEY_RALTV                =KEY_RALT+'V',
	KEY_RALTW                =KEY_RALT+'W',
	KEY_RALTX                =KEY_RALT+'X',
	KEY_RALTY                =KEY_RALT+'Y',
	KEY_RALTZ                =KEY_RALT+'Z',

	KEY_CTRLSHIFTADD         =KEY_CTRL|KEY_SHIFT|KEY_ADD,
	KEY_CTRLSHIFTSUBTRACT    =KEY_CTRL|KEY_SHIFT|KEY_SUBTRACT,
	KEY_CTRLSHIFTDOT         =KEY_CTRL|KEY_SHIFT|KEY_DOT,
	KEY_CTRLSHIFTSLASH       =KEY_CTRL|KEY_SHIFT|KEY_SLASH,

	KEY_CTRLSHIFT0           =(KEY_CTRL|KEY_SHIFT)+'0',
	KEY_CTRLSHIFT1           =(KEY_CTRL|KEY_SHIFT)+'1',
	KEY_CTRLSHIFT2           =(KEY_CTRL|KEY_SHIFT)+'2',
	KEY_CTRLSHIFT3           =(KEY_CTRL|KEY_SHIFT)+'3',
	KEY_CTRLSHIFT4           =(KEY_CTRL|KEY_SHIFT)+'4',
	KEY_CTRLSHIFT5           =(KEY_CTRL|KEY_SHIFT)+'5',
	KEY_CTRLSHIFT6           =(KEY_CTRL|KEY_SHIFT)+'6',
	KEY_CTRLSHIFT7           =(KEY_CTRL|KEY_SHIFT)+'7',
	KEY_CTRLSHIFT8           =(KEY_CTRL|KEY_SHIFT)+'8',
	KEY_CTRLSHIFT9           =(KEY_CTRL|KEY_SHIFT)+'9',

	KEY_RCTRLSHIFT0          =KEY_RCTRL+KEY_SHIFT+'0',
	KEY_RCTRLSHIFT1          =KEY_RCTRL+KEY_SHIFT+'1',
	KEY_RCTRLSHIFT2          =KEY_RCTRL+KEY_SHIFT+'2',
	KEY_RCTRLSHIFT3          =KEY_RCTRL+KEY_SHIFT+'3',
	KEY_RCTRLSHIFT4          =KEY_RCTRL+KEY_SHIFT+'4',
	KEY_RCTRLSHIFT5          =KEY_RCTRL+KEY_SHIFT+'5',
	KEY_RCTRLSHIFT6          =KEY_RCTRL+KEY_SHIFT+'6',
	KEY_RCTRLSHIFT7          =KEY_RCTRL+KEY_SHIFT+'7',
	KEY_RCTRLSHIFT8          =KEY_RCTRL+KEY_SHIFT+'8',
	KEY_RCTRLSHIFT9          =KEY_RCTRL+KEY_SHIFT+'9',

	KEY_CTRLSHIFTA           =(KEY_CTRL|KEY_SHIFT)+'A',
	KEY_CTRLSHIFTB           =(KEY_CTRL|KEY_SHIFT)+'B',
	KEY_CTRLSHIFTC           =(KEY_CTRL|KEY_SHIFT)+'C',
	KEY_CTRLSHIFTD           =(KEY_CTRL|KEY_SHIFT)+'D',
	KEY_CTRLSHIFTE           =(KEY_CTRL|KEY_SHIFT)+'E',
	KEY_CTRLSHIFTF           =(KEY_CTRL|KEY_SHIFT)+'F',
	KEY_CTRLSHIFTG           =(KEY_CTRL|KEY_SHIFT)+'G',
	KEY_CTRLSHIFTH           =(KEY_CTRL|KEY_SHIFT)+'H',
	KEY_CTRLSHIFTI           =(KEY_CTRL|KEY_SHIFT)+'I',
	KEY_CTRLSHIFTJ           =(KEY_CTRL|KEY_SHIFT)+'J',
	KEY_CTRLSHIFTK           =(KEY_CTRL|KEY_SHIFT)+'K',
	KEY_CTRLSHIFTL           =(KEY_CTRL|KEY_SHIFT)+'L',
	KEY_CTRLSHIFTM           =(KEY_CTRL|KEY_SHIFT)+'M',
	KEY_CTRLSHIFTN           =(KEY_CTRL|KEY_SHIFT)+'N',
	KEY_CTRLSHIFTO           =(KEY_CTRL|KEY_SHIFT)+'O',
	KEY_CTRLSHIFTP           =(KEY_CTRL|KEY_SHIFT)+'P',
	KEY_CTRLSHIFTQ           =(KEY_CTRL|KEY_SHIFT)+'Q',
	KEY_CTRLSHIFTR           =(KEY_CTRL|KEY_SHIFT)+'R',
	KEY_CTRLSHIFTS           =(KEY_CTRL|KEY_SHIFT)+'S',
	KEY_CTRLSHIFTT           =(KEY_CTRL|KEY_SHIFT)+'T',
	KEY_CTRLSHIFTU           =(KEY_CTRL|KEY_SHIFT)+'U',
	KEY_CTRLSHIFTV           =(KEY_CTRL|KEY_SHIFT)+'V',
	KEY_CTRLSHIFTW           =(KEY_CTRL|KEY_SHIFT)+'W',
	KEY_CTRLSHIFTX           =(KEY_CTRL|KEY_SHIFT)+'X',
	KEY_CTRLSHIFTY           =(KEY_CTRL|KEY_SHIFT)+'Y',
	KEY_CTRLSHIFTZ           =(KEY_CTRL|KEY_SHIFT)+'Z',

	KEY_RCTRLSHIFTA          =(KEY_RCTRL|KEY_SHIFT)+'A',
	KEY_RCTRLSHIFTB          =(KEY_RCTRL|KEY_SHIFT)+'B',
	KEY_RCTRLSHIFTC          =(KEY_RCTRL|KEY_SHIFT)+'C',
	KEY_RCTRLSHIFTD          =(KEY_RCTRL|KEY_SHIFT)+'D',
	KEY_RCTRLSHIFTE          =(KEY_RCTRL|KEY_SHIFT)+'E',
	KEY_RCTRLSHIFTF          =(KEY_RCTRL|KEY_SHIFT)+'F',
	KEY_RCTRLSHIFTG          =(KEY_RCTRL|KEY_SHIFT)+'G',
	KEY_RCTRLSHIFTH          =(KEY_RCTRL|KEY_SHIFT)+'H',
	KEY_RCTRLSHIFTI          =(KEY_RCTRL|KEY_SHIFT)+'I',
	KEY_RCTRLSHIFTJ          =(KEY_RCTRL|KEY_SHIFT)+'J',
	KEY_RCTRLSHIFTK          =(KEY_RCTRL|KEY_SHIFT)+'K',
	KEY_RCTRLSHIFTL          =(KEY_RCTRL|KEY_SHIFT)+'L',
	KEY_RCTRLSHIFTM          =(KEY_RCTRL|KEY_SHIFT)+'M',
	KEY_RCTRLSHIFTN          =(KEY_RCTRL|KEY_SHIFT)+'N',
	KEY_RCTRLSHIFTO          =(KEY_RCTRL|KEY_SHIFT)+'O',
	KEY_RCTRLSHIFTP          =(KEY_RCTRL|KEY_SHIFT)+'P',
	KEY_RCTRLSHIFTQ          =(KEY_RCTRL|KEY_SHIFT)+'Q',
	KEY_RCTRLSHIFTR          =(KEY_RCTRL|KEY_SHIFT)+'R',
	KEY_RCTRLSHIFTS          =(KEY_RCTRL|KEY_SHIFT)+'S',
	KEY_RCTRLSHIFTT          =(KEY_RCTRL|KEY_SHIFT)+'T',
	KEY_RCTRLSHIFTU          =(KEY_RCTRL|KEY_SHIFT)+'U',
	KEY_RCTRLSHIFTV          =(KEY_RCTRL|KEY_SHIFT)+'V',
	KEY_RCTRLSHIFTW          =(KEY_RCTRL|KEY_SHIFT)+'W',
	KEY_RCTRLSHIFTX          =(KEY_RCTRL|KEY_SHIFT)+'X',
	KEY_RCTRLSHIFTY          =(KEY_RCTRL|KEY_SHIFT)+'Y',
	KEY_RCTRLSHIFTZ          =(KEY_RCTRL|KEY_SHIFT)+'Z',

	KEY_CTRLSHIFTBRACKET     =KEY_CTRL|KEY_SHIFT|KEY_BRACKET,
	KEY_CTRLSHIFTBACKSLASH   =KEY_CTRL|KEY_SHIFT|KEY_BACKSLASH,
	KEY_CTRLSHIFTBACKBRACKET =KEY_CTRL|KEY_SHIFT|KEY_BACKBRACKET,

	KEY_RCTRLSHIFTBRACKET    =KEY_RCTRL|KEY_SHIFT|KEY_BRACKET,
	KEY_RCTRLSHIFTBACKSLASH  =KEY_RCTRL|KEY_SHIFT|KEY_BACKSLASH,
	KEY_RCTRLSHIFTBACKBRACKET=KEY_RCTRL|KEY_SHIFT|KEY_BACKBRACKET,

	KEY_ALTSHIFT0            =(KEY_ALT|KEY_SHIFT)+'0',
	KEY_ALTSHIFT1            =(KEY_ALT|KEY_SHIFT)+'1',
	KEY_ALTSHIFT2            =(KEY_ALT|KEY_SHIFT)+'2',
	KEY_ALTSHIFT3            =(KEY_ALT|KEY_SHIFT)+'3',
	KEY_ALTSHIFT4            =(KEY_ALT|KEY_SHIFT)+'4',
	KEY_ALTSHIFT5            =(KEY_ALT|KEY_SHIFT)+'5',
	KEY_ALTSHIFT6            =(KEY_ALT|KEY_SHIFT)+'6',
	KEY_ALTSHIFT7            =(KEY_ALT|KEY_SHIFT)+'7',
	KEY_ALTSHIFT8            =(KEY_ALT|KEY_SHIFT)+'8',
	KEY_ALTSHIFT9            =(KEY_ALT|KEY_SHIFT)+'9',

	KEY_RALTSHIFT0           =(KEY_RALT|KEY_SHIFT)+'0',
	KEY_RALTSHIFT1           =(KEY_RALT|KEY_SHIFT)+'1',
	KEY_RALTSHIFT2           =(KEY_RALT|KEY_SHIFT)+'2',
	KEY_RALTSHIFT3           =(KEY_RALT|KEY_SHIFT)+'3',
	KEY_RALTSHIFT4           =(KEY_RALT|KEY_SHIFT)+'4',
	KEY_RALTSHIFT5           =(KEY_RALT|KEY_SHIFT)+'5',
	KEY_RALTSHIFT6           =(KEY_RALT|KEY_SHIFT)+'6',
	KEY_RALTSHIFT7           =(KEY_RALT|KEY_SHIFT)+'7',
	KEY_RALTSHIFT8           =(KEY_RALT|KEY_SHIFT)+'8',
	KEY_RALTSHIFT9           =(KEY_RALT|KEY_SHIFT)+'9',

	KEY_ALTSHIFTA            =(KEY_ALT|KEY_SHIFT)+'A',
	KEY_ALTSHIFTB            =(KEY_ALT|KEY_SHIFT)+'B',
	KEY_ALTSHIFTC            =(KEY_ALT|KEY_SHIFT)+'C',
	KEY_ALTSHIFTD            =(KEY_ALT|KEY_SHIFT)+'D',
	KEY_ALTSHIFTE            =(KEY_ALT|KEY_SHIFT)+'E',
	KEY_ALTSHIFTF            =(KEY_ALT|KEY_SHIFT)+'F',
	KEY_ALTSHIFTG            =(KEY_ALT|KEY_SHIFT)+'G',
	KEY_ALTSHIFTH            =(KEY_ALT|KEY_SHIFT)+'H',
	KEY_ALTSHIFTI            =(KEY_ALT|KEY_SHIFT)+'I',
	KEY_ALTSHIFTJ            =(KEY_ALT|KEY_SHIFT)+'J',
	KEY_ALTSHIFTK            =(KEY_ALT|KEY_SHIFT)+'K',
	KEY_ALTSHIFTL            =(KEY_ALT|KEY_SHIFT)+'L',
	KEY_ALTSHIFTM            =(KEY_ALT|KEY_SHIFT)+'M',
	KEY_ALTSHIFTN            =(KEY_ALT|KEY_SHIFT)+'N',
	KEY_ALTSHIFTO            =(KEY_ALT|KEY_SHIFT)+'O',
	KEY_ALTSHIFTP            =(KEY_ALT|KEY_SHIFT)+'P',
	KEY_ALTSHIFTQ            =(KEY_ALT|KEY_SHIFT)+'Q',
	KEY_ALTSHIFTR            =(KEY_ALT|KEY_SHIFT)+'R',
	KEY_ALTSHIFTS            =(KEY_ALT|KEY_SHIFT)+'S',
	KEY_ALTSHIFTT            =(KEY_ALT|KEY_SHIFT)+'T',
	KEY_ALTSHIFTU            =(KEY_ALT|KEY_SHIFT)+'U',
	KEY_ALTSHIFTV            =(KEY_ALT|KEY_SHIFT)+'V',
	KEY_ALTSHIFTW            =(KEY_ALT|KEY_SHIFT)+'W',
	KEY_ALTSHIFTX            =(KEY_ALT|KEY_SHIFT)+'X',
	KEY_ALTSHIFTY            =(KEY_ALT|KEY_SHIFT)+'Y',
	KEY_ALTSHIFTZ            =(KEY_ALT|KEY_SHIFT)+'Z',

	KEY_RALTSHIFTA           =(KEY_RALT|KEY_SHIFT)+'A',
	KEY_RALTSHIFTB           =(KEY_RALT|KEY_SHIFT)+'B',
	KEY_RALTSHIFTC           =(KEY_RALT|KEY_SHIFT)+'C',
	KEY_RALTSHIFTD           =(KEY_RALT|KEY_SHIFT)+'D',
	KEY_RALTSHIFTE           =(KEY_RALT|KEY_SHIFT)+'E',
	KEY_RALTSHIFTF           =(KEY_RALT|KEY_SHIFT)+'F',
	KEY_RALTSHIFTG           =(KEY_RALT|KEY_SHIFT)+'G',
	KEY_RALTSHIFTH           =(KEY_RALT|KEY_SHIFT)+'H',
	KEY_RALTSHIFTI           =(KEY_RALT|KEY_SHIFT)+'I',
	KEY_RALTSHIFTJ           =(KEY_RALT|KEY_SHIFT)+'J',
	KEY_RALTSHIFTK           =(KEY_RALT|KEY_SHIFT)+'K',
	KEY_RALTSHIFTL           =(KEY_RALT|KEY_SHIFT)+'L',
	KEY_RALTSHIFTM           =(KEY_RALT|KEY_SHIFT)+'M',
	KEY_RALTSHIFTN           =(KEY_RALT|KEY_SHIFT)+'N',
	KEY_RALTSHIFTO           =(KEY_RALT|KEY_SHIFT)+'O',
	KEY_RALTSHIFTP           =(KEY_RALT|KEY_SHIFT)+'P',
	KEY_RALTSHIFTQ           =(KEY_RALT|KEY_SHIFT)+'Q',
	KEY_RALTSHIFTR           =(KEY_RALT|KEY_SHIFT)+'R',
	KEY_RALTSHIFTS           =(KEY_RALT|KEY_SHIFT)+'S',
	KEY_RALTSHIFTT           =(KEY_RALT|KEY_SHIFT)+'T',
	KEY_RALTSHIFTU           =(KEY_RALT|KEY_SHIFT)+'U',
	KEY_RALTSHIFTV           =(KEY_RALT|KEY_SHIFT)+'V',
	KEY_RALTSHIFTW           =(KEY_RALT|KEY_SHIFT)+'W',
	KEY_RALTSHIFTX           =(KEY_RALT|KEY_SHIFT)+'X',
	KEY_RALTSHIFTY           =(KEY_RALT|KEY_SHIFT)+'Y',
	KEY_RALTSHIFTZ           =(KEY_RALT|KEY_SHIFT)+'Z',

	KEY_ALTSHIFTBRACKET      =KEY_ALT|KEY_SHIFT|KEY_BRACKET,
	KEY_ALTSHIFTBACKBRACKET  =KEY_ALT|KEY_SHIFT|KEY_BACKBRACKET,
	KEY_RALTSHIFTBRACKET     =KEY_RALT|KEY_SHIFT|KEY_BRACKET,
	KEY_RALTSHIFTBACKBRACKET =KEY_RALT|KEY_SHIFT|KEY_BACKBRACKET,

	KEY_CTRLALT0             =(KEY_CTRL|KEY_ALT)+'0',
	KEY_CTRLALT1             =(KEY_CTRL|KEY_ALT)+'1',
	KEY_CTRLALT2             =(KEY_CTRL|KEY_ALT)+'2',
	KEY_CTRLALT3             =(KEY_CTRL|KEY_ALT)+'3',
	KEY_CTRLALT4             =(KEY_CTRL|KEY_ALT)+'4',
	KEY_CTRLALT5             =(KEY_CTRL|KEY_ALT)+'5',
	KEY_CTRLALT6             =(KEY_CTRL|KEY_ALT)+'6',
	KEY_CTRLALT7             =(KEY_CTRL|KEY_ALT)+'7',
	KEY_CTRLALT8             =(KEY_CTRL|KEY_ALT)+'8',
	KEY_CTRLALT9             =(KEY_CTRL|KEY_ALT)+'9',

	KEY_RCTRLRALT0           =(KEY_RCTRL|KEY_RALT)+'0',
	KEY_RCTRLRALT1           =(KEY_RCTRL|KEY_RALT)+'1',
	KEY_RCTRLRALT2           =(KEY_RCTRL|KEY_RALT)+'2',
	KEY_RCTRLRALT3           =(KEY_RCTRL|KEY_RALT)+'3',
	KEY_RCTRLRALT4           =(KEY_RCTRL|KEY_RALT)+'4',
	KEY_RCTRLRALT5           =(KEY_RCTRL|KEY_RALT)+'5',
	KEY_RCTRLRALT6           =(KEY_RCTRL|KEY_RALT)+'6',
	KEY_RCTRLRALT7           =(KEY_RCTRL|KEY_RALT)+'7',
	KEY_RCTRLRALT8           =(KEY_RCTRL|KEY_RALT)+'8',
	KEY_RCTRLRALT9           =(KEY_RCTRL|KEY_RALT)+'9',

	KEY_CTRLRALT0            =(KEY_CTRL|KEY_RALT)+'0',
	KEY_CTRLRALT1            =(KEY_CTRL|KEY_RALT)+'1',
	KEY_CTRLRALT2            =(KEY_CTRL|KEY_RALT)+'2',
	KEY_CTRLRALT3            =(KEY_CTRL|KEY_RALT)+'3',
	KEY_CTRLRALT4            =(KEY_CTRL|KEY_RALT)+'4',
	KEY_CTRLRALT5            =(KEY_CTRL|KEY_RALT)+'5',
	KEY_CTRLRALT6            =(KEY_CTRL|KEY_RALT)+'6',
	KEY_CTRLRALT7            =(KEY_CTRL|KEY_RALT)+'7',
	KEY_CTRLRALT8            =(KEY_CTRL|KEY_RALT)+'8',
	KEY_CTRLRALT9            =(KEY_CTRL|KEY_RALT)+'9',

	KEY_RCTRLALT0            =(KEY_RCTRL|KEY_ALT)+'0',
	KEY_RCTRLALT1            =(KEY_RCTRL|KEY_ALT)+'1',
	KEY_RCTRLALT2            =(KEY_RCTRL|KEY_ALT)+'2',
	KEY_RCTRLALT3            =(KEY_RCTRL|KEY_ALT)+'3',
	KEY_RCTRLALT4            =(KEY_RCTRL|KEY_ALT)+'4',
	KEY_RCTRLALT5            =(KEY_RCTRL|KEY_ALT)+'5',
	KEY_RCTRLALT6            =(KEY_RCTRL|KEY_ALT)+'6',
	KEY_RCTRLALT7            =(KEY_RCTRL|KEY_ALT)+'7',
	KEY_RCTRLALT8            =(KEY_RCTRL|KEY_ALT)+'8',
	KEY_RCTRLALT9            =(KEY_RCTRL|KEY_ALT)+'9',

	KEY_CTRLALTA             =(KEY_CTRL|KEY_ALT)+'A',
	KEY_CTRLALTB             =(KEY_CTRL|KEY_ALT)+'B',
	KEY_CTRLALTC             =(KEY_CTRL|KEY_ALT)+'C',
	KEY_CTRLALTD             =(KEY_CTRL|KEY_ALT)+'D',
	KEY_CTRLALTE             =(KEY_CTRL|KEY_ALT)+'E',
	KEY_CTRLALTF             =(KEY_CTRL|KEY_ALT)+'F',
	KEY_CTRLALTG             =(KEY_CTRL|KEY_ALT)+'G',
	KEY_CTRLALTH             =(KEY_CTRL|KEY_ALT)+'H',
	KEY_CTRLALTI             =(KEY_CTRL|KEY_ALT)+'I',
	KEY_CTRLALTJ             =(KEY_CTRL|KEY_ALT)+'J',
	KEY_CTRLALTK             =(KEY_CTRL|KEY_ALT)+'K',
	KEY_CTRLALTL             =(KEY_CTRL|KEY_ALT)+'L',
	KEY_CTRLALTM             =(KEY_CTRL|KEY_ALT)+'M',
	KEY_CTRLALTN             =(KEY_CTRL|KEY_ALT)+'N',
	KEY_CTRLALTO             =(KEY_CTRL|KEY_ALT)+'O',
	KEY_CTRLALTP             =(KEY_CTRL|KEY_ALT)+'P',
	KEY_CTRLALTQ             =(KEY_CTRL|KEY_ALT)+'Q',
	KEY_CTRLALTR             =(KEY_CTRL|KEY_ALT)+'R',
	KEY_CTRLALTS             =(KEY_CTRL|KEY_ALT)+'S',
	KEY_CTRLALTT             =(KEY_CTRL|KEY_ALT)+'T',
	KEY_CTRLALTU             =(KEY_CTRL|KEY_ALT)+'U',
	KEY_CTRLALTV             =(KEY_CTRL|KEY_ALT)+'V',
	KEY_CTRLALTW             =(KEY_CTRL|KEY_ALT)+'W',
	KEY_CTRLALTX             =(KEY_CTRL|KEY_ALT)+'X',
	KEY_CTRLALTY             =(KEY_CTRL|KEY_ALT)+'Y',
	KEY_CTRLALTZ             =(KEY_CTRL|KEY_ALT)+'Z',

	KEY_RCTRLRALTA           =(KEY_RCTRL|KEY_RALT)+'A',
	KEY_RCTRLRALTB           =(KEY_RCTRL|KEY_RALT)+'B',
	KEY_RCTRLRALTC           =(KEY_RCTRL|KEY_RALT)+'C',
	KEY_RCTRLRALTD           =(KEY_RCTRL|KEY_RALT)+'D',
	KEY_RCTRLRALTE           =(KEY_RCTRL|KEY_RALT)+'E',
	KEY_RCTRLRALTF           =(KEY_RCTRL|KEY_RALT)+'F',
	KEY_RCTRLRALTG           =(KEY_RCTRL|KEY_RALT)+'G',
	KEY_RCTRLRALTH           =(KEY_RCTRL|KEY_RALT)+'H',
	KEY_RCTRLRALTI           =(KEY_RCTRL|KEY_RALT)+'I',
	KEY_RCTRLRALTJ           =(KEY_RCTRL|KEY_RALT)+'J',
	KEY_RCTRLRALTK           =(KEY_RCTRL|KEY_RALT)+'K',
	KEY_RCTRLRALTL           =(KEY_RCTRL|KEY_RALT)+'L',
	KEY_RCTRLRALTM           =(KEY_RCTRL|KEY_RALT)+'M',
	KEY_RCTRLRALTN           =(KEY_RCTRL|KEY_RALT)+'N',
	KEY_RCTRLRALTO           =(KEY_RCTRL|KEY_RALT)+'O',
	KEY_RCTRLRALTP           =(KEY_RCTRL|KEY_RALT)+'P',
	KEY_RCTRLRALTQ           =(KEY_RCTRL|KEY_RALT)+'Q',
	KEY_RCTRLRALTR           =(KEY_RCTRL|KEY_RALT)+'R',
	KEY_RCTRLRALTS           =(KEY_RCTRL|KEY_RALT)+'S',
	KEY_RCTRLRALTT           =(KEY_RCTRL|KEY_RALT)+'T',
	KEY_RCTRLRALTU           =(KEY_RCTRL|KEY_RALT)+'U',
	KEY_RCTRLRALTV           =(KEY_RCTRL|KEY_RALT)+'V',
	KEY_RCTRLRALTW           =(KEY_RCTRL|KEY_RALT)+'W',
	KEY_RCTRLRALTX           =(KEY_RCTRL|KEY_RALT)+'X',
	KEY_RCTRLRALTY           =(KEY_RCTRL|KEY_RALT)+'Y',
	KEY_RCTRLRALTZ           =(KEY_RCTRL|KEY_RALT)+'Z',

	KEY_CTRLRALTA            =(KEY_CTRL|KEY_RALT)+'A',
	KEY_CTRLRALTB            =(KEY_CTRL|KEY_RALT)+'B',
	KEY_CTRLRALTC            =(KEY_CTRL|KEY_RALT)+'C',
	KEY_CTRLRALTD            =(KEY_CTRL|KEY_RALT)+'D',
	KEY_CTRLRALTE            =(KEY_CTRL|KEY_RALT)+'E',
	KEY_CTRLRALTF            =(KEY_CTRL|KEY_RALT)+'F',
	KEY_CTRLRALTG            =(KEY_CTRL|KEY_RALT)+'G',
	KEY_CTRLRALTH            =(KEY_CTRL|KEY_RALT)+'H',
	KEY_CTRLRALTI            =(KEY_CTRL|KEY_RALT)+'I',
	KEY_CTRLRALTJ            =(KEY_CTRL|KEY_RALT)+'J',
	KEY_CTRLRALTK            =(KEY_CTRL|KEY_RALT)+'K',
	KEY_CTRLRALTL            =(KEY_CTRL|KEY_RALT)+'L',
	KEY_CTRLRALTM            =(KEY_CTRL|KEY_RALT)+'M',
	KEY_CTRLRALTN            =(KEY_CTRL|KEY_RALT)+'N',
	KEY_CTRLRALTO            =(KEY_CTRL|KEY_RALT)+'O',
	KEY_CTRLRALTP            =(KEY_CTRL|KEY_RALT)+'P',
	KEY_CTRLRALTQ            =(KEY_CTRL|KEY_RALT)+'Q',
	KEY_CTRLRALTR            =(KEY_CTRL|KEY_RALT)+'R',
	KEY_CTRLRALTS            =(KEY_CTRL|KEY_RALT)+'S',
	KEY_CTRLRALTT            =(KEY_CTRL|KEY_RALT)+'T',
	KEY_CTRLRALTU            =(KEY_CTRL|KEY_RALT)+'U',
	KEY_CTRLRALTV            =(KEY_CTRL|KEY_RALT)+'V',
	KEY_CTRLRALTW            =(KEY_CTRL|KEY_RALT)+'W',
	KEY_CTRLRALTX            =(KEY_CTRL|KEY_RALT)+'X',
	KEY_CTRLRALTY            =(KEY_CTRL|KEY_RALT)+'Y',
	KEY_CTRLRALTZ            =(KEY_CTRL|KEY_RALT)+'Z',

	KEY_RCTRLALTA            =(KEY_RCTRL|KEY_ALT)+'A',
	KEY_RCTRLALTB            =(KEY_RCTRL|KEY_ALT)+'B',
	KEY_RCTRLALTC            =(KEY_RCTRL|KEY_ALT)+'C',
	KEY_RCTRLALTD            =(KEY_RCTRL|KEY_ALT)+'D',
	KEY_RCTRLALTE            =(KEY_RCTRL|KEY_ALT)+'E',
	KEY_RCTRLALTF            =(KEY_RCTRL|KEY_ALT)+'F',
	KEY_RCTRLALTG            =(KEY_RCTRL|KEY_ALT)+'G',
	KEY_RCTRLALTH            =(KEY_RCTRL|KEY_ALT)+'H',
	KEY_RCTRLALTI            =(KEY_RCTRL|KEY_ALT)+'I',
	KEY_RCTRLALTJ            =(KEY_RCTRL|KEY_ALT)+'J',
	KEY_RCTRLALTK            =(KEY_RCTRL|KEY_ALT)+'K',
	KEY_RCTRLALTL            =(KEY_RCTRL|KEY_ALT)+'L',
	KEY_RCTRLALTM            =(KEY_RCTRL|KEY_ALT)+'M',
	KEY_RCTRLALTN            =(KEY_RCTRL|KEY_ALT)+'N',
	KEY_RCTRLALTO            =(KEY_RCTRL|KEY_ALT)+'O',
	KEY_RCTRLALTP            =(KEY_RCTRL|KEY_ALT)+'P',
	KEY_RCTRLALTQ            =(KEY_RCTRL|KEY_ALT)+'Q',
	KEY_RCTRLALTR            =(KEY_RCTRL|KEY_ALT)+'R',
	KEY_RCTRLALTS            =(KEY_RCTRL|KEY_ALT)+'S',
	KEY_RCTRLALTT            =(KEY_RCTRL|KEY_ALT)+'T',
	KEY_RCTRLALTU            =(KEY_RCTRL|KEY_ALT)+'U',
	KEY_RCTRLALTV            =(KEY_RCTRL|KEY_ALT)+'V',
	KEY_RCTRLALTW            =(KEY_RCTRL|KEY_ALT)+'W',
	KEY_RCTRLALTX            =(KEY_RCTRL|KEY_ALT)+'X',
	KEY_RCTRLALTY            =(KEY_RCTRL|KEY_ALT)+'Y',
	KEY_RCTRLALTZ            =(KEY_RCTRL|KEY_ALT)+'Z',

	KEY_CTRLALTBRACKET       =KEY_CTRL|KEY_ALT|KEY_BRACKET,
	KEY_CTRLALTBACKBRACKET   =KEY_CTRL|KEY_ALT|KEY_BACKBRACKET,
	KEY_RCTRLRALTBRACKET     =KEY_RCTRL|KEY_RALT|KEY_BRACKET,
	KEY_RCTRLRALTBACKBRACKET =KEY_RCTRL|KEY_RALT|KEY_BACKBRACKET,
	KEY_CTRLRALTBRACKET      =KEY_CTRL|KEY_RALT|KEY_BRACKET,
	KEY_CTRLRALTBACKBRACKET  =KEY_CTRL|KEY_RALT|KEY_BACKBRACKET,
	KEY_RCTRLALTBRACKET      =KEY_RCTRL|KEY_ALT|KEY_BRACKET,
	KEY_RCTRLALTBACKBRACKET  =KEY_RCTRL|KEY_ALT|KEY_BACKBRACKET,

	KEY_CTRLF1               =KEY_CTRL|KEY_F1,
	KEY_CTRLF2               =KEY_CTRL|KEY_F2,
	KEY_CTRLF3               =KEY_CTRL|KEY_F3,
	KEY_CTRLF4               =KEY_CTRL|KEY_F4,
	KEY_CTRLF5               =KEY_CTRL|KEY_F5,
	KEY_CTRLF6               =KEY_CTRL|KEY_F6,
	KEY_CTRLF7               =KEY_CTRL|KEY_F7,
	KEY_CTRLF8               =KEY_CTRL|KEY_F8,
	KEY_CTRLF9               =KEY_CTRL|KEY_F9,
	KEY_CTRLF10              =KEY_CTRL|KEY_F10,
	KEY_CTRLF11              =KEY_CTRL|KEY_F11,
	KEY_CTRLF12              =KEY_CTRL|KEY_F12,

	KEY_RCTRLF1              =KEY_RCTRL|KEY_F1,
	KEY_RCTRLF2              =KEY_RCTRL|KEY_F2,
	KEY_RCTRLF3              =KEY_RCTRL|KEY_F3,
	KEY_RCTRLF4              =KEY_RCTRL|KEY_F4,
	KEY_RCTRLF5              =KEY_RCTRL|KEY_F5,
	KEY_RCTRLF6              =KEY_RCTRL|KEY_F6,
	KEY_RCTRLF7              =KEY_RCTRL|KEY_F7,
	KEY_RCTRLF8              =KEY_RCTRL|KEY_F8,
	KEY_RCTRLF9              =KEY_RCTRL|KEY_F9,
	KEY_RCTRLF10             =KEY_RCTRL|KEY_F10,
	KEY_RCTRLF11             =KEY_RCTRL|KEY_F11,
	KEY_RCTRLF12             =KEY_RCTRL|KEY_F12,

	KEY_SHIFTF1              =KEY_SHIFT|KEY_F1,
	KEY_SHIFTF2              =KEY_SHIFT|KEY_F2,
	KEY_SHIFTF3              =KEY_SHIFT|KEY_F3,
	KEY_SHIFTF4              =KEY_SHIFT|KEY_F4,
	KEY_SHIFTF5              =KEY_SHIFT|KEY_F5,
	KEY_SHIFTF6              =KEY_SHIFT|KEY_F6,
	KEY_SHIFTF7              =KEY_SHIFT|KEY_F7,
	KEY_SHIFTF8              =KEY_SHIFT|KEY_F8,
	KEY_SHIFTF9              =KEY_SHIFT|KEY_F9,
	KEY_SHIFTF10             =KEY_SHIFT|KEY_F10,
	KEY_SHIFTF11             =KEY_SHIFT|KEY_F11,
	KEY_SHIFTF12             =KEY_SHIFT|KEY_F12,

	KEY_ALTF1                =KEY_ALT|KEY_F1,
	KEY_ALTF2                =KEY_ALT|KEY_F2,
	KEY_ALTF3                =KEY_ALT|KEY_F3,
	KEY_ALTF4                =KEY_ALT|KEY_F4,
	KEY_ALTF5                =KEY_ALT|KEY_F5,
	KEY_ALTF6                =KEY_ALT|KEY_F6,
	KEY_ALTF7                =KEY_ALT|KEY_F7,
	KEY_ALTF8                =KEY_ALT|KEY_F8,
	KEY_ALTF9                =KEY_ALT|KEY_F9,
	KEY_ALTF10               =KEY_ALT|KEY_F10,
	KEY_ALTF11               =KEY_ALT|KEY_F11,
	KEY_ALTF12               =KEY_ALT|KEY_F12,

	KEY_RALTF1               =KEY_RALT|KEY_F1,
	KEY_RALTF2               =KEY_RALT|KEY_F2,
	KEY_RALTF3               =KEY_RALT|KEY_F3,
	KEY_RALTF4               =KEY_RALT|KEY_F4,
	KEY_RALTF5               =KEY_RALT|KEY_F5,
	KEY_RALTF6               =KEY_RALT|KEY_F6,
	KEY_RALTF7               =KEY_RALT|KEY_F7,
	KEY_RALTF8               =KEY_RALT|KEY_F8,
	KEY_RALTF9               =KEY_RALT|KEY_F9,
	KEY_RALTF10              =KEY_RALT|KEY_F10,
	KEY_RALTF11              =KEY_RALT|KEY_F11,
	KEY_RALTF12              =KEY_RALT|KEY_F12,

	KEY_CTRLSHIFTF1          =KEY_CTRL|KEY_SHIFT|KEY_F1,
	KEY_CTRLSHIFTF2          =KEY_CTRL|KEY_SHIFT|KEY_F2,
	KEY_CTRLSHIFTF3          =KEY_CTRL|KEY_SHIFT|KEY_F3,
	KEY_CTRLSHIFTF4          =KEY_CTRL|KEY_SHIFT|KEY_F4,
	KEY_CTRLSHIFTF5          =KEY_CTRL|KEY_SHIFT|KEY_F5,
	KEY_CTRLSHIFTF6          =KEY_CTRL|KEY_SHIFT|KEY_F6,
	KEY_CTRLSHIFTF7          =KEY_CTRL|KEY_SHIFT|KEY_F7,
	KEY_CTRLSHIFTF8          =KEY_CTRL|KEY_SHIFT|KEY_F8,
	KEY_CTRLSHIFTF9          =KEY_CTRL|KEY_SHIFT|KEY_F9,
	KEY_CTRLSHIFTF10         =KEY_CTRL|KEY_SHIFT|KEY_F10,
	KEY_CTRLSHIFTF11         =KEY_CTRL|KEY_SHIFT|KEY_F11,
	KEY_CTRLSHIFTF12         =KEY_CTRL|KEY_SHIFT|KEY_F12,

	KEY_RCTRLSHIFTF1         =KEY_RCTRL|KEY_SHIFT|KEY_F1,
	KEY_RCTRLSHIFTF2         =KEY_RCTRL|KEY_SHIFT|KEY_F2,
	KEY_RCTRLSHIFTF3         =KEY_RCTRL|KEY_SHIFT|KEY_F3,
	KEY_RCTRLSHIFTF4         =KEY_RCTRL|KEY_SHIFT|KEY_F4,
	KEY_RCTRLSHIFTF5         =KEY_RCTRL|KEY_SHIFT|KEY_F5,
	KEY_RCTRLSHIFTF6         =KEY_RCTRL|KEY_SHIFT|KEY_F6,
	KEY_RCTRLSHIFTF7         =KEY_RCTRL|KEY_SHIFT|KEY_F7,
	KEY_RCTRLSHIFTF8         =KEY_RCTRL|KEY_SHIFT|KEY_F8,
	KEY_RCTRLSHIFTF9         =KEY_RCTRL|KEY_SHIFT|KEY_F9,
	KEY_RCTRLSHIFTF10        =KEY_RCTRL|KEY_SHIFT|KEY_F10,
	KEY_RCTRLSHIFTF11        =KEY_RCTRL|KEY_SHIFT|KEY_F11,
	KEY_RCTRLSHIFTF12        =KEY_RCTRL|KEY_SHIFT|KEY_F12,

	KEY_ALTSHIFTF1           =KEY_ALT|KEY_SHIFT|KEY_F1,
	KEY_ALTSHIFTF2           =KEY_ALT|KEY_SHIFT|KEY_F2,
	KEY_ALTSHIFTF3           =KEY_ALT|KEY_SHIFT|KEY_F3,
	KEY_ALTSHIFTF4           =KEY_ALT|KEY_SHIFT|KEY_F4,
	KEY_ALTSHIFTF5           =KEY_ALT|KEY_SHIFT|KEY_F5,
	KEY_ALTSHIFTF6           =KEY_ALT|KEY_SHIFT|KEY_F6,
	KEY_ALTSHIFTF7           =KEY_ALT|KEY_SHIFT|KEY_F7,
	KEY_ALTSHIFTF8           =KEY_ALT|KEY_SHIFT|KEY_F8,
	KEY_ALTSHIFTF9           =KEY_ALT|KEY_SHIFT|KEY_F9,
	KEY_ALTSHIFTF10          =KEY_ALT|KEY_SHIFT|KEY_F10,
	KEY_ALTSHIFTF11          =KEY_ALT|KEY_SHIFT|KEY_F11,
	KEY_ALTSHIFTF12          =KEY_ALT|KEY_SHIFT|KEY_F12,

	KEY_RALTSHIFTF1          =KEY_RALT|KEY_SHIFT|KEY_F1,
	KEY_RALTSHIFTF2          =KEY_RALT|KEY_SHIFT|KEY_F2,
	KEY_RALTSHIFTF3          =KEY_RALT|KEY_SHIFT|KEY_F3,
	KEY_RALTSHIFTF4          =KEY_RALT|KEY_SHIFT|KEY_F4,
	KEY_RALTSHIFTF5          =KEY_RALT|KEY_SHIFT|KEY_F5,
	KEY_RALTSHIFTF6          =KEY_RALT|KEY_SHIFT|KEY_F6,
	KEY_RALTSHIFTF7          =KEY_RALT|KEY_SHIFT|KEY_F7,
	KEY_RALTSHIFTF8          =KEY_RALT|KEY_SHIFT|KEY_F8,
	KEY_RALTSHIFTF9          =KEY_RALT|KEY_SHIFT|KEY_F9,
	KEY_RALTSHIFTF10         =KEY_RALT|KEY_SHIFT|KEY_F10,
	KEY_RALTSHIFTF11         =KEY_RALT|KEY_SHIFT|KEY_F11,
	KEY_RALTSHIFTF12         =KEY_RALT|KEY_SHIFT|KEY_F12,

	KEY_CTRLALTF1            =KEY_CTRL|KEY_ALT|KEY_F1,
	KEY_CTRLALTF2            =KEY_CTRL|KEY_ALT|KEY_F2,
	KEY_CTRLALTF3            =KEY_CTRL|KEY_ALT|KEY_F3,
	KEY_CTRLALTF4            =KEY_CTRL|KEY_ALT|KEY_F4,
	KEY_CTRLALTF5            =KEY_CTRL|KEY_ALT|KEY_F5,
	KEY_CTRLALTF6            =KEY_CTRL|KEY_ALT|KEY_F6,
	KEY_CTRLALTF7            =KEY_CTRL|KEY_ALT|KEY_F7,
	KEY_CTRLALTF8            =KEY_CTRL|KEY_ALT|KEY_F8,
	KEY_CTRLALTF9            =KEY_CTRL|KEY_ALT|KEY_F9,
	KEY_CTRLALTF10           =KEY_CTRL|KEY_ALT|KEY_F10,
	KEY_CTRLALTF11           =KEY_CTRL|KEY_ALT|KEY_F11,
	KEY_CTRLALTF12           =KEY_CTRL|KEY_ALT|KEY_F12,

	KEY_RCTRLRALTF1          =KEY_RCTRL|KEY_RALT|KEY_F1,
	KEY_RCTRLRALTF2          =KEY_RCTRL|KEY_RALT|KEY_F2,
	KEY_RCTRLRALTF3          =KEY_RCTRL|KEY_RALT|KEY_F3,
	KEY_RCTRLRALTF4          =KEY_RCTRL|KEY_RALT|KEY_F4,
	KEY_RCTRLRALTF5          =KEY_RCTRL|KEY_RALT|KEY_F5,
	KEY_RCTRLRALTF6          =KEY_RCTRL|KEY_RALT|KEY_F6,
	KEY_RCTRLRALTF7          =KEY_RCTRL|KEY_RALT|KEY_F7,
	KEY_RCTRLRALTF8          =KEY_RCTRL|KEY_RALT|KEY_F8,
	KEY_RCTRLRALTF9          =KEY_RCTRL|KEY_RALT|KEY_F9,
	KEY_RCTRLRALTF10         =KEY_RCTRL|KEY_RALT|KEY_F10,
	KEY_RCTRLRALTF11         =KEY_RCTRL|KEY_RALT|KEY_F11,
	KEY_RCTRLRALTF12         =KEY_RCTRL|KEY_RALT|KEY_F12,

	KEY_CTRLRALTF1           =KEY_CTRL|KEY_RALT|KEY_F1,
	KEY_CTRLRALTF2           =KEY_CTRL|KEY_RALT|KEY_F2,
	KEY_CTRLRALTF3           =KEY_CTRL|KEY_RALT|KEY_F3,
	KEY_CTRLRALTF4           =KEY_CTRL|KEY_RALT|KEY_F4,
	KEY_CTRLRALTF5           =KEY_CTRL|KEY_RALT|KEY_F5,
	KEY_CTRLRALTF6           =KEY_CTRL|KEY_RALT|KEY_F6,
	KEY_CTRLRALTF7           =KEY_CTRL|KEY_RALT|KEY_F7,
	KEY_CTRLRALTF8           =KEY_CTRL|KEY_RALT|KEY_F8,
	KEY_CTRLRALTF9           =KEY_CTRL|KEY_RALT|KEY_F9,
	KEY_CTRLRALTF10          =KEY_CTRL|KEY_RALT|KEY_F10,
	KEY_CTRLRALTF11          =KEY_CTRL|KEY_RALT|KEY_F11,
	KEY_CTRLRALTF12          =KEY_CTRL|KEY_RALT|KEY_F12,

	KEY_RCTRLALTF1           =KEY_RCTRL|KEY_ALT|KEY_F1,
	KEY_RCTRLALTF2           =KEY_RCTRL|KEY_ALT|KEY_F2,
	KEY_RCTRLALTF3           =KEY_RCTRL|KEY_ALT|KEY_F3,
	KEY_RCTRLALTF4           =KEY_RCTRL|KEY_ALT|KEY_F4,
	KEY_RCTRLALTF5           =KEY_RCTRL|KEY_ALT|KEY_F5,
	KEY_RCTRLALTF6           =KEY_RCTRL|KEY_ALT|KEY_F6,
	KEY_RCTRLALTF7           =KEY_RCTRL|KEY_ALT|KEY_F7,
	KEY_RCTRLALTF8           =KEY_RCTRL|KEY_ALT|KEY_F8,
	KEY_RCTRLALTF9           =KEY_RCTRL|KEY_ALT|KEY_F9,
	KEY_RCTRLALTF10          =KEY_RCTRL|KEY_ALT|KEY_F10,
	KEY_RCTRLALTF11          =KEY_RCTRL|KEY_ALT|KEY_F11,
	KEY_RCTRLALTF12          =KEY_RCTRL|KEY_ALT|KEY_F12,

	KEY_CTRLHOME             =KEY_CTRL|KEY_HOME,
	KEY_CTRLUP               =KEY_CTRL|KEY_UP,
	KEY_CTRLPGUP             =KEY_CTRL|KEY_PGUP,
	KEY_CTRLLEFT             =KEY_CTRL|KEY_LEFT,
	KEY_CTRLRIGHT            =KEY_CTRL|KEY_RIGHT,
	KEY_CTRLEND              =KEY_CTRL|KEY_END,
	KEY_CTRLDOWN             =KEY_CTRL|KEY_DOWN,
	KEY_CTRLPGDN             =KEY_CTRL|KEY_PGDN,
	KEY_CTRLINS              =KEY_CTRL|KEY_INS,
	KEY_CTRLDEL              =KEY_CTRL|KEY_DEL,
	KEY_CTRLNUMDEL           =KEY_CTRL|KEY_NUMDEL,
	KEY_CTRLDECIMAL          =KEY_CTRL|KEY_DECIMAL,

	KEY_RCTRLHOME            =KEY_RCTRL|KEY_HOME,
	KEY_RCTRLUP              =KEY_RCTRL|KEY_UP,
	KEY_RCTRLPGUP            =KEY_RCTRL|KEY_PGUP,
	KEY_RCTRLLEFT            =KEY_RCTRL|KEY_LEFT,
	KEY_RCTRLRIGHT           =KEY_RCTRL|KEY_RIGHT,
	KEY_RCTRLEND             =KEY_RCTRL|KEY_END,
	KEY_RCTRLDOWN            =KEY_RCTRL|KEY_DOWN,
	KEY_RCTRLPGDN            =KEY_RCTRL|KEY_PGDN,
	KEY_RCTRLINS             =KEY_RCTRL|KEY_INS,
	KEY_RCTRLDEL             =KEY_RCTRL|KEY_DEL,
	KEY_RCTRLNUMDEL          =KEY_RCTRL|KEY_NUMDEL,
	KEY_RCTRLDECIMAL         =KEY_RCTRL|KEY_DECIMAL,

	KEY_SHIFTHOME            =KEY_SHIFT|KEY_HOME,
	KEY_SHIFTUP              =KEY_SHIFT|KEY_UP,
	KEY_SHIFTPGUP            =KEY_SHIFT|KEY_PGUP,
	KEY_SHIFTLEFT            =KEY_SHIFT|KEY_LEFT,
	KEY_SHIFTRIGHT           =KEY_SHIFT|KEY_RIGHT,
	KEY_SHIFTEND             =KEY_SHIFT|KEY_END,
	KEY_SHIFTDOWN            =KEY_SHIFT|KEY_DOWN,
	KEY_SHIFTPGDN            =KEY_SHIFT|KEY_PGDN,
	KEY_SHIFTINS             =KEY_SHIFT|KEY_INS,
	KEY_SHIFTDEL             =KEY_SHIFT|KEY_DEL,
	KEY_SHIFTNUMDEL          =KEY_SHIFT|KEY_NUMDEL,
	KEY_SHIFTDECIMAL         =KEY_SHIFT|KEY_DECIMAL,

	KEY_ALTHOME              =KEY_ALT|KEY_HOME,
	KEY_ALTUP                =KEY_ALT|KEY_UP,
	KEY_ALTPGUP              =KEY_ALT|KEY_PGUP,
	KEY_ALTLEFT              =KEY_ALT|KEY_LEFT,
	KEY_ALTRIGHT             =KEY_ALT|KEY_RIGHT,
	KEY_ALTEND               =KEY_ALT|KEY_END,
	KEY_ALTDOWN              =KEY_ALT|KEY_DOWN,
	KEY_ALTPGDN              =KEY_ALT|KEY_PGDN,
	KEY_ALTINS               =KEY_ALT|KEY_INS,
	KEY_ALTDEL               =KEY_ALT|KEY_DEL,
	KEY_ALTNUMDEL            =KEY_ALT|KEY_NUMDEL,
	KEY_ALTDECIMAL           =KEY_ALT|KEY_DECIMAL,

	KEY_RALTHOME             =KEY_RALT|KEY_HOME,
	KEY_RALTUP               =KEY_RALT|KEY_UP,
	KEY_RALTPGUP             =KEY_RALT|KEY_PGUP,
	KEY_RALTLEFT             =KEY_RALT|KEY_LEFT,
	KEY_RALTRIGHT            =KEY_RALT|KEY_RIGHT,
	KEY_RALTEND              =KEY_RALT|KEY_END,
	KEY_RALTDOWN             =KEY_RALT|KEY_DOWN,
	KEY_RALTPGDN             =KEY_RALT|KEY_PGDN,
	KEY_RALTINS              =KEY_RALT|KEY_INS,
	KEY_RALTDEL              =KEY_RALT|KEY_DEL,
	KEY_RALTNUMDEL           =KEY_RALT|KEY_NUMDEL,
	KEY_RALTDECIMAL          =KEY_RALT|KEY_DECIMAL,

	KEY_CTRLSHIFTHOME        =KEY_CTRL|KEY_SHIFT|KEY_HOME,
	KEY_CTRLSHIFTUP          =KEY_CTRL|KEY_SHIFT|KEY_UP,
	KEY_CTRLSHIFTPGUP        =KEY_CTRL|KEY_SHIFT|KEY_PGUP,
	KEY_CTRLSHIFTLEFT        =KEY_CTRL|KEY_SHIFT|KEY_LEFT,
	KEY_CTRLSHIFTRIGHT       =KEY_CTRL|KEY_SHIFT|KEY_RIGHT,
	KEY_CTRLSHIFTEND         =KEY_CTRL|KEY_SHIFT|KEY_END,
	KEY_CTRLSHIFTDOWN        =KEY_CTRL|KEY_SHIFT|KEY_DOWN,
	KEY_CTRLSHIFTPGDN        =KEY_CTRL|KEY_SHIFT|KEY_PGDN,
	KEY_CTRLSHIFTINS         =KEY_CTRL|KEY_SHIFT|KEY_INS,
	KEY_CTRLSHIFTDEL         =KEY_CTRL|KEY_SHIFT|KEY_DEL,
	KEY_CTRLSHIFTNUMDEL      =KEY_CTRL|KEY_SHIFT|KEY_NUMDEL,
	KEY_CTRLSHIFTDECIMAL     =KEY_CTRL|KEY_SHIFT|KEY_DECIMAL,

	KEY_RCTRLSHIFTHOME       =KEY_RCTRL|KEY_SHIFT|KEY_HOME,
	KEY_RCTRLSHIFTUP         =KEY_RCTRL|KEY_SHIFT|KEY_UP,
	KEY_RCTRLSHIFTPGUP       =KEY_RCTRL|KEY_SHIFT|KEY_PGUP,
	KEY_RCTRLSHIFTLEFT       =KEY_RCTRL|KEY_SHIFT|KEY_LEFT,
	KEY_RCTRLSHIFTRIGHT      =KEY_RCTRL|KEY_SHIFT|KEY_RIGHT,
	KEY_RCTRLSHIFTEND        =KEY_RCTRL|KEY_SHIFT|KEY_END,
	KEY_RCTRLSHIFTDOWN       =KEY_RCTRL|KEY_SHIFT|KEY_DOWN,
	KEY_RCTRLSHIFTPGDN       =KEY_RCTRL|KEY_SHIFT|KEY_PGDN,
	KEY_RCTRLSHIFTINS        =KEY_RCTRL|KEY_SHIFT|KEY_INS,
	KEY_RCTRLSHIFTDEL        =KEY_RCTRL|KEY_SHIFT|KEY_DEL,
	KEY_RCTRLSHIFTNUMDEL     =KEY_RCTRL|KEY_SHIFT|KEY_NUMDEL,
	KEY_RCTRLSHIFTDECIMAL    =KEY_RCTRL|KEY_SHIFT|KEY_DECIMAL,

	KEY_ALTSHIFTHOME         =KEY_ALT|KEY_SHIFT|KEY_HOME,
	KEY_ALTSHIFTUP           =KEY_ALT|KEY_SHIFT|KEY_UP,
	KEY_ALTSHIFTPGUP         =KEY_ALT|KEY_SHIFT|KEY_PGUP,
	KEY_ALTSHIFTLEFT         =KEY_ALT|KEY_SHIFT|KEY_LEFT,
	KEY_ALTSHIFTRIGHT        =KEY_ALT|KEY_SHIFT|KEY_RIGHT,
	KEY_ALTSHIFTEND          =KEY_ALT|KEY_SHIFT|KEY_END,
	KEY_ALTSHIFTDOWN         =KEY_ALT|KEY_SHIFT|KEY_DOWN,
	KEY_ALTSHIFTPGDN         =KEY_ALT|KEY_SHIFT|KEY_PGDN,
	KEY_ALTSHIFTINS          =KEY_ALT|KEY_SHIFT|KEY_INS,
	KEY_ALTSHIFTDEL          =KEY_ALT|KEY_SHIFT|KEY_DEL,
	KEY_ALTSHIFTNUMDEL       =KEY_ALT|KEY_SHIFT|KEY_NUMDEL,
	KEY_ALTSHIFTDECIMAL      =KEY_ALT|KEY_SHIFT|KEY_DECIMAL,

	KEY_RALTSHIFTHOME        =KEY_RALT|KEY_SHIFT|KEY_HOME,
	KEY_RALTSHIFTUP          =KEY_RALT|KEY_SHIFT|KEY_UP,
	KEY_RALTSHIFTPGUP        =KEY_RALT|KEY_SHIFT|KEY_PGUP,
	KEY_RALTSHIFTLEFT        =KEY_RALT|KEY_SHIFT|KEY_LEFT,
	KEY_RALTSHIFTRIGHT       =KEY_RALT|KEY_SHIFT|KEY_RIGHT,
	KEY_RALTSHIFTEND         =KEY_RALT|KEY_SHIFT|KEY_END,
	KEY_RALTSHIFTDOWN        =KEY_RALT|KEY_SHIFT|KEY_DOWN,
	KEY_RALTSHIFTPGDN        =KEY_RALT|KEY_SHIFT|KEY_PGDN,
	KEY_RALTSHIFTINS         =KEY_RALT|KEY_SHIFT|KEY_INS,
	KEY_RALTSHIFTDEL         =KEY_RALT|KEY_SHIFT|KEY_DEL,
	KEY_RALTSHIFTNUMDEL      =KEY_RALT|KEY_SHIFT|KEY_NUMDEL,
	KEY_RALTSHIFTDECIMAL     =KEY_RALT|KEY_SHIFT|KEY_DECIMAL,

	KEY_CTRLALTHOME          =KEY_CTRL|KEY_ALT|KEY_HOME,
	KEY_CTRLALTUP            =KEY_CTRL|KEY_ALT|KEY_UP,
	KEY_CTRLALTPGUP          =KEY_CTRL|KEY_ALT|KEY_PGUP,
	KEY_CTRLALTLEFT          =KEY_CTRL|KEY_ALT|KEY_LEFT,
	KEY_CTRLALTRIGHT         =KEY_CTRL|KEY_ALT|KEY_RIGHT,
	KEY_CTRLALTEND           =KEY_CTRL|KEY_ALT|KEY_END,
	KEY_CTRLALTDOWN          =KEY_CTRL|KEY_ALT|KEY_DOWN,
	KEY_CTRLALTPGDN          =KEY_CTRL|KEY_ALT|KEY_PGDN,
	KEY_CTRLALTINS           =KEY_CTRL|KEY_ALT|KEY_INS,

	KEY_RCTRLRALTHOME        =KEY_RCTRL|KEY_RALT|KEY_HOME,
	KEY_RCTRLRALTUP          =KEY_RCTRL|KEY_RALT|KEY_UP,
	KEY_RCTRLRALTPGUP        =KEY_RCTRL|KEY_RALT|KEY_PGUP,
	KEY_RCTRLRALTLEFT        =KEY_RCTRL|KEY_RALT|KEY_LEFT,
	KEY_RCTRLRALTRIGHT       =KEY_RCTRL|KEY_RALT|KEY_RIGHT,
	KEY_RCTRLRALTEND         =KEY_RCTRL|KEY_RALT|KEY_END,
	KEY_RCTRLRALTDOWN        =KEY_RCTRL|KEY_RALT|KEY_DOWN,
	KEY_RCTRLRALTPGDN        =KEY_RCTRL|KEY_RALT|KEY_PGDN,
	KEY_RCTRLRALTINS         =KEY_RCTRL|KEY_RALT|KEY_INS,

	KEY_CTRLRALTHOME         =KEY_CTRL|KEY_RALT|KEY_HOME,
	KEY_CTRLRALTUP           =KEY_CTRL|KEY_RALT|KEY_UP,
	KEY_CTRLRALTPGUP         =KEY_CTRL|KEY_RALT|KEY_PGUP,
	KEY_CTRLRALTLEFT         =KEY_CTRL|KEY_RALT|KEY_LEFT,
	KEY_CTRLRALTRIGHT        =KEY_CTRL|KEY_RALT|KEY_RIGHT,
	KEY_CTRLRALTEND          =KEY_CTRL|KEY_RALT|KEY_END,
	KEY_CTRLRALTDOWN         =KEY_CTRL|KEY_RALT|KEY_DOWN,
	KEY_CTRLRALTPGDN         =KEY_CTRL|KEY_RALT|KEY_PGDN,
	KEY_CTRLRALTINS          =KEY_CTRL|KEY_RALT|KEY_INS,

	KEY_RCTRLALTHOME         =KEY_RCTRL|KEY_ALT|KEY_HOME,
	KEY_RCTRLALTUP           =KEY_RCTRL|KEY_ALT|KEY_UP,
	KEY_RCTRLALTPGUP         =KEY_RCTRL|KEY_ALT|KEY_PGUP,
	KEY_RCTRLALTLEFT         =KEY_RCTRL|KEY_ALT|KEY_LEFT,
	KEY_RCTRLALTRIGHT        =KEY_RCTRL|KEY_ALT|KEY_RIGHT,
	KEY_RCTRLALTEND          =KEY_RCTRL|KEY_ALT|KEY_END,
	KEY_RCTRLALTDOWN         =KEY_RCTRL|KEY_ALT|KEY_DOWN,
	KEY_RCTRLALTPGDN         =KEY_RCTRL|KEY_ALT|KEY_PGDN,
	KEY_RCTRLALTINS          =KEY_RCTRL|KEY_ALT|KEY_INS,

	KEY_CTRLNUMPAD0          =KEY_CTRL|KEY_NUMPAD0,
	KEY_CTRLNUMPAD1          =KEY_CTRL|KEY_NUMPAD1,
	KEY_CTRLNUMPAD2          =KEY_CTRL|KEY_NUMPAD2,
	KEY_CTRLNUMPAD3          =KEY_CTRL|KEY_NUMPAD3,
	KEY_CTRLNUMPAD4          =KEY_CTRL|KEY_NUMPAD4,
	KEY_CTRLNUMPAD5          =KEY_CTRL|KEY_NUMPAD5,
	KEY_CTRLNUMPAD6          =KEY_CTRL|KEY_NUMPAD6,
	KEY_CTRLNUMPAD7          =KEY_CTRL|KEY_NUMPAD7,
	KEY_CTRLNUMPAD8          =KEY_CTRL|KEY_NUMPAD8,
	KEY_CTRLNUMPAD9          =KEY_CTRL|KEY_NUMPAD9,

	KEY_RCTRLNUMPAD0         =KEY_RCTRL|KEY_NUMPAD0,
	KEY_RCTRLNUMPAD1         =KEY_RCTRL|KEY_NUMPAD1,
	KEY_RCTRLNUMPAD2         =KEY_RCTRL|KEY_NUMPAD2,
	KEY_RCTRLNUMPAD3         =KEY_RCTRL|KEY_NUMPAD3,
	KEY_RCTRLNUMPAD4         =KEY_RCTRL|KEY_NUMPAD4,
	KEY_RCTRLNUMPAD5         =KEY_RCTRL|KEY_NUMPAD5,
	KEY_RCTRLNUMPAD6         =KEY_RCTRL|KEY_NUMPAD6,
	KEY_RCTRLNUMPAD7         =KEY_RCTRL|KEY_NUMPAD7,
	KEY_RCTRLNUMPAD8         =KEY_RCTRL|KEY_NUMPAD8,
	KEY_RCTRLNUMPAD9         =KEY_RCTRL|KEY_NUMPAD9,

	KEY_SHIFTNUMPAD0         =KEY_SHIFT|KEY_NUMPAD0,
	KEY_SHIFTNUMPAD1         =KEY_SHIFT|KEY_NUMPAD1,
	KEY_SHIFTNUMPAD2         =KEY_SHIFT|KEY_NUMPAD2,
	KEY_SHIFTNUMPAD3         =KEY_SHIFT|KEY_NUMPAD3,
	KEY_SHIFTNUMPAD4         =KEY_SHIFT|KEY_NUMPAD4,
	KEY_SHIFTNUMPAD5         =KEY_SHIFT|KEY_NUMPAD5,
	KEY_SHIFTNUMPAD6         =KEY_SHIFT|KEY_NUMPAD6,
	KEY_SHIFTNUMPAD7         =KEY_SHIFT|KEY_NUMPAD7,
	KEY_SHIFTNUMPAD8         =KEY_SHIFT|KEY_NUMPAD8,
	KEY_SHIFTNUMPAD9         =KEY_SHIFT|KEY_NUMPAD9,

	KEY_CTRLSHIFTNUMPAD0     =KEY_CTRL|KEY_SHIFT|KEY_NUMPAD0,
	KEY_CTRLSHIFTNUMPAD1     =KEY_CTRL|KEY_SHIFT|KEY_NUMPAD1,
	KEY_CTRLSHIFTNUMPAD2     =KEY_CTRL|KEY_SHIFT|KEY_NUMPAD2,
	KEY_CTRLSHIFTNUMPAD3     =KEY_CTRL|KEY_SHIFT|KEY_NUMPAD3,
	KEY_CTRLSHIFTNUMPAD4     =KEY_CTRL|KEY_SHIFT|KEY_NUMPAD4,
	KEY_CTRLSHIFTNUMPAD5     =KEY_CTRL|KEY_SHIFT|KEY_NUMPAD5,
	KEY_CTRLSHIFTNUMPAD6     =KEY_CTRL|KEY_SHIFT|KEY_NUMPAD6,
	KEY_CTRLSHIFTNUMPAD7     =KEY_CTRL|KEY_SHIFT|KEY_NUMPAD7,
	KEY_CTRLSHIFTNUMPAD8     =KEY_CTRL|KEY_SHIFT|KEY_NUMPAD8,
	KEY_CTRLSHIFTNUMPAD9     =KEY_CTRL|KEY_SHIFT|KEY_NUMPAD9,

	KEY_RCTRLSHIFTNUMPAD0    =KEY_RCTRL|KEY_SHIFT|KEY_NUMPAD0,
	KEY_RCTRLSHIFTNUMPAD1    =KEY_RCTRL|KEY_SHIFT|KEY_NUMPAD1,
	KEY_RCTRLSHIFTNUMPAD2    =KEY_RCTRL|KEY_SHIFT|KEY_NUMPAD2,
	KEY_RCTRLSHIFTNUMPAD3    =KEY_RCTRL|KEY_SHIFT|KEY_NUMPAD3,
	KEY_RCTRLSHIFTNUMPAD4    =KEY_RCTRL|KEY_SHIFT|KEY_NUMPAD4,
	KEY_RCTRLSHIFTNUMPAD5    =KEY_RCTRL|KEY_SHIFT|KEY_NUMPAD5,
	KEY_RCTRLSHIFTNUMPAD6    =KEY_RCTRL|KEY_SHIFT|KEY_NUMPAD6,
	KEY_RCTRLSHIFTNUMPAD7    =KEY_RCTRL|KEY_SHIFT|KEY_NUMPAD7,
	KEY_RCTRLSHIFTNUMPAD8    =KEY_RCTRL|KEY_SHIFT|KEY_NUMPAD8,
	KEY_RCTRLSHIFTNUMPAD9    =KEY_RCTRL|KEY_SHIFT|KEY_NUMPAD9,

	KEY_CTRLALTNUMPAD0       =KEY_CTRL|KEY_ALT|KEY_NUMPAD0,
	KEY_CTRLALTNUMPAD1       =KEY_CTRL|KEY_ALT|KEY_NUMPAD1,
	KEY_CTRLALTNUMPAD2       =KEY_CTRL|KEY_ALT|KEY_NUMPAD2,
	KEY_CTRLALTNUMPAD3       =KEY_CTRL|KEY_ALT|KEY_NUMPAD3,
	KEY_CTRLALTNUMPAD4       =KEY_CTRL|KEY_ALT|KEY_NUMPAD4,
	KEY_CTRLALTNUMPAD5       =KEY_CTRL|KEY_ALT|KEY_NUMPAD5,
	KEY_CTRLALTNUMPAD6       =KEY_CTRL|KEY_ALT|KEY_NUMPAD6,
	KEY_CTRLALTNUMPAD7       =KEY_CTRL|KEY_ALT|KEY_NUMPAD7,
	KEY_CTRLALTNUMPAD8       =KEY_CTRL|KEY_ALT|KEY_NUMPAD8,
	KEY_CTRLALTNUMPAD9       =KEY_CTRL|KEY_ALT|KEY_NUMPAD9,

	KEY_RCTRLRALTNUMPAD0     =KEY_RCTRL|KEY_RALT|KEY_NUMPAD0,
	KEY_RCTRLRALTNUMPAD1     =KEY_RCTRL|KEY_RALT|KEY_NUMPAD1,
	KEY_RCTRLRALTNUMPAD2     =KEY_RCTRL|KEY_RALT|KEY_NUMPAD2,
	KEY_RCTRLRALTNUMPAD3     =KEY_RCTRL|KEY_RALT|KEY_NUMPAD3,
	KEY_RCTRLRALTNUMPAD4     =KEY_RCTRL|KEY_RALT|KEY_NUMPAD4,
	KEY_RCTRLRALTNUMPAD5     =KEY_RCTRL|KEY_RALT|KEY_NUMPAD5,
	KEY_RCTRLRALTNUMPAD6     =KEY_RCTRL|KEY_RALT|KEY_NUMPAD6,
	KEY_RCTRLRALTNUMPAD7     =KEY_RCTRL|KEY_RALT|KEY_NUMPAD7,
	KEY_RCTRLRALTNUMPAD8     =KEY_RCTRL|KEY_RALT|KEY_NUMPAD8,
	KEY_RCTRLRALTNUMPAD9     =KEY_RCTRL|KEY_RALT|KEY_NUMPAD9,

	KEY_CTRLRALTNUMPAD0      =KEY_CTRL|KEY_RALT|KEY_NUMPAD0,
	KEY_CTRLRALTNUMPAD1      =KEY_CTRL|KEY_RALT|KEY_NUMPAD1,
	KEY_CTRLRALTNUMPAD2      =KEY_CTRL|KEY_RALT|KEY_NUMPAD2,
	KEY_CTRLRALTNUMPAD3      =KEY_CTRL|KEY_RALT|KEY_NUMPAD3,
	KEY_CTRLRALTNUMPAD4      =KEY_CTRL|KEY_RALT|KEY_NUMPAD4,
	KEY_CTRLRALTNUMPAD5      =KEY_CTRL|KEY_RALT|KEY_NUMPAD5,
	KEY_CTRLRALTNUMPAD6      =KEY_CTRL|KEY_RALT|KEY_NUMPAD6,
	KEY_CTRLRALTNUMPAD7      =KEY_CTRL|KEY_RALT|KEY_NUMPAD7,
	KEY_CTRLRALTNUMPAD8      =KEY_CTRL|KEY_RALT|KEY_NUMPAD8,
	KEY_CTRLRALTNUMPAD9      =KEY_CTRL|KEY_RALT|KEY_NUMPAD9,

	KEY_RCTRLALTNUMPAD0      =KEY_RCTRL|KEY_ALT|KEY_NUMPAD0,
	KEY_RCTRLALTNUMPAD1      =KEY_RCTRL|KEY_ALT|KEY_NUMPAD1,
	KEY_RCTRLALTNUMPAD2      =KEY_RCTRL|KEY_ALT|KEY_NUMPAD2,
	KEY_RCTRLALTNUMPAD3      =KEY_RCTRL|KEY_ALT|KEY_NUMPAD3,
	KEY_RCTRLALTNUMPAD4      =KEY_RCTRL|KEY_ALT|KEY_NUMPAD4,
	KEY_RCTRLALTNUMPAD5      =KEY_RCTRL|KEY_ALT|KEY_NUMPAD5,
	KEY_RCTRLALTNUMPAD6      =KEY_RCTRL|KEY_ALT|KEY_NUMPAD6,
	KEY_RCTRLALTNUMPAD7      =KEY_RCTRL|KEY_ALT|KEY_NUMPAD7,
	KEY_RCTRLALTNUMPAD8      =KEY_RCTRL|KEY_ALT|KEY_NUMPAD8,
	KEY_RCTRLALTNUMPAD9      =KEY_RCTRL|KEY_ALT|KEY_NUMPAD9,

	KEY_ALTSHIFTNUMPAD0      =KEY_ALT|KEY_SHIFT|KEY_NUMPAD0,
	KEY_ALTSHIFTNUMPAD1      =KEY_ALT|KEY_SHIFT|KEY_NUMPAD1,
	KEY_ALTSHIFTNUMPAD2      =KEY_ALT|KEY_SHIFT|KEY_NUMPAD2,
	KEY_ALTSHIFTNUMPAD3      =KEY_ALT|KEY_SHIFT|KEY_NUMPAD3,
	KEY_ALTSHIFTNUMPAD4      =KEY_ALT|KEY_SHIFT|KEY_NUMPAD4,
	KEY_ALTSHIFTNUMPAD5      =KEY_ALT|KEY_SHIFT|KEY_NUMPAD5,
	KEY_ALTSHIFTNUMPAD6      =KEY_ALT|KEY_SHIFT|KEY_NUMPAD6,
	KEY_ALTSHIFTNUMPAD7      =KEY_ALT|KEY_SHIFT|KEY_NUMPAD7,
	KEY_ALTSHIFTNUMPAD8      =KEY_ALT|KEY_SHIFT|KEY_NUMPAD8,
	KEY_ALTSHIFTNUMPAD9      =KEY_ALT|KEY_SHIFT|KEY_NUMPAD9,

	KEY_RALTSHIFTNUMPAD0     =KEY_RALT|KEY_SHIFT|KEY_NUMPAD0,
	KEY_RALTSHIFTNUMPAD1     =KEY_RALT|KEY_SHIFT|KEY_NUMPAD1,
	KEY_RALTSHIFTNUMPAD2     =KEY_RALT|KEY_SHIFT|KEY_NUMPAD2,
	KEY_RALTSHIFTNUMPAD3     =KEY_RALT|KEY_SHIFT|KEY_NUMPAD3,
	KEY_RALTSHIFTNUMPAD4     =KEY_RALT|KEY_SHIFT|KEY_NUMPAD4,
	KEY_RALTSHIFTNUMPAD5     =KEY_RALT|KEY_SHIFT|KEY_NUMPAD5,
	KEY_RALTSHIFTNUMPAD6     =KEY_RALT|KEY_SHIFT|KEY_NUMPAD6,
	KEY_RALTSHIFTNUMPAD7     =KEY_RALT|KEY_SHIFT|KEY_NUMPAD7,
	KEY_RALTSHIFTNUMPAD8     =KEY_RALT|KEY_SHIFT|KEY_NUMPAD8,
	KEY_RALTSHIFTNUMPAD9     =KEY_RALT|KEY_SHIFT|KEY_NUMPAD9,

	KEY_CTRLSLASH            =KEY_CTRL|KEY_SLASH,
	KEY_CTRLBACKSLASH        =KEY_CTRL|KEY_BACKSLASH,
	KEY_CTRLCLEAR            =KEY_CTRL|KEY_CLEAR,
	KEY_CTRLSHIFTCLEAR       =KEY_CTRL|KEY_SHIFT|KEY_CLEAR,
	KEY_CTRLALTCLEAR         =KEY_CTRL|KEY_ALT|KEY_CLEAR,
	KEY_RCTRLRALTCLEAR       =KEY_RCTRL|KEY_RALT|KEY_CLEAR,
	KEY_CTRLRALTCLEAR        =KEY_CTRL|KEY_RALT|KEY_CLEAR,
	KEY_RCTRLALTCLEAR        =KEY_RCTRL|KEY_ALT|KEY_CLEAR,
	KEY_CTRLADD              =KEY_CTRL|KEY_ADD,
	KEY_RCTRLSLASH           =KEY_RCTRL|KEY_SLASH,
	KEY_RCTRLBACKSLASH       =KEY_RCTRL|KEY_BACKSLASH,
	KEY_RCTRLCLEAR           =KEY_RCTRL|KEY_CLEAR,
	KEY_RCTRLSHIFTCLEAR      =KEY_RCTRL|KEY_SHIFT|KEY_CLEAR,
	KEY_RCTRLADD             =KEY_RCTRL|KEY_ADD,
	KEY_SHIFTADD             =KEY_SHIFT|KEY_ADD,

	KEY_CTRLSUBTRACT         =KEY_CTRL|KEY_SUBTRACT,
	KEY_ALTSUBTRACT          =KEY_ALT|KEY_SUBTRACT,
	KEY_SHIFTSUBTRACT        =KEY_SHIFT|KEY_SUBTRACT,
	KEY_CTRLMULTIPLY         =KEY_CTRL|KEY_MULTIPLY,

	KEY_RCTRLSUBTRACT        =KEY_RCTRL|KEY_SUBTRACT,
	KEY_RALTSUBTRACT         =KEY_RALT|KEY_SUBTRACT,
	KEY_RCTRLMULTIPLY        =KEY_RCTRL|KEY_MULTIPLY,

	KEY_CTRLBS               =KEY_CTRL|KEY_BS,
	KEY_RCTRLBS              =KEY_RCTRL|KEY_BS,
	KEY_ALTBS                =KEY_ALT|KEY_BS,
	KEY_RALTBS               =KEY_RALT|KEY_BS,
	KEY_CTRLSHIFTBS          =KEY_CTRL|KEY_SHIFT|KEY_BS,
	KEY_RCTRLSHIFTBS         =KEY_RCTRL|KEY_SHIFT|KEY_BS,
	KEY_SHIFTBS              =KEY_SHIFT|KEY_BS,

	KEY_CTRLSHIFTTAB         =KEY_CTRL|KEY_SHIFT|KEY_TAB,
	KEY_RCTRLSHIFTTAB        =KEY_RCTRL|KEY_SHIFT|KEY_TAB,
	KEY_CTRLTAB              =KEY_CTRL|KEY_TAB,
	KEY_RCTRLTAB             =KEY_RCTRL|KEY_TAB,
	KEY_SHIFTTAB             =KEY_SHIFT|KEY_TAB,

	KEY_CTRLENTER            =KEY_CTRL|KEY_ENTER,
	KEY_SHIFTENTER           =KEY_SHIFT|KEY_ENTER,
	KEY_ALTSHIFTENTER        =KEY_ALT|KEY_SHIFT|KEY_ENTER,
	KEY_CTRLALTENTER         =KEY_CTRL|KEY_ALT|KEY_ENTER,
	KEY_CTRLSHIFTENTER       =KEY_CTRL|KEY_SHIFT|KEY_ENTER,
	KEY_RCTRLENTER           =KEY_RCTRL|KEY_ENTER,
	KEY_RALTSHIFTENTER       =KEY_RALT|KEY_SHIFT|KEY_ENTER,
	KEY_RCTRLRALTENTER       =KEY_RCTRL|KEY_RALT|KEY_ENTER,
	KEY_RCTRLSHIFTENTER      =KEY_RCTRL|KEY_SHIFT|KEY_ENTER,
	KEY_CTRLRALTENTER        =KEY_CTRL|KEY_RALT|KEY_ENTER,
	KEY_RCTRLALTENTER        =KEY_RCTRL|KEY_ALT|KEY_ENTER,

	KEY_CTRLNUMENTER         =KEY_CTRL|KEY_NUMENTER,
	KEY_SHIFTNUMENTER        =KEY_SHIFT|KEY_NUMENTER,
	KEY_ALTSHIFTNUMENTER     =KEY_ALT|KEY_SHIFT|KEY_NUMENTER,
	KEY_CTRLALTNUMENTER      =KEY_CTRL|KEY_ALT|KEY_NUMENTER,
	KEY_CTRLSHIFTNUMENTER    =KEY_CTRL|KEY_SHIFT|KEY_NUMENTER,
	KEY_RCTRLNUMENTER        =KEY_RCTRL|KEY_NUMENTER,
	KEY_RALTSHIFTNUMENTER    =KEY_RALT|KEY_SHIFT|KEY_NUMENTER,
	KEY_RCTRLRALTNUMENTER    =KEY_RCTRL|KEY_RALT|KEY_NUMENTER,
	KEY_RCTRLSHIFTNUMENTER   =KEY_RCTRL|KEY_SHIFT|KEY_NUMENTER,
	KEY_CTRLRALTNUMENTER     =KEY_CTRL|KEY_RALT|KEY_NUMENTER,
	KEY_RCTRLALTNUMENTER     =KEY_RCTRL|KEY_ALT|KEY_NUMENTER,

	KEY_CTRLAPPS             =KEY_CTRL|KEY_APPS,
	KEY_ALTAPPS              =KEY_ALT|KEY_APPS,
	KEY_SHIFTAPPS            =KEY_SHIFT|KEY_APPS,
	KEY_CTRLSHIFTAPPS        =KEY_CTRL|KEY_SHIFT|KEY_APPS,
	KEY_ALTSHIFTAPPS         =KEY_ALT|KEY_SHIFT|KEY_APPS,
	KEY_CTRLALTAPPS          =KEY_CTRL|KEY_ALT|KEY_APPS,
	KEY_RCTRLAPPS            =KEY_RCTRL|KEY_APPS,
	KEY_RALTAPPS             =KEY_RALT|KEY_APPS,
	KEY_RCTRLSHIFTAPPS       =KEY_RCTRL|KEY_SHIFT|KEY_APPS,
	KEY_RALTSHIFTAPPS        =KEY_RALT|KEY_SHIFT|KEY_APPS,
	KEY_RCTRLRALTAPPS        =KEY_RCTRL|KEY_RALT|KEY_APPS,
	KEY_CTRLRALTAPPS         =KEY_CTRL|KEY_RALT|KEY_APPS,
	KEY_RCTRLALTAPPS         =KEY_RCTRL|KEY_ALT|KEY_APPS,

	KEY_CTRLSPACE            =KEY_CTRL|KEY_SPACE,
	KEY_RCTRLSPACE           =KEY_RCTRL|KEY_SPACE,
	KEY_SHIFTSPACE           =KEY_SHIFT|KEY_SPACE,
	KEY_CTRLSHIFTSPACE       =KEY_CTRL|KEY_SHIFT|KEY_SPACE,
	KEY_RCTRLSHIFTSPACE      =KEY_RCTRL|KEY_SHIFT|KEY_SPACE,

	KEY_ALT_BASE             =KEY_ALT,
	KEY_RALT_BASE            =KEY_RALT,
	KEY_ALTSHIFT_BASE        =KEY_ALTSHIFT,
	KEY_RALTSHIFT_BASE       =KEY_RALT|KEY_SHIFT,
};

#endif // KEYS_HPP_C9983354_D8EA_4A70_9E16_722A332B503D
