m4_divert(-1)

m4_define(M4_MACRO_CONCAT, $1$2$3$4$5$6$7$8$9)
m4_define(M4_MACRO_GET, __M4_MACRO_$1)
m4_define(M4_MACRO_DEFINE, `m4_define(M4_MACRO_GET($1), $2)')
m4_define(HOST_TYPE, m4_ifdef(`HOSTTYPE', HOSTTYPE, `Windows'))
m4_define(CMDAWK, m4_ifelse(
	HOST_TYPE, `Windows', `tools\gawk.exe',
	HOST_TYPE, `Msys', `./tools/gawk',
	`gawk'))
m4_define(DEVNULL, m4_ifelse(
	HOST_TYPE, `Windows', `nul',
	`/dev/null'))


# Uncomment to create a special version
#M4_MACRO_DEFINE(SPECIAL_VERSION, epic feature)

M4_MACRO_DEFINE(VERSION_MAJOR, 3)
M4_MACRO_DEFINE(VERSION_MINOR, 0)
M4_MACRO_DEFINE(VERSION_REVISION, 0)
M4_MACRO_DEFINE(VERSION_BUILD, m4_patsubst(m4_include(`vbuild.m4'),`
',`'))

M4_MACRO_DEFINE(VERSION_TYPE, m4_ifdef(`__M4_MACRO_SPECIAL_VERSION', VS_SPECIAL, m4_ifelse(BUILD_TYPE, `', VS_PRIVATE, BUILD_TYPE)))

M4_MACRO_DEFINE(BUILD_SPECIAL, m4_ifelse(M4_MACRO_GET(VERSION_TYPE), VS_SPECIAL, 1, 0))
M4_MACRO_DEFINE(BUILD_PRIVATE, m4_ifelse(M4_MACRO_GET(VERSION_TYPE), VS_PRIVATE, 1, 0))
M4_MACRO_DEFINE(BUILD_PRERELEASE, m4_ifelse(
	M4_MACRO_GET(VERSION_TYPE), VS_ALPHA,   1,
	M4_MACRO_GET(VERSION_TYPE), VS_PRIVATE, 1,
	M4_MACRO_GET(VERSION_TYPE), VS_SPECIAL, 1,
	0))

M4_MACRO_DEFINE(BUILD_PLATFORM, m4_ifelse(
	FARBIT, 64, x64,
	FARBIT, 32, x86,
	FARBIT, ARM64, ARM64,
	FARBIT, ARM32, ARM,
	FARBIT))

M4_MACRO_DEFINE(BUILD_SCM_REVISION, m4_ifelse(SCM_REVISION, `', m4_patsubst(m4_esyscmd(git rev-parse HEAD 2> DEVNULL),`
',`'), SCM_REVISION))

M4_MACRO_DEFINE(BUILD_DATE, m4_esyscmd(CMDAWK -f ./scripts/gendate.awk))
M4_MACRO_DEFINE(BUILD_YEAR,  m4_substr(M4_MACRO_GET(BUILD_DATE), 6, 4))
M4_MACRO_DEFINE(BUILD_MONTH, m4_substr(M4_MACRO_GET(BUILD_DATE), 3, 2))
M4_MACRO_DEFINE(BUILD_DAY,   m4_substr(M4_MACRO_GET(BUILD_DATE), 0, 2))
M4_MACRO_DEFINE(COPYRIGHTYEAR, M4_MACRO_GET(BUILD_YEAR))

M4_MACRO_DEFINE(FULLVERSION, M4_MACRO_GET(VERSION_MAJOR).M4_MACRO_GET(VERSION_MINOR).M4_MACRO_GET(VERSION_BUILD).M4_MACRO_GET(VERSION_REVISION)`'m4_ifelse(
	M4_MACRO_GET(VERSION_TYPE), VS_SPECIAL, ` (Special: M4_MACRO_GET(SPECIAL_VERSION))',
	M4_MACRO_GET(VERSION_TYPE), VS_PRIVATE, ` (Private)',
	M4_MACRO_GET(VERSION_TYPE), VS_ALPHA,   ` (Alpha)',
	M4_MACRO_GET(VERSION_TYPE), VS_BETA,    ` (Beta)',
	M4_MACRO_GET(VERSION_TYPE), VS_RC,      ` (RC)',
	M4_MACRO_GET(VERSION_TYPE), VS_RELEASE, `',
	                                        ` (Unknown)') M4_MACRO_GET(BUILD_PLATFORM))

m4_changequote()
m4_changecom()

m4_divert(0)m4_dnl
