|[English](CONTRIBUTING.md)|[Polski](CONTRIBUTING-PL.md)|
|-|-|

### УЧАСТИЕ

> Этот документ поможет вам ознакомиться с нашим процессом разработки.

#### Предложение исправлений

При внесении изменений в исходный код, пожалуйста, следуйте следующим правилам:

1. Каждое изменение должно быть логически завершенным и, по возможности,
   минимальным. Это позволит нам быстрее проверить и принять его.
2. Старайтесь придерживаться единообразного стиля оформления кода.
3. Детально опишите, что и зачем ваш код исправляет.
4. Если ваше исправление требует обновления документации (справки,
   Энциклопедии и т.п.), не забудьте и ее обновить.
5. Исправления желательно отправлять в виде пулл реквестов в репозиторий
   или в виде diff-файлов на наш [багтрекер](https://bugs.farmanager.com)
   или [форум](https://forum.farmanager.com/viewforum.php?f=54).
6. Если вы планируете вносить большие исправления или просто желаете находиться
   в курсе последних событий в разработке Far'а, подпишитесь на нашу
   [рассылку для разработчиков](https://groups.google.com/group/fardev) (<fardev@googlegroups.com>).
7. Если вы будете присылать нам исправления часто и хорошего качества,
   вам будет предоставлен полный доступ к репозиторию, на наше усмотрение.


#### Сборка

```
cd far
```

1. Для сборки в Visual Studio можно использовать проект для IDE или makefile.<br/>
   Пример для msbuild & vcxproj:<br/>
   `msbuild /property:Configuration=Release;platform=x64 far.vcxproj`<br/>
   Пример для nmake & makefile:<br/>
   `nmake /f makefile_vc`

2. Для сборки в GCC можно использовать makefile.<br/>
   Пример для MinGW & makefile:<br/>
   `mingw32-make -f makefile_gcc`

> Также см. комментарии в makefile_* для дополнительных параметров сборки.


#### Описание изменений - файл `changelog`

1. Все комментарии по внесенным изменениям пишутся в файл `changelog`.
   В исходном коде имеет смысл оставлять комментарии только если участок
   может быть непонятен для "будущих поколений".
2. Изменения добавляются в начало файла.
3. Каждая запись начинается с шапки вида:
```
--------------------------------------------------------------------------------
warp 2006-12-05 01:39:38+03:00 - build 2149
```
4. Изменениям может не присваиваться билд, например, была косметика или
   изменения не в коде.
5. Пример макроса для создания шапки: [ChangelogHeader.lua](./misc/changelog/ChangelogHeader.lua)

#### farversion.m4

1. Этот файл содержит информацию для генерирования версии Far:
   * `SPECIAL_VERSION`, строка, которая, если задана, помечает сборку как специальную.
      - Предназначено для выпуска версий Far, код которых
        ещё не вошел в репозиторий, чтоб не путать пользователей и нас.
      - Если не задана, тип сборки будет определён переменной окружения FARMANAGER_BUILD_TYPE.
        Если переменная не задана, тип сборки будет приватным.
        Поддерживаемые типы сборок см. в перечислении VERSION_STAGE в plugin.hpp.
   * `VERSION_MAJOR` - мажорная версия Far (например, 3).
   * `VERSION_MINOR` - минорная версия Far (например, 0).
   * `VERSION_REVISION` - ревизия версии Far (например, 0).
   * `VERSION_BUILD` - задаётся в файле `vbuild.m4`.


#### vbuild.m4

1. Если в файле `vbuild.m4` был изменен номер билда, то после коммита
   изменений в репозиторий необходимо запустить `tag_build.bat`.


#### Добавление новых строк в языковые файлы

1. Lng-файлы ренерируются автоматически.
   Добавлять изменения надо в `farlang.templ.m4`.
   Если вы не знаете, как перевести новые строки на какой-либо язык,
   используйте английский вариант с префиксом `upd:`.


#### x64 - обеспечение удачной компиляции для x86 и x64

1. DWORD_PTR, LONG_PTR, etc. применяется вместо DWORD/long/etc. в следующих
   случаях:

   - нужны там где раньше были int/long/dword/или_любой_не_поинтер_тип_даных
      и в него пихали поинтер
   - ...
   - ...


> Напоминаниям, TODO, примечаниям и т. п. место на [багтрекере](https://bugs.farmanager.com).
