bind = '127.0.0.1:8001'
backlog = 2048

workers = 2
worker_class = 'eventlet'
worker_connections = 1000
timeout = 120
keepalive = 2

# spew = True

daemon = False
pidfile = None
umask = 0
user = None
group = None
tmp_upload_dir = None

debug = True
errorlog = 'logs/errors.log'
loglevel = 'debug'
logfile = 'logs/debug.log'
accesslog = 'logs/access.log'
# captureoutput = True


proc_name = None

def post_fork(server, worker):
    server.log.info("Worker spawned (pid: %s)", worker.pid)


def pre_fork(server, worker):
    pass


def pre_exec(server):
    server.log.info("Forked child, re-executing.")


def when_ready(server):
    server.log.info("Server is ready. Spawning workers")


def worker_int(worker):
    worker.log.info("worker received INT or QUIT signal")

    # get traceback info
    import threading, sys, traceback
    id2name = dict([(th.ident, th.name) for th in threading.enumerate()])
    code = []
    for threadId, stack in sys._current_frames().items():
        code.append("\n# Thread: %s(%d)" % (id2name.get(threadId,""),
            threadId))
        for filename, lineno, name, line in traceback.extract_stack(stack):
            code.append('File: "%s", line %d, in %s' % (filename,
                lineno, name))
            if line:
                code.append("  %s" % (line.strip()))
    worker.log.debug("\n".join(code))


def worker_abort(worker):
    worker.log.info("worker received SIGABRT signal")
