### 如何靠谱

靠谱是什么？我对你的行为有所预期。

驱动靠谱的是什么？我和你在一起有安全感。

安全感并不一定要求你什么都能做到，而是说你能搞定就告诉我，你不能搞定也要告诉我。

所谓专家，并非什么问题都能解决，而是他的评估更加准确。换句话说，如果他说自己能完成，就一定能完成。如果他说不能完成，就很可能不能完成。

如何让对方有安全感呢？第一步是让对方觉得你能理解他。一位心理咨询师分享过一个故事：他和某个人聊天，对方聊了一下午，他自己却没有说几句话，但是对方最后说：“你真是一个很会说话的人。”这句话背后的含义是：你让我感觉到了你能理解我。

一个总是号称自己无所不能的人反而很难建立安全感。这也解释了暴漏自己的弱点，有时更能让双方建立信任。如果把这个话题展开，双方互相把持着对方的把柄，说不定能更好的合作。

但这些都是术上的方法。那一个人的靠谱度是如何评估的呢？要看有多少靠谱的人说你靠谱。

#### 摘抄自《罗振宇——靠谱和闭环》

放在过去，你可能会选“善良”、“能力强”这样的词。可是你发现没有，现在越来越多用来高度评价别人的词是——“靠谱”。

靠谱，正在变成一个人社会生存的首要优点。

这个变化背后，其实有一个大趋势在起作用。我们首先得定义什么是靠谱，最近我看到一篇文章，说靠谱就是三件事：

“凡事有交代，件件有着落，事事有回音。”

说是三件事，其实是一件事，就是你要在协作中完成闭环。所谓闭环，就是一件事有开头，就必有结尾。但是一般人做到这一条并不容易。

我们可以自省一下：进行一项事情，你不会半途而废吗？一件东西用完之后，你一定放回原地吗？别人跟你说一件事，你办不办得成，都一定会回复吗？如果当时不能及时回复，在你能回复的时候，你会解释一下上次不回复的原因吗？

这都叫有开头，必有结尾，一件事在你这里完成了闭环。

当年我刚入行媒体的时候，有一位老记者就跟我讲，张瑞敏在海尔抓管理，最开始是从工人不要在厂区随地大小便开始的。等完成了这种基本素质教育，再抓管理，重要的抓手，就是“闭环”两个字。

比如，在海尔上班的时候，你把椅子从桌子下拖出来，坐下开始工作。但是可能一会儿又要起身去办事，那就一定要把椅子推回去，否则就是犯规。海尔管理员工闭环，是从这么细致的地方入手的。

我还记得那位老记者怕我不信，给我现场做了个示范。他抓起电话，给青岛的海尔总部总机拨了个电话，接通之后说，“我找罗振宇。”海尔哪有叫罗振宇的，所以总机就问，罗振宇是哪个部门的？老记者就瞎编了个部门。总机说，您给我几分钟，我来查一下，我让他回电话给您。

你想，一般查无此人，不就算了吗？但是过了几分钟，那位总机竟然把电话回过来了，说整个海尔都查过了，确实没有罗振宇这个人。

你看，当时已经有电脑了，所以查无此人并不难。但是难在有始有终，把这个动作给闭环了。一个总机接线员，接到一个问询，他不能让这个事耽搁在自己手里，无论如何他都要给出一个结果。

所以你看，靠谱不是说你很能干，不是说你答应了什么就一定能做到什么。那是神仙，那不叫靠谱。靠谱，是你和周边的协作网络保持高效的互动。都说海尔管理好，好就好在这里。

所有的人都因为这个闭环的行为习惯，和他人、和组织首尾相接，凝结成了一个高效的行为网络。这种高效体现在两个方面：

第一，不断线。刚才说“凡事有交代，件件有着落，事事有回音。”这三点，本质上就是不断开和协作网络的链接。你从协作网络上接到一个信息或者任务，处理完毕之后，一定要再反馈给网络，确保两头连接。

比如，你可能接到过有人发来这样的信息：“我手机快要没电了。咱们先聊着，等下万一我没声了，就是手机断电了。我20分钟之后能充上电，先跟你说一下。”

这样的人，不管是生意伙伴还是生活伴侣，都差不到哪儿去，都是靠谱的人。因为他们特别在意，不失去和你的链接。这是在网络社会生存的第一法则，不断线。

还有第二个法则，就是“可预测性”。

不是要求你有多大本事，而是你的能力边界要让协作伙伴知道，他们能确定在什么情况下可以找你，找你能把问题解决到什么程度。

作为一个网络节点，最大的美德，不是能力强，而是不给协作者带来风险。有些人能力很强，但是答应的事做不到，遇到危机不求助，直到把小麻烦拖成大麻烦。这也叫不靠谱。

在网络协同的环境下，能力大，不如能力确定。能力越确定的节点，吸引到的连接就越多。连接越多，价值就越大，这是对你靠谱的回报。

你看，“靠谱”这种品质正在变得越来越重要，为啥？因为衡量人的价值尺度正在发生重大变化。

过去，一个人被高度评价，是因为他个人能力强、品质佳。但是现在一个人被高度评价，是因为他能够更顺畅地和网络协同，甚至能够领导和发起网络协同。从网络的角度评估人，而不是孤立地看这个人本身，已经是我们的一种认知习惯。

我们可以从这个话题稍微延伸出去一点，为什么网络协同这么重要？因为网络效应，是人类财富增长和平等化最重要的工具，也是人类文明发展最基本、最底层的逻辑。

最近我在「得到」App的订阅专栏《何帆大局观》里面看到一个例子。

大约在1910-1940年间，美国出现了一次住宅革命。原来美国的房子，不管是富翁的豪宅，还是贫民的草屋，都是各自独立的。进入20世纪之后，房子逐渐互相连接了起来。

连接起来有什么好处？电线接进了家家户户；自来水龙头一拧，干净的水就哗哗流了出来；排水管道和给水管道分开了，污水和排泄物神秘地消失了；中央供暖系统日益普及；越来越多的家庭装上了电话，这是住宅的网络化。

网络化带来了两个好处。

第一，当然是财富和繁荣，是人类生活条件的提升和改善。更重要的是，网络化一定会带来平等。

很多人只看到，网络化加强了贫富差距，但是没看到网络化是用另一种方式实现了平等。就拿住宅网络化来说，富人的豪宅里有自来水，穷人的陋室里也有自来水；富人的电灯很亮，穷人的电灯一样亮。这些设施和产品，最早是从富人那里时兴的，随后逐渐扩展到中产阶级，最后在穷人家里也普及了。

从更广阔的视野来看，富人能看到的电视节目，富人能享受的城市基础设施，也一样普惠到了穷人。所以，美国才有人说，美国社会最伟大的成就是啥？不是什么GDP数字，不是什么高楼大厦，是美国总统和街角的乞丐都能喝的上可口可乐，而且是一样好的可口可乐。

所以，加入一个网络，不仅每个节点都在贡献自己的价值，反过来，网络也在向每个节点反馈更大的价值。

正是因为这个效应，所以人类社会一直在往网络协同方向演进，这是比任何小趋势都更为根本的大趋势。

所以何帆老师提醒说，1910-1940年对美国来说，并不是一个太平年代，有经济危机、有战争，但是住宅革命似乎并没有受到影响，为啥？因为不断地联网，这是一个无可阻挡的大趋势。

所以这个时代，每个人审视自己的处境，都不再是“学会啥啥啥，就不怕啥啥啥”的模式了，而是要看两点：

第一，你是不是在正确的网络中。

第二，你的行为模式是不是和网络紧密连接，是否成为网络中受益最大的节点。

说白了，在正确的群体内，做靠谱的人，才是这个时代的生存策略。

#### 你的责任就是你的责任

心情不好了，我喜欢把责任推给他人；遇到困难了，我喜欢把责任推给他人；做事无聊了，我喜欢把责任推给他人。

我们可以把责任推给他人，但是我们也可以把责任留给自己。这不一定说什么事都要自己做，但是我们可以看到我们喜欢把责任推给他人的习性。

看见是改变的开始。我们可以看到本是我们自己的责任，也可以看到自己把责任推给他人。我们可以感谢他人帮我们承担责任，我们也可以逐步承担起自己的责任。

但这也不是说我们不给他人承担责任的机会，责任给了我们前进的理由，让我们走出自己的舒适区，这可以是创业的责任，这也可以是对孩子的责任，还有对父母的责任。我们更有责任让世界更美好，而不是一团糟。不用逃避责任，不用把你自己最不想做的事情丢给他人。

你也许会问：难道你自己就没有逃避责任啦？当然有了。但是你的责任依旧是你的责任。
