### 如何满足用户需求

#### 工作七年，我学会了一个道理

自从2010年进入企业，从创业公司到大型公司，从中国到美国，从工程师到总监，从加入别人公司到自己开公司，经历了职场的各个阶段，也经历了产品的各个阶段。只是到了今天，才回到一个最基本的话题，如何做一家成功的企业？

这需要三步走：
1. 定义用户
2. 理解用户
3. 满足用户

对用户的定义是一切的起点。我却总是忽略它。我们自以为知道用户是谁，或者笼统地说谁都能成为用户。但这些都是不清楚的定义，没有了这个定义，我们一切的工作都无法展开。

理解用户甚至高于满足用户，我们常常因为不知道自己不知道，无法满足用户，或者说错误的去满足用户。因此，理解用户让我们全方面的从不同的维度去认识我们的用户。心理学、管理学、经济学、历史学都是我们去理解用户的知识积累。当然也有很多不懂这些道理的人也能理解用户，这需要我们和用户混在一起，团结在一起，成为用户的一部分。

理解了用户，我们才能去满足用户。所谓满足，一个是让用户快乐，一个是让用户成功。当我们的产品能够同时满足两者的时候，我们离成功就不远了。

我自己的经验，以及我看到很多身边人的经验，大家往往只注重满足用户，忽略了定义和理解用户，因此只是在表面打转，而不能深入找到10x的增长点。更有甚者，连满足用户都没有做到，只是在满足自己。因此，即使每天忙忙碌碌，也没有什么进展。

一个如此简单的道理，却是如此需要我们突破内心的围墙。当你有一天走出了这道围墙，你也会感受到那份波澜不惊的心情。


#### 满足她以为的需求

我们总是急于满足我们以为的需求，却忽视了她以为的需求。因此你的产品没人买，甚至没有女朋友。

你说：做人就要释放自己，追求自我。
我说：这是逃避现实的最好借口。

你说：用户不知道自己要什么。
我说：这是成功者的托词，失败者的借口。

你说：你累了。
那我只好等待，等待你做回自己。

你说：沁原，你怎么自我矛盾。刚才说追求自己是在找借口，如今又让我做回自己。
我说：其实没有人会看出我话语的矛盾，因为98%的人从不会思考。

你说：你的文章是写给自己还是写给他人。
我说：现在的文章还是写给自己。

文字写得越多，越能感受到背后的魅力。想起了前一段与飞总一起聊天。我问他是如何知道一篇文章是否会火？他说写多了就知道了。写给自己是知道自己有什么，自己在想什么；写给他人是满足他人想要的，或者说他以为想要的。这两者本来也许没有那么冲突。关键在于我们对人性的探究是否足够的深刻。

有时候我会觉得写作是在还债，甚至是在偿还读书的债。读了那么多，我自以为是在学习，实际上也许只是在寻找安全感，当然学习是一个很好的副产品。因此，面对焦虑，写作反而成了我的新宠。

这么说来，我们的内心构建了理解世界的模型，但是进入他人内心的钥匙还是他们自以为的刚需。我们需要从这个刚需出发，探究背后的恐惧，用这份恐惧带着我们来到真相的面前。

那些看似矛盾的情节，似乎不是那么矛盾了。尽管这也许只是逻辑的美好罢了。但我们依然前行。

#### 屁股决定脑袋

需求是什么？需求是一个屁股需要解决的问题。

如果你是一个新生儿的妈妈，宝贝每天晚上闹不睡觉，你自然想要解决宝贝睡觉的问题。如果你是一个要毕业的学生，你的工作却一直没有着落，你自然想要解决找工作的问题。如果你是一个CEO，你的企业一直在亏损，你自然想要解决盈利的问题。如果你看到身边的人住了大房子，你自然也想要个大房子。但是如果你没钱，你自然想要多挣钱。

在Carl给我的一封邮件中，他告诉了我做企业的三点：
1. 定义你的用户
2. 从内而外理解你的用户
3. 让他们快乐而成功

仔细想来，确实是这样的简单。当你把屁股放在了求职者身上，你会更加理解这背后的道理。


#### 需求来自于社会认知

我们常常说用户调研，我们想知道的是用户需要什么。这背后要看的是，用户觉得自己需要什么，再往后看的是用户自以为需要什么。说白了， 就是社会认知到自己需要什么。


#### 如何了解需求

我们想了解暗恋的他，我们想了解那个顾客，我们想了解这一切。我总是看不懂他，但是我们总想了解她。读懂自己，是一切的起源，因为人性毕竟是相通的。

了解一个人也许并不难，难在如何影响他。因为影响的基础是你有实力，如果你的实力不够，即使是看到了也无法影响。

当我们反复说要了解用户需求，其实我们内心也许是知道用户需求的，但是我们却无法满足。了解需求是一个很容易挂在嘴边的话，也很容易成为我们的替罪羊，因此我们总是在反复的讲了解需求。

需求只是一个面向，另一个面向是如何满足。我们构建我们的产品与服务，就是为了能够恰好满足用户的渴望。创业就是在确定需求的基础上，寻找一个恰好的模型来满足它。

有时候，满足它也许才是最难的。

#### 从需求出发还是从问题出发

问题是把锁，为了打开这把锁，我们要找到钥匙，而不是锁。但是对锁的深入理解，能够帮我们定位钥匙的所在地。当我们研究了足够多的锁之后，就能抽象出钥匙的共性，从而找到那把钥匙。

问题是需求的一个一个具体的表现，而需求是问题背后的驱动力。需求是我们要探索的事物，而问题是我们的起点。因此，我们首先要梳理问题，探寻答案；然后对问题进行分类和逻辑组织，寻找背后的需求；最后再从需求的角度统领问题，给出系统的答案。

因此，看似一道选择题，实际上也有深刻的逻辑关系，当我们分析得到这样的逻辑关系之后，就能看到何去何从。可是现实往往是更复杂的，但是蒙蔽我们双眼的并非所谓的复杂，而是我们假装没看见。找到最基本的那一点，十而倍之，才是获胜的法宝。

有时候，坐下来想一想，会让我们看的更清晰。
