### 如何定目标

做一件任务，要思考自己的预期是什么。在任务的中途和结束，我们会考核是否达到了预期。

预期可以分为A和B，B是满足预期，而A是超过预期。如何定义A和B呢？假设做任务的人的能力等级为x，当他做出了x等级的目标，那就是B；当他做出了接近于x+1等级的目标，那就是A；如果做出了超过x+1等级的目标，那就是A+。一般来说每个等级之间差距的比例是1.42倍。

举个读书的例子，一个人平均每个月读一本书，如果他能每两周读一本书，就算实现了A的目标。再举一个销售的例子，假设平均的月收入是100万，那么如果实现了140万，可以算是实现了A的目标。考试成绩也是如此，如果你的平均排名是100，那么考到70名，就是A目标了。

德鲁克说过：只有被评估，才能被改进。因此在做一件事前思考自己的预期，并且实时的给予自己反馈，这样才能小步快跑的箭速迭代。

比如，我对自己的一个期待是每天发表一篇文章，一共发表1000篇。那么如果我能做到每天两篇，那就算是一个A目标了吧？


#### 区分什么是目标，什么是限制

很多人的生命搞混了目标与限制之间的区别。比如说，做一道数学优化的题目，我们往往有一个最优目标，但是我们也会有很多限制条件。在解这道数学题之前，我们需要搞清楚什么是目标，什么是限制，不然无从下手。

这是一个简单的道理，但在生活中我们却总把它搞混。举个例子，我们赚钱是为了更好的成长。这么说来成长是目标，生存是限制。但是很多人一辈子只是把赚钱当成了目标，于是陷入了各种各样的痛苦。

我们的一生有很多阶段性的目标。我觉得有一个分界岭，就是搞清楚自己生命的意义。在搞清楚生命的意义之后，我们才能以此来优化我们生命的目标。在搞清楚生命的意义之前，我们可以把搞清楚作为我们的目标。

做BitTiger也是如此。公司的盈利项目是我们的限制条件。因为公司要运作，需要给大家发工资，让每个人能过上一个体面的生活。但是这绝对不是公司的目标，公司的目标是让十亿人终身学习。只有理解了这个道理，才不会走偏，落入深渊。


#### 你的目标是什么

有一位好朋友，曾经告诉过我：他过年有一个仪式，和几个密友一起聊年度计划。我经过了好多年，才养成了做年度计划的习惯，从此我进入了指数成长的道路。今天就来分享我是如何定目标的。

我会从不同的粒度：一天、一周、一月、一季度、一年、五年、十年、一辈子去制定我的目标。这样做的好处是，在不同的尺度上看自己，并且审视自己到底要什么。一开始不用着急，我也是前前后后用了几年才把把它填满。填上以后也是可以随时更新的，不用有任何的心理压力。

一辈子的墓志铭：一朵玫瑰、绽放过、凋零过、爱过。
我一直在想我的生命旋律是什么，脑海总是浮现出一朵绽放的玫瑰，这不是《小王子》里柔弱的玫瑰，而是铿锵的玫瑰；每当我想起《挪威的森林》，我的脑海就会浮现一朵枯萎的玫瑰。经历了死，才明白生，才明白鲜活。

十年：让全世界的学习效率提升十倍。
我花了很多的精力在实践最有效的学习方法，暂且称之为AL，我也开始和朋友一起分享，希望能帮助每一个人。

五年：让十亿人终身学习。
从创立BitTiger到找到自己的使命，这是一条惊险的道路，看似走错每一步都不会有今天，但是命运又是如此的坚决，让我们一直走到了现在。

一年：事业、健康、关系、投资。
我不断的优化自己的年度计划，并且聚焦在了这四点。如果用一句话来分别总结，可以这么说：事业，关注长期指数增长的组织；健康，CEO的生活习惯；关系，共同成长；投资，引领价值。

一季度、一月、一周、一天：这些都是围绕着BitTiger来规划，互相关联，形成系统。

好啦，有了目标，那就开工吧。


#### 应该强化优点还是补足缺点

我的答案是：首先要找到一件自己能够或者渴望做到世界第一的事情。这是因为目标是最好的判断标准。在这个基础上，强化帮助实现目标的优点，补足阻碍实现目标的缺点。

但是我发现大多数人是没有目标的。话虽这么说，但实际上是没有大目标，依然有小目标。那么我们就从当前的小目标出发，利用“指数思维”去找到下一个阶梯的目标，并以此作为我们评估的标准。

虽然目标定了，但是实现目标的路线可以不同，因此我们也要不断树立我们的路线，从而能够帮助我们做出判断。选择多了，我们往往会陷入一种选择困难的状态。每个选择都有其优点和缺点，让我们驻足不前。这时候的一个好标准是：寻找让自己长期内在价值指数增长的选择。在我看来，有三个能力是一定要强化为优点：逻辑思维、指数思维、多维思维。想了解详情的朋友，可以在我们之前的文章中寻找更多的介绍。

如果还是看不清，那么多找找过来人讨论。这里的窍诀是不要找和你水平差不多的人，一定要找你认为最优秀的人。因为他的高度会限制你的高度，进而影响你的成长速度。
