(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     30500,        707]
NotebookOptionsPosition[     29671,        673]
NotebookOutlinePosition[     30006,        688]
CellTagsIndexPosition[     29963,        685]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", "n", "]"}], "\[Equal]", 
      RowBox[{"2", " ", 
       RowBox[{"a", "[", 
        RowBox[{"n", "-", "1"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"a", "[", "1", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"a", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellChangeTimes->{{3.705562627936607*^9, 3.705562627936844*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "[", "n", "]"}], "\[Rule]", 
    SuperscriptBox["2", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.705562629178144*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"t", "[", "u", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"t", "[", 
        RowBox[{"u", "-", "1"}], "]"}], " ", "+", " ", 
       RowBox[{"u", " ", "^", "2"}]}]}], ",", 
     RowBox[{
      RowBox[{"t", "[", "1", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"t", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellChangeTimes->{{3.705562630793707*^9, 3.705562670583549*^9}}],

Cell[BoxData[
 TemplateBox[{
  "RSolve","deqx",
   "\"Supplied equations are not difference equations of the given functions.\
\"",2,2,1,29451534515008069485,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.705562671831038*^9}],

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"t", "[", "u", "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["u", "2"], "+", 
       RowBox[{"t", "[", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "u"}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"t", "[", "1", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"t", "[", "n", "]"}], ",", "n"}], "]"}]], "Output",
 CellChangeTimes->{3.705562671831993*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"T", "[", "1", "]"}], "=", "1"}], "\n", 
 RowBox[{
  RowBox[{"T", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"T", "[", 
    RowBox[{"n", "-", "1"}], "]"}], "+", 
   RowBox[{"n", "^", "2"}]}]}], "\n", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"T", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "100", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.705562731858838*^9, 3.7055627511593723`*^9}}],

Cell[BoxData["1"], "Output",
 CellChangeTimes->{3.7055627516083508`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "14", ",", "55", ",", "140", ",", "285", ",", "506", ",", "819", 
   ",", "1240", ",", "1785", ",", "2470", ",", "3311", ",", "4324", ",", 
   "5525", ",", "6930", ",", "8555", ",", "10416", ",", "12529", ",", "14910",
    ",", "17575", ",", "20540", ",", "23821", ",", "27434", ",", "31395", ",",
    "35720", ",", "40425", ",", "45526", ",", "51039", ",", "56980", ",", 
   "63365", ",", "70210", ",", "77531", ",", "85344", ",", "93665", ",", 
   "102510", ",", "111895", ",", "121836", ",", "132349", ",", "143450", ",", 
   "155155", ",", "167480", ",", "180441", ",", "194054", ",", "208335", ",", 
   "223300", ",", "238965", ",", "255346", ",", "272459", ",", "290320", ",", 
   "308945", ",", "328350"}], "}"}]], "Output",
 CellChangeTimes->{3.7055627516185017`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"n", "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "100", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.705562811503079*^9, 3.7055628280368433`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "9", ",", "25", ",", "49", ",", "81", ",", "121", ",", "169", ",",
    "225", ",", "289", ",", "361", ",", "441", ",", "529", ",", "625", ",", 
   "729", ",", "841", ",", "961", ",", "1089", ",", "1225", ",", "1369", ",", 
   "1521", ",", "1681", ",", "1849", ",", "2025", ",", "2209", ",", "2401", 
   ",", "2601", ",", "2809", ",", "3025", ",", "3249", ",", "3481", ",", 
   "3721", ",", "3969", ",", "4225", ",", "4489", ",", "4761", ",", "5041", 
   ",", "5329", ",", "5625", ",", "5929", ",", "6241", ",", "6561", ",", 
   "6889", ",", "7225", ",", "7569", ",", "7921", ",", "8281", ",", "8649", 
   ",", "9025", ",", "9409", ",", "9801"}], "}"}]], "Output",
 CellChangeTimes->{3.705562828617756*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"T", "[", "n", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "1", ",", "100", ",", "1"}], "}"}]}], "]"}], ",", 
     " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"n", "^", "2"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "1", ",", "100", ",", "1"}], "}"}]}], "]"}], ",", 
     " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"n", "^", "2.5"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "1", ",", "100", ",", "1"}], "}"}]}], "]"}], ",", 
     " ", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"n", "^", "3"}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "1", ",", "100", ",", "1"}], "}"}]}], "]"}]}], 
    "}"}], " ", ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", "Automatic"}], ",", " ", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<t(n)\>\"", ",", " ", "\"\<n\.b2\>\"", ",", "\"\<n^2.5\>\"", ",", 
      " ", "\"\<n\.b3\>\""}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.705562837884287*^9, 3.705562861854917*^9}, {
  3.70556291399767*^9, 3.705562917280882*^9}, {3.705562949507283*^9, 
  3.705563081504541*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.007333333333333334], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        PointBox[CompressedData["
1:eJxV1FtIUwEAxvGT5Vp2cdkeIoKWjLQmYWWZZrmplZnVNK0VPVjUQxDVnhq9
dKheAiErokEPLQKzh2QQwiiUQ0QMITK7SRdZJTUSZV0sKqPL+f4vHhgfP77z
Hc7Z2Fm470jjgSzDMPb/+/xPHZnKiWn4FW7SSRaRLnLdxPPMzXiu0tqB59Pv
xR58EOcr+8LYq3RF8CJl7AQuVAZP4yXK6JmJ95k4i5cqWy7gYnwJL1MOXcbL
lcdjeIWy/houUR5qxyuVgzfwKmX7TVzK9eN4tdJ7C5cpL3bhcmVZAq9R5t3B
Fcr8HrzWTrPLwvpdzGN3caUydA/78X2lKZuRJH1Avt1LLxsLHtBXKa8/pJet
xY/oq+Xz/fSykfuEvkZ55Sm97K9+Tr9eHh+gl83eF/Qb5M5X9LLVMUi/0c7U
nhS9bITf0Ncqz72llz3d7+g32RkbG6KXrfL39HVy6wd6OTWcptf/oCX0kV42
+4fp6+XdI/RyLDNKv8XOtroMvezxfqLfKmd/ppfjI9jYZmfm9Rd62Xj2lT6I
x5R+2TX4jfPl4Oh32ZJTjh/sG+SCn+zlow2/2MvxU+PsZavnN/tGOesPezld
YAS0l52PsSX3nZwkG9t1f6VZsl+OZrApJzons5et8BT2TXJZNns56XCwl9MD
2JKL41PZN+v5Wp3s5cjhaezlaHMOe9lTNZ293ouekhns5Q7fTPZysnAWe7nN
l8t+p76feS72ctFVbMoVvtnsZX8CGyG5No+9XPMSm3JTeA57OZLjZr/LdqLd
HfgLeezrPQ==
         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.007333333333333334], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        PointBox[CompressedData["
1:eJxd1Llr03Ech/EfpUPHIA4ODlWCqBTRetarMVatt9Z7ES0tOAiKiCCCfFWU
KCKpJ1XRttb7rPdtbB26+j90cVM3N5XPq0MbCA/P7+H9+yYhyYTWfS3tVVmW
tf17/mc8fjaOZFYI5LAGJ466Ph3HYgOOwyKOD6ZmXosbRt63sJnncQdO0nfy
ydiKU4O17bzOeXv4NH3vqNe9H2cEcwd4vfMO8pnB8iE+Cw/jbP0In2N/lM8N
lhKfh8fR51Y6wed7vSf5guDgKb4wmEp8UbD5DF9sf5Y3BmvO8QKW3YdXd7i+
JJg7r/P8Bb3o/V3UedslfWmwfFnn367oTdip86arri+zv6bzoev6cuff0Hnv
TX1FsNSl82K3Pvw97NF5P89W2t/SeUuvvipYe1vnv3m2Ojh4R+c9d/U1rt9D
3npfXxtsfqDz+of6Ouc/0vmYx/r6YM0TnVc91Yd/d8+CBX6MJ17dF6zw0zzb
GMw9t+edPPH8C3vex7MWu5fIv/PE217Z8z882xQsv7bnU97Y82+8wne/tR/+
n3lnz7t54k3v7fkPnm1x/gd73vDRng/xCu/4ZL/V7jPyXzzx3i/24amuYr8t
WOKF8DTEk178aq938Ww79tuHp1086f28oucH7PwvlwYKfwEalsWo
         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.007333333333333334], 
         RGBColor[0.560181, 0.691569, 0.194885], 
         AbsoluteThickness[1.6]], 
        PointBox[CompressedData["
1:eJxVlH1M1HUcx38GJio6hpDVqPBh0sIsHzDjeHjj8XiA93wcGnBeqZMajJCY
St0tC1JDTA5B3UCXWrRI1EvlhNt1jEqMEJVDEjQUUe9AQEyZRav8vf/ptt/e
e+219+3u+/t8vnOMuap1TwmC8M6/z38pfkai/58C2iSm9dUHn4GIPoDu7TjZ
q6+R/ZhgBiA+54Wb2WPJ5GehidvhqpmuIwehvHiyffsyAzmY37+ePFdMQw55
PtIrHw8dbs4nL8BL5bfkfwVsJr/M32MivwJj7Pzd1mnbyAux6YI6zOMuJi9C
qtXVkCnZSX6duZu5GBX7B43y6j3kJWhuka35YEsFeSnG8vq8sbeKvIz/9wA5
DOVrO3tqy2vIy+FuyPtc1XiI/AYaCjMMEx1fklfwfI6S3xQz+2tyONRexV3X
h74hS3Bd1muaqKwjR/A868mREOokeYP1x8lR2DbF2WKOOUmOxpWyWS/WDFjJ
4PmfEtkMnNTNCbmce4Y+BrbzhRaLxkYfg2lep6uXyBvpV4ppsNOvxN7g1sNH
pQ56KR6H+o1bjT/QS7HGsi9UVeqkj+X7baaPxaL8qtxLk1vo49DVmrHBS/Mj
fRxUwoLZq7/7iT6e83COPh51w5aCmZ+10ifAt+zGx9Ypv9AnIKS13tff0kaf
yPlpp098ko6NF+iToLi/pztb2kGfhMyZw02n5l2kl3HeLtHLMHffrKkF42Qh
Ge3RR874DF2mT8a780aeNt/ppE/hfLroU3D1wKdZqx900aei4uIXRb3e3fSp
WFzXkfVJ0G/0qzjPV+lX4WBYynNFa3vo5SjIaPd4dvXSy7H1Q/tHTc3X6BXM
38WEAk67IbrvENmsQPjx2Q+3J/SJ7FCgrMV/16RRsqDkvtxgX4lj8ijnFvlN
9pUwaO95dnj3s68E1hX5lzSRBRX36xb7Ktj+7L+WJRlgXwXT1NhamXCbfRXs
6X62yHNkQc19vMO+GoElW/P0G+6yr0bkjOk9pRFu9tVwpWcG3g70sK/h/pKh
eZLBnYPsa1DVMSloxtkh9jXIz63oWXHkHvta7vsw+1rsH+3WLZWOsK/FQGWA
x2YnO7SICK+/mxMxyr6O9wMZOlzZZPTZGHWffR1qe/tLv3eSHTqEmH9OlCSN
sZ/G+4SMNKgzSh79/dYD9tPge6J9odRNdqRBeb7w+bbNf7Cv5/3zkH09FMLg
+/YaslmPxm/fmwhd/oh9Pb5yu0yeX8lCupjZ4/gHCpzENQ==
         "]]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         PointSize[0.007333333333333334], 
         RGBColor[0.922526, 0.385626, 0.209179], 
         AbsoluteThickness[1.6]], 
        PointBox[CompressedData["
1:eJxd01toUnEAx/HTWrd1wdZSq1FurWVmQ7vNbvO4aq3rbK0yChuxoFHQIOr5
QKsnqRG9rYf10EtPQRSsVZMMEpRAJAphYBciIlBqWFF08/ftoQT58Tk/fud/
jmDdsdOdxysMw+j5/f2T+hSD/6ZhKlzkVHIDaSPDZI3SPIqd5EmyVtl39r/7
WmS9MnkRN3C/y7hRmb6K3eQg6VF6rmMv593ATcroTewjb5F+pf82Xsnz3MWr
lKl7eDXPN4rXlNOyP8Jred7HuFl94gkOkClynfr+p3g975PB+t3jgSzeyPs9
w5vKaWae4xZlNIeD2jvGsEnmlZbsir3kekjpf00vdxfe0Lcqk2/p5aGRd/Sb
lan39HK+9IF+i9Is0MsD2SL91nJa9o/0sq/3E32bMj1OL4eDJfpt2ic+08vF
yFf6dvIbvWwb/s717dr3/6CXI34jpH6HrnsmyJZ8wltBv7PseGAivRzoqKTf
pX3fJHq5fXAy/e6yzcwUetlZPY1+j/bRKnrZfWc6fYfOd8ykl79cmEX/939r
k025MoEt2RWbLcflU4er2e/V3j+HvTw+o4a93F3AcfnIi7nsO7VP2tnLPQ8d
7OWhESd7OT06j/0+7VPz2ctdYwvYy/lSLXv5vmMh+y7tzUXs5VfNLvbyQBbH
ZfuZOvb7y7bs9ezl3ANsyb7exezlS84G9gd0fhqb8pXzS9jL4WAje7ntJzYO
6vzEUvZyVczNXi5GlrGXWzwe9hGdbyxnL7fmsCXbhr3s5XPXVrA/pPP7m0K/
AHlj1iE=
         "]]}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, AxesOrigin -> {0., 0}, 
     PlotRange -> {{0., 100.}, {0, 386365.}}, PlotRangeClipping -> True, 
     ImagePadding -> All, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0., 0}, DisplayFunction :> 
     Identity, Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, PlotRange -> {{0., 100.}, {0, 386365.}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{"\"t(n)\"", "\"n\.b2\"", "\"n^2.5\"", "\"n\.b3\""}, 
      "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.264], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.264], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.264], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.264], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.264], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.264], 
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.264], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.264], 
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.007333333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.007333333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.007333333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.560181, 0.691569, 0.194885], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.37345400000000006`, 0.461046, 0.12992333333333334`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.560181, 0.691569, 0.194885]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.560181, 0.691569, 0.194885]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.560181, 0.691569, 0.194885], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.007333333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.922526, 0.385626, 0.209179], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6150173333333333, 0.25708400000000003`, 
                    0.13945266666666667`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.922526, 0.385626, 0.209179]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.922526, 0.385626, 0.209179]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.922526, 0.385626, 0.209179], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "False", ",", "False", ",", "False"}], 
               "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.705563041487534*^9, 3.7055630510167303`*^9}, 
   3.705563082296913*^9}]
}, Open  ]]
},
WindowSize->{808, 906},
WindowMargins->{{209, Automatic}, {56, Automatic}},
FrontEndVersion->"11.0 for Linux x86 (64-bit) (July 28, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 455, 13, 32, "Input"],
Cell[1038, 37, 249, 8, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1324, 50, 498, 14, 32, "Input"],
Cell[1825, 66, 250, 6, 23, "Message"],
Cell[2078, 74, 486, 15, 42, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2601, 94, 476, 14, 75, "Input"],
Cell[3080, 110, 72, 1, 30, "Output"],
Cell[3155, 113, 827, 13, 109, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4019, 131, 244, 6, 32, "Input"],
Cell[4266, 139, 757, 12, 90, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5060, 156, 1289, 37, 80, "Input"],
Cell[6352, 195, 23303, 475, 374, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

