﻿namespace Unicorn.X86
{
    /// <summary>
    /// Represents the registers of an <see cref="X86Emulator"/>.
    /// </summary>
    public class X86Registers : Registers
    {
        internal X86Registers(Emulator emulator) : base(emulator)
        {
            // Space
        }

        // Generated by /scripts/gen_reg_properties.py.

        /// <summary>
        /// Gets or sets the value of AH register.
        /// </summary>
        public long AH
        {
            get { return Read(1); }
            set { Write(1, value); }
        }

        /// <summary>
        /// Gets or sets the value of AL register.
        /// </summary>
        public long AL
        {
            get { return Read(2); }
            set { Write(2, value); }
        }

        /// <summary>
        /// Gets or sets the value of AX register.
        /// </summary>
        public long AX
        {
            get { return Read(3); }
            set { Write(3, value); }
        }

        /// <summary>
        /// Gets or sets the value of BH register.
        /// </summary>
        public long BH
        {
            get { return Read(4); }
            set { Write(4, value); }
        }

        /// <summary>
        /// Gets or sets the value of BL register.
        /// </summary>
        public long BL
        {
            get { return Read(5); }
            set { Write(5, value); }
        }

        /// <summary>
        /// Gets or sets the value of BP register.
        /// </summary>
        public long BP
        {
            get { return Read(6); }
            set { Write(6, value); }
        }

        /// <summary>
        /// Gets or sets the value of BPL register.
        /// </summary>
        public long BPL
        {
            get { return Read(7); }
            set { Write(7, value); }
        }

        /// <summary>
        /// Gets or sets the value of BX register.
        /// </summary>
        public long BX
        {
            get { return Read(8); }
            set { Write(8, value); }
        }

        /// <summary>
        /// Gets or sets the value of CH register.
        /// </summary>
        public long CH
        {
            get { return Read(9); }
            set { Write(9, value); }
        }

        /// <summary>
        /// Gets or sets the value of CL register.
        /// </summary>
        public long CL
        {
            get { return Read(10); }
            set { Write(10, value); }
        }

        /// <summary>
        /// Gets or sets the value of CS register.
        /// </summary>
        public long CS
        {
            get { return Read(11); }
            set { Write(11, value); }
        }

        /// <summary>
        /// Gets or sets the value of CX register.
        /// </summary>
        public long CX
        {
            get { return Read(12); }
            set { Write(12, value); }
        }

        /// <summary>
        /// Gets or sets the value of DH register.
        /// </summary>
        public long DH
        {
            get { return Read(13); }
            set { Write(13, value); }
        }

        /// <summary>
        /// Gets or sets the value of DI register.
        /// </summary>
        public long DI
        {
            get { return Read(14); }
            set { Write(14, value); }
        }

        /// <summary>
        /// Gets or sets the value of DIL register.
        /// </summary>
        public long DIL
        {
            get { return Read(15); }
            set { Write(15, value); }
        }

        /// <summary>
        /// Gets or sets the value of DL register.
        /// </summary>
        public long DL
        {
            get { return Read(16); }
            set { Write(16, value); }
        }

        /// <summary>
        /// Gets or sets the value of DS register.
        /// </summary>
        public long DS
        {
            get { return Read(17); }
            set { Write(17, value); }
        }

        /// <summary>
        /// Gets or sets the value of DX register.
        /// </summary>
        public long DX
        {
            get { return Read(18); }
            set { Write(18, value); }
        }

        /// <summary>
        /// Gets or sets the value of EAX register.
        /// </summary>
        public long EAX
        {
            get { return Read(19); }
            set { Write(19, value); }
        }

        /// <summary>
        /// Gets or sets the value of EBP register.
        /// </summary>
        public long EBP
        {
            get { return Read(20); }
            set { Write(20, value); }
        }

        /// <summary>
        /// Gets or sets the value of EBX register.
        /// </summary>
        public long EBX
        {
            get { return Read(21); }
            set { Write(21, value); }
        }

        /// <summary>
        /// Gets or sets the value of ECX register.
        /// </summary>
        public long ECX
        {
            get { return Read(22); }
            set { Write(22, value); }
        }

        /// <summary>
        /// Gets or sets the value of EDI register.
        /// </summary>
        public long EDI
        {
            get { return Read(23); }
            set { Write(23, value); }
        }

        /// <summary>
        /// Gets or sets the value of EDX register.
        /// </summary>
        public long EDX
        {
            get { return Read(24); }
            set { Write(24, value); }
        }

        /// <summary>
        /// Gets or sets the value of EFLAGS register.
        /// </summary>
        public long EFLAGS
        {
            get { return Read(25); }
            set { Write(25, value); }
        }

        /// <summary>
        /// Gets or sets the value of EIP register.
        /// </summary>
        public long EIP
        {
            get { return Read(26); }
            set { Write(26, value); }
        }

        /// <summary>
        /// Gets or sets the value of EIZ register.
        /// </summary>
        public long EIZ
        {
            get { return Read(27); }
            set { Write(27, value); }
        }

        /// <summary>
        /// Gets or sets the value of ES register.
        /// </summary>
        public long ES
        {
            get { return Read(28); }
            set { Write(28, value); }
        }

        /// <summary>
        /// Gets or sets the value of ESI register.
        /// </summary>
        public long ESI
        {
            get { return Read(29); }
            set { Write(29, value); }
        }

        /// <summary>
        /// Gets or sets the value of ESP register.
        /// </summary>
        public long ESP
        {
            get { return Read(30); }
            set { Write(30, value); }
        }

        /// <summary>
        /// Gets or sets the value of FPSW register.
        /// </summary>
        public long FPSW
        {
            get { return Read(31); }
            set { Write(31, value); }
        }

        /// <summary>
        /// Gets or sets the value of FS register.
        /// </summary>
        public long FS
        {
            get { return Read(32); }
            set { Write(32, value); }
        }

        /// <summary>
        /// Gets or sets the value of GS register.
        /// </summary>
        public long GS
        {
            get { return Read(33); }
            set { Write(33, value); }
        }

        /// <summary>
        /// Gets or sets the value of IP register.
        /// </summary>
        public long IP
        {
            get { return Read(34); }
            set { Write(34, value); }
        }

        /// <summary>
        /// Gets or sets the value of RAX register.
        /// </summary>
        public long RAX
        {
            get { return Read(35); }
            set { Write(35, value); }
        }

        /// <summary>
        /// Gets or sets the value of RBP register.
        /// </summary>
        public long RBP
        {
            get { return Read(36); }
            set { Write(36, value); }
        }

        /// <summary>
        /// Gets or sets the value of RBX register.
        /// </summary>
        public long RBX
        {
            get { return Read(37); }
            set { Write(37, value); }
        }

        /// <summary>
        /// Gets or sets the value of RCX register.
        /// </summary>
        public long RCX
        {
            get { return Read(38); }
            set { Write(38, value); }
        }

        /// <summary>
        /// Gets or sets the value of RDI register.
        /// </summary>
        public long RDI
        {
            get { return Read(39); }
            set { Write(39, value); }
        }

        /// <summary>
        /// Gets or sets the value of RDX register.
        /// </summary>
        public long RDX
        {
            get { return Read(40); }
            set { Write(40, value); }
        }

        /// <summary>
        /// Gets or sets the value of RIP register.
        /// </summary>
        public long RIP
        {
            get { return Read(41); }
            set { Write(41, value); }
        }

        /// <summary>
        /// Gets or sets the value of RIZ register.
        /// </summary>
        public long RIZ
        {
            get { return Read(42); }
            set { Write(42, value); }
        }

        /// <summary>
        /// Gets or sets the value of RSI register.
        /// </summary>
        public long RSI
        {
            get { return Read(43); }
            set { Write(43, value); }
        }

        /// <summary>
        /// Gets or sets the value of RSP register.
        /// </summary>
        public long RSP
        {
            get { return Read(44); }
            set { Write(44, value); }
        }

        /// <summary>
        /// Gets or sets the value of SI register.
        /// </summary>
        public long SI
        {
            get { return Read(45); }
            set { Write(45, value); }
        }

        /// <summary>
        /// Gets or sets the value of SIL register.
        /// </summary>
        public long SIL
        {
            get { return Read(46); }
            set { Write(46, value); }
        }

        /// <summary>
        /// Gets or sets the value of SP register.
        /// </summary>
        public long SP
        {
            get { return Read(47); }
            set { Write(47, value); }
        }

        /// <summary>
        /// Gets or sets the value of SPL register.
        /// </summary>
        public long SPL
        {
            get { return Read(48); }
            set { Write(48, value); }
        }

        /// <summary>
        /// Gets or sets the value of SS register.
        /// </summary>
        public long SS
        {
            get { return Read(49); }
            set { Write(49, value); }
        }

        /// <summary>
        /// Gets or sets the value of CR0 register.
        /// </summary>
        public long CR0
        {
            get { return Read(50); }
            set { Write(50, value); }
        }

        /// <summary>
        /// Gets or sets the value of CR1 register.
        /// </summary>
        public long CR1
        {
            get { return Read(51); }
            set { Write(51, value); }
        }

        /// <summary>
        /// Gets or sets the value of CR2 register.
        /// </summary>
        public long CR2
        {
            get { return Read(52); }
            set { Write(52, value); }
        }

        /// <summary>
        /// Gets or sets the value of CR3 register.
        /// </summary>
        public long CR3
        {
            get { return Read(53); }
            set { Write(53, value); }
        }

        /// <summary>
        /// Gets or sets the value of CR4 register.
        /// </summary>
        public long CR4
        {
            get { return Read(54); }
            set { Write(54, value); }
        }

        /// <summary>
        /// Gets or sets the value of CR5 register.
        /// </summary>
        public long CR5
        {
            get { return Read(55); }
            set { Write(55, value); }
        }

        /// <summary>
        /// Gets or sets the value of CR6 register.
        /// </summary>
        public long CR6
        {
            get { return Read(56); }
            set { Write(56, value); }
        }

        /// <summary>
        /// Gets or sets the value of CR7 register.
        /// </summary>
        public long CR7
        {
            get { return Read(57); }
            set { Write(57, value); }
        }

        /// <summary>
        /// Gets or sets the value of CR8 register.
        /// </summary>
        public long CR8
        {
            get { return Read(58); }
            set { Write(58, value); }
        }

        /// <summary>
        /// Gets or sets the value of CR9 register.
        /// </summary>
        public long CR9
        {
            get { return Read(59); }
            set { Write(59, value); }
        }

        /// <summary>
        /// Gets or sets the value of CR10 register.
        /// </summary>
        public long CR10
        {
            get { return Read(60); }
            set { Write(60, value); }
        }

        /// <summary>
        /// Gets or sets the value of CR11 register.
        /// </summary>
        public long CR11
        {
            get { return Read(61); }
            set { Write(61, value); }
        }

        /// <summary>
        /// Gets or sets the value of CR12 register.
        /// </summary>
        public long CR12
        {
            get { return Read(62); }
            set { Write(62, value); }
        }

        /// <summary>
        /// Gets or sets the value of CR13 register.
        /// </summary>
        public long CR13
        {
            get { return Read(63); }
            set { Write(63, value); }
        }

        /// <summary>
        /// Gets or sets the value of CR14 register.
        /// </summary>
        public long CR14
        {
            get { return Read(64); }
            set { Write(64, value); }
        }

        /// <summary>
        /// Gets or sets the value of CR15 register.
        /// </summary>
        public long CR15
        {
            get { return Read(65); }
            set { Write(65, value); }
        }

        /// <summary>
        /// Gets or sets the value of DR0 register.
        /// </summary>
        public long DR0
        {
            get { return Read(66); }
            set { Write(66, value); }
        }

        /// <summary>
        /// Gets or sets the value of DR1 register.
        /// </summary>
        public long DR1
        {
            get { return Read(67); }
            set { Write(67, value); }
        }

        /// <summary>
        /// Gets or sets the value of DR2 register.
        /// </summary>
        public long DR2
        {
            get { return Read(68); }
            set { Write(68, value); }
        }

        /// <summary>
        /// Gets or sets the value of DR3 register.
        /// </summary>
        public long DR3
        {
            get { return Read(69); }
            set { Write(69, value); }
        }

        /// <summary>
        /// Gets or sets the value of DR4 register.
        /// </summary>
        public long DR4
        {
            get { return Read(70); }
            set { Write(70, value); }
        }

        /// <summary>
        /// Gets or sets the value of DR5 register.
        /// </summary>
        public long DR5
        {
            get { return Read(71); }
            set { Write(71, value); }
        }

        /// <summary>
        /// Gets or sets the value of DR6 register.
        /// </summary>
        public long DR6
        {
            get { return Read(72); }
            set { Write(72, value); }
        }

        /// <summary>
        /// Gets or sets the value of DR7 register.
        /// </summary>
        public long DR7
        {
            get { return Read(73); }
            set { Write(73, value); }
        }

        /// <summary>
        /// Gets or sets the value of DR8 register.
        /// </summary>
        public long DR8
        {
            get { return Read(74); }
            set { Write(74, value); }
        }

        /// <summary>
        /// Gets or sets the value of DR9 register.
        /// </summary>
        public long DR9
        {
            get { return Read(75); }
            set { Write(75, value); }
        }

        /// <summary>
        /// Gets or sets the value of DR10 register.
        /// </summary>
        public long DR10
        {
            get { return Read(76); }
            set { Write(76, value); }
        }

        /// <summary>
        /// Gets or sets the value of DR11 register.
        /// </summary>
        public long DR11
        {
            get { return Read(77); }
            set { Write(77, value); }
        }

        /// <summary>
        /// Gets or sets the value of DR12 register.
        /// </summary>
        public long DR12
        {
            get { return Read(78); }
            set { Write(78, value); }
        }

        /// <summary>
        /// Gets or sets the value of DR13 register.
        /// </summary>
        public long DR13
        {
            get { return Read(79); }
            set { Write(79, value); }
        }

        /// <summary>
        /// Gets or sets the value of DR14 register.
        /// </summary>
        public long DR14
        {
            get { return Read(80); }
            set { Write(80, value); }
        }

        /// <summary>
        /// Gets or sets the value of DR15 register.
        /// </summary>
        public long DR15
        {
            get { return Read(81); }
            set { Write(81, value); }
        }

        /// <summary>
        /// Gets or sets the value of FP0 register.
        /// </summary>
        public long FP0
        {
            get { return Read(82); }
            set { Write(82, value); }
        }

        /// <summary>
        /// Gets or sets the value of FP1 register.
        /// </summary>
        public long FP1
        {
            get { return Read(83); }
            set { Write(83, value); }
        }

        /// <summary>
        /// Gets or sets the value of FP2 register.
        /// </summary>
        public long FP2
        {
            get { return Read(84); }
            set { Write(84, value); }
        }

        /// <summary>
        /// Gets or sets the value of FP3 register.
        /// </summary>
        public long FP3
        {
            get { return Read(85); }
            set { Write(85, value); }
        }

        /// <summary>
        /// Gets or sets the value of FP4 register.
        /// </summary>
        public long FP4
        {
            get { return Read(86); }
            set { Write(86, value); }
        }

        /// <summary>
        /// Gets or sets the value of FP5 register.
        /// </summary>
        public long FP5
        {
            get { return Read(87); }
            set { Write(87, value); }
        }

        /// <summary>
        /// Gets or sets the value of FP6 register.
        /// </summary>
        public long FP6
        {
            get { return Read(88); }
            set { Write(88, value); }
        }

        /// <summary>
        /// Gets or sets the value of FP7 register.
        /// </summary>
        public long FP7
        {
            get { return Read(89); }
            set { Write(89, value); }
        }

        /// <summary>
        /// Gets or sets the value of K0 register.
        /// </summary>
        public long K0
        {
            get { return Read(90); }
            set { Write(90, value); }
        }

        /// <summary>
        /// Gets or sets the value of K1 register.
        /// </summary>
        public long K1
        {
            get { return Read(91); }
            set { Write(91, value); }
        }

        /// <summary>
        /// Gets or sets the value of K2 register.
        /// </summary>
        public long K2
        {
            get { return Read(92); }
            set { Write(92, value); }
        }

        /// <summary>
        /// Gets or sets the value of K3 register.
        /// </summary>
        public long K3
        {
            get { return Read(93); }
            set { Write(93, value); }
        }

        /// <summary>
        /// Gets or sets the value of K4 register.
        /// </summary>
        public long K4
        {
            get { return Read(94); }
            set { Write(94, value); }
        }

        /// <summary>
        /// Gets or sets the value of K5 register.
        /// </summary>
        public long K5
        {
            get { return Read(95); }
            set { Write(95, value); }
        }

        /// <summary>
        /// Gets or sets the value of K6 register.
        /// </summary>
        public long K6
        {
            get { return Read(96); }
            set { Write(96, value); }
        }

        /// <summary>
        /// Gets or sets the value of K7 register.
        /// </summary>
        public long K7
        {
            get { return Read(97); }
            set { Write(97, value); }
        }

        /// <summary>
        /// Gets or sets the value of MM0 register.
        /// </summary>
        public long MM0
        {
            get { return Read(98); }
            set { Write(98, value); }
        }

        /// <summary>
        /// Gets or sets the value of MM1 register.
        /// </summary>
        public long MM1
        {
            get { return Read(99); }
            set { Write(99, value); }
        }

        /// <summary>
        /// Gets or sets the value of MM2 register.
        /// </summary>
        public long MM2
        {
            get { return Read(100); }
            set { Write(100, value); }
        }

        /// <summary>
        /// Gets or sets the value of MM3 register.
        /// </summary>
        public long MM3
        {
            get { return Read(101); }
            set { Write(101, value); }
        }

        /// <summary>
        /// Gets or sets the value of MM4 register.
        /// </summary>
        public long MM4
        {
            get { return Read(102); }
            set { Write(102, value); }
        }

        /// <summary>
        /// Gets or sets the value of MM5 register.
        /// </summary>
        public long MM5
        {
            get { return Read(103); }
            set { Write(103, value); }
        }

        /// <summary>
        /// Gets or sets the value of MM6 register.
        /// </summary>
        public long MM6
        {
            get { return Read(104); }
            set { Write(104, value); }
        }

        /// <summary>
        /// Gets or sets the value of MM7 register.
        /// </summary>
        public long MM7
        {
            get { return Read(105); }
            set { Write(105, value); }
        }

        /// <summary>
        /// Gets or sets the value of R8 register.
        /// </summary>
        public long R8
        {
            get { return Read(106); }
            set { Write(106, value); }
        }

        /// <summary>
        /// Gets or sets the value of R9 register.
        /// </summary>
        public long R9
        {
            get { return Read(107); }
            set { Write(107, value); }
        }

        /// <summary>
        /// Gets or sets the value of R10 register.
        /// </summary>
        public long R10
        {
            get { return Read(108); }
            set { Write(108, value); }
        }

        /// <summary>
        /// Gets or sets the value of R11 register.
        /// </summary>
        public long R11
        {
            get { return Read(109); }
            set { Write(109, value); }
        }

        /// <summary>
        /// Gets or sets the value of R12 register.
        /// </summary>
        public long R12
        {
            get { return Read(110); }
            set { Write(110, value); }
        }

        /// <summary>
        /// Gets or sets the value of R13 register.
        /// </summary>
        public long R13
        {
            get { return Read(111); }
            set { Write(111, value); }
        }

        /// <summary>
        /// Gets or sets the value of R14 register.
        /// </summary>
        public long R14
        {
            get { return Read(112); }
            set { Write(112, value); }
        }

        /// <summary>
        /// Gets or sets the value of R15 register.
        /// </summary>
        public long R15
        {
            get { return Read(113); }
            set { Write(113, value); }
        }

        /// <summary>
        /// Gets or sets the value of ST0 register.
        /// </summary>
        public long ST0
        {
            get { return Read(114); }
            set { Write(114, value); }
        }

        /// <summary>
        /// Gets or sets the value of ST1 register.
        /// </summary>
        public long ST1
        {
            get { return Read(115); }
            set { Write(115, value); }
        }

        /// <summary>
        /// Gets or sets the value of ST2 register.
        /// </summary>
        public long ST2
        {
            get { return Read(116); }
            set { Write(116, value); }
        }

        /// <summary>
        /// Gets or sets the value of ST3 register.
        /// </summary>
        public long ST3
        {
            get { return Read(117); }
            set { Write(117, value); }
        }

        /// <summary>
        /// Gets or sets the value of ST4 register.
        /// </summary>
        public long ST4
        {
            get { return Read(118); }
            set { Write(118, value); }
        }

        /// <summary>
        /// Gets or sets the value of ST5 register.
        /// </summary>
        public long ST5
        {
            get { return Read(119); }
            set { Write(119, value); }
        }

        /// <summary>
        /// Gets or sets the value of ST6 register.
        /// </summary>
        public long ST6
        {
            get { return Read(120); }
            set { Write(120, value); }
        }

        /// <summary>
        /// Gets or sets the value of ST7 register.
        /// </summary>
        public long ST7
        {
            get { return Read(121); }
            set { Write(121, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM0 register.
        /// </summary>
        public long XMM0
        {
            get { return Read(122); }
            set { Write(122, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM1 register.
        /// </summary>
        public long XMM1
        {
            get { return Read(123); }
            set { Write(123, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM2 register.
        /// </summary>
        public long XMM2
        {
            get { return Read(124); }
            set { Write(124, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM3 register.
        /// </summary>
        public long XMM3
        {
            get { return Read(125); }
            set { Write(125, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM4 register.
        /// </summary>
        public long XMM4
        {
            get { return Read(126); }
            set { Write(126, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM5 register.
        /// </summary>
        public long XMM5
        {
            get { return Read(127); }
            set { Write(127, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM6 register.
        /// </summary>
        public long XMM6
        {
            get { return Read(128); }
            set { Write(128, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM7 register.
        /// </summary>
        public long XMM7
        {
            get { return Read(129); }
            set { Write(129, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM8 register.
        /// </summary>
        public long XMM8
        {
            get { return Read(130); }
            set { Write(130, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM9 register.
        /// </summary>
        public long XMM9
        {
            get { return Read(131); }
            set { Write(131, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM10 register.
        /// </summary>
        public long XMM10
        {
            get { return Read(132); }
            set { Write(132, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM11 register.
        /// </summary>
        public long XMM11
        {
            get { return Read(133); }
            set { Write(133, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM12 register.
        /// </summary>
        public long XMM12
        {
            get { return Read(134); }
            set { Write(134, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM13 register.
        /// </summary>
        public long XMM13
        {
            get { return Read(135); }
            set { Write(135, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM14 register.
        /// </summary>
        public long XMM14
        {
            get { return Read(136); }
            set { Write(136, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM15 register.
        /// </summary>
        public long XMM15
        {
            get { return Read(137); }
            set { Write(137, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM16 register.
        /// </summary>
        public long XMM16
        {
            get { return Read(138); }
            set { Write(138, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM17 register.
        /// </summary>
        public long XMM17
        {
            get { return Read(139); }
            set { Write(139, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM18 register.
        /// </summary>
        public long XMM18
        {
            get { return Read(140); }
            set { Write(140, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM19 register.
        /// </summary>
        public long XMM19
        {
            get { return Read(141); }
            set { Write(141, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM20 register.
        /// </summary>
        public long XMM20
        {
            get { return Read(142); }
            set { Write(142, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM21 register.
        /// </summary>
        public long XMM21
        {
            get { return Read(143); }
            set { Write(143, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM22 register.
        /// </summary>
        public long XMM22
        {
            get { return Read(144); }
            set { Write(144, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM23 register.
        /// </summary>
        public long XMM23
        {
            get { return Read(145); }
            set { Write(145, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM24 register.
        /// </summary>
        public long XMM24
        {
            get { return Read(146); }
            set { Write(146, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM25 register.
        /// </summary>
        public long XMM25
        {
            get { return Read(147); }
            set { Write(147, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM26 register.
        /// </summary>
        public long XMM26
        {
            get { return Read(148); }
            set { Write(148, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM27 register.
        /// </summary>
        public long XMM27
        {
            get { return Read(149); }
            set { Write(149, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM28 register.
        /// </summary>
        public long XMM28
        {
            get { return Read(150); }
            set { Write(150, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM29 register.
        /// </summary>
        public long XMM29
        {
            get { return Read(151); }
            set { Write(151, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM30 register.
        /// </summary>
        public long XMM30
        {
            get { return Read(152); }
            set { Write(152, value); }
        }

        /// <summary>
        /// Gets or sets the value of XMM31 register.
        /// </summary>
        public long XMM31
        {
            get { return Read(153); }
            set { Write(153, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM0 register.
        /// </summary>
        public long YMM0
        {
            get { return Read(154); }
            set { Write(154, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM1 register.
        /// </summary>
        public long YMM1
        {
            get { return Read(155); }
            set { Write(155, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM2 register.
        /// </summary>
        public long YMM2
        {
            get { return Read(156); }
            set { Write(156, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM3 register.
        /// </summary>
        public long YMM3
        {
            get { return Read(157); }
            set { Write(157, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM4 register.
        /// </summary>
        public long YMM4
        {
            get { return Read(158); }
            set { Write(158, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM5 register.
        /// </summary>
        public long YMM5
        {
            get { return Read(159); }
            set { Write(159, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM6 register.
        /// </summary>
        public long YMM6
        {
            get { return Read(160); }
            set { Write(160, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM7 register.
        /// </summary>
        public long YMM7
        {
            get { return Read(161); }
            set { Write(161, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM8 register.
        /// </summary>
        public long YMM8
        {
            get { return Read(162); }
            set { Write(162, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM9 register.
        /// </summary>
        public long YMM9
        {
            get { return Read(163); }
            set { Write(163, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM10 register.
        /// </summary>
        public long YMM10
        {
            get { return Read(164); }
            set { Write(164, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM11 register.
        /// </summary>
        public long YMM11
        {
            get { return Read(165); }
            set { Write(165, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM12 register.
        /// </summary>
        public long YMM12
        {
            get { return Read(166); }
            set { Write(166, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM13 register.
        /// </summary>
        public long YMM13
        {
            get { return Read(167); }
            set { Write(167, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM14 register.
        /// </summary>
        public long YMM14
        {
            get { return Read(168); }
            set { Write(168, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM15 register.
        /// </summary>
        public long YMM15
        {
            get { return Read(169); }
            set { Write(169, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM16 register.
        /// </summary>
        public long YMM16
        {
            get { return Read(170); }
            set { Write(170, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM17 register.
        /// </summary>
        public long YMM17
        {
            get { return Read(171); }
            set { Write(171, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM18 register.
        /// </summary>
        public long YMM18
        {
            get { return Read(172); }
            set { Write(172, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM19 register.
        /// </summary>
        public long YMM19
        {
            get { return Read(173); }
            set { Write(173, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM20 register.
        /// </summary>
        public long YMM20
        {
            get { return Read(174); }
            set { Write(174, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM21 register.
        /// </summary>
        public long YMM21
        {
            get { return Read(175); }
            set { Write(175, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM22 register.
        /// </summary>
        public long YMM22
        {
            get { return Read(176); }
            set { Write(176, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM23 register.
        /// </summary>
        public long YMM23
        {
            get { return Read(177); }
            set { Write(177, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM24 register.
        /// </summary>
        public long YMM24
        {
            get { return Read(178); }
            set { Write(178, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM25 register.
        /// </summary>
        public long YMM25
        {
            get { return Read(179); }
            set { Write(179, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM26 register.
        /// </summary>
        public long YMM26
        {
            get { return Read(180); }
            set { Write(180, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM27 register.
        /// </summary>
        public long YMM27
        {
            get { return Read(181); }
            set { Write(181, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM28 register.
        /// </summary>
        public long YMM28
        {
            get { return Read(182); }
            set { Write(182, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM29 register.
        /// </summary>
        public long YMM29
        {
            get { return Read(183); }
            set { Write(183, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM30 register.
        /// </summary>
        public long YMM30
        {
            get { return Read(184); }
            set { Write(184, value); }
        }

        /// <summary>
        /// Gets or sets the value of YMM31 register.
        /// </summary>
        public long YMM31
        {
            get { return Read(185); }
            set { Write(185, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM0 register.
        /// </summary>
        public long ZMM0
        {
            get { return Read(186); }
            set { Write(186, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM1 register.
        /// </summary>
        public long ZMM1
        {
            get { return Read(187); }
            set { Write(187, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM2 register.
        /// </summary>
        public long ZMM2
        {
            get { return Read(188); }
            set { Write(188, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM3 register.
        /// </summary>
        public long ZMM3
        {
            get { return Read(189); }
            set { Write(189, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM4 register.
        /// </summary>
        public long ZMM4
        {
            get { return Read(190); }
            set { Write(190, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM5 register.
        /// </summary>
        public long ZMM5
        {
            get { return Read(191); }
            set { Write(191, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM6 register.
        /// </summary>
        public long ZMM6
        {
            get { return Read(192); }
            set { Write(192, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM7 register.
        /// </summary>
        public long ZMM7
        {
            get { return Read(193); }
            set { Write(193, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM8 register.
        /// </summary>
        public long ZMM8
        {
            get { return Read(194); }
            set { Write(194, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM9 register.
        /// </summary>
        public long ZMM9
        {
            get { return Read(195); }
            set { Write(195, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM10 register.
        /// </summary>
        public long ZMM10
        {
            get { return Read(196); }
            set { Write(196, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM11 register.
        /// </summary>
        public long ZMM11
        {
            get { return Read(197); }
            set { Write(197, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM12 register.
        /// </summary>
        public long ZMM12
        {
            get { return Read(198); }
            set { Write(198, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM13 register.
        /// </summary>
        public long ZMM13
        {
            get { return Read(199); }
            set { Write(199, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM14 register.
        /// </summary>
        public long ZMM14
        {
            get { return Read(200); }
            set { Write(200, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM15 register.
        /// </summary>
        public long ZMM15
        {
            get { return Read(201); }
            set { Write(201, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM16 register.
        /// </summary>
        public long ZMM16
        {
            get { return Read(202); }
            set { Write(202, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM17 register.
        /// </summary>
        public long ZMM17
        {
            get { return Read(203); }
            set { Write(203, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM18 register.
        /// </summary>
        public long ZMM18
        {
            get { return Read(204); }
            set { Write(204, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM19 register.
        /// </summary>
        public long ZMM19
        {
            get { return Read(205); }
            set { Write(205, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM20 register.
        /// </summary>
        public long ZMM20
        {
            get { return Read(206); }
            set { Write(206, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM21 register.
        /// </summary>
        public long ZMM21
        {
            get { return Read(207); }
            set { Write(207, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM22 register.
        /// </summary>
        public long ZMM22
        {
            get { return Read(208); }
            set { Write(208, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM23 register.
        /// </summary>
        public long ZMM23
        {
            get { return Read(209); }
            set { Write(209, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM24 register.
        /// </summary>
        public long ZMM24
        {
            get { return Read(210); }
            set { Write(210, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM25 register.
        /// </summary>
        public long ZMM25
        {
            get { return Read(211); }
            set { Write(211, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM26 register.
        /// </summary>
        public long ZMM26
        {
            get { return Read(212); }
            set { Write(212, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM27 register.
        /// </summary>
        public long ZMM27
        {
            get { return Read(213); }
            set { Write(213, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM28 register.
        /// </summary>
        public long ZMM28
        {
            get { return Read(214); }
            set { Write(214, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM29 register.
        /// </summary>
        public long ZMM29
        {
            get { return Read(215); }
            set { Write(215, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM30 register.
        /// </summary>
        public long ZMM30
        {
            get { return Read(216); }
            set { Write(216, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZMM31 register.
        /// </summary>
        public long ZMM31
        {
            get { return Read(217); }
            set { Write(217, value); }
        }

        /// <summary>
        /// Gets or sets the value of R8B register.
        /// </summary>
        public long R8B
        {
            get { return Read(218); }
            set { Write(218, value); }
        }

        /// <summary>
        /// Gets or sets the value of R9B register.
        /// </summary>
        public long R9B
        {
            get { return Read(219); }
            set { Write(219, value); }
        }

        /// <summary>
        /// Gets or sets the value of R10B register.
        /// </summary>
        public long R10B
        {
            get { return Read(220); }
            set { Write(220, value); }
        }

        /// <summary>
        /// Gets or sets the value of R11B register.
        /// </summary>
        public long R11B
        {
            get { return Read(221); }
            set { Write(221, value); }
        }

        /// <summary>
        /// Gets or sets the value of R12B register.
        /// </summary>
        public long R12B
        {
            get { return Read(222); }
            set { Write(222, value); }
        }

        /// <summary>
        /// Gets or sets the value of R13B register.
        /// </summary>
        public long R13B
        {
            get { return Read(223); }
            set { Write(223, value); }
        }

        /// <summary>
        /// Gets or sets the value of R14B register.
        /// </summary>
        public long R14B
        {
            get { return Read(224); }
            set { Write(224, value); }
        }

        /// <summary>
        /// Gets or sets the value of R15B register.
        /// </summary>
        public long R15B
        {
            get { return Read(225); }
            set { Write(225, value); }
        }

        /// <summary>
        /// Gets or sets the value of R8D register.
        /// </summary>
        public long R8D
        {
            get { return Read(226); }
            set { Write(226, value); }
        }

        /// <summary>
        /// Gets or sets the value of R9D register.
        /// </summary>
        public long R9D
        {
            get { return Read(227); }
            set { Write(227, value); }
        }

        /// <summary>
        /// Gets or sets the value of R10D register.
        /// </summary>
        public long R10D
        {
            get { return Read(228); }
            set { Write(228, value); }
        }

        /// <summary>
        /// Gets or sets the value of R11D register.
        /// </summary>
        public long R11D
        {
            get { return Read(229); }
            set { Write(229, value); }
        }

        /// <summary>
        /// Gets or sets the value of R12D register.
        /// </summary>
        public long R12D
        {
            get { return Read(230); }
            set { Write(230, value); }
        }

        /// <summary>
        /// Gets or sets the value of R13D register.
        /// </summary>
        public long R13D
        {
            get { return Read(231); }
            set { Write(231, value); }
        }

        /// <summary>
        /// Gets or sets the value of R14D register.
        /// </summary>
        public long R14D
        {
            get { return Read(232); }
            set { Write(232, value); }
        }

        /// <summary>
        /// Gets or sets the value of R15D register.
        /// </summary>
        public long R15D
        {
            get { return Read(233); }
            set { Write(233, value); }
        }

        /// <summary>
        /// Gets or sets the value of R8W register.
        /// </summary>
        public long R8W
        {
            get { return Read(234); }
            set { Write(234, value); }
        }

        /// <summary>
        /// Gets or sets the value of R9W register.
        /// </summary>
        public long R9W
        {
            get { return Read(235); }
            set { Write(235, value); }
        }

        /// <summary>
        /// Gets or sets the value of R10W register.
        /// </summary>
        public long R10W
        {
            get { return Read(236); }
            set { Write(236, value); }
        }

        /// <summary>
        /// Gets or sets the value of R11W register.
        /// </summary>
        public long R11W
        {
            get { return Read(237); }
            set { Write(237, value); }
        }

        /// <summary>
        /// Gets or sets the value of R12W register.
        /// </summary>
        public long R12W
        {
            get { return Read(238); }
            set { Write(238, value); }
        }

        /// <summary>
        /// Gets or sets the value of R13W register.
        /// </summary>
        public long R13W
        {
            get { return Read(239); }
            set { Write(239, value); }
        }

        /// <summary>
        /// Gets or sets the value of R14W register.
        /// </summary>
        public long R14W
        {
            get { return Read(240); }
            set { Write(240, value); }
        }

        /// <summary>
        /// Gets or sets the value of R15W register.
        /// </summary>
        public long R15W
        {
            get { return Read(241); }
            set { Write(241, value); }
        }

        /// <summary>
        /// Gets or sets the value of IDTR register.
        /// </summary>
        public long IDTR
        {
            get { return Read(242); }
            set { Write(242, value); }
        }

        /// <summary>
        /// Gets or sets the value of GDTR register.
        /// </summary>
        public long GDTR
        {
            get { return Read(243); }
            set { Write(243, value); }
        }

        /// <summary>
        /// Gets or sets the value of LDTR register.
        /// </summary>
        public long LDTR
        {
            get { return Read(244); }
            set { Write(244, value); }
        }

        /// <summary>
        /// Gets or sets the value of TR register.
        /// </summary>
        public long TR
        {
            get { return Read(245); }
            set { Write(245, value); }
        }

        /// <summary>
        /// Gets or sets the value of FPCW register.
        /// </summary>
        public long FPCW
        {
            get { return Read(246); }
            set { Write(246, value); }
        }

        /// <summary>
        /// Gets or sets the value of FPTAG register.
        /// </summary>
        public long FPTAG
        {
            get { return Read(247); }
            set { Write(247, value); }
        }
    }
}
