﻿namespace Unicorn.X86
{
    /// <summary>
    /// Defines <see cref="Instruction"/> for the X86 architecture.
    /// </summary>
    public static class X86Instructions
    {
        // Generated by /scripts/gen_ins_fields.py.

        /// <summary>
        /// Represents the AAA instruction.
        /// </summary>
        public static readonly Instruction AAA = new Instruction(1);

        /// <summary>
        /// Represents the AAD instruction.
        /// </summary>
        public static readonly Instruction AAD = new Instruction(2);

        /// <summary>
        /// Represents the AAM instruction.
        /// </summary>
        public static readonly Instruction AAM = new Instruction(3);

        /// <summary>
        /// Represents the AAS instruction.
        /// </summary>
        public static readonly Instruction AAS = new Instruction(4);

        /// <summary>
        /// Represents the FABS instruction.
        /// </summary>
        public static readonly Instruction FABS = new Instruction(5);

        /// <summary>
        /// Represents the ADC instruction.
        /// </summary>
        public static readonly Instruction ADC = new Instruction(6);

        /// <summary>
        /// Represents the ADCX instruction.
        /// </summary>
        public static readonly Instruction ADCX = new Instruction(7);

        /// <summary>
        /// Represents the ADD instruction.
        /// </summary>
        public static readonly Instruction ADD = new Instruction(8);

        /// <summary>
        /// Represents the ADDPD instruction.
        /// </summary>
        public static readonly Instruction ADDPD = new Instruction(9);

        /// <summary>
        /// Represents the ADDPS instruction.
        /// </summary>
        public static readonly Instruction ADDPS = new Instruction(10);

        /// <summary>
        /// Represents the ADDSD instruction.
        /// </summary>
        public static readonly Instruction ADDSD = new Instruction(11);

        /// <summary>
        /// Represents the ADDSS instruction.
        /// </summary>
        public static readonly Instruction ADDSS = new Instruction(12);

        /// <summary>
        /// Represents the ADDSUBPD instruction.
        /// </summary>
        public static readonly Instruction ADDSUBPD = new Instruction(13);

        /// <summary>
        /// Represents the ADDSUBPS instruction.
        /// </summary>
        public static readonly Instruction ADDSUBPS = new Instruction(14);

        /// <summary>
        /// Represents the FADD instruction.
        /// </summary>
        public static readonly Instruction FADD = new Instruction(15);

        /// <summary>
        /// Represents the FIADD instruction.
        /// </summary>
        public static readonly Instruction FIADD = new Instruction(16);

        /// <summary>
        /// Represents the FADDP instruction.
        /// </summary>
        public static readonly Instruction FADDP = new Instruction(17);

        /// <summary>
        /// Represents the ADOX instruction.
        /// </summary>
        public static readonly Instruction ADOX = new Instruction(18);

        /// <summary>
        /// Represents the AESDECLAST instruction.
        /// </summary>
        public static readonly Instruction AESDECLAST = new Instruction(19);

        /// <summary>
        /// Represents the AESDEC instruction.
        /// </summary>
        public static readonly Instruction AESDEC = new Instruction(20);

        /// <summary>
        /// Represents the AESENCLAST instruction.
        /// </summary>
        public static readonly Instruction AESENCLAST = new Instruction(21);

        /// <summary>
        /// Represents the AESENC instruction.
        /// </summary>
        public static readonly Instruction AESENC = new Instruction(22);

        /// <summary>
        /// Represents the AESIMC instruction.
        /// </summary>
        public static readonly Instruction AESIMC = new Instruction(23);

        /// <summary>
        /// Represents the AESKEYGENASSIST instruction.
        /// </summary>
        public static readonly Instruction AESKEYGENASSIST = new Instruction(24);

        /// <summary>
        /// Represents the AND instruction.
        /// </summary>
        public static readonly Instruction AND = new Instruction(25);

        /// <summary>
        /// Represents the ANDN instruction.
        /// </summary>
        public static readonly Instruction ANDN = new Instruction(26);

        /// <summary>
        /// Represents the ANDNPD instruction.
        /// </summary>
        public static readonly Instruction ANDNPD = new Instruction(27);

        /// <summary>
        /// Represents the ANDNPS instruction.
        /// </summary>
        public static readonly Instruction ANDNPS = new Instruction(28);

        /// <summary>
        /// Represents the ANDPD instruction.
        /// </summary>
        public static readonly Instruction ANDPD = new Instruction(29);

        /// <summary>
        /// Represents the ANDPS instruction.
        /// </summary>
        public static readonly Instruction ANDPS = new Instruction(30);

        /// <summary>
        /// Represents the ARPL instruction.
        /// </summary>
        public static readonly Instruction ARPL = new Instruction(31);

        /// <summary>
        /// Represents the BEXTR instruction.
        /// </summary>
        public static readonly Instruction BEXTR = new Instruction(32);

        /// <summary>
        /// Represents the BLCFILL instruction.
        /// </summary>
        public static readonly Instruction BLCFILL = new Instruction(33);

        /// <summary>
        /// Represents the BLCI instruction.
        /// </summary>
        public static readonly Instruction BLCI = new Instruction(34);

        /// <summary>
        /// Represents the BLCIC instruction.
        /// </summary>
        public static readonly Instruction BLCIC = new Instruction(35);

        /// <summary>
        /// Represents the BLCMSK instruction.
        /// </summary>
        public static readonly Instruction BLCMSK = new Instruction(36);

        /// <summary>
        /// Represents the BLCS instruction.
        /// </summary>
        public static readonly Instruction BLCS = new Instruction(37);

        /// <summary>
        /// Represents the BLENDPD instruction.
        /// </summary>
        public static readonly Instruction BLENDPD = new Instruction(38);

        /// <summary>
        /// Represents the BLENDPS instruction.
        /// </summary>
        public static readonly Instruction BLENDPS = new Instruction(39);

        /// <summary>
        /// Represents the BLENDVPD instruction.
        /// </summary>
        public static readonly Instruction BLENDVPD = new Instruction(40);

        /// <summary>
        /// Represents the BLENDVPS instruction.
        /// </summary>
        public static readonly Instruction BLENDVPS = new Instruction(41);

        /// <summary>
        /// Represents the BLSFILL instruction.
        /// </summary>
        public static readonly Instruction BLSFILL = new Instruction(42);

        /// <summary>
        /// Represents the BLSI instruction.
        /// </summary>
        public static readonly Instruction BLSI = new Instruction(43);

        /// <summary>
        /// Represents the BLSIC instruction.
        /// </summary>
        public static readonly Instruction BLSIC = new Instruction(44);

        /// <summary>
        /// Represents the BLSMSK instruction.
        /// </summary>
        public static readonly Instruction BLSMSK = new Instruction(45);

        /// <summary>
        /// Represents the BLSR instruction.
        /// </summary>
        public static readonly Instruction BLSR = new Instruction(46);

        /// <summary>
        /// Represents the BOUND instruction.
        /// </summary>
        public static readonly Instruction BOUND = new Instruction(47);

        /// <summary>
        /// Represents the BSF instruction.
        /// </summary>
        public static readonly Instruction BSF = new Instruction(48);

        /// <summary>
        /// Represents the BSR instruction.
        /// </summary>
        public static readonly Instruction BSR = new Instruction(49);

        /// <summary>
        /// Represents the BSWAP instruction.
        /// </summary>
        public static readonly Instruction BSWAP = new Instruction(50);

        /// <summary>
        /// Represents the BT instruction.
        /// </summary>
        public static readonly Instruction BT = new Instruction(51);

        /// <summary>
        /// Represents the BTC instruction.
        /// </summary>
        public static readonly Instruction BTC = new Instruction(52);

        /// <summary>
        /// Represents the BTR instruction.
        /// </summary>
        public static readonly Instruction BTR = new Instruction(53);

        /// <summary>
        /// Represents the BTS instruction.
        /// </summary>
        public static readonly Instruction BTS = new Instruction(54);

        /// <summary>
        /// Represents the BZHI instruction.
        /// </summary>
        public static readonly Instruction BZHI = new Instruction(55);

        /// <summary>
        /// Represents the CALL instruction.
        /// </summary>
        public static readonly Instruction CALL = new Instruction(56);

        /// <summary>
        /// Represents the CBW instruction.
        /// </summary>
        public static readonly Instruction CBW = new Instruction(57);

        /// <summary>
        /// Represents the CDQ instruction.
        /// </summary>
        public static readonly Instruction CDQ = new Instruction(58);

        /// <summary>
        /// Represents the CDQE instruction.
        /// </summary>
        public static readonly Instruction CDQE = new Instruction(59);

        /// <summary>
        /// Represents the FCHS instruction.
        /// </summary>
        public static readonly Instruction FCHS = new Instruction(60);

        /// <summary>
        /// Represents the CLAC instruction.
        /// </summary>
        public static readonly Instruction CLAC = new Instruction(61);

        /// <summary>
        /// Represents the CLC instruction.
        /// </summary>
        public static readonly Instruction CLC = new Instruction(62);

        /// <summary>
        /// Represents the CLD instruction.
        /// </summary>
        public static readonly Instruction CLD = new Instruction(63);

        /// <summary>
        /// Represents the CLFLUSH instruction.
        /// </summary>
        public static readonly Instruction CLFLUSH = new Instruction(64);

        /// <summary>
        /// Represents the CLFLUSHOPT instruction.
        /// </summary>
        public static readonly Instruction CLFLUSHOPT = new Instruction(65);

        /// <summary>
        /// Represents the CLGI instruction.
        /// </summary>
        public static readonly Instruction CLGI = new Instruction(66);

        /// <summary>
        /// Represents the CLI instruction.
        /// </summary>
        public static readonly Instruction CLI = new Instruction(67);

        /// <summary>
        /// Represents the CLTS instruction.
        /// </summary>
        public static readonly Instruction CLTS = new Instruction(68);

        /// <summary>
        /// Represents the CLWB instruction.
        /// </summary>
        public static readonly Instruction CLWB = new Instruction(69);

        /// <summary>
        /// Represents the CMC instruction.
        /// </summary>
        public static readonly Instruction CMC = new Instruction(70);

        /// <summary>
        /// Represents the CMOVA instruction.
        /// </summary>
        public static readonly Instruction CMOVA = new Instruction(71);

        /// <summary>
        /// Represents the CMOVAE instruction.
        /// </summary>
        public static readonly Instruction CMOVAE = new Instruction(72);

        /// <summary>
        /// Represents the CMOVB instruction.
        /// </summary>
        public static readonly Instruction CMOVB = new Instruction(73);

        /// <summary>
        /// Represents the CMOVBE instruction.
        /// </summary>
        public static readonly Instruction CMOVBE = new Instruction(74);

        /// <summary>
        /// Represents the FCMOVBE instruction.
        /// </summary>
        public static readonly Instruction FCMOVBE = new Instruction(75);

        /// <summary>
        /// Represents the FCMOVB instruction.
        /// </summary>
        public static readonly Instruction FCMOVB = new Instruction(76);

        /// <summary>
        /// Represents the CMOVE instruction.
        /// </summary>
        public static readonly Instruction CMOVE = new Instruction(77);

        /// <summary>
        /// Represents the FCMOVE instruction.
        /// </summary>
        public static readonly Instruction FCMOVE = new Instruction(78);

        /// <summary>
        /// Represents the CMOVG instruction.
        /// </summary>
        public static readonly Instruction CMOVG = new Instruction(79);

        /// <summary>
        /// Represents the CMOVGE instruction.
        /// </summary>
        public static readonly Instruction CMOVGE = new Instruction(80);

        /// <summary>
        /// Represents the CMOVL instruction.
        /// </summary>
        public static readonly Instruction CMOVL = new Instruction(81);

        /// <summary>
        /// Represents the CMOVLE instruction.
        /// </summary>
        public static readonly Instruction CMOVLE = new Instruction(82);

        /// <summary>
        /// Represents the FCMOVNBE instruction.
        /// </summary>
        public static readonly Instruction FCMOVNBE = new Instruction(83);

        /// <summary>
        /// Represents the FCMOVNB instruction.
        /// </summary>
        public static readonly Instruction FCMOVNB = new Instruction(84);

        /// <summary>
        /// Represents the CMOVNE instruction.
        /// </summary>
        public static readonly Instruction CMOVNE = new Instruction(85);

        /// <summary>
        /// Represents the FCMOVNE instruction.
        /// </summary>
        public static readonly Instruction FCMOVNE = new Instruction(86);

        /// <summary>
        /// Represents the CMOVNO instruction.
        /// </summary>
        public static readonly Instruction CMOVNO = new Instruction(87);

        /// <summary>
        /// Represents the CMOVNP instruction.
        /// </summary>
        public static readonly Instruction CMOVNP = new Instruction(88);

        /// <summary>
        /// Represents the FCMOVNU instruction.
        /// </summary>
        public static readonly Instruction FCMOVNU = new Instruction(89);

        /// <summary>
        /// Represents the CMOVNS instruction.
        /// </summary>
        public static readonly Instruction CMOVNS = new Instruction(90);

        /// <summary>
        /// Represents the CMOVO instruction.
        /// </summary>
        public static readonly Instruction CMOVO = new Instruction(91);

        /// <summary>
        /// Represents the CMOVP instruction.
        /// </summary>
        public static readonly Instruction CMOVP = new Instruction(92);

        /// <summary>
        /// Represents the FCMOVU instruction.
        /// </summary>
        public static readonly Instruction FCMOVU = new Instruction(93);

        /// <summary>
        /// Represents the CMOVS instruction.
        /// </summary>
        public static readonly Instruction CMOVS = new Instruction(94);

        /// <summary>
        /// Represents the CMP instruction.
        /// </summary>
        public static readonly Instruction CMP = new Instruction(95);

        /// <summary>
        /// Represents the CMPPD instruction.
        /// </summary>
        public static readonly Instruction CMPPD = new Instruction(96);

        /// <summary>
        /// Represents the CMPPS instruction.
        /// </summary>
        public static readonly Instruction CMPPS = new Instruction(97);

        /// <summary>
        /// Represents the CMPSB instruction.
        /// </summary>
        public static readonly Instruction CMPSB = new Instruction(98);

        /// <summary>
        /// Represents the CMPSD instruction.
        /// </summary>
        public static readonly Instruction CMPSD = new Instruction(99);

        /// <summary>
        /// Represents the CMPSQ instruction.
        /// </summary>
        public static readonly Instruction CMPSQ = new Instruction(100);

        /// <summary>
        /// Represents the CMPSS instruction.
        /// </summary>
        public static readonly Instruction CMPSS = new Instruction(101);

        /// <summary>
        /// Represents the CMPSW instruction.
        /// </summary>
        public static readonly Instruction CMPSW = new Instruction(102);

        /// <summary>
        /// Represents the CMPXCHG16B instruction.
        /// </summary>
        public static readonly Instruction CMPXCHG16B = new Instruction(103);

        /// <summary>
        /// Represents the CMPXCHG instruction.
        /// </summary>
        public static readonly Instruction CMPXCHG = new Instruction(104);

        /// <summary>
        /// Represents the CMPXCHG8B instruction.
        /// </summary>
        public static readonly Instruction CMPXCHG8B = new Instruction(105);

        /// <summary>
        /// Represents the COMISD instruction.
        /// </summary>
        public static readonly Instruction COMISD = new Instruction(106);

        /// <summary>
        /// Represents the COMISS instruction.
        /// </summary>
        public static readonly Instruction COMISS = new Instruction(107);

        /// <summary>
        /// Represents the FCOMP instruction.
        /// </summary>
        public static readonly Instruction FCOMP = new Instruction(108);

        /// <summary>
        /// Represents the FCOMPI instruction.
        /// </summary>
        public static readonly Instruction FCOMPI = new Instruction(109);

        /// <summary>
        /// Represents the FCOMI instruction.
        /// </summary>
        public static readonly Instruction FCOMI = new Instruction(110);

        /// <summary>
        /// Represents the FCOM instruction.
        /// </summary>
        public static readonly Instruction FCOM = new Instruction(111);

        /// <summary>
        /// Represents the FCOS instruction.
        /// </summary>
        public static readonly Instruction FCOS = new Instruction(112);

        /// <summary>
        /// Represents the CPUID instruction.
        /// </summary>
        public static readonly Instruction CPUID = new Instruction(113);

        /// <summary>
        /// Represents the CQO instruction.
        /// </summary>
        public static readonly Instruction CQO = new Instruction(114);

        /// <summary>
        /// Represents the CRC32 instruction.
        /// </summary>
        public static readonly Instruction CRC32 = new Instruction(115);

        /// <summary>
        /// Represents the CVTDQ2PD instruction.
        /// </summary>
        public static readonly Instruction CVTDQ2PD = new Instruction(116);

        /// <summary>
        /// Represents the CVTDQ2PS instruction.
        /// </summary>
        public static readonly Instruction CVTDQ2PS = new Instruction(117);

        /// <summary>
        /// Represents the CVTPD2DQ instruction.
        /// </summary>
        public static readonly Instruction CVTPD2DQ = new Instruction(118);

        /// <summary>
        /// Represents the CVTPD2PS instruction.
        /// </summary>
        public static readonly Instruction CVTPD2PS = new Instruction(119);

        /// <summary>
        /// Represents the CVTPS2DQ instruction.
        /// </summary>
        public static readonly Instruction CVTPS2DQ = new Instruction(120);

        /// <summary>
        /// Represents the CVTPS2PD instruction.
        /// </summary>
        public static readonly Instruction CVTPS2PD = new Instruction(121);

        /// <summary>
        /// Represents the CVTSD2SI instruction.
        /// </summary>
        public static readonly Instruction CVTSD2SI = new Instruction(122);

        /// <summary>
        /// Represents the CVTSD2SS instruction.
        /// </summary>
        public static readonly Instruction CVTSD2SS = new Instruction(123);

        /// <summary>
        /// Represents the CVTSI2SD instruction.
        /// </summary>
        public static readonly Instruction CVTSI2SD = new Instruction(124);

        /// <summary>
        /// Represents the CVTSI2SS instruction.
        /// </summary>
        public static readonly Instruction CVTSI2SS = new Instruction(125);

        /// <summary>
        /// Represents the CVTSS2SD instruction.
        /// </summary>
        public static readonly Instruction CVTSS2SD = new Instruction(126);

        /// <summary>
        /// Represents the CVTSS2SI instruction.
        /// </summary>
        public static readonly Instruction CVTSS2SI = new Instruction(127);

        /// <summary>
        /// Represents the CVTTPD2DQ instruction.
        /// </summary>
        public static readonly Instruction CVTTPD2DQ = new Instruction(128);

        /// <summary>
        /// Represents the CVTTPS2DQ instruction.
        /// </summary>
        public static readonly Instruction CVTTPS2DQ = new Instruction(129);

        /// <summary>
        /// Represents the CVTTSD2SI instruction.
        /// </summary>
        public static readonly Instruction CVTTSD2SI = new Instruction(130);

        /// <summary>
        /// Represents the CVTTSS2SI instruction.
        /// </summary>
        public static readonly Instruction CVTTSS2SI = new Instruction(131);

        /// <summary>
        /// Represents the CWD instruction.
        /// </summary>
        public static readonly Instruction CWD = new Instruction(132);

        /// <summary>
        /// Represents the CWDE instruction.
        /// </summary>
        public static readonly Instruction CWDE = new Instruction(133);

        /// <summary>
        /// Represents the DAA instruction.
        /// </summary>
        public static readonly Instruction DAA = new Instruction(134);

        /// <summary>
        /// Represents the DAS instruction.
        /// </summary>
        public static readonly Instruction DAS = new Instruction(135);

        /// <summary>
        /// Represents the DATA16 instruction.
        /// </summary>
        public static readonly Instruction DATA16 = new Instruction(136);

        /// <summary>
        /// Represents the DEC instruction.
        /// </summary>
        public static readonly Instruction DEC = new Instruction(137);

        /// <summary>
        /// Represents the DIV instruction.
        /// </summary>
        public static readonly Instruction DIV = new Instruction(138);

        /// <summary>
        /// Represents the DIVPD instruction.
        /// </summary>
        public static readonly Instruction DIVPD = new Instruction(139);

        /// <summary>
        /// Represents the DIVPS instruction.
        /// </summary>
        public static readonly Instruction DIVPS = new Instruction(140);

        /// <summary>
        /// Represents the FDIVR instruction.
        /// </summary>
        public static readonly Instruction FDIVR = new Instruction(141);

        /// <summary>
        /// Represents the FIDIVR instruction.
        /// </summary>
        public static readonly Instruction FIDIVR = new Instruction(142);

        /// <summary>
        /// Represents the FDIVRP instruction.
        /// </summary>
        public static readonly Instruction FDIVRP = new Instruction(143);

        /// <summary>
        /// Represents the DIVSD instruction.
        /// </summary>
        public static readonly Instruction DIVSD = new Instruction(144);

        /// <summary>
        /// Represents the DIVSS instruction.
        /// </summary>
        public static readonly Instruction DIVSS = new Instruction(145);

        /// <summary>
        /// Represents the FDIV instruction.
        /// </summary>
        public static readonly Instruction FDIV = new Instruction(146);

        /// <summary>
        /// Represents the FIDIV instruction.
        /// </summary>
        public static readonly Instruction FIDIV = new Instruction(147);

        /// <summary>
        /// Represents the FDIVP instruction.
        /// </summary>
        public static readonly Instruction FDIVP = new Instruction(148);

        /// <summary>
        /// Represents the DPPD instruction.
        /// </summary>
        public static readonly Instruction DPPD = new Instruction(149);

        /// <summary>
        /// Represents the DPPS instruction.
        /// </summary>
        public static readonly Instruction DPPS = new Instruction(150);

        /// <summary>
        /// Represents the RET instruction.
        /// </summary>
        public static readonly Instruction RET = new Instruction(151);

        /// <summary>
        /// Represents the ENCLS instruction.
        /// </summary>
        public static readonly Instruction ENCLS = new Instruction(152);

        /// <summary>
        /// Represents the ENCLU instruction.
        /// </summary>
        public static readonly Instruction ENCLU = new Instruction(153);

        /// <summary>
        /// Represents the ENTER instruction.
        /// </summary>
        public static readonly Instruction ENTER = new Instruction(154);

        /// <summary>
        /// Represents the EXTRACTPS instruction.
        /// </summary>
        public static readonly Instruction EXTRACTPS = new Instruction(155);

        /// <summary>
        /// Represents the EXTRQ instruction.
        /// </summary>
        public static readonly Instruction EXTRQ = new Instruction(156);

        /// <summary>
        /// Represents the F2XM1 instruction.
        /// </summary>
        public static readonly Instruction F2XM1 = new Instruction(157);

        /// <summary>
        /// Represents the LCALL instruction.
        /// </summary>
        public static readonly Instruction LCALL = new Instruction(158);

        /// <summary>
        /// Represents the LJMP instruction.
        /// </summary>
        public static readonly Instruction LJMP = new Instruction(159);

        /// <summary>
        /// Represents the FBLD instruction.
        /// </summary>
        public static readonly Instruction FBLD = new Instruction(160);

        /// <summary>
        /// Represents the FBSTP instruction.
        /// </summary>
        public static readonly Instruction FBSTP = new Instruction(161);

        /// <summary>
        /// Represents the FCOMPP instruction.
        /// </summary>
        public static readonly Instruction FCOMPP = new Instruction(162);

        /// <summary>
        /// Represents the FDECSTP instruction.
        /// </summary>
        public static readonly Instruction FDECSTP = new Instruction(163);

        /// <summary>
        /// Represents the FEMMS instruction.
        /// </summary>
        public static readonly Instruction FEMMS = new Instruction(164);

        /// <summary>
        /// Represents the FFREE instruction.
        /// </summary>
        public static readonly Instruction FFREE = new Instruction(165);

        /// <summary>
        /// Represents the FICOM instruction.
        /// </summary>
        public static readonly Instruction FICOM = new Instruction(166);

        /// <summary>
        /// Represents the FICOMP instruction.
        /// </summary>
        public static readonly Instruction FICOMP = new Instruction(167);

        /// <summary>
        /// Represents the FINCSTP instruction.
        /// </summary>
        public static readonly Instruction FINCSTP = new Instruction(168);

        /// <summary>
        /// Represents the FLDCW instruction.
        /// </summary>
        public static readonly Instruction FLDCW = new Instruction(169);

        /// <summary>
        /// Represents the FLDENV instruction.
        /// </summary>
        public static readonly Instruction FLDENV = new Instruction(170);

        /// <summary>
        /// Represents the FLDL2E instruction.
        /// </summary>
        public static readonly Instruction FLDL2E = new Instruction(171);

        /// <summary>
        /// Represents the FLDL2T instruction.
        /// </summary>
        public static readonly Instruction FLDL2T = new Instruction(172);

        /// <summary>
        /// Represents the FLDLG2 instruction.
        /// </summary>
        public static readonly Instruction FLDLG2 = new Instruction(173);

        /// <summary>
        /// Represents the FLDLN2 instruction.
        /// </summary>
        public static readonly Instruction FLDLN2 = new Instruction(174);

        /// <summary>
        /// Represents the FLDPI instruction.
        /// </summary>
        public static readonly Instruction FLDPI = new Instruction(175);

        /// <summary>
        /// Represents the FNCLEX instruction.
        /// </summary>
        public static readonly Instruction FNCLEX = new Instruction(176);

        /// <summary>
        /// Represents the FNINIT instruction.
        /// </summary>
        public static readonly Instruction FNINIT = new Instruction(177);

        /// <summary>
        /// Represents the FNOP instruction.
        /// </summary>
        public static readonly Instruction FNOP = new Instruction(178);

        /// <summary>
        /// Represents the FNSTCW instruction.
        /// </summary>
        public static readonly Instruction FNSTCW = new Instruction(179);

        /// <summary>
        /// Represents the FNSTSW instruction.
        /// </summary>
        public static readonly Instruction FNSTSW = new Instruction(180);

        /// <summary>
        /// Represents the FPATAN instruction.
        /// </summary>
        public static readonly Instruction FPATAN = new Instruction(181);

        /// <summary>
        /// Represents the FPREM instruction.
        /// </summary>
        public static readonly Instruction FPREM = new Instruction(182);

        /// <summary>
        /// Represents the FPREM1 instruction.
        /// </summary>
        public static readonly Instruction FPREM1 = new Instruction(183);

        /// <summary>
        /// Represents the FPTAN instruction.
        /// </summary>
        public static readonly Instruction FPTAN = new Instruction(184);

        /// <summary>
        /// Represents the FFREEP instruction.
        /// </summary>
        public static readonly Instruction FFREEP = new Instruction(185);

        /// <summary>
        /// Represents the FRNDINT instruction.
        /// </summary>
        public static readonly Instruction FRNDINT = new Instruction(186);

        /// <summary>
        /// Represents the FRSTOR instruction.
        /// </summary>
        public static readonly Instruction FRSTOR = new Instruction(187);

        /// <summary>
        /// Represents the FNSAVE instruction.
        /// </summary>
        public static readonly Instruction FNSAVE = new Instruction(188);

        /// <summary>
        /// Represents the FSCALE instruction.
        /// </summary>
        public static readonly Instruction FSCALE = new Instruction(189);

        /// <summary>
        /// Represents the FSETPM instruction.
        /// </summary>
        public static readonly Instruction FSETPM = new Instruction(190);

        /// <summary>
        /// Represents the FSINCOS instruction.
        /// </summary>
        public static readonly Instruction FSINCOS = new Instruction(191);

        /// <summary>
        /// Represents the FNSTENV instruction.
        /// </summary>
        public static readonly Instruction FNSTENV = new Instruction(192);

        /// <summary>
        /// Represents the FXAM instruction.
        /// </summary>
        public static readonly Instruction FXAM = new Instruction(193);

        /// <summary>
        /// Represents the FXRSTOR instruction.
        /// </summary>
        public static readonly Instruction FXRSTOR = new Instruction(194);

        /// <summary>
        /// Represents the FXRSTOR64 instruction.
        /// </summary>
        public static readonly Instruction FXRSTOR64 = new Instruction(195);

        /// <summary>
        /// Represents the FXSAVE instruction.
        /// </summary>
        public static readonly Instruction FXSAVE = new Instruction(196);

        /// <summary>
        /// Represents the FXSAVE64 instruction.
        /// </summary>
        public static readonly Instruction FXSAVE64 = new Instruction(197);

        /// <summary>
        /// Represents the FXTRACT instruction.
        /// </summary>
        public static readonly Instruction FXTRACT = new Instruction(198);

        /// <summary>
        /// Represents the FYL2X instruction.
        /// </summary>
        public static readonly Instruction FYL2X = new Instruction(199);

        /// <summary>
        /// Represents the FYL2XP1 instruction.
        /// </summary>
        public static readonly Instruction FYL2XP1 = new Instruction(200);

        /// <summary>
        /// Represents the MOVAPD instruction.
        /// </summary>
        public static readonly Instruction MOVAPD = new Instruction(201);

        /// <summary>
        /// Represents the MOVAPS instruction.
        /// </summary>
        public static readonly Instruction MOVAPS = new Instruction(202);

        /// <summary>
        /// Represents the ORPD instruction.
        /// </summary>
        public static readonly Instruction ORPD = new Instruction(203);

        /// <summary>
        /// Represents the ORPS instruction.
        /// </summary>
        public static readonly Instruction ORPS = new Instruction(204);

        /// <summary>
        /// Represents the VMOVAPD instruction.
        /// </summary>
        public static readonly Instruction VMOVAPD = new Instruction(205);

        /// <summary>
        /// Represents the VMOVAPS instruction.
        /// </summary>
        public static readonly Instruction VMOVAPS = new Instruction(206);

        /// <summary>
        /// Represents the XORPD instruction.
        /// </summary>
        public static readonly Instruction XORPD = new Instruction(207);

        /// <summary>
        /// Represents the XORPS instruction.
        /// </summary>
        public static readonly Instruction XORPS = new Instruction(208);

        /// <summary>
        /// Represents the GETSEC instruction.
        /// </summary>
        public static readonly Instruction GETSEC = new Instruction(209);

        /// <summary>
        /// Represents the HADDPD instruction.
        /// </summary>
        public static readonly Instruction HADDPD = new Instruction(210);

        /// <summary>
        /// Represents the HADDPS instruction.
        /// </summary>
        public static readonly Instruction HADDPS = new Instruction(211);

        /// <summary>
        /// Represents the HLT instruction.
        /// </summary>
        public static readonly Instruction HLT = new Instruction(212);

        /// <summary>
        /// Represents the HSUBPD instruction.
        /// </summary>
        public static readonly Instruction HSUBPD = new Instruction(213);

        /// <summary>
        /// Represents the HSUBPS instruction.
        /// </summary>
        public static readonly Instruction HSUBPS = new Instruction(214);

        /// <summary>
        /// Represents the IDIV instruction.
        /// </summary>
        public static readonly Instruction IDIV = new Instruction(215);

        /// <summary>
        /// Represents the FILD instruction.
        /// </summary>
        public static readonly Instruction FILD = new Instruction(216);

        /// <summary>
        /// Represents the IMUL instruction.
        /// </summary>
        public static readonly Instruction IMUL = new Instruction(217);

        /// <summary>
        /// Represents the IN instruction.
        /// </summary>
        public static readonly Instruction IN = new Instruction(218);

        /// <summary>
        /// Represents the INC instruction.
        /// </summary>
        public static readonly Instruction INC = new Instruction(219);

        /// <summary>
        /// Represents the INSB instruction.
        /// </summary>
        public static readonly Instruction INSB = new Instruction(220);

        /// <summary>
        /// Represents the INSERTPS instruction.
        /// </summary>
        public static readonly Instruction INSERTPS = new Instruction(221);

        /// <summary>
        /// Represents the INSERTQ instruction.
        /// </summary>
        public static readonly Instruction INSERTQ = new Instruction(222);

        /// <summary>
        /// Represents the INSD instruction.
        /// </summary>
        public static readonly Instruction INSD = new Instruction(223);

        /// <summary>
        /// Represents the INSW instruction.
        /// </summary>
        public static readonly Instruction INSW = new Instruction(224);

        /// <summary>
        /// Represents the INT instruction.
        /// </summary>
        public static readonly Instruction INT = new Instruction(225);

        /// <summary>
        /// Represents the INT1 instruction.
        /// </summary>
        public static readonly Instruction INT1 = new Instruction(226);

        /// <summary>
        /// Represents the INT3 instruction.
        /// </summary>
        public static readonly Instruction INT3 = new Instruction(227);

        /// <summary>
        /// Represents the INTO instruction.
        /// </summary>
        public static readonly Instruction INTO = new Instruction(228);

        /// <summary>
        /// Represents the INVD instruction.
        /// </summary>
        public static readonly Instruction INVD = new Instruction(229);

        /// <summary>
        /// Represents the INVEPT instruction.
        /// </summary>
        public static readonly Instruction INVEPT = new Instruction(230);

        /// <summary>
        /// Represents the INVLPG instruction.
        /// </summary>
        public static readonly Instruction INVLPG = new Instruction(231);

        /// <summary>
        /// Represents the INVLPGA instruction.
        /// </summary>
        public static readonly Instruction INVLPGA = new Instruction(232);

        /// <summary>
        /// Represents the INVPCID instruction.
        /// </summary>
        public static readonly Instruction INVPCID = new Instruction(233);

        /// <summary>
        /// Represents the INVVPID instruction.
        /// </summary>
        public static readonly Instruction INVVPID = new Instruction(234);

        /// <summary>
        /// Represents the IRET instruction.
        /// </summary>
        public static readonly Instruction IRET = new Instruction(235);

        /// <summary>
        /// Represents the IRETD instruction.
        /// </summary>
        public static readonly Instruction IRETD = new Instruction(236);

        /// <summary>
        /// Represents the IRETQ instruction.
        /// </summary>
        public static readonly Instruction IRETQ = new Instruction(237);

        /// <summary>
        /// Represents the FISTTP instruction.
        /// </summary>
        public static readonly Instruction FISTTP = new Instruction(238);

        /// <summary>
        /// Represents the FIST instruction.
        /// </summary>
        public static readonly Instruction FIST = new Instruction(239);

        /// <summary>
        /// Represents the FISTP instruction.
        /// </summary>
        public static readonly Instruction FISTP = new Instruction(240);

        /// <summary>
        /// Represents the UCOMISD instruction.
        /// </summary>
        public static readonly Instruction UCOMISD = new Instruction(241);

        /// <summary>
        /// Represents the UCOMISS instruction.
        /// </summary>
        public static readonly Instruction UCOMISS = new Instruction(242);

        /// <summary>
        /// Represents the VCOMISD instruction.
        /// </summary>
        public static readonly Instruction VCOMISD = new Instruction(243);

        /// <summary>
        /// Represents the VCOMISS instruction.
        /// </summary>
        public static readonly Instruction VCOMISS = new Instruction(244);

        /// <summary>
        /// Represents the VCVTSD2SS instruction.
        /// </summary>
        public static readonly Instruction VCVTSD2SS = new Instruction(245);

        /// <summary>
        /// Represents the VCVTSI2SD instruction.
        /// </summary>
        public static readonly Instruction VCVTSI2SD = new Instruction(246);

        /// <summary>
        /// Represents the VCVTSI2SS instruction.
        /// </summary>
        public static readonly Instruction VCVTSI2SS = new Instruction(247);

        /// <summary>
        /// Represents the VCVTSS2SD instruction.
        /// </summary>
        public static readonly Instruction VCVTSS2SD = new Instruction(248);

        /// <summary>
        /// Represents the VCVTTSD2SI instruction.
        /// </summary>
        public static readonly Instruction VCVTTSD2SI = new Instruction(249);

        /// <summary>
        /// Represents the VCVTTSD2USI instruction.
        /// </summary>
        public static readonly Instruction VCVTTSD2USI = new Instruction(250);

        /// <summary>
        /// Represents the VCVTTSS2SI instruction.
        /// </summary>
        public static readonly Instruction VCVTTSS2SI = new Instruction(251);

        /// <summary>
        /// Represents the VCVTTSS2USI instruction.
        /// </summary>
        public static readonly Instruction VCVTTSS2USI = new Instruction(252);

        /// <summary>
        /// Represents the VCVTUSI2SD instruction.
        /// </summary>
        public static readonly Instruction VCVTUSI2SD = new Instruction(253);

        /// <summary>
        /// Represents the VCVTUSI2SS instruction.
        /// </summary>
        public static readonly Instruction VCVTUSI2SS = new Instruction(254);

        /// <summary>
        /// Represents the VUCOMISD instruction.
        /// </summary>
        public static readonly Instruction VUCOMISD = new Instruction(255);

        /// <summary>
        /// Represents the VUCOMISS instruction.
        /// </summary>
        public static readonly Instruction VUCOMISS = new Instruction(256);

        /// <summary>
        /// Represents the JAE instruction.
        /// </summary>
        public static readonly Instruction JAE = new Instruction(257);

        /// <summary>
        /// Represents the JA instruction.
        /// </summary>
        public static readonly Instruction JA = new Instruction(258);

        /// <summary>
        /// Represents the JBE instruction.
        /// </summary>
        public static readonly Instruction JBE = new Instruction(259);

        /// <summary>
        /// Represents the JB instruction.
        /// </summary>
        public static readonly Instruction JB = new Instruction(260);

        /// <summary>
        /// Represents the JCXZ instruction.
        /// </summary>
        public static readonly Instruction JCXZ = new Instruction(261);

        /// <summary>
        /// Represents the JECXZ instruction.
        /// </summary>
        public static readonly Instruction JECXZ = new Instruction(262);

        /// <summary>
        /// Represents the JE instruction.
        /// </summary>
        public static readonly Instruction JE = new Instruction(263);

        /// <summary>
        /// Represents the JGE instruction.
        /// </summary>
        public static readonly Instruction JGE = new Instruction(264);

        /// <summary>
        /// Represents the JG instruction.
        /// </summary>
        public static readonly Instruction JG = new Instruction(265);

        /// <summary>
        /// Represents the JLE instruction.
        /// </summary>
        public static readonly Instruction JLE = new Instruction(266);

        /// <summary>
        /// Represents the JL instruction.
        /// </summary>
        public static readonly Instruction JL = new Instruction(267);

        /// <summary>
        /// Represents the JMP instruction.
        /// </summary>
        public static readonly Instruction JMP = new Instruction(268);

        /// <summary>
        /// Represents the JNE instruction.
        /// </summary>
        public static readonly Instruction JNE = new Instruction(269);

        /// <summary>
        /// Represents the JNO instruction.
        /// </summary>
        public static readonly Instruction JNO = new Instruction(270);

        /// <summary>
        /// Represents the JNP instruction.
        /// </summary>
        public static readonly Instruction JNP = new Instruction(271);

        /// <summary>
        /// Represents the JNS instruction.
        /// </summary>
        public static readonly Instruction JNS = new Instruction(272);

        /// <summary>
        /// Represents the JO instruction.
        /// </summary>
        public static readonly Instruction JO = new Instruction(273);

        /// <summary>
        /// Represents the JP instruction.
        /// </summary>
        public static readonly Instruction JP = new Instruction(274);

        /// <summary>
        /// Represents the JRCXZ instruction.
        /// </summary>
        public static readonly Instruction JRCXZ = new Instruction(275);

        /// <summary>
        /// Represents the JS instruction.
        /// </summary>
        public static readonly Instruction JS = new Instruction(276);

        /// <summary>
        /// Represents the KANDB instruction.
        /// </summary>
        public static readonly Instruction KANDB = new Instruction(277);

        /// <summary>
        /// Represents the KANDD instruction.
        /// </summary>
        public static readonly Instruction KANDD = new Instruction(278);

        /// <summary>
        /// Represents the KANDNB instruction.
        /// </summary>
        public static readonly Instruction KANDNB = new Instruction(279);

        /// <summary>
        /// Represents the KANDND instruction.
        /// </summary>
        public static readonly Instruction KANDND = new Instruction(280);

        /// <summary>
        /// Represents the KANDNQ instruction.
        /// </summary>
        public static readonly Instruction KANDNQ = new Instruction(281);

        /// <summary>
        /// Represents the KANDNW instruction.
        /// </summary>
        public static readonly Instruction KANDNW = new Instruction(282);

        /// <summary>
        /// Represents the KANDQ instruction.
        /// </summary>
        public static readonly Instruction KANDQ = new Instruction(283);

        /// <summary>
        /// Represents the KANDW instruction.
        /// </summary>
        public static readonly Instruction KANDW = new Instruction(284);

        /// <summary>
        /// Represents the KMOVB instruction.
        /// </summary>
        public static readonly Instruction KMOVB = new Instruction(285);

        /// <summary>
        /// Represents the KMOVD instruction.
        /// </summary>
        public static readonly Instruction KMOVD = new Instruction(286);

        /// <summary>
        /// Represents the KMOVQ instruction.
        /// </summary>
        public static readonly Instruction KMOVQ = new Instruction(287);

        /// <summary>
        /// Represents the KMOVW instruction.
        /// </summary>
        public static readonly Instruction KMOVW = new Instruction(288);

        /// <summary>
        /// Represents the KNOTB instruction.
        /// </summary>
        public static readonly Instruction KNOTB = new Instruction(289);

        /// <summary>
        /// Represents the KNOTD instruction.
        /// </summary>
        public static readonly Instruction KNOTD = new Instruction(290);

        /// <summary>
        /// Represents the KNOTQ instruction.
        /// </summary>
        public static readonly Instruction KNOTQ = new Instruction(291);

        /// <summary>
        /// Represents the KNOTW instruction.
        /// </summary>
        public static readonly Instruction KNOTW = new Instruction(292);

        /// <summary>
        /// Represents the KORB instruction.
        /// </summary>
        public static readonly Instruction KORB = new Instruction(293);

        /// <summary>
        /// Represents the KORD instruction.
        /// </summary>
        public static readonly Instruction KORD = new Instruction(294);

        /// <summary>
        /// Represents the KORQ instruction.
        /// </summary>
        public static readonly Instruction KORQ = new Instruction(295);

        /// <summary>
        /// Represents the KORTESTB instruction.
        /// </summary>
        public static readonly Instruction KORTESTB = new Instruction(296);

        /// <summary>
        /// Represents the KORTESTD instruction.
        /// </summary>
        public static readonly Instruction KORTESTD = new Instruction(297);

        /// <summary>
        /// Represents the KORTESTQ instruction.
        /// </summary>
        public static readonly Instruction KORTESTQ = new Instruction(298);

        /// <summary>
        /// Represents the KORTESTW instruction.
        /// </summary>
        public static readonly Instruction KORTESTW = new Instruction(299);

        /// <summary>
        /// Represents the KORW instruction.
        /// </summary>
        public static readonly Instruction KORW = new Instruction(300);

        /// <summary>
        /// Represents the KSHIFTLB instruction.
        /// </summary>
        public static readonly Instruction KSHIFTLB = new Instruction(301);

        /// <summary>
        /// Represents the KSHIFTLD instruction.
        /// </summary>
        public static readonly Instruction KSHIFTLD = new Instruction(302);

        /// <summary>
        /// Represents the KSHIFTLQ instruction.
        /// </summary>
        public static readonly Instruction KSHIFTLQ = new Instruction(303);

        /// <summary>
        /// Represents the KSHIFTLW instruction.
        /// </summary>
        public static readonly Instruction KSHIFTLW = new Instruction(304);

        /// <summary>
        /// Represents the KSHIFTRB instruction.
        /// </summary>
        public static readonly Instruction KSHIFTRB = new Instruction(305);

        /// <summary>
        /// Represents the KSHIFTRD instruction.
        /// </summary>
        public static readonly Instruction KSHIFTRD = new Instruction(306);

        /// <summary>
        /// Represents the KSHIFTRQ instruction.
        /// </summary>
        public static readonly Instruction KSHIFTRQ = new Instruction(307);

        /// <summary>
        /// Represents the KSHIFTRW instruction.
        /// </summary>
        public static readonly Instruction KSHIFTRW = new Instruction(308);

        /// <summary>
        /// Represents the KUNPCKBW instruction.
        /// </summary>
        public static readonly Instruction KUNPCKBW = new Instruction(309);

        /// <summary>
        /// Represents the KXNORB instruction.
        /// </summary>
        public static readonly Instruction KXNORB = new Instruction(310);

        /// <summary>
        /// Represents the KXNORD instruction.
        /// </summary>
        public static readonly Instruction KXNORD = new Instruction(311);

        /// <summary>
        /// Represents the KXNORQ instruction.
        /// </summary>
        public static readonly Instruction KXNORQ = new Instruction(312);

        /// <summary>
        /// Represents the KXNORW instruction.
        /// </summary>
        public static readonly Instruction KXNORW = new Instruction(313);

        /// <summary>
        /// Represents the KXORB instruction.
        /// </summary>
        public static readonly Instruction KXORB = new Instruction(314);

        /// <summary>
        /// Represents the KXORD instruction.
        /// </summary>
        public static readonly Instruction KXORD = new Instruction(315);

        /// <summary>
        /// Represents the KXORQ instruction.
        /// </summary>
        public static readonly Instruction KXORQ = new Instruction(316);

        /// <summary>
        /// Represents the KXORW instruction.
        /// </summary>
        public static readonly Instruction KXORW = new Instruction(317);

        /// <summary>
        /// Represents the LAHF instruction.
        /// </summary>
        public static readonly Instruction LAHF = new Instruction(318);

        /// <summary>
        /// Represents the LAR instruction.
        /// </summary>
        public static readonly Instruction LAR = new Instruction(319);

        /// <summary>
        /// Represents the LDDQU instruction.
        /// </summary>
        public static readonly Instruction LDDQU = new Instruction(320);

        /// <summary>
        /// Represents the LDMXCSR instruction.
        /// </summary>
        public static readonly Instruction LDMXCSR = new Instruction(321);

        /// <summary>
        /// Represents the LDS instruction.
        /// </summary>
        public static readonly Instruction LDS = new Instruction(322);

        /// <summary>
        /// Represents the FLDZ instruction.
        /// </summary>
        public static readonly Instruction FLDZ = new Instruction(323);

        /// <summary>
        /// Represents the FLD1 instruction.
        /// </summary>
        public static readonly Instruction FLD1 = new Instruction(324);

        /// <summary>
        /// Represents the FLD instruction.
        /// </summary>
        public static readonly Instruction FLD = new Instruction(325);

        /// <summary>
        /// Represents the LEA instruction.
        /// </summary>
        public static readonly Instruction LEA = new Instruction(326);

        /// <summary>
        /// Represents the LEAVE instruction.
        /// </summary>
        public static readonly Instruction LEAVE = new Instruction(327);

        /// <summary>
        /// Represents the LES instruction.
        /// </summary>
        public static readonly Instruction LES = new Instruction(328);

        /// <summary>
        /// Represents the LFENCE instruction.
        /// </summary>
        public static readonly Instruction LFENCE = new Instruction(329);

        /// <summary>
        /// Represents the LFS instruction.
        /// </summary>
        public static readonly Instruction LFS = new Instruction(330);

        /// <summary>
        /// Represents the LGDT instruction.
        /// </summary>
        public static readonly Instruction LGDT = new Instruction(331);

        /// <summary>
        /// Represents the LGS instruction.
        /// </summary>
        public static readonly Instruction LGS = new Instruction(332);

        /// <summary>
        /// Represents the LIDT instruction.
        /// </summary>
        public static readonly Instruction LIDT = new Instruction(333);

        /// <summary>
        /// Represents the LLDT instruction.
        /// </summary>
        public static readonly Instruction LLDT = new Instruction(334);

        /// <summary>
        /// Represents the LMSW instruction.
        /// </summary>
        public static readonly Instruction LMSW = new Instruction(335);

        /// <summary>
        /// Represents the OR instruction.
        /// </summary>
        public static readonly Instruction OR = new Instruction(336);

        /// <summary>
        /// Represents the SUB instruction.
        /// </summary>
        public static readonly Instruction SUB = new Instruction(337);

        /// <summary>
        /// Represents the XOR instruction.
        /// </summary>
        public static readonly Instruction XOR = new Instruction(338);

        /// <summary>
        /// Represents the LODSB instruction.
        /// </summary>
        public static readonly Instruction LODSB = new Instruction(339);

        /// <summary>
        /// Represents the LODSD instruction.
        /// </summary>
        public static readonly Instruction LODSD = new Instruction(340);

        /// <summary>
        /// Represents the LODSQ instruction.
        /// </summary>
        public static readonly Instruction LODSQ = new Instruction(341);

        /// <summary>
        /// Represents the LODSW instruction.
        /// </summary>
        public static readonly Instruction LODSW = new Instruction(342);

        /// <summary>
        /// Represents the LOOP instruction.
        /// </summary>
        public static readonly Instruction LOOP = new Instruction(343);

        /// <summary>
        /// Represents the LOOPE instruction.
        /// </summary>
        public static readonly Instruction LOOPE = new Instruction(344);

        /// <summary>
        /// Represents the LOOPNE instruction.
        /// </summary>
        public static readonly Instruction LOOPNE = new Instruction(345);

        /// <summary>
        /// Represents the RETF instruction.
        /// </summary>
        public static readonly Instruction RETF = new Instruction(346);

        /// <summary>
        /// Represents the RETFQ instruction.
        /// </summary>
        public static readonly Instruction RETFQ = new Instruction(347);

        /// <summary>
        /// Represents the LSL instruction.
        /// </summary>
        public static readonly Instruction LSL = new Instruction(348);

        /// <summary>
        /// Represents the LSS instruction.
        /// </summary>
        public static readonly Instruction LSS = new Instruction(349);

        /// <summary>
        /// Represents the LTR instruction.
        /// </summary>
        public static readonly Instruction LTR = new Instruction(350);

        /// <summary>
        /// Represents the XADD instruction.
        /// </summary>
        public static readonly Instruction XADD = new Instruction(351);

        /// <summary>
        /// Represents the LZCNT instruction.
        /// </summary>
        public static readonly Instruction LZCNT = new Instruction(352);

        /// <summary>
        /// Represents the MASKMOVDQU instruction.
        /// </summary>
        public static readonly Instruction MASKMOVDQU = new Instruction(353);

        /// <summary>
        /// Represents the MAXPD instruction.
        /// </summary>
        public static readonly Instruction MAXPD = new Instruction(354);

        /// <summary>
        /// Represents the MAXPS instruction.
        /// </summary>
        public static readonly Instruction MAXPS = new Instruction(355);

        /// <summary>
        /// Represents the MAXSD instruction.
        /// </summary>
        public static readonly Instruction MAXSD = new Instruction(356);

        /// <summary>
        /// Represents the MAXSS instruction.
        /// </summary>
        public static readonly Instruction MAXSS = new Instruction(357);

        /// <summary>
        /// Represents the MFENCE instruction.
        /// </summary>
        public static readonly Instruction MFENCE = new Instruction(358);

        /// <summary>
        /// Represents the MINPD instruction.
        /// </summary>
        public static readonly Instruction MINPD = new Instruction(359);

        /// <summary>
        /// Represents the MINPS instruction.
        /// </summary>
        public static readonly Instruction MINPS = new Instruction(360);

        /// <summary>
        /// Represents the MINSD instruction.
        /// </summary>
        public static readonly Instruction MINSD = new Instruction(361);

        /// <summary>
        /// Represents the MINSS instruction.
        /// </summary>
        public static readonly Instruction MINSS = new Instruction(362);

        /// <summary>
        /// Represents the CVTPD2PI instruction.
        /// </summary>
        public static readonly Instruction CVTPD2PI = new Instruction(363);

        /// <summary>
        /// Represents the CVTPI2PD instruction.
        /// </summary>
        public static readonly Instruction CVTPI2PD = new Instruction(364);

        /// <summary>
        /// Represents the CVTPI2PS instruction.
        /// </summary>
        public static readonly Instruction CVTPI2PS = new Instruction(365);

        /// <summary>
        /// Represents the CVTPS2PI instruction.
        /// </summary>
        public static readonly Instruction CVTPS2PI = new Instruction(366);

        /// <summary>
        /// Represents the CVTTPD2PI instruction.
        /// </summary>
        public static readonly Instruction CVTTPD2PI = new Instruction(367);

        /// <summary>
        /// Represents the CVTTPS2PI instruction.
        /// </summary>
        public static readonly Instruction CVTTPS2PI = new Instruction(368);

        /// <summary>
        /// Represents the EMMS instruction.
        /// </summary>
        public static readonly Instruction EMMS = new Instruction(369);

        /// <summary>
        /// Represents the MASKMOVQ instruction.
        /// </summary>
        public static readonly Instruction MASKMOVQ = new Instruction(370);

        /// <summary>
        /// Represents the MOVD instruction.
        /// </summary>
        public static readonly Instruction MOVD = new Instruction(371);

        /// <summary>
        /// Represents the MOVDQ2Q instruction.
        /// </summary>
        public static readonly Instruction MOVDQ2Q = new Instruction(372);

        /// <summary>
        /// Represents the MOVNTQ instruction.
        /// </summary>
        public static readonly Instruction MOVNTQ = new Instruction(373);

        /// <summary>
        /// Represents the MOVQ2DQ instruction.
        /// </summary>
        public static readonly Instruction MOVQ2DQ = new Instruction(374);

        /// <summary>
        /// Represents the MOVQ instruction.
        /// </summary>
        public static readonly Instruction MOVQ = new Instruction(375);

        /// <summary>
        /// Represents the PABSB instruction.
        /// </summary>
        public static readonly Instruction PABSB = new Instruction(376);

        /// <summary>
        /// Represents the PABSD instruction.
        /// </summary>
        public static readonly Instruction PABSD = new Instruction(377);

        /// <summary>
        /// Represents the PABSW instruction.
        /// </summary>
        public static readonly Instruction PABSW = new Instruction(378);

        /// <summary>
        /// Represents the PACKSSDW instruction.
        /// </summary>
        public static readonly Instruction PACKSSDW = new Instruction(379);

        /// <summary>
        /// Represents the PACKSSWB instruction.
        /// </summary>
        public static readonly Instruction PACKSSWB = new Instruction(380);

        /// <summary>
        /// Represents the PACKUSWB instruction.
        /// </summary>
        public static readonly Instruction PACKUSWB = new Instruction(381);

        /// <summary>
        /// Represents the PADDB instruction.
        /// </summary>
        public static readonly Instruction PADDB = new Instruction(382);

        /// <summary>
        /// Represents the PADDD instruction.
        /// </summary>
        public static readonly Instruction PADDD = new Instruction(383);

        /// <summary>
        /// Represents the PADDQ instruction.
        /// </summary>
        public static readonly Instruction PADDQ = new Instruction(384);

        /// <summary>
        /// Represents the PADDSB instruction.
        /// </summary>
        public static readonly Instruction PADDSB = new Instruction(385);

        /// <summary>
        /// Represents the PADDSW instruction.
        /// </summary>
        public static readonly Instruction PADDSW = new Instruction(386);

        /// <summary>
        /// Represents the PADDUSB instruction.
        /// </summary>
        public static readonly Instruction PADDUSB = new Instruction(387);

        /// <summary>
        /// Represents the PADDUSW instruction.
        /// </summary>
        public static readonly Instruction PADDUSW = new Instruction(388);

        /// <summary>
        /// Represents the PADDW instruction.
        /// </summary>
        public static readonly Instruction PADDW = new Instruction(389);

        /// <summary>
        /// Represents the PALIGNR instruction.
        /// </summary>
        public static readonly Instruction PALIGNR = new Instruction(390);

        /// <summary>
        /// Represents the PANDN instruction.
        /// </summary>
        public static readonly Instruction PANDN = new Instruction(391);

        /// <summary>
        /// Represents the PAND instruction.
        /// </summary>
        public static readonly Instruction PAND = new Instruction(392);

        /// <summary>
        /// Represents the PAVGB instruction.
        /// </summary>
        public static readonly Instruction PAVGB = new Instruction(393);

        /// <summary>
        /// Represents the PAVGW instruction.
        /// </summary>
        public static readonly Instruction PAVGW = new Instruction(394);

        /// <summary>
        /// Represents the PCMPEQB instruction.
        /// </summary>
        public static readonly Instruction PCMPEQB = new Instruction(395);

        /// <summary>
        /// Represents the PCMPEQD instruction.
        /// </summary>
        public static readonly Instruction PCMPEQD = new Instruction(396);

        /// <summary>
        /// Represents the PCMPEQW instruction.
        /// </summary>
        public static readonly Instruction PCMPEQW = new Instruction(397);

        /// <summary>
        /// Represents the PCMPGTB instruction.
        /// </summary>
        public static readonly Instruction PCMPGTB = new Instruction(398);

        /// <summary>
        /// Represents the PCMPGTD instruction.
        /// </summary>
        public static readonly Instruction PCMPGTD = new Instruction(399);

        /// <summary>
        /// Represents the PCMPGTW instruction.
        /// </summary>
        public static readonly Instruction PCMPGTW = new Instruction(400);

        /// <summary>
        /// Represents the PEXTRW instruction.
        /// </summary>
        public static readonly Instruction PEXTRW = new Instruction(401);

        /// <summary>
        /// Represents the PHADDSW instruction.
        /// </summary>
        public static readonly Instruction PHADDSW = new Instruction(402);

        /// <summary>
        /// Represents the PHADDW instruction.
        /// </summary>
        public static readonly Instruction PHADDW = new Instruction(403);

        /// <summary>
        /// Represents the PHADDD instruction.
        /// </summary>
        public static readonly Instruction PHADDD = new Instruction(404);

        /// <summary>
        /// Represents the PHSUBD instruction.
        /// </summary>
        public static readonly Instruction PHSUBD = new Instruction(405);

        /// <summary>
        /// Represents the PHSUBSW instruction.
        /// </summary>
        public static readonly Instruction PHSUBSW = new Instruction(406);

        /// <summary>
        /// Represents the PHSUBW instruction.
        /// </summary>
        public static readonly Instruction PHSUBW = new Instruction(407);

        /// <summary>
        /// Represents the PINSRW instruction.
        /// </summary>
        public static readonly Instruction PINSRW = new Instruction(408);

        /// <summary>
        /// Represents the PMADDUBSW instruction.
        /// </summary>
        public static readonly Instruction PMADDUBSW = new Instruction(409);

        /// <summary>
        /// Represents the PMADDWD instruction.
        /// </summary>
        public static readonly Instruction PMADDWD = new Instruction(410);

        /// <summary>
        /// Represents the PMAXSW instruction.
        /// </summary>
        public static readonly Instruction PMAXSW = new Instruction(411);

        /// <summary>
        /// Represents the PMAXUB instruction.
        /// </summary>
        public static readonly Instruction PMAXUB = new Instruction(412);

        /// <summary>
        /// Represents the PMINSW instruction.
        /// </summary>
        public static readonly Instruction PMINSW = new Instruction(413);

        /// <summary>
        /// Represents the PMINUB instruction.
        /// </summary>
        public static readonly Instruction PMINUB = new Instruction(414);

        /// <summary>
        /// Represents the PMOVMSKB instruction.
        /// </summary>
        public static readonly Instruction PMOVMSKB = new Instruction(415);

        /// <summary>
        /// Represents the PMULHRSW instruction.
        /// </summary>
        public static readonly Instruction PMULHRSW = new Instruction(416);

        /// <summary>
        /// Represents the PMULHUW instruction.
        /// </summary>
        public static readonly Instruction PMULHUW = new Instruction(417);

        /// <summary>
        /// Represents the PMULHW instruction.
        /// </summary>
        public static readonly Instruction PMULHW = new Instruction(418);

        /// <summary>
        /// Represents the PMULLW instruction.
        /// </summary>
        public static readonly Instruction PMULLW = new Instruction(419);

        /// <summary>
        /// Represents the PMULUDQ instruction.
        /// </summary>
        public static readonly Instruction PMULUDQ = new Instruction(420);

        /// <summary>
        /// Represents the POR instruction.
        /// </summary>
        public static readonly Instruction POR = new Instruction(421);

        /// <summary>
        /// Represents the PSADBW instruction.
        /// </summary>
        public static readonly Instruction PSADBW = new Instruction(422);

        /// <summary>
        /// Represents the PSHUFB instruction.
        /// </summary>
        public static readonly Instruction PSHUFB = new Instruction(423);

        /// <summary>
        /// Represents the PSHUFW instruction.
        /// </summary>
        public static readonly Instruction PSHUFW = new Instruction(424);

        /// <summary>
        /// Represents the PSIGNB instruction.
        /// </summary>
        public static readonly Instruction PSIGNB = new Instruction(425);

        /// <summary>
        /// Represents the PSIGND instruction.
        /// </summary>
        public static readonly Instruction PSIGND = new Instruction(426);

        /// <summary>
        /// Represents the PSIGNW instruction.
        /// </summary>
        public static readonly Instruction PSIGNW = new Instruction(427);

        /// <summary>
        /// Represents the PSLLD instruction.
        /// </summary>
        public static readonly Instruction PSLLD = new Instruction(428);

        /// <summary>
        /// Represents the PSLLQ instruction.
        /// </summary>
        public static readonly Instruction PSLLQ = new Instruction(429);

        /// <summary>
        /// Represents the PSLLW instruction.
        /// </summary>
        public static readonly Instruction PSLLW = new Instruction(430);

        /// <summary>
        /// Represents the PSRAD instruction.
        /// </summary>
        public static readonly Instruction PSRAD = new Instruction(431);

        /// <summary>
        /// Represents the PSRAW instruction.
        /// </summary>
        public static readonly Instruction PSRAW = new Instruction(432);

        /// <summary>
        /// Represents the PSRLD instruction.
        /// </summary>
        public static readonly Instruction PSRLD = new Instruction(433);

        /// <summary>
        /// Represents the PSRLQ instruction.
        /// </summary>
        public static readonly Instruction PSRLQ = new Instruction(434);

        /// <summary>
        /// Represents the PSRLW instruction.
        /// </summary>
        public static readonly Instruction PSRLW = new Instruction(435);

        /// <summary>
        /// Represents the PSUBB instruction.
        /// </summary>
        public static readonly Instruction PSUBB = new Instruction(436);

        /// <summary>
        /// Represents the PSUBD instruction.
        /// </summary>
        public static readonly Instruction PSUBD = new Instruction(437);

        /// <summary>
        /// Represents the PSUBQ instruction.
        /// </summary>
        public static readonly Instruction PSUBQ = new Instruction(438);

        /// <summary>
        /// Represents the PSUBSB instruction.
        /// </summary>
        public static readonly Instruction PSUBSB = new Instruction(439);

        /// <summary>
        /// Represents the PSUBSW instruction.
        /// </summary>
        public static readonly Instruction PSUBSW = new Instruction(440);

        /// <summary>
        /// Represents the PSUBUSB instruction.
        /// </summary>
        public static readonly Instruction PSUBUSB = new Instruction(441);

        /// <summary>
        /// Represents the PSUBUSW instruction.
        /// </summary>
        public static readonly Instruction PSUBUSW = new Instruction(442);

        /// <summary>
        /// Represents the PSUBW instruction.
        /// </summary>
        public static readonly Instruction PSUBW = new Instruction(443);

        /// <summary>
        /// Represents the PUNPCKHBW instruction.
        /// </summary>
        public static readonly Instruction PUNPCKHBW = new Instruction(444);

        /// <summary>
        /// Represents the PUNPCKHDQ instruction.
        /// </summary>
        public static readonly Instruction PUNPCKHDQ = new Instruction(445);

        /// <summary>
        /// Represents the PUNPCKHWD instruction.
        /// </summary>
        public static readonly Instruction PUNPCKHWD = new Instruction(446);

        /// <summary>
        /// Represents the PUNPCKLBW instruction.
        /// </summary>
        public static readonly Instruction PUNPCKLBW = new Instruction(447);

        /// <summary>
        /// Represents the PUNPCKLDQ instruction.
        /// </summary>
        public static readonly Instruction PUNPCKLDQ = new Instruction(448);

        /// <summary>
        /// Represents the PUNPCKLWD instruction.
        /// </summary>
        public static readonly Instruction PUNPCKLWD = new Instruction(449);

        /// <summary>
        /// Represents the PXOR instruction.
        /// </summary>
        public static readonly Instruction PXOR = new Instruction(450);

        /// <summary>
        /// Represents the MONITOR instruction.
        /// </summary>
        public static readonly Instruction MONITOR = new Instruction(451);

        /// <summary>
        /// Represents the MONTMUL instruction.
        /// </summary>
        public static readonly Instruction MONTMUL = new Instruction(452);

        /// <summary>
        /// Represents the MOV instruction.
        /// </summary>
        public static readonly Instruction MOV = new Instruction(453);

        /// <summary>
        /// Represents the MOVABS instruction.
        /// </summary>
        public static readonly Instruction MOVABS = new Instruction(454);

        /// <summary>
        /// Represents the MOVBE instruction.
        /// </summary>
        public static readonly Instruction MOVBE = new Instruction(455);

        /// <summary>
        /// Represents the MOVDDUP instruction.
        /// </summary>
        public static readonly Instruction MOVDDUP = new Instruction(456);

        /// <summary>
        /// Represents the MOVDQA instruction.
        /// </summary>
        public static readonly Instruction MOVDQA = new Instruction(457);

        /// <summary>
        /// Represents the MOVDQU instruction.
        /// </summary>
        public static readonly Instruction MOVDQU = new Instruction(458);

        /// <summary>
        /// Represents the MOVHLPS instruction.
        /// </summary>
        public static readonly Instruction MOVHLPS = new Instruction(459);

        /// <summary>
        /// Represents the MOVHPD instruction.
        /// </summary>
        public static readonly Instruction MOVHPD = new Instruction(460);

        /// <summary>
        /// Represents the MOVHPS instruction.
        /// </summary>
        public static readonly Instruction MOVHPS = new Instruction(461);

        /// <summary>
        /// Represents the MOVLHPS instruction.
        /// </summary>
        public static readonly Instruction MOVLHPS = new Instruction(462);

        /// <summary>
        /// Represents the MOVLPD instruction.
        /// </summary>
        public static readonly Instruction MOVLPD = new Instruction(463);

        /// <summary>
        /// Represents the MOVLPS instruction.
        /// </summary>
        public static readonly Instruction MOVLPS = new Instruction(464);

        /// <summary>
        /// Represents the MOVMSKPD instruction.
        /// </summary>
        public static readonly Instruction MOVMSKPD = new Instruction(465);

        /// <summary>
        /// Represents the MOVMSKPS instruction.
        /// </summary>
        public static readonly Instruction MOVMSKPS = new Instruction(466);

        /// <summary>
        /// Represents the MOVNTDQA instruction.
        /// </summary>
        public static readonly Instruction MOVNTDQA = new Instruction(467);

        /// <summary>
        /// Represents the MOVNTDQ instruction.
        /// </summary>
        public static readonly Instruction MOVNTDQ = new Instruction(468);

        /// <summary>
        /// Represents the MOVNTI instruction.
        /// </summary>
        public static readonly Instruction MOVNTI = new Instruction(469);

        /// <summary>
        /// Represents the MOVNTPD instruction.
        /// </summary>
        public static readonly Instruction MOVNTPD = new Instruction(470);

        /// <summary>
        /// Represents the MOVNTPS instruction.
        /// </summary>
        public static readonly Instruction MOVNTPS = new Instruction(471);

        /// <summary>
        /// Represents the MOVNTSD instruction.
        /// </summary>
        public static readonly Instruction MOVNTSD = new Instruction(472);

        /// <summary>
        /// Represents the MOVNTSS instruction.
        /// </summary>
        public static readonly Instruction MOVNTSS = new Instruction(473);

        /// <summary>
        /// Represents the MOVSB instruction.
        /// </summary>
        public static readonly Instruction MOVSB = new Instruction(474);

        /// <summary>
        /// Represents the MOVSD instruction.
        /// </summary>
        public static readonly Instruction MOVSD = new Instruction(475);

        /// <summary>
        /// Represents the MOVSHDUP instruction.
        /// </summary>
        public static readonly Instruction MOVSHDUP = new Instruction(476);

        /// <summary>
        /// Represents the MOVSLDUP instruction.
        /// </summary>
        public static readonly Instruction MOVSLDUP = new Instruction(477);

        /// <summary>
        /// Represents the MOVSQ instruction.
        /// </summary>
        public static readonly Instruction MOVSQ = new Instruction(478);

        /// <summary>
        /// Represents the MOVSS instruction.
        /// </summary>
        public static readonly Instruction MOVSS = new Instruction(479);

        /// <summary>
        /// Represents the MOVSW instruction.
        /// </summary>
        public static readonly Instruction MOVSW = new Instruction(480);

        /// <summary>
        /// Represents the MOVSX instruction.
        /// </summary>
        public static readonly Instruction MOVSX = new Instruction(481);

        /// <summary>
        /// Represents the MOVSXD instruction.
        /// </summary>
        public static readonly Instruction MOVSXD = new Instruction(482);

        /// <summary>
        /// Represents the MOVUPD instruction.
        /// </summary>
        public static readonly Instruction MOVUPD = new Instruction(483);

        /// <summary>
        /// Represents the MOVUPS instruction.
        /// </summary>
        public static readonly Instruction MOVUPS = new Instruction(484);

        /// <summary>
        /// Represents the MOVZX instruction.
        /// </summary>
        public static readonly Instruction MOVZX = new Instruction(485);

        /// <summary>
        /// Represents the MPSADBW instruction.
        /// </summary>
        public static readonly Instruction MPSADBW = new Instruction(486);

        /// <summary>
        /// Represents the MUL instruction.
        /// </summary>
        public static readonly Instruction MUL = new Instruction(487);

        /// <summary>
        /// Represents the MULPD instruction.
        /// </summary>
        public static readonly Instruction MULPD = new Instruction(488);

        /// <summary>
        /// Represents the MULPS instruction.
        /// </summary>
        public static readonly Instruction MULPS = new Instruction(489);

        /// <summary>
        /// Represents the MULSD instruction.
        /// </summary>
        public static readonly Instruction MULSD = new Instruction(490);

        /// <summary>
        /// Represents the MULSS instruction.
        /// </summary>
        public static readonly Instruction MULSS = new Instruction(491);

        /// <summary>
        /// Represents the MULX instruction.
        /// </summary>
        public static readonly Instruction MULX = new Instruction(492);

        /// <summary>
        /// Represents the FMUL instruction.
        /// </summary>
        public static readonly Instruction FMUL = new Instruction(493);

        /// <summary>
        /// Represents the FIMUL instruction.
        /// </summary>
        public static readonly Instruction FIMUL = new Instruction(494);

        /// <summary>
        /// Represents the FMULP instruction.
        /// </summary>
        public static readonly Instruction FMULP = new Instruction(495);

        /// <summary>
        /// Represents the MWAIT instruction.
        /// </summary>
        public static readonly Instruction MWAIT = new Instruction(496);

        /// <summary>
        /// Represents the NEG instruction.
        /// </summary>
        public static readonly Instruction NEG = new Instruction(497);

        /// <summary>
        /// Represents the NOP instruction.
        /// </summary>
        public static readonly Instruction NOP = new Instruction(498);

        /// <summary>
        /// Represents the NOT instruction.
        /// </summary>
        public static readonly Instruction NOT = new Instruction(499);

        /// <summary>
        /// Represents the OUT instruction.
        /// </summary>
        public static readonly Instruction OUT = new Instruction(500);

        /// <summary>
        /// Represents the OUTSB instruction.
        /// </summary>
        public static readonly Instruction OUTSB = new Instruction(501);

        /// <summary>
        /// Represents the OUTSD instruction.
        /// </summary>
        public static readonly Instruction OUTSD = new Instruction(502);

        /// <summary>
        /// Represents the OUTSW instruction.
        /// </summary>
        public static readonly Instruction OUTSW = new Instruction(503);

        /// <summary>
        /// Represents the PACKUSDW instruction.
        /// </summary>
        public static readonly Instruction PACKUSDW = new Instruction(504);

        /// <summary>
        /// Represents the PAUSE instruction.
        /// </summary>
        public static readonly Instruction PAUSE = new Instruction(505);

        /// <summary>
        /// Represents the PAVGUSB instruction.
        /// </summary>
        public static readonly Instruction PAVGUSB = new Instruction(506);

        /// <summary>
        /// Represents the PBLENDVB instruction.
        /// </summary>
        public static readonly Instruction PBLENDVB = new Instruction(507);

        /// <summary>
        /// Represents the PBLENDW instruction.
        /// </summary>
        public static readonly Instruction PBLENDW = new Instruction(508);

        /// <summary>
        /// Represents the PCLMULQDQ instruction.
        /// </summary>
        public static readonly Instruction PCLMULQDQ = new Instruction(509);

        /// <summary>
        /// Represents the PCMPEQQ instruction.
        /// </summary>
        public static readonly Instruction PCMPEQQ = new Instruction(510);

        /// <summary>
        /// Represents the PCMPESTRI instruction.
        /// </summary>
        public static readonly Instruction PCMPESTRI = new Instruction(511);

        /// <summary>
        /// Represents the PCMPESTRM instruction.
        /// </summary>
        public static readonly Instruction PCMPESTRM = new Instruction(512);

        /// <summary>
        /// Represents the PCMPGTQ instruction.
        /// </summary>
        public static readonly Instruction PCMPGTQ = new Instruction(513);

        /// <summary>
        /// Represents the PCMPISTRI instruction.
        /// </summary>
        public static readonly Instruction PCMPISTRI = new Instruction(514);

        /// <summary>
        /// Represents the PCMPISTRM instruction.
        /// </summary>
        public static readonly Instruction PCMPISTRM = new Instruction(515);

        /// <summary>
        /// Represents the PCOMMIT instruction.
        /// </summary>
        public static readonly Instruction PCOMMIT = new Instruction(516);

        /// <summary>
        /// Represents the PDEP instruction.
        /// </summary>
        public static readonly Instruction PDEP = new Instruction(517);

        /// <summary>
        /// Represents the PEXT instruction.
        /// </summary>
        public static readonly Instruction PEXT = new Instruction(518);

        /// <summary>
        /// Represents the PEXTRB instruction.
        /// </summary>
        public static readonly Instruction PEXTRB = new Instruction(519);

        /// <summary>
        /// Represents the PEXTRD instruction.
        /// </summary>
        public static readonly Instruction PEXTRD = new Instruction(520);

        /// <summary>
        /// Represents the PEXTRQ instruction.
        /// </summary>
        public static readonly Instruction PEXTRQ = new Instruction(521);

        /// <summary>
        /// Represents the PF2ID instruction.
        /// </summary>
        public static readonly Instruction PF2ID = new Instruction(522);

        /// <summary>
        /// Represents the PF2IW instruction.
        /// </summary>
        public static readonly Instruction PF2IW = new Instruction(523);

        /// <summary>
        /// Represents the PFACC instruction.
        /// </summary>
        public static readonly Instruction PFACC = new Instruction(524);

        /// <summary>
        /// Represents the PFADD instruction.
        /// </summary>
        public static readonly Instruction PFADD = new Instruction(525);

        /// <summary>
        /// Represents the PFCMPEQ instruction.
        /// </summary>
        public static readonly Instruction PFCMPEQ = new Instruction(526);

        /// <summary>
        /// Represents the PFCMPGE instruction.
        /// </summary>
        public static readonly Instruction PFCMPGE = new Instruction(527);

        /// <summary>
        /// Represents the PFCMPGT instruction.
        /// </summary>
        public static readonly Instruction PFCMPGT = new Instruction(528);

        /// <summary>
        /// Represents the PFMAX instruction.
        /// </summary>
        public static readonly Instruction PFMAX = new Instruction(529);

        /// <summary>
        /// Represents the PFMIN instruction.
        /// </summary>
        public static readonly Instruction PFMIN = new Instruction(530);

        /// <summary>
        /// Represents the PFMUL instruction.
        /// </summary>
        public static readonly Instruction PFMUL = new Instruction(531);

        /// <summary>
        /// Represents the PFNACC instruction.
        /// </summary>
        public static readonly Instruction PFNACC = new Instruction(532);

        /// <summary>
        /// Represents the PFPNACC instruction.
        /// </summary>
        public static readonly Instruction PFPNACC = new Instruction(533);

        /// <summary>
        /// Represents the PFRCPIT1 instruction.
        /// </summary>
        public static readonly Instruction PFRCPIT1 = new Instruction(534);

        /// <summary>
        /// Represents the PFRCPIT2 instruction.
        /// </summary>
        public static readonly Instruction PFRCPIT2 = new Instruction(535);

        /// <summary>
        /// Represents the PFRCP instruction.
        /// </summary>
        public static readonly Instruction PFRCP = new Instruction(536);

        /// <summary>
        /// Represents the PFRSQIT1 instruction.
        /// </summary>
        public static readonly Instruction PFRSQIT1 = new Instruction(537);

        /// <summary>
        /// Represents the PFRSQRT instruction.
        /// </summary>
        public static readonly Instruction PFRSQRT = new Instruction(538);

        /// <summary>
        /// Represents the PFSUBR instruction.
        /// </summary>
        public static readonly Instruction PFSUBR = new Instruction(539);

        /// <summary>
        /// Represents the PFSUB instruction.
        /// </summary>
        public static readonly Instruction PFSUB = new Instruction(540);

        /// <summary>
        /// Represents the PHMINPOSUW instruction.
        /// </summary>
        public static readonly Instruction PHMINPOSUW = new Instruction(541);

        /// <summary>
        /// Represents the PI2FD instruction.
        /// </summary>
        public static readonly Instruction PI2FD = new Instruction(542);

        /// <summary>
        /// Represents the PI2FW instruction.
        /// </summary>
        public static readonly Instruction PI2FW = new Instruction(543);

        /// <summary>
        /// Represents the PINSRB instruction.
        /// </summary>
        public static readonly Instruction PINSRB = new Instruction(544);

        /// <summary>
        /// Represents the PINSRD instruction.
        /// </summary>
        public static readonly Instruction PINSRD = new Instruction(545);

        /// <summary>
        /// Represents the PINSRQ instruction.
        /// </summary>
        public static readonly Instruction PINSRQ = new Instruction(546);

        /// <summary>
        /// Represents the PMAXSB instruction.
        /// </summary>
        public static readonly Instruction PMAXSB = new Instruction(547);

        /// <summary>
        /// Represents the PMAXSD instruction.
        /// </summary>
        public static readonly Instruction PMAXSD = new Instruction(548);

        /// <summary>
        /// Represents the PMAXUD instruction.
        /// </summary>
        public static readonly Instruction PMAXUD = new Instruction(549);

        /// <summary>
        /// Represents the PMAXUW instruction.
        /// </summary>
        public static readonly Instruction PMAXUW = new Instruction(550);

        /// <summary>
        /// Represents the PMINSB instruction.
        /// </summary>
        public static readonly Instruction PMINSB = new Instruction(551);

        /// <summary>
        /// Represents the PMINSD instruction.
        /// </summary>
        public static readonly Instruction PMINSD = new Instruction(552);

        /// <summary>
        /// Represents the PMINUD instruction.
        /// </summary>
        public static readonly Instruction PMINUD = new Instruction(553);

        /// <summary>
        /// Represents the PMINUW instruction.
        /// </summary>
        public static readonly Instruction PMINUW = new Instruction(554);

        /// <summary>
        /// Represents the PMOVSXBD instruction.
        /// </summary>
        public static readonly Instruction PMOVSXBD = new Instruction(555);

        /// <summary>
        /// Represents the PMOVSXBQ instruction.
        /// </summary>
        public static readonly Instruction PMOVSXBQ = new Instruction(556);

        /// <summary>
        /// Represents the PMOVSXBW instruction.
        /// </summary>
        public static readonly Instruction PMOVSXBW = new Instruction(557);

        /// <summary>
        /// Represents the PMOVSXDQ instruction.
        /// </summary>
        public static readonly Instruction PMOVSXDQ = new Instruction(558);

        /// <summary>
        /// Represents the PMOVSXWD instruction.
        /// </summary>
        public static readonly Instruction PMOVSXWD = new Instruction(559);

        /// <summary>
        /// Represents the PMOVSXWQ instruction.
        /// </summary>
        public static readonly Instruction PMOVSXWQ = new Instruction(560);

        /// <summary>
        /// Represents the PMOVZXBD instruction.
        /// </summary>
        public static readonly Instruction PMOVZXBD = new Instruction(561);

        /// <summary>
        /// Represents the PMOVZXBQ instruction.
        /// </summary>
        public static readonly Instruction PMOVZXBQ = new Instruction(562);

        /// <summary>
        /// Represents the PMOVZXBW instruction.
        /// </summary>
        public static readonly Instruction PMOVZXBW = new Instruction(563);

        /// <summary>
        /// Represents the PMOVZXDQ instruction.
        /// </summary>
        public static readonly Instruction PMOVZXDQ = new Instruction(564);

        /// <summary>
        /// Represents the PMOVZXWD instruction.
        /// </summary>
        public static readonly Instruction PMOVZXWD = new Instruction(565);

        /// <summary>
        /// Represents the PMOVZXWQ instruction.
        /// </summary>
        public static readonly Instruction PMOVZXWQ = new Instruction(566);

        /// <summary>
        /// Represents the PMULDQ instruction.
        /// </summary>
        public static readonly Instruction PMULDQ = new Instruction(567);

        /// <summary>
        /// Represents the PMULHRW instruction.
        /// </summary>
        public static readonly Instruction PMULHRW = new Instruction(568);

        /// <summary>
        /// Represents the PMULLD instruction.
        /// </summary>
        public static readonly Instruction PMULLD = new Instruction(569);

        /// <summary>
        /// Represents the POP instruction.
        /// </summary>
        public static readonly Instruction POP = new Instruction(570);

        /// <summary>
        /// Represents the POPAW instruction.
        /// </summary>
        public static readonly Instruction POPAW = new Instruction(571);

        /// <summary>
        /// Represents the POPAL instruction.
        /// </summary>
        public static readonly Instruction POPAL = new Instruction(572);

        /// <summary>
        /// Represents the POPCNT instruction.
        /// </summary>
        public static readonly Instruction POPCNT = new Instruction(573);

        /// <summary>
        /// Represents the POPF instruction.
        /// </summary>
        public static readonly Instruction POPF = new Instruction(574);

        /// <summary>
        /// Represents the POPFD instruction.
        /// </summary>
        public static readonly Instruction POPFD = new Instruction(575);

        /// <summary>
        /// Represents the POPFQ instruction.
        /// </summary>
        public static readonly Instruction POPFQ = new Instruction(576);

        /// <summary>
        /// Represents the PREFETCH instruction.
        /// </summary>
        public static readonly Instruction PREFETCH = new Instruction(577);

        /// <summary>
        /// Represents the PREFETCHNTA instruction.
        /// </summary>
        public static readonly Instruction PREFETCHNTA = new Instruction(578);

        /// <summary>
        /// Represents the PREFETCHT0 instruction.
        /// </summary>
        public static readonly Instruction PREFETCHT0 = new Instruction(579);

        /// <summary>
        /// Represents the PREFETCHT1 instruction.
        /// </summary>
        public static readonly Instruction PREFETCHT1 = new Instruction(580);

        /// <summary>
        /// Represents the PREFETCHT2 instruction.
        /// </summary>
        public static readonly Instruction PREFETCHT2 = new Instruction(581);

        /// <summary>
        /// Represents the PREFETCHW instruction.
        /// </summary>
        public static readonly Instruction PREFETCHW = new Instruction(582);

        /// <summary>
        /// Represents the PSHUFD instruction.
        /// </summary>
        public static readonly Instruction PSHUFD = new Instruction(583);

        /// <summary>
        /// Represents the PSHUFHW instruction.
        /// </summary>
        public static readonly Instruction PSHUFHW = new Instruction(584);

        /// <summary>
        /// Represents the PSHUFLW instruction.
        /// </summary>
        public static readonly Instruction PSHUFLW = new Instruction(585);

        /// <summary>
        /// Represents the PSLLDQ instruction.
        /// </summary>
        public static readonly Instruction PSLLDQ = new Instruction(586);

        /// <summary>
        /// Represents the PSRLDQ instruction.
        /// </summary>
        public static readonly Instruction PSRLDQ = new Instruction(587);

        /// <summary>
        /// Represents the PSWAPD instruction.
        /// </summary>
        public static readonly Instruction PSWAPD = new Instruction(588);

        /// <summary>
        /// Represents the PTEST instruction.
        /// </summary>
        public static readonly Instruction PTEST = new Instruction(589);

        /// <summary>
        /// Represents the PUNPCKHQDQ instruction.
        /// </summary>
        public static readonly Instruction PUNPCKHQDQ = new Instruction(590);

        /// <summary>
        /// Represents the PUNPCKLQDQ instruction.
        /// </summary>
        public static readonly Instruction PUNPCKLQDQ = new Instruction(591);

        /// <summary>
        /// Represents the PUSH instruction.
        /// </summary>
        public static readonly Instruction PUSH = new Instruction(592);

        /// <summary>
        /// Represents the PUSHAW instruction.
        /// </summary>
        public static readonly Instruction PUSHAW = new Instruction(593);

        /// <summary>
        /// Represents the PUSHAL instruction.
        /// </summary>
        public static readonly Instruction PUSHAL = new Instruction(594);

        /// <summary>
        /// Represents the PUSHF instruction.
        /// </summary>
        public static readonly Instruction PUSHF = new Instruction(595);

        /// <summary>
        /// Represents the PUSHFD instruction.
        /// </summary>
        public static readonly Instruction PUSHFD = new Instruction(596);

        /// <summary>
        /// Represents the PUSHFQ instruction.
        /// </summary>
        public static readonly Instruction PUSHFQ = new Instruction(597);

        /// <summary>
        /// Represents the RCL instruction.
        /// </summary>
        public static readonly Instruction RCL = new Instruction(598);

        /// <summary>
        /// Represents the RCPPS instruction.
        /// </summary>
        public static readonly Instruction RCPPS = new Instruction(599);

        /// <summary>
        /// Represents the RCPSS instruction.
        /// </summary>
        public static readonly Instruction RCPSS = new Instruction(600);

        /// <summary>
        /// Represents the RCR instruction.
        /// </summary>
        public static readonly Instruction RCR = new Instruction(601);

        /// <summary>
        /// Represents the RDFSBASE instruction.
        /// </summary>
        public static readonly Instruction RDFSBASE = new Instruction(602);

        /// <summary>
        /// Represents the RDGSBASE instruction.
        /// </summary>
        public static readonly Instruction RDGSBASE = new Instruction(603);

        /// <summary>
        /// Represents the RDMSR instruction.
        /// </summary>
        public static readonly Instruction RDMSR = new Instruction(604);

        /// <summary>
        /// Represents the RDPMC instruction.
        /// </summary>
        public static readonly Instruction RDPMC = new Instruction(605);

        /// <summary>
        /// Represents the RDRAND instruction.
        /// </summary>
        public static readonly Instruction RDRAND = new Instruction(606);

        /// <summary>
        /// Represents the RDSEED instruction.
        /// </summary>
        public static readonly Instruction RDSEED = new Instruction(607);

        /// <summary>
        /// Represents the RDTSC instruction.
        /// </summary>
        public static readonly Instruction RDTSC = new Instruction(608);

        /// <summary>
        /// Represents the RDTSCP instruction.
        /// </summary>
        public static readonly Instruction RDTSCP = new Instruction(609);

        /// <summary>
        /// Represents the ROL instruction.
        /// </summary>
        public static readonly Instruction ROL = new Instruction(610);

        /// <summary>
        /// Represents the ROR instruction.
        /// </summary>
        public static readonly Instruction ROR = new Instruction(611);

        /// <summary>
        /// Represents the RORX instruction.
        /// </summary>
        public static readonly Instruction RORX = new Instruction(612);

        /// <summary>
        /// Represents the ROUNDPD instruction.
        /// </summary>
        public static readonly Instruction ROUNDPD = new Instruction(613);

        /// <summary>
        /// Represents the ROUNDPS instruction.
        /// </summary>
        public static readonly Instruction ROUNDPS = new Instruction(614);

        /// <summary>
        /// Represents the ROUNDSD instruction.
        /// </summary>
        public static readonly Instruction ROUNDSD = new Instruction(615);

        /// <summary>
        /// Represents the ROUNDSS instruction.
        /// </summary>
        public static readonly Instruction ROUNDSS = new Instruction(616);

        /// <summary>
        /// Represents the RSM instruction.
        /// </summary>
        public static readonly Instruction RSM = new Instruction(617);

        /// <summary>
        /// Represents the RSQRTPS instruction.
        /// </summary>
        public static readonly Instruction RSQRTPS = new Instruction(618);

        /// <summary>
        /// Represents the RSQRTSS instruction.
        /// </summary>
        public static readonly Instruction RSQRTSS = new Instruction(619);

        /// <summary>
        /// Represents the SAHF instruction.
        /// </summary>
        public static readonly Instruction SAHF = new Instruction(620);

        /// <summary>
        /// Represents the SAL instruction.
        /// </summary>
        public static readonly Instruction SAL = new Instruction(621);

        /// <summary>
        /// Represents the SALC instruction.
        /// </summary>
        public static readonly Instruction SALC = new Instruction(622);

        /// <summary>
        /// Represents the SAR instruction.
        /// </summary>
        public static readonly Instruction SAR = new Instruction(623);

        /// <summary>
        /// Represents the SARX instruction.
        /// </summary>
        public static readonly Instruction SARX = new Instruction(624);

        /// <summary>
        /// Represents the SBB instruction.
        /// </summary>
        public static readonly Instruction SBB = new Instruction(625);

        /// <summary>
        /// Represents the SCASB instruction.
        /// </summary>
        public static readonly Instruction SCASB = new Instruction(626);

        /// <summary>
        /// Represents the SCASD instruction.
        /// </summary>
        public static readonly Instruction SCASD = new Instruction(627);

        /// <summary>
        /// Represents the SCASQ instruction.
        /// </summary>
        public static readonly Instruction SCASQ = new Instruction(628);

        /// <summary>
        /// Represents the SCASW instruction.
        /// </summary>
        public static readonly Instruction SCASW = new Instruction(629);

        /// <summary>
        /// Represents the SETAE instruction.
        /// </summary>
        public static readonly Instruction SETAE = new Instruction(630);

        /// <summary>
        /// Represents the SETA instruction.
        /// </summary>
        public static readonly Instruction SETA = new Instruction(631);

        /// <summary>
        /// Represents the SETBE instruction.
        /// </summary>
        public static readonly Instruction SETBE = new Instruction(632);

        /// <summary>
        /// Represents the SETB instruction.
        /// </summary>
        public static readonly Instruction SETB = new Instruction(633);

        /// <summary>
        /// Represents the SETE instruction.
        /// </summary>
        public static readonly Instruction SETE = new Instruction(634);

        /// <summary>
        /// Represents the SETGE instruction.
        /// </summary>
        public static readonly Instruction SETGE = new Instruction(635);

        /// <summary>
        /// Represents the SETG instruction.
        /// </summary>
        public static readonly Instruction SETG = new Instruction(636);

        /// <summary>
        /// Represents the SETLE instruction.
        /// </summary>
        public static readonly Instruction SETLE = new Instruction(637);

        /// <summary>
        /// Represents the SETL instruction.
        /// </summary>
        public static readonly Instruction SETL = new Instruction(638);

        /// <summary>
        /// Represents the SETNE instruction.
        /// </summary>
        public static readonly Instruction SETNE = new Instruction(639);

        /// <summary>
        /// Represents the SETNO instruction.
        /// </summary>
        public static readonly Instruction SETNO = new Instruction(640);

        /// <summary>
        /// Represents the SETNP instruction.
        /// </summary>
        public static readonly Instruction SETNP = new Instruction(641);

        /// <summary>
        /// Represents the SETNS instruction.
        /// </summary>
        public static readonly Instruction SETNS = new Instruction(642);

        /// <summary>
        /// Represents the SETO instruction.
        /// </summary>
        public static readonly Instruction SETO = new Instruction(643);

        /// <summary>
        /// Represents the SETP instruction.
        /// </summary>
        public static readonly Instruction SETP = new Instruction(644);

        /// <summary>
        /// Represents the SETS instruction.
        /// </summary>
        public static readonly Instruction SETS = new Instruction(645);

        /// <summary>
        /// Represents the SFENCE instruction.
        /// </summary>
        public static readonly Instruction SFENCE = new Instruction(646);

        /// <summary>
        /// Represents the SGDT instruction.
        /// </summary>
        public static readonly Instruction SGDT = new Instruction(647);

        /// <summary>
        /// Represents the SHA1MSG1 instruction.
        /// </summary>
        public static readonly Instruction SHA1MSG1 = new Instruction(648);

        /// <summary>
        /// Represents the SHA1MSG2 instruction.
        /// </summary>
        public static readonly Instruction SHA1MSG2 = new Instruction(649);

        /// <summary>
        /// Represents the SHA1NEXTE instruction.
        /// </summary>
        public static readonly Instruction SHA1NEXTE = new Instruction(650);

        /// <summary>
        /// Represents the SHA1RNDS4 instruction.
        /// </summary>
        public static readonly Instruction SHA1RNDS4 = new Instruction(651);

        /// <summary>
        /// Represents the SHA256MSG1 instruction.
        /// </summary>
        public static readonly Instruction SHA256MSG1 = new Instruction(652);

        /// <summary>
        /// Represents the SHA256MSG2 instruction.
        /// </summary>
        public static readonly Instruction SHA256MSG2 = new Instruction(653);

        /// <summary>
        /// Represents the SHA256RNDS2 instruction.
        /// </summary>
        public static readonly Instruction SHA256RNDS2 = new Instruction(654);

        /// <summary>
        /// Represents the SHL instruction.
        /// </summary>
        public static readonly Instruction SHL = new Instruction(655);

        /// <summary>
        /// Represents the SHLD instruction.
        /// </summary>
        public static readonly Instruction SHLD = new Instruction(656);

        /// <summary>
        /// Represents the SHLX instruction.
        /// </summary>
        public static readonly Instruction SHLX = new Instruction(657);

        /// <summary>
        /// Represents the SHR instruction.
        /// </summary>
        public static readonly Instruction SHR = new Instruction(658);

        /// <summary>
        /// Represents the SHRD instruction.
        /// </summary>
        public static readonly Instruction SHRD = new Instruction(659);

        /// <summary>
        /// Represents the SHRX instruction.
        /// </summary>
        public static readonly Instruction SHRX = new Instruction(660);

        /// <summary>
        /// Represents the SHUFPD instruction.
        /// </summary>
        public static readonly Instruction SHUFPD = new Instruction(661);

        /// <summary>
        /// Represents the SHUFPS instruction.
        /// </summary>
        public static readonly Instruction SHUFPS = new Instruction(662);

        /// <summary>
        /// Represents the SIDT instruction.
        /// </summary>
        public static readonly Instruction SIDT = new Instruction(663);

        /// <summary>
        /// Represents the FSIN instruction.
        /// </summary>
        public static readonly Instruction FSIN = new Instruction(664);

        /// <summary>
        /// Represents the SKINIT instruction.
        /// </summary>
        public static readonly Instruction SKINIT = new Instruction(665);

        /// <summary>
        /// Represents the SLDT instruction.
        /// </summary>
        public static readonly Instruction SLDT = new Instruction(666);

        /// <summary>
        /// Represents the SMSW instruction.
        /// </summary>
        public static readonly Instruction SMSW = new Instruction(667);

        /// <summary>
        /// Represents the SQRTPD instruction.
        /// </summary>
        public static readonly Instruction SQRTPD = new Instruction(668);

        /// <summary>
        /// Represents the SQRTPS instruction.
        /// </summary>
        public static readonly Instruction SQRTPS = new Instruction(669);

        /// <summary>
        /// Represents the SQRTSD instruction.
        /// </summary>
        public static readonly Instruction SQRTSD = new Instruction(670);

        /// <summary>
        /// Represents the SQRTSS instruction.
        /// </summary>
        public static readonly Instruction SQRTSS = new Instruction(671);

        /// <summary>
        /// Represents the FSQRT instruction.
        /// </summary>
        public static readonly Instruction FSQRT = new Instruction(672);

        /// <summary>
        /// Represents the STAC instruction.
        /// </summary>
        public static readonly Instruction STAC = new Instruction(673);

        /// <summary>
        /// Represents the STC instruction.
        /// </summary>
        public static readonly Instruction STC = new Instruction(674);

        /// <summary>
        /// Represents the STD instruction.
        /// </summary>
        public static readonly Instruction STD = new Instruction(675);

        /// <summary>
        /// Represents the STGI instruction.
        /// </summary>
        public static readonly Instruction STGI = new Instruction(676);

        /// <summary>
        /// Represents the STI instruction.
        /// </summary>
        public static readonly Instruction STI = new Instruction(677);

        /// <summary>
        /// Represents the STMXCSR instruction.
        /// </summary>
        public static readonly Instruction STMXCSR = new Instruction(678);

        /// <summary>
        /// Represents the STOSB instruction.
        /// </summary>
        public static readonly Instruction STOSB = new Instruction(679);

        /// <summary>
        /// Represents the STOSD instruction.
        /// </summary>
        public static readonly Instruction STOSD = new Instruction(680);

        /// <summary>
        /// Represents the STOSQ instruction.
        /// </summary>
        public static readonly Instruction STOSQ = new Instruction(681);

        /// <summary>
        /// Represents the STOSW instruction.
        /// </summary>
        public static readonly Instruction STOSW = new Instruction(682);

        /// <summary>
        /// Represents the STR instruction.
        /// </summary>
        public static readonly Instruction STR = new Instruction(683);

        /// <summary>
        /// Represents the FST instruction.
        /// </summary>
        public static readonly Instruction FST = new Instruction(684);

        /// <summary>
        /// Represents the FSTP instruction.
        /// </summary>
        public static readonly Instruction FSTP = new Instruction(685);

        /// <summary>
        /// Represents the FSTPNCE instruction.
        /// </summary>
        public static readonly Instruction FSTPNCE = new Instruction(686);

        /// <summary>
        /// Represents the FXCH instruction.
        /// </summary>
        public static readonly Instruction FXCH = new Instruction(687);

        /// <summary>
        /// Represents the SUBPD instruction.
        /// </summary>
        public static readonly Instruction SUBPD = new Instruction(688);

        /// <summary>
        /// Represents the SUBPS instruction.
        /// </summary>
        public static readonly Instruction SUBPS = new Instruction(689);

        /// <summary>
        /// Represents the FSUBR instruction.
        /// </summary>
        public static readonly Instruction FSUBR = new Instruction(690);

        /// <summary>
        /// Represents the FISUBR instruction.
        /// </summary>
        public static readonly Instruction FISUBR = new Instruction(691);

        /// <summary>
        /// Represents the FSUBRP instruction.
        /// </summary>
        public static readonly Instruction FSUBRP = new Instruction(692);

        /// <summary>
        /// Represents the SUBSD instruction.
        /// </summary>
        public static readonly Instruction SUBSD = new Instruction(693);

        /// <summary>
        /// Represents the SUBSS instruction.
        /// </summary>
        public static readonly Instruction SUBSS = new Instruction(694);

        /// <summary>
        /// Represents the FSUB instruction.
        /// </summary>
        public static readonly Instruction FSUB = new Instruction(695);

        /// <summary>
        /// Represents the FISUB instruction.
        /// </summary>
        public static readonly Instruction FISUB = new Instruction(696);

        /// <summary>
        /// Represents the FSUBP instruction.
        /// </summary>
        public static readonly Instruction FSUBP = new Instruction(697);

        /// <summary>
        /// Represents the SWAPGS instruction.
        /// </summary>
        public static readonly Instruction SWAPGS = new Instruction(698);

        /// <summary>
        /// Represents the SYSCALL instruction.
        /// </summary>
        public static readonly Instruction SYSCALL = new Instruction(699);

        /// <summary>
        /// Represents the SYSENTER instruction.
        /// </summary>
        public static readonly Instruction SYSENTER = new Instruction(700);

        /// <summary>
        /// Represents the SYSEXIT instruction.
        /// </summary>
        public static readonly Instruction SYSEXIT = new Instruction(701);

        /// <summary>
        /// Represents the SYSRET instruction.
        /// </summary>
        public static readonly Instruction SYSRET = new Instruction(702);

        /// <summary>
        /// Represents the T1MSKC instruction.
        /// </summary>
        public static readonly Instruction T1MSKC = new Instruction(703);

        /// <summary>
        /// Represents the TEST instruction.
        /// </summary>
        public static readonly Instruction TEST = new Instruction(704);

        /// <summary>
        /// Represents the UD2 instruction.
        /// </summary>
        public static readonly Instruction UD2 = new Instruction(705);

        /// <summary>
        /// Represents the FTST instruction.
        /// </summary>
        public static readonly Instruction FTST = new Instruction(706);

        /// <summary>
        /// Represents the TZCNT instruction.
        /// </summary>
        public static readonly Instruction TZCNT = new Instruction(707);

        /// <summary>
        /// Represents the TZMSK instruction.
        /// </summary>
        public static readonly Instruction TZMSK = new Instruction(708);

        /// <summary>
        /// Represents the FUCOMPI instruction.
        /// </summary>
        public static readonly Instruction FUCOMPI = new Instruction(709);

        /// <summary>
        /// Represents the FUCOMI instruction.
        /// </summary>
        public static readonly Instruction FUCOMI = new Instruction(710);

        /// <summary>
        /// Represents the FUCOMPP instruction.
        /// </summary>
        public static readonly Instruction FUCOMPP = new Instruction(711);

        /// <summary>
        /// Represents the FUCOMP instruction.
        /// </summary>
        public static readonly Instruction FUCOMP = new Instruction(712);

        /// <summary>
        /// Represents the FUCOM instruction.
        /// </summary>
        public static readonly Instruction FUCOM = new Instruction(713);

        /// <summary>
        /// Represents the UD2B instruction.
        /// </summary>
        public static readonly Instruction UD2B = new Instruction(714);

        /// <summary>
        /// Represents the UNPCKHPD instruction.
        /// </summary>
        public static readonly Instruction UNPCKHPD = new Instruction(715);

        /// <summary>
        /// Represents the UNPCKHPS instruction.
        /// </summary>
        public static readonly Instruction UNPCKHPS = new Instruction(716);

        /// <summary>
        /// Represents the UNPCKLPD instruction.
        /// </summary>
        public static readonly Instruction UNPCKLPD = new Instruction(717);

        /// <summary>
        /// Represents the UNPCKLPS instruction.
        /// </summary>
        public static readonly Instruction UNPCKLPS = new Instruction(718);

        /// <summary>
        /// Represents the VADDPD instruction.
        /// </summary>
        public static readonly Instruction VADDPD = new Instruction(719);

        /// <summary>
        /// Represents the VADDPS instruction.
        /// </summary>
        public static readonly Instruction VADDPS = new Instruction(720);

        /// <summary>
        /// Represents the VADDSD instruction.
        /// </summary>
        public static readonly Instruction VADDSD = new Instruction(721);

        /// <summary>
        /// Represents the VADDSS instruction.
        /// </summary>
        public static readonly Instruction VADDSS = new Instruction(722);

        /// <summary>
        /// Represents the VADDSUBPD instruction.
        /// </summary>
        public static readonly Instruction VADDSUBPD = new Instruction(723);

        /// <summary>
        /// Represents the VADDSUBPS instruction.
        /// </summary>
        public static readonly Instruction VADDSUBPS = new Instruction(724);

        /// <summary>
        /// Represents the VAESDECLAST instruction.
        /// </summary>
        public static readonly Instruction VAESDECLAST = new Instruction(725);

        /// <summary>
        /// Represents the VAESDEC instruction.
        /// </summary>
        public static readonly Instruction VAESDEC = new Instruction(726);

        /// <summary>
        /// Represents the VAESENCLAST instruction.
        /// </summary>
        public static readonly Instruction VAESENCLAST = new Instruction(727);

        /// <summary>
        /// Represents the VAESENC instruction.
        /// </summary>
        public static readonly Instruction VAESENC = new Instruction(728);

        /// <summary>
        /// Represents the VAESIMC instruction.
        /// </summary>
        public static readonly Instruction VAESIMC = new Instruction(729);

        /// <summary>
        /// Represents the VAESKEYGENASSIST instruction.
        /// </summary>
        public static readonly Instruction VAESKEYGENASSIST = new Instruction(730);

        /// <summary>
        /// Represents the VALIGND instruction.
        /// </summary>
        public static readonly Instruction VALIGND = new Instruction(731);

        /// <summary>
        /// Represents the VALIGNQ instruction.
        /// </summary>
        public static readonly Instruction VALIGNQ = new Instruction(732);

        /// <summary>
        /// Represents the VANDNPD instruction.
        /// </summary>
        public static readonly Instruction VANDNPD = new Instruction(733);

        /// <summary>
        /// Represents the VANDNPS instruction.
        /// </summary>
        public static readonly Instruction VANDNPS = new Instruction(734);

        /// <summary>
        /// Represents the VANDPD instruction.
        /// </summary>
        public static readonly Instruction VANDPD = new Instruction(735);

        /// <summary>
        /// Represents the VANDPS instruction.
        /// </summary>
        public static readonly Instruction VANDPS = new Instruction(736);

        /// <summary>
        /// Represents the VBLENDMPD instruction.
        /// </summary>
        public static readonly Instruction VBLENDMPD = new Instruction(737);

        /// <summary>
        /// Represents the VBLENDMPS instruction.
        /// </summary>
        public static readonly Instruction VBLENDMPS = new Instruction(738);

        /// <summary>
        /// Represents the VBLENDPD instruction.
        /// </summary>
        public static readonly Instruction VBLENDPD = new Instruction(739);

        /// <summary>
        /// Represents the VBLENDPS instruction.
        /// </summary>
        public static readonly Instruction VBLENDPS = new Instruction(740);

        /// <summary>
        /// Represents the VBLENDVPD instruction.
        /// </summary>
        public static readonly Instruction VBLENDVPD = new Instruction(741);

        /// <summary>
        /// Represents the VBLENDVPS instruction.
        /// </summary>
        public static readonly Instruction VBLENDVPS = new Instruction(742);

        /// <summary>
        /// Represents the VBROADCASTF128 instruction.
        /// </summary>
        public static readonly Instruction VBROADCASTF128 = new Instruction(743);

        /// <summary>
        /// Represents the VBROADCASTI32X4 instruction.
        /// </summary>
        public static readonly Instruction VBROADCASTI32X4 = new Instruction(744);

        /// <summary>
        /// Represents the VBROADCASTI64X4 instruction.
        /// </summary>
        public static readonly Instruction VBROADCASTI64X4 = new Instruction(745);

        /// <summary>
        /// Represents the VBROADCASTSD instruction.
        /// </summary>
        public static readonly Instruction VBROADCASTSD = new Instruction(746);

        /// <summary>
        /// Represents the VBROADCASTSS instruction.
        /// </summary>
        public static readonly Instruction VBROADCASTSS = new Instruction(747);

        /// <summary>
        /// Represents the VCMPPD instruction.
        /// </summary>
        public static readonly Instruction VCMPPD = new Instruction(748);

        /// <summary>
        /// Represents the VCMPPS instruction.
        /// </summary>
        public static readonly Instruction VCMPPS = new Instruction(749);

        /// <summary>
        /// Represents the VCMPSD instruction.
        /// </summary>
        public static readonly Instruction VCMPSD = new Instruction(750);

        /// <summary>
        /// Represents the VCMPSS instruction.
        /// </summary>
        public static readonly Instruction VCMPSS = new Instruction(751);

        /// <summary>
        /// Represents the VCOMPRESSPD instruction.
        /// </summary>
        public static readonly Instruction VCOMPRESSPD = new Instruction(752);

        /// <summary>
        /// Represents the VCOMPRESSPS instruction.
        /// </summary>
        public static readonly Instruction VCOMPRESSPS = new Instruction(753);

        /// <summary>
        /// Represents the VCVTDQ2PD instruction.
        /// </summary>
        public static readonly Instruction VCVTDQ2PD = new Instruction(754);

        /// <summary>
        /// Represents the VCVTDQ2PS instruction.
        /// </summary>
        public static readonly Instruction VCVTDQ2PS = new Instruction(755);

        /// <summary>
        /// Represents the VCVTPD2DQX instruction.
        /// </summary>
        public static readonly Instruction VCVTPD2DQX = new Instruction(756);

        /// <summary>
        /// Represents the VCVTPD2DQ instruction.
        /// </summary>
        public static readonly Instruction VCVTPD2DQ = new Instruction(757);

        /// <summary>
        /// Represents the VCVTPD2PSX instruction.
        /// </summary>
        public static readonly Instruction VCVTPD2PSX = new Instruction(758);

        /// <summary>
        /// Represents the VCVTPD2PS instruction.
        /// </summary>
        public static readonly Instruction VCVTPD2PS = new Instruction(759);

        /// <summary>
        /// Represents the VCVTPD2UDQ instruction.
        /// </summary>
        public static readonly Instruction VCVTPD2UDQ = new Instruction(760);

        /// <summary>
        /// Represents the VCVTPH2PS instruction.
        /// </summary>
        public static readonly Instruction VCVTPH2PS = new Instruction(761);

        /// <summary>
        /// Represents the VCVTPS2DQ instruction.
        /// </summary>
        public static readonly Instruction VCVTPS2DQ = new Instruction(762);

        /// <summary>
        /// Represents the VCVTPS2PD instruction.
        /// </summary>
        public static readonly Instruction VCVTPS2PD = new Instruction(763);

        /// <summary>
        /// Represents the VCVTPS2PH instruction.
        /// </summary>
        public static readonly Instruction VCVTPS2PH = new Instruction(764);

        /// <summary>
        /// Represents the VCVTPS2UDQ instruction.
        /// </summary>
        public static readonly Instruction VCVTPS2UDQ = new Instruction(765);

        /// <summary>
        /// Represents the VCVTSD2SI instruction.
        /// </summary>
        public static readonly Instruction VCVTSD2SI = new Instruction(766);

        /// <summary>
        /// Represents the VCVTSD2USI instruction.
        /// </summary>
        public static readonly Instruction VCVTSD2USI = new Instruction(767);

        /// <summary>
        /// Represents the VCVTSS2SI instruction.
        /// </summary>
        public static readonly Instruction VCVTSS2SI = new Instruction(768);

        /// <summary>
        /// Represents the VCVTSS2USI instruction.
        /// </summary>
        public static readonly Instruction VCVTSS2USI = new Instruction(769);

        /// <summary>
        /// Represents the VCVTTPD2DQX instruction.
        /// </summary>
        public static readonly Instruction VCVTTPD2DQX = new Instruction(770);

        /// <summary>
        /// Represents the VCVTTPD2DQ instruction.
        /// </summary>
        public static readonly Instruction VCVTTPD2DQ = new Instruction(771);

        /// <summary>
        /// Represents the VCVTTPD2UDQ instruction.
        /// </summary>
        public static readonly Instruction VCVTTPD2UDQ = new Instruction(772);

        /// <summary>
        /// Represents the VCVTTPS2DQ instruction.
        /// </summary>
        public static readonly Instruction VCVTTPS2DQ = new Instruction(773);

        /// <summary>
        /// Represents the VCVTTPS2UDQ instruction.
        /// </summary>
        public static readonly Instruction VCVTTPS2UDQ = new Instruction(774);

        /// <summary>
        /// Represents the VCVTUDQ2PD instruction.
        /// </summary>
        public static readonly Instruction VCVTUDQ2PD = new Instruction(775);

        /// <summary>
        /// Represents the VCVTUDQ2PS instruction.
        /// </summary>
        public static readonly Instruction VCVTUDQ2PS = new Instruction(776);

        /// <summary>
        /// Represents the VDIVPD instruction.
        /// </summary>
        public static readonly Instruction VDIVPD = new Instruction(777);

        /// <summary>
        /// Represents the VDIVPS instruction.
        /// </summary>
        public static readonly Instruction VDIVPS = new Instruction(778);

        /// <summary>
        /// Represents the VDIVSD instruction.
        /// </summary>
        public static readonly Instruction VDIVSD = new Instruction(779);

        /// <summary>
        /// Represents the VDIVSS instruction.
        /// </summary>
        public static readonly Instruction VDIVSS = new Instruction(780);

        /// <summary>
        /// Represents the VDPPD instruction.
        /// </summary>
        public static readonly Instruction VDPPD = new Instruction(781);

        /// <summary>
        /// Represents the VDPPS instruction.
        /// </summary>
        public static readonly Instruction VDPPS = new Instruction(782);

        /// <summary>
        /// Represents the VERR instruction.
        /// </summary>
        public static readonly Instruction VERR = new Instruction(783);

        /// <summary>
        /// Represents the VERW instruction.
        /// </summary>
        public static readonly Instruction VERW = new Instruction(784);

        /// <summary>
        /// Represents the VEXP2PD instruction.
        /// </summary>
        public static readonly Instruction VEXP2PD = new Instruction(785);

        /// <summary>
        /// Represents the VEXP2PS instruction.
        /// </summary>
        public static readonly Instruction VEXP2PS = new Instruction(786);

        /// <summary>
        /// Represents the VEXPANDPD instruction.
        /// </summary>
        public static readonly Instruction VEXPANDPD = new Instruction(787);

        /// <summary>
        /// Represents the VEXPANDPS instruction.
        /// </summary>
        public static readonly Instruction VEXPANDPS = new Instruction(788);

        /// <summary>
        /// Represents the VEXTRACTF128 instruction.
        /// </summary>
        public static readonly Instruction VEXTRACTF128 = new Instruction(789);

        /// <summary>
        /// Represents the VEXTRACTF32X4 instruction.
        /// </summary>
        public static readonly Instruction VEXTRACTF32X4 = new Instruction(790);

        /// <summary>
        /// Represents the VEXTRACTF64X4 instruction.
        /// </summary>
        public static readonly Instruction VEXTRACTF64X4 = new Instruction(791);

        /// <summary>
        /// Represents the VEXTRACTI128 instruction.
        /// </summary>
        public static readonly Instruction VEXTRACTI128 = new Instruction(792);

        /// <summary>
        /// Represents the VEXTRACTI32X4 instruction.
        /// </summary>
        public static readonly Instruction VEXTRACTI32X4 = new Instruction(793);

        /// <summary>
        /// Represents the VEXTRACTI64X4 instruction.
        /// </summary>
        public static readonly Instruction VEXTRACTI64X4 = new Instruction(794);

        /// <summary>
        /// Represents the VEXTRACTPS instruction.
        /// </summary>
        public static readonly Instruction VEXTRACTPS = new Instruction(795);

        /// <summary>
        /// Represents the VFMADD132PD instruction.
        /// </summary>
        public static readonly Instruction VFMADD132PD = new Instruction(796);

        /// <summary>
        /// Represents the VFMADD132PS instruction.
        /// </summary>
        public static readonly Instruction VFMADD132PS = new Instruction(797);

        /// <summary>
        /// Represents the VFMADDPD instruction.
        /// </summary>
        public static readonly Instruction VFMADDPD = new Instruction(798);

        /// <summary>
        /// Represents the VFMADD213PD instruction.
        /// </summary>
        public static readonly Instruction VFMADD213PD = new Instruction(799);

        /// <summary>
        /// Represents the VFMADD231PD instruction.
        /// </summary>
        public static readonly Instruction VFMADD231PD = new Instruction(800);

        /// <summary>
        /// Represents the VFMADDPS instruction.
        /// </summary>
        public static readonly Instruction VFMADDPS = new Instruction(801);

        /// <summary>
        /// Represents the VFMADD213PS instruction.
        /// </summary>
        public static readonly Instruction VFMADD213PS = new Instruction(802);

        /// <summary>
        /// Represents the VFMADD231PS instruction.
        /// </summary>
        public static readonly Instruction VFMADD231PS = new Instruction(803);

        /// <summary>
        /// Represents the VFMADDSD instruction.
        /// </summary>
        public static readonly Instruction VFMADDSD = new Instruction(804);

        /// <summary>
        /// Represents the VFMADD213SD instruction.
        /// </summary>
        public static readonly Instruction VFMADD213SD = new Instruction(805);

        /// <summary>
        /// Represents the VFMADD132SD instruction.
        /// </summary>
        public static readonly Instruction VFMADD132SD = new Instruction(806);

        /// <summary>
        /// Represents the VFMADD231SD instruction.
        /// </summary>
        public static readonly Instruction VFMADD231SD = new Instruction(807);

        /// <summary>
        /// Represents the VFMADDSS instruction.
        /// </summary>
        public static readonly Instruction VFMADDSS = new Instruction(808);

        /// <summary>
        /// Represents the VFMADD213SS instruction.
        /// </summary>
        public static readonly Instruction VFMADD213SS = new Instruction(809);

        /// <summary>
        /// Represents the VFMADD132SS instruction.
        /// </summary>
        public static readonly Instruction VFMADD132SS = new Instruction(810);

        /// <summary>
        /// Represents the VFMADD231SS instruction.
        /// </summary>
        public static readonly Instruction VFMADD231SS = new Instruction(811);

        /// <summary>
        /// Represents the VFMADDSUB132PD instruction.
        /// </summary>
        public static readonly Instruction VFMADDSUB132PD = new Instruction(812);

        /// <summary>
        /// Represents the VFMADDSUB132PS instruction.
        /// </summary>
        public static readonly Instruction VFMADDSUB132PS = new Instruction(813);

        /// <summary>
        /// Represents the VFMADDSUBPD instruction.
        /// </summary>
        public static readonly Instruction VFMADDSUBPD = new Instruction(814);

        /// <summary>
        /// Represents the VFMADDSUB213PD instruction.
        /// </summary>
        public static readonly Instruction VFMADDSUB213PD = new Instruction(815);

        /// <summary>
        /// Represents the VFMADDSUB231PD instruction.
        /// </summary>
        public static readonly Instruction VFMADDSUB231PD = new Instruction(816);

        /// <summary>
        /// Represents the VFMADDSUBPS instruction.
        /// </summary>
        public static readonly Instruction VFMADDSUBPS = new Instruction(817);

        /// <summary>
        /// Represents the VFMADDSUB213PS instruction.
        /// </summary>
        public static readonly Instruction VFMADDSUB213PS = new Instruction(818);

        /// <summary>
        /// Represents the VFMADDSUB231PS instruction.
        /// </summary>
        public static readonly Instruction VFMADDSUB231PS = new Instruction(819);

        /// <summary>
        /// Represents the VFMSUB132PD instruction.
        /// </summary>
        public static readonly Instruction VFMSUB132PD = new Instruction(820);

        /// <summary>
        /// Represents the VFMSUB132PS instruction.
        /// </summary>
        public static readonly Instruction VFMSUB132PS = new Instruction(821);

        /// <summary>
        /// Represents the VFMSUBADD132PD instruction.
        /// </summary>
        public static readonly Instruction VFMSUBADD132PD = new Instruction(822);

        /// <summary>
        /// Represents the VFMSUBADD132PS instruction.
        /// </summary>
        public static readonly Instruction VFMSUBADD132PS = new Instruction(823);

        /// <summary>
        /// Represents the VFMSUBADDPD instruction.
        /// </summary>
        public static readonly Instruction VFMSUBADDPD = new Instruction(824);

        /// <summary>
        /// Represents the VFMSUBADD213PD instruction.
        /// </summary>
        public static readonly Instruction VFMSUBADD213PD = new Instruction(825);

        /// <summary>
        /// Represents the VFMSUBADD231PD instruction.
        /// </summary>
        public static readonly Instruction VFMSUBADD231PD = new Instruction(826);

        /// <summary>
        /// Represents the VFMSUBADDPS instruction.
        /// </summary>
        public static readonly Instruction VFMSUBADDPS = new Instruction(827);

        /// <summary>
        /// Represents the VFMSUBADD213PS instruction.
        /// </summary>
        public static readonly Instruction VFMSUBADD213PS = new Instruction(828);

        /// <summary>
        /// Represents the VFMSUBADD231PS instruction.
        /// </summary>
        public static readonly Instruction VFMSUBADD231PS = new Instruction(829);

        /// <summary>
        /// Represents the VFMSUBPD instruction.
        /// </summary>
        public static readonly Instruction VFMSUBPD = new Instruction(830);

        /// <summary>
        /// Represents the VFMSUB213PD instruction.
        /// </summary>
        public static readonly Instruction VFMSUB213PD = new Instruction(831);

        /// <summary>
        /// Represents the VFMSUB231PD instruction.
        /// </summary>
        public static readonly Instruction VFMSUB231PD = new Instruction(832);

        /// <summary>
        /// Represents the VFMSUBPS instruction.
        /// </summary>
        public static readonly Instruction VFMSUBPS = new Instruction(833);

        /// <summary>
        /// Represents the VFMSUB213PS instruction.
        /// </summary>
        public static readonly Instruction VFMSUB213PS = new Instruction(834);

        /// <summary>
        /// Represents the VFMSUB231PS instruction.
        /// </summary>
        public static readonly Instruction VFMSUB231PS = new Instruction(835);

        /// <summary>
        /// Represents the VFMSUBSD instruction.
        /// </summary>
        public static readonly Instruction VFMSUBSD = new Instruction(836);

        /// <summary>
        /// Represents the VFMSUB213SD instruction.
        /// </summary>
        public static readonly Instruction VFMSUB213SD = new Instruction(837);

        /// <summary>
        /// Represents the VFMSUB132SD instruction.
        /// </summary>
        public static readonly Instruction VFMSUB132SD = new Instruction(838);

        /// <summary>
        /// Represents the VFMSUB231SD instruction.
        /// </summary>
        public static readonly Instruction VFMSUB231SD = new Instruction(839);

        /// <summary>
        /// Represents the VFMSUBSS instruction.
        /// </summary>
        public static readonly Instruction VFMSUBSS = new Instruction(840);

        /// <summary>
        /// Represents the VFMSUB213SS instruction.
        /// </summary>
        public static readonly Instruction VFMSUB213SS = new Instruction(841);

        /// <summary>
        /// Represents the VFMSUB132SS instruction.
        /// </summary>
        public static readonly Instruction VFMSUB132SS = new Instruction(842);

        /// <summary>
        /// Represents the VFMSUB231SS instruction.
        /// </summary>
        public static readonly Instruction VFMSUB231SS = new Instruction(843);

        /// <summary>
        /// Represents the VFNMADD132PD instruction.
        /// </summary>
        public static readonly Instruction VFNMADD132PD = new Instruction(844);

        /// <summary>
        /// Represents the VFNMADD132PS instruction.
        /// </summary>
        public static readonly Instruction VFNMADD132PS = new Instruction(845);

        /// <summary>
        /// Represents the VFNMADDPD instruction.
        /// </summary>
        public static readonly Instruction VFNMADDPD = new Instruction(846);

        /// <summary>
        /// Represents the VFNMADD213PD instruction.
        /// </summary>
        public static readonly Instruction VFNMADD213PD = new Instruction(847);

        /// <summary>
        /// Represents the VFNMADD231PD instruction.
        /// </summary>
        public static readonly Instruction VFNMADD231PD = new Instruction(848);

        /// <summary>
        /// Represents the VFNMADDPS instruction.
        /// </summary>
        public static readonly Instruction VFNMADDPS = new Instruction(849);

        /// <summary>
        /// Represents the VFNMADD213PS instruction.
        /// </summary>
        public static readonly Instruction VFNMADD213PS = new Instruction(850);

        /// <summary>
        /// Represents the VFNMADD231PS instruction.
        /// </summary>
        public static readonly Instruction VFNMADD231PS = new Instruction(851);

        /// <summary>
        /// Represents the VFNMADDSD instruction.
        /// </summary>
        public static readonly Instruction VFNMADDSD = new Instruction(852);

        /// <summary>
        /// Represents the VFNMADD213SD instruction.
        /// </summary>
        public static readonly Instruction VFNMADD213SD = new Instruction(853);

        /// <summary>
        /// Represents the VFNMADD132SD instruction.
        /// </summary>
        public static readonly Instruction VFNMADD132SD = new Instruction(854);

        /// <summary>
        /// Represents the VFNMADD231SD instruction.
        /// </summary>
        public static readonly Instruction VFNMADD231SD = new Instruction(855);

        /// <summary>
        /// Represents the VFNMADDSS instruction.
        /// </summary>
        public static readonly Instruction VFNMADDSS = new Instruction(856);

        /// <summary>
        /// Represents the VFNMADD213SS instruction.
        /// </summary>
        public static readonly Instruction VFNMADD213SS = new Instruction(857);

        /// <summary>
        /// Represents the VFNMADD132SS instruction.
        /// </summary>
        public static readonly Instruction VFNMADD132SS = new Instruction(858);

        /// <summary>
        /// Represents the VFNMADD231SS instruction.
        /// </summary>
        public static readonly Instruction VFNMADD231SS = new Instruction(859);

        /// <summary>
        /// Represents the VFNMSUB132PD instruction.
        /// </summary>
        public static readonly Instruction VFNMSUB132PD = new Instruction(860);

        /// <summary>
        /// Represents the VFNMSUB132PS instruction.
        /// </summary>
        public static readonly Instruction VFNMSUB132PS = new Instruction(861);

        /// <summary>
        /// Represents the VFNMSUBPD instruction.
        /// </summary>
        public static readonly Instruction VFNMSUBPD = new Instruction(862);

        /// <summary>
        /// Represents the VFNMSUB213PD instruction.
        /// </summary>
        public static readonly Instruction VFNMSUB213PD = new Instruction(863);

        /// <summary>
        /// Represents the VFNMSUB231PD instruction.
        /// </summary>
        public static readonly Instruction VFNMSUB231PD = new Instruction(864);

        /// <summary>
        /// Represents the VFNMSUBPS instruction.
        /// </summary>
        public static readonly Instruction VFNMSUBPS = new Instruction(865);

        /// <summary>
        /// Represents the VFNMSUB213PS instruction.
        /// </summary>
        public static readonly Instruction VFNMSUB213PS = new Instruction(866);

        /// <summary>
        /// Represents the VFNMSUB231PS instruction.
        /// </summary>
        public static readonly Instruction VFNMSUB231PS = new Instruction(867);

        /// <summary>
        /// Represents the VFNMSUBSD instruction.
        /// </summary>
        public static readonly Instruction VFNMSUBSD = new Instruction(868);

        /// <summary>
        /// Represents the VFNMSUB213SD instruction.
        /// </summary>
        public static readonly Instruction VFNMSUB213SD = new Instruction(869);

        /// <summary>
        /// Represents the VFNMSUB132SD instruction.
        /// </summary>
        public static readonly Instruction VFNMSUB132SD = new Instruction(870);

        /// <summary>
        /// Represents the VFNMSUB231SD instruction.
        /// </summary>
        public static readonly Instruction VFNMSUB231SD = new Instruction(871);

        /// <summary>
        /// Represents the VFNMSUBSS instruction.
        /// </summary>
        public static readonly Instruction VFNMSUBSS = new Instruction(872);

        /// <summary>
        /// Represents the VFNMSUB213SS instruction.
        /// </summary>
        public static readonly Instruction VFNMSUB213SS = new Instruction(873);

        /// <summary>
        /// Represents the VFNMSUB132SS instruction.
        /// </summary>
        public static readonly Instruction VFNMSUB132SS = new Instruction(874);

        /// <summary>
        /// Represents the VFNMSUB231SS instruction.
        /// </summary>
        public static readonly Instruction VFNMSUB231SS = new Instruction(875);

        /// <summary>
        /// Represents the VFRCZPD instruction.
        /// </summary>
        public static readonly Instruction VFRCZPD = new Instruction(876);

        /// <summary>
        /// Represents the VFRCZPS instruction.
        /// </summary>
        public static readonly Instruction VFRCZPS = new Instruction(877);

        /// <summary>
        /// Represents the VFRCZSD instruction.
        /// </summary>
        public static readonly Instruction VFRCZSD = new Instruction(878);

        /// <summary>
        /// Represents the VFRCZSS instruction.
        /// </summary>
        public static readonly Instruction VFRCZSS = new Instruction(879);

        /// <summary>
        /// Represents the VORPD instruction.
        /// </summary>
        public static readonly Instruction VORPD = new Instruction(880);

        /// <summary>
        /// Represents the VORPS instruction.
        /// </summary>
        public static readonly Instruction VORPS = new Instruction(881);

        /// <summary>
        /// Represents the VXORPD instruction.
        /// </summary>
        public static readonly Instruction VXORPD = new Instruction(882);

        /// <summary>
        /// Represents the VXORPS instruction.
        /// </summary>
        public static readonly Instruction VXORPS = new Instruction(883);

        /// <summary>
        /// Represents the VGATHERDPD instruction.
        /// </summary>
        public static readonly Instruction VGATHERDPD = new Instruction(884);

        /// <summary>
        /// Represents the VGATHERDPS instruction.
        /// </summary>
        public static readonly Instruction VGATHERDPS = new Instruction(885);

        /// <summary>
        /// Represents the VGATHERPF0DPD instruction.
        /// </summary>
        public static readonly Instruction VGATHERPF0DPD = new Instruction(886);

        /// <summary>
        /// Represents the VGATHERPF0DPS instruction.
        /// </summary>
        public static readonly Instruction VGATHERPF0DPS = new Instruction(887);

        /// <summary>
        /// Represents the VGATHERPF0QPD instruction.
        /// </summary>
        public static readonly Instruction VGATHERPF0QPD = new Instruction(888);

        /// <summary>
        /// Represents the VGATHERPF0QPS instruction.
        /// </summary>
        public static readonly Instruction VGATHERPF0QPS = new Instruction(889);

        /// <summary>
        /// Represents the VGATHERPF1DPD instruction.
        /// </summary>
        public static readonly Instruction VGATHERPF1DPD = new Instruction(890);

        /// <summary>
        /// Represents the VGATHERPF1DPS instruction.
        /// </summary>
        public static readonly Instruction VGATHERPF1DPS = new Instruction(891);

        /// <summary>
        /// Represents the VGATHERPF1QPD instruction.
        /// </summary>
        public static readonly Instruction VGATHERPF1QPD = new Instruction(892);

        /// <summary>
        /// Represents the VGATHERPF1QPS instruction.
        /// </summary>
        public static readonly Instruction VGATHERPF1QPS = new Instruction(893);

        /// <summary>
        /// Represents the VGATHERQPD instruction.
        /// </summary>
        public static readonly Instruction VGATHERQPD = new Instruction(894);

        /// <summary>
        /// Represents the VGATHERQPS instruction.
        /// </summary>
        public static readonly Instruction VGATHERQPS = new Instruction(895);

        /// <summary>
        /// Represents the VHADDPD instruction.
        /// </summary>
        public static readonly Instruction VHADDPD = new Instruction(896);

        /// <summary>
        /// Represents the VHADDPS instruction.
        /// </summary>
        public static readonly Instruction VHADDPS = new Instruction(897);

        /// <summary>
        /// Represents the VHSUBPD instruction.
        /// </summary>
        public static readonly Instruction VHSUBPD = new Instruction(898);

        /// <summary>
        /// Represents the VHSUBPS instruction.
        /// </summary>
        public static readonly Instruction VHSUBPS = new Instruction(899);

        /// <summary>
        /// Represents the VINSERTF128 instruction.
        /// </summary>
        public static readonly Instruction VINSERTF128 = new Instruction(900);

        /// <summary>
        /// Represents the VINSERTF32X4 instruction.
        /// </summary>
        public static readonly Instruction VINSERTF32X4 = new Instruction(901);

        /// <summary>
        /// Represents the VINSERTF32X8 instruction.
        /// </summary>
        public static readonly Instruction VINSERTF32X8 = new Instruction(902);

        /// <summary>
        /// Represents the VINSERTF64X2 instruction.
        /// </summary>
        public static readonly Instruction VINSERTF64X2 = new Instruction(903);

        /// <summary>
        /// Represents the VINSERTF64X4 instruction.
        /// </summary>
        public static readonly Instruction VINSERTF64X4 = new Instruction(904);

        /// <summary>
        /// Represents the VINSERTI128 instruction.
        /// </summary>
        public static readonly Instruction VINSERTI128 = new Instruction(905);

        /// <summary>
        /// Represents the VINSERTI32X4 instruction.
        /// </summary>
        public static readonly Instruction VINSERTI32X4 = new Instruction(906);

        /// <summary>
        /// Represents the VINSERTI32X8 instruction.
        /// </summary>
        public static readonly Instruction VINSERTI32X8 = new Instruction(907);

        /// <summary>
        /// Represents the VINSERTI64X2 instruction.
        /// </summary>
        public static readonly Instruction VINSERTI64X2 = new Instruction(908);

        /// <summary>
        /// Represents the VINSERTI64X4 instruction.
        /// </summary>
        public static readonly Instruction VINSERTI64X4 = new Instruction(909);

        /// <summary>
        /// Represents the VINSERTPS instruction.
        /// </summary>
        public static readonly Instruction VINSERTPS = new Instruction(910);

        /// <summary>
        /// Represents the VLDDQU instruction.
        /// </summary>
        public static readonly Instruction VLDDQU = new Instruction(911);

        /// <summary>
        /// Represents the VLDMXCSR instruction.
        /// </summary>
        public static readonly Instruction VLDMXCSR = new Instruction(912);

        /// <summary>
        /// Represents the VMASKMOVDQU instruction.
        /// </summary>
        public static readonly Instruction VMASKMOVDQU = new Instruction(913);

        /// <summary>
        /// Represents the VMASKMOVPD instruction.
        /// </summary>
        public static readonly Instruction VMASKMOVPD = new Instruction(914);

        /// <summary>
        /// Represents the VMASKMOVPS instruction.
        /// </summary>
        public static readonly Instruction VMASKMOVPS = new Instruction(915);

        /// <summary>
        /// Represents the VMAXPD instruction.
        /// </summary>
        public static readonly Instruction VMAXPD = new Instruction(916);

        /// <summary>
        /// Represents the VMAXPS instruction.
        /// </summary>
        public static readonly Instruction VMAXPS = new Instruction(917);

        /// <summary>
        /// Represents the VMAXSD instruction.
        /// </summary>
        public static readonly Instruction VMAXSD = new Instruction(918);

        /// <summary>
        /// Represents the VMAXSS instruction.
        /// </summary>
        public static readonly Instruction VMAXSS = new Instruction(919);

        /// <summary>
        /// Represents the VMCALL instruction.
        /// </summary>
        public static readonly Instruction VMCALL = new Instruction(920);

        /// <summary>
        /// Represents the VMCLEAR instruction.
        /// </summary>
        public static readonly Instruction VMCLEAR = new Instruction(921);

        /// <summary>
        /// Represents the VMFUNC instruction.
        /// </summary>
        public static readonly Instruction VMFUNC = new Instruction(922);

        /// <summary>
        /// Represents the VMINPD instruction.
        /// </summary>
        public static readonly Instruction VMINPD = new Instruction(923);

        /// <summary>
        /// Represents the VMINPS instruction.
        /// </summary>
        public static readonly Instruction VMINPS = new Instruction(924);

        /// <summary>
        /// Represents the VMINSD instruction.
        /// </summary>
        public static readonly Instruction VMINSD = new Instruction(925);

        /// <summary>
        /// Represents the VMINSS instruction.
        /// </summary>
        public static readonly Instruction VMINSS = new Instruction(926);

        /// <summary>
        /// Represents the VMLAUNCH instruction.
        /// </summary>
        public static readonly Instruction VMLAUNCH = new Instruction(927);

        /// <summary>
        /// Represents the VMLOAD instruction.
        /// </summary>
        public static readonly Instruction VMLOAD = new Instruction(928);

        /// <summary>
        /// Represents the VMMCALL instruction.
        /// </summary>
        public static readonly Instruction VMMCALL = new Instruction(929);

        /// <summary>
        /// Represents the VMOVQ instruction.
        /// </summary>
        public static readonly Instruction VMOVQ = new Instruction(930);

        /// <summary>
        /// Represents the VMOVDDUP instruction.
        /// </summary>
        public static readonly Instruction VMOVDDUP = new Instruction(931);

        /// <summary>
        /// Represents the VMOVD instruction.
        /// </summary>
        public static readonly Instruction VMOVD = new Instruction(932);

        /// <summary>
        /// Represents the VMOVDQA32 instruction.
        /// </summary>
        public static readonly Instruction VMOVDQA32 = new Instruction(933);

        /// <summary>
        /// Represents the VMOVDQA64 instruction.
        /// </summary>
        public static readonly Instruction VMOVDQA64 = new Instruction(934);

        /// <summary>
        /// Represents the VMOVDQA instruction.
        /// </summary>
        public static readonly Instruction VMOVDQA = new Instruction(935);

        /// <summary>
        /// Represents the VMOVDQU16 instruction.
        /// </summary>
        public static readonly Instruction VMOVDQU16 = new Instruction(936);

        /// <summary>
        /// Represents the VMOVDQU32 instruction.
        /// </summary>
        public static readonly Instruction VMOVDQU32 = new Instruction(937);

        /// <summary>
        /// Represents the VMOVDQU64 instruction.
        /// </summary>
        public static readonly Instruction VMOVDQU64 = new Instruction(938);

        /// <summary>
        /// Represents the VMOVDQU8 instruction.
        /// </summary>
        public static readonly Instruction VMOVDQU8 = new Instruction(939);

        /// <summary>
        /// Represents the VMOVDQU instruction.
        /// </summary>
        public static readonly Instruction VMOVDQU = new Instruction(940);

        /// <summary>
        /// Represents the VMOVHLPS instruction.
        /// </summary>
        public static readonly Instruction VMOVHLPS = new Instruction(941);

        /// <summary>
        /// Represents the VMOVHPD instruction.
        /// </summary>
        public static readonly Instruction VMOVHPD = new Instruction(942);

        /// <summary>
        /// Represents the VMOVHPS instruction.
        /// </summary>
        public static readonly Instruction VMOVHPS = new Instruction(943);

        /// <summary>
        /// Represents the VMOVLHPS instruction.
        /// </summary>
        public static readonly Instruction VMOVLHPS = new Instruction(944);

        /// <summary>
        /// Represents the VMOVLPD instruction.
        /// </summary>
        public static readonly Instruction VMOVLPD = new Instruction(945);

        /// <summary>
        /// Represents the VMOVLPS instruction.
        /// </summary>
        public static readonly Instruction VMOVLPS = new Instruction(946);

        /// <summary>
        /// Represents the VMOVMSKPD instruction.
        /// </summary>
        public static readonly Instruction VMOVMSKPD = new Instruction(947);

        /// <summary>
        /// Represents the VMOVMSKPS instruction.
        /// </summary>
        public static readonly Instruction VMOVMSKPS = new Instruction(948);

        /// <summary>
        /// Represents the VMOVNTDQA instruction.
        /// </summary>
        public static readonly Instruction VMOVNTDQA = new Instruction(949);

        /// <summary>
        /// Represents the VMOVNTDQ instruction.
        /// </summary>
        public static readonly Instruction VMOVNTDQ = new Instruction(950);

        /// <summary>
        /// Represents the VMOVNTPD instruction.
        /// </summary>
        public static readonly Instruction VMOVNTPD = new Instruction(951);

        /// <summary>
        /// Represents the VMOVNTPS instruction.
        /// </summary>
        public static readonly Instruction VMOVNTPS = new Instruction(952);

        /// <summary>
        /// Represents the VMOVSD instruction.
        /// </summary>
        public static readonly Instruction VMOVSD = new Instruction(953);

        /// <summary>
        /// Represents the VMOVSHDUP instruction.
        /// </summary>
        public static readonly Instruction VMOVSHDUP = new Instruction(954);

        /// <summary>
        /// Represents the VMOVSLDUP instruction.
        /// </summary>
        public static readonly Instruction VMOVSLDUP = new Instruction(955);

        /// <summary>
        /// Represents the VMOVSS instruction.
        /// </summary>
        public static readonly Instruction VMOVSS = new Instruction(956);

        /// <summary>
        /// Represents the VMOVUPD instruction.
        /// </summary>
        public static readonly Instruction VMOVUPD = new Instruction(957);

        /// <summary>
        /// Represents the VMOVUPS instruction.
        /// </summary>
        public static readonly Instruction VMOVUPS = new Instruction(958);

        /// <summary>
        /// Represents the VMPSADBW instruction.
        /// </summary>
        public static readonly Instruction VMPSADBW = new Instruction(959);

        /// <summary>
        /// Represents the VMPTRLD instruction.
        /// </summary>
        public static readonly Instruction VMPTRLD = new Instruction(960);

        /// <summary>
        /// Represents the VMPTRST instruction.
        /// </summary>
        public static readonly Instruction VMPTRST = new Instruction(961);

        /// <summary>
        /// Represents the VMREAD instruction.
        /// </summary>
        public static readonly Instruction VMREAD = new Instruction(962);

        /// <summary>
        /// Represents the VMRESUME instruction.
        /// </summary>
        public static readonly Instruction VMRESUME = new Instruction(963);

        /// <summary>
        /// Represents the VMRUN instruction.
        /// </summary>
        public static readonly Instruction VMRUN = new Instruction(964);

        /// <summary>
        /// Represents the VMSAVE instruction.
        /// </summary>
        public static readonly Instruction VMSAVE = new Instruction(965);

        /// <summary>
        /// Represents the VMULPD instruction.
        /// </summary>
        public static readonly Instruction VMULPD = new Instruction(966);

        /// <summary>
        /// Represents the VMULPS instruction.
        /// </summary>
        public static readonly Instruction VMULPS = new Instruction(967);

        /// <summary>
        /// Represents the VMULSD instruction.
        /// </summary>
        public static readonly Instruction VMULSD = new Instruction(968);

        /// <summary>
        /// Represents the VMULSS instruction.
        /// </summary>
        public static readonly Instruction VMULSS = new Instruction(969);

        /// <summary>
        /// Represents the VMWRITE instruction.
        /// </summary>
        public static readonly Instruction VMWRITE = new Instruction(970);

        /// <summary>
        /// Represents the VMXOFF instruction.
        /// </summary>
        public static readonly Instruction VMXOFF = new Instruction(971);

        /// <summary>
        /// Represents the VMXON instruction.
        /// </summary>
        public static readonly Instruction VMXON = new Instruction(972);

        /// <summary>
        /// Represents the VPABSB instruction.
        /// </summary>
        public static readonly Instruction VPABSB = new Instruction(973);

        /// <summary>
        /// Represents the VPABSD instruction.
        /// </summary>
        public static readonly Instruction VPABSD = new Instruction(974);

        /// <summary>
        /// Represents the VPABSQ instruction.
        /// </summary>
        public static readonly Instruction VPABSQ = new Instruction(975);

        /// <summary>
        /// Represents the VPABSW instruction.
        /// </summary>
        public static readonly Instruction VPABSW = new Instruction(976);

        /// <summary>
        /// Represents the VPACKSSDW instruction.
        /// </summary>
        public static readonly Instruction VPACKSSDW = new Instruction(977);

        /// <summary>
        /// Represents the VPACKSSWB instruction.
        /// </summary>
        public static readonly Instruction VPACKSSWB = new Instruction(978);

        /// <summary>
        /// Represents the VPACKUSDW instruction.
        /// </summary>
        public static readonly Instruction VPACKUSDW = new Instruction(979);

        /// <summary>
        /// Represents the VPACKUSWB instruction.
        /// </summary>
        public static readonly Instruction VPACKUSWB = new Instruction(980);

        /// <summary>
        /// Represents the VPADDB instruction.
        /// </summary>
        public static readonly Instruction VPADDB = new Instruction(981);

        /// <summary>
        /// Represents the VPADDD instruction.
        /// </summary>
        public static readonly Instruction VPADDD = new Instruction(982);

        /// <summary>
        /// Represents the VPADDQ instruction.
        /// </summary>
        public static readonly Instruction VPADDQ = new Instruction(983);

        /// <summary>
        /// Represents the VPADDSB instruction.
        /// </summary>
        public static readonly Instruction VPADDSB = new Instruction(984);

        /// <summary>
        /// Represents the VPADDSW instruction.
        /// </summary>
        public static readonly Instruction VPADDSW = new Instruction(985);

        /// <summary>
        /// Represents the VPADDUSB instruction.
        /// </summary>
        public static readonly Instruction VPADDUSB = new Instruction(986);

        /// <summary>
        /// Represents the VPADDUSW instruction.
        /// </summary>
        public static readonly Instruction VPADDUSW = new Instruction(987);

        /// <summary>
        /// Represents the VPADDW instruction.
        /// </summary>
        public static readonly Instruction VPADDW = new Instruction(988);

        /// <summary>
        /// Represents the VPALIGNR instruction.
        /// </summary>
        public static readonly Instruction VPALIGNR = new Instruction(989);

        /// <summary>
        /// Represents the VPANDD instruction.
        /// </summary>
        public static readonly Instruction VPANDD = new Instruction(990);

        /// <summary>
        /// Represents the VPANDND instruction.
        /// </summary>
        public static readonly Instruction VPANDND = new Instruction(991);

        /// <summary>
        /// Represents the VPANDNQ instruction.
        /// </summary>
        public static readonly Instruction VPANDNQ = new Instruction(992);

        /// <summary>
        /// Represents the VPANDN instruction.
        /// </summary>
        public static readonly Instruction VPANDN = new Instruction(993);

        /// <summary>
        /// Represents the VPANDQ instruction.
        /// </summary>
        public static readonly Instruction VPANDQ = new Instruction(994);

        /// <summary>
        /// Represents the VPAND instruction.
        /// </summary>
        public static readonly Instruction VPAND = new Instruction(995);

        /// <summary>
        /// Represents the VPAVGB instruction.
        /// </summary>
        public static readonly Instruction VPAVGB = new Instruction(996);

        /// <summary>
        /// Represents the VPAVGW instruction.
        /// </summary>
        public static readonly Instruction VPAVGW = new Instruction(997);

        /// <summary>
        /// Represents the VPBLENDD instruction.
        /// </summary>
        public static readonly Instruction VPBLENDD = new Instruction(998);

        /// <summary>
        /// Represents the VPBLENDMB instruction.
        /// </summary>
        public static readonly Instruction VPBLENDMB = new Instruction(999);

        /// <summary>
        /// Represents the VPBLENDMD instruction.
        /// </summary>
        public static readonly Instruction VPBLENDMD = new Instruction(1000);

        /// <summary>
        /// Represents the VPBLENDMQ instruction.
        /// </summary>
        public static readonly Instruction VPBLENDMQ = new Instruction(1001);

        /// <summary>
        /// Represents the VPBLENDMW instruction.
        /// </summary>
        public static readonly Instruction VPBLENDMW = new Instruction(1002);

        /// <summary>
        /// Represents the VPBLENDVB instruction.
        /// </summary>
        public static readonly Instruction VPBLENDVB = new Instruction(1003);

        /// <summary>
        /// Represents the VPBLENDW instruction.
        /// </summary>
        public static readonly Instruction VPBLENDW = new Instruction(1004);

        /// <summary>
        /// Represents the VPBROADCASTB instruction.
        /// </summary>
        public static readonly Instruction VPBROADCASTB = new Instruction(1005);

        /// <summary>
        /// Represents the VPBROADCASTD instruction.
        /// </summary>
        public static readonly Instruction VPBROADCASTD = new Instruction(1006);

        /// <summary>
        /// Represents the VPBROADCASTMB2Q instruction.
        /// </summary>
        public static readonly Instruction VPBROADCASTMB2Q = new Instruction(1007);

        /// <summary>
        /// Represents the VPBROADCASTMW2D instruction.
        /// </summary>
        public static readonly Instruction VPBROADCASTMW2D = new Instruction(1008);

        /// <summary>
        /// Represents the VPBROADCASTQ instruction.
        /// </summary>
        public static readonly Instruction VPBROADCASTQ = new Instruction(1009);

        /// <summary>
        /// Represents the VPBROADCASTW instruction.
        /// </summary>
        public static readonly Instruction VPBROADCASTW = new Instruction(1010);

        /// <summary>
        /// Represents the VPCLMULQDQ instruction.
        /// </summary>
        public static readonly Instruction VPCLMULQDQ = new Instruction(1011);

        /// <summary>
        /// Represents the VPCMOV instruction.
        /// </summary>
        public static readonly Instruction VPCMOV = new Instruction(1012);

        /// <summary>
        /// Represents the VPCMPB instruction.
        /// </summary>
        public static readonly Instruction VPCMPB = new Instruction(1013);

        /// <summary>
        /// Represents the VPCMPD instruction.
        /// </summary>
        public static readonly Instruction VPCMPD = new Instruction(1014);

        /// <summary>
        /// Represents the VPCMPEQB instruction.
        /// </summary>
        public static readonly Instruction VPCMPEQB = new Instruction(1015);

        /// <summary>
        /// Represents the VPCMPEQD instruction.
        /// </summary>
        public static readonly Instruction VPCMPEQD = new Instruction(1016);

        /// <summary>
        /// Represents the VPCMPEQQ instruction.
        /// </summary>
        public static readonly Instruction VPCMPEQQ = new Instruction(1017);

        /// <summary>
        /// Represents the VPCMPEQW instruction.
        /// </summary>
        public static readonly Instruction VPCMPEQW = new Instruction(1018);

        /// <summary>
        /// Represents the VPCMPESTRI instruction.
        /// </summary>
        public static readonly Instruction VPCMPESTRI = new Instruction(1019);

        /// <summary>
        /// Represents the VPCMPESTRM instruction.
        /// </summary>
        public static readonly Instruction VPCMPESTRM = new Instruction(1020);

        /// <summary>
        /// Represents the VPCMPGTB instruction.
        /// </summary>
        public static readonly Instruction VPCMPGTB = new Instruction(1021);

        /// <summary>
        /// Represents the VPCMPGTD instruction.
        /// </summary>
        public static readonly Instruction VPCMPGTD = new Instruction(1022);

        /// <summary>
        /// Represents the VPCMPGTQ instruction.
        /// </summary>
        public static readonly Instruction VPCMPGTQ = new Instruction(1023);

        /// <summary>
        /// Represents the VPCMPGTW instruction.
        /// </summary>
        public static readonly Instruction VPCMPGTW = new Instruction(1024);

        /// <summary>
        /// Represents the VPCMPISTRI instruction.
        /// </summary>
        public static readonly Instruction VPCMPISTRI = new Instruction(1025);

        /// <summary>
        /// Represents the VPCMPISTRM instruction.
        /// </summary>
        public static readonly Instruction VPCMPISTRM = new Instruction(1026);

        /// <summary>
        /// Represents the VPCMPQ instruction.
        /// </summary>
        public static readonly Instruction VPCMPQ = new Instruction(1027);

        /// <summary>
        /// Represents the VPCMPUB instruction.
        /// </summary>
        public static readonly Instruction VPCMPUB = new Instruction(1028);

        /// <summary>
        /// Represents the VPCMPUD instruction.
        /// </summary>
        public static readonly Instruction VPCMPUD = new Instruction(1029);

        /// <summary>
        /// Represents the VPCMPUQ instruction.
        /// </summary>
        public static readonly Instruction VPCMPUQ = new Instruction(1030);

        /// <summary>
        /// Represents the VPCMPUW instruction.
        /// </summary>
        public static readonly Instruction VPCMPUW = new Instruction(1031);

        /// <summary>
        /// Represents the VPCMPW instruction.
        /// </summary>
        public static readonly Instruction VPCMPW = new Instruction(1032);

        /// <summary>
        /// Represents the VPCOMB instruction.
        /// </summary>
        public static readonly Instruction VPCOMB = new Instruction(1033);

        /// <summary>
        /// Represents the VPCOMD instruction.
        /// </summary>
        public static readonly Instruction VPCOMD = new Instruction(1034);

        /// <summary>
        /// Represents the VPCOMPRESSD instruction.
        /// </summary>
        public static readonly Instruction VPCOMPRESSD = new Instruction(1035);

        /// <summary>
        /// Represents the VPCOMPRESSQ instruction.
        /// </summary>
        public static readonly Instruction VPCOMPRESSQ = new Instruction(1036);

        /// <summary>
        /// Represents the VPCOMQ instruction.
        /// </summary>
        public static readonly Instruction VPCOMQ = new Instruction(1037);

        /// <summary>
        /// Represents the VPCOMUB instruction.
        /// </summary>
        public static readonly Instruction VPCOMUB = new Instruction(1038);

        /// <summary>
        /// Represents the VPCOMUD instruction.
        /// </summary>
        public static readonly Instruction VPCOMUD = new Instruction(1039);

        /// <summary>
        /// Represents the VPCOMUQ instruction.
        /// </summary>
        public static readonly Instruction VPCOMUQ = new Instruction(1040);

        /// <summary>
        /// Represents the VPCOMUW instruction.
        /// </summary>
        public static readonly Instruction VPCOMUW = new Instruction(1041);

        /// <summary>
        /// Represents the VPCOMW instruction.
        /// </summary>
        public static readonly Instruction VPCOMW = new Instruction(1042);

        /// <summary>
        /// Represents the VPCONFLICTD instruction.
        /// </summary>
        public static readonly Instruction VPCONFLICTD = new Instruction(1043);

        /// <summary>
        /// Represents the VPCONFLICTQ instruction.
        /// </summary>
        public static readonly Instruction VPCONFLICTQ = new Instruction(1044);

        /// <summary>
        /// Represents the VPERM2F128 instruction.
        /// </summary>
        public static readonly Instruction VPERM2F128 = new Instruction(1045);

        /// <summary>
        /// Represents the VPERM2I128 instruction.
        /// </summary>
        public static readonly Instruction VPERM2I128 = new Instruction(1046);

        /// <summary>
        /// Represents the VPERMD instruction.
        /// </summary>
        public static readonly Instruction VPERMD = new Instruction(1047);

        /// <summary>
        /// Represents the VPERMI2D instruction.
        /// </summary>
        public static readonly Instruction VPERMI2D = new Instruction(1048);

        /// <summary>
        /// Represents the VPERMI2PD instruction.
        /// </summary>
        public static readonly Instruction VPERMI2PD = new Instruction(1049);

        /// <summary>
        /// Represents the VPERMI2PS instruction.
        /// </summary>
        public static readonly Instruction VPERMI2PS = new Instruction(1050);

        /// <summary>
        /// Represents the VPERMI2Q instruction.
        /// </summary>
        public static readonly Instruction VPERMI2Q = new Instruction(1051);

        /// <summary>
        /// Represents the VPERMIL2PD instruction.
        /// </summary>
        public static readonly Instruction VPERMIL2PD = new Instruction(1052);

        /// <summary>
        /// Represents the VPERMIL2PS instruction.
        /// </summary>
        public static readonly Instruction VPERMIL2PS = new Instruction(1053);

        /// <summary>
        /// Represents the VPERMILPD instruction.
        /// </summary>
        public static readonly Instruction VPERMILPD = new Instruction(1054);

        /// <summary>
        /// Represents the VPERMILPS instruction.
        /// </summary>
        public static readonly Instruction VPERMILPS = new Instruction(1055);

        /// <summary>
        /// Represents the VPERMPD instruction.
        /// </summary>
        public static readonly Instruction VPERMPD = new Instruction(1056);

        /// <summary>
        /// Represents the VPERMPS instruction.
        /// </summary>
        public static readonly Instruction VPERMPS = new Instruction(1057);

        /// <summary>
        /// Represents the VPERMQ instruction.
        /// </summary>
        public static readonly Instruction VPERMQ = new Instruction(1058);

        /// <summary>
        /// Represents the VPERMT2D instruction.
        /// </summary>
        public static readonly Instruction VPERMT2D = new Instruction(1059);

        /// <summary>
        /// Represents the VPERMT2PD instruction.
        /// </summary>
        public static readonly Instruction VPERMT2PD = new Instruction(1060);

        /// <summary>
        /// Represents the VPERMT2PS instruction.
        /// </summary>
        public static readonly Instruction VPERMT2PS = new Instruction(1061);

        /// <summary>
        /// Represents the VPERMT2Q instruction.
        /// </summary>
        public static readonly Instruction VPERMT2Q = new Instruction(1062);

        /// <summary>
        /// Represents the VPEXPANDD instruction.
        /// </summary>
        public static readonly Instruction VPEXPANDD = new Instruction(1063);

        /// <summary>
        /// Represents the VPEXPANDQ instruction.
        /// </summary>
        public static readonly Instruction VPEXPANDQ = new Instruction(1064);

        /// <summary>
        /// Represents the VPEXTRB instruction.
        /// </summary>
        public static readonly Instruction VPEXTRB = new Instruction(1065);

        /// <summary>
        /// Represents the VPEXTRD instruction.
        /// </summary>
        public static readonly Instruction VPEXTRD = new Instruction(1066);

        /// <summary>
        /// Represents the VPEXTRQ instruction.
        /// </summary>
        public static readonly Instruction VPEXTRQ = new Instruction(1067);

        /// <summary>
        /// Represents the VPEXTRW instruction.
        /// </summary>
        public static readonly Instruction VPEXTRW = new Instruction(1068);

        /// <summary>
        /// Represents the VPGATHERDD instruction.
        /// </summary>
        public static readonly Instruction VPGATHERDD = new Instruction(1069);

        /// <summary>
        /// Represents the VPGATHERDQ instruction.
        /// </summary>
        public static readonly Instruction VPGATHERDQ = new Instruction(1070);

        /// <summary>
        /// Represents the VPGATHERQD instruction.
        /// </summary>
        public static readonly Instruction VPGATHERQD = new Instruction(1071);

        /// <summary>
        /// Represents the VPGATHERQQ instruction.
        /// </summary>
        public static readonly Instruction VPGATHERQQ = new Instruction(1072);

        /// <summary>
        /// Represents the VPHADDBD instruction.
        /// </summary>
        public static readonly Instruction VPHADDBD = new Instruction(1073);

        /// <summary>
        /// Represents the VPHADDBQ instruction.
        /// </summary>
        public static readonly Instruction VPHADDBQ = new Instruction(1074);

        /// <summary>
        /// Represents the VPHADDBW instruction.
        /// </summary>
        public static readonly Instruction VPHADDBW = new Instruction(1075);

        /// <summary>
        /// Represents the VPHADDDQ instruction.
        /// </summary>
        public static readonly Instruction VPHADDDQ = new Instruction(1076);

        /// <summary>
        /// Represents the VPHADDD instruction.
        /// </summary>
        public static readonly Instruction VPHADDD = new Instruction(1077);

        /// <summary>
        /// Represents the VPHADDSW instruction.
        /// </summary>
        public static readonly Instruction VPHADDSW = new Instruction(1078);

        /// <summary>
        /// Represents the VPHADDUBD instruction.
        /// </summary>
        public static readonly Instruction VPHADDUBD = new Instruction(1079);

        /// <summary>
        /// Represents the VPHADDUBQ instruction.
        /// </summary>
        public static readonly Instruction VPHADDUBQ = new Instruction(1080);

        /// <summary>
        /// Represents the VPHADDUBW instruction.
        /// </summary>
        public static readonly Instruction VPHADDUBW = new Instruction(1081);

        /// <summary>
        /// Represents the VPHADDUDQ instruction.
        /// </summary>
        public static readonly Instruction VPHADDUDQ = new Instruction(1082);

        /// <summary>
        /// Represents the VPHADDUWD instruction.
        /// </summary>
        public static readonly Instruction VPHADDUWD = new Instruction(1083);

        /// <summary>
        /// Represents the VPHADDUWQ instruction.
        /// </summary>
        public static readonly Instruction VPHADDUWQ = new Instruction(1084);

        /// <summary>
        /// Represents the VPHADDWD instruction.
        /// </summary>
        public static readonly Instruction VPHADDWD = new Instruction(1085);

        /// <summary>
        /// Represents the VPHADDWQ instruction.
        /// </summary>
        public static readonly Instruction VPHADDWQ = new Instruction(1086);

        /// <summary>
        /// Represents the VPHADDW instruction.
        /// </summary>
        public static readonly Instruction VPHADDW = new Instruction(1087);

        /// <summary>
        /// Represents the VPHMINPOSUW instruction.
        /// </summary>
        public static readonly Instruction VPHMINPOSUW = new Instruction(1088);

        /// <summary>
        /// Represents the VPHSUBBW instruction.
        /// </summary>
        public static readonly Instruction VPHSUBBW = new Instruction(1089);

        /// <summary>
        /// Represents the VPHSUBDQ instruction.
        /// </summary>
        public static readonly Instruction VPHSUBDQ = new Instruction(1090);

        /// <summary>
        /// Represents the VPHSUBD instruction.
        /// </summary>
        public static readonly Instruction VPHSUBD = new Instruction(1091);

        /// <summary>
        /// Represents the VPHSUBSW instruction.
        /// </summary>
        public static readonly Instruction VPHSUBSW = new Instruction(1092);

        /// <summary>
        /// Represents the VPHSUBWD instruction.
        /// </summary>
        public static readonly Instruction VPHSUBWD = new Instruction(1093);

        /// <summary>
        /// Represents the VPHSUBW instruction.
        /// </summary>
        public static readonly Instruction VPHSUBW = new Instruction(1094);

        /// <summary>
        /// Represents the VPINSRB instruction.
        /// </summary>
        public static readonly Instruction VPINSRB = new Instruction(1095);

        /// <summary>
        /// Represents the VPINSRD instruction.
        /// </summary>
        public static readonly Instruction VPINSRD = new Instruction(1096);

        /// <summary>
        /// Represents the VPINSRQ instruction.
        /// </summary>
        public static readonly Instruction VPINSRQ = new Instruction(1097);

        /// <summary>
        /// Represents the VPINSRW instruction.
        /// </summary>
        public static readonly Instruction VPINSRW = new Instruction(1098);

        /// <summary>
        /// Represents the VPLZCNTD instruction.
        /// </summary>
        public static readonly Instruction VPLZCNTD = new Instruction(1099);

        /// <summary>
        /// Represents the VPLZCNTQ instruction.
        /// </summary>
        public static readonly Instruction VPLZCNTQ = new Instruction(1100);

        /// <summary>
        /// Represents the VPMACSDD instruction.
        /// </summary>
        public static readonly Instruction VPMACSDD = new Instruction(1101);

        /// <summary>
        /// Represents the VPMACSDQH instruction.
        /// </summary>
        public static readonly Instruction VPMACSDQH = new Instruction(1102);

        /// <summary>
        /// Represents the VPMACSDQL instruction.
        /// </summary>
        public static readonly Instruction VPMACSDQL = new Instruction(1103);

        /// <summary>
        /// Represents the VPMACSSDD instruction.
        /// </summary>
        public static readonly Instruction VPMACSSDD = new Instruction(1104);

        /// <summary>
        /// Represents the VPMACSSDQH instruction.
        /// </summary>
        public static readonly Instruction VPMACSSDQH = new Instruction(1105);

        /// <summary>
        /// Represents the VPMACSSDQL instruction.
        /// </summary>
        public static readonly Instruction VPMACSSDQL = new Instruction(1106);

        /// <summary>
        /// Represents the VPMACSSWD instruction.
        /// </summary>
        public static readonly Instruction VPMACSSWD = new Instruction(1107);

        /// <summary>
        /// Represents the VPMACSSWW instruction.
        /// </summary>
        public static readonly Instruction VPMACSSWW = new Instruction(1108);

        /// <summary>
        /// Represents the VPMACSWD instruction.
        /// </summary>
        public static readonly Instruction VPMACSWD = new Instruction(1109);

        /// <summary>
        /// Represents the VPMACSWW instruction.
        /// </summary>
        public static readonly Instruction VPMACSWW = new Instruction(1110);

        /// <summary>
        /// Represents the VPMADCSSWD instruction.
        /// </summary>
        public static readonly Instruction VPMADCSSWD = new Instruction(1111);

        /// <summary>
        /// Represents the VPMADCSWD instruction.
        /// </summary>
        public static readonly Instruction VPMADCSWD = new Instruction(1112);

        /// <summary>
        /// Represents the VPMADDUBSW instruction.
        /// </summary>
        public static readonly Instruction VPMADDUBSW = new Instruction(1113);

        /// <summary>
        /// Represents the VPMADDWD instruction.
        /// </summary>
        public static readonly Instruction VPMADDWD = new Instruction(1114);

        /// <summary>
        /// Represents the VPMASKMOVD instruction.
        /// </summary>
        public static readonly Instruction VPMASKMOVD = new Instruction(1115);

        /// <summary>
        /// Represents the VPMASKMOVQ instruction.
        /// </summary>
        public static readonly Instruction VPMASKMOVQ = new Instruction(1116);

        /// <summary>
        /// Represents the VPMAXSB instruction.
        /// </summary>
        public static readonly Instruction VPMAXSB = new Instruction(1117);

        /// <summary>
        /// Represents the VPMAXSD instruction.
        /// </summary>
        public static readonly Instruction VPMAXSD = new Instruction(1118);

        /// <summary>
        /// Represents the VPMAXSQ instruction.
        /// </summary>
        public static readonly Instruction VPMAXSQ = new Instruction(1119);

        /// <summary>
        /// Represents the VPMAXSW instruction.
        /// </summary>
        public static readonly Instruction VPMAXSW = new Instruction(1120);

        /// <summary>
        /// Represents the VPMAXUB instruction.
        /// </summary>
        public static readonly Instruction VPMAXUB = new Instruction(1121);

        /// <summary>
        /// Represents the VPMAXUD instruction.
        /// </summary>
        public static readonly Instruction VPMAXUD = new Instruction(1122);

        /// <summary>
        /// Represents the VPMAXUQ instruction.
        /// </summary>
        public static readonly Instruction VPMAXUQ = new Instruction(1123);

        /// <summary>
        /// Represents the VPMAXUW instruction.
        /// </summary>
        public static readonly Instruction VPMAXUW = new Instruction(1124);

        /// <summary>
        /// Represents the VPMINSB instruction.
        /// </summary>
        public static readonly Instruction VPMINSB = new Instruction(1125);

        /// <summary>
        /// Represents the VPMINSD instruction.
        /// </summary>
        public static readonly Instruction VPMINSD = new Instruction(1126);

        /// <summary>
        /// Represents the VPMINSQ instruction.
        /// </summary>
        public static readonly Instruction VPMINSQ = new Instruction(1127);

        /// <summary>
        /// Represents the VPMINSW instruction.
        /// </summary>
        public static readonly Instruction VPMINSW = new Instruction(1128);

        /// <summary>
        /// Represents the VPMINUB instruction.
        /// </summary>
        public static readonly Instruction VPMINUB = new Instruction(1129);

        /// <summary>
        /// Represents the VPMINUD instruction.
        /// </summary>
        public static readonly Instruction VPMINUD = new Instruction(1130);

        /// <summary>
        /// Represents the VPMINUQ instruction.
        /// </summary>
        public static readonly Instruction VPMINUQ = new Instruction(1131);

        /// <summary>
        /// Represents the VPMINUW instruction.
        /// </summary>
        public static readonly Instruction VPMINUW = new Instruction(1132);

        /// <summary>
        /// Represents the VPMOVDB instruction.
        /// </summary>
        public static readonly Instruction VPMOVDB = new Instruction(1133);

        /// <summary>
        /// Represents the VPMOVDW instruction.
        /// </summary>
        public static readonly Instruction VPMOVDW = new Instruction(1134);

        /// <summary>
        /// Represents the VPMOVM2B instruction.
        /// </summary>
        public static readonly Instruction VPMOVM2B = new Instruction(1135);

        /// <summary>
        /// Represents the VPMOVM2D instruction.
        /// </summary>
        public static readonly Instruction VPMOVM2D = new Instruction(1136);

        /// <summary>
        /// Represents the VPMOVM2Q instruction.
        /// </summary>
        public static readonly Instruction VPMOVM2Q = new Instruction(1137);

        /// <summary>
        /// Represents the VPMOVM2W instruction.
        /// </summary>
        public static readonly Instruction VPMOVM2W = new Instruction(1138);

        /// <summary>
        /// Represents the VPMOVMSKB instruction.
        /// </summary>
        public static readonly Instruction VPMOVMSKB = new Instruction(1139);

        /// <summary>
        /// Represents the VPMOVQB instruction.
        /// </summary>
        public static readonly Instruction VPMOVQB = new Instruction(1140);

        /// <summary>
        /// Represents the VPMOVQD instruction.
        /// </summary>
        public static readonly Instruction VPMOVQD = new Instruction(1141);

        /// <summary>
        /// Represents the VPMOVQW instruction.
        /// </summary>
        public static readonly Instruction VPMOVQW = new Instruction(1142);

        /// <summary>
        /// Represents the VPMOVSDB instruction.
        /// </summary>
        public static readonly Instruction VPMOVSDB = new Instruction(1143);

        /// <summary>
        /// Represents the VPMOVSDW instruction.
        /// </summary>
        public static readonly Instruction VPMOVSDW = new Instruction(1144);

        /// <summary>
        /// Represents the VPMOVSQB instruction.
        /// </summary>
        public static readonly Instruction VPMOVSQB = new Instruction(1145);

        /// <summary>
        /// Represents the VPMOVSQD instruction.
        /// </summary>
        public static readonly Instruction VPMOVSQD = new Instruction(1146);

        /// <summary>
        /// Represents the VPMOVSQW instruction.
        /// </summary>
        public static readonly Instruction VPMOVSQW = new Instruction(1147);

        /// <summary>
        /// Represents the VPMOVSXBD instruction.
        /// </summary>
        public static readonly Instruction VPMOVSXBD = new Instruction(1148);

        /// <summary>
        /// Represents the VPMOVSXBQ instruction.
        /// </summary>
        public static readonly Instruction VPMOVSXBQ = new Instruction(1149);

        /// <summary>
        /// Represents the VPMOVSXBW instruction.
        /// </summary>
        public static readonly Instruction VPMOVSXBW = new Instruction(1150);

        /// <summary>
        /// Represents the VPMOVSXDQ instruction.
        /// </summary>
        public static readonly Instruction VPMOVSXDQ = new Instruction(1151);

        /// <summary>
        /// Represents the VPMOVSXWD instruction.
        /// </summary>
        public static readonly Instruction VPMOVSXWD = new Instruction(1152);

        /// <summary>
        /// Represents the VPMOVSXWQ instruction.
        /// </summary>
        public static readonly Instruction VPMOVSXWQ = new Instruction(1153);

        /// <summary>
        /// Represents the VPMOVUSDB instruction.
        /// </summary>
        public static readonly Instruction VPMOVUSDB = new Instruction(1154);

        /// <summary>
        /// Represents the VPMOVUSDW instruction.
        /// </summary>
        public static readonly Instruction VPMOVUSDW = new Instruction(1155);

        /// <summary>
        /// Represents the VPMOVUSQB instruction.
        /// </summary>
        public static readonly Instruction VPMOVUSQB = new Instruction(1156);

        /// <summary>
        /// Represents the VPMOVUSQD instruction.
        /// </summary>
        public static readonly Instruction VPMOVUSQD = new Instruction(1157);

        /// <summary>
        /// Represents the VPMOVUSQW instruction.
        /// </summary>
        public static readonly Instruction VPMOVUSQW = new Instruction(1158);

        /// <summary>
        /// Represents the VPMOVZXBD instruction.
        /// </summary>
        public static readonly Instruction VPMOVZXBD = new Instruction(1159);

        /// <summary>
        /// Represents the VPMOVZXBQ instruction.
        /// </summary>
        public static readonly Instruction VPMOVZXBQ = new Instruction(1160);

        /// <summary>
        /// Represents the VPMOVZXBW instruction.
        /// </summary>
        public static readonly Instruction VPMOVZXBW = new Instruction(1161);

        /// <summary>
        /// Represents the VPMOVZXDQ instruction.
        /// </summary>
        public static readonly Instruction VPMOVZXDQ = new Instruction(1162);

        /// <summary>
        /// Represents the VPMOVZXWD instruction.
        /// </summary>
        public static readonly Instruction VPMOVZXWD = new Instruction(1163);

        /// <summary>
        /// Represents the VPMOVZXWQ instruction.
        /// </summary>
        public static readonly Instruction VPMOVZXWQ = new Instruction(1164);

        /// <summary>
        /// Represents the VPMULDQ instruction.
        /// </summary>
        public static readonly Instruction VPMULDQ = new Instruction(1165);

        /// <summary>
        /// Represents the VPMULHRSW instruction.
        /// </summary>
        public static readonly Instruction VPMULHRSW = new Instruction(1166);

        /// <summary>
        /// Represents the VPMULHUW instruction.
        /// </summary>
        public static readonly Instruction VPMULHUW = new Instruction(1167);

        /// <summary>
        /// Represents the VPMULHW instruction.
        /// </summary>
        public static readonly Instruction VPMULHW = new Instruction(1168);

        /// <summary>
        /// Represents the VPMULLD instruction.
        /// </summary>
        public static readonly Instruction VPMULLD = new Instruction(1169);

        /// <summary>
        /// Represents the VPMULLQ instruction.
        /// </summary>
        public static readonly Instruction VPMULLQ = new Instruction(1170);

        /// <summary>
        /// Represents the VPMULLW instruction.
        /// </summary>
        public static readonly Instruction VPMULLW = new Instruction(1171);

        /// <summary>
        /// Represents the VPMULUDQ instruction.
        /// </summary>
        public static readonly Instruction VPMULUDQ = new Instruction(1172);

        /// <summary>
        /// Represents the VPORD instruction.
        /// </summary>
        public static readonly Instruction VPORD = new Instruction(1173);

        /// <summary>
        /// Represents the VPORQ instruction.
        /// </summary>
        public static readonly Instruction VPORQ = new Instruction(1174);

        /// <summary>
        /// Represents the VPOR instruction.
        /// </summary>
        public static readonly Instruction VPOR = new Instruction(1175);

        /// <summary>
        /// Represents the VPPERM instruction.
        /// </summary>
        public static readonly Instruction VPPERM = new Instruction(1176);

        /// <summary>
        /// Represents the VPROTB instruction.
        /// </summary>
        public static readonly Instruction VPROTB = new Instruction(1177);

        /// <summary>
        /// Represents the VPROTD instruction.
        /// </summary>
        public static readonly Instruction VPROTD = new Instruction(1178);

        /// <summary>
        /// Represents the VPROTQ instruction.
        /// </summary>
        public static readonly Instruction VPROTQ = new Instruction(1179);

        /// <summary>
        /// Represents the VPROTW instruction.
        /// </summary>
        public static readonly Instruction VPROTW = new Instruction(1180);

        /// <summary>
        /// Represents the VPSADBW instruction.
        /// </summary>
        public static readonly Instruction VPSADBW = new Instruction(1181);

        /// <summary>
        /// Represents the VPSCATTERDD instruction.
        /// </summary>
        public static readonly Instruction VPSCATTERDD = new Instruction(1182);

        /// <summary>
        /// Represents the VPSCATTERDQ instruction.
        /// </summary>
        public static readonly Instruction VPSCATTERDQ = new Instruction(1183);

        /// <summary>
        /// Represents the VPSCATTERQD instruction.
        /// </summary>
        public static readonly Instruction VPSCATTERQD = new Instruction(1184);

        /// <summary>
        /// Represents the VPSCATTERQQ instruction.
        /// </summary>
        public static readonly Instruction VPSCATTERQQ = new Instruction(1185);

        /// <summary>
        /// Represents the VPSHAB instruction.
        /// </summary>
        public static readonly Instruction VPSHAB = new Instruction(1186);

        /// <summary>
        /// Represents the VPSHAD instruction.
        /// </summary>
        public static readonly Instruction VPSHAD = new Instruction(1187);

        /// <summary>
        /// Represents the VPSHAQ instruction.
        /// </summary>
        public static readonly Instruction VPSHAQ = new Instruction(1188);

        /// <summary>
        /// Represents the VPSHAW instruction.
        /// </summary>
        public static readonly Instruction VPSHAW = new Instruction(1189);

        /// <summary>
        /// Represents the VPSHLB instruction.
        /// </summary>
        public static readonly Instruction VPSHLB = new Instruction(1190);

        /// <summary>
        /// Represents the VPSHLD instruction.
        /// </summary>
        public static readonly Instruction VPSHLD = new Instruction(1191);

        /// <summary>
        /// Represents the VPSHLQ instruction.
        /// </summary>
        public static readonly Instruction VPSHLQ = new Instruction(1192);

        /// <summary>
        /// Represents the VPSHLW instruction.
        /// </summary>
        public static readonly Instruction VPSHLW = new Instruction(1193);

        /// <summary>
        /// Represents the VPSHUFB instruction.
        /// </summary>
        public static readonly Instruction VPSHUFB = new Instruction(1194);

        /// <summary>
        /// Represents the VPSHUFD instruction.
        /// </summary>
        public static readonly Instruction VPSHUFD = new Instruction(1195);

        /// <summary>
        /// Represents the VPSHUFHW instruction.
        /// </summary>
        public static readonly Instruction VPSHUFHW = new Instruction(1196);

        /// <summary>
        /// Represents the VPSHUFLW instruction.
        /// </summary>
        public static readonly Instruction VPSHUFLW = new Instruction(1197);

        /// <summary>
        /// Represents the VPSIGNB instruction.
        /// </summary>
        public static readonly Instruction VPSIGNB = new Instruction(1198);

        /// <summary>
        /// Represents the VPSIGND instruction.
        /// </summary>
        public static readonly Instruction VPSIGND = new Instruction(1199);

        /// <summary>
        /// Represents the VPSIGNW instruction.
        /// </summary>
        public static readonly Instruction VPSIGNW = new Instruction(1200);

        /// <summary>
        /// Represents the VPSLLDQ instruction.
        /// </summary>
        public static readonly Instruction VPSLLDQ = new Instruction(1201);

        /// <summary>
        /// Represents the VPSLLD instruction.
        /// </summary>
        public static readonly Instruction VPSLLD = new Instruction(1202);

        /// <summary>
        /// Represents the VPSLLQ instruction.
        /// </summary>
        public static readonly Instruction VPSLLQ = new Instruction(1203);

        /// <summary>
        /// Represents the VPSLLVD instruction.
        /// </summary>
        public static readonly Instruction VPSLLVD = new Instruction(1204);

        /// <summary>
        /// Represents the VPSLLVQ instruction.
        /// </summary>
        public static readonly Instruction VPSLLVQ = new Instruction(1205);

        /// <summary>
        /// Represents the VPSLLW instruction.
        /// </summary>
        public static readonly Instruction VPSLLW = new Instruction(1206);

        /// <summary>
        /// Represents the VPSRAD instruction.
        /// </summary>
        public static readonly Instruction VPSRAD = new Instruction(1207);

        /// <summary>
        /// Represents the VPSRAQ instruction.
        /// </summary>
        public static readonly Instruction VPSRAQ = new Instruction(1208);

        /// <summary>
        /// Represents the VPSRAVD instruction.
        /// </summary>
        public static readonly Instruction VPSRAVD = new Instruction(1209);

        /// <summary>
        /// Represents the VPSRAVQ instruction.
        /// </summary>
        public static readonly Instruction VPSRAVQ = new Instruction(1210);

        /// <summary>
        /// Represents the VPSRAW instruction.
        /// </summary>
        public static readonly Instruction VPSRAW = new Instruction(1211);

        /// <summary>
        /// Represents the VPSRLDQ instruction.
        /// </summary>
        public static readonly Instruction VPSRLDQ = new Instruction(1212);

        /// <summary>
        /// Represents the VPSRLD instruction.
        /// </summary>
        public static readonly Instruction VPSRLD = new Instruction(1213);

        /// <summary>
        /// Represents the VPSRLQ instruction.
        /// </summary>
        public static readonly Instruction VPSRLQ = new Instruction(1214);

        /// <summary>
        /// Represents the VPSRLVD instruction.
        /// </summary>
        public static readonly Instruction VPSRLVD = new Instruction(1215);

        /// <summary>
        /// Represents the VPSRLVQ instruction.
        /// </summary>
        public static readonly Instruction VPSRLVQ = new Instruction(1216);

        /// <summary>
        /// Represents the VPSRLW instruction.
        /// </summary>
        public static readonly Instruction VPSRLW = new Instruction(1217);

        /// <summary>
        /// Represents the VPSUBB instruction.
        /// </summary>
        public static readonly Instruction VPSUBB = new Instruction(1218);

        /// <summary>
        /// Represents the VPSUBD instruction.
        /// </summary>
        public static readonly Instruction VPSUBD = new Instruction(1219);

        /// <summary>
        /// Represents the VPSUBQ instruction.
        /// </summary>
        public static readonly Instruction VPSUBQ = new Instruction(1220);

        /// <summary>
        /// Represents the VPSUBSB instruction.
        /// </summary>
        public static readonly Instruction VPSUBSB = new Instruction(1221);

        /// <summary>
        /// Represents the VPSUBSW instruction.
        /// </summary>
        public static readonly Instruction VPSUBSW = new Instruction(1222);

        /// <summary>
        /// Represents the VPSUBUSB instruction.
        /// </summary>
        public static readonly Instruction VPSUBUSB = new Instruction(1223);

        /// <summary>
        /// Represents the VPSUBUSW instruction.
        /// </summary>
        public static readonly Instruction VPSUBUSW = new Instruction(1224);

        /// <summary>
        /// Represents the VPSUBW instruction.
        /// </summary>
        public static readonly Instruction VPSUBW = new Instruction(1225);

        /// <summary>
        /// Represents the VPTESTMD instruction.
        /// </summary>
        public static readonly Instruction VPTESTMD = new Instruction(1226);

        /// <summary>
        /// Represents the VPTESTMQ instruction.
        /// </summary>
        public static readonly Instruction VPTESTMQ = new Instruction(1227);

        /// <summary>
        /// Represents the VPTESTNMD instruction.
        /// </summary>
        public static readonly Instruction VPTESTNMD = new Instruction(1228);

        /// <summary>
        /// Represents the VPTESTNMQ instruction.
        /// </summary>
        public static readonly Instruction VPTESTNMQ = new Instruction(1229);

        /// <summary>
        /// Represents the VPTEST instruction.
        /// </summary>
        public static readonly Instruction VPTEST = new Instruction(1230);

        /// <summary>
        /// Represents the VPUNPCKHBW instruction.
        /// </summary>
        public static readonly Instruction VPUNPCKHBW = new Instruction(1231);

        /// <summary>
        /// Represents the VPUNPCKHDQ instruction.
        /// </summary>
        public static readonly Instruction VPUNPCKHDQ = new Instruction(1232);

        /// <summary>
        /// Represents the VPUNPCKHQDQ instruction.
        /// </summary>
        public static readonly Instruction VPUNPCKHQDQ = new Instruction(1233);

        /// <summary>
        /// Represents the VPUNPCKHWD instruction.
        /// </summary>
        public static readonly Instruction VPUNPCKHWD = new Instruction(1234);

        /// <summary>
        /// Represents the VPUNPCKLBW instruction.
        /// </summary>
        public static readonly Instruction VPUNPCKLBW = new Instruction(1235);

        /// <summary>
        /// Represents the VPUNPCKLDQ instruction.
        /// </summary>
        public static readonly Instruction VPUNPCKLDQ = new Instruction(1236);

        /// <summary>
        /// Represents the VPUNPCKLQDQ instruction.
        /// </summary>
        public static readonly Instruction VPUNPCKLQDQ = new Instruction(1237);

        /// <summary>
        /// Represents the VPUNPCKLWD instruction.
        /// </summary>
        public static readonly Instruction VPUNPCKLWD = new Instruction(1238);

        /// <summary>
        /// Represents the VPXORD instruction.
        /// </summary>
        public static readonly Instruction VPXORD = new Instruction(1239);

        /// <summary>
        /// Represents the VPXORQ instruction.
        /// </summary>
        public static readonly Instruction VPXORQ = new Instruction(1240);

        /// <summary>
        /// Represents the VPXOR instruction.
        /// </summary>
        public static readonly Instruction VPXOR = new Instruction(1241);

        /// <summary>
        /// Represents the VRCP14PD instruction.
        /// </summary>
        public static readonly Instruction VRCP14PD = new Instruction(1242);

        /// <summary>
        /// Represents the VRCP14PS instruction.
        /// </summary>
        public static readonly Instruction VRCP14PS = new Instruction(1243);

        /// <summary>
        /// Represents the VRCP14SD instruction.
        /// </summary>
        public static readonly Instruction VRCP14SD = new Instruction(1244);

        /// <summary>
        /// Represents the VRCP14SS instruction.
        /// </summary>
        public static readonly Instruction VRCP14SS = new Instruction(1245);

        /// <summary>
        /// Represents the VRCP28PD instruction.
        /// </summary>
        public static readonly Instruction VRCP28PD = new Instruction(1246);

        /// <summary>
        /// Represents the VRCP28PS instruction.
        /// </summary>
        public static readonly Instruction VRCP28PS = new Instruction(1247);

        /// <summary>
        /// Represents the VRCP28SD instruction.
        /// </summary>
        public static readonly Instruction VRCP28SD = new Instruction(1248);

        /// <summary>
        /// Represents the VRCP28SS instruction.
        /// </summary>
        public static readonly Instruction VRCP28SS = new Instruction(1249);

        /// <summary>
        /// Represents the VRCPPS instruction.
        /// </summary>
        public static readonly Instruction VRCPPS = new Instruction(1250);

        /// <summary>
        /// Represents the VRCPSS instruction.
        /// </summary>
        public static readonly Instruction VRCPSS = new Instruction(1251);

        /// <summary>
        /// Represents the VRNDSCALEPD instruction.
        /// </summary>
        public static readonly Instruction VRNDSCALEPD = new Instruction(1252);

        /// <summary>
        /// Represents the VRNDSCALEPS instruction.
        /// </summary>
        public static readonly Instruction VRNDSCALEPS = new Instruction(1253);

        /// <summary>
        /// Represents the VRNDSCALESD instruction.
        /// </summary>
        public static readonly Instruction VRNDSCALESD = new Instruction(1254);

        /// <summary>
        /// Represents the VRNDSCALESS instruction.
        /// </summary>
        public static readonly Instruction VRNDSCALESS = new Instruction(1255);

        /// <summary>
        /// Represents the VROUNDPD instruction.
        /// </summary>
        public static readonly Instruction VROUNDPD = new Instruction(1256);

        /// <summary>
        /// Represents the VROUNDPS instruction.
        /// </summary>
        public static readonly Instruction VROUNDPS = new Instruction(1257);

        /// <summary>
        /// Represents the VROUNDSD instruction.
        /// </summary>
        public static readonly Instruction VROUNDSD = new Instruction(1258);

        /// <summary>
        /// Represents the VROUNDSS instruction.
        /// </summary>
        public static readonly Instruction VROUNDSS = new Instruction(1259);

        /// <summary>
        /// Represents the VRSQRT14PD instruction.
        /// </summary>
        public static readonly Instruction VRSQRT14PD = new Instruction(1260);

        /// <summary>
        /// Represents the VRSQRT14PS instruction.
        /// </summary>
        public static readonly Instruction VRSQRT14PS = new Instruction(1261);

        /// <summary>
        /// Represents the VRSQRT14SD instruction.
        /// </summary>
        public static readonly Instruction VRSQRT14SD = new Instruction(1262);

        /// <summary>
        /// Represents the VRSQRT14SS instruction.
        /// </summary>
        public static readonly Instruction VRSQRT14SS = new Instruction(1263);

        /// <summary>
        /// Represents the VRSQRT28PD instruction.
        /// </summary>
        public static readonly Instruction VRSQRT28PD = new Instruction(1264);

        /// <summary>
        /// Represents the VRSQRT28PS instruction.
        /// </summary>
        public static readonly Instruction VRSQRT28PS = new Instruction(1265);

        /// <summary>
        /// Represents the VRSQRT28SD instruction.
        /// </summary>
        public static readonly Instruction VRSQRT28SD = new Instruction(1266);

        /// <summary>
        /// Represents the VRSQRT28SS instruction.
        /// </summary>
        public static readonly Instruction VRSQRT28SS = new Instruction(1267);

        /// <summary>
        /// Represents the VRSQRTPS instruction.
        /// </summary>
        public static readonly Instruction VRSQRTPS = new Instruction(1268);

        /// <summary>
        /// Represents the VRSQRTSS instruction.
        /// </summary>
        public static readonly Instruction VRSQRTSS = new Instruction(1269);

        /// <summary>
        /// Represents the VSCATTERDPD instruction.
        /// </summary>
        public static readonly Instruction VSCATTERDPD = new Instruction(1270);

        /// <summary>
        /// Represents the VSCATTERDPS instruction.
        /// </summary>
        public static readonly Instruction VSCATTERDPS = new Instruction(1271);

        /// <summary>
        /// Represents the VSCATTERPF0DPD instruction.
        /// </summary>
        public static readonly Instruction VSCATTERPF0DPD = new Instruction(1272);

        /// <summary>
        /// Represents the VSCATTERPF0DPS instruction.
        /// </summary>
        public static readonly Instruction VSCATTERPF0DPS = new Instruction(1273);

        /// <summary>
        /// Represents the VSCATTERPF0QPD instruction.
        /// </summary>
        public static readonly Instruction VSCATTERPF0QPD = new Instruction(1274);

        /// <summary>
        /// Represents the VSCATTERPF0QPS instruction.
        /// </summary>
        public static readonly Instruction VSCATTERPF0QPS = new Instruction(1275);

        /// <summary>
        /// Represents the VSCATTERPF1DPD instruction.
        /// </summary>
        public static readonly Instruction VSCATTERPF1DPD = new Instruction(1276);

        /// <summary>
        /// Represents the VSCATTERPF1DPS instruction.
        /// </summary>
        public static readonly Instruction VSCATTERPF1DPS = new Instruction(1277);

        /// <summary>
        /// Represents the VSCATTERPF1QPD instruction.
        /// </summary>
        public static readonly Instruction VSCATTERPF1QPD = new Instruction(1278);

        /// <summary>
        /// Represents the VSCATTERPF1QPS instruction.
        /// </summary>
        public static readonly Instruction VSCATTERPF1QPS = new Instruction(1279);

        /// <summary>
        /// Represents the VSCATTERQPD instruction.
        /// </summary>
        public static readonly Instruction VSCATTERQPD = new Instruction(1280);

        /// <summary>
        /// Represents the VSCATTERQPS instruction.
        /// </summary>
        public static readonly Instruction VSCATTERQPS = new Instruction(1281);

        /// <summary>
        /// Represents the VSHUFPD instruction.
        /// </summary>
        public static readonly Instruction VSHUFPD = new Instruction(1282);

        /// <summary>
        /// Represents the VSHUFPS instruction.
        /// </summary>
        public static readonly Instruction VSHUFPS = new Instruction(1283);

        /// <summary>
        /// Represents the VSQRTPD instruction.
        /// </summary>
        public static readonly Instruction VSQRTPD = new Instruction(1284);

        /// <summary>
        /// Represents the VSQRTPS instruction.
        /// </summary>
        public static readonly Instruction VSQRTPS = new Instruction(1285);

        /// <summary>
        /// Represents the VSQRTSD instruction.
        /// </summary>
        public static readonly Instruction VSQRTSD = new Instruction(1286);

        /// <summary>
        /// Represents the VSQRTSS instruction.
        /// </summary>
        public static readonly Instruction VSQRTSS = new Instruction(1287);

        /// <summary>
        /// Represents the VSTMXCSR instruction.
        /// </summary>
        public static readonly Instruction VSTMXCSR = new Instruction(1288);

        /// <summary>
        /// Represents the VSUBPD instruction.
        /// </summary>
        public static readonly Instruction VSUBPD = new Instruction(1289);

        /// <summary>
        /// Represents the VSUBPS instruction.
        /// </summary>
        public static readonly Instruction VSUBPS = new Instruction(1290);

        /// <summary>
        /// Represents the VSUBSD instruction.
        /// </summary>
        public static readonly Instruction VSUBSD = new Instruction(1291);

        /// <summary>
        /// Represents the VSUBSS instruction.
        /// </summary>
        public static readonly Instruction VSUBSS = new Instruction(1292);

        /// <summary>
        /// Represents the VTESTPD instruction.
        /// </summary>
        public static readonly Instruction VTESTPD = new Instruction(1293);

        /// <summary>
        /// Represents the VTESTPS instruction.
        /// </summary>
        public static readonly Instruction VTESTPS = new Instruction(1294);

        /// <summary>
        /// Represents the VUNPCKHPD instruction.
        /// </summary>
        public static readonly Instruction VUNPCKHPD = new Instruction(1295);

        /// <summary>
        /// Represents the VUNPCKHPS instruction.
        /// </summary>
        public static readonly Instruction VUNPCKHPS = new Instruction(1296);

        /// <summary>
        /// Represents the VUNPCKLPD instruction.
        /// </summary>
        public static readonly Instruction VUNPCKLPD = new Instruction(1297);

        /// <summary>
        /// Represents the VUNPCKLPS instruction.
        /// </summary>
        public static readonly Instruction VUNPCKLPS = new Instruction(1298);

        /// <summary>
        /// Represents the VZEROALL instruction.
        /// </summary>
        public static readonly Instruction VZEROALL = new Instruction(1299);

        /// <summary>
        /// Represents the VZEROUPPER instruction.
        /// </summary>
        public static readonly Instruction VZEROUPPER = new Instruction(1300);

        /// <summary>
        /// Represents the WAIT instruction.
        /// </summary>
        public static readonly Instruction WAIT = new Instruction(1301);

        /// <summary>
        /// Represents the WBINVD instruction.
        /// </summary>
        public static readonly Instruction WBINVD = new Instruction(1302);

        /// <summary>
        /// Represents the WRFSBASE instruction.
        /// </summary>
        public static readonly Instruction WRFSBASE = new Instruction(1303);

        /// <summary>
        /// Represents the WRGSBASE instruction.
        /// </summary>
        public static readonly Instruction WRGSBASE = new Instruction(1304);

        /// <summary>
        /// Represents the WRMSR instruction.
        /// </summary>
        public static readonly Instruction WRMSR = new Instruction(1305);

        /// <summary>
        /// Represents the XABORT instruction.
        /// </summary>
        public static readonly Instruction XABORT = new Instruction(1306);

        /// <summary>
        /// Represents the XACQUIRE instruction.
        /// </summary>
        public static readonly Instruction XACQUIRE = new Instruction(1307);

        /// <summary>
        /// Represents the XBEGIN instruction.
        /// </summary>
        public static readonly Instruction XBEGIN = new Instruction(1308);

        /// <summary>
        /// Represents the XCHG instruction.
        /// </summary>
        public static readonly Instruction XCHG = new Instruction(1309);

        /// <summary>
        /// Represents the XCRYPTCBC instruction.
        /// </summary>
        public static readonly Instruction XCRYPTCBC = new Instruction(1310);

        /// <summary>
        /// Represents the XCRYPTCFB instruction.
        /// </summary>
        public static readonly Instruction XCRYPTCFB = new Instruction(1311);

        /// <summary>
        /// Represents the XCRYPTCTR instruction.
        /// </summary>
        public static readonly Instruction XCRYPTCTR = new Instruction(1312);

        /// <summary>
        /// Represents the XCRYPTECB instruction.
        /// </summary>
        public static readonly Instruction XCRYPTECB = new Instruction(1313);

        /// <summary>
        /// Represents the XCRYPTOFB instruction.
        /// </summary>
        public static readonly Instruction XCRYPTOFB = new Instruction(1314);

        /// <summary>
        /// Represents the XEND instruction.
        /// </summary>
        public static readonly Instruction XEND = new Instruction(1315);

        /// <summary>
        /// Represents the XGETBV instruction.
        /// </summary>
        public static readonly Instruction XGETBV = new Instruction(1316);

        /// <summary>
        /// Represents the XLATB instruction.
        /// </summary>
        public static readonly Instruction XLATB = new Instruction(1317);

        /// <summary>
        /// Represents the XRELEASE instruction.
        /// </summary>
        public static readonly Instruction XRELEASE = new Instruction(1318);

        /// <summary>
        /// Represents the XRSTOR instruction.
        /// </summary>
        public static readonly Instruction XRSTOR = new Instruction(1319);

        /// <summary>
        /// Represents the XRSTOR64 instruction.
        /// </summary>
        public static readonly Instruction XRSTOR64 = new Instruction(1320);

        /// <summary>
        /// Represents the XRSTORS instruction.
        /// </summary>
        public static readonly Instruction XRSTORS = new Instruction(1321);

        /// <summary>
        /// Represents the XRSTORS64 instruction.
        /// </summary>
        public static readonly Instruction XRSTORS64 = new Instruction(1322);

        /// <summary>
        /// Represents the XSAVE instruction.
        /// </summary>
        public static readonly Instruction XSAVE = new Instruction(1323);

        /// <summary>
        /// Represents the XSAVE64 instruction.
        /// </summary>
        public static readonly Instruction XSAVE64 = new Instruction(1324);

        /// <summary>
        /// Represents the XSAVEC instruction.
        /// </summary>
        public static readonly Instruction XSAVEC = new Instruction(1325);

        /// <summary>
        /// Represents the XSAVEC64 instruction.
        /// </summary>
        public static readonly Instruction XSAVEC64 = new Instruction(1326);

        /// <summary>
        /// Represents the XSAVEOPT instruction.
        /// </summary>
        public static readonly Instruction XSAVEOPT = new Instruction(1327);

        /// <summary>
        /// Represents the XSAVEOPT64 instruction.
        /// </summary>
        public static readonly Instruction XSAVEOPT64 = new Instruction(1328);

        /// <summary>
        /// Represents the XSAVES instruction.
        /// </summary>
        public static readonly Instruction XSAVES = new Instruction(1329);

        /// <summary>
        /// Represents the XSAVES64 instruction.
        /// </summary>
        public static readonly Instruction XSAVES64 = new Instruction(1330);

        /// <summary>
        /// Represents the XSETBV instruction.
        /// </summary>
        public static readonly Instruction XSETBV = new Instruction(1331);

        /// <summary>
        /// Represents the XSHA1 instruction.
        /// </summary>
        public static readonly Instruction XSHA1 = new Instruction(1332);

        /// <summary>
        /// Represents the XSHA256 instruction.
        /// </summary>
        public static readonly Instruction XSHA256 = new Instruction(1333);

        /// <summary>
        /// Represents the XSTORE instruction.
        /// </summary>
        public static readonly Instruction XSTORE = new Instruction(1334);

        /// <summary>
        /// Represents the XTEST instruction.
        /// </summary>
        public static readonly Instruction XTEST = new Instruction(1335);

        /// <summary>
        /// Represents the FDISI8087 NOP instruction.
        /// </summary>
        public static readonly Instruction FDISI8087_NOP = new Instruction(1336);

        /// <summary>
        /// Represents the FENI8087 NOP instruction.
        /// </summary>
        public static readonly Instruction FENI8087_NOP = new Instruction(1337);
    }
}
