namespace Unicorn.Mips
{
    /// <summary>
    /// Represents the registers of an <see cref="MipsEmulator"/>.
    /// </summary>
    public class MipsRegisters : Registers
    {
        internal MipsRegisters(Emulator emulator) : base(emulator)
        {
            // Space
        }

        // Generated by gen_reg_properties.py.

        /// <summary>
        /// Gets or sets the value of PC register.
        /// </summary>
        public long PC
        {
            get { return Read(1); }
            set { Write(1, value); }
        }

        /// <summary>
        /// Gets or sets the value of _0 register.
        /// </summary>
        public long _0
        {
            get { return Read(2); }
            set { Write(2, value); }
        }

        /// <summary>
        /// Gets or sets the value of _1 register.
        /// </summary>
        public long _1
        {
            get { return Read(3); }
            set { Write(3, value); }
        }

        /// <summary>
        /// Gets or sets the value of _2 register.
        /// </summary>
        public long _2
        {
            get { return Read(4); }
            set { Write(4, value); }
        }

        /// <summary>
        /// Gets or sets the value of _3 register.
        /// </summary>
        public long _3
        {
            get { return Read(5); }
            set { Write(5, value); }
        }

        /// <summary>
        /// Gets or sets the value of _4 register.
        /// </summary>
        public long _4
        {
            get { return Read(6); }
            set { Write(6, value); }
        }

        /// <summary>
        /// Gets or sets the value of _5 register.
        /// </summary>
        public long _5
        {
            get { return Read(7); }
            set { Write(7, value); }
        }

        /// <summary>
        /// Gets or sets the value of _6 register.
        /// </summary>
        public long _6
        {
            get { return Read(8); }
            set { Write(8, value); }
        }

        /// <summary>
        /// Gets or sets the value of _7 register.
        /// </summary>
        public long _7
        {
            get { return Read(9); }
            set { Write(9, value); }
        }

        /// <summary>
        /// Gets or sets the value of _8 register.
        /// </summary>
        public long _8
        {
            get { return Read(10); }
            set { Write(10, value); }
        }

        /// <summary>
        /// Gets or sets the value of _9 register.
        /// </summary>
        public long _9
        {
            get { return Read(11); }
            set { Write(11, value); }
        }

        /// <summary>
        /// Gets or sets the value of _10 register.
        /// </summary>
        public long _10
        {
            get { return Read(12); }
            set { Write(12, value); }
        }

        /// <summary>
        /// Gets or sets the value of _11 register.
        /// </summary>
        public long _11
        {
            get { return Read(13); }
            set { Write(13, value); }
        }

        /// <summary>
        /// Gets or sets the value of _12 register.
        /// </summary>
        public long _12
        {
            get { return Read(14); }
            set { Write(14, value); }
        }

        /// <summary>
        /// Gets or sets the value of _13 register.
        /// </summary>
        public long _13
        {
            get { return Read(15); }
            set { Write(15, value); }
        }

        /// <summary>
        /// Gets or sets the value of _14 register.
        /// </summary>
        public long _14
        {
            get { return Read(16); }
            set { Write(16, value); }
        }

        /// <summary>
        /// Gets or sets the value of _15 register.
        /// </summary>
        public long _15
        {
            get { return Read(17); }
            set { Write(17, value); }
        }

        /// <summary>
        /// Gets or sets the value of _16 register.
        /// </summary>
        public long _16
        {
            get { return Read(18); }
            set { Write(18, value); }
        }

        /// <summary>
        /// Gets or sets the value of _17 register.
        /// </summary>
        public long _17
        {
            get { return Read(19); }
            set { Write(19, value); }
        }

        /// <summary>
        /// Gets or sets the value of _18 register.
        /// </summary>
        public long _18
        {
            get { return Read(20); }
            set { Write(20, value); }
        }

        /// <summary>
        /// Gets or sets the value of _19 register.
        /// </summary>
        public long _19
        {
            get { return Read(21); }
            set { Write(21, value); }
        }

        /// <summary>
        /// Gets or sets the value of _20 register.
        /// </summary>
        public long _20
        {
            get { return Read(22); }
            set { Write(22, value); }
        }

        /// <summary>
        /// Gets or sets the value of _21 register.
        /// </summary>
        public long _21
        {
            get { return Read(23); }
            set { Write(23, value); }
        }

        /// <summary>
        /// Gets or sets the value of _22 register.
        /// </summary>
        public long _22
        {
            get { return Read(24); }
            set { Write(24, value); }
        }

        /// <summary>
        /// Gets or sets the value of _23 register.
        /// </summary>
        public long _23
        {
            get { return Read(25); }
            set { Write(25, value); }
        }

        /// <summary>
        /// Gets or sets the value of _24 register.
        /// </summary>
        public long _24
        {
            get { return Read(26); }
            set { Write(26, value); }
        }

        /// <summary>
        /// Gets or sets the value of _25 register.
        /// </summary>
        public long _25
        {
            get { return Read(27); }
            set { Write(27, value); }
        }

        /// <summary>
        /// Gets or sets the value of _26 register.
        /// </summary>
        public long _26
        {
            get { return Read(28); }
            set { Write(28, value); }
        }

        /// <summary>
        /// Gets or sets the value of _27 register.
        /// </summary>
        public long _27
        {
            get { return Read(29); }
            set { Write(29, value); }
        }

        /// <summary>
        /// Gets or sets the value of _28 register.
        /// </summary>
        public long _28
        {
            get { return Read(30); }
            set { Write(30, value); }
        }

        /// <summary>
        /// Gets or sets the value of _29 register.
        /// </summary>
        public long _29
        {
            get { return Read(31); }
            set { Write(31, value); }
        }

        /// <summary>
        /// Gets or sets the value of _30 register.
        /// </summary>
        public long _30
        {
            get { return Read(32); }
            set { Write(32, value); }
        }

        /// <summary>
        /// Gets or sets the value of _31 register.
        /// </summary>
        public long _31
        {
            get { return Read(33); }
            set { Write(33, value); }
        }

        /// <summary>
        /// Gets or sets the value of DSPCCOND register.
        /// </summary>
        public long DSPCCOND
        {
            get { return Read(34); }
            set { Write(34, value); }
        }

        /// <summary>
        /// Gets or sets the value of DSPCARRY register.
        /// </summary>
        public long DSPCARRY
        {
            get { return Read(35); }
            set { Write(35, value); }
        }

        /// <summary>
        /// Gets or sets the value of DSPEFI register.
        /// </summary>
        public long DSPEFI
        {
            get { return Read(36); }
            set { Write(36, value); }
        }

        /// <summary>
        /// Gets or sets the value of DSPOUTFLAG register.
        /// </summary>
        public long DSPOUTFLAG
        {
            get { return Read(37); }
            set { Write(37, value); }
        }

        /// <summary>
        /// Gets or sets the value of DSPOUTFLAG16_19 register.
        /// </summary>
        public long DSPOUTFLAG16_19
        {
            get { return Read(38); }
            set { Write(38, value); }
        }

        /// <summary>
        /// Gets or sets the value of DSPOUTFLAG20 register.
        /// </summary>
        public long DSPOUTFLAG20
        {
            get { return Read(39); }
            set { Write(39, value); }
        }

        /// <summary>
        /// Gets or sets the value of DSPOUTFLAG21 register.
        /// </summary>
        public long DSPOUTFLAG21
        {
            get { return Read(40); }
            set { Write(40, value); }
        }

        /// <summary>
        /// Gets or sets the value of DSPOUTFLAG22 register.
        /// </summary>
        public long DSPOUTFLAG22
        {
            get { return Read(41); }
            set { Write(41, value); }
        }

        /// <summary>
        /// Gets or sets the value of DSPOUTFLAG23 register.
        /// </summary>
        public long DSPOUTFLAG23
        {
            get { return Read(42); }
            set { Write(42, value); }
        }

        /// <summary>
        /// Gets or sets the value of DSPPOS register.
        /// </summary>
        public long DSPPOS
        {
            get { return Read(43); }
            set { Write(43, value); }
        }

        /// <summary>
        /// Gets or sets the value of DSPSCOUNT register.
        /// </summary>
        public long DSPSCOUNT
        {
            get { return Read(44); }
            set { Write(44, value); }
        }

        /// <summary>
        /// Gets or sets the value of AC0 register.
        /// </summary>
        public long AC0
        {
            get { return Read(45); }
            set { Write(45, value); }
        }

        /// <summary>
        /// Gets or sets the value of AC1 register.
        /// </summary>
        public long AC1
        {
            get { return Read(46); }
            set { Write(46, value); }
        }

        /// <summary>
        /// Gets or sets the value of AC2 register.
        /// </summary>
        public long AC2
        {
            get { return Read(47); }
            set { Write(47, value); }
        }

        /// <summary>
        /// Gets or sets the value of AC3 register.
        /// </summary>
        public long AC3
        {
            get { return Read(48); }
            set { Write(48, value); }
        }

        /// <summary>
        /// Gets or sets the value of CC0 register.
        /// </summary>
        public long CC0
        {
            get { return Read(49); }
            set { Write(49, value); }
        }

        /// <summary>
        /// Gets or sets the value of CC1 register.
        /// </summary>
        public long CC1
        {
            get { return Read(50); }
            set { Write(50, value); }
        }

        /// <summary>
        /// Gets or sets the value of CC2 register.
        /// </summary>
        public long CC2
        {
            get { return Read(51); }
            set { Write(51, value); }
        }

        /// <summary>
        /// Gets or sets the value of CC3 register.
        /// </summary>
        public long CC3
        {
            get { return Read(52); }
            set { Write(52, value); }
        }

        /// <summary>
        /// Gets or sets the value of CC4 register.
        /// </summary>
        public long CC4
        {
            get { return Read(53); }
            set { Write(53, value); }
        }

        /// <summary>
        /// Gets or sets the value of CC5 register.
        /// </summary>
        public long CC5
        {
            get { return Read(54); }
            set { Write(54, value); }
        }

        /// <summary>
        /// Gets or sets the value of CC6 register.
        /// </summary>
        public long CC6
        {
            get { return Read(55); }
            set { Write(55, value); }
        }

        /// <summary>
        /// Gets or sets the value of CC7 register.
        /// </summary>
        public long CC7
        {
            get { return Read(56); }
            set { Write(56, value); }
        }

        /// <summary>
        /// Gets or sets the value of F0 register.
        /// </summary>
        public long F0
        {
            get { return Read(57); }
            set { Write(57, value); }
        }

        /// <summary>
        /// Gets or sets the value of F1 register.
        /// </summary>
        public long F1
        {
            get { return Read(58); }
            set { Write(58, value); }
        }

        /// <summary>
        /// Gets or sets the value of F2 register.
        /// </summary>
        public long F2
        {
            get { return Read(59); }
            set { Write(59, value); }
        }

        /// <summary>
        /// Gets or sets the value of F3 register.
        /// </summary>
        public long F3
        {
            get { return Read(60); }
            set { Write(60, value); }
        }

        /// <summary>
        /// Gets or sets the value of F4 register.
        /// </summary>
        public long F4
        {
            get { return Read(61); }
            set { Write(61, value); }
        }

        /// <summary>
        /// Gets or sets the value of F5 register.
        /// </summary>
        public long F5
        {
            get { return Read(62); }
            set { Write(62, value); }
        }

        /// <summary>
        /// Gets or sets the value of F6 register.
        /// </summary>
        public long F6
        {
            get { return Read(63); }
            set { Write(63, value); }
        }

        /// <summary>
        /// Gets or sets the value of F7 register.
        /// </summary>
        public long F7
        {
            get { return Read(64); }
            set { Write(64, value); }
        }

        /// <summary>
        /// Gets or sets the value of F8 register.
        /// </summary>
        public long F8
        {
            get { return Read(65); }
            set { Write(65, value); }
        }

        /// <summary>
        /// Gets or sets the value of F9 register.
        /// </summary>
        public long F9
        {
            get { return Read(66); }
            set { Write(66, value); }
        }

        /// <summary>
        /// Gets or sets the value of F10 register.
        /// </summary>
        public long F10
        {
            get { return Read(67); }
            set { Write(67, value); }
        }

        /// <summary>
        /// Gets or sets the value of F11 register.
        /// </summary>
        public long F11
        {
            get { return Read(68); }
            set { Write(68, value); }
        }

        /// <summary>
        /// Gets or sets the value of F12 register.
        /// </summary>
        public long F12
        {
            get { return Read(69); }
            set { Write(69, value); }
        }

        /// <summary>
        /// Gets or sets the value of F13 register.
        /// </summary>
        public long F13
        {
            get { return Read(70); }
            set { Write(70, value); }
        }

        /// <summary>
        /// Gets or sets the value of F14 register.
        /// </summary>
        public long F14
        {
            get { return Read(71); }
            set { Write(71, value); }
        }

        /// <summary>
        /// Gets or sets the value of F15 register.
        /// </summary>
        public long F15
        {
            get { return Read(72); }
            set { Write(72, value); }
        }

        /// <summary>
        /// Gets or sets the value of F16 register.
        /// </summary>
        public long F16
        {
            get { return Read(73); }
            set { Write(73, value); }
        }

        /// <summary>
        /// Gets or sets the value of F17 register.
        /// </summary>
        public long F17
        {
            get { return Read(74); }
            set { Write(74, value); }
        }

        /// <summary>
        /// Gets or sets the value of F18 register.
        /// </summary>
        public long F18
        {
            get { return Read(75); }
            set { Write(75, value); }
        }

        /// <summary>
        /// Gets or sets the value of F19 register.
        /// </summary>
        public long F19
        {
            get { return Read(76); }
            set { Write(76, value); }
        }

        /// <summary>
        /// Gets or sets the value of F20 register.
        /// </summary>
        public long F20
        {
            get { return Read(77); }
            set { Write(77, value); }
        }

        /// <summary>
        /// Gets or sets the value of F21 register.
        /// </summary>
        public long F21
        {
            get { return Read(78); }
            set { Write(78, value); }
        }

        /// <summary>
        /// Gets or sets the value of F22 register.
        /// </summary>
        public long F22
        {
            get { return Read(79); }
            set { Write(79, value); }
        }

        /// <summary>
        /// Gets or sets the value of F23 register.
        /// </summary>
        public long F23
        {
            get { return Read(80); }
            set { Write(80, value); }
        }

        /// <summary>
        /// Gets or sets the value of F24 register.
        /// </summary>
        public long F24
        {
            get { return Read(81); }
            set { Write(81, value); }
        }

        /// <summary>
        /// Gets or sets the value of F25 register.
        /// </summary>
        public long F25
        {
            get { return Read(82); }
            set { Write(82, value); }
        }

        /// <summary>
        /// Gets or sets the value of F26 register.
        /// </summary>
        public long F26
        {
            get { return Read(83); }
            set { Write(83, value); }
        }

        /// <summary>
        /// Gets or sets the value of F27 register.
        /// </summary>
        public long F27
        {
            get { return Read(84); }
            set { Write(84, value); }
        }

        /// <summary>
        /// Gets or sets the value of F28 register.
        /// </summary>
        public long F28
        {
            get { return Read(85); }
            set { Write(85, value); }
        }

        /// <summary>
        /// Gets or sets the value of F29 register.
        /// </summary>
        public long F29
        {
            get { return Read(86); }
            set { Write(86, value); }
        }

        /// <summary>
        /// Gets or sets the value of F30 register.
        /// </summary>
        public long F30
        {
            get { return Read(87); }
            set { Write(87, value); }
        }

        /// <summary>
        /// Gets or sets the value of F31 register.
        /// </summary>
        public long F31
        {
            get { return Read(88); }
            set { Write(88, value); }
        }

        /// <summary>
        /// Gets or sets the value of FCC0 register.
        /// </summary>
        public long FCC0
        {
            get { return Read(89); }
            set { Write(89, value); }
        }

        /// <summary>
        /// Gets or sets the value of FCC1 register.
        /// </summary>
        public long FCC1
        {
            get { return Read(90); }
            set { Write(90, value); }
        }

        /// <summary>
        /// Gets or sets the value of FCC2 register.
        /// </summary>
        public long FCC2
        {
            get { return Read(91); }
            set { Write(91, value); }
        }

        /// <summary>
        /// Gets or sets the value of FCC3 register.
        /// </summary>
        public long FCC3
        {
            get { return Read(92); }
            set { Write(92, value); }
        }

        /// <summary>
        /// Gets or sets the value of FCC4 register.
        /// </summary>
        public long FCC4
        {
            get { return Read(93); }
            set { Write(93, value); }
        }

        /// <summary>
        /// Gets or sets the value of FCC5 register.
        /// </summary>
        public long FCC5
        {
            get { return Read(94); }
            set { Write(94, value); }
        }

        /// <summary>
        /// Gets or sets the value of FCC6 register.
        /// </summary>
        public long FCC6
        {
            get { return Read(95); }
            set { Write(95, value); }
        }

        /// <summary>
        /// Gets or sets the value of FCC7 register.
        /// </summary>
        public long FCC7
        {
            get { return Read(96); }
            set { Write(96, value); }
        }

        /// <summary>
        /// Gets or sets the value of W0 register.
        /// </summary>
        public long W0
        {
            get { return Read(97); }
            set { Write(97, value); }
        }

        /// <summary>
        /// Gets or sets the value of W1 register.
        /// </summary>
        public long W1
        {
            get { return Read(98); }
            set { Write(98, value); }
        }

        /// <summary>
        /// Gets or sets the value of W2 register.
        /// </summary>
        public long W2
        {
            get { return Read(99); }
            set { Write(99, value); }
        }

        /// <summary>
        /// Gets or sets the value of W3 register.
        /// </summary>
        public long W3
        {
            get { return Read(100); }
            set { Write(100, value); }
        }

        /// <summary>
        /// Gets or sets the value of W4 register.
        /// </summary>
        public long W4
        {
            get { return Read(101); }
            set { Write(101, value); }
        }

        /// <summary>
        /// Gets or sets the value of W5 register.
        /// </summary>
        public long W5
        {
            get { return Read(102); }
            set { Write(102, value); }
        }

        /// <summary>
        /// Gets or sets the value of W6 register.
        /// </summary>
        public long W6
        {
            get { return Read(103); }
            set { Write(103, value); }
        }

        /// <summary>
        /// Gets or sets the value of W7 register.
        /// </summary>
        public long W7
        {
            get { return Read(104); }
            set { Write(104, value); }
        }

        /// <summary>
        /// Gets or sets the value of W8 register.
        /// </summary>
        public long W8
        {
            get { return Read(105); }
            set { Write(105, value); }
        }

        /// <summary>
        /// Gets or sets the value of W9 register.
        /// </summary>
        public long W9
        {
            get { return Read(106); }
            set { Write(106, value); }
        }

        /// <summary>
        /// Gets or sets the value of W10 register.
        /// </summary>
        public long W10
        {
            get { return Read(107); }
            set { Write(107, value); }
        }

        /// <summary>
        /// Gets or sets the value of W11 register.
        /// </summary>
        public long W11
        {
            get { return Read(108); }
            set { Write(108, value); }
        }

        /// <summary>
        /// Gets or sets the value of W12 register.
        /// </summary>
        public long W12
        {
            get { return Read(109); }
            set { Write(109, value); }
        }

        /// <summary>
        /// Gets or sets the value of W13 register.
        /// </summary>
        public long W13
        {
            get { return Read(110); }
            set { Write(110, value); }
        }

        /// <summary>
        /// Gets or sets the value of W14 register.
        /// </summary>
        public long W14
        {
            get { return Read(111); }
            set { Write(111, value); }
        }

        /// <summary>
        /// Gets or sets the value of W15 register.
        /// </summary>
        public long W15
        {
            get { return Read(112); }
            set { Write(112, value); }
        }

        /// <summary>
        /// Gets or sets the value of W16 register.
        /// </summary>
        public long W16
        {
            get { return Read(113); }
            set { Write(113, value); }
        }

        /// <summary>
        /// Gets or sets the value of W17 register.
        /// </summary>
        public long W17
        {
            get { return Read(114); }
            set { Write(114, value); }
        }

        /// <summary>
        /// Gets or sets the value of W18 register.
        /// </summary>
        public long W18
        {
            get { return Read(115); }
            set { Write(115, value); }
        }

        /// <summary>
        /// Gets or sets the value of W19 register.
        /// </summary>
        public long W19
        {
            get { return Read(116); }
            set { Write(116, value); }
        }

        /// <summary>
        /// Gets or sets the value of W20 register.
        /// </summary>
        public long W20
        {
            get { return Read(117); }
            set { Write(117, value); }
        }

        /// <summary>
        /// Gets or sets the value of W21 register.
        /// </summary>
        public long W21
        {
            get { return Read(118); }
            set { Write(118, value); }
        }

        /// <summary>
        /// Gets or sets the value of W22 register.
        /// </summary>
        public long W22
        {
            get { return Read(119); }
            set { Write(119, value); }
        }

        /// <summary>
        /// Gets or sets the value of W23 register.
        /// </summary>
        public long W23
        {
            get { return Read(120); }
            set { Write(120, value); }
        }

        /// <summary>
        /// Gets or sets the value of W24 register.
        /// </summary>
        public long W24
        {
            get { return Read(121); }
            set { Write(121, value); }
        }

        /// <summary>
        /// Gets or sets the value of W25 register.
        /// </summary>
        public long W25
        {
            get { return Read(122); }
            set { Write(122, value); }
        }

        /// <summary>
        /// Gets or sets the value of W26 register.
        /// </summary>
        public long W26
        {
            get { return Read(123); }
            set { Write(123, value); }
        }

        /// <summary>
        /// Gets or sets the value of W27 register.
        /// </summary>
        public long W27
        {
            get { return Read(124); }
            set { Write(124, value); }
        }

        /// <summary>
        /// Gets or sets the value of W28 register.
        /// </summary>
        public long W28
        {
            get { return Read(125); }
            set { Write(125, value); }
        }

        /// <summary>
        /// Gets or sets the value of W29 register.
        /// </summary>
        public long W29
        {
            get { return Read(126); }
            set { Write(126, value); }
        }

        /// <summary>
        /// Gets or sets the value of W30 register.
        /// </summary>
        public long W30
        {
            get { return Read(127); }
            set { Write(127, value); }
        }

        /// <summary>
        /// Gets or sets the value of W31 register.
        /// </summary>
        public long W31
        {
            get { return Read(128); }
            set { Write(128, value); }
        }

        /// <summary>
        /// Gets or sets the value of HI register.
        /// </summary>
        public long HI
        {
            get { return Read(129); }
            set { Write(129, value); }
        }

        /// <summary>
        /// Gets or sets the value of LO register.
        /// </summary>
        public long LO
        {
            get { return Read(130); }
            set { Write(130, value); }
        }

        /// <summary>
        /// Gets or sets the value of P0 register.
        /// </summary>
        public long P0
        {
            get { return Read(131); }
            set { Write(131, value); }
        }

        /// <summary>
        /// Gets or sets the value of P1 register.
        /// </summary>
        public long P1
        {
            get { return Read(132); }
            set { Write(132, value); }
        }

        /// <summary>
        /// Gets or sets the value of P2 register.
        /// </summary>
        public long P2
        {
            get { return Read(133); }
            set { Write(133, value); }
        }

        /// <summary>
        /// Gets or sets the value of MPL0 register.
        /// </summary>
        public long MPL0
        {
            get { return Read(134); }
            set { Write(134, value); }
        }

        /// <summary>
        /// Gets or sets the value of MPL1 register.
        /// </summary>
        public long MPL1
        {
            get { return Read(135); }
            set { Write(135, value); }
        }

        /// <summary>
        /// Gets or sets the value of MPL2 register.
        /// </summary>
        public long MPL2
        {
            get { return Read(136); }
            set { Write(136, value); }
        }

        /// <summary>
        /// Gets or sets the value of ZERO register.
        /// </summary>
        public long ZERO
        {
            get { return Read(2); }
            set { Write(2, value); }
        }

        /// <summary>
        /// Gets or sets the value of AT register.
        /// </summary>
        public long AT
        {
            get { return Read(3); }
            set { Write(3, value); }
        }

        /// <summary>
        /// Gets or sets the value of V0 register.
        /// </summary>
        public long V0
        {
            get { return Read(4); }
            set { Write(4, value); }
        }

        /// <summary>
        /// Gets or sets the value of V1 register.
        /// </summary>
        public long V1
        {
            get { return Read(5); }
            set { Write(5, value); }
        }

        /// <summary>
        /// Gets or sets the value of A0 register.
        /// </summary>
        public long A0
        {
            get { return Read(6); }
            set { Write(6, value); }
        }

        /// <summary>
        /// Gets or sets the value of A1 register.
        /// </summary>
        public long A1
        {
            get { return Read(7); }
            set { Write(7, value); }
        }

        /// <summary>
        /// Gets or sets the value of A2 register.
        /// </summary>
        public long A2
        {
            get { return Read(8); }
            set { Write(8, value); }
        }

        /// <summary>
        /// Gets or sets the value of A3 register.
        /// </summary>
        public long A3
        {
            get { return Read(9); }
            set { Write(9, value); }
        }

        /// <summary>
        /// Gets or sets the value of T0 register.
        /// </summary>
        public long T0
        {
            get { return Read(10); }
            set { Write(10, value); }
        }

        /// <summary>
        /// Gets or sets the value of T1 register.
        /// </summary>
        public long T1
        {
            get { return Read(11); }
            set { Write(11, value); }
        }

        /// <summary>
        /// Gets or sets the value of T2 register.
        /// </summary>
        public long T2
        {
            get { return Read(12); }
            set { Write(12, value); }
        }

        /// <summary>
        /// Gets or sets the value of T3 register.
        /// </summary>
        public long T3
        {
            get { return Read(13); }
            set { Write(13, value); }
        }

        /// <summary>
        /// Gets or sets the value of T4 register.
        /// </summary>
        public long T4
        {
            get { return Read(14); }
            set { Write(14, value); }
        }

        /// <summary>
        /// Gets or sets the value of T5 register.
        /// </summary>
        public long T5
        {
            get { return Read(15); }
            set { Write(15, value); }
        }

        /// <summary>
        /// Gets or sets the value of T6 register.
        /// </summary>
        public long T6
        {
            get { return Read(16); }
            set { Write(16, value); }
        }

        /// <summary>
        /// Gets or sets the value of T7 register.
        /// </summary>
        public long T7
        {
            get { return Read(17); }
            set { Write(17, value); }
        }

        /// <summary>
        /// Gets or sets the value of S0 register.
        /// </summary>
        public long S0
        {
            get { return Read(18); }
            set { Write(18, value); }
        }

        /// <summary>
        /// Gets or sets the value of S1 register.
        /// </summary>
        public long S1
        {
            get { return Read(19); }
            set { Write(19, value); }
        }

        /// <summary>
        /// Gets or sets the value of S2 register.
        /// </summary>
        public long S2
        {
            get { return Read(20); }
            set { Write(20, value); }
        }

        /// <summary>
        /// Gets or sets the value of S3 register.
        /// </summary>
        public long S3
        {
            get { return Read(21); }
            set { Write(21, value); }
        }

        /// <summary>
        /// Gets or sets the value of S4 register.
        /// </summary>
        public long S4
        {
            get { return Read(22); }
            set { Write(22, value); }
        }

        /// <summary>
        /// Gets or sets the value of S5 register.
        /// </summary>
        public long S5
        {
            get { return Read(23); }
            set { Write(23, value); }
        }

        /// <summary>
        /// Gets or sets the value of S6 register.
        /// </summary>
        public long S6
        {
            get { return Read(24); }
            set { Write(24, value); }
        }

        /// <summary>
        /// Gets or sets the value of S7 register.
        /// </summary>
        public long S7
        {
            get { return Read(25); }
            set { Write(25, value); }
        }

        /// <summary>
        /// Gets or sets the value of T8 register.
        /// </summary>
        public long T8
        {
            get { return Read(26); }
            set { Write(26, value); }
        }

        /// <summary>
        /// Gets or sets the value of T9 register.
        /// </summary>
        public long T9
        {
            get { return Read(27); }
            set { Write(27, value); }
        }

        /// <summary>
        /// Gets or sets the value of K0 register.
        /// </summary>
        public long K0
        {
            get { return Read(28); }
            set { Write(28, value); }
        }

        /// <summary>
        /// Gets or sets the value of K1 register.
        /// </summary>
        public long K1
        {
            get { return Read(29); }
            set { Write(29, value); }
        }

        /// <summary>
        /// Gets or sets the value of GP register.
        /// </summary>
        public long GP
        {
            get { return Read(30); }
            set { Write(30, value); }
        }

        /// <summary>
        /// Gets or sets the value of SP register.
        /// </summary>
        public long SP
        {
            get { return Read(31); }
            set { Write(31, value); }
        }

        /// <summary>
        /// Gets or sets the value of FP register.
        /// </summary>
        public long FP
        {
            get { return Read(32); }
            set { Write(32, value); }
        }

        /// <summary>
        /// Gets or sets the value of S8 register.
        /// </summary>
        public long S8
        {
            get { return Read(32); }
            set { Write(32, value); }
        }

        /// <summary>
        /// Gets or sets the value of RA register.
        /// </summary>
        public long RA
        {
            get { return Read(33); }
            set { Write(33, value); }
        }

        /// <summary>
        /// Gets or sets the value of HI0 register.
        /// </summary>
        public long HI0
        {
            get { return Read(45); }
            set { Write(45, value); }
        }

        /// <summary>
        /// Gets or sets the value of HI1 register.
        /// </summary>
        public long HI1
        {
            get { return Read(46); }
            set { Write(46, value); }
        }

        /// <summary>
        /// Gets or sets the value of HI2 register.
        /// </summary>
        public long HI2
        {
            get { return Read(47); }
            set { Write(47, value); }
        }

        /// <summary>
        /// Gets or sets the value of HI3 register.
        /// </summary>
        public long HI3
        {
            get { return Read(48); }
            set { Write(48, value); }
        }

        /// <summary>
        /// Gets or sets the value of LO0 register.
        /// </summary>
        public long LO0
        {
            get { return Read(45); }
            set { Write(45, value); }
        }

        /// <summary>
        /// Gets or sets the value of LO1 register.
        /// </summary>
        public long LO1
        {
            get { return Read(46); }
            set { Write(46, value); }
        }

        /// <summary>
        /// Gets or sets the value of LO2 register.
        /// </summary>
        public long LO2
        {
            get { return Read(47); }
            set { Write(47, value); }
        }

        /// <summary>
        /// Gets or sets the value of LO3 register.
        /// </summary>
        public long LO3
        {
            get { return Read(48); }
            set { Write(48, value); }
        }
    }
}
