%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0":  ["0x414243443F800000", "0xEEEEEEEEEEEEEEEE", "0x0000000000000000", "0x0000000000000000"],
    "XMM1":  ["0x414243443F000000", "0xDDDDDDDDDDDDDDDD", "0x0000000000000000", "0x0000000000000000"],
    "XMM2":  ["0x414243443EAAAAAB", "0xCCCCCCCCCCCCCCCC", "0x0000000000000000", "0x0000000000000000"],
    "XMM3":  ["0x414243443E800000", "0xBBBBBBBBBBBBBBBB", "0x0000000000000000", "0x0000000000000000"],
    "XMM4":  ["0x414243443F800000", "0xAAAAAAAAAAAAAAAA", "0x0000000000000000", "0x0000000000000000"],
    "XMM5":  ["0x414243443F000000", "0xAAAAAAAAAAAAAAAA", "0x0000000000000000", "0x0000000000000000"],
    "XMM6":  ["0x414243443EAAAAAB", "0xAAAAAAAAAAAAAAAA", "0x0000000000000000", "0x0000000000000000"],
    "XMM7":  ["0x414243443E800000", "0xAAAAAAAAAAAAAAAA", "0x0000000000000000", "0x0000000000000000"],
    "XMM8":  ["0x414243443F800000", "0xDDDDDDDDDDDDDDDD", "0x0000000000000000", "0x0000000000000000"],
    "XMM9":  ["0x414243443F000000", "0xCCCCCCCCCCCCCCCC", "0x0000000000000000", "0x0000000000000000"],
    "XMM10": ["0x414243443EAAAAAB", "0xBBBBBBBBBBBBBBBB", "0x0000000000000000", "0x0000000000000000"],
    "XMM11": ["0x414243443E800000", "0xAAAAAAAAAAAAAAAA", "0x0000000000000000", "0x0000000000000000"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm0, [rdx + 32 * 0]
vmovapd ymm1, [rdx + 32 * 1]
vmovapd ymm2, [rdx + 32 * 2]
vmovapd ymm3, [rdx + 32 * 3]
vmovapd ymm4, [rdx + 32 * 4]
vmovapd ymm5, [rdx + 32 * 4]
vmovapd ymm6, [rdx + 32 * 4]
vmovapd ymm7, [rdx + 32 * 4]

; Same register
vrsqrtss xmm0, xmm0, xmm0
vrsqrtss xmm1, xmm1, xmm1
vrsqrtss xmm2, xmm2, xmm2
vrsqrtss xmm3, xmm3, xmm3

; Memory operand
vrsqrtss xmm4, xmm4, [rdx + 32 * 0]
vrsqrtss xmm5, xmm5, [rdx + 32 * 1]
vrsqrtss xmm6, xmm6, [rdx + 32 * 2]
vrsqrtss xmm7, xmm7, [rdx + 32 * 3]

; Memory operand different source register
vrsqrtss xmm8, xmm1, [rdx + 32 * 0]
vrsqrtss xmm9, xmm2, [rdx + 32 * 1]
vrsqrtss xmm10, xmm3, [rdx + 32 * 2]
vrsqrtss xmm11, xmm4, [rdx + 32 * 3]

hlt

align 32
.data:
dq 0x414243443F800000 ; 1.0
dq 0xEEEEEEEEEEEEEEEE
dq 0x5152535455565758
dq 0x5152535455565758

dq 0x4142434440800000 ; 4.0
dq 0xDDDDDDDDDDDDDDDD
dq 0x5152535455565758
dq 0x5152535455565758

dq 0x4142434441100000 ; 9.0
dq 0xCCCCCCCCCCCCCCCC
dq 0x5152535455565758
dq 0x5152535455565758

dq 0x4142434441800000 ; 16.0
dq 0xBBBBBBBBBBBBBBBB
dq 0x5152535455565758
dq 0x5152535455565758

dq 0x4142434441C80000 ; 25.0
dq 0xAAAAAAAAAAAAAAAA
dq 0x5152535455565758
dq 0x5152535455565758
