%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0":  ["0x3F8000003F800000", "0x3F8000003F800000", "0x3F8000003F800000", "0x3F8000003F800000"],
    "XMM1":  ["0x3F0000003F000000", "0x3F0000003F000000", "0x3F0000003F000000", "0x3F0000003F000000"],
    "XMM2":  ["0x3EAAAAAB3EAAAAAB", "0x3EAAAAAB3EAAAAAB", "0x0000000000000000", "0x0000000000000000"],
    "XMM3":  ["0x3E8000003E800000", "0x3E8000003E800000", "0x0000000000000000", "0x0000000000000000"],
    "XMM4":  ["0x3F8000003F800000", "0x3F8000003F800000", "0x3F8000003F800000", "0x3F8000003F800000"],
    "XMM5":  ["0x3F0000003F000000", "0x3F0000003F000000", "0x3F0000003F000000", "0x3F0000003F000000"],
    "XMM6":  ["0x3EAAAAAB3EAAAAAB", "0x3EAAAAAB3EAAAAAB", "0x0000000000000000", "0x0000000000000000"],
    "XMM7":  ["0x3E8000003E800000", "0x3E8000003E800000", "0x0000000000000000", "0x0000000000000000"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm0, [rdx + 32 * 0]
vmovapd ymm1, [rdx + 32 * 1]
vmovapd ymm2, [rdx + 32 * 2]
vmovapd ymm3, [rdx + 32 * 3]
vmovapd ymm4, [rdx + 32 * 4]
vmovapd ymm5, [rdx + 32 * 4]
vmovapd ymm6, [rdx + 32 * 4]
vmovapd ymm7, [rdx + 32 * 4]

; Register only
vrsqrtps ymm0, ymm0
vrsqrtps ymm1, ymm1
vrsqrtps xmm2, xmm2
vrsqrtps xmm3, xmm3

; Memory operand
vrsqrtps ymm4, [rdx + 32 * 0]
vrsqrtps ymm5, [rdx + 32 * 1]
vrsqrtps xmm6, [rdx + 32 * 2]
vrsqrtps xmm7, [rdx + 32 * 3]

hlt

align 32
.data:
dq 0x3F8000003F800000 ; 1.0
dq 0x3F8000003F800000
dq 0x3F8000003F800000
dq 0x3F8000003F800000

dq 0x4080000040800000 ; 4.0
dq 0x4080000040800000
dq 0x4080000040800000
dq 0x4080000040800000

dq 0x4110000041100000 ; 9.0
dq 0x4110000041100000
dq 0x4110000041100000
dq 0x4110000041100000

dq 0x4180000041800000 ; 16.0
dq 0x4180000041800000
dq 0x4180000041800000
dq 0x4180000041800000

dq 0x41C8000041C80000 ; 25.0
dq 0x41C8000041C80000
dq 0x41C8000041C80000
dq 0x41C8000041C80000
