%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0": ["0x3F8000003F800000", "0x3F8000003F800000", "0x3F8000003F800000", "0x3F8000003F800000"],
    "XMM1": ["0x4080000040800000", "0x4080000040800000", "0x4080000040800000", "0x4080000040800000"],
    "XMM2": ["0x408000003F800000", "0x4080000040800000", "0x0000000000000000", "0x0000000000000000"],
    "XMM3": ["0x3F8000003E800000", "0x3F8000003F800000", "0x0000000000000000", "0x0000000000000000"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm0, [rdx + 32 * 0]
vmovapd ymm1, [rdx + 32 * 1]

; Register only
vrcpss xmm2, xmm1, xmm0

; Memory operand
vrcpss xmm3, xmm0, [rdx + 32 * 1]

hlt

align 32
.data:
dq 0x3F8000003F800000 ; 1.0
dq 0x3F8000003F800000
dq 0x3F8000003F800000
dq 0x3F8000003F800000

dq 0x4080000040800000 ; 4.0
dq 0x4080000040800000
dq 0x4080000040800000
dq 0x4080000040800000
