/*global define */
/*
 | Copyright 2014 Esri
 |
 | Licensed under the Apache License, Version 2.0 (the "License");
 | you may not use this file except in compliance with the License.
 | You may obtain a copy of the License at
 |
 |    http://www.apache.org/licenses/LICENSE-2.0
 |
 | Unless required by applicable law or agreed to in writing, software
 | distributed under the License is distributed on an "AS IS" BASIS,
 | WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 | See the License for the specific language governing permissions and
 | limitations under the License.
 */
define({
  root: ({
    map: {
      error: "Unable to create map",
      licenseError: {
        message: "Your account is not licensed to use Configurable Apps that are not public. Please ask your organization administrator to assign you a user type that includes Essential Apps or an add-on Essential Apps license.",
        title: "Not Licensed"
      }
    },
    nav: {
      "close": "Close"
    },
    elevation: {
      toggle: "Toggle the Elevation Profile Chart.",
      drawTool: "Draw a line on the map to generate an elevation profile.",
      selectMessage: "Click a line feature or use the draw tool to draw a line to display the elevation profile",
      gainLossTemplate: "Min: ${min}   Max: ${max}   Start: ${start}   End: ${end}   Change: ${gainLoss}"
    },
    splash: {
      title: "Title",
      content: "Configure to create custom splash content"
    },
    legend: {
      title: "Legend",
      tip: "Display legend"
    },
    basemap: {
      title: "Basemap",
      tip: "Change basemap"
    },
    share: {
      title: "Share",
      tip: "Share map"
    }
  }),
  "ar": 1,
  "bs": 1,
  "ca": 1,
  "cs": 1,
  "da": 1,
  "de": 1,
  "el": 1,
  "es": 1,
  "et": 1,
  "fi": 1,
  "fr": 1,
  "he": 1,
  "hi": 1,
  "hr": 1,
  "hu": 1,
  "id": 1,
  "it": 1,
  "ja": 1,
  "ko": 1,
  "lt": 1,
  "lv": 1,
  "nl": 1,
  "nb": 1,
  "pl": 1,
  "pt-br": 1,
  "pt-pt": 1,
  "ro": 1,
  "ru": 1,
  "sl": 1,
  "su": 1,
  "sr": 1,
  "sv": 1,
  "tr": 1,
  "th": 1,
  "vi": 1,
  "zh-cn": 1,
  "zh-hk": 1,
  "zh-tw": 1
});
