# Contributing

Welcome! When contributing to Erutidians' auto-dop, we require you to follow our standards and guidelines before discussing or pushing the changes you wish to make via issues, discussions, and pull requests.

## Getting Started

Before getting started to contributing, please note that we have a [code of conduct](./CODE_OF_CONDUCT.md), please follow it in all your interactions with the project.

### Issues and Discussions

- Starting title should be a one declarative (or interrogative in some cases) sentence. e.g.:

  > Missing the contributing.md that is linked in the readme.md

  However, it should concisely explain what it is about.

- Starting comment should almost always never be empty.

  It is highly recommended for the starting comment to be filled always.

  Only then can it be empty if it has been accurately and concisely addressed in the title, so to avoid redundancy, or else it will be marked as invalid and will be immediately closed.

- Use awesome github markdown formats, if possible and really needed. You can include headers, links, images, basically everything github markdown supports.
- Use our awesome labels! Your issues should labeled properly using the pre-determined labels that fit it best.
- (For Discussions) Use categories that fit it best!
- Last but not the least, remember to follow our [code of conduct](./CODE_OF_CONDUCT.md).

Congratulations! You just submitted us a valued feedback.

### Pull Requests

#### Challengers

Greetings, everyone! Here's how you can enlist yourself as one of our esteemed Challengers that uses our npm package.

1. Navigate to [#challengers](./README.md#challengers).
2. Add yourself at the bottom of the list.

   You can address yourself as either your github display name, github username, or real name, as long as it will be linked to your public repository of the 100 days of productivity.

   > `- [yrnmsk](https://github.com/yrnmsk/100-days-of-productivity)`

3. Save, then Commit as `feat(challenger): add name`:

   > feat(challenger): add yrnmsk

   and submit a pull request, using your same commit message.

#### Issue-related

Note that if you want to push your changes but an issue about it doesn't exist yet, then you have to make that issue first so you can link your pull request to the same issue you just made.

If a pull request made by a contributor is found having no linked issue (or in some rare cases, a discussion) then it will unfortunately be immediately closed.

Closed pull requests due to this reason however can still be reopened as long as it has been linked to an issue.

1. Making your own branch

   It is highly expected that you **fork our repository** and **make your own branch**. You should **never touch** the branches that were already present after forking our repository.

   You can name your branch whatever you want, however, you still need to follow our [code of conduct](./CODE_OF_CONDUCT.md).

2. Making and Commiting your changes

   Your commits should always follow [conventional commits](https://conventionalcommits.org/en/v1.0.0)' expectations and standards. Simple examples are

   > feat(challenger): add yrnmsk

   and

   > chore: update readme

3. Submitting your Pull Request

   Your pull request title should be either simply just the commit message briefly indicating what the changes are mainly about, or an answer to the issue title in a conventional commit's style.

   A simple example of the latter would be:

   if your example issue title is

   > Missing the contributing.md that is linked in the readme.md

   then your example pull request title could be

   > chore: add missing contributing.md in readme.md

4. Waiting for a Review

   Congratulations! You just submitted us a pull request!

   Just a kind reminder that we all have our own valued personal lives outside development stuff, so please always be patient and considerate, and know that we, Erutidians, are currently just a team of three at its core.
