#include <iostream>
#include <vector>

using std::cout;
using std::cerr;
using std::string;
using std::vector;


// Iterator: a pointer-like object that can be incremented with ++, dereferenced with *, and compared against another iterator with !=.
// Iterators are generated by STL container member functions, such as begin() and end().
// Some containers return iterators that support only the above operations, while others return iterators
// that can move forward and backward, be compared with <, and so on.
//
// Iterators are used to separate algorithms and containers.
// An algorithm operates on its data through iterators and knows nothing about the container
// in which the elements are stored.
//
// Conversely, a container knows nothing about the algorithms operating on its elements;
// all it does is to supply iterators upon request (e.g., begin() and end() ).
//
// This model of separation between data storage and algorithm delivers very general and flexible software.
//
// Iterators and standard algorithms work equivalently on every standard container for which their use makes sense.


// find all occurrences of c in s
vector<string::iterator> find_all(string& s, char c) {
    vector<string::iterator> res;
    
    for (auto p = s.begin(); p != s.end(); ++p) {
        if (*p == c) {
            res.push_back(p);
        }
    }
    
    return res;
}


// a silly function just to show the iterations over an iterator
void test() {
    string m {"Mary had a little lamb"};
    
    for (auto p : find_all(m, 'a'))
        if (*p != 'a')
            cerr << "a bug!\n";
}




int main() {
    test();
    
    return 0;
}

