# Versioning

This document describes the versioning policy for this repository.

# TLDR

We follow [Semantic Versioning](https://semver.org/).

# Current Client SDK Versions (v0.x)

We will start our versioning at `v0.x.x`.

Major version zero (0.y.z) is for initial development. Anything may change at any time. The public API should not be considered stable.

# Future Client SDK Versions (v1.x)

SDK versions will follow this structure `<major>.<minor>.<patch>`:

- `major` is incremented for any backwards-incompatible updates made to our [Cloud service / backend](https://cloud.jamaibase.com/) and hence our SDK.
- `minor` or `patch` is incremented for any backwards-compatible feature update, bug fix, enhancements made to the SDK libraries.
