/*
 * Sonar Delphi Plugin
 * Copyright (C) 2015 Fabricio Colombo
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.plugins.delphi;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.sonar.api.issue.Issue;

public class IssueMatchers {

  public static <T extends Issue> Matcher<T> hasRuleKey(String key) {
    return HasRuleKey.hasRuleKey(key);
  }

  public static <T extends Issue> Matcher<T> hasRuleMessage(String message) {
    return HasRuleMessage.hasRuleMessage(message);
  }

  public static <T extends Issue> Matcher<T> hasRuleLine(int line) {
    return HasRuleLineNumber.hasRuleLine(line);
  }

  public static <T extends Issue> Matcher<T> hasRuleKeyAtLine(String key, int line) {
    return Matchers.allOf(HasRuleKey.hasRuleKey(key), hasRuleLine(line));
  }

}
